import{s as rt,n as ot,o as mt}from"../chunks/scheduler.bdbef820.js";import{S as ct,i as dt,g as p,s as n,r,A as ht,h as i,f as s,c as l,j as pt,u as o,x as m,k as it,y as gt,a,v as c,d,t as h,w as g}from"../chunks/index.c0aea24a.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as O,E as ft}from"../chunks/EditOnGithub.725ee0c1.js";function ut(Ye){let u,se,ee,ae,b,ne,j,ze='There are two types of dataset objects, a regular <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and then an ✨ <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> ✨. A <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> provides fast random access to the rows, and memory-mapping so that loading even large datasets only uses a relatively small amount of device memory. But for really, really big datasets that won’t even fit on disk or in memory, an <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> allows you to access and use the dataset without waiting for it to download completely!',le,x,Qe='This tutorial will show you how to load and access a <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',pe,w,ie,$,Le='When you load a dataset split, you’ll get a <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. You can do many things with a <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, which is why it’s important to learn how to manipulate and interact with the data stored inside.',re,y,Pe='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset, but feel free to load any dataset you’d like and follow along!',oe,M,me,v,ce,_,We='A <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> contains columns of data, and each column can be a different type of data. The <em>index</em>, or axis label, is used to access examples from the dataset. For example, indexing by the row returns a dictionary of an example from the dataset:',de,k,he,T,Ne="Use the <code>-</code> operator to start from the end of the dataset:",ge,U,fe,I,Ee="Indexing by the column name returns a list of all the values in the column:",ue,J,be,C,Se="You can combine row and column name indexing to return a specific value at a position:",je,G,xe,R,Ve="But it is important to remember that indexing order matters, especially when working with large audio and image datasets. Indexing by the column name returns all the values in the column first, then loads the value at that position. For large datasets, it may be slower to index by the column name first.",we,Z,$e,D,ye,X,Ae="Slicing returns a slice - or subset - of the dataset, which is useful for viewing several rows at once. To slice a dataset, use the <code>:</code> operator to specify a range of positions.",Me,B,ve,F,_e,q,Ke='An <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is loaded when you set the <code>streaming</code> parameter to <code>True</code> in <a href="/docs/datasets/v3.0.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',ke,H,Te,Y,Oe='You can also create an <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> from an <em>existing</em> <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, but it is faster than streaming mode because the dataset is streamed from local files:',Ue,z,Ie,Q,et='An <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> progressively iterates over a dataset one example at a time, so you don’t have to wait for the whole dataset to download before you can use it. As you can imagine, this is quite useful for large datasets you want to use immediately!',Je,L,tt='However, this means an <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>’s behavior is different from a regular <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>. You don’t get random access to examples in an <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. Instead, you should iterate over its elements, for example, by calling <code>next(iter())</code> or with a <code>for</code> loop to return the next item from the <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Ce,P,Ge,W,st='You can return a subset of the dataset with a specific number of examples in it with <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a>:',Re,N,Ze,E,at='But unlike <a href="access/#slicing">slicing</a>, <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> creates a new <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',De,S,Xe,V,nt='Interested in learning more about the differences between these two types of datasets? Learn more about them in the <a href="about_mapstyle_vs_iterable">Differences between <code>Dataset</code> and <code>IterableDataset</code></a> conceptual guide.',Be,A,lt='To get more hands-on with these datasets types, check out the <a href="process">Process</a> guide to learn how to preprocess a <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or the <a href="stream">Stream</a> guide to learn how to preprocess an <a href="/docs/datasets/v3.0.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Fe,K,qe,te,He;return b=new O({props:{title:"Know your dataset",local:"know-your-dataset",headingTag:"h1"}}),w=new O({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),M=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),v=new O({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),k=new f({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Get the first row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>}`,wrap:!1}}),U=new f({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:`<span class="hljs-comment"># Get the last row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[-<span class="hljs-number">1</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>}`,wrap:!1}}),J=new f({props:{code:"ZGF0YXNldCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;text&quot;</span>]
[<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
 <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
 <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
 ...,
 <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>]`,wrap:!1}}),G=new f({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>`,wrap:!1}}),Z=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXRleHQlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMnRleHQlMjIlNUQlMEFlbmRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBcHJpbnQoZiUyMkVsYXBzZWQlMjB0aW1lJTNBJTIwJTdCZW5kX3RpbWUlMjAtJTIwc3RhcnRfdGltZSUzQS40ZiU3RCUyMHNlY29uZHMlMjIpJTBBJTBBc3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBdGV4dCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCMCU1RCUwQWVuZF90aW1lJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyRWxhcHNlZCUyMHRpbWUlM0ElMjAlN0JlbmRfdGltZSUyMC0lMjBzdGFydF90aW1lJTNBLjRmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0031</span> seconds

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-string">&quot;text&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0094</span> seconds`,wrap:!1}}),D=new O({props:{title:"Slicing",local:"slicing",headingTag:"h3"}}),B=new f({props:{code:"ZGF0YXNldCU1QiUzQTMlNUQlMEElMEFkYXRhc2V0JTVCMyUzQTYlNUQ=",highlighted:`<span class="hljs-comment"># Get the first three rows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
  <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
  <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>]}

<span class="hljs-comment"># Get rows between three and six</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">3</span>:<span class="hljs-number">6</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>,
  <span class="hljs-string">&quot;emerges as something rare , an issue movie that&#x27;s so honest and keenly observed that it doesn&#x27;t feel like one .&quot;</span>,
  <span class="hljs-string">&#x27;the film provides some great insight into the neurotic mindset of all comics -- even those who have reached the absolute top of the game .&#x27;</span>]}`,wrap:!1}}),F=new O({props:{title:"IterableDataset",local:"iterabledataset",headingTag:"h2"}}),H=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F5C520</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),z=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()`,wrap:!1}}),P=new f({props:{code:"bmV4dChpdGVyKGl0ZXJhYmxlX2RhdGFzZXQpKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGl0ZXJhYmxlX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(iterable_dataset))
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F59B50</span>&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DE82B0</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),N=new f({props:{code:"bGlzdChpdGVyYWJsZV9kYXRhc2V0LnRha2UoMykp",highlighted:`<span class="hljs-comment"># Get first three examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(iterable_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DEE9D0</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x512 at <span class="hljs-number">0x7F7479DE8190</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x383 at <span class="hljs-number">0x7F7479DE8310</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}]`,wrap:!1}}),S=new O({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),K=new ft({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/access.mdx"}}),{c(){u=p("meta"),se=n(),ee=p("p"),ae=n(),r(b.$$.fragment),ne=n(),j=p("p"),j.innerHTML=ze,le=n(),x=p("p"),x.innerHTML=Qe,pe=n(),r(w.$$.fragment),ie=n(),$=p("p"),$.innerHTML=Le,re=n(),y=p("p"),y.innerHTML=Pe,oe=n(),r(M.$$.fragment),me=n(),r(v.$$.fragment),ce=n(),_=p("p"),_.innerHTML=We,de=n(),r(k.$$.fragment),he=n(),T=p("p"),T.innerHTML=Ne,ge=n(),r(U.$$.fragment),fe=n(),I=p("p"),I.textContent=Ee,ue=n(),r(J.$$.fragment),be=n(),C=p("p"),C.textContent=Se,je=n(),r(G.$$.fragment),xe=n(),R=p("p"),R.textContent=Ve,we=n(),r(Z.$$.fragment),$e=n(),r(D.$$.fragment),ye=n(),X=p("p"),X.innerHTML=Ae,Me=n(),r(B.$$.fragment),ve=n(),r(F.$$.fragment),_e=n(),q=p("p"),q.innerHTML=Ke,ke=n(),r(H.$$.fragment),Te=n(),Y=p("p"),Y.innerHTML=Oe,Ue=n(),r(z.$$.fragment),Ie=n(),Q=p("p"),Q.innerHTML=et,Je=n(),L=p("p"),L.innerHTML=tt,Ce=n(),r(P.$$.fragment),Ge=n(),W=p("p"),W.innerHTML=st,Re=n(),r(N.$$.fragment),Ze=n(),E=p("p"),E.innerHTML=at,De=n(),r(S.$$.fragment),Xe=n(),V=p("p"),V.innerHTML=nt,Be=n(),A=p("p"),A.innerHTML=lt,Fe=n(),r(K.$$.fragment),qe=n(),te=p("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(s),se=l(e),ee=i(e,"P",{}),pt(ee).forEach(s),ae=l(e),o(b.$$.fragment,e),ne=l(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1sat8vo"&&(j.innerHTML=ze),le=l(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1djdarf"&&(x.innerHTML=Qe),pe=l(e),o(w.$$.fragment,e),ie=l(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1h1ipdt"&&($.innerHTML=Le),re=l(e),y=i(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-jz751l"&&(y.innerHTML=Pe),oe=l(e),o(M.$$.fragment,e),me=l(e),o(v.$$.fragment,e),ce=l(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-tke3uf"&&(_.innerHTML=We),de=l(e),o(k.$$.fragment,e),he=l(e),T=i(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-18jqw8v"&&(T.innerHTML=Ne),ge=l(e),o(U.$$.fragment,e),fe=l(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-18othzs"&&(I.textContent=Ee),ue=l(e),o(J.$$.fragment,e),be=l(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1gzsqvo"&&(C.textContent=Se),je=l(e),o(G.$$.fragment,e),xe=l(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-158alym"&&(R.textContent=Ve),we=l(e),o(Z.$$.fragment,e),$e=l(e),o(D.$$.fragment,e),ye=l(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1gt5d64"&&(X.innerHTML=Ae),Me=l(e),o(B.$$.fragment,e),ve=l(e),o(F.$$.fragment,e),_e=l(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-18qajnt"&&(q.innerHTML=Ke),ke=l(e),o(H.$$.fragment,e),Te=l(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-rrc6el"&&(Y.innerHTML=Oe),Ue=l(e),o(z.$$.fragment,e),Ie=l(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-s6p98"&&(Q.innerHTML=et),Je=l(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-2wx1hb"&&(L.innerHTML=tt),Ce=l(e),o(P.$$.fragment,e),Ge=l(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-13s7j1e"&&(W.innerHTML=st),Re=l(e),o(N.$$.fragment,e),Ze=l(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-10bd549"&&(E.innerHTML=at),De=l(e),o(S.$$.fragment,e),Xe=l(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-51y7bk"&&(V.innerHTML=nt),Be=l(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1khxx9w"&&(A.innerHTML=lt),Fe=l(e),o(K.$$.fragment,e),qe=l(e),te=i(e,"P",{}),pt(te).forEach(s),this.h()},h(){it(u,"name","hf:doc:metadata"),it(u,"content",bt)},m(e,t){gt(document.head,u),a(e,se,t),a(e,ee,t),a(e,ae,t),c(b,e,t),a(e,ne,t),a(e,j,t),a(e,le,t),a(e,x,t),a(e,pe,t),c(w,e,t),a(e,ie,t),a(e,$,t),a(e,re,t),a(e,y,t),a(e,oe,t),c(M,e,t),a(e,me,t),c(v,e,t),a(e,ce,t),a(e,_,t),a(e,de,t),c(k,e,t),a(e,he,t),a(e,T,t),a(e,ge,t),c(U,e,t),a(e,fe,t),a(e,I,t),a(e,ue,t),c(J,e,t),a(e,be,t),a(e,C,t),a(e,je,t),c(G,e,t),a(e,xe,t),a(e,R,t),a(e,we,t),c(Z,e,t),a(e,$e,t),c(D,e,t),a(e,ye,t),a(e,X,t),a(e,Me,t),c(B,e,t),a(e,ve,t),c(F,e,t),a(e,_e,t),a(e,q,t),a(e,ke,t),c(H,e,t),a(e,Te,t),a(e,Y,t),a(e,Ue,t),c(z,e,t),a(e,Ie,t),a(e,Q,t),a(e,Je,t),a(e,L,t),a(e,Ce,t),c(P,e,t),a(e,Ge,t),a(e,W,t),a(e,Re,t),c(N,e,t),a(e,Ze,t),a(e,E,t),a(e,De,t),c(S,e,t),a(e,Xe,t),a(e,V,t),a(e,Be,t),a(e,A,t),a(e,Fe,t),c(K,e,t),a(e,qe,t),a(e,te,t),He=!0},p:ot,i(e){He||(d(b.$$.fragment,e),d(w.$$.fragment,e),d(M.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(K.$$.fragment,e),He=!0)},o(e){h(b.$$.fragment,e),h(w.$$.fragment,e),h(M.$$.fragment,e),h(v.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(J.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(P.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(K.$$.fragment,e),He=!1},d(e){e&&(s(se),s(ee),s(ae),s(ne),s(j),s(le),s(x),s(pe),s(ie),s($),s(re),s(y),s(oe),s(me),s(ce),s(_),s(de),s(he),s(T),s(ge),s(fe),s(I),s(ue),s(be),s(C),s(je),s(xe),s(R),s(we),s($e),s(ye),s(X),s(Me),s(ve),s(_e),s(q),s(ke),s(Te),s(Y),s(Ue),s(Ie),s(Q),s(Je),s(L),s(Ce),s(Ge),s(W),s(Re),s(Ze),s(E),s(De),s(Xe),s(V),s(Be),s(A),s(Fe),s(qe),s(te)),s(u),g(b,e),g(w,e),g(M,e),g(v,e),g(k,e),g(U,e),g(J,e),g(G,e),g(Z,e),g(D,e),g(B,e),g(F,e),g(H,e),g(z,e),g(P,e),g(N,e),g(S,e),g(K,e)}}}const bt='{"title":"Know your dataset","local":"know-your-dataset","sections":[{"title":"Dataset","local":"dataset","sections":[{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Slicing","local":"slicing","sections":[],"depth":3}],"depth":2},{"title":"IterableDataset","local":"iterabledataset","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function jt(Ye){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends ct{constructor(u){super(),dt(this,u,jt,ut,rt,{})}}export{Mt as component};
