import{s as me,n as ge,o as ce}from"../chunks/scheduler.d6170356.js";import{S as we,i as de,g as a,s,r as p,A as ye,h as o,f as i,c as n,j as fe,u as h,x as r,k as et,y as $e,a as l,v as u,d as f,t as m,w as g}from"../chunks/index.fcd4cc08.js";import{C as tt}from"../chunks/CodeBlock.db16bf50.js";import{H as b,E as be}from"../chunks/index.3a2f7ce2.js";function Me(At){let c,st,it,nt,M,at,v,Rt="These next sections highlight features and additional information that you may find useful to make the most out of the Git repositories on the Hugging Face Hub.",ot,T,rt,j,Vt='Hugging Face supports accessing repos with Python via the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> library</a>. The operations that we’ve explored, such as downloading repositories and uploading files, are available through the library, as well as other useful functions!',pt,k,Qt="If you prefer to use git directly, please read the sections below.",ht,H,ut,x,Xt='A good place to visit if you want to continue learning about Git is <a href="https://learngitbranching.js.org/" rel="nofollow">this Git tutorial</a>. For even more background on Git, you can take a look at <a href="https://github.com/git-guides" rel="nofollow">GitHub’s Git Guides</a>.',ft,L,mt,C,qt='To effectively use Git repos collaboratively and to work on features without releasing premature code you can use <strong>branches</strong>. Branches allow you to separate your “work in progress” code from your “production-ready” code, with the additional benefit of letting multiple people work on a project without frequently conflicting with each others’ contributions. You can use branches to isolate experiments in their own branch, and even <a href="https://ericmjl.github.io/essays-on-data-science/workflow/gitflow/" rel="nofollow">adopt team-wide practices for managing branches</a>.',gt,G,Dt='To learn about Git branching, you can try out the <a href="https://learngitbranching.js.org/" rel="nofollow">Learn Git Branching interactive tutorial</a>.',ct,_,wt,Z,Et='Git allows you to <em>tag</em> commits so that you can easily note milestones in your project. As such, you can use tags to mark commits in your Hub repos! To learn about using tags, you can visit <a href="https://devconnected.com/how-to-create-git-tags/" rel="nofollow">this DevConnected post</a>.',dt,W,Ot='Beyond making it easy to identify important commits in your repo’s history, using Git tags also allows you to do A/B testing, <a href="https://www.techiedelight.com/clone-specific-tag-with-git/" rel="nofollow">clone a repository at a specific tag</a>, and more! The <code>huggingface_hub</code> library also supports working with tags, such as <a href="https://huggingface.co/docs/huggingface_hub/main/en/how-to-downstream#hfhuburl" rel="nofollow">downloading files from a specific tagged commit</a>.',yt,J,$t,I,Kt="If you’d like to copy a repository, depending on whether you want to preserve the Git history there are two options.",bt,U,Mt,F,te='In many scenarios, if you want your own copy of a particular codebase you might not be concerned about the previous Git history. In this case, you can quickly duplicate a repo with the handy <a href="https://huggingface.co/spaces/huggingface-projects/repo_duplicator" rel="nofollow">Repo Duplicator</a>! You’ll have to create a User Access Token, which you can read more about in the <a href="./security-tokens">security documentation</a>.',vt,B,Tt,P,ee="A duplicate of a repository with the commit history preserved is called a <em>fork</em>. You may choose to fork one of your own repos, but it also common to fork other people’s projects if you would like to tinker with them.",jt,Y,ie='<strong>Note that you will need to <a href="https://git-lfs.github.com/" rel="nofollow">install Git LFS</a> and the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> CLI</a> to follow this process</strong>. When you want to fork or <a href="https://git-scm.com/docs/git-rebase" rel="nofollow">rebase</a> a repository with LFS files you cannot use the usual Git approach that you might be familiar with since you need to be careful to not break the LFS pointers. Forking can take time depending on your bandwidth because you will have to fetch and re-upload all the LFS files in your fork.',kt,S,le="For example, say you have an upstream repository, <strong>upstream</strong>, and you just created your own repository on the Hub which is <strong>myfork</strong> in this example.",Ht,z,se='<li><p>Create a destination repository (e.g. <strong>myfork</strong>) in <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a></p></li> <li><p>Clone your fork repository:</p></li>',xt,N,Lt,w,ne="<li>Fetch non-LFS files:</li>",Ct,A,Gt,d,ae="<li>Fetch large files. This can take some time depending on your download bandwidth:</li>",_t,R,Zt,V,oe="4.a. If you want to completely override the fork history (which should only have an initial commit), run:",Wt,Q,Jt,X,re="4.b. If you want to rebase instead of overriding, run the following command and resolve any conflicts:",It,q,Ut,y,pe="<li>Prepare your LFS files to push:</li>",Ft,D,Bt,$,he="<li>And finally push:</li>",Pt,E,Yt,O,ue="Now you have your own fork or rebased repo in the Hub!",St,K,zt,lt,Nt;return M=new b({props:{title:"Next Steps",local:"next-steps",headingTag:"h1"}}),T=new b({props:{title:"How to programmatically manage repositories",local:"how-to-programmatically-manage-repositories",headingTag:"h2"}}),H=new b({props:{title:"Learning more about Git",local:"learning-more-about-git",headingTag:"h2"}}),L=new b({props:{title:"How to use branches",local:"how-to-use-branches",headingTag:"h2"}}),_=new b({props:{title:"Using tags",local:"using-tags",headingTag:"h2"}}),J=new b({props:{title:"How to duplicate or fork a repo (including LFS pointers)",local:"how-to-duplicate-or-fork-a-repo-including-lfs-pointers",headingTag:"h2"}}),U=new b({props:{title:"Duplicating without Git history",local:"duplicating-without-git-history",headingTag:"h3"}}),B=new b({props:{title:"Duplicating with the Git history (Fork)",local:"duplicating-with-the-git-history-fork",headingTag:"h3"}}),N=new tt({props:{code:"Z2l0JTIwY2xvbmUlMjBnaXQlNDBoZi5jbyUzQW1lJTJGbXlmb3Jr",highlighted:'git <span class="hljs-keyword">clone</span> <span class="hljs-title">git</span>@hf.co:me/myfork',wrap:!1}}),A=new tt({props:{code:"Y2QlMjBteWZvcmslMEFnaXQlMjBsZnMlMjBpbnN0YWxsJTIwLS1za2lwLXNtdWRnZSUyMC0tbG9jYWwlMjAlMjMlMjBhZmZlY3RzJTIwb25seSUyMHRoaXMlMjBjbG9uZSUwQWdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwZ2l0JTQwaGYuY28lM0FmcmllbmQlMkZ1cHN0cmVhbSUwQWdpdCUyMGZldGNoJTIwdXBzdHJlYW0=",highlighted:`<span class="hljs-built_in">cd</span> myfork
git lfs install --skip-smudge --<span class="hljs-built_in">local</span> <span class="hljs-comment"># affects only this clone</span>
git remote add upstream git@hf.co:friend/upstream
git fetch upstream`,wrap:!1}}),R=new tt({props:{code:"Z2l0JTIwbGZzJTIwZmV0Y2glMjAtLWFsbCUyMHVwc3RyZWFtJTIwJTIzJTIwdGhpcyUyMGNhbiUyMHRha2UlMjB0aW1lJTIwZGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwZG93bmxvYWQlMjBiYW5kd2lkdGg=",highlighted:'<span class="hljs-string">git</span> <span class="hljs-string">lfs</span> <span class="hljs-string">fetch</span> <span class="hljs-built_in">--all</span> <span class="hljs-string">upstream</span> <span class="hljs-comment"># this can take time depending on your download bandwidth</span>',wrap:!1}}),Q=new tt({props:{code:"Z2l0JTIwcmVzZXQlMjAtLWhhcmQlMjB1cHN0cmVhbSUyRm1haW4=",highlighted:'git reset <span class="hljs-attr">--hard</span> upstream/<span class="hljs-selector-tag">main</span>',wrap:!1}}),q=new tt({props:{code:"Z2l0JTIwcmViYXNlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:"git rebase upstream/main",wrap:!1}}),D=new tt({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUyMC0tZm9yY2UlMjAtLWxvY2FsJTIwJTIzJTIwdGhpcyUyMHJlaW5zdGFsbHMlMjB0aGUlMjBMRlMlMjBob29rcyUwQWh1Z2dpbmdmYWNlLWNsaSUyMGxmcy1lbmFibGUtbGFyZ2VmaWxlcyUyMC4lMjAlMjMlMjBuZWVkZWQlMjBpZiUyMHNvbWUlMjBmaWxlcyUyMGFyZSUyMGJpZ2dlciUyMHRoYW4lMjA1R0I=",highlighted:`<span class="hljs-string">git</span> <span class="hljs-string">lfs</span> <span class="hljs-string">install</span> <span class="hljs-built_in">--force</span> <span class="hljs-built_in">--local</span> <span class="hljs-comment"># this reinstalls the LFS hooks</span>
<span class="hljs-string">huggingface-cli</span> <span class="hljs-string">lfs-enable-largefiles</span> . <span class="hljs-comment"># needed if some files are bigger than 5GB</span>`,wrap:!1}}),E=new tt({props:{code:"Z2l0JTIwcHVzaCUyMC0tZm9yY2UlMjBvcmlnaW4lMjBtYWluJTIwJTIzJTIwdGhpcyUyMGNhbiUyMHRha2UlMjB0aW1lJTIwZGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwdXBsb2FkJTIwYmFuZHdpZHRo",highlighted:'git <span class="hljs-keyword">push</span> --<span class="hljs-literal">force</span> origin main <span class="hljs-comment"># this can take time depending on your upload bandwidth</span>',wrap:!1}}),K=new be({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/repositories-next-steps.md"}}),{c(){c=a("meta"),st=s(),it=a("p"),nt=s(),p(M.$$.fragment),at=s(),v=a("p"),v.textContent=Rt,ot=s(),p(T.$$.fragment),rt=s(),j=a("p"),j.innerHTML=Vt,pt=s(),k=a("p"),k.textContent=Qt,ht=s(),p(H.$$.fragment),ut=s(),x=a("p"),x.innerHTML=Xt,ft=s(),p(L.$$.fragment),mt=s(),C=a("p"),C.innerHTML=qt,gt=s(),G=a("p"),G.innerHTML=Dt,ct=s(),p(_.$$.fragment),wt=s(),Z=a("p"),Z.innerHTML=Et,dt=s(),W=a("p"),W.innerHTML=Ot,yt=s(),p(J.$$.fragment),$t=s(),I=a("p"),I.textContent=Kt,bt=s(),p(U.$$.fragment),Mt=s(),F=a("p"),F.innerHTML=te,vt=s(),p(B.$$.fragment),Tt=s(),P=a("p"),P.innerHTML=ee,jt=s(),Y=a("p"),Y.innerHTML=ie,kt=s(),S=a("p"),S.innerHTML=le,Ht=s(),z=a("ol"),z.innerHTML=se,xt=s(),p(N.$$.fragment),Lt=s(),w=a("ol"),w.innerHTML=ne,Ct=s(),p(A.$$.fragment),Gt=s(),d=a("ol"),d.innerHTML=ae,_t=s(),p(R.$$.fragment),Zt=s(),V=a("p"),V.textContent=oe,Wt=s(),p(Q.$$.fragment),Jt=s(),X=a("p"),X.textContent=re,It=s(),p(q.$$.fragment),Ut=s(),y=a("ol"),y.innerHTML=pe,Ft=s(),p(D.$$.fragment),Bt=s(),$=a("ol"),$.innerHTML=he,Pt=s(),p(E.$$.fragment),Yt=s(),O=a("p"),O.textContent=ue,St=s(),p(K.$$.fragment),zt=s(),lt=a("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(i),st=n(t),it=o(t,"P",{}),fe(it).forEach(i),nt=n(t),h(M.$$.fragment,t),at=n(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-btdqel"&&(v.textContent=Rt),ot=n(t),h(T.$$.fragment,t),rt=n(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1jazqdv"&&(j.innerHTML=Vt),pt=n(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-qsyw3y"&&(k.textContent=Qt),ht=n(t),h(H.$$.fragment,t),ut=n(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-164omu7"&&(x.innerHTML=Xt),ft=n(t),h(L.$$.fragment,t),mt=n(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-msdaia"&&(C.innerHTML=qt),gt=n(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-vufusn"&&(G.innerHTML=Dt),ct=n(t),h(_.$$.fragment,t),wt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-23fdx"&&(Z.innerHTML=Et),dt=n(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9rjmgo"&&(W.innerHTML=Ot),yt=n(t),h(J.$$.fragment,t),$t=n(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-o7wddi"&&(I.textContent=Kt),bt=n(t),h(U.$$.fragment,t),Mt=n(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-prc7et"&&(F.innerHTML=te),vt=n(t),h(B.$$.fragment,t),Tt=n(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-16x2jq4"&&(P.innerHTML=ee),jt=n(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1rdylac"&&(Y.innerHTML=ie),kt=n(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-g5hdh6"&&(S.innerHTML=le),Ht=n(t),z=o(t,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-1osxpc3"&&(z.innerHTML=se),xt=n(t),h(N.$$.fragment,t),Lt=n(t),w=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-1g3lxt"&&(w.innerHTML=ne),Ct=n(t),h(A.$$.fragment,t),Gt=n(t),d=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(d)!=="svelte-17yi54j"&&(d.innerHTML=ae),_t=n(t),h(R.$$.fragment,t),Zt=n(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1h5q4od"&&(V.textContent=oe),Wt=n(t),h(Q.$$.fragment,t),Jt=n(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-y11elx"&&(X.textContent=re),It=n(t),h(q.$$.fragment,t),Ut=n(t),y=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-17b7oso"&&(y.innerHTML=pe),Ft=n(t),h(D.$$.fragment,t),Bt=n(t),$=o(t,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-t1bai4"&&($.innerHTML=he),Pt=n(t),h(E.$$.fragment,t),Yt=n(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-60fv4p"&&(O.textContent=ue),St=n(t),h(K.$$.fragment,t),zt=n(t),lt=o(t,"P",{}),fe(lt).forEach(i),this.h()},h(){et(c,"name","hf:doc:metadata"),et(c,"content",ve),et(w,"start","3"),et(d,"start","4"),et(y,"start","5"),et($,"start","6")},m(t,e){$e(document.head,c),l(t,st,e),l(t,it,e),l(t,nt,e),u(M,t,e),l(t,at,e),l(t,v,e),l(t,ot,e),u(T,t,e),l(t,rt,e),l(t,j,e),l(t,pt,e),l(t,k,e),l(t,ht,e),u(H,t,e),l(t,ut,e),l(t,x,e),l(t,ft,e),u(L,t,e),l(t,mt,e),l(t,C,e),l(t,gt,e),l(t,G,e),l(t,ct,e),u(_,t,e),l(t,wt,e),l(t,Z,e),l(t,dt,e),l(t,W,e),l(t,yt,e),u(J,t,e),l(t,$t,e),l(t,I,e),l(t,bt,e),u(U,t,e),l(t,Mt,e),l(t,F,e),l(t,vt,e),u(B,t,e),l(t,Tt,e),l(t,P,e),l(t,jt,e),l(t,Y,e),l(t,kt,e),l(t,S,e),l(t,Ht,e),l(t,z,e),l(t,xt,e),u(N,t,e),l(t,Lt,e),l(t,w,e),l(t,Ct,e),u(A,t,e),l(t,Gt,e),l(t,d,e),l(t,_t,e),u(R,t,e),l(t,Zt,e),l(t,V,e),l(t,Wt,e),u(Q,t,e),l(t,Jt,e),l(t,X,e),l(t,It,e),u(q,t,e),l(t,Ut,e),l(t,y,e),l(t,Ft,e),u(D,t,e),l(t,Bt,e),l(t,$,e),l(t,Pt,e),u(E,t,e),l(t,Yt,e),l(t,O,e),l(t,St,e),u(K,t,e),l(t,zt,e),l(t,lt,e),Nt=!0},p:ge,i(t){Nt||(f(M.$$.fragment,t),f(T.$$.fragment,t),f(H.$$.fragment,t),f(L.$$.fragment,t),f(_.$$.fragment,t),f(J.$$.fragment,t),f(U.$$.fragment,t),f(B.$$.fragment,t),f(N.$$.fragment,t),f(A.$$.fragment,t),f(R.$$.fragment,t),f(Q.$$.fragment,t),f(q.$$.fragment,t),f(D.$$.fragment,t),f(E.$$.fragment,t),f(K.$$.fragment,t),Nt=!0)},o(t){m(M.$$.fragment,t),m(T.$$.fragment,t),m(H.$$.fragment,t),m(L.$$.fragment,t),m(_.$$.fragment,t),m(J.$$.fragment,t),m(U.$$.fragment,t),m(B.$$.fragment,t),m(N.$$.fragment,t),m(A.$$.fragment,t),m(R.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(D.$$.fragment,t),m(E.$$.fragment,t),m(K.$$.fragment,t),Nt=!1},d(t){t&&(i(st),i(it),i(nt),i(at),i(v),i(ot),i(rt),i(j),i(pt),i(k),i(ht),i(ut),i(x),i(ft),i(mt),i(C),i(gt),i(G),i(ct),i(wt),i(Z),i(dt),i(W),i(yt),i($t),i(I),i(bt),i(Mt),i(F),i(vt),i(Tt),i(P),i(jt),i(Y),i(kt),i(S),i(Ht),i(z),i(xt),i(Lt),i(w),i(Ct),i(Gt),i(d),i(_t),i(Zt),i(V),i(Wt),i(Jt),i(X),i(It),i(Ut),i(y),i(Ft),i(Bt),i($),i(Pt),i(Yt),i(O),i(St),i(zt),i(lt)),i(c),g(M,t),g(T,t),g(H,t),g(L,t),g(_,t),g(J,t),g(U,t),g(B,t),g(N,t),g(A,t),g(R,t),g(Q,t),g(q,t),g(D,t),g(E,t),g(K,t)}}}const ve='{"title":"Next Steps","local":"next-steps","sections":[{"title":"How to programmatically manage repositories","local":"how-to-programmatically-manage-repositories","sections":[],"depth":2},{"title":"Learning more about Git","local":"learning-more-about-git","sections":[],"depth":2},{"title":"How to use branches","local":"how-to-use-branches","sections":[],"depth":2},{"title":"Using tags","local":"using-tags","sections":[],"depth":2},{"title":"How to duplicate or fork a repo (including LFS pointers)","local":"how-to-duplicate-or-fork-a-repo-including-lfs-pointers","sections":[{"title":"Duplicating without Git history","local":"duplicating-without-git-history","sections":[],"depth":3},{"title":"Duplicating with the Git history (Fork)","local":"duplicating-with-the-git-history-fork","sections":[],"depth":3}],"depth":2}],"depth":1}';function Te(At){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends we{constructor(c){super(),de(this,c,Te,Me,me,{})}}export{Le as component};
