import{s as ji,n as Di,o as Qi}from"../chunks/scheduler.d6170356.js";import{S as bi,i as Ri,g as a,s,r as M,A as vi,h as T,f as t,c as n,j as Ai,u as p,x as o,k as Ct,y as xi,a as i,v as U,d as y,t as J,w}from"../chunks/index.fcd4cc08.js";import{C as h}from"../chunks/CodeBlock.db16bf50.js";import{H as r,E as Ni}from"../chunks/index.3a2f7ce2.js";function $i(dt){let c,Zl,Ll,Wl,m,zl,u,It="Pickle is a widely used serialization format in ML. Most notably, it is the default format for PyTorch model weights.",Pl,C,Ot='There are dangerous arbitrary code execution attacks that can be perpetrated when you load a pickle file. We suggest loading models from users and organizations you trust, relying on signed commits, and/or loading models from TF or Jax formats with the <code>from_tf=True</code> auto-conversion mechanism. We also alleviate this issue by displaying/“vetting” the list of imports in any pickled file, directly on the Hub. Finally, we are experimenting with a new, simple serialization format for weights called <a href="https://github.com/huggingface/safetensors" rel="nofollow"><code>safetensors</code></a>.',Yl,d,Xl,I,kt='From the <a href="https://docs.python.org/3/library/pickle.html" rel="nofollow">official docs</a> :',ql,O,gt="<p>The <code>pickle</code> module implements binary protocols for serializing and de-serializing a Python object structure.</p>",Kl,k,At="What this means is that pickle is a serializing protocol, something you use to efficiently share data amongst parties.",le,g,jt="We call a pickle the binary file that was generated while pickling.",ee,A,Dt="At its core, the pickle is basically a stack of instructions or opcodes. As you probably have guessed, it’s not human readable. The opcodes are generated when pickling and read sequentially at unpickling. Based on the opcode, a given action is executed.",te,j,Qt="Here’s a small example:",ie,D,se,Q,bt="When you run this, it will create a pickle file and print the following instructions in your terminal:",ne,b,ae,R,Rt='Don’t worry too much about the instructions for now, just know that the <a href="https://docs.python.org/3/library/pickletools.html" rel="nofollow">pickletools</a> module is very useful for analyzing pickles. It allows you to read the instructions in the file <strong><em>without</em></strong> executing any code.',Te,v,vt="Pickle is not simply a serialization protocol, it allows more flexibility by giving the ability to users to run python code at de-serialization time. Doesn’t sound good, does it?",oe,x,Me,N,xt="As we’ve stated above, de-serializing pickle means that code can be executed. But this comes with certain limitations: you can only reference functions and classes from the top level module; you cannot embed them in the pickle file itself.",pe,$,Nt="Back to the drawing board:",Ue,F,ye,V,$t="When we run this script we get the <code>payload.pkl</code> again. When we check the file’s contents:",Je,B,we,_,Ft="We can see that there isn’t much in there, a few opcodes and the associated data. You might be thinking, so what’s the problem with pickle?",re,H,Vt="Let’s try something else:",ce,E,he,G,Bt='Here we’re using the <a href="https://github.com/trailofbits/fickling" rel="nofollow">fickling</a> library for simplicity. It allows us to add pickle instructions to execute code contained in a string via the <code>exec</code> function. This is how you circumvent the fact that you cannot define functions or classes in your pickles: you run exec on python code saved as a string.',fe,L,_t="When you run this, it creates a <code>payload.pkl</code> and prints the following:",me,S,ue,Z,Ht="If we check the contents of the pickle file, we get:",Ce,W,de,z,Et="Basically, this is what’s happening when you unpickle:",Ie,P,Oe,Y,Gt="The instructions that pose a threat are <code>STACK_GLOBAL</code>, <code>GLOBAL</code> and <code>REDUCE</code>.",ke,X,Lt="<code>REDUCE</code> is what tells the unpickler to execute the function with the provided arguments and <code>*GLOBAL</code> instructions are telling the unpickler to <code>import</code> stuff.",ge,q,St="To sum up, pickle is dangerous because:",Ae,K,Zt="<li>when importing a python module, arbitrary code can be executed</li> <li>you can import builtin functions like <code>eval</code> or <code>exec</code>, which can be used to execute arbitrary code</li> <li>when instantiating an object, the constructor may be called</li>",je,ll,Wt="This is why it is stated in most docs using pickle, do not unpickle data from untrusted sources.",De,el,Qe,tl,zt="<strong><em>Don’t use pickle</em></strong>",be,il,Pt="Sound advice Luc, but pickle is used profusely and isn’t going anywhere soon: finding a new format everyone is happy with and initiating the change will take some time.",Re,sl,Yt="So what can we do for now?",ve,nl,xe,al,Xt='On the Hub, you have the ability to <a href="./security-gpg">sign your commits with a GPG key</a>. This does <strong>not</strong> guarantee that your file is safe, but it does guarantee the origin of the file.',Ne,Tl,qt="If you know and trust user A and the commit that includes the file on the Hub is signed by user A’s GPG key, it’s pretty safe to assume that you can trust the file.",$e,ol,Fe,Ml,Kt="TensorFlow and Flax checkpoints are not affected, and can be loaded within PyTorch architectures using the <code>from_tf</code> and <code>from_flax</code> kwargs for the <code>from_pretrained</code> method to circumvent this issue.",Ve,pl,li="E.g.:",Be,Ul,_e,yl,He,Jl,ei='<li><a href="https://msgpack.org/index.html" rel="nofollow">MsgPack</a></li> <li><a href="https://developers.google.com/protocol-buffers" rel="nofollow">Protobuf</a></li> <li><a href="https://capnproto.org/" rel="nofollow">Cap’n’proto</a></li> <li><a href="https://avro.apache.org/" rel="nofollow">Avro</a></li> <li><a href="https://github.com/huggingface/safetensors" rel="nofollow">safetensors</a></li>',Ee,wl,ti="This last format, <code>safetensors</code>, is a simple serialization format that we are working on and experimenting with currently! Please help or contribute if you can 🔥.",Ge,rl,Le,cl,ii='There’s an open discussion in progress at PyTorch on having a <a href="https://github.com/pytorch/pytorch/issues/52181" rel="nofollow">Safe way of loading only weights from *.pt file by default</a> – please chime in there!',Se,hl,Ze,fl,We,ml,si="We have created a security scanner that scans every file pushed to the Hub and runs security checks. At the time of writing, it runs two types of scans:",ze,ul,ni="<li>ClamAV scans</li> <li>Pickle Import scans</li>",Pe,Cl,ai='For ClamAV scans, files are run through the open-source antivirus <a href="https://www.clamav.net" rel="nofollow">ClamAV</a>. While this covers a good amount of dangerous files, it doesn’t cover pickle exploits.',Ye,dl,Ti="We have implemented a Pickle Import scan, which extracts the list of imports referenced in a pickle file. Every time you upload a <code>pytorch_model.bin</code> or any other pickled file, this scan is run.",Xe,Il,oi="On the hub the list of imports will be displayed next to each file containing imports. If any import looks suspicious, it will be highlighted.",qe,f,Mi='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-pickle-imports.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-pickle-imports-dark.png"/>',Ke,Ol,pi='We get this data thanks to <a href="https://docs.python.org/3/library/pickletools.html#pickletools.genops" rel="nofollow"><code>pickletools.genops</code></a> which allows us to read the file without executing potentially dangerous code.',lt,kl,Ui="Note that this is what allows to know if, when unpickling a file, it will <code>REDUCE</code> on a potentially dangerous function that was imported by <code>*GLOBAL</code>.",et,gl,yi=`<strong><em>Disclaimer</em></strong>: this is not 100% foolproof. It is your responsibility as a user to check if something is safe or not. We are not actively auditing python packages for safety, the safe/unsafe imports lists we have are maintained in a best-effort manner.
Please contact us if you think something is not safe, and we flag it as such, by sending us an email to website at huggingface.co`,tt,Al,it,jl,Ji='One could think of creating a custom <a href="https://docs.python.org/3/library/pickle.html#pickle.Unpickler" rel="nofollow">Unpickler</a> in the likes of <a href="https://github.com/facebookresearch/CrypTen/blob/main/crypten/common/serial.py" rel="nofollow">this one</a>. But as we can see in this <a href="https://ctftime.org/writeup/16723" rel="nofollow">sophisticated exploit</a>, this won’t work.',st,Dl,wi="Thankfully, there is always a trace of the <code>eval</code> import, so reading the opcodes directly should allow to catch malicious usage.",nt,Ql,ri="The current solution I propose is creating a file resembling a <code>.gitignore</code> but for imports.",at,bl,ci="This file would be a whitelist of imports that would make a <code>pytorch_model.bin</code> file flagged as dangerous if there are imports not included in the whitelist.",Tt,Rl,hi="One could imagine having a regex-ish format where you could allow all numpy submodules for instance via a simple line like: <code>numpy.*</code>.",ot,vl,Mt,xl,fi='<a href="https://docs.python.org/3/library/pickle.html#what-can-be-pickled-and-unpickled" rel="nofollow">pickle - Python object serialization - Python 3.10.6 documentation</a>',pt,Nl,mi='<a href="https://intoli.com/blog/dangerous-pickles/" rel="nofollow">Dangerous Pickles - Malicious Python Serialization</a>',Ut,$l,ui='<a href="https://github.com/trailofbits/fickling" rel="nofollow">GitHub - trailofbits/fickling: A Python pickling decompiler and static analyzer</a>',yt,Fl,Ci='<a href="https://davidhamann.de/2020/04/05/exploiting-python-pickle/" rel="nofollow">Exploiting Python pickles</a>',Jt,Vl,di='<a href="https://github.com/python/cpython/blob/3.10/Lib/pickletools.py" rel="nofollow">cpython/pickletools.py at 3.10 · python/cpython</a>',wt,Bl,Ii='<a href="https://github.com/python/cpython/blob/3.10/Lib/pickle.py" rel="nofollow">cpython/pickle.py at 3.10 · python/cpython</a>',rt,_l,Oi='<a href="https://github.com/facebookresearch/CrypTen/blob/main/crypten/common/serial.py" rel="nofollow">CrypTen/serial.py at main · facebookresearch/CrypTen</a>',ct,Hl,ki='<a href="https://ctftime.org/writeup/16723" rel="nofollow">CTFtime.org / Balsn CTF 2019 / pyshv1 / Writeup</a>',ht,El,gi='<a href="https://github.com/moreati/pickle-fuzz" rel="nofollow">Rehabilitating Python’s pickle module</a>',ft,Gl,mt,Sl,ut;return m=new r({props:{title:"Pickle Scanning",local:"pickle-scanning",headingTag:"h1"}}),d=new r({props:{title:"What is a pickle?",local:"what-is-a-pickle",headingTag:"h2"}}),D=new h({props:{code:"aW1wb3J0JTIwcGlja2xlJTBBaW1wb3J0JTIwcGlja2xldG9vbHMlMEElMEF2YXIlMjAlM0QlMjAlMjJkYXRhJTIwSSUyMHdhbnQlMjB0byUyMHNoYXJlJTIwd2l0aCUyMGElMjBmcmllbmQlMjIlMEElMEElMjMlMjBzdG9yZSUyMHRoZSUyMHBpY2tsZSUyMGRhdGElMjBpbiUyMGElMjBmaWxlJTIwbmFtZWQlMjAncGF5bG9hZC5wa2wnJTBBd2l0aCUyMG9wZW4oJ3BheWxvYWQucGtsJyUyQyUyMCd3YicpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwcGlja2xlLmR1bXAodmFyJTJDJTIwZiklMEElMEElMjMlMjBkaXNhc3NlbWJsZSUyMHRoZSUyMHBpY2tsZSUwQSUyMyUyMGFuZCUyMHByaW50JTIwdGhlJTIwaW5zdHJ1Y3Rpb25zJTIwdG8lMjB0aGUlMjBjb21tYW5kJTIwbGluZSUwQXdpdGglMjBvcGVuKCdwYXlsb2FkLnBrbCclMkMlMjAncmInKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHBpY2tsZXRvb2xzLmRpcyhmKQ==",highlighted:`<span class="hljs-keyword">import</span> pickle
<span class="hljs-keyword">import</span> pickletools

var = <span class="hljs-string">&quot;data I want to share with a friend&quot;</span>

<span class="hljs-comment"># store the pickle data in a file named &#x27;payload.pkl&#x27;</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickle.dump(var, f)

<span class="hljs-comment"># disassemble the pickle</span>
<span class="hljs-comment"># and print the instructions to the command line</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;rb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickletools.dis(f)`,wrap:!1}}),b=new h({props:{code:"JTIwJTIwJTIwJTIwMCUzQSUyMCU1Q3g4MCUyMFBST1RPJTIwJTIwJTIwJTIwJTIwJTIwNCUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUN4OTUlMjBGUkFNRSUyMCUyMCUyMCUyMCUyMCUyMDQ4JTBBJTIwJTIwJTIwMTElM0ElMjAlNUN4OGMlMjBTSE9SVF9CSU5VTklDT0RFJTIwJ2RhdGElMjBJJTIwd2FudCUyMHRvJTIwc2hhcmUlMjB3aXRoJTIwYSUyMGZyaWVuZCclMEElMjAlMjAlMjA1NyUzQSUyMCU1Q3g5NCUyME1FTU9JWkUlMjAlMjAlMjAlMjAoYXMlMjAwKSUwQSUyMCUyMCUyMDU4JTNBJTIwLiUyMCUyMCUyMCUyMFNUT1AlMEFoaWdoZXN0JTIwcHJvdG9jb2wlMjBhbW9uZyUyMG9wY29kZXMlMjAlM0QlMjA0",highlighted:`    <span class="hljs-number">0</span>: \\x80 PROTO      <span class="hljs-number">4</span>
    <span class="hljs-number">2</span>: \\x95 FRAME      <span class="hljs-number">48</span>
   <span class="hljs-number">11</span>: \\x8c SHORT_BINUNICODE <span class="hljs-string">&#x27;data I want to share with a friend&#x27;</span>
   <span class="hljs-number">57</span>: \\x94 MEMOIZE    (<span class="hljs-keyword">as</span> <span class="hljs-number">0</span>)
   <span class="hljs-number">58</span>: .    STOP
highest protocol among opcodes = <span class="hljs-number">4</span>`,wrap:!1}}),x=new r({props:{title:"Why is it dangerous?",local:"why-is-it-dangerous",headingTag:"h2"}}),F=new h({props:{code:"aW1wb3J0JTIwcGlja2xlJTBBaW1wb3J0JTIwcGlja2xldG9vbHMlMEElMEFjbGFzcyUyMERhdGElM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwaW1wb3J0YW50X3N0dWZmJTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW1wb3J0YW50X3N0dWZmJTIwJTNEJTIwaW1wb3J0YW50X3N0dWZmJTBBJTBBZCUyMCUzRCUyMERhdGEoJTIyNDIlMjIpJTBBJTBBd2l0aCUyMG9wZW4oJ3BheWxvYWQucGtsJyUyQyUyMCd3YicpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwcGlja2xlLmR1bXAoZCUyQyUyMGYp",highlighted:`<span class="hljs-keyword">import</span> pickle
<span class="hljs-keyword">import</span> pickletools

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Data</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, important_stuff: <span class="hljs-built_in">str</span></span>):
        self.important_stuff = important_stuff

d = Data(<span class="hljs-string">&quot;42&quot;</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickle.dump(d, f)`,wrap:!1}}),B=new h({props:{code:"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",highlighted:`
<span class="hljs-comment"># cat payload.pkl</span>
__main__Data)}important_stuff42sb.%

<span class="hljs-comment"># hexyl payload.pkl</span>
┌────────┬─────────────────────────┬─────────────────────────┬────────┬────────┐
│00000000│ 80 04 95 33 00 00 00 00 ┊ 00 00 00 8c 08 5f 5f 6d │×•×30000┊000×•__m│
│00000010│ 61 69 6e 5f 5f 94 8c 04 ┊ 44 61 74 61 94 93 94 29 │ain__××•┊Data×××)│
│00000020│ 81 94 7d 94 8c 0f 69 6d ┊ 70 6f 72 74 61 6e 74 5f │××}××•im┊portant_│
│00000030│ 73 74 75 66 66 94 8c 02 ┊ 34 32 94 73 62 2e       │stuff××•┊42×sb.  │
└────────┴─────────────────────────┴─────────────────────────┴────────┴────────┘`,wrap:!1}}),E=new h({props:{code:"ZnJvbSUyMGZpY2tsaW5nLnBpY2tsZSUyMGltcG9ydCUyMFBpY2tsZWQlMEFpbXBvcnQlMjBwaWNrbGUlMEElMEElMjMlMjBDcmVhdGUlMjBhJTIwbWFsaWNpb3VzJTIwcGlja2xlJTBBZGF0YSUyMCUzRCUyMCUyMm15JTIwZnJpZW5kJTIwbmVlZHMlMjB0byUyMGtub3clMjB0aGlzJTIyJTBBJTBBcGlja2xlX2JpbiUyMCUzRCUyMHBpY2tsZS5kdW1wcyhkYXRhKSUwQSUwQXAlMjAlM0QlMjBQaWNrbGVkLmxvYWQocGlja2xlX2JpbiklMEElMEFwLmluc2VydF9weXRob25fZXhlYygncHJpbnQoJTIyeW91JTVDJ3ZlJTIwYmVlbiUyMHB3bmVkJTIwISUyMiknKSUwQSUwQXdpdGglMjBvcGVuKCdwYXlsb2FkLnBrbCclMkMlMjAnd2InKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHAuZHVtcChmKSUwQSUwQSUyMyUyMGlubm9jZW50bHklMjB1bnBpY2tsZSUyMGFuZCUyMGdldCUyMHlvdXIlMjBmcmllbmQncyUyMGRhdGElMEF3aXRoJTIwb3BlbigncGF5bG9hZC5wa2wnJTJDJTIwJ3JiJyklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcGlja2xlLmxvYWQoZiklMEElMjAlMjAlMjAlMjBwcmludChkYXRhKQ==",highlighted:`<span class="hljs-keyword">from</span> fickling.pickle <span class="hljs-keyword">import</span> Pickled
<span class="hljs-keyword">import</span> pickle

<span class="hljs-comment"># Create a malicious pickle</span>
data = <span class="hljs-string">&quot;my friend needs to know this&quot;</span>

pickle_bin = pickle.dumps(data)

p = Pickled.load(pickle_bin)

p.insert_python_exec(<span class="hljs-string">&#x27;print(&quot;you\\&#x27;ve been pwned !&quot;)&#x27;</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    p.dump(f)

<span class="hljs-comment"># innocently unpickle and get your friend&#x27;s data</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;rb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    data = pickle.load(f)
    <span class="hljs-built_in">print</span>(data)`,wrap:!1}}),S=new h({props:{code:"eW91J3ZlJTIwYmVlbiUyMHB3bmVkJTIwISUwQW15JTIwZnJpZW5kJTIwbmVlZHMlMjB0byUyMGtub3clMjB0aGlz",highlighted:`you<span class="hljs-comment">&#x27;ve been pwned !</span>
my <span class="hljs-keyword">friend</span> needs <span class="hljs-keyword">to</span> know this`,wrap:!1}}),W=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># cat payload.pkl</span>
c__builtin__
<span class="hljs-built_in">exec</span>
(Vprint(<span class="hljs-string">&quot;you&#x27;ve been pwned !&quot;</span>)
tR my friend needs to know this.%

<span class="hljs-comment"># hexyl payload.pkl</span>
┌────────┬─────────────────────────┬─────────────────────────┬────────┬────────┐
│00000000│ 63 5f 5f 62 75 69 6c 74 ┊ 69 6e 5f 5f 0a 65 78 65 │c__built┊in___exe│
│00000010│ 63 0a 28 56 70 72 69 6e ┊ 74 28 22 79 6f 75 27 76 │c_(Vprin┊t(<span class="hljs-string">&quot;you&#x27;v│
│00000020│ 65 20 62 65 65 6e 20 70 ┊ 77 6e 65 64 20 21 22 29 │e been p┊wned !&quot;</span>)│
│00000030│ 0a 74 52 80 04 95 20 00 ┊ 00 00 00 00 00 00 8c 1c │_tR×•× 0┊000000×•│
│00000040│ 6d 79 20 66 72 69 65 6e ┊ 64 20 6e 65 65 64 73 20 │my frien┊d needs │
│00000050│ 74 6f 20 6b 6e 6f 77 20 ┊ 74 68 69 73 94 2e       │to know ┊this×.  │
└────────┴─────────────────────────┴─────────────────────────┴────────┴────────┘`,wrap:!1}}),P=new h({props:{code:"JTIzJTIwLi4uJTBBb3Bjb2Rlc19zdGFjayUyMCUzRCUyMCU1QmV4ZWNfZnVuYyUyQyUyMCUyMm1hbGljaW91cyUyMGFyZ3VtZW50JTIyJTJDJTIwJTIyUkVEVUNFJTIyJTVEJTBBb3Bjb2RlJTIwJTNEJTIwc3RhY2sucG9wKCklMEFpZiUyMG9wY29kZSUyMCUzRCUzRCUyMCUyMlJFRFVDRSUyMiUzQSUwQSUyMCUyMCUyMCUyMGFyZyUyMCUzRCUyMG9wY29kZXNfc3RhY2sucG9wKCklMEElMjAlMjAlMjAlMjBjYWxsYWJsZSUyMCUzRCUyMG9wY29kZXNfc3RhY2sucG9wKCklMEElMjAlMjAlMjAlMjBvcGNvZGVzX3N0YWNrLmFwcGVuZChjYWxsYWJsZShhcmcpKSUwQSUyMyUyMC4uLg==",highlighted:`<span class="hljs-comment"># ...</span>
opcodes_stack = [exec_func, <span class="hljs-string">&quot;malicious argument&quot;</span>, <span class="hljs-string">&quot;REDUCE&quot;</span>]
opcode = stack.pop()
<span class="hljs-keyword">if</span> opcode == <span class="hljs-string">&quot;REDUCE&quot;</span>:
    arg = opcodes_stack.pop()
    <span class="hljs-built_in">callable</span> = opcodes_stack.pop()
    opcodes_stack.append(<span class="hljs-built_in">callable</span>(arg))
<span class="hljs-comment"># ...</span>`,wrap:!1}}),el=new r({props:{title:"Mitigation Strategies",local:"mitigation-strategies",headingTag:"h2"}}),nl=new r({props:{title:"Load files from users and organizations you trust",local:"load-files-from-users-and-organizations-you-trust",headingTag:"h3"}}),ol=new r({props:{title:"Load model weights from TF or Flax",local:"load-model-weights-from-tf-or-flax",headingTag:"h3"}}),Ul=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMGZyb21fZmxheCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, from_flax=<span class="hljs-literal">True</span>)`,wrap:!1}}),yl=new r({props:{title:"Use your own serialization format",local:"use-your-own-serialization-format",headingTag:"h3"}}),rl=new r({props:{title:"Improve torch.load/save",local:"improve-torchloadsave",headingTag:"h3"}}),hl=new r({props:{title:"Hub’s Security Scanner",local:"hubs-security-scanner",headingTag:"h3"}}),fl=new r({props:{title:"What we have now",local:"what-we-have-now",headingTag:"h4"}}),Al=new r({props:{title:"Potential solutions",local:"potential-solutions",headingTag:"h4"}}),vl=new r({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),Gl=new Ni({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/security-pickle.md"}}),{c(){c=a("meta"),Zl=s(),Ll=a("p"),Wl=s(),M(m.$$.fragment),zl=s(),u=a("p"),u.textContent=It,Pl=s(),C=a("p"),C.innerHTML=Ot,Yl=s(),M(d.$$.fragment),Xl=s(),I=a("p"),I.innerHTML=kt,ql=s(),O=a("blockquote"),O.innerHTML=gt,Kl=s(),k=a("p"),k.textContent=At,le=s(),g=a("p"),g.textContent=jt,ee=s(),A=a("p"),A.textContent=Dt,te=s(),j=a("p"),j.textContent=Qt,ie=s(),M(D.$$.fragment),se=s(),Q=a("p"),Q.textContent=bt,ne=s(),M(b.$$.fragment),ae=s(),R=a("p"),R.innerHTML=Rt,Te=s(),v=a("p"),v.textContent=vt,oe=s(),M(x.$$.fragment),Me=s(),N=a("p"),N.textContent=xt,pe=s(),$=a("p"),$.textContent=Nt,Ue=s(),M(F.$$.fragment),ye=s(),V=a("p"),V.innerHTML=$t,Je=s(),M(B.$$.fragment),we=s(),_=a("p"),_.textContent=Ft,re=s(),H=a("p"),H.textContent=Vt,ce=s(),M(E.$$.fragment),he=s(),G=a("p"),G.innerHTML=Bt,fe=s(),L=a("p"),L.innerHTML=_t,me=s(),M(S.$$.fragment),ue=s(),Z=a("p"),Z.textContent=Ht,Ce=s(),M(W.$$.fragment),de=s(),z=a("p"),z.textContent=Et,Ie=s(),M(P.$$.fragment),Oe=s(),Y=a("p"),Y.innerHTML=Gt,ke=s(),X=a("p"),X.innerHTML=Lt,ge=s(),q=a("p"),q.textContent=St,Ae=s(),K=a("ul"),K.innerHTML=Zt,je=s(),ll=a("p"),ll.textContent=Wt,De=s(),M(el.$$.fragment),Qe=s(),tl=a("p"),tl.innerHTML=zt,be=s(),il=a("p"),il.textContent=Pt,Re=s(),sl=a("p"),sl.textContent=Yt,ve=s(),M(nl.$$.fragment),xe=s(),al=a("p"),al.innerHTML=Xt,Ne=s(),Tl=a("p"),Tl.textContent=qt,$e=s(),M(ol.$$.fragment),Fe=s(),Ml=a("p"),Ml.innerHTML=Kt,Ve=s(),pl=a("p"),pl.textContent=li,Be=s(),M(Ul.$$.fragment),_e=s(),M(yl.$$.fragment),He=s(),Jl=a("ul"),Jl.innerHTML=ei,Ee=s(),wl=a("p"),wl.innerHTML=ti,Ge=s(),M(rl.$$.fragment),Le=s(),cl=a("p"),cl.innerHTML=ii,Se=s(),M(hl.$$.fragment),Ze=s(),M(fl.$$.fragment),We=s(),ml=a("p"),ml.textContent=si,ze=s(),ul=a("ul"),ul.innerHTML=ni,Pe=s(),Cl=a("p"),Cl.innerHTML=ai,Ye=s(),dl=a("p"),dl.innerHTML=Ti,Xe=s(),Il=a("p"),Il.textContent=oi,qe=s(),f=a("div"),f.innerHTML=Mi,Ke=s(),Ol=a("p"),Ol.innerHTML=pi,lt=s(),kl=a("p"),kl.innerHTML=Ui,et=s(),gl=a("p"),gl.innerHTML=yi,tt=s(),M(Al.$$.fragment),it=s(),jl=a("p"),jl.innerHTML=Ji,st=s(),Dl=a("p"),Dl.innerHTML=wi,nt=s(),Ql=a("p"),Ql.innerHTML=ri,at=s(),bl=a("p"),bl.innerHTML=ci,Tt=s(),Rl=a("p"),Rl.innerHTML=hi,ot=s(),M(vl.$$.fragment),Mt=s(),xl=a("p"),xl.innerHTML=fi,pt=s(),Nl=a("p"),Nl.innerHTML=mi,Ut=s(),$l=a("p"),$l.innerHTML=ui,yt=s(),Fl=a("p"),Fl.innerHTML=Ci,Jt=s(),Vl=a("p"),Vl.innerHTML=di,wt=s(),Bl=a("p"),Bl.innerHTML=Ii,rt=s(),_l=a("p"),_l.innerHTML=Oi,ct=s(),Hl=a("p"),Hl.innerHTML=ki,ht=s(),El=a("p"),El.innerHTML=gi,ft=s(),M(Gl.$$.fragment),mt=s(),Sl=a("p"),this.h()},l(l){const e=vi("svelte-u9bgzb",document.head);c=T(e,"META",{name:!0,content:!0}),e.forEach(t),Zl=n(l),Ll=T(l,"P",{}),Ai(Ll).forEach(t),Wl=n(l),p(m.$$.fragment,l),zl=n(l),u=T(l,"P",{"data-svelte-h":!0}),o(u)!=="svelte-fqsq33"&&(u.textContent=It),Pl=n(l),C=T(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-a29lns"&&(C.innerHTML=Ot),Yl=n(l),p(d.$$.fragment,l),Xl=n(l),I=T(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-t990cu"&&(I.innerHTML=kt),ql=n(l),O=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(O)!=="svelte-mvgji8"&&(O.innerHTML=gt),Kl=n(l),k=T(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-xlsbn2"&&(k.textContent=At),le=n(l),g=T(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-crw8fq"&&(g.textContent=jt),ee=n(l),A=T(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-903ikp"&&(A.textContent=Dt),te=n(l),j=T(l,"P",{"data-svelte-h":!0}),o(j)!=="svelte-ybkvbq"&&(j.textContent=Qt),ie=n(l),p(D.$$.fragment,l),se=n(l),Q=T(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-dc6jzh"&&(Q.textContent=bt),ne=n(l),p(b.$$.fragment,l),ae=n(l),R=T(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-2o2p4t"&&(R.innerHTML=Rt),Te=n(l),v=T(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1lc08qc"&&(v.textContent=vt),oe=n(l),p(x.$$.fragment,l),Me=n(l),N=T(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-18mv2f5"&&(N.textContent=xt),pe=n(l),$=T(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-qlmkz7"&&($.textContent=Nt),Ue=n(l),p(F.$$.fragment,l),ye=n(l),V=T(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-45qs4"&&(V.innerHTML=$t),Je=n(l),p(B.$$.fragment,l),we=n(l),_=T(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-162o2y5"&&(_.textContent=Ft),re=n(l),H=T(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1cipmup"&&(H.textContent=Vt),ce=n(l),p(E.$$.fragment,l),he=n(l),G=T(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-tiwo6o"&&(G.innerHTML=Bt),fe=n(l),L=T(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-exjbyy"&&(L.innerHTML=_t),me=n(l),p(S.$$.fragment,l),ue=n(l),Z=T(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-f6hcto"&&(Z.textContent=Ht),Ce=n(l),p(W.$$.fragment,l),de=n(l),z=T(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-17mv8nc"&&(z.textContent=Et),Ie=n(l),p(P.$$.fragment,l),Oe=n(l),Y=T(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ywjbrq"&&(Y.innerHTML=Gt),ke=n(l),X=T(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-2a921e"&&(X.innerHTML=Lt),ge=n(l),q=T(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1anxjjv"&&(q.textContent=St),Ae=n(l),K=T(l,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-tgdm9a"&&(K.innerHTML=Zt),je=n(l),ll=T(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-nlb4po"&&(ll.textContent=Wt),De=n(l),p(el.$$.fragment,l),Qe=n(l),tl=T(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-1gahowb"&&(tl.innerHTML=zt),be=n(l),il=T(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1i4ndwq"&&(il.textContent=Pt),Re=n(l),sl=T(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1akd8xr"&&(sl.textContent=Yt),ve=n(l),p(nl.$$.fragment,l),xe=n(l),al=T(l,"P",{"data-svelte-h":!0}),o(al)!=="svelte-18verv9"&&(al.innerHTML=Xt),Ne=n(l),Tl=T(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-xz3ko3"&&(Tl.textContent=qt),$e=n(l),p(ol.$$.fragment,l),Fe=n(l),Ml=T(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-gbqaor"&&(Ml.innerHTML=Kt),Ve=n(l),pl=T(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-oz78gk"&&(pl.textContent=li),Be=n(l),p(Ul.$$.fragment,l),_e=n(l),p(yl.$$.fragment,l),He=n(l),Jl=T(l,"UL",{"data-svelte-h":!0}),o(Jl)!=="svelte-iyr210"&&(Jl.innerHTML=ei),Ee=n(l),wl=T(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-ztaxgy"&&(wl.innerHTML=ti),Ge=n(l),p(rl.$$.fragment,l),Le=n(l),cl=T(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-15ucwe"&&(cl.innerHTML=ii),Se=n(l),p(hl.$$.fragment,l),Ze=n(l),p(fl.$$.fragment,l),We=n(l),ml=T(l,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-65c4de"&&(ml.textContent=si),ze=n(l),ul=T(l,"UL",{"data-svelte-h":!0}),o(ul)!=="svelte-1zxf3f"&&(ul.innerHTML=ni),Pe=n(l),Cl=T(l,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-g06wit"&&(Cl.innerHTML=ai),Ye=n(l),dl=T(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-1hmoht6"&&(dl.innerHTML=Ti),Xe=n(l),Il=T(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-3ixeiy"&&(Il.textContent=oi),qe=n(l),f=T(l,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1skhc0f"&&(f.innerHTML=Mi),Ke=n(l),Ol=T(l,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-wdhs2f"&&(Ol.innerHTML=pi),lt=n(l),kl=T(l,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1bjlcuv"&&(kl.innerHTML=Ui),et=n(l),gl=T(l,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-t5sie"&&(gl.innerHTML=yi),tt=n(l),p(Al.$$.fragment,l),it=n(l),jl=T(l,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-17489ml"&&(jl.innerHTML=Ji),st=n(l),Dl=T(l,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-4971ge"&&(Dl.innerHTML=wi),nt=n(l),Ql=T(l,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-bttwre"&&(Ql.innerHTML=ri),at=n(l),bl=T(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1her4zo"&&(bl.innerHTML=ci),Tt=n(l),Rl=T(l,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-19plnsx"&&(Rl.innerHTML=hi),ot=n(l),p(vl.$$.fragment,l),Mt=n(l),xl=T(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-dshrcb"&&(xl.innerHTML=fi),pt=n(l),Nl=T(l,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-1nbw5zj"&&(Nl.innerHTML=mi),Ut=n(l),$l=T(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1pxtenc"&&($l.innerHTML=ui),yt=n(l),Fl=T(l,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-dgsssn"&&(Fl.innerHTML=Ci),Jt=n(l),Vl=T(l,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-9sknvp"&&(Vl.innerHTML=di),wt=n(l),Bl=T(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-yi9gp3"&&(Bl.innerHTML=Ii),rt=n(l),_l=T(l,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-162i3ur"&&(_l.innerHTML=Oi),ct=n(l),Hl=T(l,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-1uviqpm"&&(Hl.innerHTML=ki),ht=n(l),El=T(l,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1bxqg0w"&&(El.innerHTML=gi),ft=n(l),p(Gl.$$.fragment,l),mt=n(l),Sl=T(l,"P",{}),Ai(Sl).forEach(t),this.h()},h(){Ct(c,"name","hf:doc:metadata"),Ct(c,"content",Fi),Ct(f,"class","flex justify-center")},m(l,e){xi(document.head,c),i(l,Zl,e),i(l,Ll,e),i(l,Wl,e),U(m,l,e),i(l,zl,e),i(l,u,e),i(l,Pl,e),i(l,C,e),i(l,Yl,e),U(d,l,e),i(l,Xl,e),i(l,I,e),i(l,ql,e),i(l,O,e),i(l,Kl,e),i(l,k,e),i(l,le,e),i(l,g,e),i(l,ee,e),i(l,A,e),i(l,te,e),i(l,j,e),i(l,ie,e),U(D,l,e),i(l,se,e),i(l,Q,e),i(l,ne,e),U(b,l,e),i(l,ae,e),i(l,R,e),i(l,Te,e),i(l,v,e),i(l,oe,e),U(x,l,e),i(l,Me,e),i(l,N,e),i(l,pe,e),i(l,$,e),i(l,Ue,e),U(F,l,e),i(l,ye,e),i(l,V,e),i(l,Je,e),U(B,l,e),i(l,we,e),i(l,_,e),i(l,re,e),i(l,H,e),i(l,ce,e),U(E,l,e),i(l,he,e),i(l,G,e),i(l,fe,e),i(l,L,e),i(l,me,e),U(S,l,e),i(l,ue,e),i(l,Z,e),i(l,Ce,e),U(W,l,e),i(l,de,e),i(l,z,e),i(l,Ie,e),U(P,l,e),i(l,Oe,e),i(l,Y,e),i(l,ke,e),i(l,X,e),i(l,ge,e),i(l,q,e),i(l,Ae,e),i(l,K,e),i(l,je,e),i(l,ll,e),i(l,De,e),U(el,l,e),i(l,Qe,e),i(l,tl,e),i(l,be,e),i(l,il,e),i(l,Re,e),i(l,sl,e),i(l,ve,e),U(nl,l,e),i(l,xe,e),i(l,al,e),i(l,Ne,e),i(l,Tl,e),i(l,$e,e),U(ol,l,e),i(l,Fe,e),i(l,Ml,e),i(l,Ve,e),i(l,pl,e),i(l,Be,e),U(Ul,l,e),i(l,_e,e),U(yl,l,e),i(l,He,e),i(l,Jl,e),i(l,Ee,e),i(l,wl,e),i(l,Ge,e),U(rl,l,e),i(l,Le,e),i(l,cl,e),i(l,Se,e),U(hl,l,e),i(l,Ze,e),U(fl,l,e),i(l,We,e),i(l,ml,e),i(l,ze,e),i(l,ul,e),i(l,Pe,e),i(l,Cl,e),i(l,Ye,e),i(l,dl,e),i(l,Xe,e),i(l,Il,e),i(l,qe,e),i(l,f,e),i(l,Ke,e),i(l,Ol,e),i(l,lt,e),i(l,kl,e),i(l,et,e),i(l,gl,e),i(l,tt,e),U(Al,l,e),i(l,it,e),i(l,jl,e),i(l,st,e),i(l,Dl,e),i(l,nt,e),i(l,Ql,e),i(l,at,e),i(l,bl,e),i(l,Tt,e),i(l,Rl,e),i(l,ot,e),U(vl,l,e),i(l,Mt,e),i(l,xl,e),i(l,pt,e),i(l,Nl,e),i(l,Ut,e),i(l,$l,e),i(l,yt,e),i(l,Fl,e),i(l,Jt,e),i(l,Vl,e),i(l,wt,e),i(l,Bl,e),i(l,rt,e),i(l,_l,e),i(l,ct,e),i(l,Hl,e),i(l,ht,e),i(l,El,e),i(l,ft,e),U(Gl,l,e),i(l,mt,e),i(l,Sl,e),ut=!0},p:Di,i(l){ut||(y(m.$$.fragment,l),y(d.$$.fragment,l),y(D.$$.fragment,l),y(b.$$.fragment,l),y(x.$$.fragment,l),y(F.$$.fragment,l),y(B.$$.fragment,l),y(E.$$.fragment,l),y(S.$$.fragment,l),y(W.$$.fragment,l),y(P.$$.fragment,l),y(el.$$.fragment,l),y(nl.$$.fragment,l),y(ol.$$.fragment,l),y(Ul.$$.fragment,l),y(yl.$$.fragment,l),y(rl.$$.fragment,l),y(hl.$$.fragment,l),y(fl.$$.fragment,l),y(Al.$$.fragment,l),y(vl.$$.fragment,l),y(Gl.$$.fragment,l),ut=!0)},o(l){J(m.$$.fragment,l),J(d.$$.fragment,l),J(D.$$.fragment,l),J(b.$$.fragment,l),J(x.$$.fragment,l),J(F.$$.fragment,l),J(B.$$.fragment,l),J(E.$$.fragment,l),J(S.$$.fragment,l),J(W.$$.fragment,l),J(P.$$.fragment,l),J(el.$$.fragment,l),J(nl.$$.fragment,l),J(ol.$$.fragment,l),J(Ul.$$.fragment,l),J(yl.$$.fragment,l),J(rl.$$.fragment,l),J(hl.$$.fragment,l),J(fl.$$.fragment,l),J(Al.$$.fragment,l),J(vl.$$.fragment,l),J(Gl.$$.fragment,l),ut=!1},d(l){l&&(t(Zl),t(Ll),t(Wl),t(zl),t(u),t(Pl),t(C),t(Yl),t(Xl),t(I),t(ql),t(O),t(Kl),t(k),t(le),t(g),t(ee),t(A),t(te),t(j),t(ie),t(se),t(Q),t(ne),t(ae),t(R),t(Te),t(v),t(oe),t(Me),t(N),t(pe),t($),t(Ue),t(ye),t(V),t(Je),t(we),t(_),t(re),t(H),t(ce),t(he),t(G),t(fe),t(L),t(me),t(ue),t(Z),t(Ce),t(de),t(z),t(Ie),t(Oe),t(Y),t(ke),t(X),t(ge),t(q),t(Ae),t(K),t(je),t(ll),t(De),t(Qe),t(tl),t(be),t(il),t(Re),t(sl),t(ve),t(xe),t(al),t(Ne),t(Tl),t($e),t(Fe),t(Ml),t(Ve),t(pl),t(Be),t(_e),t(He),t(Jl),t(Ee),t(wl),t(Ge),t(Le),t(cl),t(Se),t(Ze),t(We),t(ml),t(ze),t(ul),t(Pe),t(Cl),t(Ye),t(dl),t(Xe),t(Il),t(qe),t(f),t(Ke),t(Ol),t(lt),t(kl),t(et),t(gl),t(tt),t(it),t(jl),t(st),t(Dl),t(nt),t(Ql),t(at),t(bl),t(Tt),t(Rl),t(ot),t(Mt),t(xl),t(pt),t(Nl),t(Ut),t($l),t(yt),t(Fl),t(Jt),t(Vl),t(wt),t(Bl),t(rt),t(_l),t(ct),t(Hl),t(ht),t(El),t(ft),t(mt),t(Sl)),t(c),w(m,l),w(d,l),w(D,l),w(b,l),w(x,l),w(F,l),w(B,l),w(E,l),w(S,l),w(W,l),w(P,l),w(el,l),w(nl,l),w(ol,l),w(Ul,l),w(yl,l),w(rl,l),w(hl,l),w(fl,l),w(Al,l),w(vl,l),w(Gl,l)}}}const Fi='{"title":"Pickle Scanning","local":"pickle-scanning","sections":[{"title":"What is a pickle?","local":"what-is-a-pickle","sections":[],"depth":2},{"title":"Why is it dangerous?","local":"why-is-it-dangerous","sections":[],"depth":2},{"title":"Mitigation Strategies","local":"mitigation-strategies","sections":[{"title":"Load files from users and organizations you trust","local":"load-files-from-users-and-organizations-you-trust","sections":[],"depth":3},{"title":"Load model weights from TF or Flax","local":"load-model-weights-from-tf-or-flax","sections":[],"depth":3},{"title":"Use your own serialization format","local":"use-your-own-serialization-format","sections":[],"depth":3},{"title":"Improve torch.load/save","local":"improve-torchloadsave","sections":[],"depth":3},{"title":"Hub’s Security Scanner","local":"hubs-security-scanner","sections":[{"title":"What we have now","local":"what-we-have-now","sections":[],"depth":4},{"title":"Potential solutions","local":"potential-solutions","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Vi(dt){return Qi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gi extends bi{constructor(c){super(),Ri(this,c,Vi,$i,ji,{})}}export{Gi as component};
