import{s as bt,n as kt,o as Bt}from"../chunks/scheduler.d6170356.js";import{S as $t,i as vt,g as p,s as a,r as c,A as Zt,h as i,f as t,c as n,j as It,u as r,x as o,k as T,y as Rt,a as l,v as h,d as u,t as M,w as d}from"../chunks/index.fcd4cc08.js";import{C as m}from"../chunks/CodeBlock.db16bf50.js";import{H as g,E as Ct}from"../chunks/index.3a2f7ce2.js";function Vt(Ae){let j,vs,Bs,Zs,v,Rs,Z,Xe='In the following sections, you’ll learn the basics of creating a Docker Space, configuring it, and deploying your code to it. We’ll create a <strong>Text Generation</strong> Space with Docker that’ll be used to demo the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model, which can generate text given some input text, using FastAPI as the server.',Cs,R,We='You can find a completed version of this hosted <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">here</a>.',Vs,C,Gs,V,Qe='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Docker</strong> as our SDK.',Ls,w,_e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface.co_new-space_docker.jpg"/>',Hs,G,Ne='Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing. If you prefer to work with a UI, you can also do the work directly in the browser.',Es,L,ze='Selecting <strong>Docker</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Docker Space by setting the <code>sdk</code> property to <code>docker</code> in your <code>README.md</code> file’s YAML block.',xs,H,Ss,E,qe="You have the option to change the default application port of your Space by setting the <code>app_port</code> property in your <code>README.md</code> file’s YAML block. The default port is <code>7860</code>.",As,x,Xs,S,Ws,A,Fe='For the <strong>Text Generation</strong> Space, we’ll be building a FastAPI app that showcases a text generation model called Flan T5. For the model inference, we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model. We need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',Qs,X,_s,W,Ye="These dependencies will be installed in the Dockerfile we’ll create later.",Ns,Q,zs,_,De="Let’s kick off the process with a dummy FastAPI app to see that we can get an endpoint working. The first step is to create an app file, in this case, we’ll call it <code>main.py</code>.",qs,N,Fs,z,Ys,q,Pe='The main step for a Docker Space is creating a Dockerfile. You can read more about Dockerfiles <a href="https://docs.docker.com/get-started/" rel="nofollow">here</a>. Although we’re using FastAPI in this tutorial, Dockerfiles give great flexibility to users allowing you to build a new generation of ML demos. Let’s write the Dockerfile for our application',Ds,F,Ps,Y,Oe='When the changes are saved, the Space will rebuild and your demo should be up after a couple of seconds! <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_dummy" rel="nofollow">Here</a> is an example result at this point.',Os,y,Ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_dummy.jpg"/>',Ks,D,se,P,st="<strong>Tip for power users (you can skip):</strong> If you’re developing locally, this is a good moment in which you can do <code>docker build</code> and <code>docker run</code> to debug locally, but it’s even easier to push the changes to the Hub and see how it looks like!",ee,O,te,K,et='If you have <a href="spaces-sdks-docker#secret-management">Secrets</a> you can use <code>docker buildx</code> and pass the secrets as build arguments',le,ss,ae,es,tt="and run with <code>docker run</code> passing the secrets as environment variables",ne,ts,pe,ls,ie,as,lt="As mentioned before, the idea is to use a Flan T5 model for text generation. We’ll want to add some HTML and CSS for an input field, so let’s create a directory called static with <code>index.html</code>, <code>style.css</code>, and <code>script.js</code> files. At this moment, your file structure should look like this:",oe,ns,ce,ps,at='Let’s go through all the steps to make this working. We’ll skip some of the details of the CSS and HTML. You can find the whole code in the Files and versions tab of the <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> Space.',re,is,nt="<li>Write the FastAPI endpoint to do inference</li>",he,os,pt='We’ll use the <code>pipeline</code> from <code>transformers</code> to load the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model. We’ll set an endpoint called <code>infer_t5</code> that receives and input and outputs the result of the inference call',ue,cs,Me,f,it="<li>Write the <code>index.html</code> to have a simple form containing the code of the page.</li>",de,rs,me,J,ot="<li>In the <code>main.py</code> file, mount the static files and show the html file in the root route</li>",Te,hs,je,U,ct="<li>In the <code>script.js</code> file, make it handle the request</li>",ge,us,we,I,rt="<li>Grant permissions to the right directories</li>",ye,Ms,ht='As discussed in the <a href="./spaces-sdks-docker#permissions">Permissions Section</a>, the container runs with user ID 1000. That means that the Space might face permission issues. For example, <code>transformers</code> downloads and caches the models in the path under the <code>HF_HOME</code> path. The easiest way to solve this is to create a user with righ permissions and use it to run the container application. We can do this by adding the following lines to the <code>Dockerfile</code>.',fe,ds,Je,ms,ut="The final <code>Dockerfile</code> should look like this:",Ue,Ts,Ie,js,Mt='Success! Your app should be working now! Check out <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> to see the final result.',be,b,dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5.jpg"/>',ke,gs,mt='What a journey! Please remember that Docker Spaces give you lots of freedom, so you’re not limited to use FastAPI. From a <a href="https://huggingface.co/spaces/DockerTemplates/test-docker-go" rel="nofollow">Go Endpoint</a> to a <a href="https://huggingface.co/spaces/DockerTemplates/shiny-with-python" rel="nofollow">Shiny App</a>, the limit is the moon! Check out <a href="./spaces-sdks-docker-examples">some official examples</a>. You can also upgrade your Space to a GPU if needed 😃',Be,ws,$e,ys,Tt="You can debug your Space by checking the <strong>Build</strong> and <strong>Container</strong> logs. Click on the <strong>Open Logs</strong> button to open the modal.",ve,k,jt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_3.jpg"/>',Ze,fs,gt="If everything went well, you will see <code>Pushing Image</code> and <code>Scheduling Space</code> on the <strong>Build</strong> tab",Re,B,wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_1.jpg"/>',Ce,Js,yt="On the <strong>Container</strong> tab, you will see the application status, in this case, <code>Uvicorn running on http://0.0.0.0:7860</code>",Ve,$,ft='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_2.jpg"/>',Ge,Us,Jt='Additionally, you can enable the Dev Mode on your Space. The Dev Mode allows you to connect to your running Space via VSCode or SSH. Learn more here: <a href="https://huggingface.co/dev-mode-explorers" rel="nofollow">https://huggingface.co/dev-mode-explorers</a>',Le,Is,He,bs,Ut='<li><a href="spaces-sdks-docker">Docker Spaces</a></li> <li><a href="spaces-sdks-docker-examples">List of Docker Spaces examples</a></li>',Ee,ks,xe,$s,Se;return v=new g({props:{title:"Your First Docker Space: Text Generation with T5",local:"your-first-docker-space-text-generation-with-t5",headingTag:"h1"}}),C=new g({props:{title:"Create a new Docker Space",local:"create-a-new-docker-space",headingTag:"h2"}}),H=new m({props:{code:"c2RrJTNBJTIwZG9ja2Vy",highlighted:'<span class="hljs-attr">sdk:</span> <span class="hljs-string">docker</span>',wrap:!1}}),x=new m({props:{code:"YXBwX3BvcnQlM0ElMjA3ODYw",highlighted:'<span class="hljs-attr">app_port:</span> <span class="hljs-number">7860</span>',wrap:!1}}),S=new g({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),X=new m({props:{code:"ZmFzdGFwaSUzRCUzRDAuNzQuKiUwQXJlcXVlc3RzJTNEJTNEMi4yNy4qJTBBc2VudGVuY2VwaWVjZSUzRCUzRDAuMS4qJTBBdG9yY2glM0QlM0QxLjExLiolMEF0cmFuc2Zvcm1lcnMlM0QlM0Q0LiolMEF1dmljb3JuJTVCc3RhbmRhcmQlNUQlM0QlM0QwLjE3Lio=",highlighted:`<span class="hljs-attribute">fastapi</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.74</span>.*
<span class="hljs-attribute">requests</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">2.27</span>.*
<span class="hljs-attribute">sentencepiece</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.1</span>.*
<span class="hljs-attribute">torch</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">1.11</span>.*
<span class="hljs-attribute">transformers</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">4</span>.*
uvicorn[standard]<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.17</span>.*`,wrap:!1}}),Q=new g({props:{title:"Create the app",local:"create-the-app",headingTag:"h2"}}),N=new m({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBYXBwJTIwJTNEJTIwRmFzdEFQSSgpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwcmVhZF9yb290KCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJIZWxsbyUyMiUzQSUyMCUyMldvcmxkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_root</span>():
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;Hello&quot;</span>: <span class="hljs-string">&quot;World!&quot;</span>}`,wrap:!1}}),z=new g({props:{title:"Create the Dockerfile",local:"create-the-dockerfile",headingTag:"h2"}}),F=new m({props:{code:"JTIzJTIwcmVhZCUyMHRoZSUyMGRvYyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc3BhY2VzLXNka3MtZG9ja2VyJTBBJTIzJTIweW91JTIwd2lsbCUyMGFsc28lMjBmaW5kJTIwZ3VpZGVzJTIwb24lMjBob3clMjBiZXN0JTIwdG8lMjB3cml0ZSUyMHlvdXIlMjBEb2NrZXJmaWxlJTBBJTBBRlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQSUyMyUyMFRoZSUyMHR3byUyMGZvbGxvd2luZyUyMGxpbmVzJTIwYXJlJTIwcmVxdWlyZW1lbnRzJTIwZm9yJTIwdGhlJTIwRGV2JTIwTW9kZSUyMHRvJTIwYmUlMjBmdW5jdGlvbmFsJTBBJTIzJTIwTGVhcm4lMjBtb3JlJTIwYWJvdXQlMjB0aGUlMjBEZXYlMjBNb2RlJTIwYXQlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGV2LW1vZGUtZXhwbG9yZXJzJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQVdPUktESVIlMjAlMkZhcHAlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTJGcmVxdWlyZW1lbnRzLnR4dCUyMHJlcXVpcmVtZW50cy50eHQlMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMHJlcXVpcmVtZW50cy50eHQlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTIwJTJGYXBwJTBBQ01EJTIwJTVCJTIydXZpY29ybiUyMiUyQyUyMCUyMm1haW4lM0FhcHAlMjIlMkMlMjAlMjItLWhvc3QlMjIlMkMlMjAlMjIwLjAuMC4wJTIyJTJDJTIwJTIyLS1wb3J0JTIyJTJDJTIwJTIyNzg2MCUyMiU1RCUwQQ==",highlighted:`<span class="hljs-comment"># read the doc: https://huggingface.co/docs/hub/spaces-sdks-docker</span>
<span class="hljs-comment"># you will also find guides on how best to write your Dockerfile</span>

<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-comment"># The two following lines are requirements for the Dev Mode to be functional</span>
<span class="hljs-comment"># Learn more about the Dev Mode at https://huggingface.co/dev-mode-explorers</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user ./requirements.txt requirements.txt</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r requirements.txt</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . /app</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>
`,wrap:!1}}),D=new g({props:{title:"Testing locally",local:"testing-locally",headingTag:"h3"}}),O=new m({props:{code:"ZG9ja2VyJTIwYnVpbGQlMjAtdCUyMGZhc3RhcGklMjAuJTBBZG9ja2VyJTIwcnVuJTIwJTIwLWl0JTIwLXAlMjA3ODYwJTNBNzg2MCUyMGZhc3RhcGk=",highlighted:`docker build -t fastapi .
docker run  -it -p 7860:7860 fastapi`,wrap:!1}}),ss=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBidWlsZHglMjBidWlsZCUyMC0tc2VjcmV0JTIwaWQlM0RTRUNSRVRfRVhBTVBMRSUyQ2VudiUzRFNFQ1JFVF9FWEFNUExFJTIwLXQlMjBmYXN0YXBpJTIwLg==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker buildx build --secret <span class="hljs-built_in">id</span>=SECRET_EXAMPLE,<span class="hljs-built_in">env</span>=SECRET_EXAMPLE -t fastapi .`,wrap:!1}}),ts=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBydW4lMjAtaXQlMjAtcCUyMDc4NjAlM0E3ODYwJTIwLWUlMjBTRUNSRVRfRVhBTVBMRSUzRCUyNFNFQ1JFVF9FWEFNUExFJTIwZmFzdGFwaQ==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker run -it -p 7860:7860 -e SECRET_EXAMPLE=<span class="hljs-variable">$SECRET_EXAMPLE</span> fastapi`,wrap:!1}}),ls=new g({props:{title:"Adding some ML to our app",local:"adding-some-ml-to-our-app",headingTag:"h2"}}),ns=new m({props:{code:"JTJGc3RhdGljJTBBJTJGc3RhdGljJTJGaW5kZXguaHRtbCUwQSUyRnN0YXRpYyUyRnNjcmlwdC5qcyUwQSUyRnN0YXRpYyUyRnN0eWxlLmNzcyUwQURvY2tlcmZpbGUlMEFtYWluLnB5JTBBUkVBRE1FLm1kJTBBcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`/static
/static/index.html
/static/script.js
/static/style.css
Dockerfile
main.py
README.md
requirements.txt`,wrap:!1}}),cs=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZV9mbGFuJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dDJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkZpbmZlcl90NSUyMiklMEFkZWYlMjB0NShpbnB1dCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBwaXBlX2ZsYW4oaW5wdXQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyb3V0cHV0JTIyJTNBJTIwb3V0cHV0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe_flan = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model=<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/infer_t5&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">t5</span>(<span class="hljs-params"><span class="hljs-built_in">input</span></span>):
    output = pipe_flan(<span class="hljs-built_in">input</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;output&quot;</span>: output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]}`,wrap:!1}}),rs=new m({props:{code:"JTNDbWFpbiUzRSUwQSUyMCUyMCUzQ3NlY3Rpb24lMjBpZCUzRCUyMnRleHQtZ2VuJTIyJTNFJTBBJTIwJTIwJTIwJTIwJTNDaDIlM0VUZXh0JTIwZ2VuZXJhdGlvbiUyMHVzaW5nJTIwRmxhbiUyMFQ1JTNDJTJGaDIlM0UlMEElMjAlMjAlMjAlMjAlM0NwJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwTW9kZWwlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NhJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHJlZiUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVsJTNEJTIybm9yZWZlcnJlciUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCUzRCUyMl9ibGFuayUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRWdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0MlMkZhJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGcCUzRSUwQSUyMCUyMCUyMCUyMCUzQ2Zvcm0lMjBjbGFzcyUzRCUyMnRleHQtZ2VuLWZvcm0lMjIlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NsYWJlbCUyMGZvciUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTNFVGV4dCUyMHByb21wdCUzQyUyRmxhYmVsJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDaW5wdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZSUzRCUyMkdlcm1hbiUzQSUyMFRoZXJlJTIwYXJlJTIwbWFueSUyMGR1Y2tzJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDYnV0dG9uJTIwaWQlM0QlMjJ0ZXh0LWdlbi1zdWJtaXQlMjIlM0VTdWJtaXQlM0MlMkZidXR0b24lM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NwJTIwY2xhc3MlM0QlMjJ0ZXh0LWdlbi1vdXRwdXQlMjIlM0UlM0MlMkZwJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGZm9ybSUzRSUwQSUyMCUyMCUzQyUyRnNlY3Rpb24lM0UlMEElM0MlMkZtYWluJTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">main</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">section</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h2</span>&gt;</span>Text generation using Flan T5<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">p</span>&gt;</span>
      Model:
      <span class="hljs-tag">&lt;<span class="hljs-name">a</span>
        <span class="hljs-attr">href</span>=<span class="hljs-string">&quot;https://huggingface.co/google/flan-t5-small&quot;</span>
        <span class="hljs-attr">rel</span>=<span class="hljs-string">&quot;noreferrer&quot;</span>
        <span class="hljs-attr">target</span>=<span class="hljs-string">&quot;_blank&quot;</span>
        &gt;</span>google/flan-t5-small
      <span class="hljs-tag">&lt;/<span class="hljs-name">a</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">form</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-form&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">label</span> <span class="hljs-attr">for</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>&gt;</span>Text prompt<span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">input</span>
        <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>
        <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
        <span class="hljs-attr">value</span>=<span class="hljs-string">&quot;German: There are many ducks&quot;</span>
      /&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-submit&quot;</span>&gt;</span>Submit<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">p</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-output&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">form</span>&gt;</span>
  <span class="hljs-tag">&lt;/<span class="hljs-name">section</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span>`,wrap:!1}}),hs=new m({props:{code:"YXBwLm1vdW50KCUyMiUyRiUyMiUyQyUyMFN0YXRpY0ZpbGVzKGRpcmVjdG9yeSUzRCUyMnN0YXRpYyUyMiUyQyUyMGh0bWwlM0RUcnVlKSUyQyUyMG5hbWUlM0QlMjJzdGF0aWMlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwaW5kZXgoKSUyMC0lM0UlMjBGaWxlUmVzcG9uc2UlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBGaWxlUmVzcG9uc2UocGF0aCUzRCUyMiUyRmFwcCUyRnN0YXRpYyUyRmluZGV4Lmh0bWwlMjIlMkMlMjBtZWRpYV90eXBlJTNEJTIydGV4dCUyRmh0bWwlMjIp",highlighted:`app.mount(<span class="hljs-string">&quot;/&quot;</span>, StaticFiles(directory=<span class="hljs-string">&quot;static&quot;</span>, html=<span class="hljs-literal">True</span>), name=<span class="hljs-string">&quot;static&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">index</span>() -&gt; FileResponse:
    <span class="hljs-keyword">return</span> FileResponse(path=<span class="hljs-string">&quot;/app/static/index.html&quot;</span>, media_type=<span class="hljs-string">&quot;text/html&quot;</span>)`,wrap:!1}}),us=new m({props:{code:"Y29uc3QlMjB0ZXh0R2VuRm9ybSUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLWZvcm0lMjIpJTNCJTBBJTBBY29uc3QlMjB0cmFuc2xhdGVUZXh0JTIwJTNEJTIwYXN5bmMlMjAodGV4dCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjBjb25zdCUyMGluZmVyUmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGZldGNoKCU2MGluZmVyX3Q1JTNGaW5wdXQlM0QlMjQlN0J0ZXh0JTdEJTYwKSUzQiUwQSUyMCUyMGNvbnN0JTIwaW5mZXJKc29uJTIwJTNEJTIwYXdhaXQlMjBpbmZlclJlc3BvbnNlLmpzb24oKSUzQiUwQSUwQSUyMCUyMHJldHVybiUyMGluZmVySnNvbi5vdXRwdXQlM0IlMEElN0QlM0IlMEElMEF0ZXh0R2VuRm9ybS5hZGRFdmVudExpc3RlbmVyKCUyMnN1Ym1pdCUyMiUyQyUyMGFzeW5jJTIwKGV2ZW50KSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMGV2ZW50LnByZXZlbnREZWZhdWx0KCklM0IlMEElMEElMjAlMjBjb25zdCUyMHRleHRHZW5JbnB1dCUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMnRleHQtZ2VuLWlucHV0JTIyKSUzQiUwQSUyMCUyMGNvbnN0JTIwdGV4dEdlblBhcmFncmFwaCUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLW91dHB1dCUyMiklM0IlMEElMEElMjAlMjB0ZXh0R2VuUGFyYWdyYXBoLnRleHRDb250ZW50JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdGVUZXh0KHRleHRHZW5JbnB1dC52YWx1ZSklM0IlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> textGenForm = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-form&quot;</span>);

<span class="hljs-keyword">const</span> <span class="hljs-title function_">translateText</span> = <span class="hljs-keyword">async</span> (<span class="hljs-params">text</span>) =&gt; {
  <span class="hljs-keyword">const</span> inferResponse = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">\`infer_t5?input=<span class="hljs-subst">\${text}</span>\`</span>);
  <span class="hljs-keyword">const</span> inferJson = <span class="hljs-keyword">await</span> inferResponse.<span class="hljs-title function_">json</span>();

  <span class="hljs-keyword">return</span> inferJson.<span class="hljs-property">output</span>;
};

textGenForm.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&quot;submit&quot;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
  event.<span class="hljs-title function_">preventDefault</span>();

  <span class="hljs-keyword">const</span> textGenInput = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;text-gen-input&quot;</span>);
  <span class="hljs-keyword">const</span> textGenParagraph = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-output&quot;</span>);

  textGenParagraph.<span class="hljs-property">textContent</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translateText</span>(textGenInput.<span class="hljs-property">value</span>);
});`,wrap:!1}}),ds=new m({props:{code:"JTIzJTIwU3dpdGNoJTIwdG8lMjB0aGUlMjAlMjJ1c2VyJTIyJTIwdXNlciUwQVVTRVIlMjB1c2VyJTBBJTBBJTIzJTIwU2V0JTIwaG9tZSUyMHRvJTIwdGhlJTIwdXNlcidzJTIwaG9tZSUyMGRpcmVjdG9yeSUwQUVOViUyMEhPTUUlM0QlMkZob21lJTJGdXNlciUyMCU1QyUwQSUwOVBBVEglM0QlMkZob21lJTJGdXNlciUyRi5sb2NhbCUyRmJpbiUzQSUyNFBBVEg=",highlighted:`<span class="hljs-comment"># Switch to the &quot;user&quot; user</span>
<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-comment"># Set home to the user&#x27;s home directory</span>
<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH`,wrap:!1}}),Ts=new m({props:{code:"JTBBJTIzJTIwcmVhZCUyMHRoZSUyMGRvYyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc3BhY2VzLXNka3MtZG9ja2VyJTBBJTIzJTIweW91JTIwd2lsbCUyMGFsc28lMjBmaW5kJTIwZ3VpZGVzJTIwb24lMjBob3clMjBiZXN0JTIwdG8lMjB3cml0ZSUyMHlvdXIlMjBEb2NrZXJmaWxlJTBBJTBBRlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQSUyMyUyMFRoZSUyMHR3byUyMGZvbGxvd2luZyUyMGxpbmVzJTIwYXJlJTIwcmVxdWlyZW1lbnRzJTIwZm9yJTIwdGhlJTIwRGV2JTIwTW9kZSUyMHRvJTIwYmUlMjBmdW5jdGlvbmFsJTBBJTIzJTIwTGVhcm4lMjBtb3JlJTIwYWJvdXQlMjB0aGUlMjBEZXYlMjBNb2RlJTIwYXQlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGV2LW1vZGUtZXhwbG9yZXJzJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQVdPUktESVIlMjAlMkZhcHAlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTJGcmVxdWlyZW1lbnRzLnR4dCUyMHJlcXVpcmVtZW50cy50eHQlMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMHJlcXVpcmVtZW50cy50eHQlMEElMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTIwJTJGYXBwJTBBJTBBVVNFUiUyMHVzZXIlMEElMEFFTlYlMjBIT01FJTNEJTJGaG9tZSUyRnVzZXIlMjAlNUMlMEElMDlQQVRIJTNEJTJGaG9tZSUyRnVzZXIlMkYubG9jYWwlMkZiaW4lM0ElMjRQQVRIJTBBJTBBQ01EJTIwJTVCJTIydXZpY29ybiUyMiUyQyUyMCUyMm1haW4lM0FhcHAlMjIlMkMlMjAlMjItLWhvc3QlMjIlMkMlMjAlMjIwLjAuMC4wJTIyJTJDJTIwJTIyLS1wb3J0JTIyJTJDJTIwJTIyNzg2MCUyMiU1RA==",highlighted:`
<span class="hljs-comment"># read the doc: https://huggingface.co/docs/hub/spaces-sdks-docker</span>
<span class="hljs-comment"># you will also find guides on how best to write your Dockerfile</span>

<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-comment"># The two following lines are requirements for the Dev Mode to be functional</span>
<span class="hljs-comment"># Learn more about the Dev Mode at https://huggingface.co/dev-mode-explorers</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user ./requirements.txt requirements.txt</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r requirements.txt</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . /app</span>

<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH

<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>`,wrap:!1}}),ws=new g({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),Is=new g({props:{title:"Read More",local:"read-more",headingTag:"h2"}}),ks=new Ct({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-sdks-docker-first-demo.md"}}),{c(){j=p("meta"),vs=a(),Bs=p("p"),Zs=a(),c(v.$$.fragment),Rs=a(),Z=p("p"),Z.innerHTML=Xe,Cs=a(),R=p("p"),R.innerHTML=We,Vs=a(),c(C.$$.fragment),Gs=a(),V=p("p"),V.innerHTML=Qe,Ls=a(),w=p("div"),w.innerHTML=_e,Hs=a(),G=p("p"),G.innerHTML=Ne,Es=a(),L=p("p"),L.innerHTML=ze,xs=a(),c(H.$$.fragment),Ss=a(),E=p("p"),E.innerHTML=qe,As=a(),c(x.$$.fragment),Xs=a(),c(S.$$.fragment),Ws=a(),A=p("p"),A.innerHTML=Fe,Qs=a(),c(X.$$.fragment),_s=a(),W=p("p"),W.textContent=Ye,Ns=a(),c(Q.$$.fragment),zs=a(),_=p("p"),_.innerHTML=De,qs=a(),c(N.$$.fragment),Fs=a(),c(z.$$.fragment),Ys=a(),q=p("p"),q.innerHTML=Pe,Ds=a(),c(F.$$.fragment),Ps=a(),Y=p("p"),Y.innerHTML=Oe,Os=a(),y=p("div"),y.innerHTML=Ke,Ks=a(),c(D.$$.fragment),se=a(),P=p("p"),P.innerHTML=st,ee=a(),c(O.$$.fragment),te=a(),K=p("p"),K.innerHTML=et,le=a(),c(ss.$$.fragment),ae=a(),es=p("p"),es.innerHTML=tt,ne=a(),c(ts.$$.fragment),pe=a(),c(ls.$$.fragment),ie=a(),as=p("p"),as.innerHTML=lt,oe=a(),c(ns.$$.fragment),ce=a(),ps=p("p"),ps.innerHTML=at,re=a(),is=p("ol"),is.innerHTML=nt,he=a(),os=p("p"),os.innerHTML=pt,ue=a(),c(cs.$$.fragment),Me=a(),f=p("ol"),f.innerHTML=it,de=a(),c(rs.$$.fragment),me=a(),J=p("ol"),J.innerHTML=ot,Te=a(),c(hs.$$.fragment),je=a(),U=p("ol"),U.innerHTML=ct,ge=a(),c(us.$$.fragment),we=a(),I=p("ol"),I.innerHTML=rt,ye=a(),Ms=p("p"),Ms.innerHTML=ht,fe=a(),c(ds.$$.fragment),Je=a(),ms=p("p"),ms.innerHTML=ut,Ue=a(),c(Ts.$$.fragment),Ie=a(),js=p("p"),js.innerHTML=Mt,be=a(),b=p("div"),b.innerHTML=dt,ke=a(),gs=p("p"),gs.innerHTML=mt,Be=a(),c(ws.$$.fragment),$e=a(),ys=p("p"),ys.innerHTML=Tt,ve=a(),k=p("div"),k.innerHTML=jt,Ze=a(),fs=p("p"),fs.innerHTML=gt,Re=a(),B=p("div"),B.innerHTML=wt,Ce=a(),Js=p("p"),Js.innerHTML=yt,Ve=a(),$=p("div"),$.innerHTML=ft,Ge=a(),Us=p("p"),Us.innerHTML=Jt,Le=a(),c(Is.$$.fragment),He=a(),bs=p("ul"),bs.innerHTML=Ut,Ee=a(),c(ks.$$.fragment),xe=a(),$s=p("p"),this.h()},l(s){const e=Zt("svelte-u9bgzb",document.head);j=i(e,"META",{name:!0,content:!0}),e.forEach(t),vs=n(s),Bs=i(s,"P",{}),It(Bs).forEach(t),Zs=n(s),r(v.$$.fragment,s),Rs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-jw7cyg"&&(Z.innerHTML=Xe),Cs=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1i4ovll"&&(R.innerHTML=We),Vs=n(s),r(C.$$.fragment,s),Gs=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-v1etaf"&&(V.innerHTML=Qe),Ls=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1t9e90m"&&(w.innerHTML=_e),Hs=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1eepspk"&&(G.innerHTML=Ne),Es=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1ebivvn"&&(L.innerHTML=ze),xs=n(s),r(H.$$.fragment,s),Ss=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-16g740l"&&(E.innerHTML=qe),As=n(s),r(x.$$.fragment,s),Xs=n(s),r(S.$$.fragment,s),Ws=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-saf9yg"&&(A.innerHTML=Fe),Qs=n(s),r(X.$$.fragment,s),_s=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-nrg5eu"&&(W.textContent=Ye),Ns=n(s),r(Q.$$.fragment,s),zs=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-o8f96i"&&(_.innerHTML=De),qs=n(s),r(N.$$.fragment,s),Fs=n(s),r(z.$$.fragment,s),Ys=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1jworwg"&&(q.innerHTML=Pe),Ds=n(s),r(F.$$.fragment,s),Ps=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1qy8wh6"&&(Y.innerHTML=Oe),Os=n(s),y=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1gv7naz"&&(y.innerHTML=Ke),Ks=n(s),r(D.$$.fragment,s),se=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1887xzo"&&(P.innerHTML=st),ee=n(s),r(O.$$.fragment,s),te=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1wqy5vs"&&(K.innerHTML=et),le=n(s),r(ss.$$.fragment,s),ae=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-zs1fi1"&&(es.innerHTML=tt),ne=n(s),r(ts.$$.fragment,s),pe=n(s),r(ls.$$.fragment,s),ie=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1gdsumy"&&(as.innerHTML=lt),oe=n(s),r(ns.$$.fragment,s),ce=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-16tk1cq"&&(ps.innerHTML=at),re=n(s),is=i(s,"OL",{"data-svelte-h":!0}),o(is)!=="svelte-42bpu9"&&(is.innerHTML=nt),he=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1s0pz1q"&&(os.innerHTML=pt),ue=n(s),r(cs.$$.fragment,s),Me=n(s),f=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(f)!=="svelte-k9s0qn"&&(f.innerHTML=it),de=n(s),r(rs.$$.fragment,s),me=n(s),J=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(J)!=="svelte-fmvgb8"&&(J.innerHTML=ot),Te=n(s),r(hs.$$.fragment,s),je=n(s),U=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(U)!=="svelte-ztetn2"&&(U.innerHTML=ct),ge=n(s),r(us.$$.fragment,s),we=n(s),I=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(I)!=="svelte-1dn7zpw"&&(I.innerHTML=rt),ye=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-6lf4gt"&&(Ms.innerHTML=ht),fe=n(s),r(ds.$$.fragment,s),Je=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-hrrqd1"&&(ms.innerHTML=ut),Ue=n(s),r(Ts.$$.fragment,s),Ie=n(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-cvojof"&&(js.innerHTML=Mt),be=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-7ddsz3"&&(b.innerHTML=dt),ke=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1m82b2h"&&(gs.innerHTML=mt),Be=n(s),r(ws.$$.fragment,s),$e=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-40o9jr"&&(ys.innerHTML=Tt),ve=n(s),k=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-15efue1"&&(k.innerHTML=jt),Ze=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-86h2ue"&&(fs.innerHTML=gt),Re=n(s),B=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(B)!=="svelte-1kv7f9v"&&(B.innerHTML=wt),Ce=n(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-10fpzqt"&&(Js.innerHTML=yt),Ve=n(s),$=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-1wbh090"&&($.innerHTML=ft),Ge=n(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-yw4wzo"&&(Us.innerHTML=Jt),Le=n(s),r(Is.$$.fragment,s),He=n(s),bs=i(s,"UL",{"data-svelte-h":!0}),o(bs)!=="svelte-bhfcx6"&&(bs.innerHTML=Ut),Ee=n(s),r(ks.$$.fragment,s),xe=n(s),$s=i(s,"P",{}),It($s).forEach(t),this.h()},h(){T(j,"name","hf:doc:metadata"),T(j,"content",Gt),T(w,"class","flex justify-center"),T(y,"class","flex justify-center"),T(f,"start","2"),T(J,"start","3"),T(U,"start","4"),T(I,"start","5"),T(b,"class","flex justify-center"),T(k,"class","flex justify-center"),T(B,"class","flex justify-center"),T($,"class","flex justify-center")},m(s,e){Rt(document.head,j),l(s,vs,e),l(s,Bs,e),l(s,Zs,e),h(v,s,e),l(s,Rs,e),l(s,Z,e),l(s,Cs,e),l(s,R,e),l(s,Vs,e),h(C,s,e),l(s,Gs,e),l(s,V,e),l(s,Ls,e),l(s,w,e),l(s,Hs,e),l(s,G,e),l(s,Es,e),l(s,L,e),l(s,xs,e),h(H,s,e),l(s,Ss,e),l(s,E,e),l(s,As,e),h(x,s,e),l(s,Xs,e),h(S,s,e),l(s,Ws,e),l(s,A,e),l(s,Qs,e),h(X,s,e),l(s,_s,e),l(s,W,e),l(s,Ns,e),h(Q,s,e),l(s,zs,e),l(s,_,e),l(s,qs,e),h(N,s,e),l(s,Fs,e),h(z,s,e),l(s,Ys,e),l(s,q,e),l(s,Ds,e),h(F,s,e),l(s,Ps,e),l(s,Y,e),l(s,Os,e),l(s,y,e),l(s,Ks,e),h(D,s,e),l(s,se,e),l(s,P,e),l(s,ee,e),h(O,s,e),l(s,te,e),l(s,K,e),l(s,le,e),h(ss,s,e),l(s,ae,e),l(s,es,e),l(s,ne,e),h(ts,s,e),l(s,pe,e),h(ls,s,e),l(s,ie,e),l(s,as,e),l(s,oe,e),h(ns,s,e),l(s,ce,e),l(s,ps,e),l(s,re,e),l(s,is,e),l(s,he,e),l(s,os,e),l(s,ue,e),h(cs,s,e),l(s,Me,e),l(s,f,e),l(s,de,e),h(rs,s,e),l(s,me,e),l(s,J,e),l(s,Te,e),h(hs,s,e),l(s,je,e),l(s,U,e),l(s,ge,e),h(us,s,e),l(s,we,e),l(s,I,e),l(s,ye,e),l(s,Ms,e),l(s,fe,e),h(ds,s,e),l(s,Je,e),l(s,ms,e),l(s,Ue,e),h(Ts,s,e),l(s,Ie,e),l(s,js,e),l(s,be,e),l(s,b,e),l(s,ke,e),l(s,gs,e),l(s,Be,e),h(ws,s,e),l(s,$e,e),l(s,ys,e),l(s,ve,e),l(s,k,e),l(s,Ze,e),l(s,fs,e),l(s,Re,e),l(s,B,e),l(s,Ce,e),l(s,Js,e),l(s,Ve,e),l(s,$,e),l(s,Ge,e),l(s,Us,e),l(s,Le,e),h(Is,s,e),l(s,He,e),l(s,bs,e),l(s,Ee,e),h(ks,s,e),l(s,xe,e),l(s,$s,e),Se=!0},p:kt,i(s){Se||(u(v.$$.fragment,s),u(C.$$.fragment,s),u(H.$$.fragment,s),u(x.$$.fragment,s),u(S.$$.fragment,s),u(X.$$.fragment,s),u(Q.$$.fragment,s),u(N.$$.fragment,s),u(z.$$.fragment,s),u(F.$$.fragment,s),u(D.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(ts.$$.fragment,s),u(ls.$$.fragment,s),u(ns.$$.fragment,s),u(cs.$$.fragment,s),u(rs.$$.fragment,s),u(hs.$$.fragment,s),u(us.$$.fragment,s),u(ds.$$.fragment,s),u(Ts.$$.fragment,s),u(ws.$$.fragment,s),u(Is.$$.fragment,s),u(ks.$$.fragment,s),Se=!0)},o(s){M(v.$$.fragment,s),M(C.$$.fragment,s),M(H.$$.fragment,s),M(x.$$.fragment,s),M(S.$$.fragment,s),M(X.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(z.$$.fragment,s),M(F.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(ls.$$.fragment,s),M(ns.$$.fragment,s),M(cs.$$.fragment,s),M(rs.$$.fragment,s),M(hs.$$.fragment,s),M(us.$$.fragment,s),M(ds.$$.fragment,s),M(Ts.$$.fragment,s),M(ws.$$.fragment,s),M(Is.$$.fragment,s),M(ks.$$.fragment,s),Se=!1},d(s){s&&(t(vs),t(Bs),t(Zs),t(Rs),t(Z),t(Cs),t(R),t(Vs),t(Gs),t(V),t(Ls),t(w),t(Hs),t(G),t(Es),t(L),t(xs),t(Ss),t(E),t(As),t(Xs),t(Ws),t(A),t(Qs),t(_s),t(W),t(Ns),t(zs),t(_),t(qs),t(Fs),t(Ys),t(q),t(Ds),t(Ps),t(Y),t(Os),t(y),t(Ks),t(se),t(P),t(ee),t(te),t(K),t(le),t(ae),t(es),t(ne),t(pe),t(ie),t(as),t(oe),t(ce),t(ps),t(re),t(is),t(he),t(os),t(ue),t(Me),t(f),t(de),t(me),t(J),t(Te),t(je),t(U),t(ge),t(we),t(I),t(ye),t(Ms),t(fe),t(Je),t(ms),t(Ue),t(Ie),t(js),t(be),t(b),t(ke),t(gs),t(Be),t($e),t(ys),t(ve),t(k),t(Ze),t(fs),t(Re),t(B),t(Ce),t(Js),t(Ve),t($),t(Ge),t(Us),t(Le),t(He),t(bs),t(Ee),t(xe),t($s)),t(j),d(v,s),d(C,s),d(H,s),d(x,s),d(S,s),d(X,s),d(Q,s),d(N,s),d(z,s),d(F,s),d(D,s),d(O,s),d(ss,s),d(ts,s),d(ls,s),d(ns,s),d(cs,s),d(rs,s),d(hs,s),d(us,s),d(ds,s),d(Ts,s),d(ws,s),d(Is,s),d(ks,s)}}}const Gt='{"title":"Your First Docker Space: Text Generation with T5","local":"your-first-docker-space-text-generation-with-t5","sections":[{"title":"Create a new Docker Space","local":"create-a-new-docker-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the app","local":"create-the-app","sections":[],"depth":2},{"title":"Create the Dockerfile","local":"create-the-dockerfile","sections":[{"title":"Testing locally","local":"testing-locally","sections":[],"depth":3}],"depth":2},{"title":"Adding some ML to our app","local":"adding-some-ml-to-our-app","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Read More","local":"read-more","sections":[],"depth":2}],"depth":1}';function Lt(Ae){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends $t{constructor(j){super(),vt(this,j,Lt,Vt,bt,{})}}export{At as component};
