import{s as kt,o as Vt,n as Rt}from"../chunks/scheduler.c59d9fbb.js";import{S as Bt,i as vt,g as m,s as a,r as o,A as Xt,h as M,f as l,c as n,j as Wt,u as r,x as y,k as Gt,y as Qt,a as s,v as i,d as p,t as c,w as d}from"../chunks/index.a47918e3.js";import{T as Yt}from"../chunks/Tip.3fcf4aa4.js";import{C as h}from"../chunks/CodeBlock.936db8cd.js";import{H as de}from"../chunks/Heading.604bc707.js";function zt(ye){let u,T='💡 Read <a href="https://arxiv.org/abs/2103.10385" rel="nofollow">GPT Understands, Too</a> to learn more about p-tuning.';return{c(){u=m("p"),u.innerHTML=T},l(J){u=M(J,"P",{"data-svelte-h":!0}),y(u)!=="svelte-125xb5e"&&(u.innerHTML=T)},m(J,me){s(J,u,me)},p:Rt,d(J){J&&l(u)}}}function Ht(ye){let u,T,J,me,w,ue,U,it="It is challenging to finetune large language models for downstream tasks because they have so many parameters. To work around this, you can use <em>prompts</em> to steer the model toward a particular downstream task without fully finetuning a model. Typically, these prompts are handcrafted, which may be impractical because you need very large validation sets to find the best prompts. <em>P-tuning</em> is a method for automatically searching and optimizing for better prompts in a continuous space.",he,f,Je,b,pt='This guide will show you how to train a <a href="https://huggingface.co/roberta-large" rel="nofollow"><code>roberta-large</code></a> model (but you can also use any of the GPT, OPT, or BLOOM models) with p-tuning on the <code>mrpc</code> configuration of the <a href="https://huggingface.co/datasets/glue" rel="nofollow">GLUE</a> benchmark.',fe,j,ct="Before you begin, make sure you have all the necessary libraries installed:",Te,g,we,Z,Ue,I,dt='To get started, import 🤗 Transformers to create the base model, 🤗 Datasets to load a dataset, 🤗 Evaluate to load an evaluation metric, and 🤗 PEFT to create a <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> and setup the configuration for p-tuning.',be,C,mt="Define the model, dataset, and some basic training hyperparameters:",je,_,ge,$,Ze,W,Mt='Next, load the <code>mrpc</code> configuration - a corpus of sentence pairs labeled according to whether they’re semantically equivalent or not - from the <a href="https://huggingface.co/datasets/glue" rel="nofollow">GLUE</a> benchmark:',Ie,G,Ce,k,yt="From 🤗 Evaluate, load a metric for evaluating the model’s performance. The evaluation module returns the accuracy and F1 scores associated with this specific task.",_e,V,$e,R,ut="Now you can use the <code>metric</code> to write a function that computes the accuracy and F1 scores. The <code>compute_metric</code> function calculates the scores from the model predictions and labels:",We,B,Ge,v,ke,X,ht="Initialize the tokenizer and configure the padding token to use. If you’re using a GPT, OPT, or BLOOM model, you should set the <code>padding_side</code> to the left; otherwise it’ll be set to the right. Tokenize the sentence pairs and truncate them to the maximum length.",Ve,Q,Re,Y,Jt="Use <code>map</code> to apply the <code>tokenize_function</code> to the dataset, and remove the unprocessed columns because the model won’t need those. You should also rename the <code>label</code> column to <code>labels</code> because that is the expected name for the labels by models in the 🤗 Transformers library.",Be,z,ve,H,ft='Create a collator function with <a href="https://huggingface.co/docs/transformers/v4.35.0/en/main_classes/data_collator#transformers.DataCollatorWithPadding" rel="nofollow">DataCollatorWithPadding</a> to pad the examples in the batches to the <code>longest</code> sequence in the batch:',Xe,x,Qe,F,Ye,q,Tt='P-tuning uses a prompt encoder to optimize the prompt parameters, so you’ll need to initialize the <a href="/docs/peft/v0.6.2/en/package_reference/tuners#peft.PromptEncoderConfig">PromptEncoderConfig</a> with several arguments:',ze,E,wt="<li><code>task_type</code>: the type of task you’re training on, in this case it is sequence classification or <code>SEQ_CLS</code></li> <li><code>num_virtual_tokens</code>: the number of virtual tokens to use, or in other words, the prompt</li> <li><code>encoder_hidden_size</code>: the hidden size of the encoder used to optimize the prompt parameters</li>",He,N,xe,S,Ut='Create the base <code>roberta-large</code> model from <a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoModelForSequenceClassification" rel="nofollow">AutoModelForSequenceClassification</a>, and then wrap the base model and <code>peft_config</code> with <code>get_peft_model()</code> to create a <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. If you’re curious to see how many parameters you’re actually training compared to training on all the model parameters, you can print it out with <a href="/docs/peft/v0.6.2/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a>:',Fe,A,qe,P,bt='From the 🤗 Transformers library, set up the <a href="https://huggingface.co/docs/transformers/v4.35.0/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class with where you want to save the model to, the training hyperparameters, how to evaluate the model, and when to save the checkpoints:',Ee,L,Ne,D,jt='Then pass the model, <code>TrainingArguments</code>, datasets, tokenizer, data collator, and evaluation function to the <a href="https://huggingface.co/docs/transformers/v4.35.0/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class, which’ll handle the entire training loop for you. Once you’re ready, call <a href="https://huggingface.co/docs/transformers/v4.35.0/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training!',Se,K,Ae,O,Pe,ee,gt="You can store and share your model on the Hub if you’d like. Log in to your Hugging Face account and enter your token when prompted:",Le,te,De,le,Zt='Upload the model to a specifc model repository on the Hub with the <a href="https://huggingface.co/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> function:',Ke,se,Oe,ae,et,ne,It="Once the model has been uploaded to the Hub, anyone can easily use it for inference. Load the configuration and model:",tt,oe,lt,re,Ct="Get some text and tokenize it:",st,ie,at,pe,_t="Pass the inputs to the model to classify the sentences:",nt,ce,ot,Me,rt;return w=new de({props:{title:"P-tuning for sequence classification",local:"p-tuning-for-sequence-classification",headingTag:"h1"}}),f=new Yt({props:{$$slots:{default:[zt]},$$scope:{ctx:ye}}}),g=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMGV2YWx1YXRl",highlighted:"!pip install -q peft transformers datasets evaluate",wrap:!1}}),Z=new de({props:{title:"Setup",local:"setup",headingTag:"h2"}}),_=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwQXV0b1Rva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMERhdGFDb2xsYXRvcldpdGhQYWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMEElMjAlMjAlMjAlMjBUcmFpbmVyJTJDJTBBKSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMGdldF9wZWZ0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGdldF9wZWZ0X21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdCUyQyUwQSUyMCUyMCUyMCUyMHNldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QlMkMlMEElMjAlMjAlMjAlMjBQZWZ0VHlwZSUyQyUwQSUyMCUyMCUyMCUyMFByb21wdEVuY29kZXJDb25maWclMkMlMEEpJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX25hbWVfb3JfcGF0aCUyMCUzRCUyMCUyMnJvYmVydGEtbGFyZ2UlMjIlMEF0YXNrJTIwJTNEJTIwJTIybXJwYyUyMiUwQW51bV9lcG9jaHMlMjAlM0QlMjAyMCUwQWxyJTIwJTNEJTIwMWUtMyUwQWJhdGNoX3NpemUlMjAlM0QlMjAzMg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForSequenceClassification,
    AutoTokenizer,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> (
    get_peft_config,
    get_peft_model,
    get_peft_model_state_dict,
    set_peft_model_state_dict,
    PeftType,
    PromptEncoderConfig,
)
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> torch

model_name_or_path = <span class="hljs-string">&quot;roberta-large&quot;</span>
task = <span class="hljs-string">&quot;mrpc&quot;</span>
num_epochs = <span class="hljs-number">20</span>
lr = <span class="hljs-number">1e-3</span>
batch_size = <span class="hljs-number">32</span>`,wrap:!1}}),$=new de({props:{title:"Load dataset and metric",local:"load-dataset-and-metric",headingTag:"h2"}}),G=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwdGFzayklMEFkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIyc2VudGVuY2UxJTIyJTNBJTIwJ0Ftcm96aSUyMGFjY3VzZWQlMjBoaXMlMjBicm90aGVyJTIwJTJDJTIwd2hvbSUyMGhlJTIwY2FsbGVkJTIwJTIyJTIwdGhlJTIwd2l0bmVzcyUyMCUyMiUyMCUyQyUyMG9mJTIwZGVsaWJlcmF0ZWx5JTIwZGlzdG9ydGluZyUyMGhpcyUyMGV2aWRlbmNlJTIwLiclMkMlMEElMjAlMjAlMjAlMjAlMjJzZW50ZW5jZTIlMjIlM0ElMjAnUmVmZXJyaW5nJTIwdG8lMjBoaW0lMjBhcyUyMG9ubHklMjAlMjIlMjB0aGUlMjB3aXRuZXNzJTIwJTIyJTIwJTJDJTIwQW1yb3ppJTIwYWNjdXNlZCUyMGhpcyUyMGJyb3RoZXIlMjBvZiUyMGRlbGliZXJhdGVseSUyMGRpc3RvcnRpbmclMjBoaXMlMjBldmlkZW5jZSUyMC4nJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWwlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIyaWR4JTIyJTNBJTIwMCUyQyUwQSU3RA==",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, task)
dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{
    <span class="hljs-string">&quot;sentence1&quot;</span>: <span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
    <span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">&#x27;Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;idx&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),V=new h({props:{code:"bWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwdGFzayk=",highlighted:'metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, task)',wrap:!1}}),B=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),v=new de({props:{title:"Preprocess dataset",local:"preprocess-dataset",headingTag:"h2"}}),Q=new h({props:{code:"aWYlMjBhbnkoayUyMGluJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTIwZm9yJTIwayUyMGluJTIwKCUyMmdwdCUyMiUyQyUyMCUyMm9wdCUyMiUyQyUyMCUyMmJsb29tJTIyKSklM0ElMEElMjAlMjAlMjAlMjBwYWRkaW5nX3NpZGUlMjAlM0QlMjAlMjJsZWZ0JTIyJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMnJpZ2h0JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwcGFkZGluZ19zaWRlJTNEcGFkZGluZ19zaWRlKSUwQWlmJTIwZ2V0YXR0cih0b2tlbml6ZXIlMkMlMjAlMjJwYWRfdG9rZW5faWQlMjIpJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMEElMEElMEFkZWYlMjB0b2tlbml6ZV9mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBtYXhfbGVuZ3RoJTNETm9uZSUyMCUzRCUzRSUyMHVzZSUyMHRoZSUyMG1vZGVsJTIwbWF4JTIwbGVuZ3RoJTIwKGl0J3MlMjBhY3R1YWxseSUyMHRoZSUyMGRlZmF1bHQpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplcihleGFtcGxlcyU1QiUyMnNlbnRlbmNlMSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBtYXhfbGVuZ3RoJTNETm9uZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">if</span> <span class="hljs-built_in">any</span>(k <span class="hljs-keyword">in</span> model_name_or_path <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> (<span class="hljs-string">&quot;gpt&quot;</span>, <span class="hljs-string">&quot;opt&quot;</span>, <span class="hljs-string">&quot;bloom&quot;</span>)):
    padding_side = <span class="hljs-string">&quot;left&quot;</span>
<span class="hljs-keyword">else</span>:
    padding_side = <span class="hljs-string">&quot;right&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_name_or_path, padding_side=padding_side)
<span class="hljs-keyword">if</span> <span class="hljs-built_in">getattr</span>(tokenizer, <span class="hljs-string">&quot;pad_token_id&quot;</span>) <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token_id = tokenizer.eos_token_id


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-comment"># max_length=None =&gt; use the model max length (it&#x27;s actually the default)</span>
    outputs = tokenizer(examples[<span class="hljs-string">&quot;sentence1&quot;</span>], examples[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-literal">None</span>)
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),z=new h({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyaWR4JTIyJTJDJTIwJTIyc2VudGVuY2UxJTIyJTJDJTIwJTIyc2VudGVuY2UyJTIyJTVEJTJDJTBBKSUwQSUwQXRva2VuaXplZF9kYXRhc2V0cyUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cy5yZW5hbWVfY29sdW1uKCUyMmxhYmVsJTIyJTJDJTIwJTIybGFiZWxzJTIyKQ==",highlighted:`tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(
    tokenize_function,
    batched=<span class="hljs-literal">True</span>,
    remove_columns=[<span class="hljs-string">&quot;idx&quot;</span>, <span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>],
)

tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)`,wrap:!1}}),x=new h({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMHBhZGRpbmclM0QlMjJsb25nZXN0JTIyKQ==",highlighted:'data_collator = DataCollatorWithPadding(tokenizer=tokenizer, padding=<span class="hljs-string">&quot;longest&quot;</span>)',wrap:!1}}),F=new de({props:{title:"Train",local:"train",headingTag:"h2"}}),N=new h({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBQcm9tcHRFbmNvZGVyQ29uZmlnKHRhc2tfdHlwZSUzRCUyMlNFUV9DTFMlMjIlMkMlMjBudW1fdmlydHVhbF90b2tlbnMlM0QyMCUyQyUyMGVuY29kZXJfaGlkZGVuX3NpemUlM0QxMjgp",highlighted:'peft_config = PromptEncoderConfig(task_type=<span class="hljs-string">&quot;SEQ_CLS&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>, encoder_hidden_size=<span class="hljs-number">128</span>)',wrap:!1}}),A=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lX29yX3BhdGglMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjAxMzUxOTM4JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwMzU1NjYyMDgyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4zODAxMTg2NzY4MDYyNjEyNyUyMg==",highlighted:`model = AutoModelForSequenceClassification.from_pretrained(model_name_or_path, return_dict=<span class="hljs-literal">True</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1351938 || all params: 355662082 || trainable%: 0.38011867680626127&quot;</span>`,wrap:!1}}),L=new h({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJ5b3VyLW5hbWUlMkZyb2JlcnRhLWxhcmdlLXBlZnQtcC10dW5pbmclMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtMyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMC4wMSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;your-name/roberta-large-peft-p-tuning&quot;</span>,
    learning_rate=<span class="hljs-number">1e-3</span>,
    per_device_train_batch_size=<span class="hljs-number">32</span>,
    per_device_eval_batch_size=<span class="hljs-number">32</span>,
    num_train_epochs=<span class="hljs-number">2</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),K=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>],
    tokenizer=tokenizer,
    data_collator=data_collator,
    compute_metrics=compute_metrics,
)

trainer.train()`,wrap:!1}}),O=new de({props:{title:"Share model",local:"share-model",headingTag:"h2"}}),te=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),se=new h({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91ci1uYW1lJTJGcm9iZXJ0YS1sYXJnZS1wZWZ0LXAtdHVuaW5nJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKQ==",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your-name/roberta-large-peft-p-tuning&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)',wrap:!1}}),ae=new de({props:{title:"Inference",local:"inference",headingTag:"h2"}}),oe=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUyQyUyMFBlZnRDb25maWclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyc21hbmdydWwlMkZyb2JlcnRhLWxhcmdlLXBlZnQtcC10dW5pbmclMjIlMEFjb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKSUwQWluZmVyZW5jZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGgpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGluZmVyZW5jZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;smangrul/roberta-large-peft-p-tuning&quot;</span>
config = PeftConfig.from_pretrained(peft_model_id)
inference_model = AutoModelForSequenceClassification.from_pretrained(config.base_model_name_or_path)
tokenizer = AutoTokenizer.from_pretrained(config.base_model_name_or_path)
model = PeftModel.from_pretrained(inference_model, peft_model_id)`,wrap:!1}}),ie=new h({props:{code:"Y2xhc3NlcyUyMCUzRCUyMCU1QiUyMm5vdCUyMGVxdWl2YWxlbnQlMjIlMkMlMjAlMjJlcXVpdmFsZW50JTIyJTVEJTBBJTBBc2VudGVuY2UxJTIwJTNEJTIwJTIyQ29hc3QlMjByZWR3b29kJTIwdHJlZXMlMjBhcmUlMjB0aGUlMjB0YWxsZXN0JTIwdHJlZXMlMjBvbiUyMHRoZSUyMHBsYW5ldCUyMGFuZCUyMGNhbiUyMGdyb3clMjBvdmVyJTIwMzAwJTIwZmVldCUyMHRhbGwuJTIyJTBBc2VudGVuY2UyJTIwJTNEJTIwJTIyVGhlJTIwY29hc3QlMjByZWR3b29kJTIwdHJlZXMlMkMlMjB3aGljaCUyMGNhbiUyMGF0dGFpbiUyMGElMjBoZWlnaHQlMjBvZiUyMG92ZXIlMjAzMDAlMjBmZWV0JTJDJTIwYXJlJTIwdGhlJTIwdGFsbGVzdCUyMHRyZWVzJTIwb24lMjBlYXJ0aC4lMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoc2VudGVuY2UxJTJDJTIwc2VudGVuY2UyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEJTIybG9uZ2VzdCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`classes = [<span class="hljs-string">&quot;not equivalent&quot;</span>, <span class="hljs-string">&quot;equivalent&quot;</span>]

sentence1 = <span class="hljs-string">&quot;Coast redwood trees are the tallest trees on the planet and can grow over 300 feet tall.&quot;</span>
sentence2 = <span class="hljs-string">&quot;The coast redwood trees, which can attain a height of over 300 feet, are the tallest trees on earth.&quot;</span>

inputs = tokenizer(sentence1, sentence2, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&quot;longest&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ce=new h({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0cHV0cyklMEElMEFwYXJhcGhyYXNlZF90ZXh0JTIwJTNEJTIwdG9yY2guc29mdG1heChvdXRwdXRzJTJDJTIwZGltJTNEMSkudG9saXN0KCklNUIwJTVEJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNsYXNzZXMpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JjbGFzc2VzJTVCaSU1RCU3RCUzQSUyMCU3QmludChyb3VuZChwYXJhcGhyYXNlZF90ZXh0JTVCaSU1RCUyMColMjAxMDApKSU3RCUyNSUyMiklMEElMjJub3QlMjBlcXVpdmFsZW50JTNBJTIwNCUyNSUyMiUwQSUyMmVxdWl2YWxlbnQlM0ElMjA5NiUyNSUyMg==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs).logits
    <span class="hljs-built_in">print</span>(outputs)

paraphrased_text = torch.softmax(outputs, dim=<span class="hljs-number">1</span>).tolist()[<span class="hljs-number">0</span>]
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(classes)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{classes[i]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">int</span>(<span class="hljs-built_in">round</span>(paraphrased_text[i] * <span class="hljs-number">100</span>))}</span>%&quot;</span>)
<span class="hljs-string">&quot;not equivalent: 4%&quot;</span>
<span class="hljs-string">&quot;equivalent: 96%&quot;</span>`,wrap:!1}}),{c(){u=m("meta"),T=a(),J=m("p"),me=a(),o(w.$$.fragment),ue=a(),U=m("p"),U.innerHTML=it,he=a(),o(f.$$.fragment),Je=a(),b=m("p"),b.innerHTML=pt,fe=a(),j=m("p"),j.textContent=ct,Te=a(),o(g.$$.fragment),we=a(),o(Z.$$.fragment),Ue=a(),I=m("p"),I.innerHTML=dt,be=a(),C=m("p"),C.textContent=mt,je=a(),o(_.$$.fragment),ge=a(),o($.$$.fragment),Ze=a(),W=m("p"),W.innerHTML=Mt,Ie=a(),o(G.$$.fragment),Ce=a(),k=m("p"),k.textContent=yt,_e=a(),o(V.$$.fragment),$e=a(),R=m("p"),R.innerHTML=ut,We=a(),o(B.$$.fragment),Ge=a(),o(v.$$.fragment),ke=a(),X=m("p"),X.innerHTML=ht,Ve=a(),o(Q.$$.fragment),Re=a(),Y=m("p"),Y.innerHTML=Jt,Be=a(),o(z.$$.fragment),ve=a(),H=m("p"),H.innerHTML=ft,Xe=a(),o(x.$$.fragment),Qe=a(),o(F.$$.fragment),Ye=a(),q=m("p"),q.innerHTML=Tt,ze=a(),E=m("ul"),E.innerHTML=wt,He=a(),o(N.$$.fragment),xe=a(),S=m("p"),S.innerHTML=Ut,Fe=a(),o(A.$$.fragment),qe=a(),P=m("p"),P.innerHTML=bt,Ee=a(),o(L.$$.fragment),Ne=a(),D=m("p"),D.innerHTML=jt,Se=a(),o(K.$$.fragment),Ae=a(),o(O.$$.fragment),Pe=a(),ee=m("p"),ee.textContent=gt,Le=a(),o(te.$$.fragment),De=a(),le=m("p"),le.innerHTML=Zt,Ke=a(),o(se.$$.fragment),Oe=a(),o(ae.$$.fragment),et=a(),ne=m("p"),ne.textContent=It,tt=a(),o(oe.$$.fragment),lt=a(),re=m("p"),re.textContent=Ct,st=a(),o(ie.$$.fragment),at=a(),pe=m("p"),pe.textContent=_t,nt=a(),o(ce.$$.fragment),ot=a(),Me=m("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);u=M(t,"META",{name:!0,content:!0}),t.forEach(l),T=n(e),J=M(e,"P",{}),Wt(J).forEach(l),me=n(e),r(w.$$.fragment,e),ue=n(e),U=M(e,"P",{"data-svelte-h":!0}),y(U)!=="svelte-s3dbsf"&&(U.innerHTML=it),he=n(e),r(f.$$.fragment,e),Je=n(e),b=M(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1hr4cih"&&(b.innerHTML=pt),fe=n(e),j=M(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-1c9nexd"&&(j.textContent=ct),Te=n(e),r(g.$$.fragment,e),we=n(e),r(Z.$$.fragment,e),Ue=n(e),I=M(e,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1pdovj4"&&(I.innerHTML=dt),be=n(e),C=M(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-30fuvg"&&(C.textContent=mt),je=n(e),r(_.$$.fragment,e),ge=n(e),r($.$$.fragment,e),Ze=n(e),W=M(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-zx4u5n"&&(W.innerHTML=Mt),Ie=n(e),r(G.$$.fragment,e),Ce=n(e),k=M(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1k36sge"&&(k.textContent=yt),_e=n(e),r(V.$$.fragment,e),$e=n(e),R=M(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-17x055y"&&(R.innerHTML=ut),We=n(e),r(B.$$.fragment,e),Ge=n(e),r(v.$$.fragment,e),ke=n(e),X=M(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-12y1arr"&&(X.innerHTML=ht),Ve=n(e),r(Q.$$.fragment,e),Re=n(e),Y=M(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-1ogld7i"&&(Y.innerHTML=Jt),Be=n(e),r(z.$$.fragment,e),ve=n(e),H=M(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-r2o6gh"&&(H.innerHTML=ft),Xe=n(e),r(x.$$.fragment,e),Qe=n(e),r(F.$$.fragment,e),Ye=n(e),q=M(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-mz3vh"&&(q.innerHTML=Tt),ze=n(e),E=M(e,"UL",{"data-svelte-h":!0}),y(E)!=="svelte-ivboi0"&&(E.innerHTML=wt),He=n(e),r(N.$$.fragment,e),xe=n(e),S=M(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1ul6gt5"&&(S.innerHTML=Ut),Fe=n(e),r(A.$$.fragment,e),qe=n(e),P=M(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1xq97zs"&&(P.innerHTML=bt),Ee=n(e),r(L.$$.fragment,e),Ne=n(e),D=M(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-qhagvg"&&(D.innerHTML=jt),Se=n(e),r(K.$$.fragment,e),Ae=n(e),r(O.$$.fragment,e),Pe=n(e),ee=M(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-vati0h"&&(ee.textContent=gt),Le=n(e),r(te.$$.fragment,e),De=n(e),le=M(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-ouz64o"&&(le.innerHTML=Zt),Ke=n(e),r(se.$$.fragment,e),Oe=n(e),r(ae.$$.fragment,e),et=n(e),ne=M(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-19d9n1k"&&(ne.textContent=It),tt=n(e),r(oe.$$.fragment,e),lt=n(e),re=M(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-yrd6oi"&&(re.textContent=Ct),st=n(e),r(ie.$$.fragment,e),at=n(e),pe=M(e,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-1pxzrl4"&&(pe.textContent=_t),nt=n(e),r(ce.$$.fragment,e),ot=n(e),Me=M(e,"P",{}),Wt(Me).forEach(l),this.h()},h(){Gt(u,"name","hf:doc:metadata"),Gt(u,"content",xt)},m(e,t){Qt(document.head,u),s(e,T,t),s(e,J,t),s(e,me,t),i(w,e,t),s(e,ue,t),s(e,U,t),s(e,he,t),i(f,e,t),s(e,Je,t),s(e,b,t),s(e,fe,t),s(e,j,t),s(e,Te,t),i(g,e,t),s(e,we,t),i(Z,e,t),s(e,Ue,t),s(e,I,t),s(e,be,t),s(e,C,t),s(e,je,t),i(_,e,t),s(e,ge,t),i($,e,t),s(e,Ze,t),s(e,W,t),s(e,Ie,t),i(G,e,t),s(e,Ce,t),s(e,k,t),s(e,_e,t),i(V,e,t),s(e,$e,t),s(e,R,t),s(e,We,t),i(B,e,t),s(e,Ge,t),i(v,e,t),s(e,ke,t),s(e,X,t),s(e,Ve,t),i(Q,e,t),s(e,Re,t),s(e,Y,t),s(e,Be,t),i(z,e,t),s(e,ve,t),s(e,H,t),s(e,Xe,t),i(x,e,t),s(e,Qe,t),i(F,e,t),s(e,Ye,t),s(e,q,t),s(e,ze,t),s(e,E,t),s(e,He,t),i(N,e,t),s(e,xe,t),s(e,S,t),s(e,Fe,t),i(A,e,t),s(e,qe,t),s(e,P,t),s(e,Ee,t),i(L,e,t),s(e,Ne,t),s(e,D,t),s(e,Se,t),i(K,e,t),s(e,Ae,t),i(O,e,t),s(e,Pe,t),s(e,ee,t),s(e,Le,t),i(te,e,t),s(e,De,t),s(e,le,t),s(e,Ke,t),i(se,e,t),s(e,Oe,t),i(ae,e,t),s(e,et,t),s(e,ne,t),s(e,tt,t),i(oe,e,t),s(e,lt,t),s(e,re,t),s(e,st,t),i(ie,e,t),s(e,at,t),s(e,pe,t),s(e,nt,t),i(ce,e,t),s(e,ot,t),s(e,Me,t),rt=!0},p(e,[t]){const $t={};t&2&&($t.$$scope={dirty:t,ctx:e}),f.$set($t)},i(e){rt||(p(w.$$.fragment,e),p(f.$$.fragment,e),p(g.$$.fragment,e),p(Z.$$.fragment,e),p(_.$$.fragment,e),p($.$$.fragment,e),p(G.$$.fragment,e),p(V.$$.fragment,e),p(B.$$.fragment,e),p(v.$$.fragment,e),p(Q.$$.fragment,e),p(z.$$.fragment,e),p(x.$$.fragment,e),p(F.$$.fragment,e),p(N.$$.fragment,e),p(A.$$.fragment,e),p(L.$$.fragment,e),p(K.$$.fragment,e),p(O.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(ae.$$.fragment,e),p(oe.$$.fragment,e),p(ie.$$.fragment,e),p(ce.$$.fragment,e),rt=!0)},o(e){c(w.$$.fragment,e),c(f.$$.fragment,e),c(g.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(x.$$.fragment,e),c(F.$$.fragment,e),c(N.$$.fragment,e),c(A.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(ie.$$.fragment,e),c(ce.$$.fragment,e),rt=!1},d(e){e&&(l(T),l(J),l(me),l(ue),l(U),l(he),l(Je),l(b),l(fe),l(j),l(Te),l(we),l(Ue),l(I),l(be),l(C),l(je),l(ge),l(Ze),l(W),l(Ie),l(Ce),l(k),l(_e),l($e),l(R),l(We),l(Ge),l(ke),l(X),l(Ve),l(Re),l(Y),l(Be),l(ve),l(H),l(Xe),l(Qe),l(Ye),l(q),l(ze),l(E),l(He),l(xe),l(S),l(Fe),l(qe),l(P),l(Ee),l(Ne),l(D),l(Se),l(Ae),l(Pe),l(ee),l(Le),l(De),l(le),l(Ke),l(Oe),l(et),l(ne),l(tt),l(lt),l(re),l(st),l(at),l(pe),l(nt),l(ot),l(Me)),l(u),d(w,e),d(f,e),d(g,e),d(Z,e),d(_,e),d($,e),d(G,e),d(V,e),d(B,e),d(v,e),d(Q,e),d(z,e),d(x,e),d(F,e),d(N,e),d(A,e),d(L,e),d(K,e),d(O,e),d(te,e),d(se,e),d(ae,e),d(oe,e),d(ie,e),d(ce,e)}}}const xt='{"title":"P-tuning for sequence classification","local":"p-tuning-for-sequence-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Load dataset and metric","local":"load-dataset-and-metric","sections":[],"depth":2},{"title":"Preprocess dataset","local":"preprocess-dataset","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Share model","local":"share-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Ft(ye){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Bt{constructor(u){super(),vt(this,u,Ft,Ht,kt,{})}}export{Pt as component};
