import{s as Kt,n as Ot,o as te}from"../chunks/scheduler.53228c21.js";import{S as ee,i as ne,e as o,s as l,c as r,h as ae,a as i,d as n,b as s,f as zt,g as c,j as d,k as D,l as le,m as a,n as p,t as h,o as m,p as f}from"../chunks/index.100fac89.js";import{C as se}from"../chunks/CopyLLMTxtMenu.f9d68c5a.js";import{C as N}from"../chunks/CodeBlock.d30a6509.js";import{H as z,E as oe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.530cf753.js";function ie(It){let u,K,L,O,w,tt,T,et,b,St="<p>The attention dispatcher is an experimental feature. Please open an issue if you have any feedback or encounter any problems.</p>",nt,g,Gt="Diffusers provides several optimized attention algorithms that are more memory and computationally efficient through it’s <em>attention dispatcher</em>. The dispatcher acts as a router for managing and switching between different attention implementations and provides a unified interface for interacting with them.",at,k,xt='Refer to the table below for an overview of the available attention families and to the <a href="#available-backends">Available backends</a> section for a more complete list.',lt,U,Ft='<thead><tr><th>attention family</th> <th>main feature</th></tr></thead> <tbody><tr><td>FlashAttention</td> <td>minimizes memory reads/writes through tiling and recomputation</td></tr> <tr><td>SageAttention</td> <td>quantizes attention to int8</td></tr> <tr><td>PyTorch native</td> <td>built-in PyTorch implementation using <a href="./fp16#scaled-dot-product-attention">scaled_dot_product_attention</a></td></tr> <tr><td>xFormers</td> <td>memory-efficient attention with support for various attention kernels</td></tr></tbody>',st,_,Wt="This guide will show you how to set and use the different attention backends.",ot,J,it,v,At='The <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> method iterates through all the modules in the model and sets the appropriate attention backend to use. The attention backend setting persists until <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a> is called.',dt,j,Qt='The example below demonstrates how to enable the <code>_flash_3_hub</code> implementation for FlashAttention-3 from the <a href="https://github.com/huggingface/kernels" rel="nofollow">kernel</a> library, which allows you to instantly use optimized compute kernels from the Hub without requiring any setup.',rt,y,Ht="<p>FlashAttention-3 is not supported for non-Hopper architectures, in which case, use FlashAttention with <code>set_attention_backend(&quot;flash&quot;)</code>.</p>",ct,$,pt,C,Pt='To restore the default attention backend, call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a>.',ht,B,mt,Z,ft,I,Yt='The <a href="https://github.com/huggingface/diffusers/blob/5e181eddfe7e44c1444a2511b0d8e21d177850a0/src/diffusers/models/attention_dispatch.py#L225" rel="nofollow">attention_backend</a> context manager temporarily sets an attention backend for a model within the context. Outside the context, the default attention (PyTorch’s native scaled dot product attention) is used. This is useful if you want to use different backends for different parts of a pipeline or if you want to test the different backends.',ut,S,bt,M,Et="<p>Most attention backends support <code>torch.compile</code> without graph breaks and can be used to further speed up inference.</p>",yt,G,Mt,x,Rt="The attention dispatcher includes debugging checks that catch common errors before they cause problems.",wt,F,qt="<li>Device checks verify that query, key, and value tensors live on the same device.</li> <li>Data type checks confirm tensors have matching dtypes and use either bfloat16 or float16.</li> <li>Shape checks validate tensor dimensions and prevent mixing attention masks with causal flags.</li>",Tt,W,Xt="Enable these checks by setting the <code>DIFFUSERS_ATTN_CHECKS</code> environment variable. Checks add overhead to every attention operation, so they’re disabled by default.",gt,A,kt,Q,Nt="The checks are run now before every attention operation.",Ut,H,_t,P,Lt="You can also configure the registry directly.",Jt,Y,vt,E,jt,R,Vt="Refer to the table below for a complete list of available attention backends and their variants.",$t,q,Dt='<summary>Expand</summary> <table><thead><tr><th>Backend Name</th> <th>Family</th> <th>Description</th></tr></thead> <tbody><tr><td><code>native</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Default backend using PyTorch’s scaled_dot_product_attention</td></tr> <tr><td><code>flex</code></td> <td><a href="https://docs.pytorch.org/docs/stable/nn.attention.flex_attention.html#module-torch.nn.attention.flex_attention" rel="nofollow">FlexAttention</a></td> <td>PyTorch FlexAttention implementation</td></tr> <tr><td><code>_native_cudnn</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>CuDNN-optimized attention</td></tr> <tr><td><code>_native_efficient</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Memory-efficient attention</td></tr> <tr><td><code>_native_flash</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>PyTorch’s FlashAttention</td></tr> <tr><td><code>_native_math</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Math-based attention (fallback)</td></tr> <tr><td><code>_native_npu</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>NPU-optimized attention</td></tr> <tr><td><code>_native_xla</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>XLA-optimized attention</td></tr> <tr><td><code>flash</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-2</td></tr> <tr><td><code>flash_varlen</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention</td></tr> <tr><td><code>_flash_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3</td></tr> <tr><td><code>_flash_varlen_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention-3</td></tr> <tr><td><code>_flash_3_hub</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3 from kernels</td></tr> <tr><td><code>sage</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Quantized attention (INT8 QK)</td></tr> <tr><td><code>sage_varlen</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Variable length SageAttention</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda_sm90</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (SM90)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_triton</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (Triton)</td></tr> <tr><td><code>xformers</code></td> <td><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a></td> <td>Memory-efficient attention</td></tr></tbody></table>',Ct,X,Bt,V,Zt;return w=new se({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new z({props:{title:"Attention backends",local:"attention-backends",headingTag:"h1"}}),J=new z({props:{title:"set_attention_backend",local:"setattentionbackend",headingTag:"h2"}}),$=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS50cmFuc2Zvcm1lci5zZXRfYXR0ZW50aW9uX2JhY2tlbmQoJTIyX2ZsYXNoXzNfaHViJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUwQWNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTBBaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTBBJTIyJTIyJTIyJTBBcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),B=new N({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIucmVzZXRfYXR0ZW50aW9uX2JhY2tlbmQoKQ==",highlighted:"pipeline.transformer.reset_attention_backend()",wrap:!1}}),Z=new z({props:{title:"attention_backend context manager",local:"attentionbackend-context-manager",headingTag:"h2"}}),S=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSUwQXdpdGglMjBhdHRlbnRpb25fYmFja2VuZCglMjJfZmxhc2hfM19odWIlMjIpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

<span class="hljs-keyword">with</span> attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>):
    image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),G=new z({props:{title:"Checks",local:"checks",headingTag:"h2"}}),A=new N({props:{code:"ZXhwb3J0JTIwRElGRlVTRVJTX0FUVE5fQ0hFQ0tTJTNEeWVz",highlighted:'<span class="hljs-built_in">export</span> DIFFUSERS_ATTN_CHECKS=<span class="hljs-built_in">yes</span>',wrap:!1}}),H=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFxdWVyeSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAxMCUyQyUyMDglMkMlMjA2NCUyQyUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQWtleSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAxMCUyQyUyMDglMkMlMjA2NCUyQyUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXZhbHVlJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDEwJTJDJTIwOCUyQyUyMDY0JTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTBBJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGF0dGVudGlvbl9iYWNrZW5kKCUyMmZsYXNoJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMGRpc3BhdGNoX2F0dGVudGlvbl9mbihxdWVyeSUyQyUyMGtleSUyQyUyMHZhbHVlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QyU5MyUyMEZsYXNoJTIwQXR0ZW50aW9uJTIwd29ya3MlMjB3aXRoJTIwY2hlY2tzJTIwZW5hYmxlZCUyMiklMEFleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlDJTk3JTIwRmxhc2glMjBBdHRlbnRpb24lMjBmYWlsZWQlM0ElMjAlN0JlJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

query = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, dtype=torch.bfloat16, device=<span class="hljs-string">&quot;cuda&quot;</span>)
key = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, dtype=torch.bfloat16, device=<span class="hljs-string">&quot;cuda&quot;</span>)
value = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, dtype=torch.bfloat16, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">try</span>:
    <span class="hljs-keyword">with</span> attention_backend(<span class="hljs-string">&quot;flash&quot;</span>):
        output = dispatch_attention_fn(query, key, value)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✓ Flash Attention works with checks enabled&quot;</span>)
<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✗ Flash Attention failed: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),Y=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2RlbHMuYXR0ZW50aW9uX2Rpc3BhdGNoJTIwaW1wb3J0JTIwX0F0dGVudGlvbkJhY2tlbmRSZWdpc3RyeSUwQSUwQV9BdHRlbnRpb25CYWNrZW5kUmVnaXN0cnkuX2NoZWNrc19lbmFibGVkJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers.models.attention_dispatch <span class="hljs-keyword">import</span> _AttentionBackendRegistry

_AttentionBackendRegistry._checks_enabled = <span class="hljs-literal">True</span>`,wrap:!1}}),E=new z({props:{title:"Available backends",local:"available-backends",headingTag:"h2"}}),X=new oe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/attention_backends.md"}}),{c(){u=o("meta"),K=l(),L=o("p"),O=l(),r(w.$$.fragment),tt=l(),r(T.$$.fragment),et=l(),b=o("blockquote"),b.innerHTML=St,nt=l(),g=o("p"),g.innerHTML=Gt,at=l(),k=o("p"),k.innerHTML=xt,lt=l(),U=o("table"),U.innerHTML=Ft,st=l(),_=o("p"),_.textContent=Wt,ot=l(),r(J.$$.fragment),it=l(),v=o("p"),v.innerHTML=At,dt=l(),j=o("p"),j.innerHTML=Qt,rt=l(),y=o("blockquote"),y.innerHTML=Ht,ct=l(),r($.$$.fragment),pt=l(),C=o("p"),C.innerHTML=Pt,ht=l(),r(B.$$.fragment),mt=l(),r(Z.$$.fragment),ft=l(),I=o("p"),I.innerHTML=Yt,ut=l(),r(S.$$.fragment),bt=l(),M=o("blockquote"),M.innerHTML=Et,yt=l(),r(G.$$.fragment),Mt=l(),x=o("p"),x.textContent=Rt,wt=l(),F=o("ol"),F.innerHTML=qt,Tt=l(),W=o("p"),W.innerHTML=Xt,gt=l(),r(A.$$.fragment),kt=l(),Q=o("p"),Q.textContent=Nt,Ut=l(),r(H.$$.fragment),_t=l(),P=o("p"),P.textContent=Lt,Jt=l(),r(Y.$$.fragment),vt=l(),r(E.$$.fragment),jt=l(),R=o("p"),R.textContent=Vt,$t=l(),q=o("details"),q.innerHTML=Dt,Ct=l(),r(X.$$.fragment),Bt=l(),V=o("p"),this.h()},l(t){const e=ae("svelte-u9bgzb",document.head);u=i(e,"META",{name:!0,content:!0}),e.forEach(n),K=s(t),L=i(t,"P",{}),zt(L).forEach(n),O=s(t),c(w.$$.fragment,t),tt=s(t),c(T.$$.fragment,t),et=s(t),b=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(b)!=="svelte-7ay7vy"&&(b.innerHTML=St),nt=s(t),g=i(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1p5wykf"&&(g.innerHTML=Gt),at=s(t),k=i(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-q2vvjg"&&(k.innerHTML=xt),lt=s(t),U=i(t,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-1eo6jrm"&&(U.innerHTML=Ft),st=s(t),_=i(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1o85kpy"&&(_.textContent=Wt),ot=s(t),c(J.$$.fragment,t),it=s(t),v=i(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-k822hv"&&(v.innerHTML=At),dt=s(t),j=i(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-142if5b"&&(j.innerHTML=Qt),rt=s(t),y=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(y)!=="svelte-j6ruup"&&(y.innerHTML=Ht),ct=s(t),c($.$$.fragment,t),pt=s(t),C=i(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-41vsbn"&&(C.innerHTML=Pt),ht=s(t),c(B.$$.fragment,t),mt=s(t),c(Z.$$.fragment,t),ft=s(t),I=i(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-g6fiju"&&(I.innerHTML=Yt),ut=s(t),c(S.$$.fragment,t),bt=s(t),M=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(M)!=="svelte-1mkj6ep"&&(M.innerHTML=Et),yt=s(t),c(G.$$.fragment,t),Mt=s(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-fodsmc"&&(x.textContent=Rt),wt=s(t),F=i(t,"OL",{"data-svelte-h":!0}),d(F)!=="svelte-1ylz7pk"&&(F.innerHTML=qt),Tt=s(t),W=i(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-nw9sbr"&&(W.innerHTML=Xt),gt=s(t),c(A.$$.fragment,t),kt=s(t),Q=i(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-9nu3ec"&&(Q.textContent=Nt),Ut=s(t),c(H.$$.fragment,t),_t=s(t),P=i(t,"P",{"data-svelte-h":!0}),d(P)!=="svelte-f6wmbe"&&(P.textContent=Lt),Jt=s(t),c(Y.$$.fragment,t),vt=s(t),c(E.$$.fragment,t),jt=s(t),R=i(t,"P",{"data-svelte-h":!0}),d(R)!=="svelte-frsh1o"&&(R.textContent=Vt),$t=s(t),q=i(t,"DETAILS",{"data-svelte-h":!0}),d(q)!=="svelte-1a11wal"&&(q.innerHTML=Dt),Ct=s(t),c(X.$$.fragment,t),Bt=s(t),V=i(t,"P",{}),zt(V).forEach(n),this.h()},h(){D(u,"name","hf:doc:metadata"),D(u,"content",de),D(b,"class","note"),D(y,"class","note"),D(M,"class","tip")},m(t,e){le(document.head,u),a(t,K,e),a(t,L,e),a(t,O,e),p(w,t,e),a(t,tt,e),p(T,t,e),a(t,et,e),a(t,b,e),a(t,nt,e),a(t,g,e),a(t,at,e),a(t,k,e),a(t,lt,e),a(t,U,e),a(t,st,e),a(t,_,e),a(t,ot,e),p(J,t,e),a(t,it,e),a(t,v,e),a(t,dt,e),a(t,j,e),a(t,rt,e),a(t,y,e),a(t,ct,e),p($,t,e),a(t,pt,e),a(t,C,e),a(t,ht,e),p(B,t,e),a(t,mt,e),p(Z,t,e),a(t,ft,e),a(t,I,e),a(t,ut,e),p(S,t,e),a(t,bt,e),a(t,M,e),a(t,yt,e),p(G,t,e),a(t,Mt,e),a(t,x,e),a(t,wt,e),a(t,F,e),a(t,Tt,e),a(t,W,e),a(t,gt,e),p(A,t,e),a(t,kt,e),a(t,Q,e),a(t,Ut,e),p(H,t,e),a(t,_t,e),a(t,P,e),a(t,Jt,e),p(Y,t,e),a(t,vt,e),p(E,t,e),a(t,jt,e),a(t,R,e),a(t,$t,e),a(t,q,e),a(t,Ct,e),p(X,t,e),a(t,Bt,e),a(t,V,e),Zt=!0},p:Ot,i(t){Zt||(h(w.$$.fragment,t),h(T.$$.fragment,t),h(J.$$.fragment,t),h($.$$.fragment,t),h(B.$$.fragment,t),h(Z.$$.fragment,t),h(S.$$.fragment,t),h(G.$$.fragment,t),h(A.$$.fragment,t),h(H.$$.fragment,t),h(Y.$$.fragment,t),h(E.$$.fragment,t),h(X.$$.fragment,t),Zt=!0)},o(t){m(w.$$.fragment,t),m(T.$$.fragment,t),m(J.$$.fragment,t),m($.$$.fragment,t),m(B.$$.fragment,t),m(Z.$$.fragment,t),m(S.$$.fragment,t),m(G.$$.fragment,t),m(A.$$.fragment,t),m(H.$$.fragment,t),m(Y.$$.fragment,t),m(E.$$.fragment,t),m(X.$$.fragment,t),Zt=!1},d(t){t&&(n(K),n(L),n(O),n(tt),n(et),n(b),n(nt),n(g),n(at),n(k),n(lt),n(U),n(st),n(_),n(ot),n(it),n(v),n(dt),n(j),n(rt),n(y),n(ct),n(pt),n(C),n(ht),n(mt),n(ft),n(I),n(ut),n(bt),n(M),n(yt),n(Mt),n(x),n(wt),n(F),n(Tt),n(W),n(gt),n(kt),n(Q),n(Ut),n(_t),n(P),n(Jt),n(vt),n(jt),n(R),n($t),n(q),n(Ct),n(Bt),n(V)),n(u),f(w,t),f(T,t),f(J,t),f($,t),f(B,t),f(Z,t),f(S,t),f(G,t),f(A,t),f(H,t),f(Y,t),f(E,t),f(X,t)}}}const de='{"title":"Attention backends","local":"attention-backends","sections":[{"title":"set_attention_backend","local":"setattentionbackend","sections":[],"depth":2},{"title":"attention_backend context manager","local":"attentionbackend-context-manager","sections":[],"depth":2},{"title":"Checks","local":"checks","sections":[],"depth":2},{"title":"Available backends","local":"available-backends","sections":[],"depth":2}],"depth":1}';function re(It){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends ee{constructor(u){super(),ne(this,u,re,ie,Kt,{})}}export{ue as component};
