import{s as ol,n as ul,o as cl}from"../chunks/scheduler.32f3c0d7.js";import{S as rl,i as dl,e as i,s as n,c as m,h as gl,a as p,d as s,b as a,f as ml,j as o,g as f,k as Se,l as Ml,m as l,n as u,t as c,o as r,p as d}from"../chunks/index.a3055d2a.js";import{C as hl,H as Ve,E as bl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.fc2fe68a.js";import{C as g}from"../chunks/CodeBlock.0cebd90b.js";import{D as yl}from"../chunks/DocNotebookDropdown.03988dd0.js";function jl(ds){let M,Xe,ze,Pe,$,Re,U,Ye,T,De,_,gs="拡散モデル(Diffusion Model)は、ランダムな正規分布から段階的にノイズ除去するように学習され、画像や音声などの目的のものを生成できます。これは生成AIに多大な関心を呼び起こしました。インターネット上で拡散によって生成された画像の例を見たことがあるでしょう。🧨 Diffusersは、誰もが拡散モデルに広くアクセスできるようにすることを目的としたライブラリです。",Ee,v,Ms="この案内では、開発者または日常的なユーザーに関わらず、🧨 Diffusers を紹介し、素早く目的のものを生成できるようにします！このライブラリには3つの主要コンポーネントがあります:",Qe,C,hs='<li><code>DiffusionPipeline</code>は事前に学習された拡散モデルからサンプルを迅速に生成するために設計された高レベルのエンドツーエンドクラス。</li> <li>拡散システムを作成するためのビルディングブロックとして使用できる、人気のある事前学習された<a href="./api/models">モデル</a>アーキテクチャとモジュール。</li> <li>多くの異なる<a href="./api/schedulers/overview">スケジューラ</a> - ノイズがどのようにトレーニングのために加えられるか、そして生成中にどのようにノイズ除去された画像を生成するかを制御するアルゴリズム。</li>',Fe,x,bs="この案内では、<code>DiffusionPipeline</code>を生成に使用する方法を紹介し、モデルとスケジューラを組み合わせて<code>DiffusionPipeline</code>の内部で起こっていることを再現する方法を説明します。",Ae,h,ys='<p>この案内は🧨 Diffusers <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/diffusers_intro.ipynb" rel="nofollow">ノートブック</a>を簡略化したもので、すぐに使い始めることができます。Diffusers 🧨のゴール、設計哲学、コアAPIの詳細についてもっと知りたい方は、ノートブックをご覧ください！</p>',Ke,J,js="始める前に必要なライブラリーがすべてインストールされていることを確認してください：",Oe,Z,et,k,ws='<li><a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a>生成とトレーニングのためのモデルのロードを高速化します</li> <li><a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>ような最も一般的な拡散モデルを実行するには、<a href="https://huggingface.co/docs/transformers/index" rel="nofollow">🤗 Transformers</a>が必要です。</li>',tt,G,st,W,$s='<code>DiffusionPipeline</code>は事前学習された拡散システムを生成に使用する最も簡単な方法です。これはモデルとスケジューラを含むエンドツーエンドのシステムです。<code>DiffusionPipeline</code>は多くの作業／タスクにすぐに使用することができます。また、サポートされているタスクの完全なリストについては<a href="./api/pipelines/overview#diffusers-summary">🧨Diffusersの概要</a>の表を参照してください。',lt,q,Us='<thead><tr><th><strong>タスク</strong></th> <th><strong>説明</strong></th> <th><strong>パイプライン</strong></th></tr></thead> <tbody><tr><td>Unconditional Image Generation</td> <td>正規分布から画像生成</td> <td><a href="./using-diffusers/unconditional_image_generation">unconditional_image_generation</a></td></tr> <tr><td>Text-Guided Image Generation</td> <td>文章から画像生成</td> <td><a href="./using-diffusers/conditional_image_generation">conditional_image_generation</a></td></tr> <tr><td>Text-Guided Image-to-Image Translation</td> <td>画像と文章から新たな画像生成</td> <td><a href="./using-diffusers/img2img">img2img</a></td></tr> <tr><td>Text-Guided Image-Inpainting</td> <td>画像、マスク、および文章が指定された場合に、画像のマスクされた部分を文章をもとに修復</td> <td><a href="./using-diffusers/inpaint">inpaint</a></td></tr> <tr><td>Text-Guided Depth-to-Image Translation</td> <td>文章と深度推定によって構造を保持しながら画像生成</td> <td><a href="./using-diffusers/depth2img">depth2img</a></td></tr></tbody>',nt,L,Ts=`まず、<code>DiffusionPipeline</code>のインスタンスを作成し、ダウンロードしたいパイプラインのチェックポイントを指定します。
この<code>DiffusionPipeline</code>はHugging Face Hubに保存されている任意の<a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">チェックポイント</a>を使用することができます。
この案内では、<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5</code></a>チェックポイントでテキストから画像へ生成します。`,at,H,_s='<p>[!WARNING][Stable Diffusion]モデルについては、モデルを実行する前にまず<a href="https://huggingface.co/spaces/CompVis/stable-diffusion-license" rel="nofollow">ライセンス</a>を注意深くお読みください。🧨  Diffusers は、攻撃的または有害なコンテンツを防ぐために <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow"><code>safety_checker</code></a> を実装していますが、モデルの改良された画像生成機能により、潜在的に有害なコンテンツが生成される可能性があります。</p>',it,I,vs="モデルを<code>from_pretrained()</code>メソッドでロードします：",pt,B,ft,S,Cs="<code>DiffusionPipeline</code>は全てのモデリング、トークン化、スケジューリングコンポーネントをダウンロードしてキャッシュします。Stable Diffusionパイプラインは<code>UNet2DConditionModel</code>と<code>PNDMScheduler</code>などで構成されています：",mt,V,ot,z,xs=`このモデルはおよそ14億個のパラメータで構成されているため、GPU上でパイプラインを実行することを強く推奨します。
PyTorchと同じように、ジェネレータオブジェクトをGPUに移すことができます：`,ut,N,ct,X,Js='これで、文章を <code>pipeline</code> に渡して画像を生成し、ノイズ除去された画像にアクセスできるようになりました。デフォルトでは、画像出力は<a href="https://pillow.readthedocs.io/en/stable/reference/Image.html?highlight=image#the-image-class" rel="nofollow"><code>PIL.Image</code></a>オブジェクトでラップされます。',rt,P,dt,b,Zs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/image_of_squirrel_painting.png"/>',gt,R,ks="<code>save</code>関数で画像を保存できます:",Mt,Y,ht,D,bt,E,Gs="ローカルでパイプラインを使用することもできます。唯一の違いは、最初にウェイトをダウンロードする必要があることです：",yt,Q,jt,F,Ws="保存したウェイトをパイプラインにロードします：",wt,A,$t,K,qs="これで、上のセクションと同じようにパイプラインを動かすことができます。",Ut,O,Tt,ee,Ls="スケジューラーによって、ノイズ除去のスピードや品質のトレードオフが異なります。どれが自分に最適かを知る最善の方法は、実際に試してみることです！Diffusers 🧨の主な機能の1つは、スケジューラを簡単に切り替えることができることです。例えば、デフォルトの<code>PNDMScheduler</code>を<code>EulerDiscreteScheduler</code>に置き換えるには、<code>from_config()</code>メソッドでロードできます：",_t,te,vt,se,Hs="新しいスケジューラを使って画像を生成し、その違いに気づくかどうか試してみてください！",Ct,le,Is="次のセクションでは、<code>DiffusionPipeline</code>を構成するコンポーネント（モデルとスケジューラ）を詳しく見て、これらのコンポーネントを使って猫の画像を生成する方法を学びます。",xt,ne,Jt,ae,Bs='ほとんどのモデルはノイズの多いサンプルを取り、各タイムステップで<em>残りのノイズ</em>を予測します（他のモデルは前のサンプルを直接予測するか、速度または<a href="https://github.com/huggingface/diffusers/blob/5e5ce13e2f89ac45a0066cb3f369462a3cf1d9ef/src/diffusers/schedulers/scheduling_ddim.py#L110" rel="nofollow"><code>v-prediction</code></a>を予測するように学習します）。モデルを混ぜて他の拡散システムを作ることもできます。',Zt,ie,Ss="モデルは<code>from_pretrained()</code>メソッドで開始されます。このメソッドはモデルをローカルにキャッシュするので、次にモデルをロードするときに高速になります。この案内では、<code>UNet2DModel</code>をロードします。これは基本的な画像生成モデルであり、猫画像で学習されたチェックポイントを使います：",kt,pe,Gt,fe,Vs="モデルのパラメータにアクセスするには、<code>model.config</code> を呼び出せます：",Wt,me,qt,oe,zs="モデル構成は🧊凍結🧊されたディクショナリであり、モデル作成後にこれらのパラメー タを変更することはできません。これは意図的なもので、最初にモデル・アーキテクチャを定義するために使用されるパラメータが同じままであることを保証します。他のパラメータは生成中に調整することができます。",Lt,ue,Ns="最も重要なパラメータは以下の通りです：",Ht,ce,Xs="<li>sample_size`: 入力サンプルの高さと幅。</li> <li><code>in_channels</code>: 入力サンプルの入力チャンネル数。</li> <li>down_block_types<code>と</code>up_block_types`: UNet アーキテクチャを作成するために使用されるダウンサンプリングブロックとアップサンプリングブロックのタイプ。</li> <li>block_out_channels`: ダウンサンプリングブロックの出力チャンネル数。逆順でアップサンプリングブロックの入力チャンネル数にも使用されます。</li> <li>layer_per_block`: 各 UNet ブロックに含まれる ResNet ブロックの数。</li>",It,re,Ps="このモデルを生成に使用するには、ランダムな画像の形の正規分布を作成します。このモデルは複数のランダムな正規分布を受け取ることができるため<code>batch</code>軸を入れます。入力チャンネル数に対応する<code>channel</code>軸も必要です。画像の高さと幅に対応する<code>sample_size</code>軸を持つ必要があります：",Bt,de,St,ge,Rs="画像生成には、ノイズの多い画像と <code>timestep</code> をモデルに渡します。<code>timestep</code>は入力画像がどの程度ノイズが多いかを示します。これは、モデルが拡散プロセスにおける自分の位置を決定するのに役立ちます。モデルの出力を得るには <code>sample</code> メソッドを使用します：",Vt,Me,zt,he,Ys="しかし、実際の例を生成するには、ノイズ除去プロセスをガイドするスケジューラが必要です。次のセクションでは、モデルをスケジューラと組み合わせる方法を学びます。",Nt,be,Xt,ye,Ds="スケジューラは、モデルの出力（この場合は <code>noisy_residual</code> ）が与えられたときに、ノイズの多いサンプルからノイズの少ないサンプルへの移行を管理します。",Pt,y,Es="<p>🧨 Diffusersは拡散システムを構築するためのツールボックスです。<code>DiffusionPipeline</code>は事前に構築された拡散システムを使い始めるのに便利な方法ですが、独自のモデルとスケジューラコンポーネントを個別に選択してカスタム拡散システムを構築することもできます。</p>",Rt,je,Qs="この案内では、<code>DDPMScheduler</code>を<code>from_config()</code>メソッドでインスタンス化します：",Yt,we,Dt,j,Fs="<p>💡 スケジューラがどのようにコンフィギュレーションからインスタンス化されるかに注目してください。モデルとは異なり、スケジューラは学習可能な重みを持たず、パラメーターを持ちません！</p>",Et,$e,As="最も重要なパラメータは以下の通りです：",Qt,Ue,Ks="<li>num_train_timesteps`: ノイズ除去処理の長さ、言い換えれば、ランダムな正規分布をデータサンプルに処理するのに必要なタイムステップ数です。</li> <li><code>beta_schedule</code>: 生成とトレーニングに使用するノイズスケジュールのタイプ。</li> <li><code>beta_start</code> と <code>beta_end</code>: ノイズスケジュールの開始値と終了値。</li>",Ft,Te,Os="少しノイズの少ない画像を予測するには、スケジューラの <code>step()</code> メソッドに以下を渡します: モデルの出力、<code>timestep</code>、現在の <code>sample</code>。",At,_e,Kt,ve,el="<code>less_noisy_sample</code>は次の<code>timestep</code>に渡すことができ、そこでさらにノイズが少なくなります！",Ot,Ce,tl="では、すべてをまとめて、ノイズ除去プロセス全体を視覚化してみましょう。",es,xe,sl="まず、ノイズ除去された画像を後処理して <code>PIL.Image</code> として表示する関数を作成します：",ts,Je,ss,Ze,ll="ノイズ除去処理を高速化するために入力とモデルをGPUに移します：",ls,ke,ns,Ge,nl="ここで、ノイズが少なくなったサンプルの残りのノイズを予測するノイズ除去ループを作成し、スケジューラを使ってさらにノイズの少ないサンプルを計算します：",as,We,is,qe,al="何もないところから猫が生成されるのを、座って見てください！😻",ps,w,il='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/diffusion-quicktour.png"/>',fs,Le,ms,He,pl="このクイックツアーで、🧨ディフューザーを使ったクールな画像をいくつか作成できたと思います！次のステップとして",os,Ie,fl='<li>モデルをトレーニングまたは微調整については、<a href="./tutorials/basic_training">training</a>チュートリアルを参照してください。</li> <li>様々な使用例については、公式およびコミュニティの<a href="https://github.com/huggingface/diffusers/tree/main/examples#-diffusers-examples" rel="nofollow">training or finetuning scripts</a>の例を参照してください。</li> <li>スケジューラのロード、アクセス、変更、比較については<a href="./using-diffusers/schedulers">Using different Schedulers</a>ガイドを参照してください。</li> <li>プロンプトエンジニアリング、スピードとメモリの最適化、より高品質な画像を生成するためのヒントやトリックについては、<a href="./stable_diffusion">Stable Diffusion</a>ガイドを参照してください。</li> <li>🧨 Diffusers の高速化については、最適化された <a href="./optimization/fp16">PyTorch on a GPU</a>のガイド、<a href="./optimization/mps">Stable Diffusion on Apple Silicon (M1/M2)</a>と<a href="./optimization/onnx">ONNX Runtime</a>を参照してください。</li>',us,Be,cs,Ne,rs;return $=new hl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new yl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/quicktour.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/quicktour.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/quicktour.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/quicktour.ipynb"}]}}),T=new Ve({props:{title:"簡単な案内",local:"簡単な案内",headingTag:"h1"}}),Z=new g({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwZGlmZnVzZXJzJTIwYWNjZWxlcmF0ZSUyMHRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install --upgrade diffusers accelerate transformers</span>`,wrap:!1}}),G=new Ve({props:{title:"拡散パイプライン",local:"拡散パイプライン",headingTag:"h2"}}),B=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new g({props:{code:"cGlwZWxpbmU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline
StableDiffusionPipeline {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  ...,
  <span class="hljs-string">&quot;scheduler&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  ],
  ...,
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  ],
  <span class="hljs-string">&quot;vae&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  ]
}`,wrap:!1}}),N=new g({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),P=new g({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(<span class="hljs-string">&quot;An image of a squirrel in Picasso style&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Y=new g({props:{code:"aW1hZ2Uuc2F2ZSglMjJpbWFnZV9vZl9zcXVpcnJlbF9wYWludGluZy5wbmclMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;image_of_squirrel_painting.png&quot;</span>)',wrap:!1}}),D=new Ve({props:{title:"ローカルパイプライン",local:"ローカルパイプライン",headingTag:"h3"}}),Q=new g({props:{code:"IWdpdCUyMGxmcyUyMGluc3RhbGwlMEEhZ2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01",highlighted:`!git lfs install
!git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),A=new g({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)',wrap:!1}}),O=new Ve({props:{title:"スケジューラの交換",local:"スケジューラの交換",headingTag:"h3"}}),te=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),ne=new Ve({props:{title:"モデル",local:"モデル",headingTag:"h2"}}),pe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new g({props:{code:"bW9kZWwuY29uZmln",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config',wrap:!1}}),de=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQW5vaXN5X3NhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjBtb2RlbC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUpJTBBbm9pc3lfc2FtcGxlLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = torch.randn(<span class="hljs-number">1</span>, model.config.in_channels, model.config.sample_size, model.config.sample_size)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),Me=new g({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5vaXN5X3Jlc2lkdWFsJTIwJTNEJTIwbW9kZWwoc2FtcGxlJTNEbm9pc3lfc2FtcGxlJTJDJTIwdGltZXN0ZXAlM0QyKS5zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    noisy_residual = model(sample=noisy_sample, timestep=<span class="hljs-number">2</span>).sample`,wrap:!1}}),be=new Ve({props:{title:"スケジューラ",local:"スケジューラ",headingTag:"h2"}}),we=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fY29uZmlnKHJlcG9faWQpJTBBc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_config(repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler
DDPMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;DDPMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.02</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.0001</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: true,
  <span class="hljs-string">&quot;clip_sample_range&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;prediction_type&quot;</span>: <span class="hljs-string">&quot;epsilon&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: null,
  <span class="hljs-string">&quot;variance_type&quot;</span>: <span class="hljs-string">&quot;fixed_small&quot;</span>
}`,wrap:!1}}),_e=new g({props:{code:"bGVzc19ub2lzeV9zYW1wbGUlMjAlM0QlMjBzY2hlZHVsZXIuc3RlcChtb2RlbF9vdXRwdXQlM0Rub2lzeV9yZXNpZHVhbCUyQyUyMHRpbWVzdGVwJTNEMiUyQyUyMHNhbXBsZSUzRG5vaXN5X3NhbXBsZSkucHJldl9zYW1wbGUlMEFsZXNzX25vaXN5X3NhbXBsZS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample = scheduler.step(model_output=noisy_residual, timestep=<span class="hljs-number">2</span>, sample=noisy_sample).prev_sample
<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample.shape`,wrap:!1}}),Je=new g({props:{code:"aW1wb3J0JTIwUElMLkltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZGlzcGxheV9zYW1wbGUoc2FtcGxlJTJDJTIwaSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9wcm9jZXNzZWQlMjAlM0QlMjBzYW1wbGUuY3B1KCkucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMGltYWdlX3Byb2Nlc3NlZCUyMCUzRCUyMChpbWFnZV9wcm9jZXNzZWQlMjAlMkIlMjAxLjApJTIwKiUyMDEyNy41JTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc2VkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc2VkLm51bXB5KCkuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMCUyMGltYWdlX3BpbCUyMCUzRCUyMFBJTC5JbWFnZS5mcm9tYXJyYXkoaW1hZ2VfcHJvY2Vzc2VkJTVCMCU1RCklMEElMjAlMjAlMjAlMjBkaXNwbGF5KGYlMjJJbWFnZSUyMGF0JTIwc3RlcCUyMCU3QmklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZGlzcGxheShpbWFnZV9waWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL.Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_sample</span>(<span class="hljs-params">sample, i</span>):
<span class="hljs-meta">... </span>    image_processed = sample.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_processed = (image_processed + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>
<span class="hljs-meta">... </span>    image_processed = image_processed.numpy().astype(np.uint8)

<span class="hljs-meta">... </span>    image_pil = PIL.Image.fromarray(image_processed[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    display(<span class="hljs-string">f&quot;Image at step <span class="hljs-subst">{i}</span>&quot;</span>)
<span class="hljs-meta">... </span>    display(image_pil)`,wrap:!1}}),ke=new g({props:{code:"bW9kZWwudG8oJTIyY3VkYSUyMiklMEFub2lzeV9zYW1wbGUlMjAlM0QlMjBub2lzeV9zYW1wbGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = noisy_sample.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),We=new g({props:{code:"aW1wb3J0JTIwdHFkbSUwQSUwQXNhbXBsZSUyMCUzRCUyMG5vaXN5X3NhbXBsZSUwQSUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjBlbnVtZXJhdGUodHFkbS50cWRtKHNjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwcHJlZGljdCUyMG5vaXNlJTIwcmVzaWR1YWwlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChzYW1wbGUlMkMlMjB0KS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAyLiUyMGNvbXB1dGUlMjBsZXNzJTIwbm9pc3klMjBpbWFnZSUyMGFuZCUyMHNldCUyMHhfdCUyMC0lM0UlMjB4X3QtMSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHNhbXBsZSkucHJldl9zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMG9wdGlvbmFsbHklMjBsb29rJTIwYXQlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMGlmJTIwKGklMjAlMkIlMjAxKSUyMCUyNSUyMDUwJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3BsYXlfc2FtcGxlKHNhbXBsZSUyQyUyMGklMjAlMkIlMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>sample = noisy_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm.tqdm(scheduler.timesteps)):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># 1. predict noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = model(sample, t).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 2. compute less noisy image and set x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    sample = scheduler.step(residual, t, sample).prev_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 3. optionally look at image</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> (i + <span class="hljs-number">1</span>) % <span class="hljs-number">50</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        display_sample(sample, i + <span class="hljs-number">1</span>)`,wrap:!1}}),Le=new Ve({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),Be=new bl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ja/quicktour.md"}}),{c(){M=i("meta"),Xe=n(),ze=i("p"),Pe=n(),m($.$$.fragment),Re=n(),m(U.$$.fragment),Ye=n(),m(T.$$.fragment),De=n(),_=i("p"),_.textContent=gs,Ee=n(),v=i("p"),v.textContent=Ms,Qe=n(),C=i("ul"),C.innerHTML=hs,Fe=n(),x=i("p"),x.innerHTML=bs,Ae=n(),h=i("blockquote"),h.innerHTML=ys,Ke=n(),J=i("p"),J.textContent=js,Oe=n(),m(Z.$$.fragment),et=n(),k=i("ul"),k.innerHTML=ws,tt=n(),m(G.$$.fragment),st=n(),W=i("p"),W.innerHTML=$s,lt=n(),q=i("table"),q.innerHTML=Us,nt=n(),L=i("p"),L.innerHTML=Ts,at=n(),H=i("blockquote"),H.innerHTML=_s,it=n(),I=i("p"),I.innerHTML=vs,pt=n(),m(B.$$.fragment),ft=n(),S=i("p"),S.innerHTML=Cs,mt=n(),m(V.$$.fragment),ot=n(),z=i("p"),z.textContent=xs,ut=n(),m(N.$$.fragment),ct=n(),X=i("p"),X.innerHTML=Js,rt=n(),m(P.$$.fragment),dt=n(),b=i("div"),b.innerHTML=Zs,gt=n(),R=i("p"),R.innerHTML=ks,Mt=n(),m(Y.$$.fragment),ht=n(),m(D.$$.fragment),bt=n(),E=i("p"),E.textContent=Gs,yt=n(),m(Q.$$.fragment),jt=n(),F=i("p"),F.textContent=Ws,wt=n(),m(A.$$.fragment),$t=n(),K=i("p"),K.textContent=qs,Ut=n(),m(O.$$.fragment),Tt=n(),ee=i("p"),ee.innerHTML=Ls,_t=n(),m(te.$$.fragment),vt=n(),se=i("p"),se.textContent=Hs,Ct=n(),le=i("p"),le.innerHTML=Is,xt=n(),m(ne.$$.fragment),Jt=n(),ae=i("p"),ae.innerHTML=Bs,Zt=n(),ie=i("p"),ie.innerHTML=Ss,kt=n(),m(pe.$$.fragment),Gt=n(),fe=i("p"),fe.innerHTML=Vs,Wt=n(),m(me.$$.fragment),qt=n(),oe=i("p"),oe.textContent=zs,Lt=n(),ue=i("p"),ue.textContent=Ns,Ht=n(),ce=i("ul"),ce.innerHTML=Xs,It=n(),re=i("p"),re.innerHTML=Ps,Bt=n(),m(de.$$.fragment),St=n(),ge=i("p"),ge.innerHTML=Rs,Vt=n(),m(Me.$$.fragment),zt=n(),he=i("p"),he.textContent=Ys,Nt=n(),m(be.$$.fragment),Xt=n(),ye=i("p"),ye.innerHTML=Ds,Pt=n(),y=i("blockquote"),y.innerHTML=Es,Rt=n(),je=i("p"),je.innerHTML=Qs,Yt=n(),m(we.$$.fragment),Dt=n(),j=i("blockquote"),j.innerHTML=Fs,Et=n(),$e=i("p"),$e.textContent=As,Qt=n(),Ue=i("ul"),Ue.innerHTML=Ks,Ft=n(),Te=i("p"),Te.innerHTML=Os,At=n(),m(_e.$$.fragment),Kt=n(),ve=i("p"),ve.innerHTML=el,Ot=n(),Ce=i("p"),Ce.textContent=tl,es=n(),xe=i("p"),xe.innerHTML=sl,ts=n(),m(Je.$$.fragment),ss=n(),Ze=i("p"),Ze.textContent=ll,ls=n(),m(ke.$$.fragment),ns=n(),Ge=i("p"),Ge.textContent=nl,as=n(),m(We.$$.fragment),is=n(),qe=i("p"),qe.textContent=al,ps=n(),w=i("div"),w.innerHTML=il,fs=n(),m(Le.$$.fragment),ms=n(),He=i("p"),He.textContent=pl,os=n(),Ie=i("ul"),Ie.innerHTML=fl,us=n(),m(Be.$$.fragment),cs=n(),Ne=i("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(s),Xe=a(e),ze=p(e,"P",{}),ml(ze).forEach(s),Pe=a(e),o($.$$.fragment,e),Re=a(e),o(U.$$.fragment,e),Ye=a(e),o(T.$$.fragment,e),De=a(e),_=p(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-8fww4q"&&(_.textContent=gs),Ee=a(e),v=p(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1jcd1kt"&&(v.textContent=Ms),Qe=a(e),C=p(e,"UL",{"data-svelte-h":!0}),f(C)!=="svelte-q05j96"&&(C.innerHTML=hs),Fe=a(e),x=p(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-11en9bt"&&(x.innerHTML=bs),Ae=a(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(h)!=="svelte-e0e6mc"&&(h.innerHTML=ys),Ke=a(e),J=p(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-vu4fy1"&&(J.textContent=js),Oe=a(e),o(Z.$$.fragment,e),et=a(e),k=p(e,"UL",{"data-svelte-h":!0}),f(k)!=="svelte-127wkj3"&&(k.innerHTML=ws),tt=a(e),o(G.$$.fragment,e),st=a(e),W=p(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-17sg266"&&(W.innerHTML=$s),lt=a(e),q=p(e,"TABLE",{"data-svelte-h":!0}),f(q)!=="svelte-ihh3bo"&&(q.innerHTML=Us),nt=a(e),L=p(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1asnlw6"&&(L.innerHTML=Ts),at=a(e),H=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),f(H)!=="svelte-1v1hy7k"&&(H.innerHTML=_s),it=a(e),I=p(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-9217qk"&&(I.innerHTML=vs),pt=a(e),o(B.$$.fragment,e),ft=a(e),S=p(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-1kkhsyn"&&(S.innerHTML=Cs),mt=a(e),o(V.$$.fragment,e),ot=a(e),z=p(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-vs77ec"&&(z.textContent=xs),ut=a(e),o(N.$$.fragment,e),ct=a(e),X=p(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1s6yxe6"&&(X.innerHTML=Js),rt=a(e),o(P.$$.fragment,e),dt=a(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),f(b)!=="svelte-6cjtp1"&&(b.innerHTML=Zs),gt=a(e),R=p(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1njwl3p"&&(R.innerHTML=ks),Mt=a(e),o(Y.$$.fragment,e),ht=a(e),o(D.$$.fragment,e),bt=a(e),E=p(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-ym515z"&&(E.textContent=Gs),yt=a(e),o(Q.$$.fragment,e),jt=a(e),F=p(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-c2ekdz"&&(F.textContent=Ws),wt=a(e),o(A.$$.fragment,e),$t=a(e),K=p(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1w7rorw"&&(K.textContent=qs),Ut=a(e),o(O.$$.fragment,e),Tt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-doj56"&&(ee.innerHTML=Ls),_t=a(e),o(te.$$.fragment,e),vt=a(e),se=p(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-1dfll12"&&(se.textContent=Hs),Ct=a(e),le=p(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-qz8594"&&(le.innerHTML=Is),xt=a(e),o(ne.$$.fragment,e),Jt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-m81eak"&&(ae.innerHTML=Bs),Zt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-z93j1x"&&(ie.innerHTML=Ss),kt=a(e),o(pe.$$.fragment,e),Gt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-zg39xw"&&(fe.innerHTML=Vs),Wt=a(e),o(me.$$.fragment,e),qt=a(e),oe=p(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-duc30n"&&(oe.textContent=zs),Lt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-xh79f3"&&(ue.textContent=Ns),Ht=a(e),ce=p(e,"UL",{"data-svelte-h":!0}),f(ce)!=="svelte-vjxthd"&&(ce.innerHTML=Xs),It=a(e),re=p(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-1wu3gqi"&&(re.innerHTML=Ps),Bt=a(e),o(de.$$.fragment,e),St=a(e),ge=p(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-tfiut1"&&(ge.innerHTML=Rs),Vt=a(e),o(Me.$$.fragment,e),zt=a(e),he=p(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-10p45zu"&&(he.textContent=Ys),Nt=a(e),o(be.$$.fragment,e),Xt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1ln9s03"&&(ye.innerHTML=Ds),Pt=a(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(y)!=="svelte-9g21wf"&&(y.innerHTML=Es),Rt=a(e),je=p(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-14qd3e5"&&(je.innerHTML=Qs),Yt=a(e),o(we.$$.fragment,e),Dt=a(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(j)!=="svelte-19ufcj6"&&(j.innerHTML=Fs),Et=a(e),$e=p(e,"P",{"data-svelte-h":!0}),f($e)!=="svelte-xh79f3"&&($e.textContent=As),Qt=a(e),Ue=p(e,"UL",{"data-svelte-h":!0}),f(Ue)!=="svelte-1kldhq3"&&(Ue.innerHTML=Ks),Ft=a(e),Te=p(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-fc38zg"&&(Te.innerHTML=Os),At=a(e),o(_e.$$.fragment,e),Kt=a(e),ve=p(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-17613xv"&&(ve.innerHTML=el),Ot=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-1ooe71"&&(Ce.textContent=tl),es=a(e),xe=p(e,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-2ptaov"&&(xe.innerHTML=sl),ts=a(e),o(Je.$$.fragment,e),ss=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-kqyg05"&&(Ze.textContent=ll),ls=a(e),o(ke.$$.fragment,e),ns=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-znv8iz"&&(Ge.textContent=nl),as=a(e),o(We.$$.fragment,e),is=a(e),qe=p(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-ss97vg"&&(qe.textContent=al),ps=a(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),f(w)!=="svelte-1yzsrw6"&&(w.innerHTML=il),fs=a(e),o(Le.$$.fragment,e),ms=a(e),He=p(e,"P",{"data-svelte-h":!0}),f(He)!=="svelte-16pa74u"&&(He.textContent=pl),os=a(e),Ie=p(e,"UL",{"data-svelte-h":!0}),f(Ie)!=="svelte-1awshj"&&(Ie.innerHTML=fl),us=a(e),o(Be.$$.fragment,e),cs=a(e),Ne=p(e,"P",{}),ml(Ne).forEach(s),this.h()},h(){Se(M,"name","hf:doc:metadata"),Se(M,"content",wl),Se(h,"class","tip"),Se(b,"class","flex justify-center"),Se(y,"class","tip"),Se(j,"class","tip"),Se(w,"class","flex justify-center")},m(e,t){Ml(document.head,M),l(e,Xe,t),l(e,ze,t),l(e,Pe,t),u($,e,t),l(e,Re,t),u(U,e,t),l(e,Ye,t),u(T,e,t),l(e,De,t),l(e,_,t),l(e,Ee,t),l(e,v,t),l(e,Qe,t),l(e,C,t),l(e,Fe,t),l(e,x,t),l(e,Ae,t),l(e,h,t),l(e,Ke,t),l(e,J,t),l(e,Oe,t),u(Z,e,t),l(e,et,t),l(e,k,t),l(e,tt,t),u(G,e,t),l(e,st,t),l(e,W,t),l(e,lt,t),l(e,q,t),l(e,nt,t),l(e,L,t),l(e,at,t),l(e,H,t),l(e,it,t),l(e,I,t),l(e,pt,t),u(B,e,t),l(e,ft,t),l(e,S,t),l(e,mt,t),u(V,e,t),l(e,ot,t),l(e,z,t),l(e,ut,t),u(N,e,t),l(e,ct,t),l(e,X,t),l(e,rt,t),u(P,e,t),l(e,dt,t),l(e,b,t),l(e,gt,t),l(e,R,t),l(e,Mt,t),u(Y,e,t),l(e,ht,t),u(D,e,t),l(e,bt,t),l(e,E,t),l(e,yt,t),u(Q,e,t),l(e,jt,t),l(e,F,t),l(e,wt,t),u(A,e,t),l(e,$t,t),l(e,K,t),l(e,Ut,t),u(O,e,t),l(e,Tt,t),l(e,ee,t),l(e,_t,t),u(te,e,t),l(e,vt,t),l(e,se,t),l(e,Ct,t),l(e,le,t),l(e,xt,t),u(ne,e,t),l(e,Jt,t),l(e,ae,t),l(e,Zt,t),l(e,ie,t),l(e,kt,t),u(pe,e,t),l(e,Gt,t),l(e,fe,t),l(e,Wt,t),u(me,e,t),l(e,qt,t),l(e,oe,t),l(e,Lt,t),l(e,ue,t),l(e,Ht,t),l(e,ce,t),l(e,It,t),l(e,re,t),l(e,Bt,t),u(de,e,t),l(e,St,t),l(e,ge,t),l(e,Vt,t),u(Me,e,t),l(e,zt,t),l(e,he,t),l(e,Nt,t),u(be,e,t),l(e,Xt,t),l(e,ye,t),l(e,Pt,t),l(e,y,t),l(e,Rt,t),l(e,je,t),l(e,Yt,t),u(we,e,t),l(e,Dt,t),l(e,j,t),l(e,Et,t),l(e,$e,t),l(e,Qt,t),l(e,Ue,t),l(e,Ft,t),l(e,Te,t),l(e,At,t),u(_e,e,t),l(e,Kt,t),l(e,ve,t),l(e,Ot,t),l(e,Ce,t),l(e,es,t),l(e,xe,t),l(e,ts,t),u(Je,e,t),l(e,ss,t),l(e,Ze,t),l(e,ls,t),u(ke,e,t),l(e,ns,t),l(e,Ge,t),l(e,as,t),u(We,e,t),l(e,is,t),l(e,qe,t),l(e,ps,t),l(e,w,t),l(e,fs,t),u(Le,e,t),l(e,ms,t),l(e,He,t),l(e,os,t),l(e,Ie,t),l(e,us,t),u(Be,e,t),l(e,cs,t),l(e,Ne,t),rs=!0},p:ul,i(e){rs||(c($.$$.fragment,e),c(U.$$.fragment,e),c(T.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(P.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(de.$$.fragment,e),c(Me.$$.fragment,e),c(be.$$.fragment,e),c(we.$$.fragment,e),c(_e.$$.fragment,e),c(Je.$$.fragment,e),c(ke.$$.fragment,e),c(We.$$.fragment,e),c(Le.$$.fragment,e),c(Be.$$.fragment,e),rs=!0)},o(e){r($.$$.fragment,e),r(U.$$.fragment,e),r(T.$$.fragment,e),r(Z.$$.fragment,e),r(G.$$.fragment,e),r(B.$$.fragment,e),r(V.$$.fragment,e),r(N.$$.fragment,e),r(P.$$.fragment,e),r(Y.$$.fragment,e),r(D.$$.fragment,e),r(Q.$$.fragment,e),r(A.$$.fragment,e),r(O.$$.fragment,e),r(te.$$.fragment,e),r(ne.$$.fragment,e),r(pe.$$.fragment,e),r(me.$$.fragment,e),r(de.$$.fragment,e),r(Me.$$.fragment,e),r(be.$$.fragment,e),r(we.$$.fragment,e),r(_e.$$.fragment,e),r(Je.$$.fragment,e),r(ke.$$.fragment,e),r(We.$$.fragment,e),r(Le.$$.fragment,e),r(Be.$$.fragment,e),rs=!1},d(e){e&&(s(Xe),s(ze),s(Pe),s(Re),s(Ye),s(De),s(_),s(Ee),s(v),s(Qe),s(C),s(Fe),s(x),s(Ae),s(h),s(Ke),s(J),s(Oe),s(et),s(k),s(tt),s(st),s(W),s(lt),s(q),s(nt),s(L),s(at),s(H),s(it),s(I),s(pt),s(ft),s(S),s(mt),s(ot),s(z),s(ut),s(ct),s(X),s(rt),s(dt),s(b),s(gt),s(R),s(Mt),s(ht),s(bt),s(E),s(yt),s(jt),s(F),s(wt),s($t),s(K),s(Ut),s(Tt),s(ee),s(_t),s(vt),s(se),s(Ct),s(le),s(xt),s(Jt),s(ae),s(Zt),s(ie),s(kt),s(Gt),s(fe),s(Wt),s(qt),s(oe),s(Lt),s(ue),s(Ht),s(ce),s(It),s(re),s(Bt),s(St),s(ge),s(Vt),s(zt),s(he),s(Nt),s(Xt),s(ye),s(Pt),s(y),s(Rt),s(je),s(Yt),s(Dt),s(j),s(Et),s($e),s(Qt),s(Ue),s(Ft),s(Te),s(At),s(Kt),s(ve),s(Ot),s(Ce),s(es),s(xe),s(ts),s(ss),s(Ze),s(ls),s(ns),s(Ge),s(as),s(is),s(qe),s(ps),s(w),s(fs),s(ms),s(He),s(os),s(Ie),s(us),s(cs),s(Ne)),s(M),d($,e),d(U,e),d(T,e),d(Z,e),d(G,e),d(B,e),d(V,e),d(N,e),d(P,e),d(Y,e),d(D,e),d(Q,e),d(A,e),d(O,e),d(te,e),d(ne,e),d(pe,e),d(me,e),d(de,e),d(Me,e),d(be,e),d(we,e),d(_e,e),d(Je,e),d(ke,e),d(We,e),d(Le,e),d(Be,e)}}}const wl='{"title":"簡単な案内","local":"簡単な案内","sections":[{"title":"拡散パイプライン","local":"拡散パイプライン","sections":[{"title":"ローカルパイプライン","local":"ローカルパイプライン","sections":[],"depth":3},{"title":"スケジューラの交換","local":"スケジューラの交換","sections":[],"depth":3}],"depth":2},{"title":"モデル","local":"モデル","sections":[],"depth":2},{"title":"スケジューラ","local":"スケジューラ","sections":[],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2}],"depth":1}';function $l(ds){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends rl{constructor(M){super(),dl(this,M,$l,jl,ol,{})}}export{xl as component};
