import{s as cs,o as us,n as Tt}from"../chunks/scheduler.9039eef2.js";import{S as ms,i as Ts,g as i,s as a,r as M,A as ds,h as o,f as t,c as n,j as Ms,u as c,x as p,k as ut,y as hs,a as s,v as u,d as m,t as T,w as d}from"../chunks/index.cdcc3d35.js";import{T as mt}from"../chunks/Tip.6f74db41.js";import{C as U}from"../chunks/CodeBlock.e3ac94d9.js";import{H as w}from"../chunks/Heading.96ce3702.js";function ys(j){let r,y="While we will use <code>Llama-3 8B</code> in this tutorial, it is completely possible to use other models, simply by swtiching the <code>model_id</code>.";return{c(){r=i("p"),r.innerHTML=y},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-17hw35"&&(r.innerHTML=y)},m(h,J){s(h,r,J)},p:Tt,d(h){h&&t(r)}}}function Us(j){let r,y='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.';return{c(){r=i("p"),r.innerHTML=y},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-yp02re"&&(r.innerHTML=y)},m(h,J){s(h,r,J)},p:Tt,d(h){h&&t(r)}}}function Js(j){let r,y='To learn more about the caching system, and how you can create your own private cache repository, check this <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">guide</a>.';return{c(){r=i("p"),r.innerHTML=y},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-o0xds9"&&(r.innerHTML=y)},m(h,J){s(h,r,J)},p:Tt,d(h){h&&t(r)}}}function ws(j){let r,y="Make sure to run this precompilation phase for around 10 training steps. It is usually enough to accumulate and compile all the graphs that will be needed during the actual training.";return{c(){r=i("p"),r.textContent=y},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1k7qt99"&&(r.textContent=y)},m(h,J){s(h,r,J)},p:Tt,d(h){h&&t(r)}}}function js(j){let r,y,h,J,g,Qe,B,dt='<em>Note: The complete script for this tutorial can be downloaded <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/sft_lora_finetune_llm.py" rel="nofollow">here</a>.</em>',He,S,ht='This tutorial will teach you how to fine-tune open source LLMs like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow">Llama 3</a> on AWS Trainium. In our example, we are going to leverage the <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> libraries.',Le,V,yt="You will learn how to:",ze,R,Ut='<li><a href="#1-setup-aws-environment">Setup AWS Environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-supervised-fined-tuning-of-llama-on-aws-trainium-with-the-neuronsfttrainer">Supervised Fine-Tuning of Llama on AWS Trainium with the <code>NeuronSFTTrainer</code></a></li> <li><a href="#4-launch-training">Launch Training</a></li> <li><a href="#5-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',Ye,f,qe,A,Pe,v,Jt="Before starting this tutorial, you will need to setup your environment:",Oe,W,wt='<li>Create an AWS Trainium instance. <strong>You will need a <code>trn1.32xlarge</code>, which contains 16 Neuron Devices.</strong> You can follow this <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">guide</a> to create one.</li> <li>Make sure you are logged in on the Hugging Face Hub:</li>',De,Z,Ke,b,jt="<li>Check that you have access to the model. Some open source models are gated, meaning that users need to apply to the model owner to be able to use the model weights. Here we will be training Llama-3 8B, for which there are two possibilities:</li>",el,N,ft='<li>The official gated repo: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow"><code>meta-llama/Meta-Llama-3-8B</code></a></li> <li>The non-official un-gated repo: <a href="https://huggingface.co/NousResearch/Meta-Llama-3-8B" rel="nofollow"><code>NousResearch/Meta-Llama-3-8B</code></a></li>',ll,I,bt='<li>Clone the Optimum Neuron repository, <strong>which contains the <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/sft_lora_finetune_llm.py" rel="nofollow">complete script</a> described in this tutorial:</strong></li>',tl,F,sl,$,al,X,It='For this tutorial, we will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',nl,G,Ct="Example:",il,k,ol,x,_t="We can use the <code>load_dataset()</code> method from the 🤗 Datasets library to load the <code>dolly</code> dataset very easily.",pl,Q,rl,H,Et="To instruct fine-tune our model we need to:",Ml,L,gt=`<li><p>Convert our structured examples into collection of tasks described via instructions</p></li> <li><p>(Optional) Pack multiple examples to one sequence for more efficient training. In other words, we are stacking multiple examples into one example,
and split them with the EOS token.</p></li>`,cl,z,Bt="We could do this manually, but we will use the <code>NeuronSFTTrainer</code> instead.",ul,Y,ml,q,St='Normally you would use the <strong><a href="https://huggingface.co/docs/trl/main/en/sft_trainer#trl.SFTConfig" rel="nofollow">SFTConfig</a></strong> and <strong><a href="https://huggingface.co/docs/trl/main/en/sft_trainer" rel="nofollow">SFTTrainer</a></strong> classes to perform supervised fine-tuning of PyTorch-based transformer models.',Tl,P,Vt="Instead, here we will be using the <code>NeuronSFTConfig</code> and <code>NeuronSFTTrainer</code>. These classes replicate the ones from the <code>trl</code> library while making sure they work properly on Neuron cores.",dl,O,hl,D,Rt=`There are multiple ways to give a dataset to the <code>NeuronSFTTrainer</code>, and one of them consists in providing a formatting function.
For <code>dolly</code> without packing the examples it looks as follows:`,yl,K,Ul,ee,Jl,le,At="Since Llama-3 8B is a big model it will not fit on a single <code>trn1.32xlarge</code> instance, even with distributed training. To actually fine-tune a 8B model using only one Trainium instance we need to use both LoRA and distributed training.",wl,C,jl,te,vt=`Here, we will use tensor parallelism in conjuction with LoRA.
Our training code will look as follows:`,fl,se,bl,ae,Wt="The key points here are:",Il,ne,Zt="<li>We use the <code>lazy_load_for_parallelism</code> context manager to lazily load the model. This will not load the full model weights on each worker, but instead only load the required weights (sharded or full). <strong>This is much more memory efficient, and often mandatory to use.</strong></li> <li>We define a <code>LoraConfig</code> that specifies which layers should have adapters, and the hyperparameters for theses adapters.</li> <li>We create a <code>NeuronSFTConfig</code> from regular <code>NeuronTrainingArguments</code>. Here we specify that we do not want to pack our examples, and that the max sequence length should be <code>1024</code>, meaning that every example will be either padded or truncated to a length of <code>1024</code>.</li> <li>We use the <code>NeuronSFTTrainer</code> to perform training. It will take the lazily loaded model, along with <code>lora_config</code>, <code>sft_config</code> and <code>format_dolly</code> and prepare the dataset and model for supervised fine-tuning.</li>",Cl,ie,_l,oe,Nt='We prepared a script called <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/lora_finetune_llm.py" rel="nofollow">sft_lora_finetune_llm.py</a> summing up everything mentioned in this tutorial.',El,pe,Ft="PyTorch Neuron uses <code>torch_xla</code>. It evaluates operations lazily during the execution of the training loops, which means it builds a symbolic graph in the background, and the graph is executed on the hardware only when the tensor is printed, transferred to CPU, or when <code>xm.mark_step()</code> is called. During execution, multiple graphs can be built depending on control-flow, and it can take time to compile each graph sequentially. To alleviate that, the Neuron SDK provides <code>neuron_parallel_compile</code>, a tool which performs a fast trial run that builds all the graphs and compile them in parallel. This step is usually called precompilation.",gl,re,Bl,Me,$t="When training models on AWS Trainium we first need to compile our model with our training arguments.",Sl,ce,Xt='To ease this step, we added a <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache" rel="nofollow">model cache repository</a>, which allows us to use precompiled models from the Hugging Face Hub to skip the compilation step. But be careful: every change in the model configuration might lead to a new compilation, which could result in some cache misses.',Vl,_,Rl,ue,Gt="The compilation command simply consists in calling your script as an input to the <code>neuron_parallel_compile</code> utility:",Al,me,vl,E,Wl,Te,kt="<em>Note: Compiling without a cache can take a while. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you will have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",Zl,de,Nl,he,Fl,ye,xt="After compilation is done we can start our actual training with a similar command, we just need to remove the use of <code>neuron_parallel_compile</code>.",$l,Ue,Qt="We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",Xl,Je,Ht="The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.",Gl,we,Lt="Launch the training, with the following command.",kl,je,xl,fe,zt="That’s it, we successfully trained Llama-3 8B on AWS Trainium!",Ql,be,Yt="But before we can share and test our model we need to consolidate our model. Since we used tensor parallelism during training, we saved sharded versions of the checkpoints. We need to consolidate them now.",Hl,Ie,Ll,Ce,qt="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate [sharded_checkpoint] [output_dir]</code> command:",zl,_e,Yl,Ee,ql,ge,Pt="As for training, to be able to run inference on AWS Trainium or AWS Inferentia2 we need to compile our model. In this case, we will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 (<code>inf2.24xlarge</code>) for inference.",Pl,Be,Ot="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",Ol,Se,Dl,Ve,Dt="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",Kl,Re,et,Ae,Kt="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",lt,ve,tt,We,es="Let’s test inference. First we test without a context.",st,Ze,ls="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",at,Ne,nt,Fe,ts="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",it,$e,ss="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications:",ot,Xe,pt,Ge,as="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",rt,ke,ns="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",Mt,xe,ct;return g=new w({props:{title:"Supervised Fine-Tuning of Llama 3 8B on one AWS Trainium instance",local:"supervised-fine-tuning-of-llama-3-8b-on-one-aws-trainium-instance",headingTag:"h1"}}),f=new mt({props:{$$slots:{default:[ys]},$$scope:{ctx:j}}}),A=new w({props:{title:"1. Setup AWS Environment",local:"1-setup-aws-environment",headingTag:"h2"}}),Z=new U({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwWU9VUl9UT0tFTg==",highlighted:"huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),F=new U({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),$=new w({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),k=new U({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJsaXphcnJlJTIwZW50ZXJ0YWlubWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: (
        <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-string">&quot;It was released in 2004 by blizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),Q=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),Y=new w({props:{title:"3. Supervised Fine-Tuning of Llama on AWS Trainium with the NeuronSFTTrainer",local:"3-supervised-fine-tuning-of-llama-on-aws-trainium-with-the-neuronsfttrainer",headingTag:"h2"}}),O=new w({props:{title:"Formatting our dataset",local:"formatting-our-dataset",headingTag:"h3"}}),K=new U({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0JTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGV4YW1wbGVzJTVCJTIyaW5zdHJ1Y3Rpb24lMjIlNUQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RydWN0aW9uJTIwJTNEJTIwZiUyMiUyMyUyMyUyMyUyMEluc3RydWN0aW9uJTVDbiU3QmV4YW1wbGVzJTVCJ2luc3RydWN0aW9uJyU1RCU1QmklNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250ZXh0JTIwJTNEJTIwZiUyMiUyMyUyMyUyMyUyMENvbnRleHQlNUNuJTdCZXhhbXBsZXMlNUInY29udGV4dCclNUQlNUJpJTVEJTdEJTIyJTIwaWYlMjBsZW4oZXhhbXBsZXMlNUIlMjJjb250ZXh0JTIyJTVEJTVCaSU1RCklMjAlM0UlMjAwJTIwZWxzZSUyME5vbmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBBbnN3ZXIlNUNuJTdCZXhhbXBsZXMlNUIncmVzcG9uc2UnJTVEJTVCaSU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF90ZXh0LmFwcGVuZChwcm9tcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0X3RleHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">examples</span>):
    output_text = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(examples[<span class="hljs-string">&quot;instruction&quot;</span>])):
        instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>&quot;</span>
        context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;context&#x27;</span>][i]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(examples[<span class="hljs-string">&quot;context&quot;</span>][i]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
        response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;response&#x27;</span>][i]}</span>&quot;</span>
        prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
        output_text.append(prompt)
    <span class="hljs-keyword">return</span> output_text`,wrap:!1}}),ee=new w({props:{title:"Preparing the model",local:"preparing-the-model",headingTag:"h3"}}),C=new mt({props:{$$slots:{default:[Us]},$$scope:{ctx:j}}}),se=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronSFTConfig, NeuronSFTTrainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Define the tensor_parallel_size</span>
tensor_parallel_size = <span class="hljs-number">2</span>

dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = AutoModelForCausalLM.from_pretrained(model_id)

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>
    ],
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># training_args is an instance of NeuronTrainingArguments</span>
args = training_args.to_dict()
sft_config = NeuronSFTConfig(
    max_seq_length=<span class="hljs-number">1024</span>,
    packing=<span class="hljs-literal">False</span>,
    **args,
)

trainer = NeuronSFTTrainer(
    args=sft_config,
    model=model,
    peft_config=config,
    tokenizer=tokenizer,
    train_dataset=dataset,
    formatting_func=format_dolly,
)

<span class="hljs-comment"># Start training</span>
trainer.train()

trainer.save_model()  <span class="hljs-comment"># Saves the tokenizer too for easy upload</span>`,wrap:!1}}),ie=new w({props:{title:"4. Launch Training",local:"4-launch-training",headingTag:"h2"}}),re=new w({props:{title:"Precompilation",local:"precompilation",headingTag:"h3"}}),_=new mt({props:{$$slots:{default:[Js]},$$scope:{ctx:j}}}),me=new U({props:{code:"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",highlighted:`<span class="hljs-meta">#!/bin/bash</span>
<span class="hljs-built_in">set</span> -ex

<span class="hljs-built_in">export</span> NEURON_FUSE_SOFTMAX=1
<span class="hljs-built_in">export</span> NEURON_RT_ASYNC_EXEC_MAX_INFLIGHT_REQUESTS=3
<span class="hljs-built_in">export</span> MALLOC_ARENA_MAX=64
<span class="hljs-built_in">export</span> NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type=transformer --distribution-strategy=llm-training --enable-saturate-infinity --cache_dir=/home/ubuntu/cache_dir_neuron/&quot;</span>

PROCESSES_PER_NODE=8

NUM_EPOCHS=1
TP_DEGREE=2
PP_DEGREE=1
BS=1
GRADIENT_ACCUMULATION_STEPS=8
LOGGING_STEPS=1
MODEL_NAME=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>
OUTPUT_DIR=output-<span class="hljs-variable">$SLURM_JOB_ID</span>

<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;<span class="hljs-variable">$NEURON_EXTRACT_GRAPHS_ONLY</span>&quot;</span> = <span class="hljs-string">&quot;1&quot;</span> ]; <span class="hljs-keyword">then</span>
    MAX_STEPS=$((LOGGING_STEPS + <span class="hljs-number">5</span>))
<span class="hljs-keyword">else</span>
    MAX_STEPS=-1
<span class="hljs-keyword">fi</span>


XLA_USE_BF16=1 neuron_parallel_compile torchrun --nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span> docs/source/training_tutorials/sft_lora_finetune_llm.py \\
  --model_id <span class="hljs-variable">$MODEL_NAME</span> \\
  --num_train_epochs <span class="hljs-variable">$NUM_EPOCHS</span> \\
  --do_train \\
  --learning_rate 5e-5 \\
  --warmup_ratio 0.03 \\
  --max_steps <span class="hljs-variable">$MAX_STEPS</span> \\
  --per_device_train_batch_size <span class="hljs-variable">$BS</span> \\
  --per_device_eval_batch_size <span class="hljs-variable">$BS</span> \\
  --gradient_accumulation_steps <span class="hljs-variable">$GRADIENT_ACCUMULATION_STEPS</span> \\
  --gradient_checkpointing <span class="hljs-literal">true</span> \\
  --bf16 \\
  --zero_1 <span class="hljs-literal">false</span> \\
  --tensor_parallel_size <span class="hljs-variable">$TP_DEGREE</span> \\
  --pipeline_parallel_size <span class="hljs-variable">$PP_DEGREE</span> \\
  --logging_steps <span class="hljs-variable">$LOGGING_STEPS</span> \\
  --save_total_limit 1 \\
  --output_dir <span class="hljs-variable">$OUTPUT_DIR</span> \\
  --lr_scheduler_type <span class="hljs-string">&quot;constant&quot;</span> \\
  --overwrite_output_dir`,wrap:!1}}),E=new mt({props:{$$slots:{default:[ws]},$$scope:{ctx:j}}}),de=new U({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQXJtJTIwLXJmJTIwZG9sbHlfbGxhbWE=",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
<span class="hljs-built_in">rm</span> -rf dolly_llama`,wrap:!1}}),he=new w({props:{title:"Actual Training",local:"actual-training",headingTag:"h3"}}),je=new U({props:{code:"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",highlighted:`<span class="hljs-meta">#!/bin/bash</span>
<span class="hljs-built_in">set</span> -ex

<span class="hljs-built_in">export</span> NEURON_FUSE_SOFTMAX=1
<span class="hljs-built_in">export</span> NEURON_RT_ASYNC_EXEC_MAX_INFLIGHT_REQUESTS=3
<span class="hljs-built_in">export</span> MALLOC_ARENA_MAX=64
<span class="hljs-built_in">export</span> NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type=transformer --distribution-strategy=llm-training --enable-saturate-infinity --cache_dir=/home/ubuntu/cache_dir_neuron/&quot;</span>

PROCESSES_PER_NODE=8

NUM_EPOCHS=1
TP_DEGREE=2
PP_DEGREE=1
BS=1
GRADIENT_ACCUMULATION_STEPS=8
LOGGING_STEPS=1
MODEL_NAME=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>
OUTPUT_DIR=output-<span class="hljs-variable">$SLURM_JOB_ID</span>

<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;<span class="hljs-variable">$NEURON_EXTRACT_GRAPHS_ONLY</span>&quot;</span> = <span class="hljs-string">&quot;1&quot;</span> ]; <span class="hljs-keyword">then</span>
    MAX_STEPS=$((LOGGING_STEPS + <span class="hljs-number">5</span>))
<span class="hljs-keyword">else</span>
    MAX_STEPS=-1
<span class="hljs-keyword">fi</span>


XLA_USE_BF16=1 torchrun --nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span> docs/source/training_tutorials/sft_lora_finetune_llm.py \\
  --model_id <span class="hljs-variable">$MODEL_NAME</span> \\
  --num_train_epochs <span class="hljs-variable">$NUM_EPOCHS</span> \\
  --do_train \\
  --learning_rate 5e-5 \\
  --warmup_ratio 0.03 \\
  --max_steps <span class="hljs-variable">$MAX_STEPS</span> \\
  --per_device_train_batch_size <span class="hljs-variable">$BS</span> \\
  --per_device_eval_batch_size <span class="hljs-variable">$BS</span> \\
  --gradient_accumulation_steps <span class="hljs-variable">$GRADIENT_ACCUMULATION_STEPS</span> \\
  --gradient_checkpointing <span class="hljs-literal">true</span> \\
  --bf16 \\
  --zero_1 <span class="hljs-literal">false</span> \\
  --tensor_parallel_size <span class="hljs-variable">$TP_DEGREE</span> \\
  --pipeline_parallel_size <span class="hljs-variable">$PP_DEGREE</span> \\
  --logging_steps <span class="hljs-variable">$LOGGING_STEPS</span> \\
  --save_total_limit 1 \\
  --output_dir <span class="hljs-variable">$OUTPUT_DIR</span> \\
  --lr_scheduler_type <span class="hljs-string">&quot;constant&quot;</span> \\
  --overwrite_output_dir`,wrap:!1}}),Ie=new w({props:{title:"Consolidate the Checkpoint",local:"consolidate-the-checkpoint",headingTag:"h3"}}),_e=new U({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMGRvbGx5X2xsYW1hJTIwZG9sbHlfbGxhbWE=",highlighted:"optimum-cli neuron consolidate dolly_llama dolly_llama",wrap:!1}}),Ee=new w({props:{title:"5. Evaluate and test fine-tuned Llama model",local:"5-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),Se=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),Re=new U({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),ve=new U({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmb3JtYXRfZG9sbHlfaW5mZXJlbmNlKHNhbXBsZSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSU1Qmxlbihwcm9tcHQpJTNBJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">512</span>,
        do_sample=<span class="hljs-literal">True</span>,
        temperature=<span class="hljs-number">0.9</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.9</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Ne=new U({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Xe=new U({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){r=i("meta"),y=a(),h=i("p"),J=a(),M(g.$$.fragment),Qe=a(),B=i("p"),B.innerHTML=dt,He=a(),S=i("p"),S.innerHTML=ht,Le=a(),V=i("p"),V.textContent=yt,ze=a(),R=i("ol"),R.innerHTML=Ut,Ye=a(),M(f.$$.fragment),qe=a(),M(A.$$.fragment),Pe=a(),v=i("p"),v.textContent=Jt,Oe=a(),W=i("ol"),W.innerHTML=wt,De=a(),M(Z.$$.fragment),Ke=a(),b=i("ol"),b.innerHTML=jt,el=a(),N=i("ul"),N.innerHTML=ft,ll=a(),I=i("ol"),I.innerHTML=bt,tl=a(),M(F.$$.fragment),sl=a(),M($.$$.fragment),al=a(),X=i("p"),X.innerHTML=It,nl=a(),G=i("p"),G.textContent=Ct,il=a(),M(k.$$.fragment),ol=a(),x=i("p"),x.innerHTML=_t,pl=a(),M(Q.$$.fragment),rl=a(),H=i("p"),H.textContent=Et,Ml=a(),L=i("ol"),L.innerHTML=gt,cl=a(),z=i("p"),z.innerHTML=Bt,ul=a(),M(Y.$$.fragment),ml=a(),q=i("p"),q.innerHTML=St,Tl=a(),P=i("p"),P.innerHTML=Vt,dl=a(),M(O.$$.fragment),hl=a(),D=i("p"),D.innerHTML=Rt,yl=a(),M(K.$$.fragment),Ul=a(),M(ee.$$.fragment),Jl=a(),le=i("p"),le.innerHTML=At,wl=a(),M(C.$$.fragment),jl=a(),te=i("p"),te.textContent=vt,fl=a(),M(se.$$.fragment),bl=a(),ae=i("p"),ae.textContent=Wt,Il=a(),ne=i("ul"),ne.innerHTML=Zt,Cl=a(),M(ie.$$.fragment),_l=a(),oe=i("p"),oe.innerHTML=Nt,El=a(),pe=i("p"),pe.innerHTML=Ft,gl=a(),M(re.$$.fragment),Bl=a(),Me=i("p"),Me.textContent=$t,Sl=a(),ce=i("p"),ce.innerHTML=Xt,Vl=a(),M(_.$$.fragment),Rl=a(),ue=i("p"),ue.innerHTML=Gt,Al=a(),M(me.$$.fragment),vl=a(),M(E.$$.fragment),Wl=a(),Te=i("p"),Te.innerHTML=kt,Zl=a(),M(de.$$.fragment),Nl=a(),M(he.$$.fragment),Fl=a(),ye=i("p"),ye.innerHTML=xt,$l=a(),Ue=i("p"),Ue.innerHTML=Qt,Xl=a(),Je=i("p"),Je.innerHTML=Ht,Gl=a(),we=i("p"),we.textContent=Lt,kl=a(),M(je.$$.fragment),xl=a(),fe=i("p"),fe.textContent=zt,Ql=a(),be=i("p"),be.textContent=Yt,Hl=a(),M(Ie.$$.fragment),Ll=a(),Ce=i("p"),Ce.innerHTML=qt,zl=a(),M(_e.$$.fragment),Yl=a(),M(Ee.$$.fragment),ql=a(),ge=i("p"),ge.innerHTML=Pt,Pl=a(),Be=i("p"),Be.innerHTML=Ot,Ol=a(),M(Se.$$.fragment),Dl=a(),Ve=i("p"),Ve.innerHTML=Dt,Kl=a(),M(Re.$$.fragment),et=a(),Ae=i("p"),Ae.innerHTML=Kt,lt=a(),M(ve.$$.fragment),tt=a(),We=i("p"),We.textContent=es,st=a(),Ze=i("p"),Ze.innerHTML=ls,at=a(),M(Ne.$$.fragment),nt=a(),Fe=i("blockquote"),Fe.innerHTML=ts,it=a(),$e=i("p"),$e.textContent=ss,ot=a(),M(Xe.$$.fragment),pt=a(),Ge=i("blockquote"),Ge.innerHTML=as,rt=a(),ke=i("p"),ke.textContent=ns,Mt=a(),xe=i("p"),this.h()},l(e){const l=ds("svelte-u9bgzb",document.head);r=o(l,"META",{name:!0,content:!0}),l.forEach(t),y=n(e),h=o(e,"P",{}),Ms(h).forEach(t),J=n(e),c(g.$$.fragment,e),Qe=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-uoutuw"&&(B.innerHTML=dt),He=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1w2bqvx"&&(S.innerHTML=ht),Le=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1hahfn0"&&(V.textContent=yt),ze=n(e),R=o(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-mnoauv"&&(R.innerHTML=Ut),Ye=n(e),c(f.$$.fragment,e),qe=n(e),c(A.$$.fragment,e),Pe=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-w52dpm"&&(v.textContent=Jt),Oe=n(e),W=o(e,"OL",{"data-svelte-h":!0}),p(W)!=="svelte-15ega2l"&&(W.innerHTML=wt),De=n(e),c(Z.$$.fragment,e),Ke=n(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(b)!=="svelte-ksb30n"&&(b.innerHTML=jt),el=n(e),N=o(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1qiwkz0"&&(N.innerHTML=ft),ll=n(e),I=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(I)!=="svelte-qhor5j"&&(I.innerHTML=bt),tl=n(e),c(F.$$.fragment,e),sl=n(e),c($.$$.fragment,e),al=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-s6kf7j"&&(X.innerHTML=It),nl=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-11lpom8"&&(G.textContent=Ct),il=n(e),c(k.$$.fragment,e),ol=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1snwaj0"&&(x.innerHTML=_t),pl=n(e),c(Q.$$.fragment,e),rl=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1993zti"&&(H.textContent=Et),Ml=n(e),L=o(e,"OL",{"data-svelte-h":!0}),p(L)!=="svelte-5ew6jj"&&(L.innerHTML=gt),cl=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1u9ozqi"&&(z.innerHTML=Bt),ul=n(e),c(Y.$$.fragment,e),ml=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-uhn59v"&&(q.innerHTML=St),Tl=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1js0azg"&&(P.innerHTML=Vt),dl=n(e),c(O.$$.fragment,e),hl=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1w3fqpa"&&(D.innerHTML=Rt),yl=n(e),c(K.$$.fragment,e),Ul=n(e),c(ee.$$.fragment,e),Jl=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-sho0uq"&&(le.innerHTML=At),wl=n(e),c(C.$$.fragment,e),jl=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1bmdyu9"&&(te.textContent=vt),fl=n(e),c(se.$$.fragment,e),bl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-t16ze3"&&(ae.textContent=Wt),Il=n(e),ne=o(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-e6qxb9"&&(ne.innerHTML=Zt),Cl=n(e),c(ie.$$.fragment,e),_l=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-2j4b1j"&&(oe.innerHTML=Nt),El=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1vufr00"&&(pe.innerHTML=Ft),gl=n(e),c(re.$$.fragment,e),Bl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1u0hmu2"&&(Me.textContent=$t),Sl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1di4c3f"&&(ce.innerHTML=Xt),Vl=n(e),c(_.$$.fragment,e),Rl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-t9z3bd"&&(ue.innerHTML=Gt),Al=n(e),c(me.$$.fragment,e),vl=n(e),c(E.$$.fragment,e),Wl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-136s4kc"&&(Te.innerHTML=kt),Zl=n(e),c(de.$$.fragment,e),Nl=n(e),c(he.$$.fragment,e),Fl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1yiqpri"&&(ye.innerHTML=xt),$l=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1anw499"&&(Ue.innerHTML=Qt),Xl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-ctfnvw"&&(Je.innerHTML=Ht),Gl=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-17lv8z9"&&(we.textContent=Lt),kl=n(e),c(je.$$.fragment,e),xl=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1v2czzn"&&(fe.textContent=zt),Ql=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1wuuxgn"&&(be.textContent=Yt),Hl=n(e),c(Ie.$$.fragment,e),Ll=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-66io75"&&(Ce.innerHTML=qt),zl=n(e),c(_e.$$.fragment,e),Yl=n(e),c(Ee.$$.fragment,e),ql=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-zkjm52"&&(ge.innerHTML=Pt),Pl=n(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1pgrxrm"&&(Be.innerHTML=Ot),Ol=n(e),c(Se.$$.fragment,e),Dl=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1sinvz7"&&(Ve.innerHTML=Dt),Kl=n(e),c(Re.$$.fragment,e),et=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-jx2yqv"&&(Ae.innerHTML=Kt),lt=n(e),c(ve.$$.fragment,e),tt=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1ytr5g6"&&(We.textContent=es),st=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1j8w2o0"&&(Ze.innerHTML=ls),at=n(e),c(Ne.$$.fragment,e),nt=n(e),Fe=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Fe)!=="svelte-6l4k0q"&&(Fe.innerHTML=ts),it=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-ovzcvi"&&($e.textContent=ss),ot=n(e),c(Xe.$$.fragment,e),pt=n(e),Ge=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Ge)!=="svelte-15xrtpx"&&(Ge.innerHTML=as),rt=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-q9f4rf"&&(ke.textContent=ns),Mt=n(e),xe=o(e,"P",{}),Ms(xe).forEach(t),this.h()},h(){ut(r,"name","hf:doc:metadata"),ut(r,"content",fs),ut(b,"start","3"),ut(I,"start","4")},m(e,l){hs(document.head,r),s(e,y,l),s(e,h,l),s(e,J,l),u(g,e,l),s(e,Qe,l),s(e,B,l),s(e,He,l),s(e,S,l),s(e,Le,l),s(e,V,l),s(e,ze,l),s(e,R,l),s(e,Ye,l),u(f,e,l),s(e,qe,l),u(A,e,l),s(e,Pe,l),s(e,v,l),s(e,Oe,l),s(e,W,l),s(e,De,l),u(Z,e,l),s(e,Ke,l),s(e,b,l),s(e,el,l),s(e,N,l),s(e,ll,l),s(e,I,l),s(e,tl,l),u(F,e,l),s(e,sl,l),u($,e,l),s(e,al,l),s(e,X,l),s(e,nl,l),s(e,G,l),s(e,il,l),u(k,e,l),s(e,ol,l),s(e,x,l),s(e,pl,l),u(Q,e,l),s(e,rl,l),s(e,H,l),s(e,Ml,l),s(e,L,l),s(e,cl,l),s(e,z,l),s(e,ul,l),u(Y,e,l),s(e,ml,l),s(e,q,l),s(e,Tl,l),s(e,P,l),s(e,dl,l),u(O,e,l),s(e,hl,l),s(e,D,l),s(e,yl,l),u(K,e,l),s(e,Ul,l),u(ee,e,l),s(e,Jl,l),s(e,le,l),s(e,wl,l),u(C,e,l),s(e,jl,l),s(e,te,l),s(e,fl,l),u(se,e,l),s(e,bl,l),s(e,ae,l),s(e,Il,l),s(e,ne,l),s(e,Cl,l),u(ie,e,l),s(e,_l,l),s(e,oe,l),s(e,El,l),s(e,pe,l),s(e,gl,l),u(re,e,l),s(e,Bl,l),s(e,Me,l),s(e,Sl,l),s(e,ce,l),s(e,Vl,l),u(_,e,l),s(e,Rl,l),s(e,ue,l),s(e,Al,l),u(me,e,l),s(e,vl,l),u(E,e,l),s(e,Wl,l),s(e,Te,l),s(e,Zl,l),u(de,e,l),s(e,Nl,l),u(he,e,l),s(e,Fl,l),s(e,ye,l),s(e,$l,l),s(e,Ue,l),s(e,Xl,l),s(e,Je,l),s(e,Gl,l),s(e,we,l),s(e,kl,l),u(je,e,l),s(e,xl,l),s(e,fe,l),s(e,Ql,l),s(e,be,l),s(e,Hl,l),u(Ie,e,l),s(e,Ll,l),s(e,Ce,l),s(e,zl,l),u(_e,e,l),s(e,Yl,l),u(Ee,e,l),s(e,ql,l),s(e,ge,l),s(e,Pl,l),s(e,Be,l),s(e,Ol,l),u(Se,e,l),s(e,Dl,l),s(e,Ve,l),s(e,Kl,l),u(Re,e,l),s(e,et,l),s(e,Ae,l),s(e,lt,l),u(ve,e,l),s(e,tt,l),s(e,We,l),s(e,st,l),s(e,Ze,l),s(e,at,l),u(Ne,e,l),s(e,nt,l),s(e,Fe,l),s(e,it,l),s(e,$e,l),s(e,ot,l),u(Xe,e,l),s(e,pt,l),s(e,Ge,l),s(e,rt,l),s(e,ke,l),s(e,Mt,l),s(e,xe,l),ct=!0},p(e,[l]){const is={};l&2&&(is.$$scope={dirty:l,ctx:e}),f.$set(is);const os={};l&2&&(os.$$scope={dirty:l,ctx:e}),C.$set(os);const ps={};l&2&&(ps.$$scope={dirty:l,ctx:e}),_.$set(ps);const rs={};l&2&&(rs.$$scope={dirty:l,ctx:e}),E.$set(rs)},i(e){ct||(m(g.$$.fragment,e),m(f.$$.fragment,e),m(A.$$.fragment,e),m(Z.$$.fragment,e),m(F.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(Q.$$.fragment,e),m(Y.$$.fragment,e),m(O.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(C.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(_.$$.fragment,e),m(me.$$.fragment,e),m(E.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(_e.$$.fragment,e),m(Ee.$$.fragment,e),m(Se.$$.fragment,e),m(Re.$$.fragment,e),m(ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Xe.$$.fragment,e),ct=!0)},o(e){T(g.$$.fragment,e),T(f.$$.fragment,e),T(A.$$.fragment,e),T(Z.$$.fragment,e),T(F.$$.fragment,e),T($.$$.fragment,e),T(k.$$.fragment,e),T(Q.$$.fragment,e),T(Y.$$.fragment,e),T(O.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(C.$$.fragment,e),T(se.$$.fragment,e),T(ie.$$.fragment,e),T(re.$$.fragment,e),T(_.$$.fragment,e),T(me.$$.fragment,e),T(E.$$.fragment,e),T(de.$$.fragment,e),T(he.$$.fragment,e),T(je.$$.fragment,e),T(Ie.$$.fragment,e),T(_e.$$.fragment,e),T(Ee.$$.fragment,e),T(Se.$$.fragment,e),T(Re.$$.fragment,e),T(ve.$$.fragment,e),T(Ne.$$.fragment,e),T(Xe.$$.fragment,e),ct=!1},d(e){e&&(t(y),t(h),t(J),t(Qe),t(B),t(He),t(S),t(Le),t(V),t(ze),t(R),t(Ye),t(qe),t(Pe),t(v),t(Oe),t(W),t(De),t(Ke),t(b),t(el),t(N),t(ll),t(I),t(tl),t(sl),t(al),t(X),t(nl),t(G),t(il),t(ol),t(x),t(pl),t(rl),t(H),t(Ml),t(L),t(cl),t(z),t(ul),t(ml),t(q),t(Tl),t(P),t(dl),t(hl),t(D),t(yl),t(Ul),t(Jl),t(le),t(wl),t(jl),t(te),t(fl),t(bl),t(ae),t(Il),t(ne),t(Cl),t(_l),t(oe),t(El),t(pe),t(gl),t(Bl),t(Me),t(Sl),t(ce),t(Vl),t(Rl),t(ue),t(Al),t(vl),t(Wl),t(Te),t(Zl),t(Nl),t(Fl),t(ye),t($l),t(Ue),t(Xl),t(Je),t(Gl),t(we),t(kl),t(xl),t(fe),t(Ql),t(be),t(Hl),t(Ll),t(Ce),t(zl),t(Yl),t(ql),t(ge),t(Pl),t(Be),t(Ol),t(Dl),t(Ve),t(Kl),t(et),t(Ae),t(lt),t(tt),t(We),t(st),t(Ze),t(at),t(nt),t(Fe),t(it),t($e),t(ot),t(pt),t(Ge),t(rt),t(ke),t(Mt),t(xe)),t(r),d(g,e),d(f,e),d(A,e),d(Z,e),d(F,e),d($,e),d(k,e),d(Q,e),d(Y,e),d(O,e),d(K,e),d(ee,e),d(C,e),d(se,e),d(ie,e),d(re,e),d(_,e),d(me,e),d(E,e),d(de,e),d(he,e),d(je,e),d(Ie,e),d(_e,e),d(Ee,e),d(Se,e),d(Re,e),d(ve,e),d(Ne,e),d(Xe,e)}}}const fs='{"title":"Supervised Fine-Tuning of Llama 3 8B on one AWS Trainium instance","local":"supervised-fine-tuning-of-llama-3-8b-on-one-aws-trainium-instance","sections":[{"title":"1. Setup AWS Environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Supervised Fine-Tuning of Llama on AWS Trainium with the NeuronSFTTrainer","local":"3-supervised-fine-tuning-of-llama-on-aws-trainium-with-the-neuronsfttrainer","sections":[{"title":"Formatting our dataset","local":"formatting-our-dataset","sections":[],"depth":3},{"title":"Preparing the model","local":"preparing-the-model","sections":[],"depth":3}],"depth":2},{"title":"4. Launch Training","local":"4-launch-training","sections":[{"title":"Precompilation","local":"precompilation","sections":[],"depth":3},{"title":"Actual Training","local":"actual-training","sections":[],"depth":3},{"title":"Consolidate the Checkpoint","local":"consolidate-the-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"5. Evaluate and test fine-tuned Llama model","local":"5-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function bs(j){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bs extends ms{constructor(r){super(),Ts(this,r,bs,js,cs,{})}}export{Bs as component};
