import{s as yl,n as gl,o as hl}from"../chunks/scheduler.c9113122.js";import{S as Ul,i as dl,e as a,s,c as M,h as Jl,a as o,d as l,b as i,f as Ee,g as m,j as r,k as Le,l as Jt,m as n,n as p,t as u,o as c,p as T}from"../chunks/index.667522bb.js";import{C as bt}from"../chunks/CodeBlock.78f8cced.js";import{H as y,E as bl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2eeed2e2.js";function jl(Be){let g,Ct,jt,vt,d,_t,J,Ze="<strong>Hugging Face Jobs</strong> provides fully managed cloud infrastructure for training models without the hassle of setting up GPUs, managing dependencies, or configuring environments locally. This is particularly valuable for SFT training, which can be resource-intensive and time-consuming.",It,b,$t,j,He="<li><strong>Scalable Infrastructure</strong>: Access to high-end GPUs (A100, L4, etc.) without hardware investment</li> <li><strong>Zero Setup</strong>: No need to manage CUDA drivers, Docker containers, or environment configurations</li> <li><strong>Cost Effective</strong>: Pay only for compute time used, with automatic shutdown after completion</li> <li><strong>Integrated Workflow</strong>: Seamless integration with Hugging Face Hub for model storage and sharing</li> <li><strong>Monitoring</strong>: Built-in logging and progress tracking through the Hub interface</li>",Et,w,Lt,C,Ae="To use Hugging Face Jobs, you need:",Bt,v,Fe='<li>A <strong>Pro, Team, or Enterprise</strong> Hugging Face plan which you can get <a href="https://huggingface.co/pricing" rel="nofollow">here</a></li> <li>Authentication via <code>hf auth login</code></li>',Zt,_,Ht,I,ke="The best way to run TRL with HF jobs is using the built-in scripts. They take advantage of <code>uv</code> to manage dependencies and <code>hf jobs</code> to run the training job.",At,$,Ge="This guide will walk you through using TRL’s built-in scripts to train a model with Hugging Face Jobs. If you want to use a custom script, you can implement <code>uv</code> dependencies and run the script with <code>hf jobs run</code>.",Ft,f,Ut,Re="Create a custom training script with inline dependencies",_e,E,Ie,dt,Ve="Then run with the Jobs CLI:",$e,L,kt,B,Gt,Z,We="Choose the right hardware flavor based on your model size and training requirements:",Rt,H,Xe="<strong>For SmolLM3-3B (Recommended)</strong>:",Vt,A,xe="<li><code>a10g-large</code>: 24GB GPU memory, cost-effective for most SFT tasks</li> <li><code>a100-large</code>: 40GB GPU memory, fastest training with larger batch sizes</li> <li><code>l4x1</code>: 24GB GPU memory, multi-GPU setup for distributed training</li>",Wt,F,Se="<strong>For Larger Models (7B+)</strong>:",Xt,k,Qe="<li><code>a100-large</code>: Required for 7B+ models</li> <li><code>l4x4</code>: Multi-GPU setup for distributed training</li>",xt,G,Ne="<strong>Budget Options</strong>:",St,R,Ye="<li><code>t4-small</code>: 16GB GPU memory, slower but economical for experimentation</li> <li><code>l4x1</code>: 24GB GPU memory, good balance of cost and performance</li>",Qt,h,ze='<p>For a detailed comparison of the different hardware flavors, you can check out the <a href="https://huggingface.co/pricing" rel="nofollow">Pricing Page</a> page.</p>',Nt,V,Yt,W,zt,X,Pe="<strong>Environment Variables and Secrets</strong>:",Pt,x,qe="If you’re working with a custom script, you can use the <code>--secrets</code> flag to pass in environment variables.",qt,S,Dt,Q,Ot,N,De='To check you training job, you can use the <code>hf jobs</code> command or you can go to <a href="https://huggingface.co/settings/jobs" rel="nofollow">Job Settings</a> on the Hub.',Kt,Y,Oe="<strong>Check Job Status</strong>:",te,z,ee,P,le,q,Ke="Enable LoRA when using TRL’s maintained SFT script by passing PEFT flags. See the script for authoritative flags and defaults: <code>https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py</code>.",ne,D,se,O,tl="Notes:",ie,K,el="<li>Confirm flag names in the TRL SFT script before running: <code>https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py</code>.</li> <li>LoRA trains small adapters, which you can keep separate or merge later for deployment.</li>",ae,tt,oe,et,ll="You can monitor your training job with Trackio.",re,lt,nl='<img src="https://github.com/user-attachments/assets/f3eac49e-d8ee-4fc0-b1ca-aedfc6d6fae1" alt="Trackio Monitoring"/>',Me,nt,me,st,sl="Approximate costs for SmolLM3-3B SFT training (1000 steps):",pe,it,il="<li>l4x1: ~$3-4 per hour (24GB GPU memory)</li> <li>a10g-large: ~$4-6 per hour (24GB GPU memory)</li> <li>a100-large: ~$8-12 per hour (40GB GPU memory)</li>",ue,at,al="Training typically takes 30-90 minutes for 1000 steps depending on hardware and configuration, making Jobs cost-effective compared to local GPU rental or cloud instances.",ce,ot,ol="<strong>Cost-Saving Tips</strong>:",Te,rt,rl="<li>Use smaller batch sizes with gradient accumulation to fit on cheaper GPUs</li> <li>Start with shorter training runs (500 steps) to validate your setup</li> <li>Use <code>l4x1</code> for initial experiments, then scale to faster GPUs for production</li> <li>Set appropriate timeouts to avoid unexpected charges</li>",fe,Mt,ye,mt,Ml="<strong>Out of Memory Errors</strong>:",ge,pt,ml="<li>Reduce <code>per_device_train_batch_size</code></li> <li>Enable gradient checkpointing</li> <li>Use smaller <code>max_length</code></li>",he,ut,pl="<strong>Timeout Issues</strong>:",Ue,ct,ul="<li>Increase timeout parameter</li> <li>Reduce training steps or use more powerful hardware</li> <li>Optimize data loading and preprocessing</li>",de,Tt,cl="<strong>Authentication Errors</strong>:",Je,ft,Tl="<li>Ensure HF_TOKEN is correctly set as a secret</li> <li>Verify your Hugging Face account has the required plan</li> <li>Check token permissions for model uploads</li>",be,yt,je,gt,fl='<li><a href="https://huggingface.co/docs/huggingface_hub/guides/jobs" rel="nofollow">Hugging Face Jobs Documentation</a> - Complete Jobs guide</li> <li><a href="https://huggingface.co/docs/trl/main/en/jobs_training" rel="nofollow">TRL Jobs Training Guide</a> - TRL-specific Jobs examples</li> <li><a href="https://huggingface.co/pricing" rel="nofollow">Jobs Pricing</a> - Current pricing for different hardware flavors</li> <li><a href="https://huggingface.co/docs/huggingface_hub/guides/cli#hf-jobs" rel="nofollow">Jobs CLI Reference</a> - Command-line interface details</li>',we,ht,Ce,wt,ve;return d=new y({props:{title:"Training with Hugging Face Jobs",local:"training-with-hugging-face-jobs",headingTag:"h1"}}),b=new y({props:{title:"Why Use Jobs for SFT Training?",local:"why-use-jobs-for-sft-training",headingTag:"h2"}}),w=new y({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),_=new y({props:{title:"Running SFT with Jobs: Two Approaches",local:"running-sft-with-jobs-two-approaches",headingTag:"h2"}}),E=new bt({props:{code:"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",highlighted:`<span class="hljs-comment"># sft_training.py</span>
<span class="hljs-comment"># /// script</span>
<span class="hljs-comment"># dependencies = [</span>
<span class="hljs-comment">#     &quot;trl[sft]&gt;=0.7.0&quot;,</span>
<span class="hljs-comment">#     &quot;transformers&gt;=4.36.0&quot;, </span>
<span class="hljs-comment">#     &quot;datasets&gt;=2.14.0&quot;,</span>
<span class="hljs-comment">#     &quot;accelerate&gt;=0.24.0&quot;,</span>
<span class="hljs-comment">#     &quot;peft&gt;=0.7.0&quot;</span>
<span class="hljs-comment"># ]</span>
<span class="hljs-comment"># ///</span>

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>)

<span class="hljs-comment"># Load dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceTB/smoltalk2&quot;</span>, <span class="hljs-string">&quot;SFT&quot;</span>)

<span class="hljs-comment"># Configure training</span>
config = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./smollm3-jobs-sft&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    max_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">50</span>,
    save_steps=<span class="hljs-number">200</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_model_id=<span class="hljs-string">&quot;your-username/smollm3-jobs-sft&quot;</span>
)

<span class="hljs-comment"># Train</span>
trainer = SFTTrainer(
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;smoltalk_everyday_convs_reasoning_Qwen3_32B_think&quot;</span>],
    args=config,
)
trainer.train()`,wrap:!1}}),L=new bt({props:{code:"JTIzJTIwUnVuJTIwdGhlJTIwVVYlMjBzY3JpcHQlMjBvbiUyMEpvYnMlMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjBzZnRfdHJhaW5pbmcucHk=",highlighted:`<span class="hljs-comment"># Run the UV script on Jobs</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    sft_training.py`,wrap:!1}}),B=new y({props:{title:"Hardware Selection for SFT",local:"hardware-selection-for-sft",headingTag:"h2"}}),V=new y({props:{title:"Advanced Jobs Configuration",local:"advanced-jobs-configuration",headingTag:"h2"}}),W=new bt({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQi1CYXNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjBIdWdnaW5nRmFjZVRCJTJGc21vbHRhbGsyX2V2ZXJ5ZGF5X2NvbnZzX3RoaW5rJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3N0ZXBzJTIwMTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2xsbTMtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbGxtMy1zZnQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlcG9ydF90byUyMHRyYWNraW8=",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
    --dataset_name HuggingFaceTB/smoltalk2_everyday_convs_think \\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_steps 1000 \\
    --output_dir smollm3-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smollm3-sft \\
    --report_to trackio`,wrap:!1}}),S=new bt({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRpbWVvdXQlMjAzaCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTNEeW91cl90b2tlbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMFdBTkRCX0FQSV9LRVklM0R5b3VyX3dhbmRiX2tleSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW52JTIwV0FOREJfUFJPSkVDVCUzRHNtb2xsbTMtc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1lbnYlMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMjAlNUMlMEElMjAlMjAlMjAlMjBteV9zZnRfdHJhaW5pbmcucHk=",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 3h \\
    --secrets HF_TOKEN=your_token \\
    --secrets WANDB_API_KEY=your_wandb_key \\
    --<span class="hljs-built_in">env</span> WANDB_PROJECT=smollm3-sft \\
    --<span class="hljs-built_in">env</span> CUDA_VISIBLE_DEVICES=0 \\
    my_sft_training.py`,wrap:!1}}),Q=new y({props:{title:"Monitoring Your Training Job",local:"monitoring-your-training-job",headingTag:"h2"}}),z=new bt({props:{code:"JTIzJTIwTGlzdCUyMGFsbCUyMGpvYnMlMEFoZiUyMGpvYnMlMjBwcyUyMC1hJTBBJTBBJTIzJTIwR2V0JTIwZGV0YWlsZWQlMjBqb2IlMjBpbmZvcm1hdGlvbiUyMCUyMCUwQWhmJTIwam9icyUyMGluc3BlY3QlMjAlM0Nqb2JfaWQlM0UlMEElMEElMjMlMjBTdHJlYW0lMjBqb2IlMjBsb2dzJTIwaW4lMjByZWFsLXRpbWUlMEFoZiUyMGpvYnMlMjBsb2dzJTIwJTNDam9iX2lkJTNFJTIwLS1mb2xsb3clMEElMEElMjMlMjBDYW5jZWwlMjBhJTIwcnVubmluZyUyMGpvYiUyMGlmJTIwbmVlZGVkJTBBaGYlMjBqb2JzJTIwY2FuY2VsJTIwJTNDam9iX2lkJTNF",highlighted:`<span class="hljs-comment"># List all jobs</span>
hf <span class="hljs-built_in">jobs</span> ps -a

<span class="hljs-comment"># Get detailed job information  </span>
hf <span class="hljs-built_in">jobs</span> inspect &lt;job_id&gt;

<span class="hljs-comment"># Stream job logs in real-time</span>
hf <span class="hljs-built_in">jobs</span> logs &lt;job_id&gt; --follow

<span class="hljs-comment"># Cancel a running job if needed</span>
hf <span class="hljs-built_in">jobs</span> cancel &lt;job_id&gt;`,wrap:!1}}),P=new y({props:{title:"LoRA/PEFT on Jobs (optional)",local:"lorapeft-on-jobs-optional",headingTag:"h2"}}),D=new bt({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAlMjAtLXRpbWVvdXQlMjAyaCUyMCU1QyUwQSUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTIwJTVDJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmwlMkZtYWluJTJGdHJsJTJGc2NyaXB0cyUyRnNmdC5weSUyMiUyMCU1QyUwQSUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwSHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0ItQmFzZSUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldF9uYW1lJTIwSHVnZ2luZ0ZhY2VUQiUyRnNtb2x0YWxrMl9ldmVyeWRheV9jb252c190aGluayUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2xsbTMtbG9yYS1zZnQtam9icyUyMCU1QyUwQSUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAtLW1heF9zdGVwcyUyMDEwMDAlMjAlNUMlMEElMjAlMjAtLXJlcG9ydF90byUyMHRyYWNraW8lMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbGxtMy1sb3JhLXNmdCUyMCU1QyUwQSUyMCUyMC0tdXNlX3BlZnQlMjAlNUMlMEElMjAlMjAtLWxvcmFfciUyMDglMjAlNUMlMEElMjAlMjAtLWxvcmFfYWxwaGElMjAxNiUyMCU1QyUwQSUyMCUyMC0tbG9yYV9kcm9wb3V0JTIwMC4wNSUyMCU1QyUwQSUyMCUyMC0tbG9yYV90YXJnZXRfbW9kdWxlcyUyMGFsbC1saW5lYXI=",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
  --flavor a10g-large \\
  --<span class="hljs-built_in">timeout</span> 2h \\
  --secrets HF_TOKEN \\
  <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
  --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
  --dataset_name HuggingFaceTB/smoltalk2_everyday_convs_think \\
  --output_dir smollm3-lora-sft-jobs \\
  --per_device_train_batch_size 4 \\
  --learning_rate 5e-5 \\
  --max_steps 1000 \\
  --report_to trackio \\
  --push_to_hub \\
  --hub_model_id your-username/smollm3-lora-sft \\
  --use_peft \\
  --lora_r 8 \\
  --lora_alpha 16 \\
  --lora_dropout 0.05 \\
  --lora_target_modules all-linear`,wrap:!1}}),tt=new y({props:{title:"Monitoring with Trackio",local:"monitoring-with-trackio",headingTag:"h2"}}),nt=new y({props:{title:"Cost Estimation",local:"cost-estimation",headingTag:"h2"}}),Mt=new y({props:{title:"Troubleshooting Common Issues",local:"troubleshooting-common-issues",headingTag:"h2"}}),yt=new y({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),ht=new bl({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/5.md"}}),{c(){g=a("meta"),Ct=s(),jt=a("p"),vt=s(),M(d.$$.fragment),_t=s(),J=a("p"),J.innerHTML=Ze,It=s(),M(b.$$.fragment),$t=s(),j=a("ul"),j.innerHTML=He,Et=s(),M(w.$$.fragment),Lt=s(),C=a("p"),C.textContent=Ae,Bt=s(),v=a("ul"),v.innerHTML=Fe,Zt=s(),M(_.$$.fragment),Ht=s(),I=a("p"),I.innerHTML=ke,At=s(),$=a("p"),$.innerHTML=Ge,Ft=s(),f=a("details"),Ut=a("summary"),Ut.textContent=Re,_e=s(),M(E.$$.fragment),Ie=s(),dt=a("p"),dt.textContent=Ve,$e=s(),M(L.$$.fragment),kt=s(),M(B.$$.fragment),Gt=s(),Z=a("p"),Z.textContent=We,Rt=s(),H=a("p"),H.innerHTML=Xe,Vt=s(),A=a("ul"),A.innerHTML=xe,Wt=s(),F=a("p"),F.innerHTML=Se,Xt=s(),k=a("ul"),k.innerHTML=Qe,xt=s(),G=a("p"),G.innerHTML=Ne,St=s(),R=a("ul"),R.innerHTML=Ye,Qt=s(),h=a("blockquote"),h.innerHTML=ze,Nt=s(),M(V.$$.fragment),Yt=s(),M(W.$$.fragment),zt=s(),X=a("p"),X.innerHTML=Pe,Pt=s(),x=a("p"),x.innerHTML=qe,qt=s(),M(S.$$.fragment),Dt=s(),M(Q.$$.fragment),Ot=s(),N=a("p"),N.innerHTML=De,Kt=s(),Y=a("p"),Y.innerHTML=Oe,te=s(),M(z.$$.fragment),ee=s(),M(P.$$.fragment),le=s(),q=a("p"),q.innerHTML=Ke,ne=s(),M(D.$$.fragment),se=s(),O=a("p"),O.textContent=tl,ie=s(),K=a("ul"),K.innerHTML=el,ae=s(),M(tt.$$.fragment),oe=s(),et=a("p"),et.textContent=ll,re=s(),lt=a("p"),lt.innerHTML=nl,Me=s(),M(nt.$$.fragment),me=s(),st=a("p"),st.textContent=sl,pe=s(),it=a("ul"),it.innerHTML=il,ue=s(),at=a("p"),at.textContent=al,ce=s(),ot=a("p"),ot.innerHTML=ol,Te=s(),rt=a("ul"),rt.innerHTML=rl,fe=s(),M(Mt.$$.fragment),ye=s(),mt=a("p"),mt.innerHTML=Ml,ge=s(),pt=a("ul"),pt.innerHTML=ml,he=s(),ut=a("p"),ut.innerHTML=pl,Ue=s(),ct=a("ul"),ct.innerHTML=ul,de=s(),Tt=a("p"),Tt.innerHTML=cl,Je=s(),ft=a("ul"),ft.innerHTML=Tl,be=s(),M(yt.$$.fragment),je=s(),gt=a("ul"),gt.innerHTML=fl,we=s(),M(ht.$$.fragment),Ce=s(),wt=a("p"),this.h()},l(t){const e=Jl("svelte-u9bgzb",document.head);g=o(e,"META",{name:!0,content:!0}),e.forEach(l),Ct=i(t),jt=o(t,"P",{}),Ee(jt).forEach(l),vt=i(t),m(d.$$.fragment,t),_t=i(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1romi1a"&&(J.innerHTML=Ze),It=i(t),m(b.$$.fragment,t),$t=i(t),j=o(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-hq0r4s"&&(j.innerHTML=He),Et=i(t),m(w.$$.fragment,t),Lt=i(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1m87417"&&(C.textContent=Ae),Bt=i(t),v=o(t,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-jk9mxc"&&(v.innerHTML=Fe),Zt=i(t),m(_.$$.fragment,t),Ht=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1md3sw3"&&(I.innerHTML=ke),At=i(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-186flx0"&&($.innerHTML=Ge),Ft=i(t),f=o(t,"DETAILS",{});var U=Ee(f);Ut=o(U,"SUMMARY",{"data-svelte-h":!0}),r(Ut)!=="svelte-3ojvyd"&&(Ut.textContent=Re),_e=i(U),m(E.$$.fragment,U),Ie=i(U),dt=o(U,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-14xyf0t"&&(dt.textContent=Ve),$e=i(U),m(L.$$.fragment,U),U.forEach(l),kt=i(t),m(B.$$.fragment,t),Gt=i(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-uvhb8e"&&(Z.textContent=We),Rt=i(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1wmskg9"&&(H.innerHTML=Xe),Vt=i(t),A=o(t,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1sswzc8"&&(A.innerHTML=xe),Wt=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1dojeau"&&(F.innerHTML=Se),Xt=i(t),k=o(t,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-v8ek3l"&&(k.innerHTML=Qe),xt=i(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-rwb6vm"&&(G.innerHTML=Ne),St=i(t),R=o(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1gcm4iq"&&(R.innerHTML=Ye),Qt=i(t),h=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1bie0ph"&&(h.innerHTML=ze),Nt=i(t),m(V.$$.fragment,t),Yt=i(t),m(W.$$.fragment,t),zt=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-9exkfb"&&(X.innerHTML=Pe),Pt=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1t7coxe"&&(x.innerHTML=qe),qt=i(t),m(S.$$.fragment,t),Dt=i(t),m(Q.$$.fragment,t),Ot=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-z7hljb"&&(N.innerHTML=De),Kt=i(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1gp7ih6"&&(Y.innerHTML=Oe),te=i(t),m(z.$$.fragment,t),ee=i(t),m(P.$$.fragment,t),le=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-w7eu5t"&&(q.innerHTML=Ke),ne=i(t),m(D.$$.fragment,t),se=i(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1biq3pv"&&(O.textContent=tl),ie=i(t),K=o(t,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-1cfpqte"&&(K.innerHTML=el),ae=i(t),m(tt.$$.fragment,t),oe=i(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-dlsnzk"&&(et.textContent=ll),re=i(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1qwosyu"&&(lt.innerHTML=nl),Me=i(t),m(nt.$$.fragment,t),me=i(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-bqeor6"&&(st.textContent=sl),pe=i(t),it=o(t,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-1keptmg"&&(it.innerHTML=il),ue=i(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-15zzqy3"&&(at.textContent=al),ce=i(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-10khssf"&&(ot.innerHTML=ol),Te=i(t),rt=o(t,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-16wbhfu"&&(rt.innerHTML=rl),fe=i(t),m(Mt.$$.fragment,t),ye=i(t),mt=o(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-gw1iva"&&(mt.innerHTML=Ml),ge=i(t),pt=o(t,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-1xnq70w"&&(pt.innerHTML=ml),he=i(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1mihp6k"&&(ut.innerHTML=pl),Ue=i(t),ct=o(t,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-6iw3pz"&&(ct.innerHTML=ul),de=i(t),Tt=o(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-ah43vs"&&(Tt.innerHTML=cl),Je=i(t),ft=o(t,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-1f6kf7m"&&(ft.innerHTML=Tl),be=i(t),m(yt.$$.fragment,t),je=i(t),gt=o(t,"UL",{"data-svelte-h":!0}),r(gt)!=="svelte-1y75b5h"&&(gt.innerHTML=fl),we=i(t),m(ht.$$.fragment,t),Ce=i(t),wt=o(t,"P",{}),Ee(wt).forEach(l),this.h()},h(){Le(g,"name","hf:doc:metadata"),Le(g,"content",wl),Le(h,"class","tip")},m(t,e){Jt(document.head,g),n(t,Ct,e),n(t,jt,e),n(t,vt,e),p(d,t,e),n(t,_t,e),n(t,J,e),n(t,It,e),p(b,t,e),n(t,$t,e),n(t,j,e),n(t,Et,e),p(w,t,e),n(t,Lt,e),n(t,C,e),n(t,Bt,e),n(t,v,e),n(t,Zt,e),p(_,t,e),n(t,Ht,e),n(t,I,e),n(t,At,e),n(t,$,e),n(t,Ft,e),n(t,f,e),Jt(f,Ut),Jt(f,_e),p(E,f,null),Jt(f,Ie),Jt(f,dt),Jt(f,$e),p(L,f,null),n(t,kt,e),p(B,t,e),n(t,Gt,e),n(t,Z,e),n(t,Rt,e),n(t,H,e),n(t,Vt,e),n(t,A,e),n(t,Wt,e),n(t,F,e),n(t,Xt,e),n(t,k,e),n(t,xt,e),n(t,G,e),n(t,St,e),n(t,R,e),n(t,Qt,e),n(t,h,e),n(t,Nt,e),p(V,t,e),n(t,Yt,e),p(W,t,e),n(t,zt,e),n(t,X,e),n(t,Pt,e),n(t,x,e),n(t,qt,e),p(S,t,e),n(t,Dt,e),p(Q,t,e),n(t,Ot,e),n(t,N,e),n(t,Kt,e),n(t,Y,e),n(t,te,e),p(z,t,e),n(t,ee,e),p(P,t,e),n(t,le,e),n(t,q,e),n(t,ne,e),p(D,t,e),n(t,se,e),n(t,O,e),n(t,ie,e),n(t,K,e),n(t,ae,e),p(tt,t,e),n(t,oe,e),n(t,et,e),n(t,re,e),n(t,lt,e),n(t,Me,e),p(nt,t,e),n(t,me,e),n(t,st,e),n(t,pe,e),n(t,it,e),n(t,ue,e),n(t,at,e),n(t,ce,e),n(t,ot,e),n(t,Te,e),n(t,rt,e),n(t,fe,e),p(Mt,t,e),n(t,ye,e),n(t,mt,e),n(t,ge,e),n(t,pt,e),n(t,he,e),n(t,ut,e),n(t,Ue,e),n(t,ct,e),n(t,de,e),n(t,Tt,e),n(t,Je,e),n(t,ft,e),n(t,be,e),p(yt,t,e),n(t,je,e),n(t,gt,e),n(t,we,e),p(ht,t,e),n(t,Ce,e),n(t,wt,e),ve=!0},p:gl,i(t){ve||(u(d.$$.fragment,t),u(b.$$.fragment,t),u(w.$$.fragment,t),u(_.$$.fragment,t),u(E.$$.fragment,t),u(L.$$.fragment,t),u(B.$$.fragment,t),u(V.$$.fragment,t),u(W.$$.fragment,t),u(S.$$.fragment,t),u(Q.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(tt.$$.fragment,t),u(nt.$$.fragment,t),u(Mt.$$.fragment,t),u(yt.$$.fragment,t),u(ht.$$.fragment,t),ve=!0)},o(t){c(d.$$.fragment,t),c(b.$$.fragment,t),c(w.$$.fragment,t),c(_.$$.fragment,t),c(E.$$.fragment,t),c(L.$$.fragment,t),c(B.$$.fragment,t),c(V.$$.fragment,t),c(W.$$.fragment,t),c(S.$$.fragment,t),c(Q.$$.fragment,t),c(z.$$.fragment,t),c(P.$$.fragment,t),c(D.$$.fragment,t),c(tt.$$.fragment,t),c(nt.$$.fragment,t),c(Mt.$$.fragment,t),c(yt.$$.fragment,t),c(ht.$$.fragment,t),ve=!1},d(t){t&&(l(Ct),l(jt),l(vt),l(_t),l(J),l(It),l($t),l(j),l(Et),l(Lt),l(C),l(Bt),l(v),l(Zt),l(Ht),l(I),l(At),l($),l(Ft),l(f),l(kt),l(Gt),l(Z),l(Rt),l(H),l(Vt),l(A),l(Wt),l(F),l(Xt),l(k),l(xt),l(G),l(St),l(R),l(Qt),l(h),l(Nt),l(Yt),l(zt),l(X),l(Pt),l(x),l(qt),l(Dt),l(Ot),l(N),l(Kt),l(Y),l(te),l(ee),l(le),l(q),l(ne),l(se),l(O),l(ie),l(K),l(ae),l(oe),l(et),l(re),l(lt),l(Me),l(me),l(st),l(pe),l(it),l(ue),l(at),l(ce),l(ot),l(Te),l(rt),l(fe),l(ye),l(mt),l(ge),l(pt),l(he),l(ut),l(Ue),l(ct),l(de),l(Tt),l(Je),l(ft),l(be),l(je),l(gt),l(we),l(Ce),l(wt)),l(g),T(d,t),T(b,t),T(w,t),T(_,t),T(E),T(L),T(B,t),T(V,t),T(W,t),T(S,t),T(Q,t),T(z,t),T(P,t),T(D,t),T(tt,t),T(nt,t),T(Mt,t),T(yt,t),T(ht,t)}}}const wl='{"title":"Training with Hugging Face Jobs","local":"training-with-hugging-face-jobs","sections":[{"title":"Why Use Jobs for SFT Training?","local":"why-use-jobs-for-sft-training","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Running SFT with Jobs: Two Approaches","local":"running-sft-with-jobs-two-approaches","sections":[],"depth":2},{"title":"Hardware Selection for SFT","local":"hardware-selection-for-sft","sections":[],"depth":2},{"title":"Advanced Jobs Configuration","local":"advanced-jobs-configuration","sections":[],"depth":2},{"title":"Monitoring Your Training Job","local":"monitoring-your-training-job","sections":[],"depth":2},{"title":"LoRA/PEFT on Jobs (optional)","local":"lorapeft-on-jobs-optional","sections":[],"depth":2},{"title":"Monitoring with Trackio","local":"monitoring-with-trackio","sections":[],"depth":2},{"title":"Cost Estimation","local":"cost-estimation","sections":[],"depth":2},{"title":"Troubleshooting Common Issues","local":"troubleshooting-common-issues","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function Cl(Be){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Ul{constructor(g){super(),dl(this,g,Cl,jl,yl,{})}}export{El as component};
