# ビジュアル言語モデル

<CourseFloatingBanner chapter={10}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ja/5_vision_language_models/vlm_usage_sample.ipynb"},
]} />
    
ビジュアル言語モデル（VLM）は、画像とテキストの間のギャップを埋め、画像キャプションの生成、視覚に基づく質問への回答、テキストと視覚データの関係の理解などの高度なタスクを可能にします。そのアーキテクチャは、両方のモダリティをシームレスに処理するように設計されています。

### アーキテクチャ

VLMは、画像処理コンポーネントとテキスト生成モデルを組み合わせて、統一された理解を実現します。主な要素は次のとおりです：

![VLMアーキテクチャ](./images/VLM_Architecture.png)

- **画像エンコーダ**：生の画像をコンパクトな数値表現に変換します。CLIPやビジョントランスフォーマー（ViT）などの事前トレーニングされたエンコーダが一般的に使用されます。
- **埋め込みプロジェクタ**：画像特徴をテキスト埋め込みと互換性のある空間にマッピングします。通常、密な層や線形変換を使用します。
- **テキストデコーダ**：マルチモーダル情報を翻訳して一貫したテキストを生成する言語生成コンポーネントです。LlamaやVicunaなどの生成モデルが例として挙げられます。
- **マルチモーダルプロジェクタ**：画像とテキストの表現をブレンドするための追加の層を提供します。LLaVAのようなモデルでは、2つのモダリティ間の強力な接続を確立するために重要です。

ほとんどのVLMは、事前トレーニングされた画像エンコーダとテキストデコーダを活用し、ペアになった画像テキストデータセットで追加のファインチューニングを行います。このアプローチにより、効率的なトレーニングが可能になり、モデルが効果的に一般化できるようになります。

### 使用方法

![VLMプロセス](./images/VLM_Process.png)

VLMは、さまざまなマルチモーダルタスクに適用されます。その適応性により、さまざまなドメインで異なるレベルのファインチューニングを行うことができます：

- **画像キャプション生成**：画像の説明を生成します。
- **視覚質問応答（VQA）**：画像の内容に関する質問に答えます。
- **クロスモーダル検索**：特定の画像に対応するテキストを見つける、またはその逆を行います。
- **クリエイティブなアプリケーション**：デザイン支援、アート生成、魅力的なマルチメディアコンテンツの作成などに役立ちます。

![VLMの使用](./images/VLM_Usage.png)

VLMのトレーニングとファインチューニングには、画像とテキストの注釈がペアになった高品質なデータセットが必要です。Hugging Faceの`transformers`ライブラリなどのツールを使用すると、事前トレーニングされたVLMに簡単にアクセスでき、カスタムファインチューニングのワークフローが簡素化されます。

### チャット形式

多くのVLMは、使いやすさを向上させるためにチャットボットのような形式で構造化されています。この形式には次の要素が含まれます：

- モデルの役割やコンテキストを設定する**システムメッセージ**（例：「あなたは視覚データを分析するアシスタントです」）。
- テキスト入力と関連する画像を組み合わせた**ユーザークエリ**。
- マルチモーダル分析から得られたテキスト出力を提供する**アシスタントの応答**。

この会話形式は直感的であり、特にカスタマーサービスや教育ツールなどのインタラクティブなアプリケーションにおいて、ユーザーの期待に沿ったものです。

フォーマットされた入力の例を次に示します：

```json
[
    {
        "role": "system",
        "content": [{"type": "text", "text": "あなたはチャート画像の視覚データを解釈する専門のビジュアル言語モデルです..."}]
    },
    {
        "role": "user",
        "content": [
            {"type": "image", "image": "<image_data>"},
            {"type": "text", "text": "棒グラフの最高値は何ですか？"}
        ]
    },
    {
        "role": "assistant",
        "content": [{"type": "text", "text": "42"}]
    }
]
```

**複数の画像やビデオの処理**

VLMは、入力構造を適応させることで、複数の画像やビデオを処理することもできます。ビデオの場合、フレームを抽出して個々の画像として処理し、時間順序を維持します。

## リソース

- [Hugging Face Blog: Vision Language Models](https://huggingface.co/blog/vlms)
- [Hugging Face Blog: SmolVLM](https://huggingface.co/blog/smolvlm)

## 次のステップ

⏩ SMOLVLMのさまざまな使用方法を試すには、[vlm_usage_sample.ipynb](../../../notebooks/ja/5_vision_language_models/vlm_usage_sample.ipynb)を試してください。


<EditOnGithub source="https://github.com/huggingface/smol-course/blob/main/units/ja/unit5/2.md" />