% Intrinsic and Extrinsic Camera Parameters
%
% This script file can be directly excecuted under Matlab to recover the camera intrinsic and extrinsic parameters.
% IMPORTANT: This file contains neither the structure of the calibration objects nor the image coordinates of the calibration points.
%            All those complementary variables are saved in the complete matlab data file Calib_Results.mat.
% For more information regarding the calibration model visit http://www.vision.caltech.edu/bouguetj/calib_doc/


%-- Focal length:
fc = [ 2900.120764843560200 ; 2890.562160275289900 ];

%-- Principal point:
cc = [ 791.168475644626030 ; 656.274844704592970 ];

%-- Skew coefficient:
alpha_c = 0.000000000000000;

%-- Distortion coefficients:
kc = [ -0.100948219381907 ; -0.077809384496636 ; 0.000983634473606 ; 0.000597688349750 ; 0.000000000000000 ];

%-- Focal length uncertainty:
fc_error = [ 0.803697920313549 ; 0.769131117812338 ];

%-- Principal point uncertainty:
cc_error = [ 1.028541571877633 ; 1.035561608596494 ];

%-- Skew coefficient uncertainty:
alpha_c_error = 0.000000000000000;

%-- Distortion coefficients uncertainty:
kc_error = [ 0.001753090964391 ; 0.016930058673965 ; 0.000095025640099 ; 0.000115978118221 ; 0.000000000000000 ];

%-- Image size:
nx = 1600;
ny = 1200;


%-- Various other variables (may be ignored if you do not use the Matlab Calibration Toolbox):
%-- Those variables are used to control which intrinsic parameters should be optimized

n_ima = 94;						% Number of calibration images
est_fc = [ 1 ; 1 ];					% Estimation indicator of the two focal variables
est_aspect_ratio = 1;				% Estimation indicator of the aspect ratio fc(2)/fc(1)
center_optim = 1;					% Estimation indicator of the principal point
est_alpha = 0;						% Estimation indicator of the skew coefficient
est_dist = [ 1 ; 1 ; 1 ; 1 ; 0 ];	% Estimation indicator of the distortion coefficients


%-- Extrinsic parameters:
%-- The rotation (omc_kk) and the translation (Tc_kk) vectors for every calibration image and their uncertainties

%-- Image #1:
omc_1 = [ 2.451191e+00 ; 8.103640e-01 ; 1.512459e+00 ];
Tc_1  = [ -4.001425e+01 ; 8.309583e+00 ; 5.637561e+02 ];
omc_error_1 = [ 4.332546e-04 ; 2.411228e-04 ; 5.042386e-04 ];
Tc_error_1  = [ 2.008687e-01 ; 2.022145e-01 ; 1.783761e-01 ];

%-- Image #2:
omc_2 = [ -2.358124e+00 ; -1.443210e+00 ; -1.276255e+00 ];
Tc_2  = [ -4.915187e+01 ; -3.637459e+01 ; 5.815666e+02 ];
omc_error_2 = [ 2.900072e-04 ; 3.834030e-04 ; 5.421647e-04 ];
Tc_error_2  = [ 2.074174e-01 ; 2.086393e-01 ; 1.824733e-01 ];

%-- Image #3:
omc_3 = [ -1.932980e+00 ; -1.836013e+00 ; -8.675640e-01 ];
Tc_3  = [ -3.410420e+01 ; -7.853292e+01 ; 6.016733e+02 ];
omc_error_3 = [ 2.637785e-04 ; 3.681301e-04 ; 5.521742e-04 ];
Tc_error_3  = [ 2.146867e-01 ; 2.160182e-01 ; 1.900160e-01 ];

%-- Image #4:
omc_4 = [ -1.450630e+00 ; -2.079991e+00 ; -4.592356e-01 ];
Tc_4  = [ 1.397649e+00 ; -1.070208e+02 ; 6.175907e+02 ];
omc_error_4 = [ 2.363476e-04 ; 3.651348e-04 ; 5.569254e-04 ];
Tc_error_4  = [ 2.207549e-01 ; 2.223612e-01 ; 1.950045e-01 ];

%-- Image #5:
omc_5 = [ -9.376729e-01 ; -2.187921e+00 ; -7.055597e-02 ];
Tc_5  = [ 4.887067e+01 ; -1.145222e+02 ; 6.248854e+02 ];
omc_error_5 = [ 2.193704e-04 ; 3.723915e-04 ; 5.013466e-04 ];
Tc_error_5  = [ 2.235536e-01 ; 2.253317e-01 ; 1.943163e-01 ];

%-- Image #6:
omc_6 = [ -1.032894e+00 ; -2.213278e+00 ; 1.627483e-01 ];
Tc_6  = [ 4.947931e+01 ; -1.108515e+02 ; 6.441572e+02 ];
omc_error_6 = [ 2.386840e-04 ; 3.730194e-04 ; 5.189194e-04 ];
Tc_error_6  = [ 2.300085e-01 ; 2.318203e-01 ; 1.942856e-01 ];

%-- Image #7:
omc_7 = [ -1.386987e+00 ; -2.195761e+00 ; -1.060797e-01 ];
Tc_7  = [ 1.717803e+01 ; -1.093729e+02 ; 6.399560e+02 ];
omc_error_7 = [ 2.534974e-04 ; 3.807736e-04 ; 6.129806e-04 ];
Tc_error_7  = [ 2.286358e-01 ; 2.302852e-01 ; 1.955987e-01 ];

%-- Image #8:
omc_8 = [ -1.736543e+00 ; -2.118560e+00 ; -3.977401e-01 ];
Tc_8  = [ -1.228297e+01 ; -9.841753e+01 ; 6.300479e+02 ];
omc_error_8 = [ 2.803676e-04 ; 3.868384e-04 ; 6.726011e-04 ];
Tc_error_8  = [ 2.248769e-01 ; 2.264691e-01 ; 1.979357e-01 ];

%-- Image #9:
omc_9 = [ -2.069380e+00 ; -1.970560e+00 ; -7.116369e-01 ];
Tc_9  = [ -3.458188e+01 ; -7.918526e+01 ; 6.142841e+02 ];
omc_error_9 = [ 2.845101e-04 ; 3.781305e-04 ; 6.341798e-04 ];
Tc_error_9  = [ 2.191671e-01 ; 2.204061e-01 ; 1.926656e-01 ];

%-- Image #10:
omc_10 = [ -2.373697e+00 ; -1.746428e+00 ; -1.036630e+00 ];
Tc_10  = [ -4.742711e+01 ; -5.365343e+01 ; 5.951852e+02 ];
omc_error_10 = [ 2.756032e-04 ; 3.834189e-04 ; 5.979895e-04 ];
Tc_error_10  = [ 2.123995e-01 ; 2.134884e-01 ; 1.861788e-01 ];

%-- Image #11:
omc_11 = [ 2.382354e+00 ; 1.299670e+00 ; 1.232420e+00 ];
Tc_11  = [ -4.844818e+01 ; -2.578223e+01 ; 5.760345e+02 ];
omc_error_11 = [ 4.232312e-04 ; 1.977354e-04 ; 5.357710e-04 ];
Tc_error_11  = [ 2.054990e-01 ; 2.066418e-01 ; 1.816719e-01 ];

%-- Image #12:
omc_12 = [ 2.163432e+00 ; 9.410732e-01 ; 1.198306e+00 ];
Tc_12  = [ -3.877966e+01 ; -9.711242e+00 ; 5.586266e+02 ];
omc_error_12 = [ 4.062928e-04 ; 2.355045e-04 ; 4.559478e-04 ];
Tc_error_12  = [ 1.990954e-01 ; 2.003686e-01 ; 1.786669e-01 ];

%-- Image #13:
omc_13 = [ 2.242003e+00 ; 1.268891e+00 ; 1.067576e+00 ];
Tc_13  = [ -4.811859e+01 ; -2.768400e+01 ; 5.756877e+02 ];
omc_error_13 = [ 4.049893e-04 ; 2.084828e-04 ; 5.059594e-04 ];
Tc_error_13  = [ 2.053752e-01 ; 2.065055e-01 ; 1.813874e-01 ];

%-- Image #14:
omc_14 = [ 2.288447e+00 ; 1.601209e+00 ; 9.064928e-01 ];
Tc_14  = [ -4.987468e+01 ; -4.651794e+01 ; 5.944950e+02 ];
omc_error_14 = [ 4.021186e-04 ; 2.067695e-04 ; 5.710653e-04 ];
Tc_error_14  = [ 2.121688e-01 ; 2.132168e-01 ; 1.850233e-01 ];

%-- Image #15:
omc_15 = [ 2.296938e+00 ; 1.934206e+00 ; 7.135601e-01 ];
Tc_15  = [ -4.425025e+01 ; -6.450574e+01 ; 6.135262e+02 ];
omc_error_15 = [ 4.035079e-04 ; 2.503756e-04 ; 6.735516e-04 ];
Tc_error_15  = [ 2.189216e-01 ; 2.199793e-01 ; 1.899897e-01 ];

%-- Image #16:
omc_16 = [ -2.130209e+00 ; -2.129307e+00 ; -4.581664e-01 ];
Tc_16  = [ -3.259133e+01 ; -8.022574e+01 ; 6.312076e+02 ];
omc_error_16 = [ 3.605705e-04 ; 4.281009e-04 ; 8.152272e-04 ];
Tc_error_16  = [ 2.250909e-01 ; 2.263811e-01 ; 1.978235e-01 ];

%-- Image #17:
omc_17 = [ -1.862763e+00 ; -2.204490e+00 ; -1.918594e-01 ];
Tc_17  = [ -1.410230e+01 ; -9.248893e+01 ; 6.458775e+02 ];
omc_error_17 = [ 3.906592e-04 ; 4.856031e-04 ; 9.428704e-04 ];
Tc_error_17  = [ 2.302695e-01 ; 2.319932e-01 ; 2.034985e-01 ];

%-- Image #18:
omc_18 = [ -1.586294e+00 ; -2.237096e+00 ; 4.804446e-02 ];
Tc_18  = [ 8.603516e+00 ; -1.002637e+02 ; 6.557611e+02 ];
omc_error_18 = [ 3.145530e-04 ; 4.259376e-04 ; 7.495443e-04 ];
Tc_error_18  = [ 2.338740e-01 ; 2.355337e-01 ; 1.951558e-01 ];

%-- Image #19:
omc_19 = [ -1.307020e+00 ; -2.234286e+00 ; 2.705718e-01 ];
Tc_19  = [ 3.413311e+01 ; -1.031553e+02 ; 6.615684e+02 ];
omc_error_19 = [ 2.728686e-04 ; 3.787921e-04 ; 5.834493e-04 ];
Tc_error_19  = [ 2.358234e-01 ; 2.375897e-01 ; 1.927022e-01 ];

%-- Image #20:
omc_20 = [ -1.291399e+00 ; -2.206774e+00 ; 5.970580e-01 ];
Tc_20  = [ 4.526948e+01 ; -9.217940e+01 ; 6.792897e+02 ];
omc_error_20 = [ 2.945389e-04 ; 3.507058e-04 ; 5.364885e-04 ];
Tc_error_20  = [ 2.416735e-01 ; 2.436975e-01 ; 1.902508e-01 ];

%-- Image #21:
omc_21 = [ -1.529638e+00 ; -2.254284e+00 ; 4.168770e-01 ];
Tc_21  = [ 2.336878e+01 ; -9.216801e+01 ; 6.767347e+02 ];
omc_error_21 = [ 3.173755e-04 ; 3.866377e-04 ; 6.465889e-04 ];
Tc_error_21  = [ 2.408442e-01 ; 2.425807e-01 ; 1.895320e-01 ];

%-- Image #22:
omc_22 = [ -1.765871e+00 ; -2.276899e+00 ; 2.183415e-01 ];
Tc_22  = [ 2.202771e+00 ; -8.925077e+01 ; 6.697072e+02 ];
omc_error_22 = [ 4.120554e-04 ; 5.092090e-04 ; 9.316511e-04 ];
Tc_error_22  = [ 2.384167e-01 ; 2.400364e-01 ; 1.910754e-01 ];

%-- Image #23:
omc_23 = [ -1.998842e+00 ; -2.273133e+00 ; 8.341229e-03 ];
Tc_23  = [ -1.639424e+01 ; -8.369629e+01 ; 6.594629e+02 ];
omc_error_23 = [ 7.269575e-04 ; 8.456625e-04 ; 1.717285e-03 ];
Tc_error_23  = [ 2.346530e-01 ; 2.366954e-01 ; 2.135817e-01 ];

%-- Image #24:
omc_24 = [ 2.188760e+00 ; 2.201544e+00 ; 2.238302e-01 ];
Tc_24  = [ -3.137460e+01 ; -7.572520e+01 ; 6.453672e+02 ];
omc_error_24 = [ 5.415503e-04 ; 5.142242e-04 ; 1.138592e-03 ];
Tc_error_24  = [ 2.299211e-01 ; 2.313326e-01 ; 2.029304e-01 ];

%-- Image #25:
omc_25 = [ 2.200014e+00 ; 1.954878e+00 ; 4.367785e-01 ];
Tc_25  = [ -4.251781e+01 ; -6.559010e+01 ; 6.283712e+02 ];
omc_error_25 = [ 4.098049e-04 ; 3.087513e-04 ; 7.303775e-04 ];
Tc_error_25  = [ 2.240575e-01 ; 2.252108e-01 ; 1.916822e-01 ];

%-- Image #26:
omc_26 = [ 2.183130e+00 ; 1.701593e+00 ; 6.274785e-01 ];
Tc_26  = [ -4.978027e+01 ; -5.396775e+01 ; 6.098148e+02 ];
omc_error_26 = [ 3.854273e-04 ; 2.391605e-04 ; 5.888708e-04 ];
Tc_error_26  = [ 2.175434e-01 ; 2.186433e-01 ; 1.864921e-01 ];

%-- Image #27:
omc_27 = [ 2.141957e+00 ; 1.448043e+00 ; 7.948304e-01 ];
Tc_27  = [ -5.051151e+01 ; -4.149965e+01 ; 5.908994e+02 ];
omc_error_27 = [ 3.849319e-04 ; 2.199231e-04 ; 5.160110e-04 ];
Tc_error_27  = [ 2.107790e-01 ; 2.119097e-01 ; 1.827327e-01 ];

%-- Image #28:
omc_28 = [ 2.078955e+00 ; 1.194097e+00 ; 9.418232e-01 ];
Tc_28  = [ -4.592342e+01 ; -2.912904e+01 ; 5.726280e+02 ];
omc_error_28 = [ 3.892357e-04 ; 2.276245e-04 ; 4.655026e-04 ];
Tc_error_28  = [ 2.041618e-01 ; 2.053711e-01 ; 1.796684e-01 ];

%-- Image #29:
omc_29 = [ 1.857755e+00 ; 1.023697e+00 ; 8.989219e-01 ];
Tc_29  = [ -3.867816e+01 ; -2.869160e+01 ; 5.604124e+02 ];
omc_error_29 = [ 3.794281e-04 ; 2.587977e-04 ; 4.059295e-04 ];
Tc_error_29  = [ 1.995656e-01 ; 2.009411e-01 ; 1.759738e-01 ];

%-- Image #30:
omc_30 = [ 1.938045e+00 ; 1.228361e+00 ; 7.646528e-01 ];
Tc_30  = [ -4.730845e+01 ; -3.584360e+01 ; 5.775058e+02 ];
omc_error_30 = [ 3.729258e-04 ; 2.428911e-04 ; 4.432408e-04 ];
Tc_error_30  = [ 2.057852e-01 ; 2.070820e-01 ; 1.785724e-01 ];

%-- Image #31:
omc_31 = [ 2.004818e+00 ; 1.432638e+00 ; 6.153516e-01 ];
Tc_31  = [ -5.139395e+01 ; -4.343834e+01 ; 5.960262e+02 ];
omc_error_31 = [ 3.668349e-04 ; 2.382623e-04 ; 4.871029e-04 ];
Tc_error_31  = [ 2.124274e-01 ; 2.136991e-01 ; 1.815157e-01 ];

%-- Image #32:
omc_32 = [ 2.056320e+00 ; 1.635494e+00 ; 4.508537e-01 ];
Tc_32  = [ -5.109086e+01 ; -5.110382e+01 ; 6.149790e+02 ];
omc_error_32 = [ 3.649742e-04 ; 2.521594e-04 ; 5.463373e-04 ];
Tc_error_32  = [ 2.191379e-01 ; 2.204381e-01 ; 1.847072e-01 ];

%-- Image #33:
omc_33 = [ 2.090574e+00 ; 1.835355e+00 ; 2.706348e-01 ];
Tc_33  = [ -4.623619e+01 ; -5.822381e+01 ; 6.333906e+02 ];
omc_error_33 = [ 3.788363e-04 ; 2.972506e-04 ; 6.458336e-04 ];
Tc_error_33  = [ 2.255544e-01 ; 2.269604e-01 ; 1.881977e-01 ];

%-- Image #34:
omc_34 = [ 2.105463e+00 ; 2.030918e+00 ; 7.397712e-02 ];
Tc_34  = [ -3.758520e+01 ; -6.459115e+01 ; 6.504733e+02 ];
omc_error_34 = [ 4.433183e-04 ; 4.061735e-04 ; 8.626885e-04 ];
Tc_error_34  = [ 2.313698e-01 ; 2.330084e-01 ; 1.923381e-01 ];

%-- Image #35:
omc_35 = [ 2.099105e+00 ; 2.220158e+00 ; -1.365137e-01 ];
Tc_35  = [ -2.508610e+01 ; -7.001807e+01 ; 6.654914e+02 ];
omc_error_35 = [ 5.838499e-04 ; 6.025620e-04 ; 1.255573e-03 ];
Tc_error_35  = [ 2.362920e-01 ; 2.382267e-01 ; 1.932671e-01 ];

%-- Image #36:
omc_36 = [ -2.003800e+00 ; -2.325015e+00 ; 3.485406e-01 ];
Tc_36  = [ -9.390154e+00 ; -7.420002e+01 ; 6.778153e+02 ];
omc_error_36 = [ 4.859223e-04 ; 5.365100e-04 ; 1.051706e-03 ];
Tc_error_36  = [ 2.408049e-01 ; 2.424710e-01 ; 1.854461e-01 ];

%-- Image #37:
omc_37 = [ -1.790846e+00 ; -2.286674e+00 ; 5.381173e-01 ];
Tc_37  = [ 8.819473e+00 ; -7.700361e+01 ; 6.867846e+02 ];
omc_error_37 = [ 3.713989e-04 ; 3.929078e-04 ; 7.291727e-04 ];
Tc_error_37  = [ 2.440809e-01 ; 2.457925e-01 ; 1.854238e-01 ];

%-- Image #38:
omc_38 = [ -1.576512e+00 ; -2.229424e+00 ; 7.085727e-01 ];
Tc_38  = [ 2.842801e+01 ; -7.825571e+01 ; 6.920078e+02 ];
omc_error_38 = [ 3.342550e-04 ; 3.383183e-04 ; 5.908886e-04 ];
Tc_error_38  = [ 2.459242e-01 ; 2.478670e-01 ; 1.867983e-01 ];

%-- Image #39:
omc_39 = [ -1.530966e+00 ; -2.119795e+00 ; 1.058523e+00 ];
Tc_39  = [ 4.226981e+01 ; -6.108136e+01 ; 7.041587e+02 ];
omc_error_39 = [ 3.572598e-04 ; 2.981790e-04 ; 5.257225e-04 ];
Tc_error_39  = [ 2.500667e-01 ; 2.523648e-01 ; 1.856300e-01 ];

%-- Image #40:
omc_40 = [ -1.730659e+00 ; -2.210683e+00 ; 9.229803e-01 ];
Tc_40  = [ 2.382934e+01 ; -6.071072e+01 ; 7.020917e+02 ];
omc_error_40 = [ 3.650761e-04 ; 3.012666e-04 ; 5.870689e-04 ];
Tc_error_40  = [ 2.492973e-01 ; 2.513439e-01 ; 1.849082e-01 ];

%-- Image #41:
omc_41 = [ -1.930209e+00 ; -2.288917e+00 ; 7.671461e-01 ];
Tc_41  = [ 5.925201e+00 ; -6.018900e+01 ; 6.963779e+02 ];
omc_error_41 = [ 3.825629e-04 ; 3.236116e-04 ; 6.747615e-04 ];
Tc_error_41  = [ 2.472570e-01 ; 2.491025e-01 ; 1.842142e-01 ];

%-- Image #42:
omc_42 = [ 2.016332e+00 ; 2.227396e+00 ; -5.596269e-01 ];
Tc_42  = [ -1.056844e+01 ; -5.875070e+01 ; 6.870950e+02 ];
omc_error_42 = [ 3.342519e-04 ; 4.203423e-04 ; 7.541062e-04 ];
Tc_error_42  = [ 2.439063e-01 ; 2.457024e-01 ; 1.843793e-01 ];

%-- Image #43:
omc_43 = [ 2.020004e+00 ; 2.081201e+00 ; -3.403892e-01 ];
Tc_43  = [ -2.603679e+01 ; -5.660633e+01 ; 6.744297e+02 ];
omc_error_43 = [ 3.715410e-04 ; 4.047716e-04 ; 7.564756e-04 ];
Tc_error_43  = [ 2.393556e-01 ; 2.412626e-01 ; 1.862241e-01 ];

%-- Image #44:
omc_44 = [ 2.006824e+00 ; 1.930063e+00 ; -1.347948e-01 ];
Tc_44  = [ -3.752599e+01 ; -5.425722e+01 ; 6.596502e+02 ];
omc_error_44 = [ 3.610370e-04 ; 3.503909e-04 ; 6.706230e-04 ];
Tc_error_44  = [ 2.342526e-01 ; 2.361230e-01 ; 1.871505e-01 ];

%-- Image #45:
omc_45 = [ 1.977423e+00 ; 1.773008e+00 ; 5.907901e-02 ];
Tc_45  = [ -4.569359e+01 ; -5.144878e+01 ; 6.428525e+02 ];
omc_error_45 = [ 3.466349e-04 ; 2.993021e-04 ; 5.778595e-04 ];
Tc_error_45  = [ 2.285159e-01 ; 2.302241e-01 ; 1.858731e-01 ];

%-- Image #46:
omc_46 = [ 1.933633e+00 ; 1.611314e+00 ; 2.399381e-01 ];
Tc_46  = [ -5.034951e+01 ; -4.825721e+01 ; 6.246284e+02 ];
omc_error_46 = [ 3.442874e-04 ; 2.693660e-04 ; 5.120833e-04 ];
Tc_error_46  = [ 2.222233e-01 ; 2.237863e-01 ; 1.835362e-01 ];

%-- Image #47:
omc_47 = [ 1.876306e+00 ; 1.444183e+00 ; 4.096878e-01 ];
Tc_47  = [ -5.198037e+01 ; -4.493520e+01 ; 6.056236e+02 ];
omc_error_47 = [ 3.490989e-04 ; 2.575097e-04 ; 4.640403e-04 ];
Tc_error_47  = [ 2.155891e-01 ; 2.170565e-01 ; 1.808637e-01 ];

%-- Image #48:
omc_48 = [ 1.807501e+00 ; 1.276175e+00 ; 5.654224e-01 ];
Tc_48  = [ -4.845448e+01 ; -4.157464e+01 ; 5.869212e+02 ];
omc_error_48 = [ 3.568765e-04 ; 2.589755e-04 ; 4.255957e-04 ];
Tc_error_48  = [ 2.089515e-01 ; 2.103821e-01 ; 1.779625e-01 ];

%-- Image #49:
omc_49 = [ 1.727795e+00 ; 1.106177e+00 ; 7.095577e-01 ];
Tc_49  = [ -4.139633e+01 ; -3.839542e+01 ; 5.693267e+02 ];
omc_error_49 = [ 3.650461e-04 ; 2.697484e-04 ; 3.913788e-04 ];
Tc_error_49  = [ 2.026321e-01 ; 2.040795e-01 ; 1.752335e-01 ];

%-- Image #50:
omc_50 = [ 2.160667e+00 ; 1.546569e+00 ; 7.325152e-01 ];
Tc_50  = [ -8.000908e+01 ; -4.942572e+01 ; 8.412527e+02 ];
omc_error_50 = [ 4.155305e-04 ; 2.635721e-04 ; 6.019232e-04 ];
Tc_error_50  = [ 3.004286e-01 ; 3.021633e-01 ; 2.670421e-01 ];

%-- Image #51:
omc_51 = [ 2.193219e+00 ; 1.818190e+00 ; 5.435588e-01 ];
Tc_51  = [ -7.696869e+01 ; -6.245704e+01 ; 8.612963e+02 ];
omc_error_51 = [ 4.534896e-04 ; 3.389186e-04 ; 7.694110e-04 ];
Tc_error_51  = [ 3.075556e-01 ; 3.093235e-01 ; 2.732165e-01 ];

%-- Image #52:
omc_52 = [ 2.196300e+00 ; 2.085983e+00 ; 3.277874e-01 ];
Tc_52  = [ -6.746869e+01 ; -7.415264e+01 ; 8.804324e+02 ];
omc_error_52 = [ 6.238856e-04 ; 5.833581e-04 ; 1.262443e-03 ];
Tc_error_52  = [ 3.141866e-01 ; 3.161639e-01 ; 2.874288e-01 ];

%-- Image #53:
omc_53 = [ -2.090036e+00 ; -2.265685e+00 ; -8.137810e-02 ];
Tc_53  = [ -5.307134e+01 ; -8.401348e+01 ; 8.973355e+02 ];
omc_error_53 = [ 1.284060e-03 ; 1.364790e-03 ; 2.915797e-03 ];
Tc_error_53  = [ 3.190528e-01 ; 3.221782e-01 ; 3.320684e-01 ];

%-- Image #54:
omc_54 = [ -1.840640e+00 ; -2.279559e+00 ; 1.500729e-01 ];
Tc_54  = [ -3.384464e+01 ; -9.105840e+01 ; 9.094905e+02 ];
omc_error_54 = [ 5.736556e-04 ; 6.793405e-04 ; 1.306910e-03 ];
Tc_error_54  = [ 3.235522e-01 ; 3.259640e-01 ; 2.704951e-01 ];

%-- Image #55:
omc_55 = [ -1.943713e+00 ; -2.316467e+00 ; 4.271014e-01 ];
Tc_55  = [ -3.360453e+01 ; -7.769192e+01 ; 9.252202e+02 ];
omc_error_55 = [ 5.095815e-04 ; 5.469913e-04 ; 1.067539e-03 ];
Tc_error_55  = [ 3.288569e-01 ; 3.315847e-01 ; 2.595167e-01 ];

%-- Image #56:
omc_56 = [ 2.089724e+00 ; 2.257810e+00 ; -2.043494e-01 ];
Tc_56  = [ -5.025402e+01 ; -7.339749e+01 ; 9.129360e+02 ];
omc_error_56 = [ 7.658090e-04 ; 8.444932e-04 ; 1.700277e-03 ];
Tc_error_56  = [ 3.241349e-01 ; 3.271674e-01 ; 2.641319e-01 ];

%-- Image #57:
omc_57 = [ 2.098969e+00 ; 2.058975e+00 ; 2.096192e-02 ];
Tc_57  = [ -6.439855e+01 ; -6.786313e+01 ; 8.972911e+02 ];
omc_error_57 = [ 6.369061e-04 ; 6.317303e-04 ; 1.311636e-03 ];
Tc_error_57  = [ 3.191357e-01 ; 3.216911e-01 ; 2.772203e-01 ];

%-- Image #58:
omc_58 = [ 2.085691e+00 ; 1.853859e+00 ; 2.327996e-01 ];
Tc_58  = [ -7.428413e+01 ; -6.139666e+01 ; 8.793741e+02 ];
omc_error_58 = [ 4.557492e-04 ; 3.939379e-04 ; 8.235397e-04 ];
Tc_error_58  = [ 3.133492e-01 ; 3.154879e-01 ; 2.727799e-01 ];

%-- Image #59:
omc_59 = [ 2.050017e+00 ; 1.643397e+00 ; 4.271895e-01 ];
Tc_59  = [ -7.957400e+01 ; -5.421420e+01 ; 8.598235e+02 ];
omc_error_59 = [ 4.005747e-04 ; 3.014531e-04 ; 6.269074e-04 ];
Tc_error_59  = [ 3.066305e-01 ; 3.086213e-01 ; 2.681529e-01 ];

%-- Image #60:
omc_60 = [ 1.871677e+00 ; 1.481370e+00 ; 3.438891e-01 ];
Tc_60  = [ -8.223659e+01 ; -4.870487e+01 ; 8.541765e+02 ];
omc_error_60 = [ 3.640749e-04 ; 2.896242e-04 ; 5.148211e-04 ];
Tc_error_60  = [ 3.042629e-01 ; 3.065621e-01 ; 2.647064e-01 ];

%-- Image #61:
omc_61 = [ 1.930644e+00 ; 1.655178e+00 ; 1.576957e-01 ];
Tc_61  = [ -7.855874e+01 ; -5.193537e+01 ; 8.746354e+02 ];
omc_error_61 = [ 3.713311e-04 ; 3.198652e-04 ; 5.949517e-04 ];
Tc_error_61  = [ 3.112422e-01 ; 3.137562e-01 ; 2.677743e-01 ];

%-- Image #62:
omc_62 = [ 1.973927e+00 ; 1.822382e+00 ; -4.098714e-02 ];
Tc_62  = [ -7.244222e+01 ; -5.491287e+01 ; 8.937399e+02 ];
omc_error_62 = [ 3.956279e-04 ; 3.787304e-04 ; 7.136793e-04 ];
Tc_error_62  = [ 3.176221e-01 ; 3.204588e-01 ; 2.700645e-01 ];

%-- Image #63:
omc_63 = [ 2.000292e+00 ; 1.984079e+00 ; -2.531555e-01 ];
Tc_63  = [ -6.204399e+01 ; -5.786293e+01 ; 9.109238e+02 ];
omc_error_63 = [ 4.283879e-04 ; 4.557266e-04 ; 8.502147e-04 ];
Tc_error_63  = [ 3.233331e-01 ; 3.264874e-01 ; 2.692461e-01 ];

%-- Image #64:
omc_64 = [ 2.009202e+00 ; 2.138575e+00 ; -4.798880e-01 ];
Tc_64  = [ -4.775819e+01 ; -5.968835e+01 ; 9.259089e+02 ];
omc_error_64 = [ 4.093201e-04 ; 4.885090e-04 ; 8.827982e-04 ];
Tc_error_64  = [ 3.286671e-01 ; 3.318007e-01 ; 2.646556e-01 ];

%-- Image #65:
omc_65 = [ -2.243775e+00 ; -1.975110e+00 ; -7.399512e-01 ];
Tc_65  = [ -1.667872e+01 ; -6.782389e+01 ; 4.070953e+02 ];
omc_error_65 = [ 2.315640e-04 ; 3.698320e-04 ; 6.056073e-04 ];
Tc_error_65  = [ 1.455088e-01 ; 1.452792e-01 ; 1.288921e-01 ];

%-- Image #66:
omc_66 = [ -2.162836e+00 ; -2.221573e+00 ; -2.561148e-01 ];
Tc_66  = [ -5.426742e+00 ; -7.672383e+01 ; 4.373443e+02 ];
omc_error_66 = [ 3.170443e-04 ; 4.073823e-04 ; 7.820051e-04 ];
Tc_error_66  = [ 1.560589e-01 ; 1.562541e-01 ; 1.343663e-01 ];

%-- Image #67:
omc_67 = [ 2.105767e+00 ; 1.894399e+00 ; 2.354107e-01 ];
Tc_67  = [ -1.953322e+01 ; -5.809787e+01 ; 4.310681e+02 ];
omc_error_67 = [ 3.515571e-04 ; 2.581668e-04 ; 5.928650e-04 ];
Tc_error_67  = [ 1.534245e-01 ; 1.540826e-01 ; 1.260178e-01 ];

%-- Image #68:
omc_68 = [ 2.112894e+00 ; 2.133524e+00 ; -1.060969e-02 ];
Tc_68  = [ -6.988540e+00 ; -6.582337e+01 ; 4.509957e+02 ];
omc_error_68 = [ 3.797806e-04 ; 3.414900e-04 ; 7.484935e-04 ];
Tc_error_68  = [ 1.605013e-01 ; 1.613873e-01 ; 1.302121e-01 ];

%-- Image #69:
omc_69 = [ 2.003083e+00 ; 1.987704e+00 ; -2.572542e-01 ];
Tc_69  = [ -8.595529e+00 ; -5.206266e+01 ; 4.616996e+02 ];
omc_error_69 = [ 3.208141e-04 ; 3.105763e-04 ; 5.897648e-04 ];
Tc_error_69  = [ 1.639611e-01 ; 1.649186e-01 ; 1.263592e-01 ];

%-- Image #70:
omc_70 = [ 1.972371e+00 ; 1.804930e+00 ; -1.742039e-02 ];
Tc_70  = [ -1.987462e+01 ; -4.911691e+01 ; 4.420392e+02 ];
omc_error_70 = [ 3.260292e-04 ; 2.707446e-04 ; 5.294935e-04 ];
Tc_error_70  = [ 1.569977e-01 ; 1.579215e-01 ; 1.242197e-01 ];

%-- Image #71:
omc_71 = [ -2.499139e+00 ; -1.252910e+00 ; -1.426308e+00 ];
Tc_71  = [ -3.416424e+01 ; -1.775399e+01 ; 4.530546e+02 ];
omc_error_71 = [ 2.868041e-04 ; 3.918574e-04 ; 5.350976e-04 ];
Tc_error_71  = [ 1.614643e-01 ; 1.622575e-01 ; 1.435140e-01 ];

%-- Image #72:
omc_72 = [ -1.991861e+00 ; -1.793791e+00 ; -9.206926e-01 ];
Tc_72  = [ -2.301357e+01 ; -7.232216e+01 ; 4.777219e+02 ];
omc_error_72 = [ 2.404573e-04 ; 3.645776e-04 ; 5.318126e-04 ];
Tc_error_72  = [ 1.707338e-01 ; 1.712112e-01 ; 1.517893e-01 ];

%-- Image #73:
omc_73 = [ -1.389306e+00 ; -2.100240e+00 ; -4.097051e-01 ];
Tc_73  = [ 2.146334e+01 ; -1.077690e+02 ; 4.977032e+02 ];
omc_error_73 = [ 2.073027e-04 ; 3.504926e-04 ; 5.265430e-04 ];
Tc_error_73  = [ 1.786055e-01 ; 1.801189e-01 ; 1.584238e-01 ];

%-- Image #74:
omc_74 = [ -1.385658e+00 ; -2.210869e+00 ; -2.584721e-02 ];
Tc_74  = [ 3.417355e+01 ; -1.066828e+02 ; 5.241043e+02 ];
omc_error_74 = [ 2.352272e-04 ; 3.621163e-04 ; 5.798549e-04 ];
Tc_error_74  = [ 1.877970e-01 ; 1.894358e-01 ; 1.596463e-01 ];

%-- Image #75:
omc_75 = [ -1.794680e+00 ; -2.134132e+00 ; -3.699798e-01 ];
Tc_75  = [ -2.530159e-01 ; -9.447274e+01 ; 5.118036e+02 ];
omc_error_75 = [ 2.580777e-04 ; 3.729742e-04 ; 6.570064e-04 ];
Tc_error_75  = [ 1.829914e-01 ; 1.840557e-01 ; 1.608680e-01 ];

%-- Image #76:
omc_76 = [ -2.178050e+00 ; -1.959870e+00 ; -7.467104e-01 ];
Tc_76  = [ -2.442760e+01 ; -7.157957e+01 ; 4.914872e+02 ];
omc_error_76 = [ 2.523203e-04 ; 3.698936e-04 ; 6.086674e-04 ];
Tc_error_76  = [ 1.755337e-01 ; 1.758997e-01 ; 1.538341e-01 ];

%-- Image #77:
omc_77 = [ 2.373255e+00 ; 1.579814e+00 ; 1.074324e+00 ];
Tc_77  = [ -3.514063e+01 ; -4.172262e+01 ; 4.675540e+02 ];
omc_error_77 = [ 4.080873e-04 ; 1.792933e-04 ; 5.588968e-04 ];
Tc_error_77  = [ 1.668370e-01 ; 1.673828e-01 ; 1.472587e-01 ];

%-- Image #78:
omc_78 = [ 2.184052e+00 ; 1.323250e+00 ; 9.554541e-01 ];
Tc_78  = [ -3.460299e+01 ; -3.172722e+01 ; 4.587961e+02 ];
omc_error_78 = [ 3.898913e-04 ; 2.040517e-04 ; 4.900003e-04 ];
Tc_error_78  = [ 1.635729e-01 ; 1.643182e-01 ; 1.444658e-01 ];

%-- Image #79:
omc_79 = [ 2.238257e+00 ; 1.684702e+00 ; 7.505109e-01 ];
Tc_79  = [ -3.532979e+01 ; -5.077981e+01 ; 4.822023e+02 ];
omc_error_79 = [ 3.814854e-04 ; 2.050422e-04 ; 5.607632e-04 ];
Tc_error_79  = [ 1.720146e-01 ; 1.726022e-01 ; 1.486313e-01 ];

%-- Image #80:
omc_80 = [ 2.245213e+00 ; 2.044049e+00 ; 5.047395e-01 ];
Tc_80  = [ -2.614934e+01 ; -6.859557e+01 ; 5.053832e+02 ];
omc_error_80 = [ 3.840400e-04 ; 2.668452e-04 ; 6.884415e-04 ];
Tc_error_80  = [ 1.802754e-01 ; 1.807923e-01 ; 1.545608e-01 ];

%-- Image #81:
omc_81 = [ -2.041436e+00 ; -2.223923e+00 ; -1.989269e-01 ];
Tc_81  = [ -8.357595e+00 ; -8.317789e+01 ; 5.258595e+02 ];
omc_error_81 = [ 3.999195e-04 ; 4.867905e-04 ; 9.521964e-04 ];
Tc_error_81  = [ 1.875152e-01 ; 1.884921e-01 ; 1.654493e-01 ];

%-- Image #82:
omc_82 = [ -1.725819e+00 ; -2.255699e+00 ; 9.053275e-02 ];
Tc_82  = [ 1.577871e+01 ; -9.275189e+01 ; 5.400812e+02 ];
omc_error_82 = [ 3.434550e-04 ; 4.526794e-04 ; 8.304605e-04 ];
Tc_error_82  = [ 1.928041e-01 ; 1.943577e-01 ; 1.606279e-01 ];

%-- Image #83:
omc_83 = [ -1.702156e+00 ; -2.272870e+00 ; 5.261098e-01 ];
Tc_83  = [ 2.892264e+01 ; -7.989121e+01 ; 5.640360e+02 ];
omc_error_83 = [ 3.279769e-04 ; 3.582982e-04 ; 6.372114e-04 ];
Tc_error_83  = [ 2.007169e-01 ; 2.018929e-01 ; 1.533556e-01 ];

%-- Image #84:
omc_84 = [ -1.974381e+00 ; -2.314792e+00 ; 2.884731e-01 ];
Tc_84  = [ 6.108154e+00 ; -7.614639e+01 ; 5.533549e+02 ];
omc_error_84 = [ 4.501738e-04 ; 5.241113e-04 ; 1.002649e-03 ];
Tc_error_84  = [ 1.967566e-01 ; 1.979264e-01 ; 1.551411e-01 ];

%-- Image #85:
omc_85 = [ 2.123678e+00 ; 2.199391e+00 ; -2.380519e-02 ];
Tc_85  = [ -1.353099e+01 ; -7.001575e+01 ; 5.376312e+02 ];
omc_error_85 = [ 4.700941e-04 ; 4.529125e-04 ; 9.814546e-04 ];
Tc_error_85  = [ 1.911539e-01 ; 1.925123e-01 ; 1.584355e-01 ];

%-- Image #86:
omc_86 = [ 2.126733e+00 ; 1.944932e+00 ; 2.363762e-01 ];
Tc_86  = [ -2.753244e+01 ; -6.174106e+01 ; 5.177685e+02 ];
omc_error_86 = [ 3.715955e-04 ; 2.904044e-04 ; 6.578883e-04 ];
Tc_error_86  = [ 1.843127e-01 ; 1.853015e-01 ; 1.523915e-01 ];

%-- Image #87:
omc_87 = [ 2.095381e+00 ; 1.682000e+00 ; 4.694325e-01 ];
Tc_87  = [ -3.567144e+01 ; -5.180182e+01 ; 4.950521e+02 ];
omc_error_87 = [ 3.591353e-04 ; 2.335825e-04 ; 5.394586e-04 ];
Tc_error_87  = [ 1.763478e-01 ; 1.772041e-01 ; 1.479684e-01 ];

%-- Image #88:
omc_88 = [ 2.034522e+00 ; 1.414739e+00 ; 6.758916e-01 ];
Tc_88  = [ -3.620760e+01 ; -4.094002e+01 ; 4.713669e+02 ];
omc_error_88 = [ 3.664353e-04 ; 2.228706e-04 ; 4.751198e-04 ];
Tc_error_88  = [ 1.679253e-01 ; 1.687820e-01 ; 1.441554e-01 ];

%-- Image #89:
omc_89 = [ 1.825540e+00 ; 1.318208e+00 ; 5.280523e-01 ];
Tc_89  = [ -3.581966e+01 ; -4.090933e+01 ; 4.698012e+02 ];
omc_error_89 = [ 3.518992e-04 ; 2.493860e-04 ; 4.242709e-04 ];
Tc_error_89  = [ 1.671375e-01 ; 1.681919e-01 ; 1.413611e-01 ];

%-- Image #90:
omc_90 = [ 1.906045e+00 ; 1.527487e+00 ; 3.276951e-01 ];
Tc_90  = [ -3.833431e+01 ; -4.517475e+01 ; 4.933434e+02 ];
omc_error_90 = [ 3.406018e-04 ; 2.487905e-04 ; 4.689099e-04 ];
Tc_error_90  = [ 1.754773e-01 ; 1.765691e-01 ; 1.447810e-01 ];

%-- Image #91:
omc_91 = [ 1.967478e+00 ; 1.733132e+00 ; 1.063242e-01 ];
Tc_91  = [ -3.353956e+01 ; -4.930195e+01 ; 5.166934e+02 ];
omc_error_91 = [ 3.332781e-04 ; 2.687325e-04 ; 5.261871e-04 ];
Tc_error_91  = [ 1.836378e-01 ; 1.848474e-01 ; 1.478962e-01 ];

%-- Image #92:
omc_92 = [ 2.006295e+00 ; 1.930397e+00 ; -1.334931e-01 ];
Tc_92  = [ -2.401314e+01 ; -5.310865e+01 ; 5.380266e+02 ];
omc_error_92 = [ 3.353420e-04 ; 3.143071e-04 ; 6.067686e-04 ];
Tc_error_92  = [ 1.910605e-01 ; 1.923979e-01 ; 1.502171e-01 ];

%-- Image #93:
omc_93 = [ 2.020306e+00 ; 2.119724e+00 ; -3.941289e-01 ];
Tc_93  = [ -8.091963e+00 ; -5.614017e+01 ; 5.564907e+02 ];
omc_error_93 = [ 3.340215e-04 ; 3.677996e-04 ; 6.838954e-04 ];
Tc_error_93  = [ 1.975420e-01 ; 1.988110e-01 ; 1.507461e-01 ];

%-- Image #94:
omc_94 = [ 2.007214e+00 ; 2.296919e+00 ; -6.729990e-01 ];
Tc_94  = [ 1.079514e+01 ; -5.828074e+01 ; 5.704710e+02 ];
omc_error_94 = [ 2.794948e-04 ; 3.841751e-04 ; 6.700876e-04 ];
Tc_error_94  = [ 2.025516e-01 ; 2.037213e-01 ; 1.503313e-01 ];

