% Intrinsic and Extrinsic Camera Parameters
%
% This script file can be directly excecuted under Matlab to recover the camera intrinsic and extrinsic parameters.
% IMPORTANT: This file contains neither the structure of the calibration objects nor the image coordinates of the calibration points.
%            All those complementary variables are saved in the complete matlab data file Calib_Results.mat.
% For more information regarding the calibration model visit http://www.vision.caltech.edu/bouguetj/calib_doc/


%-- Focal length:
fc = [ 2892.843725329502400 ; 2882.249450476587300 ];

%-- Principal point:
cc = [ 824.425157504919530 ; 605.187152104484080 ];

%-- Skew coefficient:
alpha_c = 0.000000000000000;

%-- Distortion coefficients:
kc = [ -0.087418212941861 ; -0.292439728506788 ; 0.001111938237143 ; -0.000238360064404 ; 0.000000000000000 ];

%-- Focal length uncertainty:
fc_error = [ 0.860030933592827 ; 0.843329194106533 ];

%-- Principal point uncertainty:
cc_error = [ 1.074352900070148 ; 1.096296294401897 ];

%-- Skew coefficient uncertainty:
alpha_c_error = 0.000000000000000;

%-- Distortion coefficients uncertainty:
kc_error = [ 0.001845284436224 ; 0.024439546987398 ; 0.000103225255729 ; 0.000109609406818 ; 0.000000000000000 ];

%-- Image size:
nx = 1600;
ny = 1200;


%-- Various other variables (may be ignored if you do not use the Matlab Calibration Toolbox):
%-- Those variables are used to control which intrinsic parameters should be optimized

n_ima = 94;						% Number of calibration images
est_fc = [ 1 ; 1 ];					% Estimation indicator of the two focal variables
est_aspect_ratio = 1;				% Estimation indicator of the aspect ratio fc(2)/fc(1)
center_optim = 1;					% Estimation indicator of the principal point
est_alpha = 0;						% Estimation indicator of the skew coefficient
est_dist = [ 1 ; 1 ; 1 ; 1 ; 0 ];	% Estimation indicator of the distortion coefficients


%-- Extrinsic parameters:
%-- The rotation (omc_kk) and the translation (Tc_kk) vectors for every calibration image and their uncertainties

%-- Image #1:
omc_1 = [ 2.646883e+00 ; 8.491224e-01 ; 1.201473e+00 ];
Tc_1  = [ -9.164054e+01 ; 2.883847e+01 ; 5.780082e+02 ];
omc_error_1 = [ 4.641154e-04 ; 1.882847e-04 ; 5.881338e-04 ];
Tc_error_1  = [ 2.154257e-01 ; 2.212490e-01 ; 2.042411e-01 ];

%-- Image #2:
omc_2 = [ -2.444423e+00 ; -1.383376e+00 ; -9.331597e-01 ];
Tc_2  = [ -9.677179e+01 ; -1.515467e+01 ; 5.991584e+02 ];
omc_error_2 = [ 3.497886e-04 ; 3.458957e-04 ; 6.106841e-04 ];
Tc_error_2  = [ 2.231886e-01 ; 2.293516e-01 ; 2.074369e-01 ];

%-- Image #3:
omc_3 = [ -1.973200e+00 ; -1.703606e+00 ; -5.772585e-01 ];
Tc_3  = [ -7.798528e+01 ; -5.694933e+01 ; 6.165702e+02 ];
omc_error_3 = [ 3.224235e-04 ; 3.546533e-04 ; 5.656291e-04 ];
Tc_error_3  = [ 2.297269e-01 ; 2.357334e-01 ; 2.108887e-01 ];

%-- Image #4:
omc_4 = [ -1.459378e+00 ; -1.890948e+00 ; -2.412967e-01 ];
Tc_4  = [ -3.987781e+01 ; -8.548137e+01 ; 6.237389e+02 ];
omc_error_4 = [ 2.867257e-04 ; 3.560693e-04 ; 5.047639e-04 ];
Tc_error_4  = [ 2.323899e-01 ; 2.379401e-01 ; 2.100527e-01 ];

%-- Image #5:
omc_5 = [ -9.261897e-01 ; -1.962692e+00 ; 6.906567e-02 ];
Tc_5  = [ 8.307069e+00 ; -9.358140e+01 ; 6.197556e+02 ];
omc_error_5 = [ 2.712612e-04 ; 3.622021e-04 ; 4.486791e-04 ];
Tc_error_5  = [ 2.312985e-01 ; 2.361610e-01 ; 2.075991e-01 ];

%-- Image #6:
omc_6 = [ -9.871599e-01 ; -1.988992e+00 ; 3.035277e-01 ];
Tc_6  = [ 1.361858e+01 ; -8.935096e+01 ; 6.383336e+02 ];
omc_error_6 = [ 2.819123e-04 ; 3.547017e-04 ; 4.609878e-04 ];
Tc_error_6  = [ 2.380060e-01 ; 2.430823e-01 ; 2.080807e-01 ];

%-- Image #7:
omc_7 = [ -1.353674e+00 ; -1.994332e+00 ; 8.911246e-02 ];
Tc_7  = [ -1.893242e+01 ; -8.745466e+01 ; 6.418942e+02 ];
omc_error_7 = [ 2.887735e-04 ; 3.499220e-04 ; 5.158107e-04 ];
Tc_error_7  = [ 2.390229e-01 ; 2.444765e-01 ; 2.098746e-01 ];

%-- Image #8:
omc_8 = [ -1.718859e+00 ; -1.948508e+00 ; -1.471893e-01 ];
Tc_8  = [ -5.010895e+01 ; -7.627709e+01 ; 6.388482e+02 ];
omc_error_8 = [ 3.144689e-04 ; 3.588758e-04 ; 5.918554e-04 ];
Tc_error_8  = [ 2.377543e-01 ; 2.436119e-01 ; 2.121520e-01 ];

%-- Image #9:
omc_9 = [ -2.075648e+00 ; -1.844694e+00 ; -4.067469e-01 ];
Tc_9  = [ -7.538925e+01 ; -5.719246e+01 ; 6.289479e+02 ];
omc_error_9 = [ 3.613169e-04 ; 3.741440e-04 ; 6.743052e-04 ];
Tc_error_9  = [ 2.342414e-01 ; 2.403166e-01 ; 2.140009e-01 ];

%-- Image #10:
omc_10 = [ -2.411937e+00 ; -1.674094e+00 ; -6.890162e-01 ];
Tc_10  = [ -9.206173e+01 ; -3.200799e+01 ; 6.124841e+02 ];
omc_error_10 = [ 3.732271e-04 ; 3.626528e-04 ; 7.000583e-04 ];
Tc_error_10  = [ 2.281689e-01 ; 2.343594e-01 ; 2.114309e-01 ];

%-- Image #11:
omc_11 = [ 2.578526e+00 ; 1.354978e+00 ; 9.332071e-01 ];
Tc_11  = [ -9.732819e+01 ; -4.681446e+00 ; 5.930120e+02 ];
omc_error_11 = [ 4.668145e-04 ; 1.848872e-04 ; 6.469543e-04 ];
Tc_error_11  = [ 2.208912e-01 ; 2.270398e-01 ; 2.079984e-01 ];

%-- Image #12:
omc_12 = [ 2.325060e+00 ; 1.037853e+00 ; 9.201125e-01 ];
Tc_12  = [ -9.226156e+01 ; 1.073483e+01 ; 5.735922e+02 ];
omc_error_12 = [ 4.321298e-04 ; 2.009305e-04 ; 5.437968e-04 ];
Tc_error_12  = [ 2.137855e-01 ; 2.196816e-01 ; 2.042350e-01 ];

%-- Image #13:
omc_13 = [ 2.411389e+00 ; 1.354611e+00 ; 7.815021e-01 ];
Tc_13  = [ -9.728733e+01 ; -6.581466e+00 ; 5.927909e+02 ];
omc_error_13 = [ 4.455330e-04 ; 2.057593e-04 ; 6.254815e-04 ];
Tc_error_13  = [ 2.208020e-01 ; 2.269764e-01 ; 2.081408e-01 ];

%-- Image #14:
omc_14 = [ 2.463799e+00 ; 1.678324e+00 ; 6.141950e-01 ];
Tc_14  = [ -9.457204e+01 ; -2.482871e+01 ; 6.119319e+02 ];
omc_error_14 = [ 4.788753e-04 ; 2.680275e-04 ; 7.611872e-04 ];
Tc_error_14  = [ 2.278631e-01 ; 2.341523e-01 ; 2.125224e-01 ];

%-- Image #15:
omc_15 = [ -2.365436e+00 ; -1.916759e+00 ; -3.953420e-01 ];
Tc_15  = [ -8.473506e+01 ; -4.236416e+01 ; 6.298787e+02 ];
omc_error_15 = [ 4.870056e-04 ; 4.399184e-04 ; 9.425829e-04 ];
Tc_error_15  = [ 2.345951e-01 ; 2.408254e-01 ; 2.177607e-01 ];

%-- Image #16:
omc_16 = [ -2.092482e+00 ; -1.999459e+00 ; -1.531067e-01 ];
Tc_16  = [ -6.939086e+01 ; -5.774461e+01 ; 6.447952e+02 ];
omc_error_16 = [ 4.487172e-04 ; 4.432955e-04 ; 8.875823e-04 ];
Tc_error_16  = [ 2.398618e-01 ; 2.460555e-01 ; 2.169272e-01 ];

%-- Image #17:
omc_17 = [ -1.808456e+00 ; -2.040524e+00 ; 6.387093e-02 ];
Tc_17  = [ -4.797623e+01 ; -6.984002e+01 ; 6.543738e+02 ];
omc_error_17 = [ 3.495968e-04 ; 3.745815e-04 ; 6.843088e-04 ];
Tc_error_17  = [ 2.432166e-01 ; 2.492560e-01 ; 2.116641e-01 ];

%-- Image #18:
omc_18 = [ -1.520611e+00 ; -2.047848e+00 ; 2.608970e-01 ];
Tc_18  = [ -2.335541e+01 ; -7.774938e+01 ; 6.592142e+02 ];
omc_error_18 = [ 3.103301e-04 ; 3.450092e-04 ; 5.673818e-04 ];
Tc_error_18  = [ 2.451162e-01 ; 2.509023e-01 ; 2.094506e-01 ];

%-- Image #19:
omc_19 = [ -1.231173e+00 ; -2.023609e+00 ; 4.399609e-01 ];
Tc_19  = [ 2.900203e+00 ; -8.088525e+01 ; 6.587835e+02 ];
omc_error_19 = [ 2.991944e-04 ; 3.416372e-04 ; 4.995083e-04 ];
Tc_error_19  = [ 2.451876e-01 ; 2.507171e-01 ; 2.080292e-01 ];

%-- Image #20:
omc_20 = [ -1.176651e+00 ; -1.994369e+00 ; 7.478962e-01 ];
Tc_20  = [ 1.790292e+01 ; -6.953225e+01 ; 6.727010e+02 ];
omc_error_20 = [ 3.203480e-04 ; 3.346384e-04 ; 4.816513e-04 ];
Tc_error_20  = [ 2.502579e-01 ; 2.560021e-01 ; 2.055607e-01 ];

%-- Image #21:
omc_21 = [ -1.420318e+00 ; -2.057120e+00 ; 6.066878e-01 ];
Tc_21  = [ -3.945601e+00 ; -6.924403e+01 ; 6.756760e+02 ];
omc_error_21 = [ 3.219525e-04 ; 3.282478e-04 ; 5.357190e-04 ];
Tc_error_21  = [ 2.511402e-01 ; 2.570521e-01 ; 2.066632e-01 ];

%-- Image #22:
omc_22 = [ -1.664645e+00 ; -2.100258e+00 ; 4.483199e-01 ];
Tc_22  = [ -2.614640e+01 ; -6.620822e+01 ; 6.740619e+02 ];
omc_error_22 = [ 3.371140e-04 ; 3.404525e-04 ; 6.178973e-04 ];
Tc_error_22  = [ 2.503541e-01 ; 2.564583e-01 ; 2.075502e-01 ];

%-- Image #23:
omc_23 = [ -1.907884e+00 ; -2.120815e+00 ; 2.723920e-01 ];
Tc_23  = [ -4.679229e+01 ; -6.066039e+01 ; 6.681046e+02 ];
omc_error_23 = [ 3.941963e-04 ; 3.990186e-04 ; 7.878266e-04 ];
Tc_error_23  = [ 2.480372e-01 ; 2.543127e-01 ; 2.087323e-01 ];

%-- Image #24:
omc_24 = [ -2.148903e+00 ; -2.116922e+00 ; 7.960078e-02 ];
Tc_24  = [ -6.472668e+01 ; -5.283662e+01 ; 6.579810e+02 ];
omc_error_24 = [ 6.187367e-04 ; 6.048143e-04 ; 1.302766e-03 ];
Tc_error_24  = [ 2.443676e-01 ; 2.506994e-01 ; 2.151891e-01 ];

%-- Image #25:
omc_25 = [ 2.340362e+00 ; 2.046854e+00 ; 1.403923e-01 ];
Tc_25  = [ -7.953085e+01 ; -4.303474e+01 ; 6.437174e+02 ];
omc_error_25 = [ 8.236826e-04 ; 7.158051e-04 ; 1.662610e-03 ];
Tc_error_25  = [ 2.396985e-01 ; 2.458639e-01 ; 2.300372e-01 ];

%-- Image #26:
omc_26 = [ 2.327473e+00 ; 1.800362e+00 ; 3.396890e-01 ];
Tc_26  = [ -9.097947e+01 ; -3.182349e+01 ; 6.271888e+02 ];
omc_error_26 = [ 5.185477e-04 ; 3.747158e-04 ; 9.269959e-04 ];
Tc_error_26  = [ 2.334127e-01 ; 2.397712e-01 ; 2.161229e-01 ];

%-- Image #27:
omc_27 = [ 2.286973e+00 ; 1.553755e+00 ; 5.151899e-01 ];
Tc_27  = [ -9.620540e+01 ; -1.989732e+01 ; 6.087574e+02 ];
omc_error_27 = [ 4.353356e-04 ; 2.578714e-04 ; 6.778323e-04 ];
Tc_error_27  = [ 2.266028e-01 ; 2.329241e-01 ; 2.097839e-01 ];

%-- Image #28:
omc_28 = [ 2.223241e+00 ; 1.307865e+00 ; 6.715248e-01 ];
Tc_28  = [ -9.612917e+01 ; -8.135497e+00 ; 5.896122e+02 ];
omc_error_28 = [ 4.156037e-04 ; 2.214640e-04 ; 5.701181e-04 ];
Tc_error_28  = [ 2.195861e-01 ; 2.257478e-01 ; 2.055567e-01 ];

%-- Image #29:
omc_29 = [ 1.981169e+00 ; 1.166382e+00 ; 6.532234e-01 ];
Tc_29  = [ -9.224942e+01 ; -8.170887e+00 ; 5.760951e+02 ];
omc_error_29 = [ 3.930819e-04 ; 2.417230e-04 ; 4.840109e-04 ];
Tc_error_29  = [ 2.145103e-01 ; 2.205735e-01 ; 2.002884e-01 ];

%-- Image #30:
omc_30 = [ 2.058507e+00 ; 1.363190e+00 ; 5.073172e-01 ];
Tc_30  = [ -9.650260e+01 ; -1.467603e+01 ; 5.950254e+02 ];
omc_error_30 = [ 3.901168e-04 ; 2.446786e-04 ; 5.401391e-04 ];
Tc_error_30  = [ 2.214874e-01 ; 2.277641e-01 ; 2.038833e-01 ];

%-- Image #31:
omc_31 = [ 2.121523e+00 ; 1.559759e+00 ; 3.467072e-01 ];
Tc_31  = [ -9.599625e+01 ; -2.166255e+01 ; 6.141893e+02 ];
omc_error_31 = [ 3.978256e-04 ; 2.719394e-04 ; 6.259968e-04 ];
Tc_error_31  = [ 2.284944e-01 ; 2.349145e-01 ; 2.073905e-01 ];

%-- Image #32:
omc_32 = [ 2.168215e+00 ; 1.755050e+00 ; 1.708726e-01 ];
Tc_32  = [ -9.112517e+01 ; -2.877758e+01 ; 6.326956e+02 ];
omc_error_32 = [ 4.407235e-04 ; 3.454721e-04 ; 7.940259e-04 ];
Tc_error_32  = [ 2.352441e-01 ; 2.417178e-01 ; 2.109452e-01 ];

%-- Image #33:
omc_33 = [ 2.195775e+00 ; 1.947120e+00 ; -2.096002e-02 ];
Tc_33  = [ -8.197386e+01 ; -3.543869e+01 ; 6.495122e+02 ];
omc_error_33 = [ 5.815645e-04 ; 5.187818e-04 ; 1.171165e-03 ];
Tc_error_33  = [ 2.413930e-01 ; 2.477849e-01 ; 2.135105e-01 ];

%-- Image #34:
omc_34 = [ 2.202600e+00 ; 2.135357e+00 ; -2.273745e-01 ];
Tc_34  = [ -6.945205e+01 ; -4.144506e+01 ; 6.641077e+02 ];
omc_error_34 = [ 6.170163e-04 ; 6.125183e-04 ; 1.318030e-03 ];
Tc_error_34  = [ 2.465587e-01 ; 2.530297e-01 ; 2.069109e-01 ];

%-- Image #35:
omc_35 = [ -2.081689e+00 ; -2.206824e+00 ; 4.280003e-01 ];
Tc_35  = [ -5.368839e+01 ; -4.664949e+01 ; 6.759346e+02 ];
omc_error_35 = [ 4.442290e-04 ; 4.223449e-04 ; 9.090731e-04 ];
Tc_error_35  = [ 2.507861e-01 ; 2.573527e-01 ; 2.045692e-01 ];

%-- Image #36:
omc_36 = [ -1.864397e+00 ; -2.167204e+00 ; 5.999613e-01 ];
Tc_36  = [ -3.546530e+01 ; -5.070710e+01 ; 6.841887e+02 ];
omc_error_36 = [ 3.726078e-04 ; 3.385197e-04 ; 6.912475e-04 ];
Tc_error_36  = [ 2.538726e-01 ; 2.603419e-01 ; 2.049808e-01 ];

%-- Image #37:
omc_37 = [ -1.646364e+00 ; -2.109852e+00 ; 7.530470e-01 ];
Tc_37  = [ -1.564667e+01 ; -5.353292e+01 ; 6.884525e+02 ];
omc_error_37 = [ 3.509780e-04 ; 3.136176e-04 ; 5.879432e-04 ];
Tc_error_37  = [ 2.555738e-01 ; 2.618885e-01 ; 2.047742e-01 ];

%-- Image #38:
omc_38 = [ -1.428464e+00 ; -2.036978e+00 ; 8.876757e-01 ];
Tc_38  = [ 4.615616e+00 ; -5.495444e+01 ; 6.886891e+02 ];
omc_error_38 = [ 3.457850e-04 ; 3.147635e-04 ; 5.239296e-04 ];
Tc_error_38  = [ 2.558482e-01 ; 2.619994e-01 ; 2.040418e-01 ];

%-- Image #39:
omc_39 = [ -1.346521e+00 ; -1.931540e+00 ; 1.213192e+00 ];
Tc_39  = [ 2.105140e+01 ; -3.765155e+01 ; 6.966033e+02 ];
omc_error_39 = [ 3.762793e-04 ; 3.156384e-04 ; 4.877917e-04 ];
Tc_error_39  = [ 2.588648e-01 ; 2.651105e-01 ; 2.012535e-01 ];

%-- Image #40:
omc_40 = [ -1.546048e+00 ; -2.034804e+00 ; 1.107969e+00 ];
Tc_40  = [ 2.678049e+00 ; -3.703716e+01 ; 6.991479e+02 ];
omc_error_40 = [ 3.753290e-04 ; 2.987888e-04 ; 5.362725e-04 ];
Tc_error_40  = [ 2.595895e-01 ; 2.659817e-01 ; 2.023534e-01 ];

%-- Image #41:
omc_41 = [ -1.746760e+00 ; -2.128177e+00 ; 9.839430e-01 ];
Tc_41  = [ -1.605455e+01 ; -3.639403e+01 ; 6.980469e+02 ];
omc_error_41 = [ 3.783737e-04 ; 2.910655e-04 ; 5.953583e-04 ];
Tc_error_41  = [ 2.590197e-01 ; 2.655437e-01 ; 2.031528e-01 ];

%-- Image #42:
omc_42 = [ -1.948536e+00 ; -2.209766e+00 ; 8.406961e-01 ];
Tc_42  = [ -3.427551e+01 ; -3.496254e+01 ; 6.931018e+02 ];
omc_error_42 = [ 3.888807e-04 ; 3.003607e-04 ; 6.758782e-04 ];
Tc_error_42  = [ 2.571006e-01 ; 2.637264e-01 ; 2.034120e-01 ];

%-- Image #43:
omc_43 = [ 2.065551e+00 ; 2.187158e+00 ; -6.483938e-01 ];
Tc_43  = [ -5.234873e+01 ; -3.295325e+01 ; 6.845457e+02 ];
omc_error_43 = [ 3.188446e-04 ; 4.292311e-04 ; 7.569249e-04 ];
Tc_error_43  = [ 2.539440e-01 ; 2.606330e-01 ; 2.033621e-01 ];

%-- Image #44:
omc_44 = [ 2.064156e+00 ; 2.045547e+00 ; -4.299055e-01 ];
Tc_44  = [ -6.710444e+01 ; -3.083513e+01 ; 6.727221e+02 ];
omc_error_44 = [ 3.804811e-04 ; 4.249433e-04 ; 8.133456e-04 ];
Tc_error_44  = [ 2.496807e-01 ; 2.563182e-01 ; 2.044051e-01 ];

%-- Image #45:
omc_45 = [ 2.045593e+00 ; 1.898180e+00 ; -2.245764e-01 ];
Tc_45  = [ -7.912639e+01 ; -2.837521e+01 ; 6.582456e+02 ];
omc_error_45 = [ 3.920796e-04 ; 3.878852e-04 ; 7.767938e-04 ];
Tc_error_45  = [ 2.444338e-01 ; 2.510345e-01 ; 2.067736e-01 ];

%-- Image #46:
omc_46 = [ 2.011775e+00 ; 1.745960e+00 ; -3.156369e-02 ];
Tc_46  = [ -8.808723e+01 ; -2.563881e+01 ; 6.417008e+02 ];
omc_error_46 = [ 3.726176e-04 ; 3.306900e-04 ; 6.694501e-04 ];
Tc_error_46  = [ 2.383936e-01 ; 2.449995e-01 ; 2.072402e-01 ];

%-- Image #47:
omc_47 = [ 1.963131e+00 ; 1.587510e+00 ; 1.511683e-01 ];
Tc_47  = [ -9.430976e+01 ; -2.284552e+01 ; 6.235811e+02 ];
omc_error_47 = [ 3.631274e-04 ; 2.896860e-04 ; 5.778210e-04 ];
Tc_error_47  = [ 2.317961e-01 ; 2.383647e-01 ; 2.056331e-01 ];

%-- Image #48:
omc_48 = [ 1.901970e+00 ; 1.427657e+00 ; 3.195682e-01 ];
Tc_48  = [ -9.544957e+01 ; -2.008661e+01 ; 6.045579e+02 ];
omc_error_48 = [ 3.656063e-04 ; 2.689270e-04 ; 5.141329e-04 ];
Tc_error_48  = [ 2.248315e-01 ; 2.312643e-01 ; 2.027673e-01 ];

%-- Image #49:
omc_49 = [ 1.829100e+00 ; 1.265243e+00 ; 4.765918e-01 ];
Tc_49  = [ -9.289060e+01 ; -1.753753e+01 ; 5.856687e+02 ];
omc_error_49 = [ 3.733025e-04 ; 2.635734e-04 ; 4.663302e-04 ];
Tc_error_49  = [ 2.178762e-01 ; 2.241205e-01 ; 1.994236e-01 ];

%-- Image #50:
omc_50 = [ 2.305701e+00 ; 1.649061e+00 ; 4.492638e-01 ];
Tc_50  = [ -6.383454e+01 ; -2.000424e+01 ; 8.588008e+02 ];
omc_error_50 = [ 5.241740e-04 ; 3.361174e-04 ; 8.543089e-04 ];
Tc_error_50  = [ 3.188620e-01 ; 3.269600e-01 ; 2.989437e-01 ];

%-- Image #51:
omc_51 = [ 2.336728e+00 ; 1.913978e+00 ; 2.520153e-01 ];
Tc_51  = [ -5.612380e+01 ; -3.250388e+01 ; 8.776873e+02 ];
omc_error_51 = [ 7.498438e-04 ; 5.785438e-04 ; 1.405894e-03 ];
Tc_error_51  = [ 3.259555e-01 ; 3.340755e-01 ; 3.129325e-01 ];

%-- Image #52:
omc_52 = [ -2.261703e+00 ; -2.107734e+00 ; -2.144868e-02 ];
Tc_52  = [ -4.239672e+01 ; -4.379922e+01 ; 8.947052e+02 ];
omc_error_52 = [ 1.422404e-03 ; 1.385052e-03 ; 3.035161e-03 ];
Tc_error_52  = [ 3.325358e-01 ; 3.406098e-01 ; 3.478950e-01 ];

%-- Image #53:
omc_53 = [ -2.003101e+00 ; -2.122963e+00 ; 1.968417e-01 ];
Tc_53  = [ -2.444751e+01 ; -5.339777e+01 ; 9.072840e+02 ];
omc_error_53 = [ 6.132733e-04 ; 6.581883e-04 ; 1.308397e-03 ];
Tc_error_53  = [ 3.369314e-01 ; 3.450915e-01 ; 2.973620e-01 ];

%-- Image #54:
omc_54 = [ -1.743182e+00 ; -2.110398e+00 ; 3.920183e-01 ];
Tc_54  = [ -2.692817e+00 ; -6.040591e+01 ; 9.152671e+02 ];
omc_error_54 = [ 4.032010e-04 ; 4.398084e-04 ; 7.977628e-04 ];
Tc_error_54  = [ 3.401480e-01 ; 3.481305e-01 ; 2.943109e-01 ];

%-- Image #55:
omc_55 = [ -1.800575e+00 ; -2.153530e+00 ; 6.669151e-01 ];
Tc_55  = [ 1.277855e+00 ; -4.653850e+01 ; 9.297923e+02 ];
omc_error_55 = [ 4.103481e-04 ; 4.019650e-04 ; 7.651526e-04 ];
Tc_error_55  = [ 3.454572e-01 ; 3.536051e-01 ; 2.904866e-01 ];

%-- Image #56:
omc_56 = [ -2.031932e+00 ; -2.203248e+00 ; 4.904495e-01 ];
Tc_56  = [ -1.780457e+01 ; -4.233753e+01 ; 9.220189e+02 ];
omc_error_56 = [ 5.232876e-04 ; 5.383092e-04 ; 1.089135e-03 ];
Tc_error_56  = [ 3.424130e-01 ; 3.505862e-01 ; 2.871420e-01 ];

%-- Image #57:
omc_57 = [ 2.192155e+00 ; 2.163407e+00 ; -2.827982e-01 ];
Tc_57  = [ -3.529691e+01 ; -3.703861e+01 ; 9.100701e+02 ];
omc_error_57 = [ 8.584511e-04 ; 8.181887e-04 ; 1.798317e-03 ];
Tc_error_57  = [ 3.380754e-01 ; 3.460729e-01 ; 2.868692e-01 ];

%-- Image #58:
omc_58 = [ 2.187616e+00 ; 1.965779e+00 ; -6.000276e-02 ];
Tc_58  = [ -4.924033e+01 ; -3.092801e+01 ; 8.948635e+02 ];
omc_error_58 = [ 7.557286e-04 ; 6.541849e-04 ; 1.496682e-03 ];
Tc_error_58  = [ 3.323415e-01 ; 3.404502e-01 ; 3.013855e-01 ];

%-- Image #59:
omc_59 = [ 2.159061e+00 ; 1.763380e+00 ; 1.471817e-01 ];
Tc_59  = [ -5.908918e+01 ; -2.423857e+01 ; 8.770318e+02 ];
omc_error_59 = [ 5.223524e-04 ; 4.045141e-04 ; 9.285563e-04 ];
Tc_error_59  = [ 3.255780e-01 ; 3.337836e-01 ; 2.982356e-01 ];

%-- Image #60:
omc_60 = [ 1.952343e+00 ; 1.624750e+00 ; 8.440668e-02 ];
Tc_60  = [ -6.308337e+01 ; -1.882429e+01 ; 8.719969e+02 ];
omc_error_60 = [ 4.080982e-04 ; 3.315624e-04 ; 6.585207e-04 ];
Tc_error_60  = [ 3.236849e-01 ; 3.319284e-01 ; 2.920703e-01 ];

%-- Image #61:
omc_61 = [ 2.001443e+00 ; 1.788918e+00 ; -1.156076e-01 ];
Tc_61  = [ -5.453175e+01 ; -2.152204e+01 ; 8.909074e+02 ];
omc_error_61 = [ 4.393372e-04 ; 3.912311e-04 ; 7.926963e-04 ];
Tc_error_61  = [ 3.307649e-01 ; 3.389928e-01 ; 2.941703e-01 ];

%-- Image #62:
omc_62 = [ 2.033262e+00 ; 1.945662e+00 ; -3.277532e-01 ];
Tc_62  = [ -4.392913e+01 ; -2.404548e+01 ; 9.079835e+02 ];
omc_error_62 = [ 4.766854e-04 ; 4.652981e-04 ; 9.317860e-04 ];
Tc_error_62  = [ 3.372115e-01 ; 3.453893e-01 ; 2.927001e-01 ];

%-- Image #63:
omc_63 = [ 2.047557e+00 ; 2.096818e+00 ; -5.533052e-01 ];
Tc_63  = [ -2.965379e+01 ; -2.666796e+01 ; 9.224436e+02 ];
omc_error_63 = [ 4.504533e-04 ; 4.936264e-04 ; 9.377453e-04 ];
Tc_error_63  = [ 3.425881e-01 ; 3.508090e-01 ; 2.892436e-01 ];

%-- Image #64:
omc_64 = [ 2.041834e+00 ; 2.239327e+00 ; -7.953803e-01 ];
Tc_64  = [ -1.217832e+01 ; -2.829657e+01 ; 9.336400e+02 ];
omc_error_64 = [ 3.668627e-04 ; 4.827275e-04 ; 8.347570e-04 ];
Tc_error_64  = [ 3.467330e-01 ; 3.550484e-01 ; 2.891318e-01 ];

%-- Image #65:
omc_65 = [ -2.241562e+00 ; -1.871111e+00 ; -4.116853e-01 ];
Tc_65  = [ -1.084174e+02 ; -5.221257e+01 ; 4.233987e+02 ];
omc_error_65 = [ 3.629614e-04 ; 3.288637e-04 ; 6.590789e-04 ];
Tc_error_65  = [ 1.582853e-01 ; 1.641059e-01 ; 1.519787e-01 ];

%-- Image #66:
omc_66 = [ -2.091573e+00 ; -2.088623e+00 ; 4.327380e-02 ];
Tc_66  = [ -9.028940e+01 ; -6.036205e+01 ; 4.500333e+02 ];
omc_error_66 = [ 3.845351e-04 ; 3.479714e-04 ; 7.589052e-04 ];
Tc_error_66  = [ 1.675443e-01 ; 1.726571e-01 ; 1.507879e-01 ];

%-- Image #67:
omc_67 = [ 2.210867e+00 ; 2.002388e+00 ; -5.989890e-02 ];
Tc_67  = [ -1.053918e+02 ; -4.170273e+01 ; 4.468390e+02 ];
omc_error_67 = [ 4.298927e-04 ; 4.292161e-04 ; 9.151954e-04 ];
Tc_error_67  = [ 1.664828e-01 ; 1.721987e-01 ; 1.516132e-01 ];

%-- Image #68:
omc_68 = [ -2.186611e+00 ; -2.211694e+00 ; 3.142882e-01 ];
Tc_68  = [ -8.843018e+01 ; -4.904300e+01 ; 4.633488e+02 ];
omc_error_68 = [ 3.949547e-04 ; 3.336459e-04 ; 7.987242e-04 ];
Tc_error_68  = [ 1.720992e-01 ; 1.778682e-01 ; 1.462220e-01 ];

%-- Image #69:
omc_69 = [ 2.049481e+00 ; 2.099737e+00 ; -5.568376e-01 ];
Tc_69  = [ -8.731116e+01 ; -3.493689e+01 ; 4.737004e+02 ];
omc_error_69 = [ 2.553484e-04 ; 3.788188e-04 ; 6.502289e-04 ];
Tc_error_69  = [ 1.756150e-01 ; 1.818541e-01 ; 1.429342e-01 ];

%-- Image #70:
omc_70 = [ 2.032290e+00 ; 1.928660e+00 ; -3.030334e-01 ];
Tc_70  = [ -1.030307e+02 ; -3.236226e+01 ; 4.571523e+02 ];
omc_error_70 = [ 2.912015e-04 ; 3.458775e-04 ; 6.428473e-04 ];
Tc_error_70  = [ 1.697744e-01 ; 1.761082e-01 ; 1.454448e-01 ];

%-- Image #71:
omc_71 = [ -2.606700e+00 ; -1.223481e+00 ; -1.069454e+00 ];
Tc_71  = [ -1.132880e+02 ; -5.469785e-01 ; 4.702208e+02 ];
omc_error_71 = [ 3.391101e-04 ; 3.245082e-04 ; 5.911767e-04 ];
Tc_error_71  = [ 1.760296e-01 ; 1.815498e-01 ; 1.692977e-01 ];

%-- Image #72:
omc_72 = [ -2.037239e+00 ; -1.670249e+00 ; -6.221543e-01 ];
Tc_72  = [ -9.738356e+01 ; -5.455919e+01 ; 4.935668e+02 ];
omc_error_72 = [ 3.160123e-04 ; 3.315118e-04 ; 5.400542e-04 ];
Tc_error_72  = [ 1.842945e-01 ; 1.900169e-01 ; 1.725332e-01 ];

%-- Image #73:
omc_73 = [ -1.394966e+00 ; -1.905683e+00 ; -2.018047e-01 ];
Tc_73  = [ -4.965851e+01 ; -9.003543e+01 ; 5.025802e+02 ];
omc_error_73 = [ 2.802095e-04 ; 3.409633e-04 ; 4.763236e-04 ];
Tc_error_73  = [ 1.876334e-01 ; 1.920456e-01 ; 1.711814e-01 ];

%-- Image #74:
omc_74 = [ -1.342353e+00 ; -2.008646e+00 ; 1.651027e-01 ];
Tc_74  = [ -3.068429e+01 ; -8.843448e+01 ; 5.253814e+02 ];
omc_error_74 = [ 2.861745e-04 ; 3.319648e-04 ; 4.942504e-04 ];
Tc_error_74  = [ 1.957834e-01 ; 2.001682e-01 ; 1.706034e-01 ];

%-- Image #75:
omc_75 = [ -1.768932e+00 ; -1.967846e+00 ; -1.137668e-01 ];
Tc_75  = [ -6.728917e+01 ; -7.596682e+01 ; 5.211497e+02 ];
omc_error_75 = [ 3.101341e-04 ; 3.340464e-04 ; 5.744288e-04 ];
Tc_error_75  = [ 1.941424e-01 ; 1.991798e-01 ; 1.735145e-01 ];

%-- Image #76:
omc_76 = [ -2.182247e+00 ; -1.848268e+00 ; -4.268242e-01 ];
Tc_76  = [ -9.539345e+01 ; -5.336013e+01 ; 5.072734e+02 ];
omc_error_76 = [ 3.597438e-04 ; 3.481736e-04 ; 6.638899e-04 ];
Tc_error_76  = [ 1.892711e-01 ; 1.950019e-01 ; 1.755731e-01 ];

%-- Image #77:
omc_77 = [ -2.565417e+00 ; -1.633148e+00 ; -7.739022e-01 ];
Tc_77  = [ -1.111033e+02 ; -2.401960e+01 ; 4.852666e+02 ];
omc_error_77 = [ 3.454993e-04 ; 3.327587e-04 ; 6.721483e-04 ];
Tc_error_77  = [ 1.815610e-01 ; 1.872519e-01 ; 1.728822e-01 ];

%-- Image #78:
omc_78 = [ 2.341683e+00 ; 1.420819e+00 ; 6.745048e-01 ];
Tc_78  = [ -1.128133e+02 ; -1.428001e+01 ; 4.764629e+02 ];
omc_error_78 = [ 4.084748e-04 ; 2.048228e-04 ; 5.925708e-04 ];
Tc_error_78  = [ 1.785483e-01 ; 1.839230e-01 ; 1.709052e-01 ];

%-- Image #79:
omc_79 = [ 2.398385e+00 ; 1.772606e+00 ; 4.606326e-01 ];
Tc_79  = [ -1.079589e+02 ; -3.262772e+01 ; 4.997512e+02 ];
omc_error_79 = [ 4.568770e-04 ; 3.030630e-04 ; 7.807633e-04 ];
Tc_error_79  = [ 1.869789e-01 ; 1.925423e-01 ; 1.762630e-01 ];

%-- Image #80:
omc_80 = [ -2.293659e+00 ; -2.027653e+00 ; -1.919011e-01 ];
Tc_80  = [ -9.368268e+01 ; -4.992736e+01 ; 5.209539e+02 ];
omc_error_80 = [ 5.330931e-04 ; 4.673493e-04 ; 1.047463e-03 ];
Tc_error_80  = [ 1.942389e-01 ; 1.998986e-01 ; 1.817185e-01 ];

%-- Image #81:
omc_81 = [ -1.972716e+00 ; -2.076011e+00 ; 8.032695e-02 ];
Tc_81  = [ -7.165014e+01 ; -6.415126e+01 ; 5.364520e+02 ];
omc_error_81 = [ 3.719186e-04 ; 3.627291e-04 ; 7.324030e-04 ];
Tc_error_81  = [ 1.994467e-01 ; 2.048117e-01 ; 1.733545e-01 ];

%-- Image #82:
omc_82 = [ -1.645013e+00 ; -2.077783e+00 ; 3.187288e-01 ];
Tc_82  = [ -4.462654e+01 ; -7.374743e+01 ; 5.450456e+02 ];
omc_error_82 = [ 3.154524e-04 ; 3.197777e-04 ; 5.712282e-04 ];
Tc_error_82  = [ 2.026030e-01 ; 2.076420e-01 ; 1.700268e-01 ];

%-- Image #83:
omc_83 = [ -1.566009e+00 ; -2.088817e+00 ; 7.313139e-01 ];
Tc_83  = [ -2.605532e+01 ; -6.035093e+01 ; 5.646674e+02 ];
omc_error_83 = [ 3.335940e-04 ; 2.987061e-04 ; 5.413199e-04 ];
Tc_error_83  = [ 2.095627e-01 ; 2.149496e-01 ; 1.656679e-01 ];

%-- Image #84:
omc_84 = [ -1.845229e+00 ; -2.154476e+00 ; 5.397172e-01 ];
Tc_84  = [ -5.076234e+01 ; -5.656479e+01 ; 5.598666e+02 ];
omc_error_84 = [ 3.480931e-04 ; 3.074872e-04 ; 6.351688e-04 ];
Tc_error_84  = [ 2.077269e-01 ; 2.133709e-01 ; 1.673222e-01 ];

%-- Image #85:
omc_85 = [ -2.122968e+00 ; -2.191486e+00 ; 3.186463e-01 ];
Tc_85  = [ -7.366487e+01 ; -5.058596e+01 ; 5.490755e+02 ];
omc_error_85 = [ 4.213383e-04 ; 3.846130e-04 ; 8.573824e-04 ];
Tc_error_85  = [ 2.037805e-01 ; 2.096570e-01 ; 1.692570e-01 ];

%-- Image #86:
omc_86 = [ 2.237895e+00 ; 2.049452e+00 ; -6.200746e-02 ];
Tc_86  = [ -9.202590e+01 ; -4.266297e+01 ; 5.329912e+02 ];
omc_error_86 = [ 5.813623e-04 ; 5.578584e-04 ; 1.226452e-03 ];
Tc_error_86  = [ 1.982691e-01 ; 2.039540e-01 ; 1.772346e-01 ];

%-- Image #87:
omc_87 = [ 2.214639e+00 ; 1.795809e+00 ; 1.852566e-01 ];
Tc_87  = [ -1.053908e+02 ; -3.326140e+01 ; 5.126827e+02 ];
omc_error_87 = [ 4.259484e-04 ; 3.440419e-04 ; 7.990595e-04 ];
Tc_error_87  = [ 1.914113e-01 ; 1.969800e-01 ; 1.746759e-01 ];

%-- Image #88:
omc_88 = [ 2.158746e+00 ; 1.537841e+00 ; 4.052071e-01 ];
Tc_88  = [ -1.116148e+02 ; -2.307911e+01 ; 4.895776e+02 ];
omc_error_88 = [ 3.746871e-04 ; 2.463930e-04 ; 5.866627e-04 ];
Tc_error_88  = [ 1.831159e-01 ; 1.886624e-01 ; 1.699915e-01 ];

%-- Image #89:
omc_89 = [ 1.918138e+00 ; 1.467809e+00 ; 2.788666e-01 ];
Tc_89  = [ -1.117462e+02 ; -2.307711e+01 ; 4.878987e+02 ];
omc_error_89 = [ 3.416413e-04 ; 2.608687e-04 ; 5.003402e-04 ];
Tc_error_89  = [ 1.821906e-01 ; 1.879928e-01 ; 1.667151e-01 ];

%-- Image #90:
omc_90 = [ 1.988559e+00 ; 1.666634e+00 ; 6.257752e-02 ];
Tc_90  = [ -1.084421e+02 ; -2.660926e+01 ; 5.114138e+02 ];
omc_error_90 = [ 3.338537e-04 ; 2.910365e-04 ; 5.760352e-04 ];
Tc_error_90  = [ 1.905754e-01 ; 1.965906e-01 ; 1.695936e-01 ];

%-- Image #91:
omc_91 = [ 2.037990e+00 ; 1.860626e+00 ; -1.742962e-01 ];
Tc_91  = [ -9.808955e+01 ; -3.013093e+01 ; 5.329242e+02 ];
omc_error_91 = [ 3.401527e-04 ; 3.462828e-04 ; 6.803683e-04 ];
Tc_error_91  = [ 1.980734e-01 ; 2.042416e-01 ; 1.700409e-01 ];

%-- Image #92:
omc_92 = [ 2.063431e+00 ; 2.045867e+00 ; -4.281304e-01 ];
Tc_92  = [ -8.365366e+01 ; -3.348138e+01 ; 5.514660e+02 ];
omc_error_92 = [ 3.208023e-04 ; 3.895280e-04 ; 7.217717e-04 ];
Tc_error_92  = [ 2.045811e-01 ; 2.108793e-01 ; 1.677982e-01 ];

%-- Image #93:
omc_93 = [ 2.062645e+00 ; 2.223165e+00 ; -7.053591e-01 ];
Tc_93  = [ -6.371835e+01 ; -3.624792e+01 ; 5.657904e+02 ];
omc_error_93 = [ 2.542450e-04 ; 4.082903e-04 ; 6.798995e-04 ];
Tc_error_93  = [ 2.097356e-01 ; 2.158915e-01 ; 1.658288e-01 ];

%-- Image #94:
omc_94 = [ -1.847898e+00 ; -2.171450e+00 ; 9.136035e-01 ];
Tc_94  = [ -4.199641e+01 ; -3.827475e+01 ; 5.748073e+02 ];
omc_error_94 = [ 3.700280e-04 ; 2.695160e-04 ; 6.015079e-04 ];
Tc_error_94  = [ 2.130521e-01 ; 2.189865e-01 ; 1.643862e-01 ];

