/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class AggregateDumpAnalyzer {
    private double totNrOfTransfer = 0.0;
    private double totNrOfDebit = 0.0;
    private double totNrOfCashIn = 0.0;
    private double totNrOfCashOut = 0.0;
    private double totNrOfDeposit = 0.0;
    private double totNrOfPayments = 0.0;
    private double avgAvgTransfer = 0.0;
    private double avgAvgDebit = 0.0;
    private double avgAvgCashIn = 0.0;
    private double avgAvgCashOut = 0.0;
    private double avgAvgDeposit = 0.0;
    private double avgAvgPayments = 0.0;
    private double avgStdTransfer = 0.0;
    private double avgStdDebit = 0.0;
    private double avgStdCashIn = 0.0;
    private double avgStdCashOut = 0.0;
    private double avgStdDeposit = 0.0;
    private double avgStdPayment = 0.0;
    private ArrayList<String> fileContents = new ArrayList();

    public AggregateDumpAnalyzer(String string) {
        this.init(string);
    }

    private void init(String string) {
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                this.fileContents.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void analyze() {
        this.calculateTotal();
        this.calculateAvgOfAvg();
        this.calculateAvgStd();
    }

    private void calculateTotal() {
        this.totNrOfCashIn = this.getCount(1);
        this.totNrOfCashOut = this.getCount(2);
        this.totNrOfDebit = this.getCount(3);
        this.totNrOfDeposit = this.getCount(4);
        this.totNrOfPayments = this.getCount(5);
        this.totNrOfTransfer = this.getCount(6);
    }

    private void calculateAvgOfAvg() {
        this.avgAvgCashIn = this.getAvgAvg(1);
        this.avgAvgCashOut = this.getAvgAvg(2);
        this.avgAvgDebit = this.getAvgAvg(3);
        this.avgAvgDeposit = this.getAvgAvg(4);
        this.avgAvgPayments = this.getAvgAvg(5);
        this.avgAvgTransfer = this.getAvgAvg(6);
    }

    private void calculateAvgStd() {
        this.avgStdCashIn = this.getAvgStd(1);
        this.avgStdCashOut = this.getAvgStd(2);
        this.avgStdDebit = this.getAvgStd(3);
        this.avgStdDeposit = this.getAvgStd(4);
        this.avgStdPayment = this.getAvgStd(5);
        this.avgStdTransfer = this.getAvgAvg(6);
    }

    public void printSummary() {
        String[] stringArray;
        DecimalFormat decimalFormat = new DecimalFormat("#.##########");
        for (String string : stringArray = this.toString().split(",")) {
            System.out.println(string + "\n");
        }
        double d = this.totNrOfCashIn + this.totNrOfCashOut + this.totNrOfDebit + this.totNrOfDeposit + this.totNrOfPayments + this.totNrOfTransfer;
        System.out.println("\n\nTot\t" + decimalFormat.format(d) + "\n");
    }

    private boolean isNumber(String string) {
        boolean bl = true;
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private String getTypeFromNumber(int n) {
        switch (n) {
            case 1: {
                return "CASH_IN";
            }
            case 2: {
                return "CASH_OUT";
            }
            case 3: {
                return "DEBIT";
            }
            case 4: {
                return "DEPOSIT";
            }
            case 5: {
                return "PAYMENT";
            }
            case 6: {
                return "TRANSFER";
            }
        }
        return null;
    }

    private double getCount(int n) {
        double d = 0.0;
        for (String string : this.fileContents) {
            String[] stringArray = string.split(",");
            String string2 = stringArray[0];
            if (!this.isNumber(string2)) {
                String string3 = this.getTypeFromNumber(n);
                if (!string3.equals(string2)) continue;
                d += Double.parseDouble(stringArray[4]);
                continue;
            }
            if (Double.parseDouble(string2) != (double)n) continue;
            d += Double.parseDouble(stringArray[4]);
        }
        return d;
    }

    private double getAvgAvg(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (String string : this.fileContents) {
            String[] stringArray = string.split(",");
            String string2 = stringArray[0];
            if (!this.isNumber(string2)) {
                String string3 = this.getTypeFromNumber(n);
                if (!string3.equals(string2)) continue;
                d += Double.parseDouble(stringArray[6]);
                d2 += 1.0;
                continue;
            }
            if (Double.parseDouble(string2) != (double)n) continue;
            d += Double.parseDouble(stringArray[6]);
            d2 += 1.0;
        }
        return d /= d2;
    }

    private double getAvgStd(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (String string : this.fileContents) {
            String[] stringArray = string.split(",");
            String string2 = stringArray[0];
            if (!this.isNumber(string2)) {
                String string3 = this.getTypeFromNumber(n);
                if (!string3.equals(string2)) continue;
                d += Double.parseDouble(stringArray[7]);
                d2 += 1.0;
                continue;
            }
            if (Double.parseDouble(string2) != (double)n) continue;
            d += Double.parseDouble(stringArray[7]);
            d2 += 1.0;
        }
        return d /= d2;
    }

    public double getTotNrOfTransfer() {
        return this.totNrOfTransfer;
    }

    public void setTotNrOfTransfer(double d) {
        this.totNrOfTransfer = d;
    }

    public double getTotNrOfDebit() {
        return this.totNrOfDebit;
    }

    public void setTotNrOfDebit(double d) {
        this.totNrOfDebit = d;
    }

    public double getTotNrOfCashIn() {
        return this.totNrOfCashIn;
    }

    public void setTotNrOfCashIn(double d) {
        this.totNrOfCashIn = d;
    }

    public double getTotNrOfCashOut() {
        return this.totNrOfCashOut;
    }

    public void setTotNrOfCashOut(double d) {
        this.totNrOfCashOut = d;
    }

    public double getTotNrOfDeposit() {
        return this.totNrOfDeposit;
    }

    public void setTotNrOfDeposit(double d) {
        this.totNrOfDeposit = d;
    }

    public double getTotNrOfPayments() {
        return this.totNrOfPayments;
    }

    public void setTotNrOfPayments(double d) {
        this.totNrOfPayments = d;
    }

    public ArrayList<String> getFileContents() {
        return this.fileContents;
    }

    public void setFileContents(ArrayList<String> arrayList) {
        this.fileContents = arrayList;
    }

    public double getAvgAvgTransfer() {
        return this.avgAvgTransfer;
    }

    public void setAvgAvgTransfer(double d) {
        this.avgAvgTransfer = d;
    }

    public double getAvgAvgDebit() {
        return this.avgAvgDebit;
    }

    public void setAvgAvgDebit(double d) {
        this.avgAvgDebit = d;
    }

    public double getAvgAvgCashIn() {
        return this.avgAvgCashIn;
    }

    public void setAvgAvgCashIn(double d) {
        this.avgAvgCashIn = d;
    }

    public double getAvgAvgCashOut() {
        return this.avgAvgCashOut;
    }

    public void setAvgAvgCashOut(double d) {
        this.avgAvgCashOut = d;
    }

    public double getAvgAvgDeposit() {
        return this.avgAvgDeposit;
    }

    public void setAvgAvgDeposit(double d) {
        this.avgAvgDeposit = d;
    }

    public double getAvgAvgPayments() {
        return this.avgAvgPayments;
    }

    public void setAvgAvgPayments(double d) {
        this.avgAvgPayments = d;
    }

    public double getAvgStdTransfer() {
        return this.avgStdTransfer;
    }

    public void setAvgStdTransfer(double d) {
        this.avgStdTransfer = d;
    }

    public double getAvgStdDebit() {
        return this.avgStdDebit;
    }

    public void setAvgStdDebit(double d) {
        this.avgStdDebit = d;
    }

    public double getAvgStdCashIn() {
        return this.avgStdCashIn;
    }

    public void setAvgStdCashIn(double d) {
        this.avgStdCashIn = d;
    }

    public double getAvgStdCashOut() {
        return this.avgStdCashOut;
    }

    public void setAvgStdCashOut(double d) {
        this.avgStdCashOut = d;
    }

    public double getAvgStdDeposit() {
        return this.avgStdDeposit;
    }

    public void setAvgStdDeposit(double d) {
        this.avgStdDeposit = d;
    }

    public double getAvgStdPayment() {
        return this.avgStdPayment;
    }

    public void setAvgStdPayment(double d) {
        this.avgStdPayment = d;
    }

    public String toString() {
        return "AggregateDumpAnalyzer [totNrOfTransfer=" + this.totNrOfTransfer + ", totNrOfDebit=" + this.totNrOfDebit + ", totNrOfCashIn=" + this.totNrOfCashIn + ", totNrOfCashOut=" + this.totNrOfCashOut + ", totNrOfDeposit=" + this.totNrOfDeposit + ", totNrOfPayments=" + this.totNrOfPayments + ", avgAvgTransfer=" + this.avgAvgTransfer + ", avgAvgDebit=" + this.avgAvgDebit + ", avgAvgCashIn=" + this.avgAvgCashIn + ", avgAvgCashOut=" + this.avgAvgCashOut + ", avgAvgDeposit=" + this.avgAvgDeposit + ", avgAvgPayments=" + this.avgAvgPayments + ", avgStdTransfer=" + this.avgStdTransfer + ", avgStdDebit=" + this.avgStdDebit + ", avgStdCashIn=" + this.avgStdCashIn + ", avgStdCashOut=" + this.avgStdCashOut + ", avgStdDeposit=" + this.avgStdDeposit + ", avgStdPayment=" + this.avgStdPayment + "]";
    }
}

