/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.util.ArrayList;
import paysim.ActionProbability;
import paysim.AggregateTransactionRecord;
import paysim.CurrentStepHandler;
import paysim.Manager;
import paysim.Merchant;
import paysim.PaySim;
import paysim.SuperClient;
import paysim.Transaction;
import sim.engine.SimState;
import sim.engine.Steppable;

public class ClientBeta
extends SuperClient
implements Steppable {
    private String name = "";
    private boolean willRepeat = false;
    boolean failed = false;
    private double[] probabilityArr;
    private ArrayList<ActionProbability> probList;
    private ArrayList<Long> stepsToRepeat = new ArrayList();
    private long nrOfStepsToRepeat = 0L;
    private ArrayList<String> paramFile = new ArrayList();
    String currType = "";
    private CurrentStepHandler stepHandler = null;
    private double x;
    private double y;

    public double getDiff(ClientBeta clientBeta) {
        double d = clientBeta.getX() - this.x;
        d *= d;
        double d2 = clientBeta.getY() - this.y;
        d2 *= d2;
        double d3 = d + d2;
        d3 = Math.sqrt(d3);
        return d3;
    }

    public void move(PaySim paySim) {
        int n = 0;
        int n2 = 0;
        while ((n = paySim.random.nextInt() % 5) == 0) {
        }
        while ((n2 = paySim.random.nextInt() % 5) == 0) {
        }
        System.out.println("RandedX:\t" + n + "\tRandedY:\t" + n2 + "\n");
        this.x += (double)n;
        this.y += (double)n2;
        if (this.x > 1000.0) {
            this.x = 1000.0;
        } else if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.y > 1000.0) {
            this.y = 1000.0;
        } else if (this.y < 0.0) {
            this.y = 0.0;
        }
        System.out.println("X:\t" + this.x + "\tY:\t" + this.y + "\n");
    }

    @Override
    public void step(SimState simState) {
        this.handleAction(simState);
        if (this.cont != null) {
            this.handleRepetition(simState);
        }
    }

    public long getNrOfStepsToRepeat() {
        return this.nrOfStepsToRepeat;
    }

    public void setNrOfStepsToRepeat(long l) {
        this.nrOfStepsToRepeat = l;
    }

    public void handleAction(SimState simState) {
        PaySim paySim = (PaySim)simState;
        int n = 0;
        do {
            if ((n = this.chooseAction(paySim, this.probabilityArr)) != -1 || this.probabilityArr.length != 0) continue;
            return;
        } while (n == -1);
        switch (n) {
            case 1: {
                this.handleCashIn(paySim);
                break;
            }
            case 2: {
                this.handleCashOut(paySim);
                break;
            }
            case 3: {
                this.handleDebit(paySim);
                break;
            }
            case 4: {
                this.handleDeposit(paySim);
                break;
            }
            case 5: {
                this.handlePayment(paySim);
                break;
            }
            case 6: {
                this.handleTransfer(paySim);
            }
        }
    }

    public void handleRepetition(SimState simState) {
        PaySim paySim = (PaySim)simState;
        block16: for (int i = 0; i < this.stepsToRepeat.size(); ++i) {
            long l = this.stepsToRepeat.get(i);
            this.currDay = (int)(l / 24L) + 1;
            this.currHour = (int)(l - (long)((this.currDay - 1) * 24));
            switch (this.cont.getType()) {
                case "CASH_IN": {
                    this.currType = "CASH_IN";
                    this.handleCashInRepetition(paySim);
                    continue block16;
                }
                case "CASH_OUT": {
                    this.currType = "CASH_OUT";
                    this.handleCashOutRepetition(paySim);
                    continue block16;
                }
                case "DEBIT": {
                    this.currType = "DEBIT";
                    this.handleDebitRepetition(paySim);
                    continue block16;
                }
                case "DEPOSIT": {
                    this.currType = "DEPOSIT";
                    this.handleDepositRepetition(paySim);
                    continue block16;
                }
                case "PAYMENT": {
                    this.currType = "PAYMENT";
                    this.handlePaymentRepetition(paySim);
                    continue block16;
                }
                case "TRANSFER": {
                    this.currType = "TRANSFER";
                    this.handleTrasferRepetition(paySim);
                }
            }
        }
    }

    public void setClientBeta(ClientBeta clientBeta) {
        this.balance = clientBeta.getBalance();
        this.currency = clientBeta.getCurrency();
        this.currStep = clientBeta.getCurrStep();
        this.name = clientBeta.getName();
        this.numDeposits = clientBeta.getNumDeposits();
        this.numTransfers = clientBeta.getNumTransfers();
        this.numWithdraws = clientBeta.getNumWithdraws();
    }

    public double[] getProbabilityArr() {
        return this.probabilityArr;
    }

    public void setProbabilityArr(double[] dArray) {
        this.probabilityArr = dArray;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        Object object = super.toString();
        object = (String)object + "\t" + this.name;
        return this.name;
    }

    public void handleCashIn(PaySim paySim) {
        ActionProbability actionProbability = this.getProb("CASH_IN", paySim);
        if (actionProbability != null) {
            double d = this.getAmount(actionProbability, paySim);
            ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
            ClientBeta clientBeta2 = new ClientBeta();
            clientBeta2.setClientBeta(clientBeta);
            ClientBeta clientBeta3 = new ClientBeta();
            clientBeta3.setClientBeta(this);
            clientBeta.withdraw(d);
            this.deposit(d);
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 1, d, "CashIn");
            transaction.setClientBetaDestAfter(clientBeta);
            transaction.setClientBetaDestBefore(clientBeta2);
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            paySim.getTrans().add(transaction);
        } else {
            ++Manager.nrFailed;
            this.printActionProbability();
        }
    }

    public void handleCashOut(PaySim paySim) {
        ActionProbability actionProbability = this.getProb("CASH_OUT", paySim);
        if (actionProbability != null) {
            double d = this.getAmount(actionProbability, paySim);
            ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
            ClientBeta clientBeta2 = new ClientBeta();
            clientBeta2.setClientBeta(clientBeta);
            ClientBeta clientBeta3 = new ClientBeta();
            clientBeta3.setClientBeta(this);
            this.withdraw(d);
            clientBeta.deposit(d);
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 2, d, "CashOut");
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            transaction.setClientBetaDestAfter(clientBeta);
            transaction.setClientBetaDestBefore(clientBeta2);
            paySim.getTrans().add(transaction);
        } else {
            this.printActionProbability();
        }
    }

    public void handleDeposit(PaySim paySim) {
        ActionProbability actionProbability = this.getProb("DEPOSIT", paySim);
        if (actionProbability != null) {
            double d = this.getAmount(actionProbability, paySim);
            ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
            ClientBeta clientBeta2 = new ClientBeta();
            clientBeta2.setClientBeta(clientBeta);
            ClientBeta clientBeta3 = new ClientBeta();
            clientBeta3.setClientBeta(this);
            clientBeta.withdraw(d);
            this.deposit(d);
            ++this.numDeposits;
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 4, d, "Deposit");
            transaction.setClientBetaDestAfter(clientBeta);
            transaction.setClientBetaDestBefore(clientBeta2);
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            paySim.getTrans().add(transaction);
        } else {
            this.printActionProbability();
        }
    }

    public void handlePayment(PaySim paySim) {
        Merchant merchant = this.getRandomMerchant(paySim);
        Merchant merchant2 = new Merchant();
        merchant2.setMerchant(merchant);
        ActionProbability actionProbability = this.getProb("PAYMENT", paySim);
        if (actionProbability != null) {
            double d = this.getAmount(actionProbability, paySim);
            ClientBeta clientBeta = new ClientBeta();
            clientBeta.setClientBeta(this);
            this.withdraw(d);
            merchant.deposit(d);
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta, this, 5, d, "Payment");
            transaction.setMerchantAfter(merchant);
            transaction.setMerchantBefore(merchant2);
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            paySim.getTrans().add(transaction);
        } else {
            this.printActionProbability();
        }
    }

    public void handleTransfer(PaySim paySim) {
        ActionProbability actionProbability = this.getProb("TRANSFER", paySim);
        if (actionProbability != null) {
            double d = this.getAmount(actionProbability, paySim);
            ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
            ClientBeta clientBeta2 = new ClientBeta();
            clientBeta2.setClientBeta(clientBeta);
            ClientBeta clientBeta3 = new ClientBeta();
            clientBeta3.setClientBeta(this);
            this.withdraw(d);
            clientBeta.deposit(d);
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 6, d, "Transfer");
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            transaction.setClientBetaDestAfter(clientBeta);
            transaction.setClientBetaDestBefore(clientBeta2);
            paySim.getTrans().add(transaction);
        } else {
            this.printActionProbability();
        }
    }

    public void handleDebit(PaySim paySim) {
        ActionProbability actionProbability = this.getProb("DEBIT", paySim);
        if (actionProbability != null) {
            double d = this.getAmount(actionProbability, paySim);
            ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
            ClientBeta clientBeta2 = new ClientBeta();
            clientBeta2.setClientBeta(clientBeta);
            ClientBeta clientBeta3 = new ClientBeta();
            clientBeta3.setClientBeta(this);
            this.withdraw(d);
            clientBeta.deposit(d);
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 3, d, "Debit");
            transaction.setClientBetaDestBefore(clientBeta2);
            transaction.setClientBetaDestAfter(clientBeta);
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            paySim.getTrans().add(transaction);
        } else {
            this.printActionProbability();
        }
    }

    public void handleCashInRepetition(PaySim paySim) {
        double d = this.getAmountRepetition(this.currType, this.currDay, this.currHour, paySim);
        if (d == -1.0) {
            return;
        }
        ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
        ClientBeta clientBeta2 = new ClientBeta();
        clientBeta2.setClientBeta(clientBeta);
        ClientBeta clientBeta3 = new ClientBeta();
        clientBeta3.setClientBeta(this);
        clientBeta.withdraw(d);
        this.deposit(d);
        Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 1, d, "CashIn");
        transaction.setClientBetaDestAfter(clientBeta);
        transaction.setClientBetaDestBefore(clientBeta2);
        transaction.setDay(this.currDay);
        transaction.setHour(this.currHour);
        paySim.getTrans().add(transaction);
    }

    public void handleCashOutRepetition(PaySim paySim) {
        double d = this.getAmountRepetition(this.currType, this.currDay, this.currHour, paySim);
        if (d == -1.0) {
            return;
        }
        ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
        ClientBeta clientBeta2 = new ClientBeta();
        clientBeta2.setClientBeta(clientBeta);
        ClientBeta clientBeta3 = new ClientBeta();
        clientBeta3.setClientBeta(this);
        this.withdraw(d);
        clientBeta.deposit(d);
        Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 2, d, "CashOut");
        transaction.setDay(this.currDay);
        transaction.setHour(this.currHour);
        transaction.setClientBetaDestAfter(clientBeta);
        transaction.setClientBetaDestBefore(clientBeta2);
        paySim.getTrans().add(transaction);
    }

    public void handleDebitRepetition(PaySim paySim) {
        double d = this.getAmountRepetition(this.currType, this.currDay, this.currHour, paySim);
        if (d == -1.0) {
            return;
        }
        ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
        ClientBeta clientBeta2 = new ClientBeta();
        clientBeta2.setClientBeta(clientBeta);
        ClientBeta clientBeta3 = new ClientBeta();
        clientBeta3.setClientBeta(this);
        this.withdraw(d);
        clientBeta.deposit(d);
        Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 3, d, "Debit");
        transaction.setClientBetaDestBefore(clientBeta2);
        transaction.setClientBetaDestAfter(clientBeta);
        transaction.setDay(this.currDay);
        transaction.setHour(this.currHour);
        paySim.getTrans().add(transaction);
    }

    public void handleDepositRepetition(PaySim paySim) {
        double d = this.getAmountRepetition(this.currType, this.currDay, this.currHour, paySim);
        if (d == -1.0) {
            return;
        }
        ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
        ClientBeta clientBeta2 = new ClientBeta();
        clientBeta2.setClientBeta(clientBeta);
        ClientBeta clientBeta3 = new ClientBeta();
        clientBeta3.setClientBeta(this);
        clientBeta.withdraw(d);
        this.deposit(d);
        ++this.numDeposits;
        Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 4, d, "Deposit");
        transaction.setClientBetaDestAfter(clientBeta);
        transaction.setClientBetaDestBefore(clientBeta2);
        transaction.setDay(this.currDay);
        transaction.setHour(this.currHour);
        paySim.getTrans().add(transaction);
    }

    public void handlePaymentRepetition(PaySim paySim) {
        Merchant merchant = this.getRandomMerchant(paySim);
        Merchant merchant2 = new Merchant();
        merchant2.setMerchant(merchant);
        double d = this.getAmountRepetition(this.currType, this.currDay, this.currHour, paySim);
        if (d == -1.0) {
            return;
        }
        ClientBeta clientBeta = new ClientBeta();
        clientBeta.setClientBeta(this);
        this.withdraw(d);
        merchant.deposit(d);
        Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta, this, 5, d, "Payment");
        transaction.setMerchantAfter(merchant);
        transaction.setMerchantBefore(merchant2);
        transaction.setDay(this.currDay);
        transaction.setHour(this.currHour);
        paySim.getTrans().add(transaction);
    }

    public void handleTrasferRepetition(PaySim paySim) {
        double d = this.getAmountRepetition(this.currType, this.currDay, this.currHour, paySim);
        if (d == -1.0) {
            return;
        }
        try {
            ClientBeta clientBeta = this.getRandomClientBeta(d, paySim);
            ClientBeta clientBeta2 = new ClientBeta();
            clientBeta2.setClientBeta(clientBeta);
            ClientBeta clientBeta3 = new ClientBeta();
            clientBeta3.setClientBeta(this);
            this.withdraw(d);
            clientBeta.deposit(d);
            Transaction transaction = new Transaction((Long)paySim.schedule.getSteps(), clientBeta3, this, 6, d, "Transfer");
            transaction.setDay(this.currDay);
            transaction.setHour(this.currHour);
            transaction.setClientBetaDestAfter(clientBeta);
            transaction.setClientBetaDestBefore(clientBeta2);
            paySim.getTrans().add(transaction);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public ArrayList<ActionProbability> getProbList() {
        return this.probList;
    }

    public boolean isWillRepeat() {
        return this.willRepeat;
    }

    public ClientBeta getRandomClientBeta(double d, PaySim paySim) {
        ClientBeta clientBeta = new ClientBeta();
        int n = 0;
        do {
            clientBeta = paySim.getClientsBeta().get(paySim.random.nextInt(paySim.getClientsBeta().size()));
        } while (++n <= 50000 && clientBeta.getBalance() < d);
        return clientBeta;
    }

    public Merchant getRandomMerchant(PaySim paySim) {
        Merchant merchant = paySim.getMerchants().get(paySim.random.nextInt(paySim.getMerchants().size()));
        return merchant;
    }

    public void setWillRepeat(boolean bl) {
        this.willRepeat = bl;
    }

    public void setProbList(ArrayList<ActionProbability> arrayList) {
        this.probList = arrayList;
    }

    private double getAmount(ActionProbability actionProbability, PaySim paySim) {
        double d = 0.0;
        while ((d = paySim.random.nextGaussian() * actionProbability.getStd() + actionProbability.getAverage()) <= 0.0) {
        }
        return d;
    }

    private double getAmountRepetition(String string, int n, int n2, PaySim paySim) {
        AggregateTransactionRecord aggregateTransactionRecord = this.stepHandler.getRecord(string, n, n2);
        if (aggregateTransactionRecord == null) {
            return -1.0;
        }
        double d = 0.0;
        while ((d = paySim.random.nextGaussian() * Double.parseDouble(aggregateTransactionRecord.gettStd()) + Double.parseDouble(aggregateTransactionRecord.gettAvg())) <= 0.0) {
        }
        return d;
    }

    public ArrayList<Long> getStepsToRepeat() {
        return this.stepsToRepeat;
    }

    public void setStepsToRepeat(ArrayList<Long> arrayList) {
        this.stepsToRepeat = arrayList;
    }

    private ActionProbability getProb(String string, PaySim paySim) {
        for (ActionProbability actionProbability : this.probList) {
            if (!actionProbability.getType().equals(string)) continue;
            return actionProbability;
        }
        return null;
    }

    private void printActionProbability() {
        System.out.println("Printing prob\n");
        for (ActionProbability actionProbability : this.probList) {
            System.out.println(actionProbability.getType() + "\n" + actionProbability.getNrOfTransactions() + "\n");
        }
        System.out.println("\n\n");
    }

    public ArrayList<String> getParamFile() {
        return this.paramFile;
    }

    public void setParamFile(ArrayList<String> arrayList) {
        this.paramFile = arrayList;
    }

    public CurrentStepHandler getStepHandler() {
        return this.stepHandler;
    }

    public void setStepHandler(CurrentStepHandler currentStepHandler) {
        this.stepHandler = currentStepHandler;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }
}

