/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.util.ArrayList;
import paysim.ActionProbability;
import paysim.AggregateTransactionRecord;
import paysim.Client;
import paysim.ClientBeta;
import paysim.CurrentStepHandler;
import paysim.InitBalanceHandler;
import paysim.PaySim;
import paysim.ProbabilityContainerHandler;
import paysim.ProbabilityRecordContainer;
import paysim.RepetitionContainer;
import paysim.RepetitionFreqHandler;
import paysim.RepetitionHandler;
import paysim.SuperClient;
import paysim.TransferMaxHandler;
import sim.engine.SimState;
import sim.engine.Steppable;

public class Manager
implements Steppable {
    private int nrOfClientRepeat = 0;
    public static int cashInCounter = 0;
    public static int trueNrOfClients = 0;
    public static int trueNrOfRepetitions = 0;
    public static int nrFailed = 0;
    public static int nrOfDaysParticipated = 0;
    ProbabilityContainerHandler probabilityHandler = new ProbabilityContainerHandler();
    long debugCounter = 0L;
    int currDay = 0;
    int currHour = 0;
    long nrOfStepsTotal = 0L;
    RepetitionHandler repHandler;
    private TransferMaxHandler transferMaxHandler;
    private InitBalanceHandler balanceHandler;
    private CurrentStepHandler stepHandler;
    RepetitionFreqHandler repFreqHandler = new RepetitionFreqHandler();

    public void setTransferMaxHandler(TransferMaxHandler transferMaxHandler) {
        this.transferMaxHandler = transferMaxHandler;
    }

    public TransferMaxHandler getTransferMaxHandler() {
        return this.transferMaxHandler;
    }

    public void step(SimState simState) {
        PaySim paySim = (PaySim)simState;
        this.repHandler = new RepetitionHandler(paySim.seed, paySim);
        long l = paySim.schedule.getSteps() + 1L;
        long l2 = this.stepHandler.getNrOfTimesToReduce(l);
        ArrayList<ActionProbability> arrayList = this.getActionProbabilityFromStep(l, paySim);
        int n = this.getNrOfClients(arrayList);
        trueNrOfClients += n;
        n = (int)((double)n * paySim.getMultiplier());
        if (paySim.debugFlag) {
            System.out.println("Step:\t" + l + "\tNrOfClients Before:\t" + n + "\n");
        }
        double[] dArray = paySim.loadProbabilites(arrayList, n);
        if (l2 != -1L) {
            n = (int)((long)n - l2);
        }
        trueNrOfRepetitions = (int)((long)trueNrOfRepetitions + l2);
        if (paySim.debugFlag) {
            // empty if block
        }
        this.nrOfClientRepeat = n < 0 ? n * -1 : 0;
        for (int i = 0; i < n; ++i) {
            SuperClient superClient;
            if (!paySim.clientBetaFlag) {
                superClient = this.generateClient(dArray, arrayList, paySim, l);
                ++this.debugCounter;
                if (((Client)superClient).getStepsToRepeat().size() != 0) {
                    paySim.getClients().add((Client)superClient);
                }
                paySim.schedule.scheduleOnce((Steppable)superClient);
                continue;
            }
            superClient = this.generateClientBeta(dArray, arrayList, paySim, l);
            ++this.debugCounter;
            if (((ClientBeta)superClient).getStepsToRepeat().size() != 0) {
                paySim.getClientsBeta().add((ClientBeta)superClient);
            }
            paySim.schedule.scheduleOnce((Steppable)superClient);
        }
        this.updatePaysimOutputs(paySim);
    }

    private void updatePaysimOutputs(PaySim paySim) {
        ArrayList<AggregateTransactionRecord> arrayList;
        if (paySim.debugFlag) {
            System.out.println("Updating\n");
        }
        if ((arrayList = paySim.getAggregateCreator().generateAggregateParamFile(paySim.getTrans())).size() > 0) {
            ++nrOfDaysParticipated;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            paySim.getAggrTransRecordList().add(arrayList.get(i));
        }
        paySim.writeLog();
        if (paySim.saveToDbFlag) {
            // empty if block
        }
        paySim.resetVariables();
    }

    private ClientBeta generateClientBeta(double[] dArray, ArrayList<ActionProbability> arrayList, PaySim paySim, long l) {
        double d = 0.0;
        ClientBeta clientBeta = new ClientBeta();
        clientBeta.setStepHandler(this.stepHandler);
        clientBeta.setParamFile(paySim.getParamFileList());
        clientBeta.setProbabilityArr(dArray);
        clientBeta.setProbList(arrayList);
        clientBeta.setName(String.valueOf(clientBeta.hashCode()));
        clientBeta.setBalance(this.balanceHandler.getBalance());
        clientBeta.setCurrDay(this.currDay);
        clientBeta.setCurrHour(this.currHour);
        clientBeta.setTransferMaxHandler(this.transferMaxHandler);
        RepetitionContainer repetitionContainer = this.repHandler.getRepetition();
        if (repetitionContainer.getLow() == 1.0 && repetitionContainer.getHigh() == 1.0) {
            return clientBeta;
        }
        long l2 = 0L;
        if (repetitionContainer.getLow() - repetitionContainer.getHigh() == 0.0) {
            l2 = (int)repetitionContainer.getLow();
        } else {
            int n = paySim.random.nextInt() % (int)(repetitionContainer.getHigh() - repetitionContainer.getLow());
            if (n < 0) {
                n *= -1;
            }
            if ((double)(l2 = (long)((int)(repetitionContainer.getLow() + (double)n))) > (d = this.transferMaxHandler.getMaxGivenType(repetitionContainer.getType()))) {
                l2 = (long)d;
            }
        }
        l2 = (long)((double)l2 * paySim.getMultiplier());
        ArrayList<Long> arrayList2 = this.stepHandler.getSteps(l, l2);
        if (arrayList2 == null) {
            return clientBeta;
        }
        this.nrOfClientRepeat = (int)((long)this.nrOfClientRepeat + l2);
        clientBeta.setStepsToRepeat(arrayList2);
        clientBeta.setCont(repetitionContainer);
        return clientBeta;
    }

    private Client generateClient(double[] dArray, ArrayList<ActionProbability> arrayList, PaySim paySim, long l) {
        double d = 0.0;
        Client client = new Client();
        client.setStepHandler(this.stepHandler);
        client.setParamFile(paySim.getParamFileList());
        client.setProbabilityArr(dArray);
        client.setProbList(arrayList);
        client.setName(String.valueOf(String.valueOf(System.currentTimeMillis()).hashCode()));
        client.setBalance(this.balanceHandler.getBalance());
        client.setCurrDay(this.currDay);
        client.setCurrHour(this.currHour);
        client.setTransferMaxHandler(this.transferMaxHandler);
        RepetitionContainer repetitionContainer = this.repHandler.getRepetition();
        this.repFreqHandler.add(repetitionContainer);
        if (repetitionContainer.getLow() == 1.0 && repetitionContainer.getHigh() == 1.0) {
            return client;
        }
        long l2 = 0L;
        if (repetitionContainer.getLow() - repetitionContainer.getHigh() == 0.0) {
            l2 = (int)repetitionContainer.getLow();
        } else {
            int n = paySim.random.nextInt() % (int)(repetitionContainer.getHigh() - repetitionContainer.getLow());
            if (n < 0) {
                n *= -1;
            }
            if ((double)(l2 = (long)((int)(repetitionContainer.getLow() + (double)n))) > (d = this.transferMaxHandler.getMaxGivenType(repetitionContainer.getType()))) {
                l2 = (long)d;
            }
        }
        l2 = (long)((double)l2 * paySim.getMultiplier());
        ArrayList<Long> arrayList2 = this.stepHandler.getSteps(l, l2);
        if (arrayList2 == null) {
            return client;
        }
        this.nrOfClientRepeat = (int)((long)this.nrOfClientRepeat + l2);
        client.setStepsToRepeat(arrayList2);
        client.setCont(repetitionContainer);
        return client;
    }

    public long getNrOfStepsTotal() {
        return this.nrOfStepsTotal;
    }

    public void setNrOfStepsTotal(long l) {
        this.nrOfStepsTotal = l;
    }

    public boolean doesRepeat(PaySim paySim) {
        int n = paySim.random.nextInt() % 10;
        while (n <= 0) {
            n = paySim.random.nextInt() % 10;
        }
        return n == 1;
    }

    public ArrayList<ActionProbability> getActionProbabilityFromStep(long l, PaySim paySim) {
        ArrayList<ActionProbability> arrayList = new ArrayList();
        int n = (int)(l / 24L) + 1;
        int n2 = (int)(l - (long)((n - 1) * 24));
        this.currDay = n;
        this.currHour = n2;
        ProbabilityRecordContainer probabilityRecordContainer = this.probabilityHandler.getList().get((int)l - 1);
        arrayList = probabilityRecordContainer.getProbList();
        if (paySim.debugFlag) {
            System.out.println("Was searching for step:\t" + l + " And got from origAggrTransList:\n");
            for (ActionProbability actionProbability : arrayList) {
                System.out.println(actionProbability.toString() + "\n\n");
            }
        }
        return arrayList;
    }

    public InitBalanceHandler getBalanceHandler() {
        return this.balanceHandler;
    }

    public void setBalanceHandler(InitBalanceHandler initBalanceHandler) {
        this.balanceHandler = initBalanceHandler;
    }

    public int getNrOfClients(ArrayList<ActionProbability> arrayList) {
        int n = 0;
        for (ActionProbability actionProbability : arrayList) {
            n = (int)((double)n + actionProbability.getNrOfTransactions());
        }
        return n;
    }

    public CurrentStepHandler getStepHandler() {
        return this.stepHandler;
    }

    public void setStepHandler(CurrentStepHandler currentStepHandler) {
        this.stepHandler = currentStepHandler;
    }

    public ProbabilityContainerHandler getProbabilityHandler() {
        return this.probabilityHandler;
    }

    public void setProbabilityHandler(ProbabilityContainerHandler probabilityContainerHandler) {
        this.probabilityHandler = probabilityContainerHandler;
    }

    public RepetitionFreqHandler getRepFreqHandler() {
        return this.repFreqHandler;
    }

    public void setRepFreqHandler(RepetitionFreqHandler repetitionFreqHandler) {
        this.repFreqHandler = repetitionFreqHandler;
    }
}

