/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import paysim.PaySim;
import sim.engine.SimState;

public class ParameterizedPaySim
extends PaySim {
    public static String simulatorName = "";
    ParameterizedPaySim parameterizedPaysim = null;
    ArrayList<String> paramFile = new ArrayList();
    ArrayList<String> actions = new ArrayList();
    BufferedWriter bufWriter;
    String filePath = "";
    long begin = 0L;
    long end = 0L;
    static long numOfSteps = 1L;
    int numOfRepeat = 0;
    public static int currentLoop = 0;
    double incRepeat = 0.0;

    public ParameterizedPaySim(long l) {
        super(l);
        super.setTagName("1");
    }

    public ParameterizedPaySim() {
        super(1L);
        super.setTagName("1");
    }

    public void setCurrentLoop(int n) {
        currentLoop = n;
    }

    public void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].equals("-file")) {
                this.filePath = stringArray[i + 1];
                super.setPropertiesFile(this.filePath);
                continue;
            }
            if (stringArray[i].equals("-for")) {
                numOfSteps = Long.parseLong(stringArray[i + 1].toString());
                continue;
            }
            if (stringArray[i].equals("-r")) {
                this.numOfRepeat = Integer.parseInt(stringArray[i + 1].toString());
                continue;
            }
            if (!stringArray[i].equals("-inc")) continue;
            this.incRepeat = Double.parseDouble(stringArray[i + 1].toString());
        }
    }

    public void runSimulation(String[] stringArray) {
        this.parseArgs(stringArray);
        this.numOfRepeat = 1;
        this.executeSimulation();
    }

    private void loadAggregatedFile() {
        this.paramFile = new ArrayList();
        try {
            FileReader fileReader = new FileReader(new File(this.parameterFilePath));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.paramFile.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.actions.add("CASH_IN");
        this.actions.add("CASH_OUT");
        this.actions.add("DEBIT");
        this.actions.add("DEPOSIT");
        this.actions.add("PAYMENT");
        this.actions.add("TRANSFER");
    }

    private void initBufWriter(String string) {
        long l = System.currentTimeMillis();
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            this.bufWriter = new BufferedWriter(fileWriter);
            this.bufWriter.write("step,type,amount,nameOrig,oldbalanceOrg,newbalanceOrig,nameDest,oldbalanceDest,newbalanceDest,isFraud,isFlaggedFraud\n");
            this.bufWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initSimulatorName() {
        Date date = new Date();
        simulatorName = "PS_" + (date.getYear() + 1900) + (date.getMonth() + 1) + date.getDate() + date.getHours() + date.getMinutes() + date.getSeconds() + "_" + this.seed;
        File file = new File(System.getProperty("user.dir") + "//outputs//" + simulatorName);
        file.mkdir();
    }

    public void executeSimulation() {
        long l;
        super.loadParametersFromFile();
        this.initSimulatorName();
        this.loadAggregatedFile();
        this.logFileName = System.getProperty("user.dir") + "//outputs//" + simulatorName + "//" + simulatorName + "_log.txt";
        this.initBufWriter(this.logFileName);
        if (this.debugFlag) {
            System.out.println("Size of paramFile:\t" + this.paramFile.size() + "\n");
        }
        this.setParamFileList(this.paramFile);
        this.setActionTypes(this.actions);
        this.setWriter(this.bufWriter);
        this.setNrOfSteps(numOfSteps);
        super.start();
        this.begin = System.currentTimeMillis();
        System.out.println("Starting PaySim Running for " + numOfSteps + " steps. Current loop:" + currentLoop);
        while ((l = this.schedule.getSteps()) < numOfSteps && this.schedule.step((SimState)this)) {
            if (l % 100L == 0L && l != 0L) {
                System.out.println("Time Step " + l);
                continue;
            }
            System.out.print("*");
        }
        System.out.println(" - Finished running " + l + " steps ");
        super.finish();
        this.end = System.currentTimeMillis();
        double d = this.end - this.begin;
        System.out.println("\nIt took:\t" + (d /= 1000.0) / 60.0 + " minutes to execute the simulation\n");
        System.out.println("Simulation name: " + simulatorName);
    }

    @Override
    public void refresh() {
        System.out.println("Refreshing\n");
        super.refresh();
        this.paramFile = new ArrayList();
        this.bufWriter = null;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[5]);
        for (int i = 0; i < n; ++i) {
            ParameterizedPaySim parameterizedPaySim = new ParameterizedPaySim(1L);
            parameterizedPaySim.setCurrentLoop(i);
            parameterizedPaySim.runSimulation(stringArray);
        }
    }
}

