/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import paysim.ActionProbability;
import paysim.AggregateDumpAnalyzer;
import paysim.AggregateParamFileCreator;
import paysim.AggregateTransactionRecord;
import paysim.AggregatedumpHandler;
import paysim.Client;
import paysim.ClientBeta;
import paysim.CurrentStepHandler;
import paysim.DatabaseHandler;
import paysim.Fraudster;
import paysim.InitBalanceHandler;
import paysim.Manager;
import paysim.Merchant;
import paysim.ParameterizedPaySim;
import paysim.ProbabilityContainerHandler;
import paysim.RepetitionFreqContainer;
import paysim.RepetitionFreqHandler;
import paysim.Transaction;
import paysim.TransferMaxHandler;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous2D;

public class PaySim
extends SimState {
    public static final double PAYSIM_VERSION = 1.0;
    private static double multiplier = 1.0;
    public static int numberOfClientsCreated = 0;
    public double width = 100.0;
    public double height = 100.0;
    public Continuous2D land = new Continuous2D(1.0, this.width, this.height);
    double[] probArr = null;
    ArrayList<AggregateTransactionRecord> aggrTransRecordList = new ArrayList();
    AggregateParamFileCreator aggregateCreator = new AggregateParamFileCreator();
    ProbabilityContainerHandler probabilityContainerHandler = new ProbabilityContainerHandler();
    ArrayList<Transaction> trans = new ArrayList();
    ArrayList<Merchant> merchants = new ArrayList();
    ArrayList<Fraudster> fraudsters = new ArrayList();
    ArrayList<Client> clients = new ArrayList();
    ArrayList<ClientBeta> clientsBeta = new ArrayList();
    ArrayList<String> paramFileList = new ArrayList();
    ArrayList<String> actionTypes = new ArrayList();
    ArrayList<ActionProbability> aProbList = new ArrayList();
    BufferedWriter writer;
    String logFileName = "";
    InitBalanceHandler balanceHandler;
    TransferMaxHandler handlerMax;
    CurrentStepHandler stepHandler;
    Manager manager;
    long seed = 0L;
    long nrOfSteps = 0L;
    long startTime = 0L;
    long endTime = 0L;
    double probDoDeposit = 0.0;
    double probDoTransfer = 0.0;
    double probDoWithdraw = 0.0;
    double probDoNothing = 0.0;
    double totalErrorRate = 0.0;
    double totalTransactionsMade = 0.0;
    String propertiesPath = "";
    double probDoFromVoucher = 0.0;
    double probDoToVoucher = 0.0;
    double probDoPayment = 0.0;
    double probDoExpireVoucher = 0.0;
    double fraudProbability = 0.0;
    int nrOfClients = 0;
    int nrOfMerchants = 0;
    int numFraudsters = 0;
    double transferLimit = 100000.0;
    Properties paramters;
    private double day;
    private double hour;
    String parameterFilePath = "";
    String pathOutput = "/outputs/";
    String tagName = "def";
    String logPath = "";
    String aggregateParameterPath = "";
    String transferMaxPath = "";
    String paramFileHistoryPath = "";
    String dbUrl = "";
    String dbUser = "";
    String dbPassword = "";
    String balanceHandlerFilePath = "";
    String networkPath = "";
    String transferFreqMod = "";
    String transferFreqModInit = "";
    boolean debugFlag = false;
    boolean saveToDbFlag = false;
    boolean clientBetaFlag = false;
    boolean networkFlag = false;
    RepetitionFreqHandler repFreqHandler = new RepetitionFreqHandler();

    public static void main(String[] stringArray) {
        PaySim.doLoop(PaySim.class, (String[])stringArray);
        System.exit(0);
    }

    public PaySim(String string) {
        super(1L);
        this.loadParametersFromFile();
        this.initPaySimWithUI();
    }

    public PaySim(long l) {
        super(l);
    }

    public void start() {
        System.out.println(this.welcome());
        this.startTime = System.currentTimeMillis();
        super.start();
        this.initSimulation();
    }

    public void refresh() {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Refreshing\n");
        }
        this.aggrTransRecordList = new ArrayList();
        this.aggregateCreator = new AggregateParamFileCreator();
        this.trans = new ArrayList();
        this.merchants = new ArrayList();
        this.clients = new ArrayList();
        this.paramFileList = new ArrayList();
        this.actionTypes = new ArrayList();
        this.aProbList = new ArrayList();
        this.balanceHandler = null;
        this.handlerMax = null;
        this.stepHandler = null;
        Object var1_2 = null;
        this.seed = 0L;
        this.nrOfSteps = 0L;
        this.startTime = 0L;
        this.endTime = 0L;
        this.probDoDeposit = 0.0;
        this.probDoTransfer = 0.0;
        this.probDoWithdraw = 0.0;
        this.probDoNothing = 0.0;
        this.probDoFromVoucher = 0.0;
        this.probDoToVoucher = 0.0;
        this.probDoPayment = 0.0;
        this.probDoExpireVoucher = 0.0;
        this.nrOfClients = 0;
        this.nrOfMerchants = 0;
        this.day = 0.0;
        this.hour = 0.0;
        this.parameterFilePath = "";
        this.tagName = "def";
        this.logPath = "";
        this.fraudProbability = 0.0;
        this.aggregateParameterPath = "";
        this.transferMaxPath = "";
        this.paramFileHistoryPath = "";
        this.dbUrl = "";
        this.dbUser = "";
        this.dbPassword = "";
        this.balanceHandlerFilePath = "";
    }

    public void finish() {
        this.writeLog();
        this.writeFraudsters();
        this.writeAggregateParamFile();
        this.writeParamfileHistory();
        if (this.networkFlag) {
            this.writeNetworkResults();
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.writeErrorTable();
        this.writeSummaryFile();
        this.appendSimulationSummary();
        this.dumpRepetitionFreq();
        System.out.println("\nNrOfFailed\t" + Manager.nrFailed + "\nNrOfTrueClients:\t" + (double)Manager.trueNrOfClients * this.getMultiplier() + "\nNrOfDaysParticipated\t" + Manager.nrOfDaysParticipated + "\n");
    }

    public Merchant getRandomMerchant() {
        Merchant merchant = this.getMerchants().get(this.random.nextInt(this.getMerchants().size()));
        return merchant;
    }

    public Client getRandomClient() {
        if (this.getClients().size() > 0) {
            Client client = this.getClients().get(this.random.nextInt(this.getClients().size()));
            return client;
        }
        return null;
    }

    private void dumpRepetitionFreq() {
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        String string = this.repFreqHandler.getFrequencyList();
        ArrayList<RepetitionFreqContainer> arrayList = this.repFreqHandler.freqContList;
        ArrayList<String> arrayList2 = this.listOfProbs();
        File file = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_repetitionFrequency.csv");
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("type,high,low,total,freq\n");
            for (int i = 1; i < arrayList2.size(); ++i) {
                String string2 = arrayList2.get(i);
                String[] stringArray = string2.split(",");
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                double d = this.getTotalFromType(stringArray[0], arrayList);
                RepetitionFreqContainer repetitionFreqContainer = this.getCont(stringArray[0], n2, n, arrayList);
                if (repetitionFreqContainer != null) {
                    bufferedWriter.write(stringArray[0] + "," + n + "," + n2 + "," + repetitionFreqContainer.getFreq() + "," + decimalFormat.format((double)repetitionFreqContainer.getFreq() / d) + "\n");
                    continue;
                }
                bufferedWriter.write(stringArray[0] + "," + n + "," + n2 + ",0,0\n");
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList<Fraudster> getFraudsters() {
        return this.fraudsters;
    }

    public void setFraudsters(ArrayList<Fraudster> arrayList) {
        this.fraudsters = arrayList;
    }

    public double getFraudProbability() {
        return this.fraudProbability;
    }

    public void setFraudProbability(double d) {
        this.fraudProbability = d;
    }

    public int getNumFraudsters() {
        return this.numFraudsters;
    }

    public void setNumFraudsters(int n) {
        this.numFraudsters = n;
    }

    private double getTotalFromType(String string, ArrayList<RepetitionFreqContainer> arrayList) {
        double d = 0.0;
        for (RepetitionFreqContainer repetitionFreqContainer : arrayList) {
            if (!repetitionFreqContainer.getCont().getType().equals(string)) continue;
            d += (double)repetitionFreqContainer.getFreq();
        }
        return d;
    }

    private ArrayList<String> listOfProbs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.transferFreqMod);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private RepetitionFreqContainer getCont(String string, int n, int n2, ArrayList<RepetitionFreqContainer> arrayList) {
        for (RepetitionFreqContainer repetitionFreqContainer : arrayList) {
            if (repetitionFreqContainer.getCont().getHigh() != (double)n || repetitionFreqContainer.getCont().getLow() != (double)n2 || !repetitionFreqContainer.getCont().getType().equals(string)) continue;
            return repetitionFreqContainer;
        }
        return null;
    }

    private void appendSimulationSummary() {
        String string = "name,steps,totNrOfTransactions,totNrOfClients,totError\n";
        String string2 = ParameterizedPaySim.simulatorName + "," + ParameterizedPaySim.numOfSteps + "," + this.totalTransactionsMade + "," + this.clients.size() + "," + this.totalErrorRate + "\n";
        File file = new File(System.getProperty("user.dir") + this.pathOutput + "summary.csv");
        if (file.exists() && !file.isDirectory()) {
            Closeable closeable;
            Closeable closeable2;
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            try {
                closeable2 = new FileReader(file);
                closeable = new BufferedReader((Reader)closeable2);
                Object object = "";
                while ((object = ((BufferedReader)closeable).readLine()) != null) {
                    arrayList.add((CallSite)((Object)((String)object + "\n")));
                }
                ((BufferedReader)closeable).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            arrayList.add((CallSite)((Object)string2));
            try {
                closeable2 = new FileWriter(file);
                closeable = new BufferedWriter((Writer)closeable2);
                for (String string3 : arrayList) {
                    ((Writer)closeable).append(string3);
                }
                ((BufferedWriter)closeable).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Closeable closeable;
            Closeable closeable3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                file.createNewFile();
                closeable3 = new FileReader(file);
                closeable = new BufferedReader((Reader)closeable3);
                Object object = "";
                arrayList.add(string);
                while ((object = ((BufferedReader)closeable).readLine()) != null) {
                    arrayList.add((String)object + "\n");
                }
                ((BufferedReader)closeable).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            arrayList.add(string2);
            try {
                closeable3 = new FileWriter(file);
                closeable = new BufferedWriter((Writer)closeable3);
                for (String string4 : arrayList) {
                    ((Writer)closeable).append(string4);
                }
                ((BufferedWriter)closeable).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getStringRepresentationFlags() {
        Object object = "";
        object = this.debugFlag ? (String)object + "debugFlag=1\n" : (String)object + "debugFlag=0\n";
        object = this.saveToDbFlag ? (String)object + "saveToDbFlag=1\n" : (String)object + "saveToDbFlag=0\n";
        object = this.networkFlag ? (String)object + "saveNetwork=1\n" : (String)object + "saveNetwork=0\n";
        object = this.clientBetaFlag ? (String)object + "clientBeta=1\n" : (String)object + "clientBeta=0\n";
        return object;
    }

    private void writeParamfileHistory() {
        this.endTime = System.currentTimeMillis();
        long l = this.endTime - this.startTime;
        try {
            File file = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_ParamHistory.txt");
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String string = "nrOfMerchants=" + this.nrOfMerchants + "\nseed=" + this.seed + "\nmultiplier=" + this.getMultiplier() + "\nparameterFilePath=" + this.parameterFilePath.replace(System.getProperty("user.dir"), "") + "\naggregateParameterFilePath=" + this.aggregateParameterPath.replace(System.getProperty("user.dir"), "") + "\ntransferMaxPath=" + this.transferMaxPath.replace(System.getProperty("user.dir"), "") + "\nlogPath=" + this.logPath.replace(System.getProperty("user.dir"), "") + "\nparamFileHistory=" + this.paramFileHistoryPath.replace(System.getProperty("user.dir"), "") + "\nbalanceHandler=" + this.balanceHandlerFilePath.replace(System.getProperty("user.dir"), "") + "\ntransferFreqMod=" + this.transferFreqMod.replace(System.getProperty("user.dir"), "") + "\nnetworkFolderPath=" + this.networkPath + "\ndbUrl=" + this.dbUrl + "\ndbUser=" + this.dbUser + "\ndbPassword=" + this.dbPassword + "\nfraudProbability=" + this.fraudProbability + "\ntransferLimit=" + this.transferLimit + "\nnumFraudsters=" + this.numFraudsters + "\n" + this.getStringRepresentationFlags() + "TotalPassedTime=" + l + " MS";
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeDatabaseLog() {
        if (this.debugFlag) {
            System.out.println("\nWriting databse logs...\n");
        }
        DatabaseHandler databaseHandler = new DatabaseHandler(this.dbUrl, this.dbUser, this.dbPassword);
        for (Transaction transaction : this.trans) {
            databaseHandler.insert(transaction);
        }
    }

    private void writeErrorTable() {
        String string = System.getProperty("user.dir") + "//paramFiles//AggregateTransaction.csv";
        String string2 = System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_AggregateParamDump.csv";
        if (this.debugFlag) {
            System.out.println("Orig:\t" + string + "\nSynth:\t" + string2 + "\n");
        }
        AggregatedumpHandler aggregatedumpHandler = new AggregatedumpHandler();
        AggregateDumpAnalyzer aggregateDumpAnalyzer = new AggregateDumpAnalyzer(string);
        AggregateDumpAnalyzer aggregateDumpAnalyzer2 = new AggregateDumpAnalyzer(string2);
        aggregateDumpAnalyzer.analyze();
        aggregateDumpAnalyzer2.analyze();
        String string3 = aggregatedumpHandler.checkDelta(aggregateDumpAnalyzer, aggregateDumpAnalyzer2);
        this.totalErrorRate = aggregatedumpHandler.getTotalErrorRate();
        try {
            File file = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_ErrorTable.txt");
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeFraudsters() {
        String string = System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_Fraudsters.csv";
        String string2 = "fname,numVictims,profit";
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string2);
            for (Fraudster fraudster : this.fraudsters) {
                String string3 = fraudster.getName() + "," + fraudster.clientsAffected + "," + fraudster.profit;
                bufferedWriter.write(string3);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getTypeFromNumber(short s) {
        switch (s) {
            case 1: {
                return "CASH_IN";
            }
            case 2: {
                return "CASH_OUT";
            }
            case 3: {
                return "DEBIT";
            }
            case 4: {
                return "DEPOSIT";
            }
            case 5: {
                return "PAYMENT";
            }
            case 6: {
                return "TRANSFER";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog() {
        long l = System.currentTimeMillis();
        try {
            if (this.debugFlag) {
                System.out.println("Size of transactionList: " + this.trans.size() + "\n");
            }
            FileWriter fileWriter = new FileWriter(new File(this.logFileName), true);
            this.writer = new BufferedWriter(fileWriter);
            for (int i = 0; i < this.trans.size(); ++i) {
                Transaction transaction = this.trans.get(i);
                String string = this.getTypeFromNumber(transaction.getType());
                if (string.equals("PAYMENT")) {
                    this.writer.write(transaction.getStep() + "," + this.getTypeFromNumber(transaction.getType()) + "," + this.getDoublePrecision(2, transaction.getAmount()) + "," + transaction.getClientOrigBefore().getName() + "," + this.getDoublePrecision(2, transaction.getClientOrigBefore().getBalance()) + "," + this.getDoublePrecision(2, transaction.getClientOrigAfter().getBalance()) + "," + transaction.getMerchantBefore().getName() + "," + this.getDoublePrecision(2, transaction.getMerchantBefore().getBalance()) + "," + this.getDoublePrecision(2, transaction.getMerchantAfter().getBalance()) + "," + (transaction.isFraud() ? 1 : 0) + "," + (transaction.isFlaggedFraud() ? 1 : 0) + "\n");
                    continue;
                }
                this.writer.write(transaction.getStep() + "," + this.getTypeFromNumber(transaction.getType()) + "," + this.getDoublePrecision(2, transaction.getAmount()) + "," + transaction.getClientOrigBefore().getName() + "," + this.getDoublePrecision(2, transaction.getClientOrigBefore().getBalance()) + "," + this.getDoublePrecision(2, transaction.getClientOrigAfter().getBalance()) + "," + transaction.getClientDestAfter().getName() + "," + this.getDoublePrecision(2, transaction.getClientDestBefore().getBalance()) + "," + this.getDoublePrecision(2, transaction.getClientDestAfter().getBalance()) + "," + (transaction.isFraud() ? 1 : 0) + "," + (transaction.isFlaggedFraud() ? 1 : 0) + "\n");
            }
            if (this.debugFlag) {
                System.out.println("Finished Writing: \n");
            }
            this.writer.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeAggregateParamFile() {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_AggregateParamDump.csv")));
            bufferedWriter.write("type,tmonth,tday,thour,tcount,tsum,tavg,tstd,step\n");
            ArrayList<Object> arrayList = new ArrayList();
            Collections.sort(this.aggrTransRecordList);
            arrayList = this.aggregateCreator.reformat(this.aggrTransRecordList);
            Collections.sort(arrayList);
            double d = 0.0;
            for (AggregateTransactionRecord aggregateTransactionRecord : arrayList) {
                d += Double.parseDouble(aggregateTransactionRecord.gettCount());
            }
            if (this.debugFlag) {
                System.out.println("SIzeOfTransList:\t" + d + "\n");
                System.out.println("TrueNrOfRepetitions:\t" + Manager.trueNrOfRepetitions + "\n");
            }
            for (AggregateTransactionRecord aggregateTransactionRecord : arrayList) {
                bufferedWriter.write(aggregateTransactionRecord.getType() + "," + aggregateTransactionRecord.getMonth() + "," + aggregateTransactionRecord.gettDay() + "," + aggregateTransactionRecord.gettHour() + "," + aggregateTransactionRecord.gettCount() + "," + decimalFormat.format(Double.parseDouble(aggregateTransactionRecord.gettSum())) + "," + decimalFormat.format(Double.parseDouble(aggregateTransactionRecord.gettAvg())) + "," + decimalFormat.format(Double.parseDouble(aggregateTransactionRecord.gettStd())) + "," + this.generateStep(aggregateTransactionRecord) + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int generateStep(AggregateTransactionRecord aggregateTransactionRecord) {
        int n = 0;
        n = (int)((Double.parseDouble(aggregateTransactionRecord.gettDay()) - 1.0) * 24.0 + (Double.parseDouble(aggregateTransactionRecord.gettHour()) + 1.0));
        return n;
    }

    private void reformatAggrList() {
    }

    public void initSimulation() {
        Object object;
        System.out.println("InInit  TagName:\t" + this.tagName + "\nNrOfMerchants:\t" + this.nrOfMerchants + "\nSeed:\t" + this.seed + "\nparameterFilePath\t" + this.parameterFilePath + "\n");
        this.setSeed(this.seed);
        this.balanceHandler = new InitBalanceHandler(this.balanceHandlerFilePath);
        this.handlerMax = new TransferMaxHandler(this.transferMaxPath);
        System.out.println("Inputting this paramfile:\n");
        this.stepHandler = new CurrentStepHandler(this.paramFileList, this.getMultiplier());
        this.balanceHandler.setPaysim(this);
        this.probabilityContainerHandler.initRecordList(this.paramFileList);
        Manager manager = new Manager();
        manager.setBalanceHandler(this.balanceHandler);
        manager.setNrOfStepsTotal(this.nrOfSteps);
        manager.setTransferMaxHandler(this.handlerMax);
        manager.setStepHandler(this.stepHandler);
        manager.setProbabilityHandler(this.probabilityContainerHandler);
        manager.setRepFreqHandler(this.repFreqHandler);
        System.out.println("NrOfMerchants:\t" + (double)this.nrOfMerchants * this.getMultiplier() + "\n");
        int n = 0;
        while ((double)n < (double)this.nrOfMerchants * this.getMultiplier()) {
            object = new Merchant();
            this.merchants.add((Merchant)object);
            ++n;
        }
        System.out.println("NrOfFraudsters:\t" + (double)this.numFraudsters * this.getMultiplier() + "\n");
        n = 0;
        while ((double)n < (double)this.numFraudsters * this.getMultiplier()) {
            object = new Fraudster();
            this.fraudsters.add((Fraudster)object);
            this.schedule.scheduleRepeating((Steppable)object);
            ++n;
        }
        this.schedule.scheduleRepeating((Steppable)manager);
    }

    public void resetVariables() {
        this.trans = new ArrayList();
    }

    private double getDoublePrecision(int n, double d) {
        Double d2 = new Double(d);
        Double d3 = new BigDecimal(d2).setScale(n, 4).doubleValue();
        return d3;
    }

    public String toString() {
        return "ProbDoWithdraw: " + this.probDoWithdraw + "\nProbDoDeposit: " + this.probDoDeposit + "ProbDoNothing: " + this.probDoNothing + "\nProbDoPayment: " + this.probDoPayment + "\nProbDoTransfer: " + this.probDoTransfer + "\nprobDoFromVoucher: " + this.probDoFromVoucher + "\nProbDoToVoucher: " + this.probDoToVoucher + "\nProbDoPayment: " + this.probDoPayment + "\nprobDoExpireVoucher: " + this.probDoExpireVoucher + "\nNrOfClients: " + this.nrOfClients + "\nNrOfMerchants: " + this.nrOfMerchants + "NrOfSteps: " + this.nrOfSteps + "\n";
    }

    public String welcome() {
        return "PAYSIM: Financial Simulator v" + 1.0 + " \n ";
    }

    private ActionProbability getActionProb(String string) {
        String[] stringArray = string.split(",");
        ActionProbability actionProbability = new ActionProbability();
        actionProbability.setType(stringArray[0]);
        actionProbability.setMonth(Double.parseDouble(stringArray[1]));
        actionProbability.setDay(Double.parseDouble(stringArray[2]));
        actionProbability.setHour(Double.parseDouble(stringArray[3]));
        actionProbability.setNrOfTransactions(Double.parseDouble(stringArray[4]));
        actionProbability.setTotalSum(Double.parseDouble(stringArray[5]));
        actionProbability.setAverage(Double.parseDouble(stringArray[6]));
        actionProbability.setStd(Double.parseDouble(stringArray[7]));
        return actionProbability;
    }

    public ArrayList<ActionProbability> getActionProbabilityList(long l) {
        int n = 0;
        ArrayList<ActionProbability> arrayList = new ArrayList<ActionProbability>();
        block0: for (String string : this.actionTypes) {
            for (n = 1; n < this.paramFileList.size(); ++n) {
                String string2 = this.paramFileList.get(n);
                String[] stringArray = string2.split(",");
                double d = Double.parseDouble(stringArray[2]);
                double d2 = Double.parseDouble(stringArray[3]);
                String string3 = stringArray[0];
                String string4 = stringArray[8];
                if (!string4.equals(String.valueOf(l)) || !string3.equals(string)) continue;
                ActionProbability actionProbability = this.getActionProb(string2);
                arrayList.add(actionProbability);
                continue block0;
            }
        }
        return arrayList;
    }

    public void setPropertiesFile(String string) {
        this.propertiesPath = string;
    }

    private void initSeed() {
        String string = String.valueOf(this.paramters.getProperty("seed"));
        this.seed = string.equals("time") ? System.currentTimeMillis() : Long.parseLong(string);
    }

    private void initFlags() {
        this.debugFlag = this.paramters.getProperty("debugFlag").equals("1");
        this.networkFlag = this.paramters.getProperty("saveNetwork").equals("1");
        this.saveToDbFlag = this.paramters.getProperty("saveToDbFlag").equals("1");
        this.clientBetaFlag = this.paramters.getProperty("clientBeta").equals("1");
    }

    public void loadParametersFromFile() {
        try {
            this.paramters = new Properties();
            FileInputStream fileInputStream = new FileInputStream(new File(this.propertiesPath));
            if (fileInputStream != null) {
                this.paramters.load(fileInputStream);
            }
            this.nrOfMerchants = Integer.parseInt(this.paramters.getProperty("nrOfMerchants"));
            this.numFraudsters = Integer.parseInt(this.paramters.getProperty("numFraudsters"));
            this.fraudProbability = Double.parseDouble(this.paramters.getProperty("fraudProbability"));
            this.transferLimit = Double.parseDouble(this.paramters.getProperty("transferLimit"));
            this.parameterFilePath = System.getProperty("user.dir") + this.paramters.getProperty("parameterFilePath");
            this.logPath = this.paramters.getProperty("logPath");
            this.aggregateParameterPath = System.getProperty("user.dir") + this.paramters.getProperty("aggregateParameterFilePath");
            this.setMultiplier(Double.parseDouble(this.paramters.getProperty("multiplier")));
            this.transferMaxPath = System.getProperty("user.dir") + this.paramters.getProperty("transferMaxPath");
            this.paramFileHistoryPath = this.paramters.getProperty("paramFileHistory");
            this.dbUser = this.paramters.getProperty("dbUser");
            this.dbPassword = this.paramters.getProperty("dbPassword");
            this.dbUrl = this.paramters.getProperty("dbUrl");
            this.balanceHandlerFilePath = System.getProperty("user.dir") + this.paramters.getProperty("balanceHandler");
            this.networkPath = this.paramters.getProperty("networkFolderPath");
            this.transferFreqMod = System.getProperty("user.dir") + this.paramters.getProperty("transferFreqMod");
            this.transferFreqModInit = System.getProperty("user.dir") + this.paramters.getProperty("transferFreqModInit");
            this.initSeed();
            this.initFlags();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double[] loadProbabilites(ArrayList<ActionProbability> arrayList, int n) {
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            double d;
            if (this.debugFlag) {
                System.out.println("Dividing:\t" + arrayList.get(i).getNrOfTransactions() * this.getMultiplier() + "\tBy:\t" + (double)n + "\n");
            }
            dArray[i] = d = arrayList.get(i).getNrOfTransactions() * this.getMultiplier() / (double)n;
        }
        return dArray;
    }

    private void parseActionParams(String string) {
        String[] stringArray = string.split(",");
        this.probDoDeposit = Double.parseDouble(stringArray[0]);
        this.probDoWithdraw = Double.parseDouble(stringArray[1]);
        this.probDoTransfer = Double.parseDouble(stringArray[2]);
        this.probDoFromVoucher = Double.parseDouble(stringArray[3]);
        this.probDoToVoucher = Double.parseDouble(stringArray[4]);
        this.probDoPayment = Double.parseDouble(stringArray[5]);
        this.probDoExpireVoucher = Double.parseDouble(stringArray[6]);
        double d = this.probDoDeposit + this.probDoWithdraw + this.probDoTransfer + this.probDoFromVoucher + this.probDoToVoucher + this.probDoPayment + this.probDoExpireVoucher;
        if (this.debugFlag) {
            System.out.println(d + "\n");
        }
        if (d <= 0.9999 || d >= 1.0) {
            if (this.debugFlag) {
                System.out.println("IsNotOne");
            }
            try {
                throw new Exception("Incorrect param insertion - Make sure that the sum of all action params = 1 \n");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void writeNetworkResults() {
        Object object;
        Object object2;
        Serializable serializable;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            serializable = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_log.txt");
            FileReader fileReader = new FileReader((File)serializable);
            object2 = new BufferedReader(fileReader);
            object = "";
            ((BufferedReader)object2).readLine();
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                arrayList.add((String[])object);
            }
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new ArrayList<String>();
        ((ArrayList)serializable).add("type,from,to,amount");
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (String)arrayList.get(i);
            object = ((String)object2).split(",");
            try {
                String string = object[0] + "," + object[1] + "," + object[5] + "," + object[2];
                ((ArrayList)serializable).add(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Writer writer = null;
        try {
            object2 = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_networkdump.txt");
            object = new FileWriter((File)object2);
            writer = new BufferedWriter((Writer)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            try {
                writer.write((String)((ArrayList)serializable).get(i));
                ((BufferedWriter)writer).newLine();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void writeSummaryFile() {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        String string = System.getProperty("user.dir") + "/paramFiles/AggregateTransaction.csv";
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            serializable = new File(string);
            object4 = new FileReader((File)serializable);
            object3 = new BufferedReader((Reader)object4);
            object2 = ((BufferedReader)object3).readLine();
            while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                arrayList.add((String)object2);
            }
            ((BufferedReader)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new ArrayList();
        try {
            object4 = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_AggregateParamDump.csv");
            object3 = new FileReader((File)object4);
            object2 = new BufferedReader((Reader)object3);
            String string2 = ((BufferedReader)object2).readLine();
            while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                ((ArrayList)serializable).add(string2);
            }
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object4 = "                    ";
        object3 = (String)object4 + "Orig" + (String)object4 + "\tSynthetic" + (String)object4 + "\n";
        object3 = (String)object3 + (String)object4 + "Sum" + (String)object4 + "\tSum\n";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DecimalFormat decimalFormat = new DecimalFormat("#.##############");
        arrayList2.add("CASH_IN");
        arrayList2.add("CASH_OUT");
        arrayList2.add("TRANSFER");
        arrayList2.add("PAYMENT");
        arrayList2.add("DEBIT");
        for (n = 0; n < arrayList2.size(); ++n) {
            object = (String)arrayList2.get(n);
            object3 = (String)object3 + (String)object + ((String)object4).substring(((String)object).length(), ((String)object4).length()) + decimalFormat.format(d3 += PaySim.getCumulative((String)object, 5, arrayList)) + ((String)object4).substring(String.valueOf(d3).length(), ((String)object4).length()) + "\t\t" + decimalFormat.format(d4 += PaySim.getCumulative(String.valueOf(n + 1), 5, (ArrayList<String>)serializable)) + "\n";
        }
        object3 = (String)object3 + "-----------------------------------------------------------------------------\n";
        object3 = (String)object3 + (String)object4 + "Count" + (String)object4 + "\tCount" + (String)object4 + "\n";
        for (n = 0; n < arrayList2.size(); ++n) {
            object = (String)arrayList2.get(n);
            this.totalTransactionsMade += (d2 += PaySim.getCumulative(String.valueOf(n + 1), 4, (ArrayList<String>)serializable));
            object3 = (String)object3 + (String)object + ((String)object4).substring(((String)object).length(), ((String)object4).length()) + decimalFormat.format(d += PaySim.getCumulative((String)object, 4, arrayList)) + ((String)object4).substring(String.valueOf(d3).length(), ((String)object4).length()) + "\t\t\t" + decimalFormat.format(d2) + "\n";
        }
        try {
            File file = new File(System.getProperty("user.dir") + this.pathOutput + ParameterizedPaySim.simulatorName + "//" + ParameterizedPaySim.simulatorName + "_Summary.csv");
            object = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
            bufferedWriter.append((CharSequence)object3);
            bufferedWriter.close();
            ((OutputStreamWriter)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println((String)object3);
    }

    public static double getCumulative(String string, int n, ArrayList<String> arrayList) {
        boolean bl = false;
        try {
            int n2 = Integer.parseInt(string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            String[] stringArray = string2.split(",");
            String string3 = stringArray[0];
            if (bl) {
                double d2 = Double.parseDouble(string3);
                int n3 = (int)d2;
                string3 = String.valueOf(n3);
            }
            if (!string3.equals(string)) continue;
            d += Double.parseDouble(stringArray[n]);
        }
        return d;
    }

    private void initPaySimWithUI() {
        Object object;
        try {
            FileReader fileReader = new FileReader(new File(this.parameterFilePath));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            object = "";
            while ((object = bufferedReader.readLine()) != null) {
                this.paramFileList.add((String)object);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.actionTypes.add("CASH_IN");
        this.actionTypes.add("CASH_OUT");
        this.actionTypes.add("DEBIT");
        this.actionTypes.add("DEPOSIT");
        this.actionTypes.add("PAYMENT");
        this.actionTypes.add("TRANSFER");
        long l = System.currentTimeMillis();
        try {
            object = new FileWriter(new File(this.logPath + l + "-PaySimSimulation.txt"));
            this.writer = new BufferedWriter((Writer)object);
            this.writer.write("name,amount,oldbalance,newbalance,numwithdrawals,numdeposits,numtransfers,type\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList<Transaction> getTrans() {
        return this.trans;
    }

    public void setTrans(ArrayList<Transaction> arrayList) {
        this.trans = arrayList;
    }

    public double getProbDoDeposit() {
        return this.probDoDeposit;
    }

    public void setProbDoDeposit(double d) {
        this.probDoDeposit = d;
    }

    public double getProbDoTransfer() {
        return this.probDoTransfer;
    }

    public void setProbDoTransfer(double d) {
        this.probDoTransfer = d;
    }

    public double getProbDoWithdraw() {
        return this.probDoWithdraw;
    }

    public void setProbDoWithdraw(double d) {
        this.probDoWithdraw = d;
    }

    public double getProbDoNothing() {
        return this.probDoNothing;
    }

    public void setProbDoNothing(double d) {
        this.probDoNothing = d;
    }

    public int getNrOfClients() {
        return this.nrOfClients;
    }

    public void setNrOfClients(int n) {
        this.nrOfClients = n;
    }

    public int getNrOfMerchants() {
        return this.nrOfMerchants;
    }

    public void setNrOfMerchants(int n) {
        this.nrOfMerchants = n;
    }

    public long getNrOfSteps() {
        return this.nrOfSteps;
    }

    public void setNrOfSteps(long l) {
        this.nrOfSteps = l;
    }

    public Properties getParamters() {
        return this.paramters;
    }

    public void setParamters(Properties properties) {
        this.paramters = properties;
    }

    public ArrayList<Client> getClients() {
        return this.clients;
    }

    public double getDay() {
        return this.day;
    }

    public void setDay(double d) {
        this.day = d;
    }

    public double getHour() {
        return this.hour;
    }

    public void setHour(double d) {
        this.hour = d;
    }

    public ArrayList<String> getParamFileList() {
        return this.paramFileList;
    }

    public ArrayList<String> getActionTypes() {
        return this.actionTypes;
    }

    public void setActionTypes(ArrayList<String> arrayList) {
        this.actionTypes = arrayList;
    }

    public void setParamFileList(ArrayList<String> arrayList) {
        this.paramFileList = arrayList;
    }

    public ArrayList<ActionProbability> getaProbList() {
        return this.aProbList;
    }

    public void setaProbList(ArrayList<ActionProbability> arrayList) {
        this.aProbList = arrayList;
    }

    public void setClients(ArrayList<Client> arrayList) {
        this.clients = arrayList;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public void setWriter(BufferedWriter bufferedWriter) {
        this.writer = bufferedWriter;
    }

    public ArrayList<Merchant> getMerchants() {
        return this.merchants;
    }

    public void setMerchants(ArrayList<Merchant> arrayList) {
        this.merchants = arrayList;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTransferMaxPath() {
        return this.transferMaxPath;
    }

    public void setTransferMaxPath(String string) {
        this.transferMaxPath = string;
    }

    public ArrayList<AggregateTransactionRecord> getAggrTransRecordList() {
        return this.aggrTransRecordList;
    }

    public void setAggrTransRecordList(ArrayList<AggregateTransactionRecord> arrayList) {
        this.aggrTransRecordList = arrayList;
    }

    public AggregateParamFileCreator getAggregateCreator() {
        return this.aggregateCreator;
    }

    public void setAggregateCreator(AggregateParamFileCreator aggregateParamFileCreator) {
        this.aggregateCreator = aggregateParamFileCreator;
    }

    public void setTagName(String string) {
        this.tagName = string;
    }

    public ArrayList<ClientBeta> getClientsBeta() {
        return this.clientsBeta;
    }

    public void setClientsBeta(ArrayList<ClientBeta> arrayList) {
        this.clientsBeta = arrayList;
    }

    public double getMultiplier() {
        return multiplier;
    }

    public void setMultiplier(double d) {
        multiplier = d;
    }
}

