/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import paysim.RepetitionContainer;
import paysim.RepetitionFreqContainer;

public class RepetitionFreqHandler {
    ArrayList<RepetitionFreqContainer> freqContList = new ArrayList();

    public void add(RepetitionContainer repetitionContainer) {
        if (!this.doesExist(repetitionContainer)) {
            RepetitionFreqContainer repetitionFreqContainer = new RepetitionFreqContainer();
            repetitionFreqContainer.setCont(repetitionContainer);
            repetitionFreqContainer.incrementFrequency();
            this.freqContList.add(repetitionFreqContainer);
        } else {
            for (RepetitionFreqContainer repetitionFreqContainer : this.freqContList) {
                if (!repetitionFreqContainer.getCont().equals(repetitionContainer)) continue;
                repetitionFreqContainer.incrementFrequency();
            }
        }
    }

    private boolean doesExist(RepetitionContainer repetitionContainer) {
        for (int i = 0; i < this.freqContList.size(); ++i) {
            if (!this.freqContList.get(i).getCont().equals(repetitionContainer)) continue;
            return true;
        }
        return false;
    }

    private double getTot() {
        double d = 0.0;
        for (RepetitionFreqContainer repetitionFreqContainer : this.freqContList) {
            d += (double)repetitionFreqContainer.getFreq();
        }
        return d;
    }

    public String getFrequencyList() {
        Object object = "";
        double d = this.getTot();
        DecimalFormat decimalFormat = new DecimalFormat("#.######");
        Collections.sort(this.freqContList);
        for (RepetitionFreqContainer repetitionFreqContainer : this.freqContList) {
            object = (String)object + repetitionFreqContainer.toString() + "," + decimalFormat.format((double)repetitionFreqContainer.getFreq() / d) + "\n";
        }
        return object;
    }
}

