/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Random;
import paysim.PaySim;
import paysim.RepetitionContainer;

public class RepetitionHandler {
    ArrayList<String> fileContents = new ArrayList();
    private Double[] probabilityArr;
    long seed = 11343L;
    Random r;
    private double totNr = 0.0;

    public RepetitionHandler(long l, PaySim paySim) {
        this.init(paySim);
        this.r = new Random(l);
    }

    public int getAction() {
        int n = 0;
        while ((n = this.generateAction()) == -1) {
        }
        return n;
    }

    public RepetitionContainer getRepetition() {
        int n;
        RepetitionContainer repetitionContainer = new RepetitionContainer();
        int n2 = this.getAction();
        String string = this.fileContents.get(n2).split(",")[0];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 6; i < this.fileContents.size(); ++i) {
            if (!this.fileContents.get(i).split(",")[0].equals(string)) continue;
            arrayList.add(this.fileContents.get(i));
        }
        double[] dArray = new double[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dArray[n] = Double.parseDouble(((String)arrayList.get(n)).split(",")[5]);
        }
        n = this.getIndex(dArray);
        String string2 = (String)arrayList.get(n);
        String[] stringArray = string2.split(",");
        repetitionContainer.setLow(Double.parseDouble(stringArray[1]));
        repetitionContainer.setHigh(Double.parseDouble(stringArray[2]));
        repetitionContainer.setAvg(Double.parseDouble(stringArray[3]));
        repetitionContainer.setStd(Double.parseDouble(stringArray[4]));
        repetitionContainer.setType(stringArray[0]);
        return repetitionContainer;
    }

    private int getIndex(double[] dArray) {
        double d = this.r.nextDouble();
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i];
            if (d >= d2 && d <= d2 + d3) {
                return i;
            }
            d2 += d3;
        }
        return -1;
    }

    private int generateAction() {
        double d = this.r.nextDouble();
        double d2 = 0.0;
        for (int i = 0; i < this.probabilityArr.length; ++i) {
            double d3 = this.probabilityArr[i];
            if (d >= d2 && d <= d2 + d3) {
                return i;
            }
            d2 += d3;
        }
        return -1;
    }

    private void init(PaySim paySim) {
        this.readFileContents(paySim);
        this.initProbabilityArr();
    }

    private void initProbabilityArr() {
        this.probabilityArr = new Double[6];
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CASH_IN");
        arrayList.add("CASH_OUT");
        arrayList.add("DEBIT");
        arrayList.add("DEPOSIT");
        arrayList.add("PAYMENT");
        arrayList.add("TRANSFER");
        for (int i = 0; i < 6; ++i) {
            this.probabilityArr[i] = Double.parseDouble(this.fileContents.get(i).split(",")[1]);
        }
    }

    private double getProbability(String string) {
        double d = 0.0;
        double d2 = 0.0;
        for (String string2 : this.fileContents) {
            String[] stringArray = string2.split(",");
            if (!stringArray[0].equals(string)) continue;
            double d3 = Double.parseDouble(stringArray[3]);
            d2 += d3;
        }
        d = d2 / this.totNr;
        return d;
    }

    private void initTotNr() {
        for (String string : this.fileContents) {
            String[] stringArray = string.split(",");
            double d = Double.parseDouble(stringArray[3]);
            this.totNr += d;
        }
        System.out.println("Tot\t" + this.totNr + "\n");
    }

    private void readFileContents(PaySim paySim) {
        Object object;
        Object object2;
        File file = new File(paySim.transferFreqModInit);
        try {
            object2 = new BufferedReader(new FileReader(file));
            object = "";
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                this.fileContents.add((String)object);
            }
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = new File(paySim.transferFreqMod);
        try {
            object = new BufferedReader(new FileReader((File)object2));
            String string = "";
            ((BufferedReader)object).readLine();
            while ((string = ((BufferedReader)object).readLine()) != null) {
                this.fileContents.add(string);
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long l) {
        this.seed = l;
    }
}

