#!/bin/bash

# 检查是否提供了model-path参数
if [ $# -eq 0 ]; then
    echo "使用方法: $0 <model-path>"
    echo "示例: $0 /media/raid/workspace/jiangkailin/LLaVA/merge_llava_null_space"
    exit 1
fi

MODEL_PATH="$1"

# 从model-path中提取最后一个路径组件作为experiment名称
# 提取两个名称
FINAL_EXPERIMENT_NAME="$(basename "$(dirname "$(dirname "$MODEL_PATH")")")_$(basename "$(dirname "$MODEL_PATH")")_$(basename "$MODEL_PATH")"
echo "$FINAL_NAME"

echo "使用模型路径: $MODEL_PATH"
echo "提取的实验名称: $FINAL_EXPERIMENT_NAME"




python -m llava.eval.model_vqa_science \
    --model-path "$MODEL_PATH" \
    --question-file /home/bingxing2/ailab/scx6mh7/jkl/LLaVA_8_8_null_space/capture_know/tichu_sample_data/new_tichu_32_scienceqa.jsonl \
    --image-folder /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/scienceqa/images/test \
    --answers-file "/home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/answers/$FINAL_EXPERIMENT_NAME.jsonl" \
    --single-pred-prompt \
    --temperature 0 \
    --conv-mode vicuna_v1

python llava/eval/eval_science_qa.py \
    --base-dir /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa \
    --result-file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/answers/$FINAL_EXPERIMENT_NAME.jsonl \
    --output-file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/answers/${FINAL_EXPERIMENT_NAME}_output.jsonl \
    --output-result /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/answers/${FINAL_EXPERIMENT_NAME}_result.json


