#!/bin/bash

# Accept parameters from the command line
while getopts "d:n:r:s:" opt; do
  case ${opt} in
    d) DATASET_NAMES=$OPTARG ;;
    n) N_SAMPLES=$OPTARG ;;
    r) RANK=$OPTARG ;;
    s) SEED=$OPTARG ;;
    \?) echo "Usage: cmd [-d dataset_names] [-n n_samples] [-r rank] [-s seed]"; exit 1 ;;
  esac
done

# Set question-file and image-folder based on dataset
if [ "$DATASET_NAMES" = "MME" ]; then
    QUESTION_FILE="/home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/MME/llava_mme.jsonl"
    IMAGE_FOLDER="/home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/MME/MME_Benchmark_release_version/MME_Benchmark"
elif [ "$DATASET_NAMES" = "scienceqa" ]; then
    QUESTION_FILE="/home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/llava_test_CQM-A.json"
    IMAGE_FOLDER="/home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/scienceqa/scienceqa/images/test"
else
    echo "Error: DATASET_NAMES must be either 'MME' or 'SCI'"
    exit 1
fi

CUDA_VISIBLE_DEVICES=0,1,2,3 python /home/bingxing2/ailab/scx6mh7/jkl/LLaVA_8_8_null_space/lora_null/build_adapter_mllm.py \
    --model_id "/home/bingxing2/ailab/scx6mh7/jkl/ckpt_sum/vlm_ckpt/llava-v1.5-7b" \
    --singular_aware \
    --r $RANK \
    --seed $SEED \
    --calib_dataset $DATASET_NAMES \
    --calib_loader_size $N_SAMPLES \
    --question-file $QUESTION_FILE \
    --image-folder $IMAGE_FOLDER \
    --save_sampled_data True \
    --output_file /home/bingxing2/ailab/scx6mh7/jkl/LLaVA_8_8_null_space/capture_know/sample_data/${DATASET_NAMES}/rank${RANK}_sample${N_SAMPLES}.jsonl \
    --temperature 0 \
    --conv-mode llava_v1