




#!/bin/bash

# Accept parameters from the command line
while getopts "d:n:r:s:b:" opt; do
  case ${opt} in
    d) DATASET_NAMES=$OPTARG ;;
    n) N_SAMPLES=$OPTARG ;;
    r) RANK=$OPTARG ;;
    s) SEED=$OPTARG ;;
    b) BENCH=$OPTARG ;;
    \?) echo "Usage: cmd [-d dataset_names] [-n n_samples] [-r rank] [-s seed]"; exit 1 ;;
  esac
done


CUDA_VISIBLE_DEVICES=0,1,2,3 python lora_null/build_adapter_mllm.py \
    --model_id "/home/bingxing2/ailab/scx6mh7/jkl/ckpt_sum/vlm_ckpt/llava-v1.5-7b" \
    --mode full_decompose \
    --seed $SEED \
    --r $RANK \
    --save_model \
    --dataset_names $DATASET_NAMES \
    --n_samples_per_dataset $N_SAMPLES \
    --use_cache \
    --benchmark_cache_file $BENCH \
    --save_path /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/capture_know/${DATASET_NAMES}/plain/${N_SAMPLES}/save_llava_PT_${RANK}_pre_${N_SAMPLES} \
    --temperature 0 \
    --conv-mode llava_v1



