

# 定义变量
DATASET_NAMES="MME"
N_SAMPLES=256
RANK=128
SEED=233

DATASET_NAMES_UNDERSCORE=$(echo $DATASET_NAMES | tr ' ' '_')

CUDA_VISIBLE_DEVICES=0,1,2,3 python lora_null/build_adapter_mllm.py \
    --model_id "/home/bingxing2/ailab/scx6mh7/jkl/ckpt_sum/vlm_ckpt/llava-v1.5-7b" \
    --seed $SEED \
    --singular_aware \
    --r $RANK \
    --save_model \
    --dataset_names $DATASET_NAMES \
    --n_samples_per_dataset $N_SAMPLES \
    --data_root /home/bingxing2/ailab/scx6mh7/jkl/ckpt_sum/data/vlmeval \
    --save_sampled_data True \
    --benchmark_cache_file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/benchmark_covariance_matrix/cache/llava-v1.5-7b_covariance_matrices_from_MME_pre_256_seed_233.pt  \
    --output_file /home/bingxing2/ailab/scx6mh7/jkl/LLaVA_8_8_null_space/benchmark_seed_data/benchmark_original_data_rank${RANK}_${DATASET_NAMES_UNDERSCORE}_pre_${N_SAMPLES}/${RANK}_${DATASET_NAMES_UNDERSCORE}_pre_${N_SAMPLES}.jsonl \
    --save_path /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/lora_null_sample_ckpt/save_LoRA_Null_adapter_llava_PT_${RANK}_${DATASET_NAMES_UNDERSCORE}_pre_${N_SAMPLES} \
    --temperature 0 \
    --conv-mode llava_v1







# CUDA_VISIBLE_DEVICES=2,3 python lora_null/build_adapter_mllm.py \
#     --model_id "/media/raid/workspace/jiangkailin/data_and_ckpt/hugging_cache/llava-v1.5-7b" \
#     --singular_aware \
#     --r 2 \
#     --calib_loader_size 5 \
#     --save_model \
#     --dataset_names MME OCRBench \
#     --n_samples_per_dataset 16 \
#     --data_root /media/raid/workspace/jiangkailin/data_and_ckpt/dataset/cache/vlmeval \
#     --save_path save_LoRA_Null_adapter_llava2_PT_128 \
#     --temperature 0 \
#     --conv-mode llava_v1