# 定义变量
N_SAMPLES=64
RANK=235
SEED=233
DATASET_NAMES="onevision"


DATASET_NAMES_UNDERSCORE=$(echo $DATASET_NAMES | tr ' ' '_')

CUDA_VISIBLE_DEVICES=0,1,2,3 python lora_null/build_adapter_mllm.py \
    --model_id "/hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/vlm_ckpt/llava-v1.5-13b" \
    --seed $SEED \
    --singular_aware \
    --r $RANK \
    --save_model \
    --n_samples_per_dataset $N_SAMPLES \
    --save_sampled_data True \
    --dataset_names $DATASET_NAMES \
    --onevision_image_dir  /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/vlm_ckpt/ov_data \
    --onevision_local_dir /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/vlm_ckpt/LLaVA-OneVision-Data \
    --onevision_sources Geometry3K\(MathV360K\),iiit5k,VizWiz\(MathV360K\),FigureQA\(MathV360K\) \
    --output_file /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/vlm_ckpt/ov_data/benchmark_seed_data/onevision/benchmark_original_data_rank${RANK}_${DATASET_NAMES_UNDERSCORE}_pre_${N_SAMPLES}/${RANK}_${DATASET_NAMES_UNDERSCORE}_pre_${N_SAMPLES}.jsonl \
    --save_path /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/vlm_ckpt/ov_data/lora_null_sample_ckpt/save_LoRA_Null_adapter_llava_13b_PT_${RANK}_ov_pre_${N_SAMPLES} \
    --temperature 0 \
    --conv-mode llava_v1