#!/bin/bash

CUDA_VISIBLE_DEVICES=0,1,2,3 deepspeed llava/train/train_mem_v2.py \
    --lora_null_enable True --lora_null_v1 True --mm_projector_lr 2e-5 \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path /media/raid/workspace/jiangkailin/LLaVA/save_LoRA_Null_adapter_llava_PT_128 \
    --version v1 \
    --data_path /media/raid/workspace/jiangkailin/LLaVA/llava_train.json \
    --image_folder /media/raid/workspace/jiangkailin/LLaVA/evoke_injection_imgs \
    --vision_tower /media/raid/workspace/jiangkailin/data_and_ckpt/hugging_cache/clip-vit-large-patch14-336 \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --bf16 True \
    --output_dir ./checkpoints/llava-v1.5-7b-task-lora \
    --num_train_epochs 1 \
    --per_device_train_batch_size 16 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 50000 \
    --save_total_limit 1 \
    --learning_rate 2e-4 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to none