#!/bin/bash

# Accept parameters from the command line
while getopts "d:n:r:s:" opt; do
  case ${opt} in
    n) N_SAMPLES=$OPTARG ;;
    r) RANK=$OPTARG ;;
    s) SEED=$OPTARG ;;
    \?) echo "Usage: cmd [-d dataset_names] [-n n_samples] [-r rank] [-s seed]"; exit 1 ;;
  esac
done


CUDA_VISIBLE_DEVICES=0,1,2,3 python lora_null/build_adapter_mllm.py \
    --model_id "/home/bingxing2/ailab/scx6mh7/jkl/ckpt_sum/vlm_ckpt/llava-v1.5-7b" \
    --mode full_decompose \
    --seed $SEED \
    --r $RANK \
    --act_aware \
    --save_model \
    --scaling_method abs_mean \
    --dataset_names MME \
    --n_samples_per_dataset $N_SAMPLES \
    --question_file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/infoseek_data/infoseek_filtered_and_updated.jsonl \
    --save_sampled_data  True \
    --use_cache \
    --benchmark_cache_file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/benchmark_covariance_matrix/cache/llava-v1.5-7b_covariance_matrices_from_MME_pre_256_seed_233.pt \
    --save_path /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/infoseek/MME/act_abs_mean/save_llava_PT_${RANK}_infoseek_pre_${N_SAMPLES} \
    --temperature 0 \
    --conv-mode llava_v1



