#!/bin/bash

# Accept parameters from the command line
while getopts "d:n:r:s:" opt; do
  case ${opt} in
    n) N_SAMPLES=$OPTARG ;;
    r) RANK=$OPTARG ;;
    s) SEED=$OPTARG ;;
    \?) echo "Usage: cmd [-d dataset_names] [-n n_samples] [-r rank] [-s seed]"; exit 1 ;;
  esac
done


CUDA_VISIBLE_DEVICES=0,1,2,3 python lora_null/build_adapter_mllm.py \
    --model_id "/home/bingxing2/ailab/scx6mh7/jkl/ckpt_sum/vlm_ckpt/llava-v1.5-7b" \
    --mode full_decompose \
    --seed $SEED \
    --r $RANK \
    --cov_aware_wo_inv \
    --save_model \
    --dataset_names infoseek \
    --n_samples_per_dataset $N_SAMPLES \
    --question_file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/infoseek_data/infoseek_filtered_and_updated.jsonl \
    --save_sampled_data  True \
    --output_file /home/bingxing2/ailab/scx6mh7/jkl/LLaVA_8_8_null_space/infoseek_sample_data/cov_aware_wo_inv/sampled_rank${RANK}_infoseek_${N_SAMPLES}_seed${SEED}_data.jsonl \
    --use_cache \
    --benchmark_cache_file /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/benchmark_covariance_matrix/cache/llava-v1.5-7b_covariance_matrices_from_infoseek_pre_256_seed_233.pt \
    --save_path /home/bingxing2/ailab/group/ai4bio/renyuchen/jkl/infoseek/cov_aware_wo_inv/save_llava_PT_${RANK}_infoseek_pre_${N_SAMPLES} \
    --temperature 0 \
    --conv-mode llava_v1



