#!/bin/bash

# 检查是否提供了model-path参数
if [ $# -eq 0 ]; then
    echo "使用方法: $0 <model-path>"
    echo "示例: $0 /media/raid/workspace/jiangkailin/LLaVA/merge_llava_null_space"
    exit 1
fi

MODEL_PATH="$1"
SPLIT="mmbench_dev_20230712"

# 从model-path中提取最后一个路径组件作为experiment名称
# 提取两个名称
FINAL_EXPERIMENT_NAME="$(basename "$(dirname "$(dirname "$MODEL_PATH")")")_$(basename "$(dirname "$MODEL_PATH")")_$(basename "$MODEL_PATH")"
echo "$FINAL_EXPERIMENT_NAME"

echo "使用模型路径: $MODEL_PATH"
echo "提取的实验名称: $FINAL_EXPERIMENT_NAME"

python -m llava.eval.model_vqa_mmbench \
    --model-path "$MODEL_PATH" \
    --question-file /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/dataset/mmbench/$SPLIT.tsv \
    --answers-file "/hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/dataset/mmbench/answers/$SPLIT/$FINAL_EXPERIMENT_NAME.jsonl" \
    --single-pred-prompt \
    --temperature 0 \
    --conv-mode vicuna_v1

mkdir -p /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/dataset/mmbench/answers_upload/$SPLIT

python /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/LLaVA_8_8_null_space/scripts/convert_mmbench_for_submission.py \
    --annotation-file /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/dataset/mmbench/$SPLIT.tsv \
    --result-dir /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/dataset/mmbench/answers/$SPLIT \
    --upload-dir /hkfs/work/workspace/scratch/lmu_chd4938-MINED_26/MINED_26/data_ckpt/dataset/mmbench/answers_upload/$SPLIT \
    --experiment "$FINAL_EXPERIMENT_NAME"