﻿param (
    [switch]$Help,
    [switch]$DisablePyPIMirror,
    [switch]$DisableGithubMirror,
    [string]$UseCustomGithubMirror,
    [switch]$DisableProxy,
    [string]$UseCustomProxy,
    [switch]$DisableHuggingFaceMirror,
    [string]$UseCustomHuggingFaceMirror
)
# Fooocus Installer 版本和检查更新间隔
$Env:FOOOCUS_INSTALLER_VERSION = 190
$Env:UPDATE_TIME_SPAN = 3600
# PyPI 镜像源
$PIP_INDEX_ADDR = "https://mirrors.cloud.tencent.com/pypi/simple"
$PIP_INDEX_ADDR_ORI = "https://pypi.python.org/simple"
$PIP_EXTRA_INDEX_ADDR = "https://mirrors.cernet.edu.cn/pypi/web/simple"
$PIP_EXTRA_INDEX_ADDR_ORI = ""
$PIP_FIND_ADDR = "https://mirrors.aliyun.com/pytorch-wheels/torch_stable.html"
$PIP_FIND_ADDR_ORI = "https://download.pytorch.org/whl/torch_stable.html"
$USE_PIP_MIRROR = if ((!(Test-Path "$PSScriptRoot/disable_pypi_mirror.txt")) -and (!($DisablePyPIMirror))) { $true } else { $false }
$PIP_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_INDEX_ADDR } else { $PIP_INDEX_ADDR_ORI }
$PIP_EXTRA_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_EXTRA_INDEX_ADDR } else { $PIP_EXTRA_INDEX_ADDR_ORI }
$PIP_FIND_MIRROR = if ($USE_PIP_MIRROR) { $PIP_FIND_ADDR } else { $PIP_FIND_ADDR_ORI }
$PIP_FIND_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121/torch_stable.html"
$PIP_EXTRA_INDEX_MIRROR_PYTORCH = "https://download.pytorch.org/whl"
$PIP_EXTRA_INDEX_MIRROR_XPU = "https://download.pytorch.org/whl/xpu"
$PIP_EXTRA_INDEX_MIRROR_CU118 = "https://download.pytorch.org/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121"
$PIP_EXTRA_INDEX_MIRROR_CU124 = "https://download.pytorch.org/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126 = "https://download.pytorch.org/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128 = "https://download.pytorch.org/whl/cu128"
$PIP_EXTRA_INDEX_MIRROR_CU118_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU124_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu128"
# Github 镜像源
$GITHUB_MIRROR_LIST = @(
    "https://ghfast.top/https://github.com",
    "https://mirror.ghproxy.com/https://github.com",
    "https://ghproxy.net/https://github.com",
    "https://gh.api.99988866.xyz/https://github.com",
    "https://gh-proxy.com/https://github.com",
    "https://ghps.cc/https://github.com",
    "https://gh.idayer.com/https://github.com",
    "https://ghproxy.1888866.xyz/github.com",
    "https://slink.ltd/https://github.com",
    "https://github.boki.moe/github.com",
    "https://github.moeyy.xyz/https://github.com",
    "https://gh-proxy.net/https://github.com",
    "https://gh-proxy.ygxz.in/https://github.com",
    "https://wget.la/https://github.com",
    "https://kkgithub.com",
    "https://gitclone.com/github.com"
)
# uv 最低版本
$UV_MINIMUM_VER = "0.8"
# Aria2 最低版本
$ARIA2_MINIMUM_VER = "1.37.0"
# PATH
$PYTHON_PATH = "$PSScriptRoot/python"
$PYTHON_EXTRA_PATH = "$PSScriptRoot/Fooocus/python"
$PYTHON_SCRIPTS_PATH = "$PSScriptRoot/python/Scripts"
$PYTHON_SCRIPTS_EXTRA_PATH = "$PSScriptRoot/Fooocus/python/Scripts"
$GIT_PATH = "$PSScriptRoot/git/bin"
$GIT_EXTRA_PATH = "$PSScriptRoot/Fooocus/git/bin"
$Env:PATH = "$PYTHON_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_EXTRA_PATH$([System.IO.Path]::PathSeparator)$GIT_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_PATH$([System.IO.Path]::PathSeparator)$GIT_PATH$([System.IO.Path]::PathSeparator)$Env:PATH"
# 环境变量
$Env:PIP_INDEX_URL = "$PIP_INDEX_MIRROR"
$Env:PIP_EXTRA_INDEX_URL = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:PIP_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_DEFAULT_INDEX = "$PIP_INDEX_MIRROR"
$Env:UV_INDEX = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:UV_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_LINK_MODE = "copy"
$Env:UV_HTTP_TIMEOUT = 30
$Env:UV_CONCURRENT_DOWNLOADS = 50
$Env:UV_INDEX_STRATEGY = "unsafe-best-match"
$Env:UV_CONFIG_FILE = "nul"
$Env:PIP_CONFIG_FILE = "nul"
$Env:PIP_DISABLE_PIP_VERSION_CHECK = 1
$Env:PIP_NO_WARN_SCRIPT_LOCATION = 0
$Env:PIP_TIMEOUT = 30
$Env:PIP_RETRIES = 5
$Env:PIP_PREFER_BINARY = 1
$Env:PIP_YES = 1
$Env:PYTHONUTF8 = 1
$Env:PYTHONIOENCODING = "utf-8"
$Env:PYTHONUNBUFFERED = 1
$Env:PYTHONNOUSERSITE = 1
$Env:PYTHONFAULTHANDLER = 1
$Env:GRADIO_ANALYTICS_ENABLED = "False"
$Env:HF_HUB_DISABLE_SYMLINKS_WARNING = 1
$Env:BITSANDBYTES_NOWELCOME = 1
$Env:ClDeviceGlobalMemSizeAvailablePercent = 100
$Env:CUDA_MODULE_LOADING = "LAZY"
$Env:TORCH_CUDNN_V8_API_ENABLED = 1
$Env:USE_LIBUV = 0
$Env:SYCL_CACHE_PERSISTENT = 1
$Env:TF_CPP_MIN_LOG_LEVEL = 3
$Env:SAFETENSORS_FAST_GPU = 1
$Env:CACHE_HOME = "$PSScriptRoot/cache"
$Env:HF_HOME = "$PSScriptRoot/cache/huggingface"
$Env:MATPLOTLIBRC = "$PSScriptRoot/cache"
$Env:MODELSCOPE_CACHE = "$PSScriptRoot/cache/modelscope/hub"
$Env:MS_CACHE_HOME = "$PSScriptRoot/cache/modelscope/hub"
$Env:SYCL_CACHE_DIR = "$PSScriptRoot/cache/libsycl_cache"
$Env:TORCH_HOME = "$PSScriptRoot/cache/torch"
$Env:U2NET_HOME = "$PSScriptRoot/cache/u2net"
$Env:XDG_CACHE_HOME = "$PSScriptRoot/cache"
$Env:PIP_CACHE_DIR = "$PSScriptRoot/cache/pip"
$Env:PYTHONPYCACHEPREFIX = "$PSScriptRoot/cache/pycache"
$Env:TORCHINDUCTOR_CACHE_DIR = "$PSScriptRoot/cache/torchinductor"
$Env:TRITON_CACHE_DIR = "$PSScriptRoot/cache/triton"
$Env:UV_CACHE_DIR = "$PSScriptRoot/cache/uv"
$Env:UV_PYTHON = "$PSScriptRoot/python/python.exe"
$Env:FOOOCUS_INSTALLER_ROOT = $PSScriptRoot



# 帮助信息
function Get-Fooocus-Installer-Cmdlet-Help {
    $content = "
使用:
    .\activate.ps1 [-Help] [-DisablePyPIMirror] [-DisableGithubMirror] [-UseCustomGithubMirror <Github 镜像源地址>] [-DisableProxy] [-UseCustomProxy <代理服务器地址>] [-DisableHuggingFaceMirror] [-UseCustomHuggingFaceMirror <HuggingFace 镜像源地址>]

参数:
    -Help
        获取 Fooocus Installer 的帮助信息

    -DisablePyPIMirror
        禁用 PyPI 镜像源, 使用 PyPI 官方源下载 Python 软件包

    -DisableGithubMirror
        禁用 Fooocus Installer 自动设置 Github 镜像源

    -UseCustomGithubMirror <Github 镜像站地址>
        使用自定义的 Github 镜像站地址
        可用的 Github 镜像站地址:
            https://ghfast.top/https://github.com
            https://mirror.ghproxy.com/https://github.com
            https://ghproxy.net/https://github.com
            https://gh.api.99988866.xyz/https://github.com
            https://gh-proxy.com/https://github.com
            https://ghps.cc/https://github.com
            https://gh.idayer.com/https://github.com
            https://ghproxy.1888866.xyz/github.com
            https://slink.ltd/https://github.com
            https://github.boki.moe/github.com
            https://github.moeyy.xyz/https://github.com
            https://gh-proxy.net/https://github.com
            https://gh-proxy.ygxz.in/https://github.com
            https://wget.la/https://github.com
            https://kkgithub.com
            https://gitclone.com/github.com

    -DisableProxy
        禁用 Fooocus Installer 自动设置代理服务器

    -UseCustomProxy <代理服务器地址>
        使用自定义的代理服务器地址, 例如代理服务器地址为 http://127.0.0.1:10809, 则使用 -UseCustomProxy `"http://127.0.0.1:10809`" 设置代理服务器地址

    -DisableHuggingFaceMirror
        禁用 HuggingFace 镜像源, 不使用 HuggingFace 镜像源下载文件

    -UseCustomHuggingFaceMirror <HuggingFace 镜像源地址>
        使用自定义 HuggingFace 镜像源地址, 例如代理服务器地址为 https://hf-mirror.com, 则使用 -UseCustomHuggingFaceMirror `"https://hf-mirror.com`" 设置 HuggingFace 镜像源地址


更多的帮助信息请阅读 Fooocus Installer 使用文档: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md
".Trim()

    if ($Help) {
        Write-Host $content
        exit 0
    }
}


# 提示符信息
function global:prompt {
    "$(Write-Host "[Fooocus Env]" -ForegroundColor Green -NoNewLine) $(Get-Location)> "
}


# 消息输出
function global:Print-Msg ($msg) {
    Write-Host "[$(Get-Date -Format "yyyy-MM-dd HH:mm:ss")]" -ForegroundColor Yellow -NoNewline
    Write-Host "[Fooocus Installer]" -ForegroundColor Cyan -NoNewline
    Write-Host ":: " -ForegroundColor Blue -NoNewline
    Write-Host "$msg"
}


# 更新 uv
function global:Update-uv {
    Print-Msg "更新 uv 中"
    python -m pip install uv --upgrade
    if ($?) {
        Print-Msg "更新 uv 成功"
    } else {
        Print-Msg "更新 uv 失败, 可尝试重新运行更新命令"
    }
}


# 更新 Aria2
function global:Update-Aria2 {
    $urls = @(
        "https://modelscope.cn/models/licyks/invokeai-core-model/resolve/master/pypatchmatch/aria2c.exe",
        "https://huggingface.co/licyk/invokeai-core-model/resolve/main/pypatchmatch/aria2c.exe"
    )
    $aria2_tmp_path = "$Env:CACHE_HOME/aria2c.exe"
    $i = 0
    Print-Msg "下载 Aria2 中"
    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null
    ForEach ($url in $urls) {
        Print-Msg "下载 Aria2 中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$aria2_tmp_path"
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试下载 Aria2 中"
            } else {
                Print-Msg "下载 Aria2 失败, 无法进行更新, 可尝试重新运行更新命令"
                return
            }
        }
    }

    Move-Item -Path "$Env:CACHE_HOME/aria2c.exe" -Destination "$Env:FOOOCUS_INSTALLER_ROOT/git/bin/aria2c.exe" -Force
    Print-Msg "更新 Aria2 完成"
}


# Fooocus Installer 更新检测
function global:Check-Fooocus-Installer-Update {
    # 可用的下载源
    $urls = @(
        "https://github.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://github.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitlab.com/licyk/sd-webui-all-in-one/-/raw/main/fooocus_installer.ps1"
    )
    $i = 0

    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null
    Set-Content -Encoding UTF8 -Path "$Env:FOOOCUS_INSTALLER_ROOT/update_time.txt" -Value $(Get-Date -Format "yyyy-MM-dd HH:mm:ss") # 记录更新时间

    ForEach ($url in $urls) {
        Print-Msg "检查 Fooocus Installer 更新中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$Env:CACHE_HOME/fooocus_installer.ps1"
            $latest_version = [int]$(
                Get-Content "$Env:CACHE_HOME/fooocus_installer.ps1" |
                Select-String -Pattern "FOOOCUS_INSTALLER_VERSION" |
                ForEach-Object { $_.ToString() }
            )[0].Split("=")[1].Trim()
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试检查 Fooocus Installer 更新中"
            } else {
                Print-Msg "检查 Fooocus Installer 更新失败"
                return
            }
        }
    }

    if ($latest_version -gt $Env:FOOOCUS_INSTALLER_VERSION) {
        Print-Msg "Fooocus Installer 有新版本可用"
        Print-Msg "调用 Fooocus Installer 进行更新中"
        . "$Env:CACHE_HOME/fooocus_installer.ps1" -InstallPath "$Env:FOOOCUS_INSTALLER_ROOT" -UseUpdateMode
        Print-Msg "更新结束, 需重新启动 Fooocus Installer 管理脚本以应用更新, 回车退出 Fooocus Installer 管理脚本"
        Read-Host | Out-Null
        exit 0
    } else {
        Print-Msg "Fooocus Installer 已是最新版本"
    }
}


# 安装绘世启动器
function global:Install-Hanamizuki {
    $urls = @(
        "https://modelscope.cn/models/licyks/invokeai-core-model/resolve/master/pypatchmatch/hanamizuki.exe",
        "https://github.com/licyk/term-sd/releases/download/archive/hanamizuki.exe",
        "https://gitee.com/licyk/term-sd/releases/download/archive/hanamizuki.exe"
    )
    $i = 0

    if (!(Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus")) {
        Print-Msg "在 $Env:FOOOCUS_INSTALLER_ROOT 路径中未找到 Fooocus 文件夹, 无法安装绘世启动器, 请检查 Fooocus 是否已正确安装, 或者尝试运行 Fooocus Installer 进行修复"
        return
    }

    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null

    if (Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/hanamizuki.exe") {
        Print-Msg "绘世启动器已安装, 路径: $([System.IO.Path]::GetFullPath("$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/hanamizuki.exe"))"
        Print-Msg "可以进入该路径启动绘世启动器, 也可运行 hanamizuki.bat 启动绘世启动器"
    } else {
        ForEach ($url in $urls) {
            Print-Msg "下载绘世启动器中"
            try {
                Invoke-WebRequest -Uri $url -OutFile "$Env:CACHE_HOME/hanamizuki_tmp.exe"
                Move-Item -Path "$Env:CACHE_HOME/hanamizuki_tmp.exe" "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/hanamizuki.exe" -Force
                Print-Msg "绘世启动器安装成功, 路径: $([System.IO.Path]::GetFullPath("$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/hanamizuki.exe"))"
                Print-Msg "可以进入该路径启动绘世启动器, 也可运行 hanamizuki.bat 启动绘世启动器"
                break
            }
            catch {
                $i += 1
                if ($i -lt $urls.Length) {
                    Print-Msg "重试下载绘世启动器中"
                } else {
                    Print-Msg "下载绘世启动器失败"
                    return
                }
            }
        }
    }

    $content = "
@echo off
if exist `"%~dp0`"\Fooocus (
    cd /d `"%~dp0`"\Fooocus
) else (
    echo Fooocus not found
    pause
    exit 1
)
if exist .\hanamizuki.exe (
    start /B .\hanamizuki.exe
) else (
    echo Hanamizuki not found
    pause
    exit 1
)
    ".Trim()

    Set-Content -Encoding Default -Path "$Env:FOOOCUS_INSTALLER_ROOT/hanamizuki.bat" -Value $content

    Print-Msg "检查绘世启动器运行环境"
    if (!(Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/python/python.exe")) {
        if (Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/python") {
            Print-Msg "尝试将 Python 移动至 $Env:FOOOCUS_INSTALLER_ROOT\Fooocus 中"
            Move-Item -Path "$Env:FOOOCUS_INSTALLER_ROOT/python" "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus" -Force
            if ($?) {
                Print-Msg "Python 路径移动成功"
            } else {
                Print-Msg "Python 路径移动失败, 这将导致绘世启动器无法正确识别到 Python 环境"
                Print-Msg "请关闭所有占用 Python 的进程, 并重新运行该命令"
            }
        } else {
            Print-Msg "环境缺少 Python, 无法为绘世启动器准备 Python 环境, 请重新运行 Fooocus Installer 修复环境"
        }
    }

    if (!(Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/git/bin/git.exe")) {
        if (Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/git") {
            Print-Msg "尝试将 Git 移动至 $Env:FOOOCUS_INSTALLER_ROOT\Fooocus 中"
            Move-Item -Path "$Env:FOOOCUS_INSTALLER_ROOT/git" "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus" -Force
            if ($?) {
                Print-Msg "Git 路径移动成功"
            } else {
                Print-Msg "Git 路径移动失败, 这将导致绘世启动器无法正确识别到 Git 环境"
                Print-Msg "请关闭所有占用 Git 的进程, 并重新运行该命令"
            }
        } else {
            Print-Msg "环境缺少 Git, 无法为绘世启动器准备 Git 环境, 请重新运行 Fooocus Installer 修复环境"
        }
    }

    Print-Msg "检查绘世启动器运行环境结束"
}


# 设置 Python 命令别名
function global:pip {
    python -m pip @args
}

Set-Alias pip3 pip
Set-Alias pip3.11 pip
Set-Alias python3 python
Set-Alias python3.11 python


# 列出 Fooocus Installer 内置命令
function global:List-CMD {
    Write-Host "
==================================
Fooocus Installer created by licyk
哔哩哔哩：https://space.bilibili.com/46497516
Github：https://github.com/licyk
==================================

当前可用的 Fooocus Installer 内置命令：

    Update-uv
    Update-Aria2
    Check-Fooocus-Installer-Update
    Install-Hanamizuki
    List-CMD

更多帮助信息可在 Fooocus Installer 文档中查看: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md
"
}


# 显示 Fooocus Installer 版本
function Get-Fooocus-Installer-Version {
    $ver = $([string]$Env:FOOOCUS_INSTALLER_VERSION).ToCharArray()
    $major = ($ver[0..($ver.Length - 3)])
    $minor = $ver[-2]
    $micro = $ver[-1]
    Print-Msg "Fooocus Installer 版本: v${major}.${minor}.${micro}"
}


# PyPI 镜像源状态
function PyPI-Mirror-Status {
    if ($USE_PIP_MIRROR) {
        Print-Msg "使用 PyPI 镜像源"
    } else {
        Print-Msg "检测到 disable_pypi_mirror.txt 配置文件 / -DisablePyPIMirror 命令行参数, 已将 PyPI 源切换至官方源"
    }
}


# 代理配置
function Set-Proxy {
    $Env:NO_PROXY = "localhost,127.0.0.1,::1"
    # 检测是否禁用自动设置镜像源
    if ((Test-Path "$PSScriptRoot/disable_proxy.txt") -or ($DisableProxy)) {
        Print-Msg "检测到本地存在 disable_proxy.txt 代理配置文件 / -DisableProxy 命令行参数, 禁用自动设置代理"
        return
    }

    $internet_setting = Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings"
    if ((Test-Path "$PSScriptRoot/proxy.txt") -or ($UseCustomProxy)) { # 本地存在代理配置
        if ($UseCustomProxy) {
            $proxy_value = $UseCustomProxy
        } else {
            $proxy_value = Get-Content "$PSScriptRoot/proxy.txt"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到本地存在 proxy.txt 代理配置文件 / -UseCustomProxy 命令行参数, 已读取代理配置文件并设置代理"
    } elseif ($internet_setting.ProxyEnable -eq 1) { # 系统已设置代理
        $proxy_addr = $($internet_setting.ProxyServer)
        # 提取代理地址
        if (($proxy_addr -match "http=(.*?);") -or ($proxy_addr -match "https=(.*?);")) {
            $proxy_value = $matches[1]
            # 去除 http / https 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "http://${proxy_value}"
        } elseif ($proxy_addr -match "socks=(.*)") {
            $proxy_value = $matches[1]
            # 去除 socks 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "socks://${proxy_value}"
        } else {
            $proxy_value = "http://${proxy_addr}"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到系统设置了代理, 已读取系统中的代理配置并设置代理"
    }
}


# HuggingFace 镜像源
function Set-HuggingFace-Mirror {
    if ((Test-Path "$PSScriptRoot/disable_hf_mirror.txt") -or ($DisableHuggingFaceMirror)) { # 检测是否禁用了自动设置 HuggingFace 镜像源
        Print-Msg "检测到本地存在 disable_hf_mirror.txt 镜像源配置文件 / -DisableHuggingFaceMirror 命令行参数, 禁用自动设置 HuggingFace 镜像源"
        return
    }

    if ((Test-Path "$PSScriptRoot/hf_mirror.txt") -or ($UseCustomHuggingFaceMirror)) { # 本地存在 HuggingFace 镜像源配置
        if ($UseCustomHuggingFaceMirror) {
            $hf_mirror_value = $UseCustomHuggingFaceMirror
        } else {
            $hf_mirror_value = Get-Content "$PSScriptRoot/hf_mirror.txt"
        }
        $Env:HF_ENDPOINT = $hf_mirror_value
        Print-Msg "检测到本地存在 hf_mirror.txt 配置文件 / -UseCustomHuggingFaceMirror 命令行参数, 已读取该配置并设置 HuggingFace 镜像源"
    } else { # 使用默认设置
        $Env:HF_ENDPOINT = "https://hf-mirror.com"
        Print-Msg "使用默认 HuggingFace 镜像源"
    }
}


# Github 镜像源
function Set-Github-Mirror {
    $Env:GIT_CONFIG_GLOBAL = "$PSScriptRoot/.gitconfig" # 设置 Git 配置文件路径
    if (Test-Path "$PSScriptRoot/.gitconfig") {
        Remove-Item -Path "$PSScriptRoot/.gitconfig" -Force -Recurse
    }

    # 默认 Git 配置
    git config --global --add safe.directory "*"
    git config --global core.longpaths true

    if ((Test-Path "$PSScriptRoot/disable_gh_mirror.txt") -or ($DisableGithubMirror)) { # 禁用 Github 镜像源
        Print-Msg "检测到本地存在 disable_gh_mirror.txt Github 镜像源配置文件 / -DisableGithubMirror 命令行参数, 禁用 Github 镜像源"
        return
    }

    # 使用自定义 Github 镜像源
    if ((Test-Path "$PSScriptRoot/gh_mirror.txt") -or ($UseCustomGithubMirror)) {
        if ($UseCustomGithubMirror) {
            $github_mirror = $UseCustomGithubMirror
        } else {
            $github_mirror = Get-Content "$PSScriptRoot/gh_mirror.txt"
        }
        git config --global url."$github_mirror".insteadOf "https://github.com"
        Print-Msg "检测到本地存在 gh_mirror.txt Github 镜像源配置文件 / -UseCustomGithubMirror 命令行参数, 已读取 Github 镜像源配置文件并设置 Github 镜像源"
    }
}


function Main {
    Print-Msg "初始化中"
    Get-Fooocus-Installer-Version
    Get-Fooocus-Installer-Cmdlet-Help
    Set-Proxy
    Set-HuggingFace-Mirror
    Set-Github-Mirror
    PyPI-Mirror-Status
    # 切换 uv 指定的 Python
    if (Test-Path "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/python/python.exe") {
        $Env:UV_PYTHON = "$Env:FOOOCUS_INSTALLER_ROOT/Fooocus/python/python.exe"
    }
    Print-Msg "激活 Fooocus Env"
    Print-Msg "更多帮助信息可在 Fooocus Installer 项目地址查看: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md"
}

###################

Main
