﻿param (
    [switch]$Help,
    [switch]$BuildMode,
    [string]$BuildWitchModel,
    [switch]$DisablePyPIMirror,
    [switch]$DisableProxy,
    [string]$UseCustomProxy,
    [switch]$DisableUpdate,
    [switch]$DisableAutoApplyUpdate
)
# Fooocus Installer 版本和检查更新间隔
$FOOOCUS_INSTALLER_VERSION = 190
$UPDATE_TIME_SPAN = 3600
# PyPI 镜像源
$PIP_INDEX_ADDR = "https://mirrors.cloud.tencent.com/pypi/simple"
$PIP_INDEX_ADDR_ORI = "https://pypi.python.org/simple"
$PIP_EXTRA_INDEX_ADDR = "https://mirrors.cernet.edu.cn/pypi/web/simple"
$PIP_EXTRA_INDEX_ADDR_ORI = ""
$PIP_FIND_ADDR = "https://mirrors.aliyun.com/pytorch-wheels/torch_stable.html"
$PIP_FIND_ADDR_ORI = "https://download.pytorch.org/whl/torch_stable.html"
$USE_PIP_MIRROR = if ((!(Test-Path "$PSScriptRoot/disable_pypi_mirror.txt")) -and (!($DisablePyPIMirror))) { $true } else { $false }
$PIP_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_INDEX_ADDR } else { $PIP_INDEX_ADDR_ORI }
$PIP_EXTRA_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_EXTRA_INDEX_ADDR } else { $PIP_EXTRA_INDEX_ADDR_ORI }
$PIP_FIND_MIRROR = if ($USE_PIP_MIRROR) { $PIP_FIND_ADDR } else { $PIP_FIND_ADDR_ORI }
$PIP_FIND_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121/torch_stable.html"
$PIP_EXTRA_INDEX_MIRROR_PYTORCH = "https://download.pytorch.org/whl"
$PIP_EXTRA_INDEX_MIRROR_XPU = "https://download.pytorch.org/whl/xpu"
$PIP_EXTRA_INDEX_MIRROR_CU118 = "https://download.pytorch.org/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121"
$PIP_EXTRA_INDEX_MIRROR_CU124 = "https://download.pytorch.org/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126 = "https://download.pytorch.org/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128 = "https://download.pytorch.org/whl/cu128"
$PIP_EXTRA_INDEX_MIRROR_CU118_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU124_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu128"
# uv 最低版本
$UV_MINIMUM_VER = "0.8"
# Aria2 最低版本
$ARIA2_MINIMUM_VER = "1.37.0"
# PATH
$PYTHON_PATH = "$PSScriptRoot/python"
$PYTHON_EXTRA_PATH = "$PSScriptRoot/Fooocus/python"
$PYTHON_SCRIPTS_PATH = "$PSScriptRoot/python/Scripts"
$PYTHON_SCRIPTS_EXTRA_PATH = "$PSScriptRoot/Fooocus/python/Scripts"
$GIT_PATH = "$PSScriptRoot/git/bin"
$GIT_EXTRA_PATH = "$PSScriptRoot/Fooocus/git/bin"
$Env:PATH = "$PYTHON_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_EXTRA_PATH$([System.IO.Path]::PathSeparator)$GIT_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_PATH$([System.IO.Path]::PathSeparator)$GIT_PATH$([System.IO.Path]::PathSeparator)$Env:PATH"
# 环境变量
$Env:PIP_INDEX_URL = "$PIP_INDEX_MIRROR"
$Env:PIP_EXTRA_INDEX_URL = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:PIP_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_DEFAULT_INDEX = "$PIP_INDEX_MIRROR"
$Env:UV_INDEX = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:UV_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_LINK_MODE = "copy"
$Env:UV_HTTP_TIMEOUT = 30
$Env:UV_CONCURRENT_DOWNLOADS = 50
$Env:UV_INDEX_STRATEGY = "unsafe-best-match"
$Env:UV_CONFIG_FILE = "nul"
$Env:PIP_CONFIG_FILE = "nul"
$Env:PIP_DISABLE_PIP_VERSION_CHECK = 1
$Env:PIP_NO_WARN_SCRIPT_LOCATION = 0
$Env:PIP_TIMEOUT = 30
$Env:PIP_RETRIES = 5
$Env:PIP_PREFER_BINARY = 1
$Env:PIP_YES = 1
$Env:PYTHONUTF8 = 1
$Env:PYTHONIOENCODING = "utf-8"
$Env:PYTHONUNBUFFERED = 1
$Env:PYTHONNOUSERSITE = 1
$Env:PYTHONFAULTHANDLER = 1
$Env:GRADIO_ANALYTICS_ENABLED = "False"
$Env:HF_HUB_DISABLE_SYMLINKS_WARNING = 1
$Env:BITSANDBYTES_NOWELCOME = 1
$Env:ClDeviceGlobalMemSizeAvailablePercent = 100
$Env:CUDA_MODULE_LOADING = "LAZY"
$Env:TORCH_CUDNN_V8_API_ENABLED = 1
$Env:USE_LIBUV = 0
$Env:SYCL_CACHE_PERSISTENT = 1
$Env:TF_CPP_MIN_LOG_LEVEL = 3
$Env:SAFETENSORS_FAST_GPU = 1
$Env:CACHE_HOME = "$PSScriptRoot/cache"
$Env:HF_HOME = "$PSScriptRoot/cache/huggingface"
$Env:MATPLOTLIBRC = "$PSScriptRoot/cache"
$Env:MODELSCOPE_CACHE = "$PSScriptRoot/cache/modelscope/hub"
$Env:MS_CACHE_HOME = "$PSScriptRoot/cache/modelscope/hub"
$Env:SYCL_CACHE_DIR = "$PSScriptRoot/cache/libsycl_cache"
$Env:TORCH_HOME = "$PSScriptRoot/cache/torch"
$Env:U2NET_HOME = "$PSScriptRoot/cache/u2net"
$Env:XDG_CACHE_HOME = "$PSScriptRoot/cache"
$Env:PIP_CACHE_DIR = "$PSScriptRoot/cache/pip"
$Env:PYTHONPYCACHEPREFIX = "$PSScriptRoot/cache/pycache"
$Env:TORCHINDUCTOR_CACHE_DIR = "$PSScriptRoot/cache/torchinductor"
$Env:TRITON_CACHE_DIR = "$PSScriptRoot/cache/triton"
$Env:UV_CACHE_DIR = "$PSScriptRoot/cache/uv"
$Env:UV_PYTHON = "$PSScriptRoot/python/python.exe"



# 帮助信息
function Get-Fooocus-Installer-Cmdlet-Help {
    $content = "
使用:
    .\download_models.ps1 [-Help] [-BuildMode] [-BuildWitchModel <模型编号列表>] [-DisablePyPIMirror] [-DisableProxy] [-UseCustomProxy <代理服务器地址>] [-DisableUpdate] [-DisableAutoApplyUpdate]

参数:
    -Help
        获取 Fooocus Installer 的帮助信息

    -BuildMode
        启用 Fooocus Installer 构建模式

    -BuildWitchModel <模型编号列表>
        (需添加 -BuildMode 启用 Fooocus Installer 构建模式) Fooocus Installer 执行完基础安装流程后调用 Fooocus Installer 的 download_models.ps1 脚本, 根据模型编号列表下载指定的模型
        模型编号可运行 download_models.ps1 脚本进行查看

    -DisablePyPIMirror
        禁用 PyPI 镜像源, 使用 PyPI 官方源下载 Python 软件包

    -DisableProxy
        禁用 Fooocus Installer 自动设置代理服务器

    -UseCustomProxy <代理服务器地址>
        使用自定义的代理服务器地址, 例如代理服务器地址为 http://127.0.0.1:10809, 则使用 -UseCustomProxy `"http://127.0.0.1:10809`" 设置代理服务器地址

    -DisableUpdate
        禁用 Fooocus Installer 更新检查

    -DisableAutoApplyUpdate
        禁用 Fooocus Installer 自动应用新版本更新


更多的帮助信息请阅读 Fooocus Installer 使用文档: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md
".Trim()

    if ($Help) {
        Write-Host $content
        exit 0
    }
}


# 消息输出
function Print-Msg ($msg) {
    Write-Host "[$(Get-Date -Format "yyyy-MM-dd HH:mm:ss")]" -ForegroundColor Yellow -NoNewline
    Write-Host "[Fooocus Installer]" -ForegroundColor Cyan -NoNewline
    Write-Host ":: " -ForegroundColor Blue -NoNewline
    Write-Host "$msg"
}


# 显示 Fooocus Installer 版本
function Get-Fooocus-Installer-Version {
    $ver = $([string]$FOOOCUS_INSTALLER_VERSION).ToCharArray()
    $major = ($ver[0..($ver.Length - 3)])
    $minor = $ver[-2]
    $micro = $ver[-1]
    Print-Msg "Fooocus Installer 版本: v${major}.${minor}.${micro}"
}


# 代理配置
function Set-Proxy {
    $Env:NO_PROXY = "localhost,127.0.0.1,::1"
    # 检测是否禁用自动设置镜像源
    if ((Test-Path "$PSScriptRoot/disable_proxy.txt") -or ($DisableProxy)) {
        Print-Msg "检测到本地存在 disable_proxy.txt 代理配置文件 / -DisableProxy 命令行参数, 禁用自动设置代理"
        return
    }

    $internet_setting = Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings"
    if ((Test-Path "$PSScriptRoot/proxy.txt") -or ($UseCustomProxy)) { # 本地存在代理配置
        if ($UseCustomProxy) {
            $proxy_value = $UseCustomProxy
        } else {
            $proxy_value = Get-Content "$PSScriptRoot/proxy.txt"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到本地存在 proxy.txt 代理配置文件 / -UseCustomProxy 命令行参数, 已读取代理配置文件并设置代理"
    } elseif ($internet_setting.ProxyEnable -eq 1) { # 系统已设置代理
        $proxy_addr = $($internet_setting.ProxyServer)
        # 提取代理地址
        if (($proxy_addr -match "http=(.*?);") -or ($proxy_addr -match "https=(.*?);")) {
            $proxy_value = $matches[1]
            # 去除 http / https 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "http://${proxy_value}"
        } elseif ($proxy_addr -match "socks=(.*)") {
            $proxy_value = $matches[1]
            # 去除 socks 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "socks://${proxy_value}"
        } else {
            $proxy_value = "http://${proxy_addr}"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到系统设置了代理, 已读取系统中的代理配置并设置代理"
    }
}


# Fooocus Installer 更新检测
function Check-Fooocus-Installer-Update {
    # 可用的下载源
    $urls = @(
        "https://github.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://github.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitlab.com/licyk/sd-webui-all-in-one/-/raw/main/fooocus_installer.ps1"
    )
    $i = 0

    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null

    if ((Test-Path "$PSScriptRoot/disable_update.txt") -or ($DisableUpdate)) {
        Print-Msg "检测到 disable_update.txt 更新配置文件 / -DisableUpdate 命令行参数, 已禁用 Fooocus Installer 的自动检查更新功能"
        return
    }

    # 获取更新时间间隔
    try {
        $last_update_time = Get-Content "$PSScriptRoot/update_time.txt" 2> $null
        $last_update_time = Get-Date $last_update_time -Format "yyyy-MM-dd HH:mm:ss"
    }
    catch {
        $last_update_time = Get-Date 0 -Format "yyyy-MM-dd HH:mm:ss"
    }
    finally {
        $update_time = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
        $time_span = New-TimeSpan -Start $last_update_time -End $update_time
    }

    if ($time_span.TotalSeconds -gt $UPDATE_TIME_SPAN) {
        Set-Content -Encoding UTF8 -Path "$PSScriptRoot/update_time.txt" -Value $(Get-Date -Format "yyyy-MM-dd HH:mm:ss") # 记录更新时间
    } else {
        return
    }

    ForEach ($url in $urls) {
        Print-Msg "检查 Fooocus Installer 更新中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$Env:CACHE_HOME/fooocus_installer.ps1"
            $latest_version = [int]$(
                Get-Content "$Env:CACHE_HOME/fooocus_installer.ps1" |
                Select-String -Pattern "FOOOCUS_INSTALLER_VERSION" |
                ForEach-Object { $_.ToString() }
            )[0].Split("=")[1].Trim()
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试检查 Fooocus Installer 更新中"
            } else {
                Print-Msg "检查 Fooocus Installer 更新失败"
                return
            }
        }
    }

    if ($latest_version -le $FOOOCUS_INSTALLER_VERSION) {
        Print-Msg "Fooocus Installer 已是最新版本"
        return
    }

    if (($DisableAutoApplyUpdate) -or (Test-Path "$PSScriptRoot/disable_auto_apply_update.txt")) {
        Print-Msg "检测到 Fooocus Installer 有新版本可用, 是否进行更新 (yes/no) ?"
        Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
        $arg = (Read-Host "========================================>").Trim()
        if (!($arg -eq "yes" -or $arg -eq "y" -or $arg -eq "YES" -or $arg -eq "Y")) {
            Print-Msg "跳过 Fooocus Installer 更新"
            return
        }
    } else {
        Print-Msg "检测到 Fooocus Installer 有新版本可用"
    }

    Print-Msg "调用 Fooocus Installer 进行更新中"
    . "$Env:CACHE_HOME/fooocus_installer.ps1" -InstallPath "$PSScriptRoot" -UseUpdateMode
    $raw_params = $script:MyInvocation.Line -replace "^.*\.ps1[\s]*", ""
    Print-Msg "更新结束, 重新启动 Fooocus Installer 管理脚本中, 使用的命令行参数: $raw_params"
    Invoke-Expression "& `"$PSCommandPath`" $raw_params"
    exit 0
}


# 检查 Aria2 版本并更新
function Check-Aria2-Version {
    $content = "
import re
import subprocess



def get_aria2_ver() -> str:
    try:
        aria2_output = subprocess.check_output(['aria2c', '--version'], text=True).splitlines()
    except:
        return None

    for text in aria2_output:
        version_match = re.search(r'aria2 version (\d+\.\d+\.\d+)', text)
        if version_match:
            return version_match.group(1)

    return None


def compare_versions(version1, version2) -> int:
    try:
        nums1 = re.sub(r'[a-zA-Z]+', '', version1).replace('-', '.').replace('+', '.').split('.')
        nums2 = re.sub(r'[a-zA-Z]+', '', version2).replace('-', '.').replace('+', '.').split('.')
    except:
        return 0

    for i in range(max(len(nums1), len(nums2))):
        num1 = int(nums1[i]) if i < len(nums1) else 0
        num2 = int(nums2[i]) if i < len(nums2) else 0

        if num1 == num2:
            continue
        elif num1 > num2:
            return 1
        else:
            return -1

    return 0


def aria2_need_update(aria2_min_ver: str) -> bool:
    aria2_ver = get_aria2_ver()

    if aria2_ver:
        if compare_versions(aria2_ver, aria2_min_ver) == -1:
            return True
        else:
            return False
    else:
        return True


print(aria2_need_update('$ARIA2_MINIMUM_VER'))
".Trim()

    Print-Msg "检查 Aria2 是否需要更新"
    $urls = @(
        "https://modelscope.cn/models/licyks/invokeai-core-model/resolve/master/pypatchmatch/aria2c.exe",
        "https://huggingface.co/licyk/invokeai-core-model/resolve/main/pypatchmatch/aria2c.exe"
    )
    $aria2_tmp_path = "$Env:CACHE_HOME/aria2c.exe"
    $status = $(python -c "$content")
    $i = 0

    if ($status -eq "True") {
        Print-Msg "更新 Aria2 中"
        New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null
    } else {
        Print-Msg "Aria2 无需更新"
        return
    }

    ForEach ($url in $urls) {
        Print-Msg "下载 Aria2 中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$aria2_tmp_path"
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试下载 Aria2 中"
            } else {
                Print-Msg "Aria2 下载失败, 无法更新 Aria2, 可能会导致模型下载出现问题"
                return
            }
        }
    }

    if ((Test-Path "$PSScriptRoot/Fooocus/git/bin/aria2c.exe") -or (Test-Path "$PSScriptRoot/Fooocus/git/bin/git.exe")) {
        Move-Item -Path "$Env:CACHE_HOME/aria2c.exe" -Destination "$PSScriptRoot/Fooocus/git/bin/aria2c.exe" -Force
    } elseif ((Test-Path "$PSScriptRoot/git/bin/aria2c.exe") -or (Test-Path "$PSScriptRoot/git/bin/git.exe")) {
        Move-Item -Path "$Env:CACHE_HOME/aria2c.exe" -Destination "$PSScriptRoot/git/bin/aria2c.exe" -Force
    } else {
        New-Item -ItemType Directory -Path "$PSScriptRoot/git/bin" -Force > $null
        Move-Item -Path "$Env:CACHE_HOME/aria2c.exe" -Destination "$PSScriptRoot/git/bin/aria2c.exe" -Force
    }
    Print-Msg "Aria2 更新完成"
}


# 模型列表
function Get-Model-List {
    $model_list = New-Object System.Collections.ArrayList

    # >>>>>>>>>> Start
    # SD 1.5
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/v1-5-pruned-emaonly.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/animefull-final-pruned.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/nai1-artist_all_in_one_merge.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/Counterfeit-V3.0_fp16.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/cetusMix_Whalefall2.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/cuteyukimixAdorable_neochapter3.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/ekmix-pastel-fp16-no-ema.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/ex2K_sse2.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/kohakuV5_rev2.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/meinamix_meinaV11.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/oukaStar_10.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/pastelMixStylizedAnime_pastelMixPrunedFP16.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/rabbit_v6.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/sweetSugarSyndrome_rev15.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/AnythingV5Ink_ink.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/bartstyledbBlueArchiveArtStyleFineTunedModel_v10.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/meinapastel_v6Pastel.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/qteamixQ_omegaFp16.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_1.5/tmndMix_tmndMixSPRAINBOW.safetensors", "SD 1.5", "checkpoints")) | Out-Null
    # SD 2.1
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_2.1/v2-1_768-ema-pruned.safetensors", "SD 2.1", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_2.1/wd-1-4-anime_e2.ckpt", "SD 2.1", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sd_2.1/wd-mofu-fp16.safetensors", "SD 2.1", "checkpoints")) | Out-Null
    # SDXL
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-lora/resolve/master/sdxl/sd_xl_offset_example-lora_1.0.safetensors", "SDXL", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/sd_xl_base_1.0_0.9vae.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/sd_xl_refiner_1.0_0.9vae.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/sd_xl_turbo_1.0_fp16.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/cosxl.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/cosxl_edit.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animagine-xl-3.0-base.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animagine-xl-3.0.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animagine-xl-3.1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animagine-xl-4.0.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animagine-xl-4.0-opt.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animagine-xl-4.0-zero.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/holodayo-xl-2.1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/kivotos-xl-2.0.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/clandestine-xl-1.0.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/UrangDiffusion-1.1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/RaeDiffusion-XL-v2.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/sd_xl_anime_V52.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/kohaku-xl-delta-rev1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/kohakuXLEpsilon_rev1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/kohaku-xl-epsilon-rev2.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/kohaku-xl-epsilon-rev3.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/kohaku-xl-zeta.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/starryXLV52_v52.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/heartOfAppleXL_v20.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/heartOfAppleXL_v30.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/baxlBartstylexlBlueArchiveFlatCelluloid_xlv1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/baxlBlueArchiveFlatCelluloidStyle_xlv3.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/sanaexlAnimeV10_v10.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/sanaexlAnimeV10_v11.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/SanaeXL-Anime-v1.2-aesthetic.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/SanaeXL-Anime-v1.3-aesthetic.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/Illustrious-XL-v0.1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/Illustrious-XL-v0.1-GUIDED.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/Illustrious-XL-v1.0.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/Illustrious-XL-v1.1.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/Illustrious-XL-v2.0-stable.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/jruTheJourneyRemains_v25XL.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/PVCStyleModelMovable_illustriousxl10.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/miaomiaoHarem_v15a.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/waiNSFWIllustrious_v80.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/tIllunai3_v4.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_earlyAccessVersion.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_epsilonPred05Version.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_epsilonPred075.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_epsilonPred077.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_epsilonPred10Version.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_epsilonPred11Version.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPredTestVersion.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPred05Version.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPred06Version.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPred065SVersion.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPred075SVersion.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPred09RVersion.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/noobaiXLNAIXL_vPred10Version.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/PVCStyleModelMovable_nbxl12.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/PVCStyleModelMovable_nbxlVPredV10.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/ponyDiffusionV6XL_v6StartWithThisOne.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/pdForAnime_v20.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/tPonynai3_v51WeightOptimized.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/omegaPonyXLAnime_v20.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animeIllustDiffusion_v061.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/artiwaifuDiffusion_v10.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/artiwaifu-diffusion-v2.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/AnythingXL_xl.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/abyssorangeXLElse_v10.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/animaPencilXL_v200.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/bluePencilXL_v401.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/nekorayxl_v06W3.safetensors", "SDXL", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-model/resolve/master/sdxl_1.0/CounterfeitXL-V1.0.safetensors", "SDXL", "checkpoints")) | Out-Null
    # SD 3
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3_medium.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3_medium_incl_clips.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3_medium_incl_clips_t5xxlfp8.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3.5_large.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3.5_large_fp8_scaled.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3.5_large_turbo.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3.5_medium.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/sd3.5_medium_incl_clips_t5xxlfp8scaled.safetensors", "SD 3", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/emi3.safetensors", "SD 3", "checkpoints")) | Out-Null
    # SD 3 Text Encoder
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/text_encoders/clip_g.safetensors", "SD 3 Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/text_encoders/clip_l.safetensors", "SD 3 Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/text_encoders/t5xxl_fp16.safetensors", "SD 3 Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/text_encoders/t5xxl_fp8_e4m3fn.safetensors", "SD 3 Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-3-model/resolve/master/text_encoders/t5xxl_fp8_e4m3fn_scaled.safetensors", "SD 3 Text Encoder", "clip")) | Out-Null
    # HunyuanDiT
    $model_list.Add(@("https://modelscope.cn/models/licyks/comfyui-extension-models/resolve/master/hunyuan_dit_comfyui/hunyuan_dit_1.2.safetensors", "HunyuanDiT", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/comfyui-extension-models/resolve/master/hunyuan_dit_comfyui/comfy_freeway_animation_hunyuan_dit_180w.safetensors", "HunyuanDiT", "checkpoints")) | Out-Null
    # FLUX
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev.safetensors", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-fp8.safetensors", "FLUX", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux_dev_fp8_scaled_diffusion_model.safetensors", "FLUX", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-bnb-nf4-v2.safetensors", "FLUX", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-bnb-nf4.safetensors", "FLUX", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q2_K.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q3_K_S.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q4_0.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q4_1.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q4_K_S.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q5_0.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q5_1.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q5_K_S.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q6_K.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-Q8_0.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-dev-F16.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell.safetensors", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-fp8.safetensors", "FLUX", "checkpoints")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q2_K.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q3_K_S.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q4_0.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q4_1.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q4_K_S.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q5_0.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q5_1.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q5_K_S.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q6_K.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-Q8_0.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/flux1-schnell-F16.gguf", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/ashen0209-flux1-dev2pro.safetensors", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/jimmycarter-LibreFLUX.safetensors", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/nyanko7-flux-dev-de-distill.safetensors", "FLUX", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_1/shuttle-3-diffusion.safetensors", "FLUX", "unet")) | Out-Null
    # FLUX Text Encoder
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/clip_l.safetensors", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5xxl_fp16.safetensors", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5xxl_fp8_e4m3fn.safetensors", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q3_K_L.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q3_K_M.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q3_K_S.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q4_K_M.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q4_K_S.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q5_K_M.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q5_K_S.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q6_K.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-Q8_0.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-f16.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_text_encoders/t5-v1_1-xxl-encoder-f32.gguf", "FLUX Text Encoder", "clip")) | Out-Null
    # FLUX VAE
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux-model/resolve/master/flux_vae/ae.safetensors", "FLUX VAE", "vae")) | Out-Null
    # SD 1.5 VAE
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/sd_1.5/vae-ft-ema-560000-ema-pruned.safetensors", "SD 1.5 VAE", "vae")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/sd_1.5/vae-ft-mse-840000-ema-pruned.safetensors", "SD 1.5 VAE", "vae")) | Out-Null
    # SDXL VAE
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/sdxl_1.0/sdxl_vae.safetensors", "SDXL VAE", "vae")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/sdxl_1.0/sdxl_fp16_fix_vae.safetensors", "SDXL VAE", "vae")) | Out-Null
    # VAE approx
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/vae-approx/model.pt", "VAE approx", "vae_approx")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/vae-approx/vaeapprox-sdxl.pt", "VAE approx", "vae_approx")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-vae/resolve/master/vae-approx/vaeapprox-sd3.pt", "VAE approx", "vae_approx")) | Out-Null
    # Upscale
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/Codeformer/codeformer-v0.1.0.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_2_x2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_2_x3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_2_x4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_S_x2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_S_x3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_S_x4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_light_x2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_light_x3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_light_x4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_x2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_x3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/DAT/DAT_x4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/16xPSNR.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/1x-ITF-SkinDiffDetail-Lite-v1.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/1x_NMKD-BrightenRedux_200k.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/1x_NMKD-YandereInpaint_375000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/1x_NMKDDetoon_97500_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/1x_NoiseToner-Poisson-Detailed_108000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/1x_NoiseToner-Uniform-Detailed_100000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x-UltraSharp.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4xPSNR.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_CountryRoads_377000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_Fatality_Comix_260000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKD-Siax_200k.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKD-Superscale-Artisoftject_210000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKD-Superscale-SP_178000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKD-UltraYandere-Lite_280k.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKD-UltraYandere_300k.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKD-YandereNeoXL_200k.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NMKDSuperscale_Artisoft_120000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_NickelbackFS_72000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_Nickelback_70000G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_RealisticRescaler_100000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_Valar_v1.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_fatal_Anime_500000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/4x_foolhardy_Remacri.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/8xPSNR.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/8x_NMKD-Superscale_150000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/8x_NMKD-Typescale_175k.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/A_ESRGAN_Single.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/BSRGAN.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/BSRGANx2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/BSRNet.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/ESRGAN_4x.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/LADDIER1_282500_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/UniversalUpscaler/4x_UniversalUpscalerV2-Neutral_115000_swaG.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/UniversalUpscaler/4x_UniversalUpscalerV2-Sharp_101000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/UniversalUpscaler/4x_UniversalUpscalerV2-Sharper_103000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/UniversalUpscaler/Legacy/4x_UniversalUpscaler-Detailed_155000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/UniversalUpscaler/Legacy/4x_UniversalUpscaler-Soft_190000_G.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/WaifuGAN_v3_30000.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/lollypop.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/ESRGAN/sudo_rife4_269.662_testV1_scale1.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/GFPGAN/GFPGANv1.3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/GFPGAN/GFPGANv1.4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/GFPGAN/detection_Resnet50_Final.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/GFPGAN/parsing_bisenet.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/GFPGAN/parsing_parsenet.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/RealESRGAN/RealESRGAN_x4plus.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/RealESRGAN/RealESRGAN_x4plus_anime_6B.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DF2K_s64w8_SwinIR-M_x2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DF2K_s64w8_SwinIR-M_x3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DF2K_s64w8_SwinIR-M_x4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DF2K_s64w8_SwinIR-M_x8.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DIV2K_s48w8_SwinIR-M_x2.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DIV2K_s48w8_SwinIR-M_x3.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DIV2K_s48w8_SwinIR-M_x4.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/001_classicalSR_DIV2K_s48w8_SwinIR-M_x8.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/003_realSR_BSRGAN_DFOWMFC_s64w8_SwinIR-L_x4_GAN-with-dict-keys-params-and-params_ema.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/003_realSR_BSRGAN_DFO_s64w8_SwinIR-M_x2_GAN-with-dict-keys-params-and-params_ema.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/Swin2SR_ClassicalSR_X2_64.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/Swin2SR_ClassicalSR_X4_64.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/Swin2SR_CompressedSR_X4_48.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/Swin2SR_RealworldSR_X4_64_BSRGAN_PSNR.pth", "Upscale", "upscale_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-upscaler-models/resolve/master/SwinIR/SwinIR_4x.pth", "Upscale", "upscale_models")) | Out-Null
    # Embedding
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/EasyNegativeV2.safetensors", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/bad-artist-anime.pt", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/bad-artist.pt", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/bad-hands-5.pt", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/bad-image-v2-39000.pt", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/bad_prompt_version2.pt", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/ng_deepnegative_v1_75t.pt", "Embedding", "embeddings")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd-embeddings/resolve/master/sd_1.5/verybadimagenegative_v1.3.pt", "Embedding", "embeddings")) | Out-Null
    # SD 1.5 ControlNet
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11e_sd15_ip2p_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11e_sd15_shuffle_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11f1e_sd15_tile_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11f1p_sd15_depth_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_canny_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_inpaint_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_lineart_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_mlsd_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_normalbae_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_openpose_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_scribble_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_seg_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15_softedge_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v11p_sd15s2_lineart_anime_fp16.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v1p_sd15_brightness.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v1p_sd15_illumination.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/control_v1p_sd15_qrcode_monster.safetensors", "SD 1.5 ControlNet", "controlnet")) | Out-Null
    # SDXL ControlNet
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/monster-labs-control_v1p_sdxl_qrcode_monster.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/mistoLine_fp16.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/destitech-controlnet-inpaint-dreamer-sdxl.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/control-lora/resolve/master/control-lora-recolor-rank128-sdxl.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/xinsir-controlnet-union-sdxl-1.0-promax.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/kohakuXLControlnet_canny.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/animagineXL40_canny.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLCanny_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLLineart_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLDepth_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLSoftedge_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLLineartRrealistic_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLShuffle_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLOpenPose_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLTile_v10.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLv0.1_inpainting_fp16.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLv1.1_canny_fp16.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLv1.1_depth_midas_fp16.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLv1.1_inpainting_fp16.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/illustriousXLv1.1_tile_fp16.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsCanny.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsDepthMidas.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsLineartAnime.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsNormalMidas.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsSoftedgeHed.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsMangaLine.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsLineartRealistic.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsDepthMidasV11.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsScribbleHed.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsScribblePidinet.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_openposeModel.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/noobaiXLControlnet_epsTile.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd_control_collection/resolve/master/NoobAI_Inpainting_ControlNet.safetensors", "SDXL ControlNet", "controlnet")) | Out-Null
    # SD 3.5 ControlNet
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd3_controlnet/resolve/master/sd3.5_large_controlnet_blur.safetensors", "SD 3.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd3_controlnet/resolve/master/sd3.5_large_controlnet_canny.safetensors", "SD 3.5 ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/sd3_controlnet/resolve/master/sd3.5_large_controlnet_depth.safetensors", "SD 3.5 ControlNet", "controlnet")) | Out-Null
    # FLUX ControlNet
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-redux-dev.safetensors", "FLUX ControlNet", "style_models")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev.safetensors", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q3_K_S.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q4_0.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q4_1.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q4_K_S.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q5_0.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q5_1.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q5_K_S.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q6_K.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-Q8_0.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-fp16-F16-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-fp16-Q4_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-fp16-Q5_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-fp16-Q8_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-lora-rank128.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-lora-rank256.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-lora-rank32.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-lora-rank4.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-lora-rank64.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-fill-dev-lora-rank8.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-canny-dev-lora.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-canny-dev.safetensors", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-canny-dev-fp16-F16-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-canny-dev-fp16-Q4_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-canny-dev-fp16-Q5_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-canny-dev-fp16-Q8_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-depth-dev-fp16-F16-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-depth-dev-fp16-Q4_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-depth-dev-fp16-Q5_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-depth-dev-fp16-Q8_0-GGUF.gguf", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-depth-dev-lora.safetensors", "FLUX ControlNet", "loras")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-depth-dev.safetensors", "FLUX ControlNet", "unet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-xlabs-canny-controlnet-v3.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-xlabs-depth-controlnet-v3.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-xlabs-hed-controlnet-v3.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-dev-jasperai-Controlnet-Depth.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-dev-jasperai-Controlnet-Surface-Normals.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-dev-jasperai-Controlnet-Upscaler.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-dev-instantx-controlnet-union.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-dev-mistoline.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-dev-shakker-labs-controlnet-union-pro.safetensors", "FLUX ControlNet", "controlnet")) | Out-Null
    # CLIP Vision
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1_annotator/resolve/master/clip_vision/clip_g.pth", "CLIP Vision", "clip_vision")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1_annotator/resolve/master/clip_vision/clip_h.pth", "CLIP Vision", "clip_vision")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1_annotator/resolve/master/clip_vision/clip_vitl.pth", "CLIP Vision", "clip_vision")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/sigclip_vision_patch14_384.safetensors", "CLIP Vision", "clip_vision")) | Out-Null
    # IP Adapter
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter_sd15.pth", "SD 1.5 IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter_sd15_light.pth", "SD 1.5 IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter_sd15_plus.pth", "SD 1.5 IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter_sd15_vit-G.safetensors", "SD 1.5 IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter-plus_sdxl_vit-h.safetensors", "SDXL IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter_sdxl.safetensors", "SDXL IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/ip-adapter_sdxl_vit-h.safetensors", "SDXL IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/controlnet_v1.1/resolve/master/noobIPAMARK1_mark1.safetensors", "SDXL IP Adapter", "ipadapter")) | Out-Null
    $model_list.Add(@("https://modelscope.cn/models/licyks/flux_controlnet/resolve/master/flux1-xlabs-ip-adapter.safetensors", "FLUX IP Adapter", "controlnet")) | Out-Null
    # <<<<<<<<<< End

    return $model_list
}


# 展示模型列表
function List-Model($model_list) {
    $count = 0
    $point = "None"
    Print-Msg "可下载的模型列表"
    Write-Host "-----------------------------------------------------"
    Write-Host "模型序号" -ForegroundColor Yellow -NoNewline
    Write-Host " | " -NoNewline
    Write-Host "模型名称" -ForegroundColor White -NoNewline
    Write-Host " | " -NoNewline
    Write-Host "模型种类" -ForegroundColor Cyan
    for ($i = 0; $i -lt $model_list.Count; $i++) {
        $content = $model_list[$i]
        $count += 1
        $url = $content[0]
        # $name = [System.IO.Path]::GetFileNameWithoutExtension($url)
        $name = [System.IO.Path]::GetFileName($url)
        $ver = $content[1]
        if ($point -ne $ver) {
            Write-Host
            Write-Host "- $ver" -ForegroundColor Cyan
        }
        $point = $ver
        Write-Host "  - ${count}、" -ForegroundColor Yellow -NoNewline
        Write-Host "$name " -ForegroundColor White -NoNewline
        Write-Host "($ver)" -ForegroundColor Cyan
    }
    Write-Host
    Write-Host "关于部分模型的介绍可阅读：https://github.com/licyk/README-collection/blob/main/model-info/README.md"
    Write-Host "-----------------------------------------------------"
}


# 列出要下载的模型
function List-Download-Task ($download_list) {
    Print-Msg "当前选择要下载的模型"
    Write-Host "-----------------------------------------------------"
    Write-Host "模型名称" -ForegroundColor White -NoNewline
    Write-Host " | " -NoNewline
    Write-Host "模型种类" -ForegroundColor Cyan
    Write-Host
    for ($i = 0; $i -lt $download_list.Count; $i++) {
        $content = $download_list[$i]
        $name = $content[0]
        $type = $content[2]
        Write-Host "- " -ForegroundColor Yellow -NoNewline
        Write-Host "$name" -ForegroundColor White -NoNewline
        Write-Host " ($type) " -ForegroundColor Cyan
    }
    Write-Host
    Write-Host "总共要下载的模型数量: $($i)" -ForegroundColor White
    Write-Host "-----------------------------------------------------"
}


# 模型下载器
function Model-Downloader ($download_list) {
    $sum = $download_list.Count
    for ($i = 0; $i -lt $download_list.Count; $i++) {
        $content = $download_list[$i]
        $name = $content[0]
        $url = $content[1]
        $type = $content[2]
        $path = ([System.IO.Path]::GetFullPath($content[3]))
        $model_name = Split-Path $url -Leaf
        Print-Msg "[$($i + 1)/$sum] 下载 $name ($type) 模型到 $path 中"
        aria2c --file-allocation=none --summary-interval=0 --console-log-level=error -s 64 -c -x 16 -k 1M $url -d "$path" -o "$model_name"
        if ($?) {
            Print-Msg "[$($i + 1)/$sum] $name ($type) 下载成功"
        } else {
            Print-Msg "[$($i + 1)/$sum] $name ($type) 下载失败"
        }
    }
}


# 获取用户输入
function Get-User-Input {
    return (Read-Host "========================================>").Trim()
}


# 搜索模型列表
function Search-Model-List ($model_list, $key) {
    $count = 0
    $result = 0
    Print-Msg "模型列表搜索结果"
    Write-Host "-----------------------------------------------------"
    Write-Host "模型序号" -ForegroundColor Yellow -NoNewline
    Write-Host " | " -NoNewline
    Write-Host "模型名称" -ForegroundColor White -NoNewline
    Write-Host " | " -NoNewline
    Write-Host "模型种类" -ForegroundColor Cyan
    for ($i = 0; $i -lt $model_list.Count; $i++) {
        $content = $model_list[$i]
        $count += 1
        $url = $content[0]
        # $name = [System.IO.Path]::GetFileNameWithoutExtension($url)
        $name = [System.IO.Path]::GetFileName($url)
        $ver = $content[1]

        if ($name -like "*$key*") {
            Write-Host " - ${count}、" -ForegroundColor Yellow -NoNewline
            Write-Host "$name " -ForegroundColor White -NoNewline
            Write-Host "($ver)" -ForegroundColor Cyan
            $result += 1
        }
    }
    Write-Host
    Write-Host "搜索 $key 得到的结果数量: $result" -ForegroundColor White
    Write-Host "-----------------------------------------------------"
}


function Main {
    Print-Msg "初始化中"
    Get-Fooocus-Installer-Version
    Get-Fooocus-Installer-Cmdlet-Help
    Set-Proxy
    if ($BuildMode) {
        Print-Msg "Fooocus Installer 构建模式已启用, 跳过 Fooocus Installer 更新检查"
    } else {
        Check-Fooocus-Installer-Update
    }
    Check-Aria2-Version

    if (!(Test-Path "$PSScriptRoot/Fooocus")) {
        Print-Msg "在 $PSScriptRoot 路径中未找到 Fooocus 文件夹, 请检查 Fooocus 是否已正确安装, 或者尝试运行 Fooocus Installer 进行修复"
        Read-Host | Out-Null
        return
    }

    $to_exit = 0
    $go_to = 0
    $has_error = $false
    $model_list = Get-Model-List
    $download_list = New-Object System.Collections.ArrayList
    $after_list_model_option = ""

    while ($True) {
        List-Model $model_list
        switch ($after_list_model_option) {
            list_search_result {
                Search-Model-List $model_list $find_key
                break
            }
            display_input_error {
                Print-Msg "输入有误, 请重试"
            }
            Default {
                break
            }
        }
        $after_list_model_option = ""
        Print-Msg "请选择要下载的模型"
        Print-Msg "提示:"
        Print-Msg "1. 输入数字后回车"
        Print-Msg "2. 如果需要下载多个模型, 可以输入多个数字并使用空格隔开"
        Print-Msg "3. 输入 search 可以进入列表搜索模式, 可搜索列表中已有的模型"
        Print-Msg "4. 输入 exit 退出模型下载脚本"
        if ($BuildMode) {
            $arg = $BuildWitchModel
            $go_to = 1
        } else {
            $arg = Get-User-Input
        }

        switch ($arg) {
            exit {
                $to_exit = 1
                $go_to = 1
                break
            }
            search {
                Print-Msg "请输入要从模型列表搜索的模型名称"
                $find_key = Get-User-Input
                $after_list_model_option = "list_search_result"
            }
            Default {
                $arg = $arg.Split() # 拆分成列表
                ForEach ($i in $arg) {
                    try {
                        # 检测输入是否符合列表
                        $i = [int]$i
                        if ((!(($i -ge 1) -and ($i -le $model_list.Count)))) {
                            $has_error = $true
                            break
                        }

                        # 创建下载列表
                        $content = $model_list[($i - 1)]
                        $url = $content[0] # 下载链接
                        $type = $content[1] # 类型
                        $path = "$PSScriptRoot/Fooocus/models/$($content[2])" # 模型放置路径
                        # $name = [System.IO.Path]::GetFileNameWithoutExtension($url) # 模型名称
                        $name = [System.IO.Path]::GetFileName($url) # 模型名称
                        $task = @($name, $url, $type, $path)
                        # 检查重复元素
                        $has_duplicate = $false
                        for ($j = 0; $j -lt $download_list.Count; $j++) {
                            $task_tmp = $download_list[$j]
                            $comparison = Compare-Object -ReferenceObject $task_tmp -DifferenceObject $task
                            if ($comparison.Count -eq 0) {
                                $has_duplicate = $true
                                break
                            }
                        }
                        if (!($has_duplicate)) {
                            $download_list.Add($task) | Out-Null # 添加列表
                        }
                        $has_duplicate = $false
                    }
                    catch {
                        $has_error = $true
                        break
                    }
                }

                if ($has_error) {
                    $after_list_model_option = "display_input_error"
                    $has_error = $false
                    $download_list.Clear() # 出现错误时清除下载列表
                    break
                }

                $go_to = 1
                break
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }

    if ($to_exit -eq 1) {
        Print-Msg "退出模型下载脚本"
        Read-Host | Out-Null
        exit 0
    }

    List-Download-Task $download_list
    Print-Msg "是否确认下载模型?"
    Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
    if ($BuildMode) {
        $download_operate = "yes"
    } else {
        $download_operate = Get-User-Input
    }
    if ($download_operate -eq "yes" -or $download_operate -eq "y" -or $download_operate -eq "YES" -or $download_operate -eq "Y") {
        Model-Downloader $download_list
    }

    Print-Msg "退出模型下载脚本"

    if (!($BuildMode)) {
        Read-Host | Out-Null
    }
}

###################

Main
