﻿param (
    [switch]$Help,
    [switch]$BuildMode,
    [int]$BuildWithTorch,
    [switch]$BuildWithTorchReinstall,
    [switch]$DisablePyPIMirror,
    [switch]$DisableUpdate,
    [switch]$DisableUV,
    [switch]$DisableProxy,
    [string]$UseCustomProxy,
    [switch]$DisableAutoApplyUpdate
)
# Fooocus Installer 版本和检查更新间隔
$FOOOCUS_INSTALLER_VERSION = 190
$UPDATE_TIME_SPAN = 3600
# PyPI 镜像源
$PIP_INDEX_ADDR = "https://mirrors.cloud.tencent.com/pypi/simple"
$PIP_INDEX_ADDR_ORI = "https://pypi.python.org/simple"
$PIP_EXTRA_INDEX_ADDR = "https://mirrors.cernet.edu.cn/pypi/web/simple"
$PIP_EXTRA_INDEX_ADDR_ORI = ""
$PIP_FIND_ADDR = "https://mirrors.aliyun.com/pytorch-wheels/torch_stable.html"
$PIP_FIND_ADDR_ORI = "https://download.pytorch.org/whl/torch_stable.html"
$USE_PIP_MIRROR = if ((!(Test-Path "$PSScriptRoot/disable_pypi_mirror.txt")) -and (!($DisablePyPIMirror))) { $true } else { $false }
$PIP_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_INDEX_ADDR } else { $PIP_INDEX_ADDR_ORI }
$PIP_EXTRA_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_EXTRA_INDEX_ADDR } else { $PIP_EXTRA_INDEX_ADDR_ORI }
$PIP_FIND_MIRROR = if ($USE_PIP_MIRROR) { $PIP_FIND_ADDR } else { $PIP_FIND_ADDR_ORI }
$PIP_FIND_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121/torch_stable.html"
$PIP_EXTRA_INDEX_MIRROR_PYTORCH = "https://download.pytorch.org/whl"
$PIP_EXTRA_INDEX_MIRROR_XPU = "https://download.pytorch.org/whl/xpu"
$PIP_EXTRA_INDEX_MIRROR_CU118 = "https://download.pytorch.org/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121"
$PIP_EXTRA_INDEX_MIRROR_CU124 = "https://download.pytorch.org/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126 = "https://download.pytorch.org/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128 = "https://download.pytorch.org/whl/cu128"
$PIP_EXTRA_INDEX_MIRROR_CU118_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU124_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu128"
# uv 最低版本
$UV_MINIMUM_VER = "0.8"
# Aria2 最低版本
$ARIA2_MINIMUM_VER = "1.37.0"
# PATH
$PYTHON_PATH = "$PSScriptRoot/python"
$PYTHON_EXTRA_PATH = "$PSScriptRoot/Fooocus/python"
$PYTHON_SCRIPTS_PATH = "$PSScriptRoot/python/Scripts"
$PYTHON_SCRIPTS_EXTRA_PATH = "$PSScriptRoot/Fooocus/python/Scripts"
$GIT_PATH = "$PSScriptRoot/git/bin"
$GIT_EXTRA_PATH = "$PSScriptRoot/Fooocus/git/bin"
$Env:PATH = "$PYTHON_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_EXTRA_PATH$([System.IO.Path]::PathSeparator)$GIT_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_PATH$([System.IO.Path]::PathSeparator)$GIT_PATH$([System.IO.Path]::PathSeparator)$Env:PATH"
# 环境变量
$Env:PIP_INDEX_URL = "$PIP_INDEX_MIRROR"
$Env:PIP_EXTRA_INDEX_URL = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:PIP_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_DEFAULT_INDEX = "$PIP_INDEX_MIRROR"
$Env:UV_INDEX = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:UV_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_LINK_MODE = "copy"
$Env:UV_HTTP_TIMEOUT = 30
$Env:UV_CONCURRENT_DOWNLOADS = 50
$Env:UV_INDEX_STRATEGY = "unsafe-best-match"
$Env:UV_CONFIG_FILE = "nul"
$Env:PIP_CONFIG_FILE = "nul"
$Env:PIP_DISABLE_PIP_VERSION_CHECK = 1
$Env:PIP_NO_WARN_SCRIPT_LOCATION = 0
$Env:PIP_TIMEOUT = 30
$Env:PIP_RETRIES = 5
$Env:PIP_PREFER_BINARY = 1
$Env:PIP_YES = 1
$Env:PYTHONUTF8 = 1
$Env:PYTHONIOENCODING = "utf-8"
$Env:PYTHONUNBUFFERED = 1
$Env:PYTHONNOUSERSITE = 1
$Env:PYTHONFAULTHANDLER = 1
$Env:GRADIO_ANALYTICS_ENABLED = "False"
$Env:HF_HUB_DISABLE_SYMLINKS_WARNING = 1
$Env:BITSANDBYTES_NOWELCOME = 1
$Env:ClDeviceGlobalMemSizeAvailablePercent = 100
$Env:CUDA_MODULE_LOADING = "LAZY"
$Env:TORCH_CUDNN_V8_API_ENABLED = 1
$Env:USE_LIBUV = 0
$Env:SYCL_CACHE_PERSISTENT = 1
$Env:TF_CPP_MIN_LOG_LEVEL = 3
$Env:SAFETENSORS_FAST_GPU = 1
$Env:CACHE_HOME = "$PSScriptRoot/cache"
$Env:HF_HOME = "$PSScriptRoot/cache/huggingface"
$Env:MATPLOTLIBRC = "$PSScriptRoot/cache"
$Env:MODELSCOPE_CACHE = "$PSScriptRoot/cache/modelscope/hub"
$Env:MS_CACHE_HOME = "$PSScriptRoot/cache/modelscope/hub"
$Env:SYCL_CACHE_DIR = "$PSScriptRoot/cache/libsycl_cache"
$Env:TORCH_HOME = "$PSScriptRoot/cache/torch"
$Env:U2NET_HOME = "$PSScriptRoot/cache/u2net"
$Env:XDG_CACHE_HOME = "$PSScriptRoot/cache"
$Env:PIP_CACHE_DIR = "$PSScriptRoot/cache/pip"
$Env:PYTHONPYCACHEPREFIX = "$PSScriptRoot/cache/pycache"
$Env:TORCHINDUCTOR_CACHE_DIR = "$PSScriptRoot/cache/torchinductor"
$Env:TRITON_CACHE_DIR = "$PSScriptRoot/cache/triton"
$Env:UV_CACHE_DIR = "$PSScriptRoot/cache/uv"
$Env:UV_PYTHON = "$PSScriptRoot/python/python.exe"



# 帮助信息
function Get-Fooocus-Installer-Cmdlet-Help {
    $content = "
使用:
    .\reinstall_pytorch.ps1 [-Help] [-BuildMode] [-BuildWithTorch <PyTorch 版本编号>] [-BuildWithTorchReinstall] [-DisablePyPIMirror] [-DisableUpdate] [-DisableUV] [-DisableProxy] [-UseCustomProxy <代理服务器地址>] [-DisableAutoApplyUpdate]

参数:
    -Help
        获取 Fooocus Installer 的帮助信息

    -BuildMode
        启用 Fooocus Installer 构建模式

    -BuildWithTorch <PyTorch 版本编号>
        (需添加 -BuildMode 启用 Fooocus Installer 构建模式) Fooocus Installer 执行完基础安装流程后调用 Fooocus Installer 的 reinstall_pytorch.ps1 脚本, 根据 PyTorch 版本编号安装指定的 PyTorch 版本
        PyTorch 版本编号可运行 reinstall_pytorch.ps1 脚本进行查看

    -BuildWithTorchReinstall
        (需添加 -BuildMode 启用 Fooocus Installer 构建模式, 并且添加 -BuildWithTorch) 在 Fooocus Installer 构建模式下, 执行 reinstall_pytorch.ps1 脚本对 PyTorch 进行指定版本安装时使用强制重新安装

    -DisablePyPIMirror
        禁用 PyPI 镜像源, 使用 PyPI 官方源下载 Python 软件包

    -DisableUpdate
        禁用 Fooocus Installer 更新检查

    -DisableUV
        禁用 Fooocus Installer 使用 uv 安装 Python 软件包, 使用 Pip 安装 Python 软件包

    -DisableProxy
        禁用 Fooocus Installer 自动设置代理服务器

    -UseCustomProxy <代理服务器地址>
        使用自定义的代理服务器地址, 例如代理服务器地址为 http://127.0.0.1:10809, 则使用 -UseCustomProxy `"http://127.0.0.1:10809`" 设置代理服务器地址

    -DisableAutoApplyUpdate
        禁用 Fooocus Installer 自动应用新版本更新


更多的帮助信息请阅读 Fooocus Installer 使用文档: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md
".Trim()

    if ($Help) {
        Write-Host $content
        exit 0
    }
}


# 消息输出
function Print-Msg ($msg) {
    Write-Host "[$(Get-Date -Format "yyyy-MM-dd HH:mm:ss")]" -ForegroundColor Yellow -NoNewline
    Write-Host "[Fooocus Installer]" -ForegroundColor Cyan -NoNewline
    Write-Host ":: " -ForegroundColor Blue -NoNewline
    Write-Host "$msg"
}


# 显示 Fooocus Installer 版本
function Get-Fooocus-Installer-Version {
    $ver = $([string]$FOOOCUS_INSTALLER_VERSION).ToCharArray()
    $major = ($ver[0..($ver.Length - 3)])
    $minor = $ver[-2]
    $micro = $ver[-1]
    Print-Msg "Fooocus Installer 版本: v${major}.${minor}.${micro}"
}


# PyPI 镜像源状态
function PyPI-Mirror-Status {
    if ($USE_PIP_MIRROR) {
        Print-Msg "使用 PyPI 镜像源"
    } else {
        Print-Msg "检测到 disable_pypi_mirror.txt 配置文件 / -DisablePyPIMirror 命令行参数, 已将 PyPI 源切换至官方源"
    }
}


# Fooocus Installer 更新检测
function Check-Fooocus-Installer-Update {
    # 可用的下载源
    $urls = @(
        "https://github.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://github.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitlab.com/licyk/sd-webui-all-in-one/-/raw/main/fooocus_installer.ps1"
    )
    $i = 0

    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null

    if ((Test-Path "$PSScriptRoot/disable_update.txt") -or ($DisableUpdate)) {
        Print-Msg "检测到 disable_update.txt 更新配置文件 / -DisableUpdate 命令行参数, 已禁用 Fooocus Installer 的自动检查更新功能"
        return
    }

    # 获取更新时间间隔
    try {
        $last_update_time = Get-Content "$PSScriptRoot/update_time.txt" 2> $null
        $last_update_time = Get-Date $last_update_time -Format "yyyy-MM-dd HH:mm:ss"
    }
    catch {
        $last_update_time = Get-Date 0 -Format "yyyy-MM-dd HH:mm:ss"
    }
    finally {
        $update_time = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
        $time_span = New-TimeSpan -Start $last_update_time -End $update_time
    }

    if ($time_span.TotalSeconds -gt $UPDATE_TIME_SPAN) {
        Set-Content -Encoding UTF8 -Path "$PSScriptRoot/update_time.txt" -Value $(Get-Date -Format "yyyy-MM-dd HH:mm:ss") # 记录更新时间
    } else {
        return
    }

    ForEach ($url in $urls) {
        Print-Msg "检查 Fooocus Installer 更新中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$Env:CACHE_HOME/fooocus_installer.ps1"
            $latest_version = [int]$(
                Get-Content "$Env:CACHE_HOME/fooocus_installer.ps1" |
                Select-String -Pattern "FOOOCUS_INSTALLER_VERSION" |
                ForEach-Object { $_.ToString() }
            )[0].Split("=")[1].Trim()
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试检查 Fooocus Installer 更新中"
            } else {
                Print-Msg "检查 Fooocus Installer 更新失败"
                return
            }
        }
    }

    if ($latest_version -le $FOOOCUS_INSTALLER_VERSION) {
        Print-Msg "Fooocus Installer 已是最新版本"
        return
    }

    if (($DisableAutoApplyUpdate) -or (Test-Path "$PSScriptRoot/disable_auto_apply_update.txt")) {
        Print-Msg "检测到 Fooocus Installer 有新版本可用, 是否进行更新 (yes/no) ?"
        Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
        $arg = (Read-Host "========================================>").Trim()
        if (!($arg -eq "yes" -or $arg -eq "y" -or $arg -eq "YES" -or $arg -eq "Y")) {
            Print-Msg "跳过 Fooocus Installer 更新"
            return
        }
    } else {
        Print-Msg "检测到 Fooocus Installer 有新版本可用"
    }

    Print-Msg "调用 Fooocus Installer 进行更新中"
    . "$Env:CACHE_HOME/fooocus_installer.ps1" -InstallPath "$PSScriptRoot" -UseUpdateMode
    $raw_params = $script:MyInvocation.Line -replace "^.*\.ps1[\s]*", ""
    Print-Msg "更新结束, 重新启动 Fooocus Installer 管理脚本中, 使用的命令行参数: $raw_params"
    Invoke-Expression "& `"$PSCommandPath`" $raw_params"
    exit 0
}


# 检查 uv 是否需要更新
function Check-uv-Version {
    $content = "
import re
from importlib.metadata import version



def compare_versions(version1, version2) -> int:
    try:
        nums1 = re.sub(r'[a-zA-Z]+', '', version1).replace('-', '.').replace('+', '.').split('.')
        nums2 = re.sub(r'[a-zA-Z]+', '', version2).replace('-', '.').replace('+', '.').split('.')
    except:
        return 0

    for i in range(max(len(nums1), len(nums2))):
        num1 = int(nums1[i]) if i < len(nums1) else 0
        num2 = int(nums2[i]) if i < len(nums2) else 0

        if num1 == num2:
            continue
        elif num1 > num2:
            return 1
        else:
            return -1

    return 0



def is_uv_need_update() -> bool:
    try:
        uv_ver = version('uv')
    except:
        return True
    
    if compare_versions(uv_ver, uv_minimum_ver) == -1:
        return True
    else:
        return False



uv_minimum_ver = '$UV_MINIMUM_VER'
print(is_uv_need_update())
".Trim()

    Print-Msg "检测 uv 是否需要更新"
    $status = $(python -c "$content")
    if ($status -eq "True") {
        Print-Msg "更新 uv 中"
        python -m pip install -U "uv>=$UV_MINIMUM_VER"
        if ($?) {
            Print-Msg "uv 更新成功"
        } else {
            Print-Msg "uv 更新失败, 可能会造成 uv 部分功能异常"
        }
    } else {
        Print-Msg "uv 无需更新"
    }
}


# 设置 uv 的使用状态
function Set-uv {
    # 切换 uv 指定的 Python
    if (Test-Path "$PSScriptRoot/Fooocus/python/python.exe") {
        $Env:UV_PYTHON = "$PSScriptRoot/Fooocus/python/python.exe"
    }

    if ((Test-Path "$PSScriptRoot/disable_uv.txt") -or ($DisableUV)) {
        Print-Msg "检测到 disable_uv.txt 配置文件 / -DisableUV 命令行参数, 已禁用 uv, 使用 Pip 作为 Python 包管理器"
        $Global:USE_UV = $false
    } else {
        Print-Msg "默认启用 uv 作为 Python 包管理器, 加快 Python 软件包的安装速度"
        Print-Msg "当 uv 安装 Python 软件包失败时, 将自动切换成 Pip 重试 Python 软件包的安装"
        $Global:USE_UV = $true
        Check-uv-Version
    }
}


# 代理配置
function Set-Proxy {
    $Env:NO_PROXY = "localhost,127.0.0.1,::1"
    # 检测是否禁用自动设置镜像源
    if ((Test-Path "$PSScriptRoot/disable_proxy.txt") -or ($DisableProxy)) {
        Print-Msg "检测到本地存在 disable_proxy.txt 代理配置文件 / -DisableProxy 命令行参数, 禁用自动设置代理"
        return
    }

    $internet_setting = Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings"
    if ((Test-Path "$PSScriptRoot/proxy.txt") -or ($UseCustomProxy)) { # 本地存在代理配置
        if ($UseCustomProxy) {
            $proxy_value = $UseCustomProxy
        } else {
            $proxy_value = Get-Content "$PSScriptRoot/proxy.txt"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到本地存在 proxy.txt 代理配置文件 / -UseCustomProxy 命令行参数, 已读取代理配置文件并设置代理"
    } elseif ($internet_setting.ProxyEnable -eq 1) { # 系统已设置代理
        $proxy_addr = $($internet_setting.ProxyServer)
        # 提取代理地址
        if (($proxy_addr -match "http=(.*?);") -or ($proxy_addr -match "https=(.*?);")) {
            $proxy_value = $matches[1]
            # 去除 http / https 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "http://${proxy_value}"
        } elseif ($proxy_addr -match "socks=(.*)") {
            $proxy_value = $matches[1]
            # 去除 socks 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "socks://${proxy_value}"
        } else {
            $proxy_value = "http://${proxy_addr}"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到系统设置了代理, 已读取系统中的代理配置并设置代理"
    }
}


# 获取 xFormers 版本
function Get-xFormers-Version {
    $content = "
from importlib.metadata import version

try:
    ver = version('xformers')
except:
    ver = None

print(ver)
".Trim()

    $status = $(python -c "$content")
    return $status
}


# 获取驱动支持的最高 CUDA 版本
function Get-Drive-Support-CUDA-Version {
    Print-Msg "获取显卡驱动支持的最高 CUDA 版本"
    if (Get-Command nvidia-smi -ErrorAction SilentlyContinue) {
        $cuda_ver = $(nvidia-smi -q | Select-String -Pattern 'CUDA Version\s*:\s*([\d.]+)').Matches.Groups[1].Value
    } else {
        $cuda_ver = "未知"
    }
    return $cuda_ver
}


# 显示 PyTorch 和 xFormers 版本
function Get-PyTorch-And-xFormers-Version {
    $content = "
from importlib.metadata import version

try:
    print(version('torch'))
except:
    print(None)
".Trim()

    $torch_ver = $(python -c "$content")

    $content = "
from importlib.metadata import version

try:
    print(version('xformers'))
except:
    print(None)
".Trim()

    $xformers_ver = $(python -c "$content")

    if ($torch_ver -eq "None") { $torch_ver = "未安装" }
    if ($xformers_ver -eq "None") { $xformers_ver = "未安装" }

    Print-Msg "当前 PyTorch 版本: $torch_ver"
    Print-Msg "当前 xFormers 版本: $xformers_ver"
}


function Main {
    Print-Msg "初始化中"
    Get-Fooocus-Installer-Version
    Get-Fooocus-Installer-Cmdlet-Help
    Set-Proxy
    if ($BuildMode) {
        Print-Msg "Fooocus Installer 构建模式已启用, 跳过 Fooocus Installer 更新检查"
    } else {
        Check-Fooocus-Installer-Update
    }
    Set-uv
    PyPI-Mirror-Status

    # PyTorch 版本列表
    $content = "
-----------------------------------------------------
- 1、Torch 1.12.1 (CUDA 11.3) + xFormers 0.0.14
- 2、Torch 1.13.1 (DirectML)
- 3、Torch 1.13.1 (CUDA 11.7) + xFormers 0.0.16
- 4、Torch 2.0.0 (DirectML)
- 5、Torch 2.0.0 (Intel Arc)
- 6、Torch 2.0.0 (CUDA 11.8) + xFormers 0.0.18
- 7、Torch 2.0.1 (CUDA 11.8) + xFormers 0.0.22
- 8、Torch 2.1.0 (Intel Arc)
- 9、Torch 2.1.0 (Intel Core Ultra)
- 10、Torch 2.1.1 (CUDA 11.8) + xFormers 0.0.23
- 11、Torch 2.1.1 (CUDA 12.1) + xFormers 0.0.23
- 12、Torch 2.1.2 (CUDA 11.8) + xFormers 0.0.23.post1
- 13、Torch 2.1.2 (CUDA 12.1) + xFormers 0.0.23.post1
- 14、Torch 2.2.0 (CUDA 11.8) + xFormers 0.0.24
- 15、Torch 2.2.0 (CUDA 12.1) + xFormers 0.0.24
- 16、Torch 2.2.1 (CUDA 11.8) + xFormers 0.0.25
- 17、Torch 2.2.1 (DirectML)
- 18、Torch 2.2.1 (CUDA 12.1) + xFormers 0.0.25
- 19、Torch 2.2.2 (CUDA 11.8) + xFormers 0.0.25.post1
- 20、Torch 2.2.2 (CUDA 12.1) + xFormers 0.0.25.post1
- 21、Torch 2.3.0 (CUDA 11.8) + xFormers 0.0.26.post1
- 22、Torch 2.3.0 (CUDA 12.1) + xFormers 0.0.26.post1
- 23、Torch 2.3.1 (DirectML)
- 24、Torch 2.3.1 (CUDA 11.8) + xFormers 0.0.27
- 25、Torch 2.3.1 (CUDA 12.1) + xFormers 0.0.27
- 26、Torch 2.4.0 (CUDA 11.8) + xFormers 0.0.27.post2
- 27、Torch 2.4.0 (CUDA 12.1) + xFormers 0.0.27.post2
- 28、Torch 2.4.1 (CUDA 12.4) + xFormers 0.0.28.post1
- 29、Torch 2.5.0 (CUDA 12.4) + xFormers 0.0.28.post2
- 30、Torch 2.5.1 (CUDA 12.4) + xFormers 0.0.28.post3
- 31、Torch 2.6.0 (Intel Arc)
- 32、Torch 2.6.0 (CUDA 12.4) + xFormers 0.0.29.post3
- 33、Torch 2.6.0 (CUDA 12.6) + xFormers 0.0.29.post3
- 34、Torch 2.7.0 (Intel Arc)
- 35、Torch 2.7.0 (CUDA 11.8)
- 36、Torch 2.7.0 (CUDA 12.6) + xFormers 0.0.30
- 37、Torch 2.7.0 (CUDA 12.8) + xFormers 0.0.30
- 38、Torch 2.7.1 (Intel Arc)
- 39、Torch 2.7.1 (CUDA 11.8)
- 40、Torch 2.7.1 (CUDA 12.6) + xFormers 0.0.31.post1
- 41、Torch 2.7.1 (CUDA 12.8) + xFormers 0.0.31.post1
-----------------------------------------------------
    ".Trim()

    $to_exit = 0
    $torch_ver = ""
    $xformers_ver = ""
    $cuda_support_ver = Get-Drive-Support-CUDA-Version

    while ($True) {
        Print-Msg "PyTorch 版本列表"
        $go_to = 0
        Write-Host $content
        Get-PyTorch-And-xFormers-Version
        Print-Msg "当前显卡驱动支持的最高 CUDA 版本: $cuda_support_ver"
        Print-Msg "请选择 PyTorch 版本"
        Print-Msg "提示:"
        Print-Msg "1. PyTroch 版本通常来说选择最新版的即可"
        Print-Msg "2. 驱动支持的最高 CUDA 版本需要大于或等于要安装的 PyTorch 中所带的 CUDA 版本, 若驱动支持的最高 CUDA 版本低于要安装的 PyTorch 中所带的 CUDA 版本, 可尝试更新显卡驱动, 或者选择 CUDA 版本更低的 PyTorch"
        Print-Msg "3. 输入数字后回车, 或者输入 exit 退出 PyTroch 重装脚本"
        if ($BuildMode) {
            Print-Msg "Fooocus Installer 构建已启用, 指定安装的 PyTorch 序号: $BuildWithTorch"
            $arg = $BuildWithTorch
            $go_to = 1
        } else {
            $arg = (Read-Host "========================================>").Trim()
        }

        switch ($arg) {
            1 {
                $torch_ver = "torch==1.12.1+cu113 torchvision==0.13.1+cu113 torchaudio==1.12.1+cu113"
                $xformers_ver = "xformers==0.0.14"
                $go_to = 1
            }
            2 {
                $torch_ver = "torch==1.13.1 torchvision==0.14.1 torchaudio==0.13.1 torch-directml==0.1.13.1.dev230413"
                $xformers_ver = ""
                $go_to = 1
            }
            3 {
                $torch_ver = "torch==1.13.1+cu117 torchvision==0.14.1+cu117 torchaudio==1.13.1+cu117"
                $xformers_ver = "xformers==0.0.18"
                $go_to = 1
            }
            4 {
                $torch_ver = "torch==2.0.0 torchvision==0.15.1 torchaudio==2.0.0 torch-directml==0.2.0.dev230426"
                $xformers_ver = ""
                $go_to = 1
            }
            5 {
                $torch_ver = "torch==2.0.0a0+gite9ebda2 torchvision==0.15.2a0+fa99a53 intel_extension_for_pytorch==2.0.110+gitc6ea20b"
                $xformers_ver = ""
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = "https://licyk.github.io/t/pypi/index.html"
                $Env:UV_FIND_LINKS = "https://licyk.github.io/t/pypi/index.html"
                $go_to = 1
            }
            6 {
                $torch_ver = "torch==2.0.0+cu118 torchvision==0.15.1+cu118 torchaudio==2.0.0+cu118"
                $xformers_ver = "xformers==0.0.14"
                $go_to = 1
            }
            7 {
                $torch_ver = "torch==2.0.1+cu118 torchvision==0.15.2+cu118 torchaudio==2.0.1+cu118"
                $xformers_ver = "xformers==0.0.22"
                $go_to = 1
            }
            8 {
                $torch_ver = "torch==2.1.0a0+cxx11.abi torchvision==0.16.0a0+cxx11.abi torchaudio==2.1.0a0+cxx11.abi intel_extension_for_pytorch==2.1.10+xpu"
                $xformers_ver = ""
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = "https://licyk.github.io/t/pypi/index.html"
                $Env:UV_FIND_LINKS = "https://licyk.github.io/t/pypi/index.html"
                $go_to = 1
            }
            9 {
                $torch_ver = "torch==2.1.0a0+git7bcf7da torchvision==0.16.0+fbb4cc5 torchaudio==2.1.0+6ea1133 intel_extension_for_pytorch==2.1.20+git4849f3b"
                $xformers_ver = ""
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = "https://licyk.github.io/t/pypi/index.html"
                $Env:UV_FIND_LINKS = "https://licyk.github.io/t/pypi/index.html"
                $go_to = 1
            }
            10 {
                $torch_ver = "torch==2.1.1+cu118 torchvision==0.16.1+cu118 torchaudio==2.1.1+cu118"
                $xformers_ver = "xformers==0.0.23+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            11 {
                $torch_ver = "torch==2.1.1+cu121 torchvision==0.16.1+cu121 torchaudio==2.1.1+cu121"
                $xformers_ver = "xformers===0.0.23"
                $go_to = 1
            }
            12 {
                $torch_ver = "torch==2.1.2+cu118 torchvision==0.16.2+cu118 torchaudio==2.1.2+cu118"
                $xformers_ver = "xformers==0.0.23.post1+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            13 {
                $torch_ver = "torch==2.1.2+cu121 torchvision==0.16.2+cu121 torchaudio==2.1.2+cu121"
                $xformers_ver = "xformers===0.0.23.post1"
                $go_to = 1
            }
            14 {
                $torch_ver = "torch==2.2.0+cu118 torchvision==0.17.0+cu118 torchaudio==2.2.0+cu118"
                $xformers_ver = "xformers==0.0.24+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            15 {
                $torch_ver = "torch==2.2.0+cu121 torchvision==0.17.0+cu121 torchaudio==2.2.0+cu121"
                $xformers_ver = "xformers===0.0.24"
                $go_to = 1
            }
            16 {
                $torch_ver = "torch==2.2.1+cu118 torchvision==0.17.1+cu118 torchaudio==2.2.1+cu118"
                $xformers_ver = "xformers==0.0.25+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            17 {
                $torch_ver = "torch==2.2.1 torchvision==0.17.1 torchaudio==2.2.1 torch-directml==0.2.1.dev240521"
                $xformers_ver = ""
                $go_to = 1
            }
            18 {
                $torch_ver = "torch==2.2.1+cu121 torchvision==0.17.1+cu121 torchaudio==2.2.1+cu121"
                $xformers_ver = "xformers===0.0.25"
                $go_to = 1
            }
            19 {
                $torch_ver = "torch==2.2.2+cu118 torchvision==0.17.2+cu118 torchaudio==2.2.2+cu118"
                $xformers_ver = "xformers==0.0.25.post1+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            20 {
                $torch_ver = "torch==2.2.2+cu121 torchvision==0.17.2+cu121 torchaudio==2.2.2+cu121"
                $xformers_ver = "xformers===0.0.25.post1"
                $go_to = 1
            }
            21 {
                $torch_ver = "torch==2.3.0+cu118 torchvision==0.18.0+cu118 torchaudio==2.3.0+cu118"
                $xformers_ver = "xformers==0.0.26.post1+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            22 {
                $torch_ver = "torch==2.3.0+cu121 torchvision==0.18.0+cu121 torchaudio==2.3.0+cu121"
                $xformers_ver = "xformers===0.0.26.post1"
                $go_to = 1
            }
            23 {
                $torch_ver = "torch==2.3.1 torchvision==0.18.1 torchaudio==2.3.1 torch-directml==0.2.3.dev240715"
                $xformers_ver = "torch==2.3.1 torchvision==0.18.1 torch-directml==0.2.3.dev240715"
                $go_to = 1
            }
            24 {
                $torch_ver = "torch==2.3.1+cu118 torchvision==0.18.1+cu118 torchaudio==2.3.1+cu118"
                $xformers_ver = "xformers==0.0.27+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            25 {
                $torch_ver = "torch==2.3.1+cu121 torchvision==0.18.1+cu121 torchaudio==2.3.1+cu121"
                $xformers_ver = "xformers===0.0.27"
                $Env:PIP_INDEX_URL = $PIP_EXTRA_INDEX_MIRROR_CU121
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            26 {
                $torch_ver = "torch==2.4.0+cu118 torchvision==0.19.0+cu118 torchaudio==2.4.0+cu118"
                $xformers_ver = "xformers==0.0.27.post2+cu118"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            27 {
                $torch_ver = "torch==2.4.0+cu121 torchvision==0.19.0+cu121 torchaudio==2.4.0+cu121"
                $xformers_ver = "xformers==0.0.27.post2"
                $Env:PIP_INDEX_URL = $PIP_EXTRA_INDEX_MIRROR_CU121
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            28 {
                $torch_ver = "torch==2.4.1+cu124 torchvision==0.19.1+cu124 torchaudio==2.4.1+cu124"
                $xformers_ver = "xformers==0.0.28.post1"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU124_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU124
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            29 {
                $torch_ver = "torch==2.5.0+cu124 torchvision==0.20.0+cu124 torchaudio==2.5.0+cu124"
                $xformers_ver = "xformers==0.0.28.post2"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU124_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU124
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            30 {
                $torch_ver = "torch==2.5.1+cu124 torchvision==0.20.1+cu124 torchaudio==2.5.1+cu124"
                $xformers_ver = "xformers==0.0.28.post3"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU124_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU124
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            31 {
                $torch_ver = "torch==2.6.0+xpu torchvision==0.21.0+xpu torchaudio==2.6.0+xpu"
                $xformers_ver = ""
                $Env:PIP_INDEX_URL = $PIP_EXTRA_INDEX_MIRROR_XPU
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            32 {
                $torch_ver = "torch==2.6.0+cu124 torchvision==0.21.0+cu124 torchaudio==2.6.0+cu124"
                $xformers_ver = "xformers==0.0.29.post3"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU124_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU124
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            33 {
                $torch_ver = "torch==2.6.0+cu126 torchvision==0.21.0+cu126 torchaudio==2.6.0+cu126"
                $xformers_ver = "xformers==0.0.29.post3"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU126_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU126
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            34 {
                $torch_ver = "torch==2.7.0+xpu torchvision==0.22.0+xpu torchaudio==2.7.0+xpu"
                $xformers_ver = ""
                $Env:PIP_INDEX_URL = $PIP_EXTRA_INDEX_MIRROR_XPU
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            35 {
                $torch_ver = "torch==2.7.0+cu118 torchvision==0.22.0+cu118 torchaudio==2.7.0+cu118"
                $xformers_ver = ""
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            36 {
                $torch_ver = "torch==2.7.0+cu126 torchvision==0.22.0+cu126 torchaudio==2.7.0+cu126"
                $xformers_ver = "xformers==0.0.30"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU126_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU126
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            37 {
                $torch_ver = "torch==2.7.0+cu128 torchvision==0.22.0+cu128 torchaudio==2.7.0+cu128"
                $xformers_ver = "xformers==0.0.30"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU128_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU128
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            38 {
                $torch_ver = "torch==2.7.1+xpu torchvision==0.22.1+xpu torchaudio==2.7.1+xpu"
                $xformers_ver = ""
                $Env:PIP_INDEX_URL = $PIP_EXTRA_INDEX_MIRROR_XPU
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            39 {
                $torch_ver = "torch==2.7.1+cu118 torchvision==0.22.1+cu118 torchaudio==2.7.1+cu118"
                $xformers_ver = ""
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU118_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU118
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            40 {
                $torch_ver = "torch==2.7.1+cu126 torchvision==0.22.1+cu126 torchaudio==2.7.1+cu126"
                $xformers_ver = "xformers==0.0.31.post1"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU126_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU126
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            41 {
                $torch_ver = "torch==2.7.1+cu128 torchvision==0.22.1+cu128 torchaudio==2.7.1+cu128"
                $xformers_ver = "xformers==0.0.31.post1"
                $Env:PIP_INDEX_URL = if ($USE_PIP_MIRROR) {
                    $PIP_EXTRA_INDEX_MIRROR_CU128_NJU
                } else {
                    $PIP_EXTRA_INDEX_MIRROR_CU128
                }
                $Env:UV_DEFAULT_INDEX = $Env:PIP_INDEX_URL
                $Env:PIP_EXTRA_INDEX_URL = ""
                $Env:UV_INDEX = ""
                $Env:PIP_FIND_LINKS = ""
                $Env:UV_FIND_LINKS = ""
                $go_to = 1
            }
            exit {
                Print-Msg "退出 PyTorch 重装脚本"
                $to_exit = 1
                $go_to = 1
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }

    if ($to_exit -eq 1) {
        Read-Host | Out-Null
        exit 0
    }

    Print-Msg "是否选择仅强制重装 ? (通常情况下不需要)"
    Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
    if ($BuildMode) {
        if ($BuildWithTorchReinstall) {
            $use_force_reinstall = "yes"
        } else {
            $use_force_reinstall = "no"
        }
    } else {
        $use_force_reinstall = (Read-Host "========================================>").Trim()
    }

    if ($use_force_reinstall -eq "yes" -or $use_force_reinstall -eq "y" -or $use_force_reinstall -eq "YES" -or $use_force_reinstall -eq "Y") {
        $force_reinstall_arg = "--force-reinstall"
        $force_reinstall_status = "启用"
    } else {
        $force_reinstall_arg = New-Object System.Collections.ArrayList
        $force_reinstall_status = "禁用"
    }

    Print-Msg "当前的选择"
    Print-Msg "PyTorch: $torch_ver"
    Print-Msg "xFormers: $xformers_ver"
    Print-Msg "仅强制重装: $force_reinstall_status"
    Print-Msg "是否确认安装?"
    Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
    if ($BuildMode) {
        $install_torch = "yes"
    } else {
        $install_torch = (Read-Host "========================================>").Trim()
    }

    if ($install_torch -eq "yes" -or $install_torch -eq "y" -or $install_torch -eq "YES" -or $install_torch -eq "Y") {
        Print-Msg "重装 PyTorch 中"
        if ($USE_UV) {
            uv pip install $torch_ver.ToString().Split() $force_reinstall_arg
            if (!($?)) {
                Print-Msg "检测到 uv 安装 Python 软件包失败, 尝试回滚至 Pip 重试 Python 软件包安装"
                python -m pip install $torch_ver.ToString().Split() $force_reinstall_arg --no-warn-conflicts
            }
        } else {
            python -m pip install $torch_ver.ToString().Split() $force_reinstall_arg --no-warn-conflicts
        }
        if ($?) {
            Print-Msg "安装 PyTorch 成功"
        } else {
            Print-Msg "安装 PyTorch 失败, 终止 PyTorch 重装进程"
            if (!($BuildMode)) {
                Read-Host | Out-Null
            }
            exit 1
        }

        if ($xformers_ver -ne "") {
            Print-Msg "重装 xFormers 中"
            if ($USE_UV) {
                $current_xf_ver = Get-xFormers-Version
                if ($xformers_ver.Split("=")[-1] -ne $current_xf_ver) {
                    Print-Msg "卸载原有 xFormers 中"
                    python -m pip uninstall xformers -y
                }
                uv pip install $xformers_ver $force_reinstall_arg --no-deps
                if (!($?)) {
                    Print-Msg "检测到 uv 安装 Python 软件包失败, 尝试回滚至 Pip 重试 Python 软件包安装"
                    python -m pip install $xformers_ver $force_reinstall_arg --no-deps --no-warn-conflicts
                }
            } else {
                python -m pip install $xformers_ver $force_reinstall_arg --no-deps --no-warn-conflicts
            }
            if ($?) {
                Print-Msg "安装 xFormers 成功"
            } else {
                Print-Msg "安装 xFormers 失败, 终止 PyTorch 重装进程"
                if (!($BuildMode)) {
                    Read-Host | Out-Null
                }
                exit 1
            }
        }
    } else {
        Print-Msg "取消重装 PyTorch"
    }

    Print-Msg "退出 PyTorch 重装脚本"
    if (!($BuildMode)) {
        Read-Host | Out-Null
    }
}

###################

Main
