﻿param (
    [switch]$Help,
    [switch]$DisablePyPIMirror,
    [switch]$DisableProxy,
    [string]$UseCustomProxy
)
# Fooocus Installer 版本和检查更新间隔
$FOOOCUS_INSTALLER_VERSION = 190
$UPDATE_TIME_SPAN = 3600
# PyPI 镜像源
$PIP_INDEX_ADDR = "https://mirrors.cloud.tencent.com/pypi/simple"
$PIP_INDEX_ADDR_ORI = "https://pypi.python.org/simple"
$PIP_EXTRA_INDEX_ADDR = "https://mirrors.cernet.edu.cn/pypi/web/simple"
$PIP_EXTRA_INDEX_ADDR_ORI = ""
$PIP_FIND_ADDR = "https://mirrors.aliyun.com/pytorch-wheels/torch_stable.html"
$PIP_FIND_ADDR_ORI = "https://download.pytorch.org/whl/torch_stable.html"
$USE_PIP_MIRROR = if ((!(Test-Path "$PSScriptRoot/disable_pypi_mirror.txt")) -and (!($DisablePyPIMirror))) { $true } else { $false }
$PIP_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_INDEX_ADDR } else { $PIP_INDEX_ADDR_ORI }
$PIP_EXTRA_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_EXTRA_INDEX_ADDR } else { $PIP_EXTRA_INDEX_ADDR_ORI }
$PIP_FIND_MIRROR = if ($USE_PIP_MIRROR) { $PIP_FIND_ADDR } else { $PIP_FIND_ADDR_ORI }
$PIP_FIND_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121/torch_stable.html"
$PIP_EXTRA_INDEX_MIRROR_PYTORCH = "https://download.pytorch.org/whl"
$PIP_EXTRA_INDEX_MIRROR_XPU = "https://download.pytorch.org/whl/xpu"
$PIP_EXTRA_INDEX_MIRROR_CU118 = "https://download.pytorch.org/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121"
$PIP_EXTRA_INDEX_MIRROR_CU124 = "https://download.pytorch.org/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126 = "https://download.pytorch.org/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128 = "https://download.pytorch.org/whl/cu128"
$PIP_EXTRA_INDEX_MIRROR_CU118_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU124_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu128"
# uv 最低版本
$UV_MINIMUM_VER = "0.8"
# Aria2 最低版本
$ARIA2_MINIMUM_VER = "1.37.0"
# PATH
$PYTHON_PATH = "$PSScriptRoot/python"
$PYTHON_EXTRA_PATH = "$PSScriptRoot/Fooocus/python"
$PYTHON_SCRIPTS_PATH = "$PSScriptRoot/python/Scripts"
$PYTHON_SCRIPTS_EXTRA_PATH = "$PSScriptRoot/Fooocus/python/Scripts"
$GIT_PATH = "$PSScriptRoot/git/bin"
$GIT_EXTRA_PATH = "$PSScriptRoot/Fooocus/git/bin"
$Env:PATH = "$PYTHON_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_EXTRA_PATH$([System.IO.Path]::PathSeparator)$GIT_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_PATH$([System.IO.Path]::PathSeparator)$GIT_PATH$([System.IO.Path]::PathSeparator)$Env:PATH"
# 环境变量
$Env:PIP_INDEX_URL = "$PIP_INDEX_MIRROR"
$Env:PIP_EXTRA_INDEX_URL = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:PIP_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_DEFAULT_INDEX = "$PIP_INDEX_MIRROR"
$Env:UV_INDEX = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:UV_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_LINK_MODE = "copy"
$Env:UV_HTTP_TIMEOUT = 30
$Env:UV_CONCURRENT_DOWNLOADS = 50
$Env:UV_INDEX_STRATEGY = "unsafe-best-match"
$Env:UV_CONFIG_FILE = "nul"
$Env:PIP_CONFIG_FILE = "nul"
$Env:PIP_DISABLE_PIP_VERSION_CHECK = 1
$Env:PIP_NO_WARN_SCRIPT_LOCATION = 0
$Env:PIP_TIMEOUT = 30
$Env:PIP_RETRIES = 5
$Env:PIP_PREFER_BINARY = 1
$Env:PIP_YES = 1
$Env:PYTHONUTF8 = 1
$Env:PYTHONIOENCODING = "utf-8"
$Env:PYTHONUNBUFFERED = 1
$Env:PYTHONNOUSERSITE = 1
$Env:PYTHONFAULTHANDLER = 1
$Env:GRADIO_ANALYTICS_ENABLED = "False"
$Env:HF_HUB_DISABLE_SYMLINKS_WARNING = 1
$Env:BITSANDBYTES_NOWELCOME = 1
$Env:ClDeviceGlobalMemSizeAvailablePercent = 100
$Env:CUDA_MODULE_LOADING = "LAZY"
$Env:TORCH_CUDNN_V8_API_ENABLED = 1
$Env:USE_LIBUV = 0
$Env:SYCL_CACHE_PERSISTENT = 1
$Env:TF_CPP_MIN_LOG_LEVEL = 3
$Env:SAFETENSORS_FAST_GPU = 1
$Env:CACHE_HOME = "$PSScriptRoot/cache"
$Env:HF_HOME = "$PSScriptRoot/cache/huggingface"
$Env:MATPLOTLIBRC = "$PSScriptRoot/cache"
$Env:MODELSCOPE_CACHE = "$PSScriptRoot/cache/modelscope/hub"
$Env:MS_CACHE_HOME = "$PSScriptRoot/cache/modelscope/hub"
$Env:SYCL_CACHE_DIR = "$PSScriptRoot/cache/libsycl_cache"
$Env:TORCH_HOME = "$PSScriptRoot/cache/torch"
$Env:U2NET_HOME = "$PSScriptRoot/cache/u2net"
$Env:XDG_CACHE_HOME = "$PSScriptRoot/cache"
$Env:PIP_CACHE_DIR = "$PSScriptRoot/cache/pip"
$Env:PYTHONPYCACHEPREFIX = "$PSScriptRoot/cache/pycache"
$Env:TORCHINDUCTOR_CACHE_DIR = "$PSScriptRoot/cache/torchinductor"
$Env:TRITON_CACHE_DIR = "$PSScriptRoot/cache/triton"
$Env:UV_CACHE_DIR = "$PSScriptRoot/cache/uv"
$Env:UV_PYTHON = "$PSScriptRoot/python/python.exe"



# 帮助信息
function Get-Fooocus-Installer-Cmdlet-Help {
    $content = "
使用:
    .\settings.ps1 [-Help] [-DisablePyPIMirror] [-DisableProxy] [-UseCustomProxy <代理服务器地址>]

参数:
    -Help
        获取 Fooocus Installer 的帮助信息

    -DisablePyPIMirror
        禁用 PyPI 镜像源, 使用 PyPI 官方源下载 Python 软件包

    -DisableProxy
        禁用 Fooocus Installer 自动设置代理服务器

    -UseCustomProxy <代理服务器地址>
        使用自定义的代理服务器地址, 例如代理服务器地址为 http://127.0.0.1:10809, 则使用 -UseCustomProxy `"http://127.0.0.1:10809`" 设置代理服务器地址


更多的帮助信息请阅读 Fooocus Installer 使用文档: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md
".Trim()

    if ($Help) {
        Write-Host $content
        exit 0
    }
}


# 消息输出
function Print-Msg ($msg) {
    Write-Host "[$(Get-Date -Format "yyyy-MM-dd HH:mm:ss")]" -ForegroundColor Yellow -NoNewline
    Write-Host "[Fooocus Installer]" -ForegroundColor Cyan -NoNewline
    Write-Host ":: " -ForegroundColor Blue -NoNewline
    Write-Host "$msg"
}


# 显示 Fooocus Installer 版本
function Get-Fooocus-Installer-Version {
    $ver = $([string]$FOOOCUS_INSTALLER_VERSION).ToCharArray()
    $major = ($ver[0..($ver.Length - 3)])
    $minor = $ver[-2]
    $micro = $ver[-1]
    Print-Msg "Fooocus Installer 版本: v${major}.${minor}.${micro}"
}


# 代理配置
function Set-Proxy {
    $Env:NO_PROXY = "localhost,127.0.0.1,::1"
    # 检测是否禁用自动设置镜像源
    if ((Test-Path "$PSScriptRoot/disable_proxy.txt") -or ($DisableProxy)) {
        Print-Msg "检测到本地存在 disable_proxy.txt 代理配置文件 / -DisableProxy 命令行参数, 禁用自动设置代理"
        return
    }

    $internet_setting = Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings"
    if ((Test-Path "$PSScriptRoot/proxy.txt") -or ($UseCustomProxy)) { # 本地存在代理配置
        if ($UseCustomProxy) {
            $proxy_value = $UseCustomProxy
        } else {
            $proxy_value = Get-Content "$PSScriptRoot/proxy.txt"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到本地存在 proxy.txt 代理配置文件 / -UseCustomProxy 命令行参数, 已读取代理配置文件并设置代理"
    } elseif ($internet_setting.ProxyEnable -eq 1) { # 系统已设置代理
        $proxy_addr = $($internet_setting.ProxyServer)
        # 提取代理地址
        if (($proxy_addr -match "http=(.*?);") -or ($proxy_addr -match "https=(.*?);")) {
            $proxy_value = $matches[1]
            # 去除 http / https 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "http://${proxy_value}"
        } elseif ($proxy_addr -match "socks=(.*)") {
            $proxy_value = $matches[1]
            # 去除 socks 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "socks://${proxy_value}"
        } else {
            $proxy_value = "http://${proxy_addr}"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到系统设置了代理, 已读取系统中的代理配置并设置代理"
    }
}


# 获取代理设置
function Get-Proxy-Setting {
    if (Test-Path "$PSScriptRoot/disable_proxy.txt") {
        return "禁用"
    } elseif (Test-Path "$PSScriptRoot/proxy.txt") {
        return "启用 (使用自定义代理服务器: $(Get-Content "$PSScriptRoot/proxy.txt"))"
    } else {
        return "启用 (使用系统代理)"
    }
}


# 获取 Python 包管理器设置
function Get-Python-Package-Manager-Setting {
    if (Test-Path "$PSScriptRoot/disable_uv.txt") {
        return "Pip"
    } else {
        return "uv"
    }
}


# 获取 HuggingFace 镜像源设置
function Get-HuggingFace-Mirror-Setting {
    if (Test-Path "$PSScriptRoot/disable_hf_mirror.txt") {
        return "禁用"
    } elseif (Test-Path "$PSScriptRoot/hf_mirror.txt") {
        return "启用 (自定义镜像源: $(Get-Content "$PSScriptRoot/hf_mirror.txt"))"
    } else {
        return "启用 (默认镜像源)"
    }
}


# 获取 Github 镜像源设置
function Get-Github-Mirror-Setting {
    if (Test-Path "$PSScriptRoot/disable_gh_mirror.txt") {
        return "禁用"
    } elseif (Test-Path "$PSScriptRoot/gh_mirror.txt") {
        return "启用 (使用自定义镜像源: $(Get-Content "$PSScriptRoot/gh_mirror.txt"))"
    } else {
        return "启用 (自动选择镜像源)"
    }
}


# 获取 Fooocus Installer 自动检测更新设置
function Get-Fooocus-Installer-Auto-Check-Update-Setting {
    if (Test-Path "$PSScriptRoot/disable_update.txt") {
        return "禁用"
    } else {
        return "启用"
    }
}


# 获取 Fooocus Installer 自动应用更新设置
function Get-Fooocus-Installer-Auto-Apply-Update-Setting {
    if (Test-Path "$PSScriptRoot/disable_auto_apply_update.txt") {
        return "禁用"
    } else {
        return "启用"
    }
}


# 获取启动参数设置
function Get-Launch-Args-Setting {
    if (Test-Path "$PSScriptRoot/launch_args.txt") {
        return Get-Content "$PSScriptRoot/launch_args.txt"
    } else {
        return "无"
    }
}


# 获取自动创建快捷启动方式
function Get-Auto-Set-Launch-Shortcut-Setting {
    if (Test-Path "$PSScriptRoot/enable_shortcut.txt") {
        return "启用"
    } else {
        return "禁用"
    }
}


# 获取 PyPI 镜像源配置
function Get-PyPI-Mirror-Setting {
    if (!(Test-Path "$PSScriptRoot/disable_pypi_mirror.txt")) {
        return "启用"
    } else {
        return "禁用"
    }
}


# 获取 Fooocus 运行环境检测配置
function Get-Fooocus-Env-Check-Setting {
    if (!(Test-Path "$PSScriptRoot/disable_check_env.txt")) {
        return "启用"
    } else {
        return "禁用"
    }
}


# 获取 CUDA 内存分配器设置
function Get-PyTorch-CUDA-Memory-Alloc-Setting {
    if (!(Test-Path "$PSScriptRoot/disable_set_pytorch_cuda_memory_alloc.txt")) {
        return "启用"
    } else {
        return "禁用"
    }
}


# 获取用户输入
function Get-User-Input {
    return (Read-Host "========================================>").Trim()
}


# 代理设置
function Update-Proxy-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前代理设置: $(Get-Proxy-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用代理 (使用系统代理)"
        Print-Msg "2. 启用代理 (手动设置代理服务器)"
        Print-Msg "3. 禁用代理"
        Print-Msg "4. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_proxy.txt" -Force -Recurse 2> $null
                Remove-Item -Path "$PSScriptRoot/proxy.txt" -Force -Recurse 2> $null
                Print-Msg "启用代理成功, 当设置了系统代理后将自动读取并使用"
                break
            }
            2 {
                Print-Msg "请输入代理服务器地址"
                Print-Msg "提示: 代理地址可查看代理软件获取, 代理地址的格式如 http://127.0.0.1:10809、socks://127.0.0.1:7890 等, 输入后回车保存"
                $proxy_address = Get-User-Input
                Remove-Item -Path "$PSScriptRoot/disable_proxy.txt" -Force -Recurse 2> $null
                Set-Content -Encoding UTF8 -Path "$PSScriptRoot/proxy.txt" -Value $proxy_address
                Print-Msg "启用代理成功, 使用的代理服务器为: $proxy_address"
                break
            }
            3 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_proxy.txt" -Force > $null
                Remove-Item -Path "$PSScriptRoot/proxy.txt" -Force -Recurse 2> $null
                Print-Msg "禁用代理成功"
                break
            }
            4 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# Python 包管理器设置
function Update-Python-Package-Manager-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前使用的 Python 包管理器: $(Get-Python-Package-Manager-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 使用 uv 作为 Python 包管理器"
        Print-Msg "2. 使用 Pip 作为 Python 包管理器"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_uv.txt" -Force -Recurse 2> $null
                Print-Msg "设置 uv 作为 Python 包管理器成功"
                break
            }
            2 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_uv.txt" -Force > $null
                Print-Msg "设置 Pip 作为 Python 包管理器成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# 设置 HuggingFace 镜像源
function Update-HuggingFace-Mirror-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 HuggingFace 镜像源设置: $(Get-HuggingFace-Mirror-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用 HuggingFace 镜像源 (使用默认镜像源)"
        Print-Msg "2. 启用 HuggingFace 镜像源 (使用自定义 HuggingFace 镜像源)"
        Print-Msg "3. 禁用 HuggingFace 镜像源"
        Print-Msg "4. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_hf_mirror.txt" -Force -Recurse 2> $null
                Remove-Item -Path "$PSScriptRoot/hf_mirror.txt" -Force -Recurse 2> $null
                Print-Msg "启用 HuggingFace 镜像成功, 使用默认的 HuggingFace 镜像源 (https://hf-mirror.com)"
                break
            }
            2 {
                Print-Msg "请输入 HuggingFace 镜像源地址"
                Print-Msg "提示: 可用的 HuggingFace 镜像源有:"
                Print-Msg " https://hf-mirror.com"
                Print-Msg " https://huggingface.sukaka.top"
                Print-Msg "提示: 输入 HuggingFace 镜像源地址后回车保存"
                $huggingface_mirror_address = Get-User-Input
                Remove-Item -Path "$PSScriptRoot/disable_hf_mirror.txt" -Force -Recurse 2> $null
                Set-Content -Encoding UTF8 -Path "$PSScriptRoot/hf_mirror.txt" -Value $huggingface_mirror_address
                Print-Msg "启用 HuggingFace 镜像成功, 使用的 HuggingFace 镜像源为: $huggingface_mirror_address"
                break
            }
            3 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_hf_mirror.txt" -Force > $null
                Remove-Item -Path "$PSScriptRoot/hf_mirror.txt" -Force -Recurse 2> $null
                Print-Msg "禁用 HuggingFace 镜像成功"
                break
            }
            4 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# 设置 Github 镜像源
function Update-Github-Mirror-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 Github 镜像源设置: $(Get-Github-Mirror-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用 Github 镜像源 (自动检测可用的 Github 镜像源并使用)"
        Print-Msg "2. 启用 Github 镜像源 (使用自定义 Github 镜像源)"
        Print-Msg "3. 禁用 Github 镜像源"
        Print-Msg "4. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_gh_mirror.txt" -Force -Recurse 2> $null
                Remove-Item -Path "$PSScriptRoot/gh_mirror.txt" -Force -Recurse 2> $null
                Print-Msg "启用 Github 镜像成功, 在更新 Fooocus 时将自动检测可用的 Github 镜像源并使用"
                break
            }
            2 {
                Print-Msg "请输入 Github 镜像源地址"
                Print-Msg "提示: 可用的 Github 镜像源有: "
                Print-Msg " https://ghfast.top/https://github.com"
                Print-Msg " https://mirror.ghproxy.com/https://github.com"
                Print-Msg " https://ghproxy.net/https://github.com"
                Print-Msg " https://gh.api.99988866.xyz/https://github.com"
                Print-Msg " https://ghproxy.1888866.xyz/github.com"
                Print-Msg " https://slink.ltd/https://github.com"
                Print-Msg " https://github.boki.moe/github.com"
                Print-Msg " https://github.moeyy.xyz/https://github.com"
                Print-Msg " https://gh-proxy.net/https://github.com"
                Print-Msg " https://gh-proxy.ygxz.in/https://github.com"
                Print-Msg " https://wget.la/https://github.com"
                Print-Msg " https://kkgithub.com"
                Print-Msg " https://gh-proxy.com/https://github.com"
                Print-Msg " https://ghps.cc/https://github.com"
                Print-Msg " https://gh.idayer.com/https://github.com"
                Print-Msg " https://gitclone.com/github.com"
                Print-Msg "提示: 输入 Github 镜像源地址后回车保存"
                $github_mirror_address = Get-User-Input
                Remove-Item -Path "$PSScriptRoot/disable_gh_mirror.txt" -Force -Recurse 2> $null
                Set-Content -Encoding UTF8 -Path "$PSScriptRoot/gh_mirror.txt" -Value $github_mirror_address
                Print-Msg "启用 Github 镜像成功, 使用的 Github 镜像源为: $github_mirror_address"
                break
            }
            3 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_gh_mirror.txt" -Force > $null
                Remove-Item -Path "$PSScriptRoot/gh_mirror.txt" -Force -Recurse 2> $null
                Print-Msg "禁用 Github 镜像成功"
                break
            }
            4 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# Fooocus Installer 自动检查更新设置
function Update-Fooocus-Installer-Auto-Check-Update-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 Fooocus Installer 自动检测更新设置: $(Get-Fooocus-Installer-Auto-Check-Update-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用 Fooocus Installer 自动更新检查"
        Print-Msg "2. 禁用 Fooocus Installer 自动更新检查"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"
        Print-Msg "警告: 当 Fooocus Installer 有重要更新(如功能性修复)时, 禁用自动更新检查后将得不到及时提示"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_update.txt" -Force -Recurse 2> $null
                Print-Msg "启用 Fooocus Installer 自动更新检查成功"
                break
            }
            2 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_update.txt" -Force > $null
                Print-Msg "禁用 Fooocus Installer 自动更新检查成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# Fooocus Installer 自动应用更新设置
function Update-Fooocus-Installer-Auto-Apply-Update-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 Fooocus Installer 自动应用更新设置: $(Get-Fooocus-Installer-Auto-Apply-Update-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用 Fooocus Installer 自动应用更新"
        Print-Msg "2. 禁用 Fooocus Installer 自动应用更新"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_auto_apply_update.txt" -Force -Recurse 2> $null
                Print-Msg "启用 Fooocus Installer 自动应用更新成功"
                break
            }
            2 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_auto_apply_update.txt" -Force > $null
                Print-Msg "禁用 Fooocus Installer 自动应用更新成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# Fooocus 启动参数设置
function Update-Fooocus-Launch-Args-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 Fooocus 启动参数: $(Get-Launch-Args-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 设置 Fooocus 启动参数"
        Print-Msg "2. 删除 Fooocus 启动参数"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Print-Msg "请输入 Fooocus 启动参数"
                Print-Msg "提示: 保存启动参数后原有的启动参数将被覆盖, Fooocus 可用的启动参数可阅读: https://github.com/AUTOMATIC1111/Fooocus/wiki/Command-Line-Arguments-and-Settings"
                Print-Msg "输入启动参数后回车保存"
                $fooocus_launch_args = Get-User-Input
                Set-Content -Encoding UTF8 -Path "$PSScriptRoot/launch_args.txt" -Value $fooocus_launch_args
                Print-Msg "设置 Fooocus 启动参数成功, 使用的 Fooocus 启动参数为: $fooocus_launch_args"
                break
            }
            2 {
                Remove-Item -Path "$PSScriptRoot/launch_args.txt" -Force -Recurse 2> $null
                Print-Msg "删除 Fooocus 启动参数成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# 自动创建 Fooocus 快捷启动方式设置
function Auto-Set-Launch-Shortcut-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前自动创建 Fooocus 快捷启动方式设置: $(Get-Auto-Set-Launch-Shortcut-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用自动创建 Fooocus 快捷启动方式"
        Print-Msg "2. 禁用自动创建 Fooocus 快捷启动方式"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                New-Item -ItemType File -Path "$PSScriptRoot/enable_shortcut.txt" -Force > $null
                Print-Msg "启用自动创建 Fooocus 快捷启动方式成功"
                break
            }
            2 {
                Remove-Item -Path "$PSScriptRoot/enable_shortcut.txt" -Force -Recurse 2> $null
                Print-Msg "禁用自动创建 Fooocus 快捷启动方式成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# PyPI 镜像源设置
function PyPI-Mirror-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 PyPI 镜像源设置: $(Get-PyPI-Mirror-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用 PyPI 镜像源"
        Print-Msg "2. 禁用 PyPI 镜像源"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_pypi_mirror.txt" -Force -Recurse 2> $null
                Print-Msg "启用 PyPI 镜像源成功"
                break
            }
            2 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_pypi_mirror.txt" -Force > $null
                Print-Msg "禁用 PyPI 镜像源成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# CUDA 内存分配器设置
function PyTorch-CUDA-Memory-Alloc-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前自动设置 CUDA 内存分配器设置: $(Get-PyTorch-CUDA-Memory-Alloc-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用自动设置 CUDA 内存分配器"
        Print-Msg "2. 禁用自动设置 CUDA 内存分配器"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_set_pytorch_cuda_memory_alloc.txt" -Force -Recurse 2> $null
                Print-Msg "启用自动设置 CUDA 内存分配器成功"
                break
            }
            2 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_set_pytorch_cuda_memory_alloc.txt" -Force > $null
                Print-Msg "禁用自动设置 CUDA 内存分配器成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# Fooocus 运行环境检测设置
function Fooocus-Env-Check-Setting {
    while ($true) {
        $go_to = 0
        Print-Msg "当前 Fooocus 运行环境检测设置: $(Get-Fooocus-Env-Check-Setting)"
        Print-Msg "可选操作:"
        Print-Msg "1. 启用 Fooocus 运行环境检测"
        Print-Msg "2. 禁用 Fooocus 运行环境检测"
        Print-Msg "3. 返回"
        Print-Msg "提示: 输入数字后回车"

        $arg = Get-User-Input

        switch ($arg) {
            1 {
                Remove-Item -Path "$PSScriptRoot/disable_check_env.txt" -Force -Recurse 2> $null
                Print-Msg "启用 Fooocus 运行环境检测成功"
                break
            }
            2 {
                New-Item -ItemType File -Path "$PSScriptRoot/disable_check_env.txt" -Force > $null
                Print-Msg "禁用 Fooocus 运行环境检测成功"
                break
            }
            3 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }
}


# 检查 Fooocus Installer 更新
function Check-Fooocus-Installer-Update {
    # 可用的下载源
    $urls = @(
        "https://github.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://github.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitlab.com/licyk/sd-webui-all-in-one/-/raw/main/fooocus_installer.ps1"
    )
    $i = 0

    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null
    Set-Content -Encoding UTF8 -Path "$PSScriptRoot/update_time.txt" -Value $(Get-Date -Format "yyyy-MM-dd HH:mm:ss") # 记录更新时间

    ForEach ($url in $urls) {
        Print-Msg "检查 Fooocus Installer 更新中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$Env:CACHE_HOME/fooocus_installer.ps1"
            $latest_version = [int]$(
                Get-Content "$Env:CACHE_HOME/fooocus_installer.ps1" |
                Select-String -Pattern "FOOOCUS_INSTALLER_VERSION" |
                ForEach-Object { $_.ToString() }
            )[0].Split("=")[1].Trim()
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试检查 Fooocus Installer 更新中"
            } else {
                Print-Msg "检查 Fooocus Installer 更新失败"
                return
            }
        }
    }

    if ($latest_version -gt $FOOOCUS_INSTALLER_VERSION) {
        Print-Msg "Fooocus Installer 有新版本可用"
        Print-Msg "调用 Fooocus Installer 进行更新中"
        . "$Env:CACHE_HOME/fooocus_installer.ps1" -InstallPath "$PSScriptRoot" -UseUpdateMode
        $raw_params = $script:MyInvocation.Line -replace "^.*\.ps1[\s]*", ""
        Print-Msg "更新结束, 重新启动 Fooocus Installer 管理脚本中, 使用的命令行参数: $raw_params"
        Invoke-Expression "& `"$PSCommandPath`" $raw_params"
        exit 0
    } else {
        Print-Msg "Fooocus Installer 已是最新版本"
    }
}


# 检查环境完整性
function Check-Env {
    Print-Msg "检查环境完整性中"
    $broken = 0
    if ((Test-Path "$PSScriptRoot/python/python.exe") -or (Test-Path "$PSScriptRoot/Fooocus/python/python.exe")) {
        $python_status = "已安装"
    } else {
        $python_status = "未安装"
        $broken = 1
    }

    if ((Test-Path "$PSScriptRoot/git/bin/git.exe") -or (Test-Path "$PSScriptRoot/Fooocus/git/bin/git.exe")) {
        $git_status = "已安装"
    } else {
        $git_status = "未安装"
        $broken = 1
    }

    python -m pip show uv --quiet 2> $null
    if ($?) {
        $uv_status = "已安装"
    } else {
        $uv_status = "未安装"
        $broken = 1
    }

    if ((Test-Path "$PSScriptRoot/git/bin/aria2c.exe") -or (Test-Path "$PSScriptRoot/Fooocus/git/bin/aria2c.exe")) {
        $aria2_status = "已安装"
    } else {
        $aria2_status = "未安装"
        $broken = 1
    }

    if (Test-Path "$PSScriptRoot/Fooocus/launch.py") {
        $fooocus_status = "已安装"
    } else {
        $fooocus_status = "未安装"
        $broken = 1
    }

    python -m pip show torch --quiet 2> $null
    if ($?) {
        $torch_status = "已安装"
    } else {
        $torch_status = "未安装"
        $broken = 1
    }

    python -m pip show xformers --quiet 2> $null
    if ($?) {
        $xformers_status = "已安装"
    } else {
        $xformers_status = "未安装"
        $broken = 1
    }

    Print-Msg "-----------------------------------------------------"
    Print-Msg "当前环境:"
    Print-Msg "Python: $python_status"
    Print-Msg "Git: $git_status"
    Print-Msg "uv: $uv_status"
    Print-Msg "Aria2: $aria2_status"
    Print-Msg "PyTorch: $torch_status"
    Print-Msg "xFormers: $xformers_status"
    Print-Msg "Fooocus: $fooocus_status"
    Print-Msg "-----------------------------------------------------"
    if ($broken -eq 1) {
        Print-Msg "检测到环境出现组件缺失, 可尝试运行 Fooocus Installer 进行安装"
    } else {
        Print-Msg "当前环境无缺失组件"
    }
}


# 查看 Fooocus Installer 文档
function Get-Fooocus-Installer-Help-Docs {
    Print-Msg "调用浏览器打开 Fooocus Installer 文档中"
    Start-Process "https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md"
}


function Main {
    Print-Msg "初始化中"
    Get-Fooocus-Installer-Version
    Get-Fooocus-Installer-Cmdlet-Help
    Set-Proxy

    while ($true) {
        $go_to = 0
        Print-Msg "-----------------------------------------------------"
        Print-Msg "当前环境配置:"
        Print-Msg "代理设置: $(Get-Proxy-Setting)"
        Print-Msg "Python 包管理器: $(Get-Python-Package-Manager-Setting)"
        Print-Msg "HuggingFace 镜像源设置: $(Get-HuggingFace-Mirror-Setting)"
        Print-Msg "Github 镜像源设置: $(Get-Github-Mirror-Setting)"
        Print-Msg "Fooocus Installer 自动检查更新: $(Get-Fooocus-Installer-Auto-Check-Update-Setting)"
        Print-Msg "Fooocus Installer 自动应用更新: $(Get-Fooocus-Installer-Auto-Apply-Update-Setting)"
        Print-Msg "Fooocus 启动参数: $(Get-Launch-Args-Setting)"
        Print-Msg "自动创建 Fooocus 快捷启动方式设置: $(Get-Auto-Set-Launch-Shortcut-Setting)"
        Print-Msg "PyPI 镜像源设置: $(Get-PyPI-Mirror-Setting)"
        Print-Msg "自动设置 CUDA 内存分配器设置: $(Get-PyTorch-CUDA-Memory-Alloc-Setting)"
        Print-Msg "Fooocus 运行环境检测设置: $(Get-Fooocus-Env-Check-Setting)"
        Print-Msg "-----------------------------------------------------"
        Print-Msg "可选操作:"
        Print-Msg "1. 进入代理设置"
        Print-Msg "2. 进入 Python 包管理器设置"
        Print-Msg "3. 进入 HuggingFace 镜像源设置"
        Print-Msg "4. 进入 Github 镜像源设置"
        Print-Msg "5. 进入 Fooocus Installer 自动检查更新设置"
        Print-Msg "6. 进入 Fooocus Installer 自动应用更新设置"
        Print-Msg "7. 进入 Fooocus 启动参数设置"
        Print-Msg "8. 进入自动创建 Fooocus 快捷启动方式设置"
        Print-Msg "9. 进入 PyPI 镜像源设置"
        Print-Msg "10. 进入自动设置 CUDA 内存分配器设置"
        Print-Msg "11. 进入 Fooocus 运行环境检测设置"
        Print-Msg "12. 更新 Fooocus Installer 管理脚本"
        Print-Msg "13. 检查环境完整性"
        Print-Msg "14. 查看 Fooocus Installer 文档"
        Print-Msg "15. 退出 Fooocus Installer 设置"
        Print-Msg "提示: 输入数字后回车"
        $arg = Get-User-Input
        switch ($arg) {
            1 {
                Update-Proxy-Setting
                break
            }
            2 {
                Update-Python-Package-Manager-Setting
                break
            }
            3 {
                Update-HuggingFace-Mirror-Setting
                break
            }
            4 {
                Update-Github-Mirror-Setting
                break
            }
            5 {
                Update-Fooocus-Installer-Auto-Check-Update-Setting
                break
            }
            6 {
                Update-Fooocus-Installer-Auto-Apply-Update-Setting
                break
            }
            7 {
                Update-Fooocus-Launch-Args-Setting
                break
            }
            8 {
                Auto-Set-Launch-Shortcut-Setting
                break
            }
            9 {
                PyPI-Mirror-Setting
                break
            }
            10 {
                PyTorch-CUDA-Memory-Alloc-Setting
                break
            }
            11 {
                Fooocus-Env-Check-Setting
                break
            }
            12 {
                Check-Fooocus-Installer-Update
                break
            }
            13 {
                Check-Env
                break
            }
            14 {
                Get-Fooocus-Installer-Help-Docs
                break
            }
            15 {
                $go_to = 1
                break
            }
            Default {
                Print-Msg "输入有误, 请重试"
                break
            }
        }

        if ($go_to -eq 1) {
            Print-Msg "退出 Fooocus Installer 设置"
            break
        }
    }
}

###################

Main
Read-Host | Out-Null
