﻿param (
    [switch]$Help,
    [switch]$BuildMode,
    [int]$BuildWitchBranch,
    [switch]$DisablePyPIMirror,
    [switch]$DisableUpdate,
    [switch]$DisableProxy,
    [string]$UseCustomProxy,
    [switch]$DisableGithubMirror,
    [string]$UseCustomGithubMirror,
    [switch]$DisableAutoApplyUpdate
)
# Fooocus Installer 版本和检查更新间隔
$FOOOCUS_INSTALLER_VERSION = 190
$UPDATE_TIME_SPAN = 3600
# PyPI 镜像源
$PIP_INDEX_ADDR = "https://mirrors.cloud.tencent.com/pypi/simple"
$PIP_INDEX_ADDR_ORI = "https://pypi.python.org/simple"
$PIP_EXTRA_INDEX_ADDR = "https://mirrors.cernet.edu.cn/pypi/web/simple"
$PIP_EXTRA_INDEX_ADDR_ORI = ""
$PIP_FIND_ADDR = "https://mirrors.aliyun.com/pytorch-wheels/torch_stable.html"
$PIP_FIND_ADDR_ORI = "https://download.pytorch.org/whl/torch_stable.html"
$USE_PIP_MIRROR = if ((!(Test-Path "$PSScriptRoot/disable_pypi_mirror.txt")) -and (!($DisablePyPIMirror))) { $true } else { $false }
$PIP_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_INDEX_ADDR } else { $PIP_INDEX_ADDR_ORI }
$PIP_EXTRA_INDEX_MIRROR = if ($USE_PIP_MIRROR) { $PIP_EXTRA_INDEX_ADDR } else { $PIP_EXTRA_INDEX_ADDR_ORI }
$PIP_FIND_MIRROR = if ($USE_PIP_MIRROR) { $PIP_FIND_ADDR } else { $PIP_FIND_ADDR_ORI }
$PIP_FIND_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121/torch_stable.html"
$PIP_EXTRA_INDEX_MIRROR_PYTORCH = "https://download.pytorch.org/whl"
$PIP_EXTRA_INDEX_MIRROR_XPU = "https://download.pytorch.org/whl/xpu"
$PIP_EXTRA_INDEX_MIRROR_CU118 = "https://download.pytorch.org/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU121 = "https://download.pytorch.org/whl/cu121"
$PIP_EXTRA_INDEX_MIRROR_CU124 = "https://download.pytorch.org/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126 = "https://download.pytorch.org/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128 = "https://download.pytorch.org/whl/cu128"
$PIP_EXTRA_INDEX_MIRROR_CU118_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu118"
$PIP_EXTRA_INDEX_MIRROR_CU124_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu124"
$PIP_EXTRA_INDEX_MIRROR_CU126_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu126"
$PIP_EXTRA_INDEX_MIRROR_CU128_NJU = "https://mirror.nju.edu.cn/pytorch/whl/cu128"
# Github 镜像源
$GITHUB_MIRROR_LIST = @(
    "https://ghfast.top/https://github.com",
    "https://mirror.ghproxy.com/https://github.com",
    "https://ghproxy.net/https://github.com",
    "https://gh.api.99988866.xyz/https://github.com",
    "https://gh-proxy.com/https://github.com",
    "https://ghps.cc/https://github.com",
    "https://gh.idayer.com/https://github.com",
    "https://ghproxy.1888866.xyz/github.com",
    "https://slink.ltd/https://github.com",
    "https://github.boki.moe/github.com",
    "https://github.moeyy.xyz/https://github.com",
    "https://gh-proxy.net/https://github.com",
    "https://gh-proxy.ygxz.in/https://github.com",
    "https://wget.la/https://github.com",
    "https://kkgithub.com",
    "https://gitclone.com/github.com"
)
# uv 最低版本
$UV_MINIMUM_VER = "0.8"
# Aria2 最低版本
$ARIA2_MINIMUM_VER = "1.37.0"
# PATH
$PYTHON_PATH = "$PSScriptRoot/python"
$PYTHON_EXTRA_PATH = "$PSScriptRoot/Fooocus/python"
$PYTHON_SCRIPTS_PATH = "$PSScriptRoot/python/Scripts"
$PYTHON_SCRIPTS_EXTRA_PATH = "$PSScriptRoot/Fooocus/python/Scripts"
$GIT_PATH = "$PSScriptRoot/git/bin"
$GIT_EXTRA_PATH = "$PSScriptRoot/Fooocus/git/bin"
$Env:PATH = "$PYTHON_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_EXTRA_PATH$([System.IO.Path]::PathSeparator)$GIT_EXTRA_PATH$([System.IO.Path]::PathSeparator)$PYTHON_PATH$([System.IO.Path]::PathSeparator)$PYTHON_SCRIPTS_PATH$([System.IO.Path]::PathSeparator)$GIT_PATH$([System.IO.Path]::PathSeparator)$Env:PATH"
# 环境变量
$Env:PIP_INDEX_URL = "$PIP_INDEX_MIRROR"
$Env:PIP_EXTRA_INDEX_URL = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:PIP_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_DEFAULT_INDEX = "$PIP_INDEX_MIRROR"
$Env:UV_INDEX = if ($PIP_EXTRA_INDEX_MIRROR -ne $PIP_EXTRA_INDEX_MIRROR_PYTORCH) { "$PIP_EXTRA_INDEX_MIRROR $PIP_EXTRA_INDEX_MIRROR_PYTORCH".Trim() } else { $PIP_EXTRA_INDEX_MIRROR }
$Env:UV_FIND_LINKS = "$PIP_FIND_MIRROR"
$Env:UV_LINK_MODE = "copy"
$Env:UV_HTTP_TIMEOUT = 30
$Env:UV_CONCURRENT_DOWNLOADS = 50
$Env:UV_INDEX_STRATEGY = "unsafe-best-match"
$Env:UV_CONFIG_FILE = "nul"
$Env:PIP_CONFIG_FILE = "nul"
$Env:PIP_DISABLE_PIP_VERSION_CHECK = 1
$Env:PIP_NO_WARN_SCRIPT_LOCATION = 0
$Env:PIP_TIMEOUT = 30
$Env:PIP_RETRIES = 5
$Env:PIP_PREFER_BINARY = 1
$Env:PIP_YES = 1
$Env:PYTHONUTF8 = 1
$Env:PYTHONIOENCODING = "utf-8"
$Env:PYTHONUNBUFFERED = 1
$Env:PYTHONNOUSERSITE = 1
$Env:PYTHONFAULTHANDLER = 1
$Env:GRADIO_ANALYTICS_ENABLED = "False"
$Env:HF_HUB_DISABLE_SYMLINKS_WARNING = 1
$Env:BITSANDBYTES_NOWELCOME = 1
$Env:ClDeviceGlobalMemSizeAvailablePercent = 100
$Env:CUDA_MODULE_LOADING = "LAZY"
$Env:TORCH_CUDNN_V8_API_ENABLED = 1
$Env:USE_LIBUV = 0
$Env:SYCL_CACHE_PERSISTENT = 1
$Env:TF_CPP_MIN_LOG_LEVEL = 3
$Env:SAFETENSORS_FAST_GPU = 1
$Env:CACHE_HOME = "$PSScriptRoot/cache"
$Env:HF_HOME = "$PSScriptRoot/cache/huggingface"
$Env:MATPLOTLIBRC = "$PSScriptRoot/cache"
$Env:MODELSCOPE_CACHE = "$PSScriptRoot/cache/modelscope/hub"
$Env:MS_CACHE_HOME = "$PSScriptRoot/cache/modelscope/hub"
$Env:SYCL_CACHE_DIR = "$PSScriptRoot/cache/libsycl_cache"
$Env:TORCH_HOME = "$PSScriptRoot/cache/torch"
$Env:U2NET_HOME = "$PSScriptRoot/cache/u2net"
$Env:XDG_CACHE_HOME = "$PSScriptRoot/cache"
$Env:PIP_CACHE_DIR = "$PSScriptRoot/cache/pip"
$Env:PYTHONPYCACHEPREFIX = "$PSScriptRoot/cache/pycache"
$Env:TORCHINDUCTOR_CACHE_DIR = "$PSScriptRoot/cache/torchinductor"
$Env:TRITON_CACHE_DIR = "$PSScriptRoot/cache/triton"
$Env:UV_CACHE_DIR = "$PSScriptRoot/cache/uv"
$Env:UV_PYTHON = "$PSScriptRoot/python/python.exe"



# 帮助信息
function Get-Fooocus-Installer-Cmdlet-Help {
    $content = "
使用:
    .\switch_branch.ps1 [-Help] [-BuildMode] [-BuildWitchBranch <Fooocus 分支编号>] [-DisablePyPIMirror] [-DisableUpdate] [-DisableProxy] [-UseCustomProxy <代理服务器地址>] [-DisableGithubMirror] [-UseCustomGithubMirror <Github 镜像源地址>] [-DisableAutoApplyUpdate]

参数:
    -Help
        获取 Fooocus Installer 的帮助信息

    -BuildMode
        启用 Fooocus Installer 构建模式

    -BuildWitchBranch <Fooocus 分支编号>
        (需添加 -BuildMode 启用 Fooocus Installer 构建模式) Fooocus Installer 执行完基础安装流程后调用 Fooocus Installer 的 switch_branch.ps1 脚本, 根据 Fooocus 分支编号切换到对应的 Fooocus 分支
        Fooocus 分支编号可运行 switch_branch.ps1 脚本进行查看

    -DisablePyPIMirror
        禁用 PyPI 镜像源, 使用 PyPI 官方源下载 Python 软件包

    -DisableUpdate
        禁用 Fooocus Installer 更新检查

    -DisableProxy
        禁用 Fooocus Installer 自动设置代理服务器

    -UseCustomProxy <代理服务器地址>
        使用自定义的代理服务器地址, 例如代理服务器地址为 http://127.0.0.1:10809, 则使用 -UseCustomProxy `"http://127.0.0.1:10809`" 设置代理服务器地址

    -DisableGithubMirror
        禁用 Fooocus Installer 自动设置 Github 镜像源

    -UseCustomGithubMirror <Github 镜像站地址>
        使用自定义的 Github 镜像站地址
        可用的 Github 镜像站地址:
            https://ghfast.top/https://github.com
            https://mirror.ghproxy.com/https://github.com
            https://ghproxy.net/https://github.com
            https://gh.api.99988866.xyz/https://github.com
            https://gh-proxy.com/https://github.com
            https://ghps.cc/https://github.com
            https://gh.idayer.com/https://github.com
            https://ghproxy.1888866.xyz/github.com
            https://slink.ltd/https://github.com
            https://github.boki.moe/github.com
            https://github.moeyy.xyz/https://github.com
            https://gh-proxy.net/https://github.com
            https://gh-proxy.ygxz.in/https://github.com
            https://wget.la/https://github.com
            https://kkgithub.com
            https://gitclone.com/github.com

    -DisableAutoApplyUpdate
        禁用 Fooocus Installer 自动应用新版本更新


更多的帮助信息请阅读 Fooocus Installer 使用文档: https://github.com/licyk/sd-webui-all-in-one/blob/main/fooocus_installer.md
".Trim()

    if ($Help) {
        Write-Host $content
        exit 0
    }
}


# 消息输出
function Print-Msg ($msg) {
    Write-Host "[$(Get-Date -Format "yyyy-MM-dd HH:mm:ss")]" -ForegroundColor Yellow -NoNewline
    Write-Host "[Fooocus Installer]" -ForegroundColor Cyan -NoNewline
    Write-Host ":: " -ForegroundColor Blue -NoNewline
    Write-Host "$msg"
}


# 显示 Fooocus Installer 版本
function Get-Fooocus-Installer-Version {
    $ver = $([string]$FOOOCUS_INSTALLER_VERSION).ToCharArray()
    $major = ($ver[0..($ver.Length - 3)])
    $minor = $ver[-2]
    $micro = $ver[-1]
    Print-Msg "Fooocus Installer 版本: v${major}.${minor}.${micro}"
}


# Fooocus Installer 更新检测
function Check-Fooocus-Installer-Update {
    # 可用的下载源
    $urls = @(
        "https://github.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/raw/main/fooocus_installer.ps1",
        "https://github.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitee.com/licyk/sd-webui-all-in-one/releases/download/fooocus_installer/fooocus_installer.ps1",
        "https://gitlab.com/licyk/sd-webui-all-in-one/-/raw/main/fooocus_installer.ps1"
    )
    $i = 0

    New-Item -ItemType Directory -Path "$Env:CACHE_HOME" -Force > $null

    if ((Test-Path "$PSScriptRoot/disable_update.txt") -or ($DisableUpdate)) {
        Print-Msg "检测到 disable_update.txt 更新配置文件 / -DisableUpdate 命令行参数, 已禁用 Fooocus Installer 的自动检查更新功能"
        return
    }

    # 获取更新时间间隔
    try {
        $last_update_time = Get-Content "$PSScriptRoot/update_time.txt" 2> $null
        $last_update_time = Get-Date $last_update_time -Format "yyyy-MM-dd HH:mm:ss"
    }
    catch {
        $last_update_time = Get-Date 0 -Format "yyyy-MM-dd HH:mm:ss"
    }
    finally {
        $update_time = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
        $time_span = New-TimeSpan -Start $last_update_time -End $update_time
    }

    if ($time_span.TotalSeconds -gt $UPDATE_TIME_SPAN) {
        Set-Content -Encoding UTF8 -Path "$PSScriptRoot/update_time.txt" -Value $(Get-Date -Format "yyyy-MM-dd HH:mm:ss") # 记录更新时间
    } else {
        return
    }

    ForEach ($url in $urls) {
        Print-Msg "检查 Fooocus Installer 更新中"
        try {
            Invoke-WebRequest -Uri $url -OutFile "$Env:CACHE_HOME/fooocus_installer.ps1"
            $latest_version = [int]$(
                Get-Content "$Env:CACHE_HOME/fooocus_installer.ps1" |
                Select-String -Pattern "FOOOCUS_INSTALLER_VERSION" |
                ForEach-Object { $_.ToString() }
            )[0].Split("=")[1].Trim()
            break
        }
        catch {
            $i += 1
            if ($i -lt $urls.Length) {
                Print-Msg "重试检查 Fooocus Installer 更新中"
            } else {
                Print-Msg "检查 Fooocus Installer 更新失败"
                return
            }
        }
    }

    if ($latest_version -le $FOOOCUS_INSTALLER_VERSION) {
        Print-Msg "Fooocus Installer 已是最新版本"
        return
    }

    if (($DisableAutoApplyUpdate) -or (Test-Path "$PSScriptRoot/disable_auto_apply_update.txt")) {
        Print-Msg "检测到 Fooocus Installer 有新版本可用, 是否进行更新 (yes/no) ?"
        Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
        $arg = (Read-Host "========================================>").Trim()
        if (!($arg -eq "yes" -or $arg -eq "y" -or $arg -eq "YES" -or $arg -eq "Y")) {
            Print-Msg "跳过 Fooocus Installer 更新"
            return
        }
    } else {
        Print-Msg "检测到 Fooocus Installer 有新版本可用"
    }

    Print-Msg "调用 Fooocus Installer 进行更新中"
    . "$Env:CACHE_HOME/fooocus_installer.ps1" -InstallPath "$PSScriptRoot" -UseUpdateMode
    $raw_params = $script:MyInvocation.Line -replace "^.*\.ps1[\s]*", ""
    Print-Msg "更新结束, 重新启动 Fooocus Installer 管理脚本中, 使用的命令行参数: $raw_params"
    Invoke-Expression "& `"$PSCommandPath`" $raw_params"
    exit 0
}


# 代理配置
function Set-Proxy {
    $Env:NO_PROXY = "localhost,127.0.0.1,::1"
    # 检测是否禁用自动设置镜像源
    if ((Test-Path "$PSScriptRoot/disable_proxy.txt") -or ($DisableProxy)) {
        Print-Msg "检测到本地存在 disable_proxy.txt 代理配置文件 / -DisableProxy 命令行参数, 禁用自动设置代理"
        return
    }

    $internet_setting = Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings"
    if ((Test-Path "$PSScriptRoot/proxy.txt") -or ($UseCustomProxy)) { # 本地存在代理配置
        if ($UseCustomProxy) {
            $proxy_value = $UseCustomProxy
        } else {
            $proxy_value = Get-Content "$PSScriptRoot/proxy.txt"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到本地存在 proxy.txt 代理配置文件 / -UseCustomProxy 命令行参数, 已读取代理配置文件并设置代理"
    } elseif ($internet_setting.ProxyEnable -eq 1) { # 系统已设置代理
        $proxy_addr = $($internet_setting.ProxyServer)
        # 提取代理地址
        if (($proxy_addr -match "http=(.*?);") -or ($proxy_addr -match "https=(.*?);")) {
            $proxy_value = $matches[1]
            # 去除 http / https 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "http://${proxy_value}"
        } elseif ($proxy_addr -match "socks=(.*)") {
            $proxy_value = $matches[1]
            # 去除 socks 前缀
            $proxy_value = $proxy_value.ToString().Replace("http://", "").Replace("https://", "")
            $proxy_value = "socks://${proxy_value}"
        } else {
            $proxy_value = "http://${proxy_addr}"
        }
        $Env:HTTP_PROXY = $proxy_value
        $Env:HTTPS_PROXY = $proxy_value
        Print-Msg "检测到系统设置了代理, 已读取系统中的代理配置并设置代理"
    }
}


# Github 镜像源
function Set-Github-Mirror {
    $Env:GIT_CONFIG_GLOBAL = "$PSScriptRoot/.gitconfig" # 设置 Git 配置文件路径
    if (Test-Path "$PSScriptRoot/.gitconfig") {
        Remove-Item -Path "$PSScriptRoot/.gitconfig" -Force -Recurse
    }

    # 默认 Git 配置
    git config --global --add safe.directory "*"
    git config --global core.longpaths true

    if ((Test-Path "$PSScriptRoot/disable_gh_mirror.txt") -or ($DisableGithubMirror)) { # 禁用 Github 镜像源
        Print-Msg "检测到本地存在 disable_gh_mirror.txt Github 镜像源配置文件 / -DisableGithubMirror 命令行参数, 禁用 Github 镜像源"
        return
    }

    # 使用自定义 Github 镜像源
    if ((Test-Path "$PSScriptRoot/gh_mirror.txt") -or ($UseCustomGithubMirror)) {
        if ($UseCustomGithubMirror) {
            $github_mirror = $UseCustomGithubMirror
        } else {
            $github_mirror = Get-Content "$PSScriptRoot/gh_mirror.txt"
        }
        git config --global url."$github_mirror".insteadOf "https://github.com"
        Print-Msg "检测到本地存在 gh_mirror.txt Github 镜像源配置文件 / -UseCustomGithubMirror 命令行参数, 已读取 Github 镜像源配置文件并设置 Github 镜像源"
        return
    }

    # 自动检测可用镜像源并使用
    $status = 0
    ForEach($i in $GITHUB_MIRROR_LIST) {
        Print-Msg "测试 Github 镜像源: $i"
        if (Test-Path "$Env:CACHE_HOME/github-mirror-test") {
            Remove-Item -Path "$Env:CACHE_HOME/github-mirror-test" -Force -Recurse
        }
        git clone "$i/licyk/empty" "$Env:CACHE_HOME/github-mirror-test" --quiet
        if ($?) {
            Print-Msg "该 Github 镜像源可用"
            $github_mirror = $i
            $status = 1
            break
        } else {
            Print-Msg "镜像源不可用, 更换镜像源进行测试"
        }
    }

    if (Test-Path "$Env:CACHE_HOME/github-mirror-test") {
        Remove-Item -Path "$Env:CACHE_HOME/github-mirror-test" -Force -Recurse
    }

    if ($status -eq 0) {
        Print-Msg "无可用 Github 镜像源, 取消使用 Github 镜像源"
    } else {
        Print-Msg "设置 Github 镜像源"
        git config --global url."$github_mirror".insteadOf "https://github.com"
    }
}


# 获取 Fooocus 分支
function Get-Fooocus-Branch {
    $remote = $(git -C "$PSScriptRoot/Fooocus" remote get-url origin)
    $ref = $(git -C "$PSScriptRoot/Fooocus" symbolic-ref --quiet HEAD 2> $null)
    if ($ref -eq $null) {
        $ref = $(git -C "$PSScriptRoot/Fooocus" show -s --format="%h")
    }

    return "$($remote.Split("/")[-2])/$($remote.Split("/")[-1]) $([System.IO.Path]::GetFileName($ref))"
}


# 切换 Fooocus 分支
function Switch-Fooocus-Branch ($remote, $branch, $use_submod) {
    $fooocus_path = "$PSScriptRoot/Fooocus"
    $preview_url = $(git -C "$fooocus_path" remote get-url origin)

    Set-Github-Mirror # 设置 Github 镜像源

    Print-Msg "Fooocus 远程源替换: $preview_url -> $remote"
    git -C "$fooocus_path" remote set-url origin "$remote" # 替换远程源

    # 处理 Git 子模块
    if ($use_submod) {
        Print-Msg "更新 Fooocus 的 Git 子模块信息"
        git -C "$fooocus_path" submodule update --init --recursive
    } else {
        Print-Msg "禁用 Fooocus 的 Git 子模块"
        git -C "$fooocus_path" submodule deinit --all -f
    }

    Print-Msg "拉取 Fooocus 远程源更新"
    git -C "$fooocus_path" fetch # 拉取远程源内容
    if ($?) {
        if ($use_submod) {
            Print-Msg "清理原有的 Git 子模块"
            git -C "$fooocus_path" submodule deinit --all -f
        }
        Print-Msg "切换 Fooocus 分支至 $branch"

        # 本地分支不存在时创建一个分支
        git -C "$fooocus_path" show-ref --verify --quiet "refs/heads/${branch}"
        if (!($?)) {
            git -C "$fooocus_path" branch "${branch}"
        }

        git -C "$fooocus_path" checkout "${branch}" --force # 切换分支
        Print-Msg "应用 Fooocus 远程源的更新"
        if ($use_submod) {
            Print-Msg "更新 Fooocus 的 Git 子模块信息"
            git -C "$fooocus_path" reset --hard "origin/$branch"
            git -C "$fooocus_path" submodule deinit --all -f
            git -C "$fooocus_path" submodule update --init --recursive
        }
        if ($use_submod) {
            git -C "$fooocus_path" reset --recurse-submodules --hard "origin/$branch" # 切换到最新的提交内容上
        } else {
            git -C "$fooocus_path" reset --hard "origin/$branch" # 切换到最新的提交内容上
        }
        Print-Msg "切换 Fooocus 分支完成"
        $global:status = $true
    } else {
        Print-Msg "拉取 Fooocus 远程源更新失败, 取消分支切换"
        Print-Msg "尝试回退 Fooocus 的更改"
        git -C "$fooocus_path" remote set-url origin "$preview_url"
        if ($use_submod) {
            git -C "$fooocus_path" submodule deinit --all -f
        } else {
            git -C "$fooocus_path" submodule update --init --recursive
        }
        Print-Msg "回退 Fooocus 分支更改完成"
        Print-Msg "切换 Fooocus 分支更改失败"
        $global:status = $false
    }
}


function Main {
    Print-Msg "初始化中"
    Get-Fooocus-Installer-Version
    Get-Fooocus-Installer-Cmdlet-Help
    Set-Proxy
    if ($BuildMode) {
        Print-Msg "Fooocus Installer 构建模式已启用, 跳过 Fooocus Installer 更新检查"
    } else {
        Check-Fooocus-Installer-Update
    }

    if (!(Test-Path "$PSScriptRoot/Fooocus")) {
        Print-Msg "在 $PSScriptRoot 路径中未找到 Fooocus 文件夹, 请检查 Fooocus 是否已正确安装, 或者尝试运行 Fooocus Installer 进行修复"
        Read-Host | Out-Null
        return
    }

    $content = "
-----------------------------------------------------
- 1、lllyasviel - Fooocus 分支
- 2、runew0lf - RuinedFooocus 分支
- 3、MoonRide303 - Fooocus-MRE 分支
-----------------------------------------------------
".Trim()

    $to_exit = 0

    while ($True) {
        Print-Msg "Fooocus 分支列表"
        $go_to = 0
        Write-Host $content
        Print-Msg "当前 Fooocus 分支: $(Get-Fooocus-Branch)"
        Print-Msg "请选择 Fooocus 分支"
        Print-Msg "提示: 输入数字后回车, 或者输入 exit 退出 Fooocus 分支切换脚本"
        if ($BuildMode) {
            $go_to = 1
            $arg = $BuildWitchBranch
        } else {
            $arg = (Read-Host "========================================>").Trim()
        }

        switch ($arg) {
            1 {
                $remote = "https://github.com/lllyasviel/Fooocus"
                $branch = "main"
                $branch_name = "lllyasviel - Fooocus 分支"
                $use_submod = $false
                $go_to = 1
            }
            2 {
                $remote = "https://github.com/runew0lf/RuinedFooocus"
                $branch = "main"
                $branch_name = "runew0lf - RuinedFooocus 分支"
                $use_submod = $false
                $go_to = 1
            }
            3 {
                $remote = "https://github.com/MoonRide303/Fooocus-MRE"
                $branch = "moonride-main"
                $branch_name = "MoonRide303 - Fooocus-MRE 分支"
                $use_submod = $false
                $go_to = 1
            }
            exit {
                Print-Msg "退出 Fooocus 分支切换脚本"
                $to_exit = 1
                $go_to = 1
            }
            Default {
                Print-Msg "输入有误, 请重试"
            }
        }

        if ($go_to -eq 1) {
            break
        }
    }

    if ($to_exit -eq 1) {
        Read-Host | Out-Null
        exit 0
    }

    Print-Msg "是否切换 Fooocus 分支到 $branch_name ?"
    Print-Msg "提示: 输入 yes 确认或 no 取消 (默认为 no)"
    if ($BuildMode) {
        $operate = "yes"
    } else {
        $operate = (Read-Host "========================================>").Trim()
    }

    if ($operate -eq "yes" -or $operate -eq "y" -or $operate -eq "YES" -or $operate -eq "Y") {
        Print-Msg "开始切换 Fooocus 分支"
        Switch-Fooocus-Branch $remote $branch $use_submod
        if ($status) {
            Print-Msg "切换 Fooocus 分支成功"
        } else {
            Print-Msg "切换 Fooocus 分支失败, 可尝试重新运行 Fooocus 分支切换脚本"
        }
    } else {
        Print-Msg "取消切换 Fooocus 分支"
    }
    Print-Msg "退出 Fooocus 分支切换脚本"

    if (!($BuildMode)) {
        Read-Host | Out-Null
    }
}

###################

Main
