<a id="revChatGPT.V1"></a>

# revChatGPT.V1

Standard ChatGPT

<a id="revChatGPT.V1.generate_random_hex"></a>

#### generate\_random\_hex

```python
def generate_random_hex(length: int = 17) -> str
```

Generate a random hex string

**Arguments**:

- `length` _int, optional_ - Length of the hex string. Defaults to 17.


**Returns**:

- `str` - Random hex string

<a id="revChatGPT.V1.random_int"></a>

#### random\_int

```python
def random_int(min: int, max: int) -> int
```

Generate a random integer

**Arguments**:

- `min` _int_ - Minimum value
- `max` _int_ - Maximum value


**Returns**:

- `int` - Random integer

<a id="revChatGPT.V1.logger"></a>

#### logger

```python
def logger(is_timed: bool)
```

Logger decorator

**Arguments**:

- `is_timed` _bool_ - Whether to include function running time in exit log


**Returns**:

- `_type_` - decorated function

<a id="revChatGPT.V1.get_arkose_token"></a>

#### get\_arkose\_token

```python
def get_arkose_token(download_images: bool = True,
                     solver: function = captcha_solver) -> str
```

The solver function should take in a list of images in base64 and a dict of challenge details
and return the index of the image that matches the challenge details

Challenge details:
    game_type: str - Audio or Image
    instructions: str - Instructions for the captcha
    URLs: list[str] - URLs of the images or audio files

<a id="revChatGPT.V1.Chatbot"></a>

## Chatbot Objects

```python
class Chatbot()
```

Chatbot class for ChatGPT

<a id="revChatGPT.V1.Chatbot.__init__"></a>

#### \_\_init\_\_

```python
@logger(is_timed=True)
def __init__(config: dict[str, str],
             conversation_id: str | None = None,
             parent_id: str | None = None,
             lazy_loading: bool = True,
             base_url: str | None = None,
             captcha_solver: function = captcha_solver,
             captcha_download_images: bool = True) -> None
```

Initialize a chatbot

**Arguments**:

- `config` _dict[str, str]_ - Login and proxy info. Example:
  {
- `"access_token"` - "<access_token>"
- `"proxy"` - "<proxy_url_string>",
- `"model"` - "<model_name>",
- `"plugin"` - "<plugin_id>",
  }
  More details on these are available at https://github.com/acheong08/ChatGPT#configuration
- `conversation_id` _str | None, optional_ - Id of the conversation to continue on. Defaults to None.
- `parent_id` _str | None, optional_ - Id of the previous response message to continue on. Defaults to None.
- `lazy_loading` _bool, optional_ - Whether to load only the active conversation. Defaults to True.
- `base_url` _str | None, optional_ - Base URL of the ChatGPT server. Defaults to None.
- `captcha_solver` _function, optional_ - Function to solve captcha. Defaults to captcha_solver.
- `captcha_download_images` _bool, optional_ - Whether to download captcha images. Defaults to True.


**Raises**:

- `Exception` - _description_

<a id="revChatGPT.V1.Chatbot.set_access_token"></a>

#### set\_access\_token

```python
@logger(is_timed=False)
def set_access_token(access_token: str) -> None
```

Set access token in request header and self.config, then cache it to file.

**Arguments**:

- `access_token` _str_ - access_token

<a id="revChatGPT.V1.Chatbot.login"></a>

#### login

```python
@logger(is_timed=True)
def login() -> None
```

Login to OpenAI by email and password

<a id="revChatGPT.V1.Chatbot.post_messages"></a>

#### post\_messages

```python
@logger(is_timed=True)
def post_messages(messages: list[dict],
                  conversation_id: str | None = None,
                  parent_id: str | None = None,
                  plugin_ids: list = [],
                  model: str | None = None,
                  auto_continue: bool = False,
                  timeout: float = 360,
                  **kwargs) -> Generator[dict, None, None]
```

Ask a question to the chatbot

**Arguments**:

- `messages` _list[dict]_ - The messages to send
- `conversation_id` _str | None, optional_ - UUID for the conversation to continue on. Defaults to None.
- `parent_id` _str | None, optional_ - UUID for the message to continue on. Defaults to None.
- `model` _str | None, optional_ - The model to use. Defaults to None.
- `auto_continue` _bool, optional_ - Whether to continue the conversation automatically. Defaults to False.
- `timeout` _float, optional_ - Timeout for getting the full response, unit is second. Defaults to 360.

- `Yields` - Generator[dict, None, None] - The response from the chatbot
- `dict` - {
- `"message"` - str,
- `"conversation_id"` - str,
- `"parent_id"` - str,
- `"model"` - str,
- `"finish_details"` - str, # "max_tokens" or "stop"
- `"end_turn"` - bool,
- `"recipient"` - str,
- `"citations"` - list[dict],
  }

<a id="revChatGPT.V1.Chatbot.ask"></a>

#### ask

```python
@logger(is_timed=True)
def ask(prompt: str,
        conversation_id: str | None = None,
        parent_id: str = "",
        model: str = "",
        plugin_ids: list = [],
        auto_continue: bool = False,
        timeout: float = 360,
        **kwargs) -> Generator[dict, None, None]
```

Ask a question to the chatbot

**Arguments**:

- `prompt` _str_ - The question
- `conversation_id` _str, optional_ - UUID for the conversation to continue on. Defaults to None.
- `parent_id` _str, optional_ - UUID for the message to continue on. Defaults to "".
- `model` _str, optional_ - The model to use. Defaults to "".
- `auto_continue` _bool, optional_ - Whether to continue the conversation automatically. Defaults to False.
- `timeout` _float, optional_ - Timeout for getting the full response, unit is second. Defaults to 360.

- `Yields` - The response from the chatbot
- `dict` - {
- `"message"` - str,
- `"conversation_id"` - str,
- `"parent_id"` - str,
- `"model"` - str,
- `"finish_details"` - str, # "max_tokens" or "stop"
- `"end_turn"` - bool,
- `"recipient"` - str,
  }

<a id="revChatGPT.V1.Chatbot.continue_write"></a>

#### continue\_write

```python
@logger(is_timed=True)
def continue_write(conversation_id: str | None = None,
                   parent_id: str = "",
                   model: str = "",
                   auto_continue: bool = False,
                   timeout: float = 360) -> Generator[dict, None, None]
```

let the chatbot continue to write.

**Arguments**:

- `conversation_id` _str | None, optional_ - UUID for the conversation to continue on. Defaults to None.
- `parent_id` _str, optional_ - UUID for the message to continue on. Defaults to None.
- `model` _str, optional_ - The model to use. Defaults to None.
- `auto_continue` _bool, optional_ - Whether to continue the conversation automatically. Defaults to False.
- `timeout` _float, optional_ - Timeout for getting the full response, unit is second. Defaults to 360.


**Yields**:

- `dict` - {
- `"message"` - str,
- `"conversation_id"` - str,
- `"parent_id"` - str,
- `"model"` - str,
- `"finish_details"` - str, # "max_tokens" or "stop"
- `"end_turn"` - bool,
- `"recipient"` - str,
  }

<a id="revChatGPT.V1.Chatbot.get_conversations"></a>

#### get\_conversations

```python
@logger(is_timed=True)
def get_conversations(offset: int = 0,
                      limit: int = 20,
                      encoding: str | None = None) -> list
```

Get conversations

**Arguments**:

- `offset`: Integer
- `limit`: Integer

<a id="revChatGPT.V1.Chatbot.get_msg_history"></a>

#### get\_msg\_history

```python
@logger(is_timed=True)
def get_msg_history(convo_id: str, encoding: str | None = None) -> list
```

Get message history

**Arguments**:

- `id`: UUID of conversation
- `encoding`: String

<a id="revChatGPT.V1.Chatbot.share_conversation"></a>

#### share\_conversation

```python
def share_conversation(title: str = None,
                       convo_id: str = None,
                       node_id: str = None,
                       anonymous: bool = True) -> str
```

Creates a share link to a conversation

**Arguments**:

- `convo_id`: UUID of conversation
- `node_id`: UUID of node
- `anonymous`: Boolean
- `title`: String
Returns:
    str: A URL to the shared link

<a id="revChatGPT.V1.Chatbot.gen_title"></a>

#### gen\_title

```python
@logger(is_timed=True)
def gen_title(convo_id: str, message_id: str) -> str
```

Generate title for conversation

**Arguments**:

- `id`: UUID of conversation
- `message_id`: UUID of message

<a id="revChatGPT.V1.Chatbot.change_title"></a>

#### change\_title

```python
@logger(is_timed=True)
def change_title(convo_id: str, title: str) -> None
```

Change title of conversation

**Arguments**:

- `id`: UUID of conversation
- `title`: String

<a id="revChatGPT.V1.Chatbot.delete_conversation"></a>

#### delete\_conversation

```python
@logger(is_timed=True)
def delete_conversation(convo_id: str) -> None
```

Delete conversation

**Arguments**:

- `id`: UUID of conversation

<a id="revChatGPT.V1.Chatbot.clear_conversations"></a>

#### clear\_conversations

```python
@logger(is_timed=True)
def clear_conversations() -> None
```

Delete all conversations

<a id="revChatGPT.V1.Chatbot.reset_chat"></a>

#### reset\_chat

```python
@logger(is_timed=False)
def reset_chat() -> None
```

Reset the conversation ID and parent ID.

**Returns**:

None

<a id="revChatGPT.V1.Chatbot.rollback_conversation"></a>

#### rollback\_conversation

```python
@logger(is_timed=False)
def rollback_conversation(num: int = 1) -> None
```

Rollback the conversation.

**Arguments**:

- `num`: Integer. The number of messages to rollback

**Returns**:

None

<a id="revChatGPT.V1.Chatbot.get_plugins"></a>

#### get\_plugins

```python
@logger(is_timed=True)
def get_plugins(offset: int = 0, limit: int = 250, status: str = "approved")
```

Get plugins

**Arguments**:

- `offset`: Integer. Offset (Only supports 0)
- `limit`: Integer. Limit (Only below 250)
- `status`: String. Status of plugin (approved)

<a id="revChatGPT.V1.Chatbot.install_plugin"></a>

#### install\_plugin

```python
@logger(is_timed=True)
def install_plugin(plugin_id: str)
```

Install plugin by ID

**Arguments**:

- `plugin_id`: String. ID of plugin

<a id="revChatGPT.V1.Chatbot.get_unverified_plugin"></a>

#### get\_unverified\_plugin

```python
@logger(is_timed=True)
def get_unverified_plugin(domain: str, install: bool = True) -> dict
```

Get unverified plugin by domain

**Arguments**:

- `domain`: String. Domain of plugin
- `install`: Boolean. Install plugin if found

<a id="revChatGPT.V1.AsyncChatbot"></a>

## AsyncChatbot Objects

```python
class AsyncChatbot(Chatbot)
```

Async Chatbot class for ChatGPT

<a id="revChatGPT.V1.AsyncChatbot.__init__"></a>

#### \_\_init\_\_

```python
def __init__(config: dict,
             conversation_id: str | None = None,
             parent_id: str | None = None,
             base_url: str | None = None,
             lazy_loading: bool = True) -> None
```

Same as Chatbot class, but with async methods.

<a id="revChatGPT.V1.AsyncChatbot.post_messages"></a>

#### post\_messages

```python
async def post_messages(messages: list[dict],
                        conversation_id: str | None = None,
                        parent_id: str | None = None,
                        plugin_ids: list = [],
                        model: str | None = None,
                        auto_continue: bool = False,
                        timeout: float = 360,
                        **kwargs) -> AsyncGenerator[dict, None]
```

Post messages to the chatbot

**Arguments**:

- `messages` _list[dict]_ - the messages to post
- `conversation_id` _str | None, optional_ - UUID for the conversation to continue on. Defaults to None.
- `parent_id` _str | None, optional_ - UUID for the message to continue on. Defaults to None.
- `model` _str | None, optional_ - The model to use. Defaults to None.
- `auto_continue` _bool, optional_ - Whether to continue the conversation automatically. Defaults to False.
- `timeout` _float, optional_ - Timeout for getting the full response, unit is second. Defaults to 360.


**Yields**:

  AsyncGenerator[dict, None]: The response from the chatbot
  {
- `"message"` - str,
- `"conversation_id"` - str,
- `"parent_id"` - str,
- `"model"` - str,
- `"finish_details"` - str,
- `"end_turn"` - bool,
- `"recipient"` - str,
- `"citations"` - list[dict],
  }

<a id="revChatGPT.V1.AsyncChatbot.ask"></a>

#### ask

```python
async def ask(prompt: str,
              conversation_id: str | None = None,
              parent_id: str = "",
              model: str = "",
              plugin_ids: list = [],
              auto_continue: bool = False,
              timeout: int = 360,
              **kwargs) -> AsyncGenerator[dict, None]
```

Ask a question to the chatbot

**Arguments**:

- `prompt` _str_ - The question to ask
- `conversation_id` _str | None, optional_ - UUID for the conversation to continue on. Defaults to None.
- `parent_id` _str, optional_ - UUID for the message to continue on. Defaults to "".
- `model` _str, optional_ - The model to use. Defaults to "".
- `auto_continue` _bool, optional_ - Whether to continue the conversation automatically. Defaults to False.
- `timeout` _float, optional_ - Timeout for getting the full response, unit is second. Defaults to 360.


**Yields**:

  AsyncGenerator[dict, None]: The response from the chatbot
  {
- `"message"` - str,
- `"conversation_id"` - str,
- `"parent_id"` - str,
- `"model"` - str,
- `"finish_details"` - str,
- `"end_turn"` - bool,
- `"recipient"` - str,
  }

<a id="revChatGPT.V1.AsyncChatbot.continue_write"></a>

#### continue\_write

```python
async def continue_write(conversation_id: str | None = None,
                         parent_id: str = "",
                         model: str = "",
                         auto_continue: bool = False,
                         timeout: float = 360) -> AsyncGenerator[dict, None]
```

let the chatbot continue to write

**Arguments**:

- `conversation_id` _str | None, optional_ - UUID for the conversation to continue on. Defaults to None.
- `parent_id` _str, optional_ - UUID for the message to continue on. Defaults to None.
- `model` _str, optional_ - Model to use. Defaults to None.
- `auto_continue` _bool, optional_ - Whether to continue writing automatically. Defaults to False.
- `timeout` _float, optional_ - Timeout for getting the full response, unit is second. Defaults to 360.



**Yields**:

  AsyncGenerator[dict, None]: The response from the chatbot
  {
- `"message"` - str,
- `"conversation_id"` - str,
- `"parent_id"` - str,
- `"model"` - str,
- `"finish_details"` - str,
- `"end_turn"` - bool,
- `"recipient"` - str,
  }

<a id="revChatGPT.V1.AsyncChatbot.get_conversations"></a>

#### get\_conversations

```python
async def get_conversations(offset: int = 0, limit: int = 20) -> list
```

Get conversations

**Arguments**:

- `offset`: Integer
- `limit`: Integer

<a id="revChatGPT.V1.AsyncChatbot.get_msg_history"></a>

#### get\_msg\_history

```python
async def get_msg_history(convo_id: str,
                          encoding: str | None = "utf-8") -> dict
```

Get message history

**Arguments**:

- `id`: UUID of conversation

<a id="revChatGPT.V1.AsyncChatbot.share_conversation"></a>

#### share\_conversation

```python
async def share_conversation(title: str = None,
                             convo_id: str = None,
                             node_id: str = None,
                             anonymous: bool = True) -> str
```

Creates a share link to a conversation

**Arguments**:

- `convo_id`: UUID of conversation
- `node_id`: UUID of node
Returns:
    str: A URL to the shared link

<a id="revChatGPT.V1.AsyncChatbot.gen_title"></a>

#### gen\_title

```python
async def gen_title(convo_id: str, message_id: str) -> None
```

Generate title for conversation

<a id="revChatGPT.V1.AsyncChatbot.change_title"></a>

#### change\_title

```python
async def change_title(convo_id: str, title: str) -> None
```

Change title of conversation

**Arguments**:

- `convo_id`: UUID of conversation
- `title`: String

<a id="revChatGPT.V1.AsyncChatbot.delete_conversation"></a>

#### delete\_conversation

```python
async def delete_conversation(convo_id: str) -> None
```

Delete conversation

**Arguments**:

- `convo_id`: UUID of conversation

<a id="revChatGPT.V1.AsyncChatbot.clear_conversations"></a>

#### clear\_conversations

```python
async def clear_conversations() -> None
```

Delete all conversations

<a id="revChatGPT.V1.configure"></a>

#### configure

```python
@logger(is_timed=False)
def configure() -> dict
```

Looks for a config file in the following locations:

<a id="revChatGPT.V1.main"></a>

#### main

```python
@logger(is_timed=False)
def main(config: dict) -> NoReturn
```

Main function for the chatGPT program.
