<a id="revChatGPT.V3"></a>

# revChatGPT.V3

A simple wrapper for the official ChatGPT API

<a id="revChatGPT.V3.Chatbot"></a>

## Chatbot Objects

```python
class Chatbot()
```

Official ChatGPT API

<a id="revChatGPT.V3.Chatbot.__init__"></a>

#### \_\_init\_\_

```python
def __init__(
    api_key: str,
    engine: str = os.environ.get("GPT_ENGINE") or "gpt-3.5-turbo",
    proxy: str = None,
    timeout: float = None,
    max_tokens: int = None,
    temperature: float = 0.5,
    top_p: float = 1.0,
    presence_penalty: float = 0.0,
    frequency_penalty: float = 0.0,
    reply_count: int = 1,
    truncate_limit: int = None,
    system_prompt:
    str = "You are ChatGPT, a large language model trained by OpenAI. Respond conversationally"
) -> None
```

Initialize Chatbot with API key (from https://platform.openai.com/account/api-keys)

<a id="revChatGPT.V3.Chatbot.add_to_conversation"></a>

#### add\_to\_conversation

```python
def add_to_conversation(message: str,
                        role: str,
                        convo_id: str = "default") -> None
```

Add a message to the conversation

<a id="revChatGPT.V3.Chatbot.get_token_count"></a>

#### get\_token\_count

```python
def get_token_count(convo_id: str = "default") -> int
```

Get token count

<a id="revChatGPT.V3.Chatbot.get_max_tokens"></a>

#### get\_max\_tokens

```python
def get_max_tokens(convo_id: str) -> int
```

Get max tokens

<a id="revChatGPT.V3.Chatbot.ask_stream"></a>

#### ask\_stream

```python
def ask_stream(prompt: str,
               role: str = "user",
               convo_id: str = "default",
               model: str = None,
               pass_history: bool = True,
               **kwargs)
```

Ask a question

<a id="revChatGPT.V3.Chatbot.ask_stream_async"></a>

#### ask\_stream\_async

```python
async def ask_stream_async(prompt: str,
                           role: str = "user",
                           convo_id: str = "default",
                           model: str = None,
                           pass_history: bool = True,
                           **kwargs) -> AsyncGenerator[str, None]
```

Ask a question

<a id="revChatGPT.V3.Chatbot.ask_async"></a>

#### ask\_async

```python
async def ask_async(prompt: str,
                    role: str = "user",
                    convo_id: str = "default",
                    model: str = None,
                    pass_history: bool = True,
                    **kwargs) -> str
```

Non-streaming ask

<a id="revChatGPT.V3.Chatbot.ask"></a>

#### ask

```python
def ask(prompt: str,
        role: str = "user",
        convo_id: str = "default",
        model: str = None,
        pass_history: bool = True,
        **kwargs) -> str
```

Non-streaming ask

<a id="revChatGPT.V3.Chatbot.rollback"></a>

#### rollback

```python
def rollback(n: int = 1, convo_id: str = "default") -> None
```

Rollback the conversation

<a id="revChatGPT.V3.Chatbot.reset"></a>

#### reset

```python
def reset(convo_id: str = "default", system_prompt: str = None) -> None
```

Reset the conversation

<a id="revChatGPT.V3.Chatbot.save"></a>

#### save

```python
def save(file: str, *keys: str) -> None
```

Save the Chatbot configuration to a JSON file

<a id="revChatGPT.V3.Chatbot.load"></a>

#### load

```python
def load(file: Path, *keys_: str) -> None
```

Load the Chatbot configuration from a JSON file

<a id="revChatGPT.V3.ChatbotCLI"></a>

## ChatbotCLI Objects

```python
class ChatbotCLI(Chatbot)
```

Command Line Interface for Chatbot

<a id="revChatGPT.V3.ChatbotCLI.print_config"></a>

#### print\_config

```python
def print_config(convo_id: str = "default") -> None
```

Prints the current configuration

<a id="revChatGPT.V3.ChatbotCLI.print_help"></a>

#### print\_help

```python
def print_help() -> None
```

Prints the help message

<a id="revChatGPT.V3.ChatbotCLI.handle_commands"></a>

#### handle\_commands

```python
def handle_commands(prompt: str, convo_id: str = "default") -> bool
```

Handle chatbot commands

<a id="revChatGPT.V3.main"></a>

#### main

```python
def main() -> NoReturn
```

Main function
