/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.CaptionBuilder;
import org.allenai.pdffigures2.CaptionParagraph;
import org.allenai.pdffigures2.CaptionStart;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.PageWithCaptions;
import org.allenai.pdffigures2.PageWithGraphics;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.Paragraph$;
import org.allenai.pdffigures2.TextSpan;
import org.allenai.pdffigures2.Word;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.text.TextPosition;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class CaptionBuilder$
implements Logging {
    public static CaptionBuilder$ MODULE$;
    private final double AlignmentTolerance;
    private final double GraphicIntersectTolerance;
    private final double LargeParagraphNumberOfLines;
    private final double MedianSpacingPadding;
    private final double MaxAdditionalSpacing;
    private final double LineContinuationMaxYDifference;
    private final double LineContinuationMaxXDifference;
    private final int MinYDistBetweenLines;
    private final int LeftEdgeDifferenceTolerance;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new CaptionBuilder$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    private double AlignmentTolerance() {
        return this.AlignmentTolerance;
    }

    private double GraphicIntersectTolerance() {
        return this.GraphicIntersectTolerance;
    }

    private double LargeParagraphNumberOfLines() {
        return this.LargeParagraphNumberOfLines;
    }

    private double MedianSpacingPadding() {
        return this.MedianSpacingPadding;
    }

    private double MaxAdditionalSpacing() {
        return this.MaxAdditionalSpacing;
    }

    private double LineContinuationMaxYDifference() {
        return this.LineContinuationMaxYDifference;
    }

    private double LineContinuationMaxXDifference() {
        return this.LineContinuationMaxXDifference;
    }

    private int MinYDistBetweenLines() {
        return this.MinYDistBetweenLines;
    }

    private int LeftEdgeDifferenceTolerance() {
        return this.LeftEdgeDifferenceTolerance;
    }

    private Option<PDFont> getLineFont(Line line) {
        List fonts = line.words().flatMap((Function1<Word, List> & Serializable & scala.Serializable)x$1 -> x$1.positions(), List$.MODULE$.canBuildFrom()).map((Function1<TextPosition, PDFont> & Serializable & scala.Serializable)x$2 -> x$2.getFont(), List$.MODULE$.canBuildFrom());
        if (((LinearSeqOptimized)fonts.tail()).forall((Function1<PDFont, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.equals(fonts.head())))) {
            return new Some<PDFont>((PDFont)fonts.head());
        }
        return None$.MODULE$;
    }

    public PageWithCaptions buildCaptions(Seq<CaptionStart> candidates, PageWithGraphics text, double medianLineSpacing) {
        if (candidates.nonEmpty()) {
            Seq captionStartLocations = candidates.map((Function1<CaptionStart, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(CaptionBuilder$.$anonfun$buildCaptions$1(x$4)), Seq$.MODULE$.canBuildFrom());
            Seq<CaptionParagraph> captions = candidates.map((Function1<CaptionStart, CaptionParagraph> & Serializable & scala.Serializable)c -> MODULE$.buildCaption((CaptionStart)c, captionStartLocations, text.paragraphs(), text.graphics(), medianLineSpacing + MODULE$.MedianSpacingPadding()), Seq$.MODULE$.canBuildFrom());
            Seq<Paragraph> textWithoutCaptions = Paragraph$.MODULE$.removeSpans(captions.map((Function1<CaptionParagraph, TextSpan> & Serializable & scala.Serializable)x$5 -> x$5.paragraph().span(), Seq$.MODULE$.canBuildFrom()), text.paragraphs());
            return new PageWithCaptions(text.pageNumber(), captions, text.graphics(), text.nonFigureGraphics(), textWithoutCaptions.toList(), text.classifiedText());
        }
        return new PageWithCaptions(text.pageNumber(), Nil$.MODULE$, text.graphics(), text.nonFigureGraphics(), text.paragraphs(), text.classifiedText());
    }

    private Paragraph pruneCaptionParagraph(Paragraph paragraph) {
        Box prunedBB;
        double x$1 = paragraph.lines().head().words().head().boundary().y1();
        double x$2 = paragraph.boundary().copy$default$1();
        double x$3 = paragraph.boundary().copy$default$3();
        double x$4 = paragraph.boundary().copy$default$4();
        Box x$5 = prunedBB = paragraph.boundary().copy(x$2, x$1, x$3, x$4);
        List<Line> x$6 = paragraph.copy$default$1();
        return paragraph.copy(x$6, x$5);
    }

    public CaptionParagraph buildCaption(CaptionStart candidate, Seq<Object> captionLocations, Seq<Paragraph> paragraphs, Seq<Box> graphicsLocations, double safeLineSpacing) {
        Seq linesWithParagraphs = paragraphs.flatMap((Function1<Paragraph, List> & Serializable & scala.Serializable)paragraph -> paragraph.lines().map((Function1<Line, Tuple2> & Serializable & scala.Serializable)line -> new Tuple2<Line, Paragraph>((Line)line, (Paragraph)paragraph), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq linesStartingAtCaption = (Seq)linesWithParagraphs.dropWhile((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(CaptionBuilder$.$anonfun$buildCaption$3(candidate, x0$1)));
        Predef$.MODULE$.require(linesStartingAtCaption.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "No lines at candidate's location");
        Line startingLine = (Line)((Tuple2)linesStartingAtCaption.head())._1();
        ObjectRef<CaptionBuilder.CaptionBuilder> currentCaption = ObjectRef.create(new CaptionBuilder.CaptionBuilder(new $colon$colon<Nothing$>((Nothing$)((Object)startingLine), Nil$.MODULE$), startingLine.boundary(), this.getLineFont(startingLine), true));
        Seq graphicsToAvoid = (Seq)graphicsLocations.filter((Function1<Box, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(CaptionBuilder$.$anonfun$buildCaption$5(currentCaption, x$6)));
        ((IterableLike)linesStartingAtCaption.tail()).takeWhile((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean(CaptionBuilder$.$anonfun$buildCaption$6(currentCaption, candidate, safeLineSpacing, graphicsToAvoid, captionLocations, x0$2)));
        return new CaptionParagraph(candidate.name(), candidate.figType(), candidate.page(), this.pruneCaptionParagraph(new Paragraph(((CaptionBuilder.CaptionBuilder)currentCaption.elem).lines(), ((CaptionBuilder.CaptionBuilder)currentCaption.elem).boundary())));
    }

    private final void logger$lzycompute$1() {
        CaptionBuilder$ captionBuilder$ = this;
        synchronized (captionBuilder$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        CaptionBuilder$ captionBuilder$ = this;
        synchronized (captionBuilder$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$buildCaptions$1(CaptionStart x$4) {
        return x$4.line().lineNumber();
    }

    public static final /* synthetic */ boolean $anonfun$buildCaption$3(CaptionStart candidate$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Line line = (Line)tuple2._1();
            return line.lineNumber() < candidate$1.line().lineNumber();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$buildCaption$5(ObjectRef currentCaption$1, Box x$6) {
        return !x$6.intersects(((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).boundary(), MODULE$.GraphicIntersectTolerance());
    }

    public static final /* synthetic */ boolean $anonfun$buildCaption$6(ObjectRef currentCaption$1, CaptionStart candidate$1, double safeLineSpacing$1, Seq graphicsToAvoid$1, Seq captionLocations$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            boolean useLine;
            boolean bl;
            boolean fontChange;
            Line line = (Line)tuple2._1();
            Paragraph paragraph = (Paragraph)tuple2._2();
            Box lineBB = line.boundary();
            Box currentBoundary = ((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).boundary();
            Box proposedBB = currentBoundary.container(lineBB);
            double yDist = lineBB.y1() - currentBoundary.y2();
            Option<PDFont> lineFont = MODULE$.getLineFont(line);
            boolean firstLine = ((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).lines().size() == 1;
            boolean firstLineAfterSingleLineHeader = firstLine && candidate$1.lineEnd();
            boolean bl2 = fontChange = lineFont.isDefined() && ((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).font().isDefined() && !firstLineAfterSingleLineHeader && !lineFont.get().equals(((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).font().get());
            if (yDist < (double)MODULE$.MinYDistBetweenLines() || yDist > safeLineSpacing$1 + MODULE$.MaxAdditionalSpacing()) {
                bl = false;
            } else if (graphicsToAvoid$1.exists((Function1<Box, Object> & Serializable & scala.Serializable)bb -> BoxesRunTime.boxToBoolean(bb.intersects(proposedBB, CaptionBuilder$.MODULE$.GraphicIntersectTolerance()))) || captionLocations$1.contains(BoxesRunTime.boxToInteger(line.lineNumber()))) {
                bl = false;
            } else if (yDist < MODULE$.LineContinuationMaxYDifference() && ((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).lines().last().boundary().x2() - lineBB.x1() < MODULE$.LineContinuationMaxXDifference()) {
                bl = true;
            } else if (fontChange && !firstLineAfterSingleLineHeader) {
                bl = false;
            } else if (yDist < safeLineSpacing$1 && yDist > 0.0 && Math.abs(currentBoundary.x1() - lineBB.x1()) < MODULE$.AlignmentTolerance()) {
                bl = true;
            } else {
                boolean centered = Math.abs(lineBB.xCenter() - currentBoundary.xCenter()) < MODULE$.AlignmentTolerance();
                boolean overlapsHorizontal = lineBB.x1() < currentBoundary.x2() && lineBB.x2() > currentBoundary.x1() && (currentBoundary.x1() - proposedBB.x1() < (double)MODULE$.LeftEdgeDifferenceTolerance() || firstLineAfterSingleLineHeader);
                boolean startingLargeParagraph = line.lineNumber() == paragraph.lines().head().lineNumber() && (double)paragraph.lines().size() >= MODULE$.LargeParagraphNumberOfLines();
                boolean breaksJustification = !((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).lastLineRightAligned() && (!((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).centered() || !centered);
                bl = useLine = overlapsHorizontal && !startingLargeParagraph && !breaksJustification;
            }
            if (useLine) {
                currentCaption$1.elem = ((CaptionBuilder.CaptionBuilder)currentCaption$1.elem).addLine(line, proposedBB, lineFont);
            }
            return useLine;
        }
        throw new MatchError(tuple2);
    }

    private CaptionBuilder$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.AlignmentTolerance = 2.0;
        this.GraphicIntersectTolerance = -2.0;
        this.LargeParagraphNumberOfLines = 5.0;
        this.MedianSpacingPadding = 0.2;
        this.MaxAdditionalSpacing = 2.0;
        this.LineContinuationMaxYDifference = 3.0;
        this.LineContinuationMaxXDifference = 12.0;
        this.MinYDistBetweenLines = -40;
        this.LeftEdgeDifferenceTolerance = 30;
    }
}

