/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.DocumentLayout;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.Page;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.Word;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.text.TextPosition;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDI$sp;
import scala.Tuple2$mcID$sp;
import scala.Tuple9;
import scala.collection.AbstractSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1$mcID$sp;
import scala.runtime.java8.JFunction1$mcII$sp;

public final class DocumentLayout$
implements Logging,
scala.Serializable {
    public static DocumentLayout$ MODULE$;
    private final int LineWidthBucketSize;
    private final double TwoColumnMaxUsageDifference;
    private final double TwoColumnMaxXDifference;
    private final double MinCommonLineWidthUse;
    private final double TrustMarginsTwoColumnThreshold;
    private final int TrustMarginsNumMarginsToCount;
    private final double TrustMarginsOneColumnThreshold;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new DocumentLayout$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public int LineWidthBucketSize() {
        return this.LineWidthBucketSize;
    }

    private double TwoColumnMaxUsageDifference() {
        return this.TwoColumnMaxUsageDifference;
    }

    private double TwoColumnMaxXDifference() {
        return this.TwoColumnMaxXDifference;
    }

    private double MinCommonLineWidthUse() {
        return this.MinCommonLineWidthUse;
    }

    private double TrustMarginsTwoColumnThreshold() {
        return this.TrustMarginsTwoColumnThreshold;
    }

    private int TrustMarginsNumMarginsToCount() {
        return this.TrustMarginsNumMarginsToCount;
    }

    private double TrustMarginsOneColumnThreshold() {
        return this.TrustMarginsOneColumnThreshold;
    }

    public double weightedMedian(Vector<Tuple2<Object, Object>> inputs) {
        Predef$.MODULE$.require(inputs.nonEmpty());
        Object sorted = (Vector)inputs.sortBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble(x$1._1$mcD$sp()), (Ordering)Ordering$Double$.MODULE$);
        int weightedRemovedFromStart = 0;
        int weightedRemovedFromEnd = 0;
        while (((AbstractSeq)sorted).size() != 1) {
            if (weightedRemovedFromEnd + ((Tuple2)((Vector)sorted).last())._2$mcI$sp() < weightedRemovedFromStart + ((Tuple2)((Vector)sorted).head())._2$mcI$sp()) {
                weightedRemovedFromEnd += ((Tuple2)((Vector)sorted).last())._2$mcI$sp();
                sorted = ((Vector)sorted).dropRight(1);
                continue;
            }
            weightedRemovedFromStart += ((Tuple2)((Vector)sorted).head())._2$mcI$sp();
            sorted = ((Vector)sorted).drop(1);
        }
        return ((Tuple2)((Vector)sorted).head())._1$mcD$sp();
    }

    public Option<DocumentLayout> apply(scala.collection.immutable.Seq<Page> textPages) {
        double wordsInTopMargins;
        boolean trustMargins;
        double wordsInTopMargins2;
        boolean twoColumn;
        boolean bl;
        DoubleRef totalWordSpacing = DoubleRef.create(0.0);
        IntRef totalWordSpaces = IntRef.create(0);
        Map leftMargins = ((Map)Map$.MODULE$.apply(Nil$.MODULE$)).withDefault((JFunction1$mcII$sp & scala.Serializable)x$2 -> 0);
        Map fontCounts = ((Map)Map$.MODULE$.apply(Nil$.MODULE$)).withDefault((Function1<PDFont, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger(DocumentLayout$.$anonfun$apply$2(x$3)));
        Map lineWidths = ((Map)Map$.MODULE$.apply(Nil$.MODULE$)).withDefault((JFunction1$mcID$sp & scala.Serializable)x$4 -> 0);
        Map fontSizeCounts = ((Map)Map$.MODULE$.apply(Nil$.MODULE$)).withDefault((JFunction1$mcID$sp & scala.Serializable)x$5 -> 0);
        ListBuffer lineSpacing = (ListBuffer)ListBuffer$.MODULE$.apply(Nil$.MODULE$);
        textPages.foreach((Function1<Page, Object> & Serializable & scala.Serializable)textPage -> {
            DocumentLayout$.$anonfun$apply$5(leftMargins, lineSpacing, lineWidths, totalWordSpacing, totalWordSpaces, fontCounts, fontSizeCounts, textPage);
            return BoxedUnit.UNIT;
        });
        int totalChars = BoxesRunTime.unboxToInt(fontCounts.values().sum(Numeric$IntIsIntegral$.MODULE$));
        int totalLines = BoxesRunTime.unboxToInt(lineWidths.values().sum(Numeric$IntIsIntegral$.MODULE$)) / 2;
        if (totalWordSpaces.elem == 0 || totalChars == 0 || lineSpacing.isEmpty() || totalLines == 0) {
            return None$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)fontSizeCounts.maxBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger(x$7._2$mcI$sp()), Ordering$Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double mostCommonFontSize = tuple2._1$mcD$sp();
        int mostCommonFontSizeCount = tuple2._2$mcI$sp();
        Tuple2$mcDI$sp tuple2$mcDI$sp = new Tuple2$mcDI$sp(mostCommonFontSize, mostCommonFontSizeCount);
        double mostCommonFontSize2 = ((Tuple2)tuple2$mcDI$sp)._1$mcD$sp();
        int mostCommonFontSizeCount2 = ((Tuple2)tuple2$mcDI$sp)._2$mcI$sp();
        Option standardFontSize = (double)mostCommonFontSizeCount2 > (double)totalChars / 2.0 ? new Some<Double>(BoxesRunTime.boxToDouble(mostCommonFontSize2)) : None$.MODULE$;
        double averageFontSize = BoxesRunTime.unboxToDouble(((TraversableOnce)fontSizeCounts.map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble(DocumentLayout$.$anonfun$apply$12(x0$1)), Iterable$.MODULE$.canBuildFrom())).sum(Numeric$DoubleIsFractional$.MODULE$)) / (double)BoxesRunTime.unboxToInt(fontSizeCounts.values().sum(Numeric$IntIsIntegral$.MODULE$));
        double medianLineSpacing = this.weightedMedian(lineSpacing.toVector());
        Tuple2 tuple22 = (Tuple2)lineWidths.maxBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger(x$9._2$mcI$sp()), Ordering$Int$.MODULE$);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        double mostCommonWidth = tuple22._1$mcD$sp();
        int mostCommonWidthCount = tuple22._2$mcI$sp();
        Tuple2$mcDI$sp tuple2$mcDI$sp2 = new Tuple2$mcDI$sp(mostCommonWidth, mostCommonWidthCount);
        double mostCommonWidth2 = ((Tuple2)tuple2$mcDI$sp2)._1$mcD$sp();
        int mostCommonWidthCount2 = ((Tuple2)tuple2$mcDI$sp2)._2$mcI$sp();
        Option standardLineWidth = (double)mostCommonWidthCount2 > (double)totalLines * this.MinCommonLineWidthUse() ? new Some<Double>(BoxesRunTime.boxToDouble(mostCommonWidth2)) : None$.MODULE$;
        Seq sortedLeftMargins = (Seq)leftMargins.toSeq().sortBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger(DocumentLayout$.$anonfun$apply$14(x$11)), Ordering$Int$.MODULE$);
        Seq top2Margins = (Seq)sortedLeftMargins.take(2);
        Tuple2 mostCommon = (Tuple2)top2Margins.head();
        Option secondMostCommonOpt = ((TraversableLike)top2Margins.tail()).headOption();
        if (secondMostCommonOpt.isDefined()) {
            Tuple2 secondMostCommon = (Tuple2)secondMostCommonOpt.get();
            double diff = (double)Math.abs(mostCommon._2$mcI$sp() - secondMostCommon._2$mcI$sp()) / (double)(mostCommon._2$mcI$sp() + secondMostCommon._2$mcI$sp());
            bl = diff < this.TwoColumnMaxUsageDifference() && (double)Math.abs(mostCommon._1$mcI$sp() - secondMostCommon._1$mcI$sp()) > this.TwoColumnMaxXDifference();
        } else {
            bl = twoColumn = false;
        }
        if (twoColumn) {
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Document was two column");
        } else {
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Document was not two column");
        }
        scala.collection.immutable.Map<PDFont, Object> fontPercents = ((TraversableOnce)fontCounts.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                PDFont k = (PDFont)tuple2._1();
                int v = tuple2._2$mcI$sp();
                return new Tuple2<PDFont, Double>(k, BoxesRunTime.boxToDouble((double)v / (double)totalChars));
            }
            throw new MatchError(tuple2);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int totalMarginCounts = BoxesRunTime.unboxToInt(leftMargins.values().sum(Numeric$IntIsIntegral$.MODULE$));
        Seq sortedMarginsByPercent = sortedLeftMargins.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int margin = tuple2._1$mcI$sp();
                int count = tuple2._2$mcI$sp();
                return new Tuple2$mcID$sp(margin, (double)count / (double)totalMarginCounts);
            }
            throw new MatchError(tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        boolean bl2 = twoColumn ? (wordsInTopMargins2 = BoxesRunTime.unboxToDouble(((TraversableOnce)((TraversableLike)sortedMarginsByPercent.take(this.TrustMarginsNumMarginsToCount() * 2)).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble(x$12._2$mcD$sp()), Seq$.MODULE$.canBuildFrom())).sum(Numeric$DoubleIsFractional$.MODULE$))) > this.TrustMarginsTwoColumnThreshold() : (trustMargins = (wordsInTopMargins = BoxesRunTime.unboxToDouble(((TraversableOnce)((TraversableLike)sortedMarginsByPercent.take(this.TrustMarginsNumMarginsToCount())).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble(x$13._2$mcD$sp()), Seq$.MODULE$.canBuildFrom())).sum(Numeric$DoubleIsFractional$.MODULE$))) > this.TrustMarginsOneColumnThreshold());
        if (!trustMargins) {
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Margins appear to be inconsistent, won't use in heuristics");
        }
        DocumentLayout layout = new DocumentLayout(twoColumn, fontPercents, standardFontSize, averageFontSize, totalWordSpacing.elem / (double)totalWordSpaces.elem, trustMargins, sortedMarginsByPercent.toMap(Predef$.MODULE$.$conforms()), medianLineSpacing, standardLineWidth);
        return new Some<DocumentLayout>(layout);
    }

    public DocumentLayout apply(boolean twoColumns, scala.collection.immutable.Map<PDFont, Object> fontCounts, Option<Object> standardFontSize, double averageFontSize, double averageWordSpacing, boolean trustLeftMargin, scala.collection.immutable.Map<Object, Object> leftMargins, double medianLineSpacing, Option<Object> standardWidthBucketed) {
        return new DocumentLayout(twoColumns, fontCounts, standardFontSize, averageFontSize, averageWordSpacing, trustLeftMargin, leftMargins, medianLineSpacing, standardWidthBucketed);
    }

    public Option<Tuple9<Object, scala.collection.immutable.Map<PDFont, Object>, Option<Object>, Object, Object, Object, scala.collection.immutable.Map<Object, Object>, Object, Option<Object>>> unapply(DocumentLayout x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple9<Object, scala.collection.immutable.Map<PDFont, Object>, Option<Object>, Object, Object, Object, scala.collection.immutable.Map<Object, Object>, Object, Option<Object>>>(new Tuple9<Boolean, scala.collection.immutable.Map<PDFont, Object>, Option<Object>, Double, Double, Boolean, scala.collection.immutable.Map<Object, Object>, Double, Option<Object>>(BoxesRunTime.boxToBoolean(x$0.twoColumns()), x$0.fontCounts(), x$0.standardFontSize(), BoxesRunTime.boxToDouble(x$0.averageFontSize()), BoxesRunTime.boxToDouble(x$0.averageWordSpacing()), BoxesRunTime.boxToBoolean(x$0.trustLeftMargin()), x$0.leftMargins(), BoxesRunTime.boxToDouble(x$0.medianLineSpacing()), x$0.standardWidthBucketed()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void logger$lzycompute$1() {
        DocumentLayout$ documentLayout$ = this;
        synchronized (documentLayout$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        DocumentLayout$ documentLayout$ = this;
        synchronized (documentLayout$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$apply$2(PDFont x$3) {
        return 0;
    }

    public static final /* synthetic */ void $anonfun$apply$10(Map fontCounts$1, Map fontSizeCounts$1, TextPosition pos) {
        fontCounts$1.update(pos.getFont(), BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(fontCounts$1.apply(pos.getFont())) + 1));
        float fontSize = pos.getFontSizeInPt();
        fontSizeCounts$1.update(BoxesRunTime.boxToDouble(fontSize), BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(fontSizeCounts$1.apply(BoxesRunTime.boxToDouble(fontSize))) + 1));
    }

    public static final /* synthetic */ void $anonfun$apply$9(ObjectRef prevWord$1, DoubleRef totalWordSpacing$1, IntRef totalWordSpaces$1, Map fontCounts$1, Map fontSizeCounts$1, Word word) {
        if (((Option)prevWord$1.elem).isDefined()) {
            Box prevWordBB = ((Word)((Option)prevWord$1.elem).get()).boundary();
            double spacing = word.boundary().x1() - prevWordBB.x2();
            if (spacing > 0.0) {
                totalWordSpacing$1.elem += spacing;
                ++totalWordSpaces$1.elem;
            }
        }
        word.positions().foreach((Function1<TextPosition, Object> & Serializable & scala.Serializable)pos -> {
            DocumentLayout$.$anonfun$apply$10(fontCounts$1, fontSizeCounts$1, pos);
            return BoxedUnit.UNIT;
        });
        prevWord$1.elem = new Some<Word>(word);
    }

    public static final /* synthetic */ void $anonfun$apply$8(Map leftMargins$1, ObjectRef prevLineBB$1, ListBuffer lineSpacing$1, Map lineWidths$1, DoubleRef totalWordSpacing$1, IntRef totalWordSpaces$1, Map fontCounts$1, Map fontSizeCounts$1, Line line) {
        int weight = line.words().size();
        int x1 = (int)Math.round(line.boundary().x1());
        leftMargins$1.update(BoxesRunTime.boxToInteger(x1), BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(leftMargins$1.apply(BoxesRunTime.boxToInteger(x1))) + weight));
        if (((Option)prevLineBB$1.elem).isDefined()) {
            Box bb = line.boundary();
            double space = line.boundary().y1() - ((Box)((Option)prevLineBB$1.elem).get()).y2();
            if (((Box)((Option)prevLineBB$1.elem).get()).x1() < bb.x2() && ((Box)((Option)prevLineBB$1.elem).get()).x2() > bb.x1() && space > 0.0) {
                lineSpacing$1.append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcDI$sp(space, weight)}));
            }
        }
        double w = line.boundary().width();
        double lowerBucket = Math.floor(w / (double)MODULE$.LineWidthBucketSize()) * (double)MODULE$.LineWidthBucketSize();
        double upperBucket = Math.ceil(w / (double)MODULE$.LineWidthBucketSize()) * (double)MODULE$.LineWidthBucketSize();
        lineWidths$1.update(BoxesRunTime.boxToDouble(lowerBucket), BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(lineWidths$1.apply(BoxesRunTime.boxToDouble(lowerBucket))) + weight));
        lineWidths$1.update(BoxesRunTime.boxToDouble(upperBucket), BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(lineWidths$1.apply(BoxesRunTime.boxToDouble(upperBucket))) + weight));
        prevLineBB$1.elem = new Some<Box>(line.boundary());
        ObjectRef<None$> prevWord = ObjectRef.create(None$.MODULE$);
        line.words().foreach((Function1<Word, Object> & Serializable & scala.Serializable)word -> {
            DocumentLayout$.$anonfun$apply$9(prevWord, totalWordSpacing$1, totalWordSpaces$1, fontCounts$1, fontSizeCounts$1, word);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$6(Map leftMargins$1, ObjectRef prevLineBB$1, ListBuffer lineSpacing$1, Map lineWidths$1, DoubleRef totalWordSpacing$1, IntRef totalWordSpaces$1, Map fontCounts$1, Map fontSizeCounts$1, Paragraph paragraph) {
        ((List)paragraph.lines().filter((Function1<Line, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isHorizontal()))).foreach((Function1<Line, Object> & Serializable & scala.Serializable)line -> {
            DocumentLayout$.$anonfun$apply$8(leftMargins$1, prevLineBB$1, lineSpacing$1, lineWidths$1, totalWordSpacing$1, totalWordSpaces$1, fontCounts$1, fontSizeCounts$1, line);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$5(Map leftMargins$1, ListBuffer lineSpacing$1, Map lineWidths$1, DoubleRef totalWordSpacing$1, IntRef totalWordSpaces$1, Map fontCounts$1, Map fontSizeCounts$1, Page textPage) {
        ObjectRef<None$> prevLineBB = ObjectRef.create(None$.MODULE$);
        textPage.paragraphs().foreach((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> {
            DocumentLayout$.$anonfun$apply$6(leftMargins$1, prevLineBB, lineSpacing$1, lineWidths$1, totalWordSpacing$1, totalWordSpaces$1, fontCounts$1, fontSizeCounts$1, paragraph);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ double $anonfun$apply$12(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double k = tuple2._1$mcD$sp();
            int v = tuple2._2$mcI$sp();
            return k * (double)v;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ int $anonfun$apply$14(Tuple2 x$11) {
        return -x$11._2$mcI$sp();
    }

    private DocumentLayout$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.LineWidthBucketSize = 2;
        this.TwoColumnMaxUsageDifference = 0.4;
        this.TwoColumnMaxXDifference = 0.4;
        this.MinCommonLineWidthUse = 0.4;
        this.TrustMarginsTwoColumnThreshold = 0.65;
        this.TrustMarginsNumMarginsToCount = 3;
        this.TrustMarginsOneColumnThreshold = 0.55;
    }
}

