/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.Box$;
import org.allenai.pdffigures2.Caption;
import org.allenai.pdffigures2.Caption$;
import org.allenai.pdffigures2.CaptionParagraph;
import org.allenai.pdffigures2.DocumentLayout;
import org.allenai.pdffigures2.Figure;
import org.allenai.pdffigures2.FigureDetector;
import org.allenai.pdffigures2.FigureDetector$Proposal$;
import org.allenai.pdffigures2.FigureDetector$ProposalDirection$Down$;
import org.allenai.pdffigures2.FigureDetector$ProposalDirection$Left$;
import org.allenai.pdffigures2.FigureDetector$ProposalDirection$Right$;
import org.allenai.pdffigures2.FigureDetector$ProposalDirection$Up$;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.PageWithBodyText;
import org.allenai.pdffigures2.PageWithFigures;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.Paragraph$;
import org.allenai.pdffigures2.VisualLogger;
import org.allenai.pdffigures2.Word;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Ordering$;
import scala.math.Ordering$Double$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1$mcZD$sp;

public final class FigureDetector$ {
    public static FigureDetector$ MODULE$;
    private final int MinProposalHeight;
    private final int MinProposalWidth;
    private final int ClipRegionMinGraphicSize;
    private final int ClipRegionLargeTextSize;
    private final int ClipRegionMaxTextDistance;
    private final int ClipRegionMaxLargeTextDistance;
    private final int ClipRegionMaxGraphicDistance;
    private final double LeftRightFigurePenalty;
    private final double SplitDifferentTypesPenalty;
    private final double SplitSameTypesPenalty;
    private final int SplitWhitespaceBonus;
    private final int LargeGraphicThreshold;
    private final double ContainsGraphicBonus;
    private final double ContainsLargeGraphicBonus;
    private final int SplitVerticalRegionMinHeightFraction;
    private final double cutFilterIntervalMin;
    private final double cutFilterIntervalMax;
    private final int boundaryFilterMinDistance;

    static {
        new FigureDetector$();
    }

    private int MinProposalHeight() {
        return this.MinProposalHeight;
    }

    private int MinProposalWidth() {
        return this.MinProposalWidth;
    }

    private int ClipRegionMinGraphicSize() {
        return this.ClipRegionMinGraphicSize;
    }

    private int ClipRegionLargeTextSize() {
        return this.ClipRegionLargeTextSize;
    }

    private int ClipRegionMaxTextDistance() {
        return this.ClipRegionMaxTextDistance;
    }

    private int ClipRegionMaxLargeTextDistance() {
        return this.ClipRegionMaxLargeTextDistance;
    }

    private int ClipRegionMaxGraphicDistance() {
        return this.ClipRegionMaxGraphicDistance;
    }

    private double LeftRightFigurePenalty() {
        return this.LeftRightFigurePenalty;
    }

    private double SplitDifferentTypesPenalty() {
        return this.SplitDifferentTypesPenalty;
    }

    private double SplitSameTypesPenalty() {
        return this.SplitSameTypesPenalty;
    }

    private int SplitWhitespaceBonus() {
        return this.SplitWhitespaceBonus;
    }

    private int LargeGraphicThreshold() {
        return this.LargeGraphicThreshold;
    }

    private double ContainsGraphicBonus() {
        return this.ContainsGraphicBonus;
    }

    private double ContainsLargeGraphicBonus() {
        return this.ContainsLargeGraphicBonus;
    }

    private int SplitVerticalRegionMinHeightFraction() {
        return this.SplitVerticalRegionMinHeightFraction;
    }

    public double cutFilterIntervalMin() {
        return this.cutFilterIntervalMin;
    }

    public double cutFilterIntervalMax() {
        return this.cutFilterIntervalMax;
    }

    public int boundaryFilterMinDistance() {
        return this.boundaryFilterMinDistance;
    }

    private List<Paragraph> removeTextInRegions(List<Paragraph> paragraphs, List<Box> regions) {
        if (regions.isEmpty()) {
            return paragraphs;
        }
        List<Paragraph> cleanedParagraphs = paragraphs.flatMap((Function1<Paragraph, Iterable> & Serializable & scala.Serializable)p -> {
            List filteredLines = (List)p.lines().filter((Function1<Line, Object> & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$removeTextInRegions$2(regions, l)));
            if (filteredLines.nonEmpty()) {
                return Option$.MODULE$.option2Iterable(new Some<Paragraph>(Paragraph$.MODULE$.apply(filteredLines)));
            }
            return Option$.MODULE$.option2Iterable(None$.MODULE$);
        }, List$.MODULE$.canBuildFrom());
        return cleanedParagraphs;
    }

    private Tuple2<Object, Object> findCenterColumn(PageWithBodyText page) {
        double rightX1;
        double leftX2;
        double centerX1;
        double textCenter = Box$.MODULE$.container(((TraversableLike)((TraversableLike)page.bodyText().$plus$plus(page.otherText(), Seq$.MODULE$.canBuildFrom())).map((Function1<Paragraph, Box> & Serializable & scala.Serializable)x$2 -> x$2.boundary(), Seq$.MODULE$.canBuildFrom())).$plus$plus(page.captions().map((Function1<CaptionParagraph, Box> & Serializable & scala.Serializable)x$3 -> x$3.boundary(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).xCenter();
        Seq leftSide = (Seq)page.bodyText().filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$findCenterColumn$3(textCenter, p)));
        Seq rightSide = (Seq)page.bodyText().filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$findCenterColumn$4(textCenter, p)));
        double d = leftSide.isEmpty() ? textCenter : (centerX1 = Math.abs((leftX2 = BoxesRunTime.unboxToDouble(((TraversableOnce)leftSide.map((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble(FigureDetector$.$anonfun$findCenterColumn$5(x$4)), Seq$.MODULE$.canBuildFrom())).max(Ordering$Double$.MODULE$))) - textCenter) < (double)10 ? leftX2 : textCenter);
        double centerX2 = rightSide.isEmpty() ? textCenter : (Math.abs((rightX1 = BoxesRunTime.unboxToDouble(((TraversableOnce)rightSide.map((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble(FigureDetector$.$anonfun$findCenterColumn$6(x$5)), Seq$.MODULE$.canBuildFrom())).min(Ordering$Double$.MODULE$))) - textCenter) < (double)10 ? rightX1 : textCenter);
        return new Tuple2$mcDD$sp(centerX1, centerX2);
    }

    private Option<Tuple3<Box, Box, Box>> splitRegionHorizontally(Box proposalRegion, Seq<Box> content) {
        double x$8;
        double x$72;
        Seq intersects = (Seq)content.filter((Function1<Box, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.intersects(proposalRegion, x$6.intersects$default$2())));
        Seq<Box> emptyBlocks = Box$.MODULE$.findEmptyHorizontalBlocks(proposalRegion, intersects);
        Seq emptyBlocksNearCenter = (Seq)emptyBlocks.filter((Function1<Box, Object> & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$splitRegionHorizontally$2(proposalRegion, e)));
        if (emptyBlocksNearCenter.isEmpty()) {
            return None$.MODULE$;
        }
        Box largest = (Box)emptyBlocksNearCenter.maxBy((Function1<Box, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble(x$7.area()), Ordering$Double$.MODULE$);
        double x$1 = largest.y1();
        double x$2 = proposalRegion.copy$default$1();
        double x$3 = proposalRegion.copy$default$2();
        double x$4 = proposalRegion.copy$default$3();
        Option<Box> upper = Box$.MODULE$.crop(proposalRegion.copy(x$2, x$3, x$4, x$1), intersects, -1.0);
        double x$5 = largest.y2();
        double x$62 = proposalRegion.copy$default$1();
        Option<Box> lower = Box$.MODULE$.crop(proposalRegion.copy(x$62, x$5, x$72 = proposalRegion.copy$default$3(), x$8 = proposalRegion.copy$default$4()), intersects, -1.0);
        if (lower.isDefined() && upper.isDefined() && lower.get().height() > (double)this.MinProposalHeight() && upper.get().height() > (double)this.MinProposalHeight()) {
            return new Some<Tuple3<Box, Box, Box>>(new Tuple3<Box, Box, Box>(upper.get(), lower.get(), largest));
        }
        return None$.MODULE$;
    }

    private Seq<FigureDetector.Proposal> splitProposals(Seq<FigureDetector.Proposal> proposals, Seq<Box> content) {
        Seq groupedByCollision = Nil$.MODULE$;
        ObjectRef<Seq<FigureDetector.Proposal>> proposalToCheck = ObjectRef.create(proposals);
        while (((Seq)proposalToCheck.elem).nonEmpty()) {
            Tuple2 tuple2 = ((TraversableLike)((Seq)proposalToCheck.elem).tail()).partition((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$splitProposals$1(proposalToCheck, x$8)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq collides = (Seq)tuple2._1();
            Seq rest = (Seq)tuple2._2();
            Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(collides, rest);
            Seq collides2 = tuple22._1();
            Seq rest2 = tuple22._2();
            FigureDetector.Proposal proposal = (FigureDetector.Proposal)((Seq)proposalToCheck.elem).head();
            Seq seq = collides2.$plus$colon(proposal, Seq$.MODULE$.canBuildFrom());
            groupedByCollision = groupedByCollision.$plus$colon(seq, Seq$.MODULE$.canBuildFrom());
            proposalToCheck.elem = rest2;
        }
        Seq<FigureDetector.Proposal> splitProposals = groupedByCollision.flatMap((Function1<Seq, Seq> & Serializable & scala.Serializable)group -> {
            double x$4;
            Box x$3;
            Box qual$2;
            double x$2;
            Box x$1;
            Box qual$1;
            if (group.size() == 1) {
                return group;
            }
            if (group.size() == 2 && group.exists((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$splitProposals$3(x$12))) && group.exists((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$splitProposals$4(x$13))) && ((qual$1 = ((FigureDetector.Proposal)group.last()).region()).contains(x$1 = ((FigureDetector.Proposal)group.head()).region(), x$2 = qual$1.contains$default$2()) || (qual$2 = ((FigureDetector.Proposal)group.head()).region()).contains(x$3 = ((FigureDetector.Proposal)group.last()).region(), x$4 = qual$2.contains$default$2()))) {
                Box region = Box$.MODULE$.container(group.map((Function1<FigureDetector.Proposal, Box> & Serializable & scala.Serializable)x$14 -> x$14.region(), Seq$.MODULE$.canBuildFrom()));
                Option<Tuple3<Box, Box, Box>> splitAttempt = MODULE$.splitRegionHorizontally(region, content);
                if (splitAttempt.isDefined()) {
                    Tuple3<Box, Box, Box> tuple3 = splitAttempt.get();
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    Box upperSplit = tuple3._1();
                    Box lowerSplit = tuple3._2();
                    Box whiteSpace = tuple3._3();
                    Tuple3<Box, Box, Box> tuple32 = new Tuple3<Box, Box, Box>(upperSplit, lowerSplit, whiteSpace);
                    Box upperSplit2 = tuple32._1();
                    Box lowerSplit2 = tuple32._2();
                    Box whiteSpace2 = tuple32._3();
                    Tuple2 tuple2 = group.partition((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$splitProposals$6(x$16)));
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Seq upperProp = (Seq)tuple2._1();
                    Seq lowerProp = (Seq)tuple2._2();
                    Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(upperProp, lowerProp);
                    Seq upperProp2 = tuple22._1();
                    Seq lowerProp2 = tuple22._2();
                    FigureDetector.Proposal qual$3 = (FigureDetector.Proposal)upperProp2.head();
                    Box x$5 = upperSplit2;
                    Some<Tuple2<CaptionParagraph, Box>> x$6 = new Some<Tuple2<CaptionParagraph, Box>>(new Tuple2<CaptionParagraph, Box>(((FigureDetector.Proposal)lowerProp2.head()).caption(), whiteSpace2));
                    CaptionParagraph x$7 = qual$3.copy$default$2();
                    FigureDetector.ProposalDirection x$8 = qual$3.copy$default$3();
                    FigureDetector.Proposal qual$4 = (FigureDetector.Proposal)lowerProp2.head();
                    Box x$9 = lowerSplit2;
                    Some<Tuple2<CaptionParagraph, Box>> x$10 = new Some<Tuple2<CaptionParagraph, Box>>(new Tuple2<CaptionParagraph, Box>(((FigureDetector.Proposal)upperProp2.head()).caption(), whiteSpace2));
                    CaptionParagraph x$11 = qual$4.copy$default$2();
                    FigureDetector.ProposalDirection x$122 = qual$4.copy$default$3();
                    return new $colon$colon<Nothing$>((Nothing$)((Object)qual$3.copy(x$5, x$7, x$8, x$6)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)qual$4.copy(x$9, x$11, x$122, x$10)), Nil$.MODULE$));
                }
                return group;
            }
            return group;
        }, Seq$.MODULE$.canBuildFrom());
        return splitProposals;
    }

    public <T> List<List<T>> cartesianProduct(List<List<T>> xss) {
        List<List<T>> list = xss;
        if (((Object)Nil$.MODULE$).equals(list)) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)Nil$.MODULE$), Nil$.MODULE$);
        }
        if (list instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            List h = (List)$colon$colon.head();
            List t = $colon$colon.tl$access$1();
            return h.flatMap((Function1<Object, List> & Serializable & scala.Serializable)xh -> MODULE$.cartesianProduct(t).map((Function1<List, List> & Serializable & scala.Serializable)xt -> {
                Object object = xh;
                return xt.$colon$colon(object);
            }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        }
        throw new MatchError(list);
    }

    private Box cropToCenter(Box caption, Box proposal, Seq<Box> inCenter, double center) {
        boolean proposalCrossesCenter;
        boolean captionCrossesCenter = caption.x2() > center && caption.x1() <= center;
        boolean bl = proposalCrossesCenter = proposal.x2() > center && proposal.x1() < center;
        if (proposalCrossesCenter && !captionCrossesCenter) {
            if (inCenter.forall((Function1<Box, Object> & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$cropToCenter$1(proposal, x$19)))) {
                if (caption.x1() > center) {
                    return proposal.copy(center, proposal.copy$default$2(), proposal.copy$default$3(), proposal.copy$default$4());
                }
                double x$1 = center;
                double x$2 = proposal.copy$default$1();
                double x$3 = proposal.copy$default$2();
                double x$4 = proposal.copy$default$4();
                return proposal.copy(x$2, x$3, x$1, x$4);
            }
            return proposal;
        }
        return proposal;
    }

    private Box clipUpwardRegion(Box caption, Box region, Seq<Box> graphics, Seq<Paragraph> otherText) {
        Seq containedGraphics = (Seq)graphics.filter((Function1<Box, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$clipUpwardRegion$1(region, g)));
        Tuple2 tuple2 = containedGraphics.partition((Function1<Box, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$clipUpwardRegion$2(g)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq significantGraphics = (Seq)tuple2._1();
        Seq nonSigGraphics = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(significantGraphics, nonSigGraphics);
        Seq significantGraphics2 = tuple22._1();
        Seq nonSigGraphics2 = tuple22._2();
        if (significantGraphics2.nonEmpty()) {
            ObjectRef<Box> cluster = ObjectRef.create(Box$.MODULE$.container(significantGraphics2));
            Seq remainingGraphics = nonSigGraphics2;
            Seq remainingOtherText = (Seq)otherText.filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(region.intersects(p.boundary(), region.intersects$default$2())));
            boolean done = false;
            while (!done) {
                Seq outOfClusterGraphics;
                Tuple2 tuple23 = remainingOtherText.partition((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$clipUpwardRegion$4(cluster, p)));
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                Seq inClusterText = (Seq)tuple23._1();
                Seq outOfClusterText = (Seq)tuple23._2();
                Tuple2<Seq, Seq> tuple24 = new Tuple2<Seq, Seq>(inClusterText, outOfClusterText);
                Seq inClusterText2 = tuple24._1();
                Seq outOfClusterText2 = tuple24._2();
                Tuple2 tuple25 = remainingGraphics.partition((Function1<Box, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$clipUpwardRegion$5(cluster, g)));
                if (tuple25 == null) {
                    throw new MatchError(tuple25);
                }
                Seq inClusterGraphics = (Seq)tuple25._1();
                Seq outOfClusterGraphics2 = (Seq)tuple25._2();
                Tuple2<Seq, Seq> tuple26 = new Tuple2<Seq, Seq>(inClusterGraphics, outOfClusterGraphics2);
                Seq inClusterGraphics2 = tuple26._1();
                remainingGraphics = outOfClusterGraphics = tuple26._2();
                remainingOtherText = outOfClusterText2;
                Seq newBoxes = inClusterGraphics2.$plus$plus(inClusterText2.map((Function1<Paragraph, Box> & Serializable & scala.Serializable)x$23 -> x$23.boundary(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                if (newBoxes.nonEmpty()) {
                    Box box = (Box)cluster.elem;
                    cluster.elem = Box$.MODULE$.container(newBoxes.$plus$colon(box, Seq$.MODULE$.canBuildFrom())).intersectRegion(region).get();
                    continue;
                }
                done = true;
            }
            return (Box)cluster.elem;
        }
        return region;
    }

    private Option<Object> scoreProposal(FigureDetector.Proposal proposal, Seq<Box> graphics, Seq<Box> otherText, Seq<FigureDetector.Proposal> otherProposals, Box bounds) {
        double areaScore;
        block8: {
            block9: {
                block7: {
                    Box boundary = proposal.region();
                    if (otherProposals.exists((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$scoreProposal$1(boundary, p)))) {
                        return None$.MODULE$;
                    }
                    areaScore = boundary.area() / bounds.area();
                    if (graphics.exists((Function1<Box, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(boundary.contains(g, boundary.contains$default$2())))) {
                        areaScore += this.ContainsGraphicBonus();
                    }
                    if (graphics.exists((Function1<Box, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$scoreProposal$3(boundary, g)))) {
                        areaScore += this.ContainsLargeGraphicBonus();
                    }
                    if (!proposal.splitWith().isDefined()) break block7;
                    Tuple2<CaptionParagraph, Box> tuple2 = proposal.splitWith().get();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    CaptionParagraph splitWith = tuple2._1();
                    Box whiteSpace = tuple2._2();
                    Tuple2<CaptionParagraph, Box> tuple22 = new Tuple2<CaptionParagraph, Box>(splitWith, whiteSpace);
                    CaptionParagraph splitWith2 = tuple22._1();
                    Box whiteSpace2 = tuple22._2();
                    areaScore += whiteSpace2.area() * (double)this.SplitWhitespaceBonus() / bounds.area();
                    Enumeration.Value value = splitWith2.figType();
                    Enumeration.Value value2 = proposal.caption().figType();
                    areaScore = (value == null ? value2 != null : !((Object)value).equals(value2)) ? (areaScore *= this.SplitDifferentTypesPenalty()) : (areaScore *= this.SplitSameTypesPenalty());
                    break block8;
                }
                FigureDetector.ProposalDirection proposalDirection = proposal.dir();
                FigureDetector$ProposalDirection$Left$ figureDetector$ProposalDirection$Left$ = FigureDetector$ProposalDirection$Left$.MODULE$;
                if (!(proposalDirection == null ? figureDetector$ProposalDirection$Left$ != null : !proposalDirection.equals(figureDetector$ProposalDirection$Left$))) break block9;
                FigureDetector.ProposalDirection proposalDirection2 = proposal.dir();
                FigureDetector$ProposalDirection$Right$ figureDetector$ProposalDirection$Right$ = FigureDetector$ProposalDirection$Right$.MODULE$;
                if (proposalDirection2 != null ? !proposalDirection2.equals(figureDetector$ProposalDirection$Right$) : figureDetector$ProposalDirection$Right$ != null) break block8;
            }
            areaScore *= this.LeftRightFigurePenalty();
        }
        return new Some<Object>(BoxesRunTime.boxToDouble(areaScore));
    }

    private Tuple2<Object, Object> boxAlignment(Box box1, Box box2) {
        int h;
        int n = box1.x2() < box2.x1() ? -1 : (h = box1.x1() > box2.x2() ? 1 : 0);
        int v = box1.y2() < box2.y1() ? -1 : (box1.y1() > box2.y2() ? 1 : 0);
        return new Tuple2$mcII$sp(h, v);
    }

    private Box boxExpandLR(Box box, Seq<Box> boxes, Box bounds) {
        DoubleRef x1 = DoubleRef.create(bounds.x1());
        DoubleRef x2 = DoubleRef.create(bounds.x2());
        boxes.foreach((Function1<Box, Object> & Serializable & scala.Serializable)box2 -> {
            FigureDetector$.$anonfun$boxExpandLR$1(box, x1, x2, box2);
            return BoxedUnit.UNIT;
        });
        double x$1 = x1.elem;
        double x$2 = x2.elem;
        double x$3 = box.copy$default$2();
        double x$4 = box.copy$default$4();
        return box.copy(x$1, x$3, x$2, x$4);
    }

    private Box boxExpandUD(Box box, Seq<Box> boxes, Box bounds) {
        DoubleRef y1 = DoubleRef.create(bounds.y1());
        DoubleRef y2 = DoubleRef.create(bounds.y2());
        boxes.foreach((Function1<Box, Object> & Serializable & scala.Serializable)box2 -> {
            FigureDetector$.$anonfun$boxExpandUD$1(box, y1, y2, box2);
            return BoxedUnit.UNIT;
        });
        double x$1 = y1.elem;
        double x$2 = y2.elem;
        double x$3 = box.copy$default$1();
        double x$4 = box.copy$default$3();
        return box.copy(x$3, x$1, x$4, x$2);
    }

    private Seq<List<FigureDetector.Proposal>> buildProposals(PageWithBodyText page, DocumentLayout layout) {
        Seq seq;
        Some some;
        Tuple2 tuple2;
        Option option;
        Some some2;
        Tuple2 tuple22;
        Seq<Box> nonFigureContent = page.nonFigureContent();
        Seq<Box> possibleFigureContent = page.possibleFigureContent();
        Seq<Box> allContent = nonFigureContent.$plus$plus(possibleFigureContent, Seq$.MODULE$.canBuildFrom());
        Box bounds = Box$.MODULE$.container(allContent);
        Seq otherTextWordsBBs = page.otherText().flatMap((Function1<Paragraph, List> & Serializable & scala.Serializable)paragraph -> paragraph.lines().flatMap((Function1<Line, List> & Serializable & scala.Serializable)line -> line.words().map((Function1<Word, Box> & Serializable & scala.Serializable)word -> {
            if (word.boundary().height() < (double)10) {
                return word.boundary();
            }
            double x$1 = word.boundary().y2() - 5.0;
            double x$2 = word.boundary().copy$default$1();
            double x$3 = word.boundary().copy$default$3();
            double x$4 = word.boundary().copy$default$4();
            return word.boundary().copy(x$2, x$1, x$3, x$4);
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        boolean twoColumn = layout.twoColumns();
        Option centerColumn = twoColumn ? new Some<Tuple2<Object, Object>>(this.findCenterColumn(page)) : None$.MODULE$;
        Option option2 = centerColumn;
        if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
            double x1 = tuple22._1$mcD$sp();
            double x2 = tuple22._2$mcD$sp();
            option = new Some<Double>(BoxesRunTime.boxToDouble((x1 + x2) / 2.0));
        } else if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        None$ pageCenter = option;
        Option option3 = centerColumn;
        if (option3 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option3).value()) != null) {
            double x1 = tuple2._1$mcD$sp();
            double x2 = tuple2._2$mcD$sp();
            seq = (Seq)possibleFigureContent.filter((Function1<Box, Object> & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$buildProposals$4(x1, x2, box)));
        } else if (None$.MODULE$.equals(option3)) {
            seq = Nil$.MODULE$;
        } else {
            throw new MatchError(option3);
        }
        Seq crossesCenter = seq;
        Seq<List<FigureDetector.Proposal>> proposalsPerCaption = page.captions().map((Function1<CaptionParagraph, List> & Serializable & scala.Serializable)caption -> {
            Box captBox = caption.boundary();
            Tuple4<Double, Double, Double, Double> tuple4 = new Tuple4<Double, Double, Double, Double>(BoxesRunTime.boxToDouble(bounds.x1()), BoxesRunTime.boxToDouble(bounds.y1()), BoxesRunTime.boxToDouble(bounds.x2()), BoxesRunTime.boxToDouble(bounds.y2()));
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            double x1 = BoxesRunTime.unboxToDouble(tuple4._1());
            double y1 = BoxesRunTime.unboxToDouble(tuple4._2());
            double x2 = BoxesRunTime.unboxToDouble(tuple4._3());
            double y2 = BoxesRunTime.unboxToDouble(tuple4._4());
            Tuple4<Double, Double, Double, Double> tuple42 = new Tuple4<Double, Double, Double, Double>(BoxesRunTime.boxToDouble(x1), BoxesRunTime.boxToDouble(y1), BoxesRunTime.boxToDouble(x2), BoxesRunTime.boxToDouble(y2));
            DoubleRef x12 = DoubleRef.create(BoxesRunTime.unboxToDouble(tuple42._1()));
            DoubleRef y12 = DoubleRef.create(BoxesRunTime.unboxToDouble(tuple42._2()));
            DoubleRef x22 = DoubleRef.create(BoxesRunTime.unboxToDouble(tuple42._3()));
            DoubleRef y22 = DoubleRef.create(BoxesRunTime.unboxToDouble(tuple42._4()));
            nonFigureContent.foreach((Function1<Box, Object> & Serializable & scala.Serializable)box -> {
                FigureDetector$.$anonfun$buildProposals$6(captBox, y12, y22, x12, x22, box);
                return BoxedUnit.UNIT;
            });
            List proposals = Nil$.MODULE$;
            if (x12.elem < captBox.x1() - (double)MODULE$.MinProposalWidth()) {
                Box qual$1 = MODULE$.boxExpandUD(captBox.copy(x12.elem, captBox.copy$default$2(), captBox.copy$default$3(), captBox.copy$default$4()), nonFigureContent, bounds);
                double x$5 = captBox.x1();
                double x$6 = qual$1.copy$default$1();
                double x$7 = qual$1.copy$default$2();
                double x$8 = qual$1.copy$default$4();
                Box prop2 = qual$1.copy(x$6, x$7, x$5, x$8);
                if (twoColumn) {
                    boolean containsCenterElement = crossesCenter.exists((Function1<Box, Object> & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean(prop2.contains(x$30, 2.0)));
                    if (containsCenterElement || !(prop2.x1() < BoxesRunTime.unboxToDouble(pageCenter.get())) || !(prop2.x2() > BoxesRunTime.unboxToDouble(pageCenter.get()))) {
                        FigureDetector.Proposal proposal2 = new FigureDetector.Proposal(prop2, (CaptionParagraph)caption, FigureDetector$ProposalDirection$Left$.MODULE$, FigureDetector$Proposal$.MODULE$.apply$default$4());
                        proposals = proposals.$colon$colon(proposal2);
                    }
                } else {
                    FigureDetector.Proposal proposal3 = new FigureDetector.Proposal(prop2, (CaptionParagraph)caption, FigureDetector$ProposalDirection$Left$.MODULE$, FigureDetector$Proposal$.MODULE$.apply$default$4());
                    proposals = proposals.$colon$colon(proposal3);
                }
            }
            if (x22.elem > captBox.x2() + (double)MODULE$.MinProposalWidth()) {
                double x$9 = x22.elem;
                double x$10 = captBox.copy$default$1();
                double x$11 = captBox.copy$default$2();
                double x$12 = captBox.copy$default$4();
                Box qual$2 = MODULE$.boxExpandUD(captBox.copy(x$10, x$11, x$9, x$12), nonFigureContent, bounds);
                double x$13 = captBox.x2();
                double x$14 = qual$2.copy$default$2();
                double x$15 = qual$2.copy$default$3();
                double x$16 = qual$2.copy$default$4();
                Box prop3 = qual$2.copy(x$13, x$14, x$15, x$16);
                if (twoColumn) {
                    boolean containsCenterElement = crossesCenter.exists((Function1<Box, Object> & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean(prop3.contains(x$33, 2.0)));
                    if (containsCenterElement || !(prop3.x1() < BoxesRunTime.unboxToDouble(pageCenter.get())) || !(prop3.x2() > BoxesRunTime.unboxToDouble(pageCenter.get()))) {
                        FigureDetector.Proposal proposal4 = new FigureDetector.Proposal(prop3, (CaptionParagraph)caption, FigureDetector$ProposalDirection$Right$.MODULE$, FigureDetector$Proposal$.MODULE$.apply$default$4());
                        proposals = proposals.$colon$colon(proposal4);
                    }
                } else {
                    FigureDetector.Proposal proposal5 = new FigureDetector.Proposal(prop3, (CaptionParagraph)caption, FigureDetector$ProposalDirection$Right$.MODULE$, FigureDetector$Proposal$.MODULE$.apply$default$4());
                    proposals = proposals.$colon$colon(proposal5);
                }
            }
            if (y12.elem < captBox.y1() - (double)MODULE$.MinProposalHeight()) {
                double x$17 = y12.elem;
                double x$18 = captBox.copy$default$1();
                double x$19 = captBox.copy$default$3();
                double x$20 = captBox.copy$default$4();
                Box qual$3 = MODULE$.boxExpandLR(captBox.copy(x$18, x$17, x$19, x$20), nonFigureContent, bounds);
                double x$21 = captBox.y1();
                double x$22 = qual$3.copy$default$1();
                double x$23 = qual$3.copy$default$2();
                double x$24 = qual$3.copy$default$3();
                Box prop4 = qual$3.copy(x$22, x$23, x$24, x$21);
                Box cropped = twoColumn ? MODULE$.cropToCenter(captBox, prop4, crossesCenter, BoxesRunTime.unboxToDouble(pageCenter.get())) : prop4;
                Box pruned = MODULE$.clipUpwardRegion(captBox, cropped, page.graphics(), page.otherText());
                FigureDetector.Proposal proposal6 = new FigureDetector.Proposal(pruned, (CaptionParagraph)caption, FigureDetector$ProposalDirection$Up$.MODULE$, FigureDetector$Proposal$.MODULE$.apply$default$4());
                proposals = proposals.$colon$colon(proposal6);
            }
            if (y22.elem > captBox.y2() + (double)MODULE$.MinProposalHeight()) {
                double x$25 = y22.elem;
                double x$26 = captBox.copy$default$1();
                double x$27 = captBox.copy$default$2();
                double x$28 = captBox.copy$default$3();
                Box qual$4 = MODULE$.boxExpandLR(captBox.copy(x$26, x$27, x$28, x$25), nonFigureContent, bounds);
                double x$29 = captBox.y2();
                double x$302 = qual$4.copy$default$1();
                double x$31 = qual$4.copy$default$3();
                double x$32 = qual$4.copy$default$4();
                Box prop5 = qual$4.copy(x$302, x$29, x$31, x$32);
                Box cropped = twoColumn ? MODULE$.cropToCenter(captBox, prop5, crossesCenter, BoxesRunTime.unboxToDouble(pageCenter.get())) : prop5;
                FigureDetector.Proposal proposal7 = new FigureDetector.Proposal(cropped, (CaptionParagraph)caption, FigureDetector$ProposalDirection$Down$.MODULE$, FigureDetector$Proposal$.MODULE$.apply$default$4());
                proposals = proposals.$colon$colon(proposal7);
            }
            proposals = proposals.flatMap((Function1<FigureDetector.Proposal, Iterable> & Serializable & scala.Serializable)prop -> {
                Some some;
                Box cropped;
                Option<Box> option = Box$.MODULE$.crop(prop.region(), allContent, -1.0);
                if (option instanceof Some && (cropped = (Box)(some = (Some)option).value()).width() > (double)MODULE$.MinProposalWidth() && cropped.height() > (double)MODULE$.MinProposalHeight()) {
                    boolean partiallyIntersectsWord = otherTextWordsBBs.exists((Function1<Box, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$buildProposals$10(cropped, b)));
                    if (partiallyIntersectsWord) {
                        return Option$.MODULE$.option2Iterable(None$.MODULE$);
                    }
                    return Option$.MODULE$.option2Iterable(new Some<FigureDetector.Proposal>(prop.copy(cropped, prop.copy$default$2(), prop.copy$default$3(), prop.copy$default$4())));
                }
                return Option$.MODULE$.option2Iterable(None$.MODULE$);
            }, List$.MODULE$.canBuildFrom());
            return (List)((TraversableLike)proposals.filter((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)proposal -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$buildProposals$11(possibleFigureContent, proposal)))).filter((Function1<FigureDetector.Proposal, Object> & Serializable & scala.Serializable)proposal -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$buildProposals$12(proposal)));
        }, Seq$.MODULE$.canBuildFrom());
        return proposalsPerCaption;
    }

    private boolean boxOnBoundary(Box box) {
        return box.x1() <= (double)this.boundaryFilterMinDistance() || box.y1() <= (double)this.boundaryFilterMinDistance();
    }

    private boolean inCutInterval(double d) {
        return d >= this.cutFilterIntervalMin() && d <= this.cutFilterIntervalMax();
    }

    private boolean boxCutsFigure(Box box, Seq<Box> possibleFigureContent) {
        return ((IterableLike)possibleFigureContent.map((Function1<Box, Object> & Serializable & scala.Serializable)fig -> BoxesRunTime.boxToDouble(FigureDetector$.$anonfun$boxCutsFigure$1(box, fig)), Seq$.MODULE$.canBuildFrom())).exists((JFunction1$mcZD$sp & scala.Serializable)d -> MODULE$.inCutInterval(d));
    }

    public PageWithFigures locatedFigures(PageWithBodyText page, DocumentLayout layout, Option<VisualLogger> log) {
        Seq<List<FigureDetector.Proposal>> proposals = this.buildProposals(page, layout);
        Seq proposalsWithCaptions = page.captions().zip(proposals, Seq$.MODULE$.canBuildFrom());
        Seq<Box> allContent = page.allContent();
        Box bounds = Box$.MODULE$.container(allContent);
        Seq captionsWithNoProposals = ((TraversableLike)proposalsWithCaptions.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$locatedFigures$1(x$38)))).map((Function1<Tuple2, CaptionParagraph> & Serializable & scala.Serializable)x$39 -> (CaptionParagraph)x$39._1(), Seq$.MODULE$.canBuildFrom());
        Seq validProposals = (Seq)((TraversableLike)proposalsWithCaptions.map((Function1<Tuple2, List> & Serializable & scala.Serializable)x$40 -> (List)x$40._2(), Seq$.MODULE$.canBuildFrom())).filter((Function1<List, Object> & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean(x$41.nonEmpty()));
        long configurationCount = BoxesRunTime.unboxToLong(((TraversableOnce)validProposals.map((Function1<List, Object> & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToLong(x$42.size()), Seq$.MODULE$.canBuildFrom())).product(Numeric$LongIsIntegral$.MODULE$));
        if (validProposals.isEmpty() || configurationCount > 500000L) {
            return new PageWithFigures(page.pageNumber(), ((TraversableOnce)((SeqLike)((TraversableLike)page.otherText().$plus$plus(page.bodyText(), Seq$.MODULE$.canBuildFrom())).$plus$plus(captionsWithNoProposals.map((Function1<CaptionParagraph, Paragraph> & Serializable & scala.Serializable)x$43 -> x$43.paragraph(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).toList(), page.classifiedText(), Nil$.MODULE$, captionsWithNoProposals.map((Function1<CaptionParagraph, Caption> & Serializable & scala.Serializable)captionParagraph -> Caption$.MODULE$.apply((CaptionParagraph)captionParagraph), Seq$.MODULE$.canBuildFrom()));
        }
        Tuple2 bestConfiguration = (Tuple2)((TraversableOnce)((TraversableViewLike)this.cartesianProduct(validProposals.toList()).view().zipWithIndex(SeqView$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                List proposalsToUse = (List)tuple2._1();
                List props = MODULE$.splitProposals(proposalsToUse, allContent).toList();
                List scored = Nil$.MODULE$;
                List scores = Nil$.MODULE$;
                while (props.nonEmpty()) {
                    FigureDetector.Proposal prop = (FigureDetector.Proposal)props.head();
                    props = (List)props.tail();
                    Nil$ nil$ = scored;
                    Option<Object> score = MODULE$.scoreProposal(prop, page.graphics(), page.otherText().map((Function1<Paragraph, Box> & Serializable & scala.Serializable)x$44 -> x$44.boundary(), Seq$.MODULE$.canBuildFrom()), props.$colon$colon$colon(nil$), bounds);
                    FigureDetector.Proposal proposal = prop;
                    scored = scored.$colon$colon(proposal);
                    Option<Object> option = score;
                    scores = scores.$colon$colon(option);
                }
                double overallScore = BoxesRunTime.unboxToDouble(((TraversableOnce)scores.flatMap((Function1<Option, Iterable> & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(x), List$.MODULE$.canBuildFrom())).sum(Numeric$DoubleIsFractional$.MODULE$)) - (double)scores.count((Function1<Option, Object> & Serializable & scala.Serializable)x$48 -> BoxesRunTime.boxToBoolean(x$48.isEmpty()));
                return new Tuple2<Double, Object>(BoxesRunTime.boxToDouble(overallScore), scored.zip(scores, List$.MODULE$.canBuildFrom()).reverse());
            }
            throw new MatchError(tuple2);
        }, SeqView$.MODULE$.canBuildFrom())).maxBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$49 -> BoxesRunTime.boxToDouble(x$49._1$mcD$sp()), Ordering$Double$.MODULE$);
        Tuple2 tuple2 = ((TraversableLike)bestConfiguration._2()).partition((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$50 -> BoxesRunTime.boxToBoolean(FigureDetector$.$anonfun$locatedFigures$13(x$50)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List goodProps = (List)tuple2._1();
        List badProps = (List)tuple2._2();
        Tuple2<List, List> tuple22 = new Tuple2<List, List>(goodProps, badProps);
        List goodProps2 = tuple22._1();
        List badProps2 = tuple22._2();
        List<Figure> figures = goodProps2.map((Function1<Tuple2, Figure> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                FigureDetector.Proposal proposal = (FigureDetector.Proposal)tuple2._1();
                Seq<String> imageText = page.otherText().flatMap((Function1<Paragraph, List> & Serializable & scala.Serializable)p -> p.lines().flatMap((Function1<Line, List> & Serializable & scala.Serializable)l -> l.words().flatMap((Function1<Word, Iterable> & Serializable & scala.Serializable)x0$3 -> {
                    Word word = x0$3;
                    if (proposal.region().contains(word.boundary(), 1.0)) {
                        return Option$.MODULE$.option2Iterable(new Some<String>(word.text()));
                    }
                    return Option$.MODULE$.option2Iterable(None$.MODULE$);
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                CaptionParagraph caption = proposal.caption();
                return new Figure(caption.name(), caption.figType(), caption.page(), caption.text(), imageText, caption.boundary(), proposal.region());
            }
            throw new MatchError(tuple2);
        }, List$.MODULE$.canBuildFrom());
        List<?> failedCaptions = badProps2.map((Function1<Tuple2, CaptionParagraph> & Serializable & scala.Serializable)x$52 -> ((FigureDetector.Proposal)x$52._1()).caption(), List$.MODULE$.canBuildFrom()).$plus$plus(captionsWithNoProposals, List$.MODULE$.canBuildFrom());
        List nonFigureText = this.removeTextInRegions(((TraversableOnce)page.otherText().$plus$plus(page.bodyText(), Seq$.MODULE$.canBuildFrom())).toList(), figures.map((Function1<Figure, Box> & Serializable & scala.Serializable)x$53 -> x$53.regionBoundary(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)failedCaptions.map((Function1<CaptionParagraph, Paragraph> & Serializable & scala.Serializable)x$54 -> x$54.paragraph(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return new PageWithFigures(page.pageNumber(), (Seq)nonFigureText.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), page.classifiedText(), figures, failedCaptions.map((Function1<CaptionParagraph, Caption> & Serializable & scala.Serializable)captionParagraph -> Caption$.MODULE$.apply((CaptionParagraph)captionParagraph), List$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$removeTextInRegions$2(List regions$1, Line l) {
        return !regions$1.exists((Function1<Box, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.contains(l.boundary(), x$1.contains$default$2())));
    }

    public static final /* synthetic */ boolean $anonfun$findCenterColumn$3(double textCenter$1, Paragraph p) {
        return p.boundary().x2() < textCenter$1;
    }

    public static final /* synthetic */ boolean $anonfun$findCenterColumn$4(double textCenter$1, Paragraph p) {
        return p.boundary().x1() > textCenter$1;
    }

    public static final /* synthetic */ double $anonfun$findCenterColumn$5(Paragraph x$4) {
        return x$4.boundary().x2();
    }

    public static final /* synthetic */ double $anonfun$findCenterColumn$6(Paragraph x$5) {
        return x$5.boundary().x1();
    }

    public static final /* synthetic */ boolean $anonfun$splitRegionHorizontally$2(Box proposalRegion$1, Box e) {
        return e.y1() - proposalRegion$1.y1() > proposalRegion$1.height() / (double)MODULE$.SplitVerticalRegionMinHeightFraction() && proposalRegion$1.y2() - e.y2() > proposalRegion$1.height() / (double)MODULE$.SplitVerticalRegionMinHeightFraction() && e.height() > (double)2;
    }

    public static final /* synthetic */ boolean $anonfun$splitProposals$1(ObjectRef proposalToCheck$1, FigureDetector.Proposal x$8) {
        return x$8.region().intersects(((FigureDetector.Proposal)((Seq)proposalToCheck$1.elem).head()).region(), -2.0);
    }

    public static final /* synthetic */ boolean $anonfun$splitProposals$3(FigureDetector.Proposal x$12) {
        FigureDetector.ProposalDirection proposalDirection = x$12.dir();
        FigureDetector$ProposalDirection$Up$ figureDetector$ProposalDirection$Up$ = FigureDetector$ProposalDirection$Up$.MODULE$;
        return !(proposalDirection != null ? !proposalDirection.equals(figureDetector$ProposalDirection$Up$) : figureDetector$ProposalDirection$Up$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitProposals$4(FigureDetector.Proposal x$13) {
        FigureDetector.ProposalDirection proposalDirection = x$13.dir();
        FigureDetector$ProposalDirection$Down$ figureDetector$ProposalDirection$Down$ = FigureDetector$ProposalDirection$Down$.MODULE$;
        return !(proposalDirection != null ? !proposalDirection.equals(figureDetector$ProposalDirection$Down$) : figureDetector$ProposalDirection$Down$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitProposals$6(FigureDetector.Proposal x$16) {
        FigureDetector.ProposalDirection proposalDirection = x$16.dir();
        FigureDetector$ProposalDirection$Down$ figureDetector$ProposalDirection$Down$ = FigureDetector$ProposalDirection$Down$.MODULE$;
        return !(proposalDirection != null ? !proposalDirection.equals(figureDetector$ProposalDirection$Down$) : figureDetector$ProposalDirection$Down$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$cropToCenter$1(Box proposal$1, Box x$19) {
        return !proposal$1.contains(x$19, proposal$1.contains$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$clipUpwardRegion$1(Box region$1, Box g) {
        return region$1.intersectArea(g) / g.area() > 0.95;
    }

    public static final /* synthetic */ boolean $anonfun$clipUpwardRegion$2(Box g) {
        return g.area() > (double)MODULE$.ClipRegionMinGraphicSize();
    }

    public static final /* synthetic */ boolean $anonfun$clipUpwardRegion$4(ObjectRef cluster$1, Paragraph p) {
        double yDist = ((Box)cluster$1.elem).y1() - p.boundary().y2();
        if (p.boundary().area() < (double)MODULE$.ClipRegionLargeTextSize()) {
            return yDist < (double)MODULE$.ClipRegionMaxLargeTextDistance();
        }
        return yDist < (double)MODULE$.ClipRegionMaxTextDistance();
    }

    public static final /* synthetic */ boolean $anonfun$clipUpwardRegion$5(ObjectRef cluster$1, Box g) {
        double yDist = ((Box)cluster$1.elem).y1() - g.y2();
        return yDist < (double)MODULE$.ClipRegionMaxGraphicDistance();
    }

    public static final /* synthetic */ boolean $anonfun$scoreProposal$1(Box boundary$1, FigureDetector.Proposal p) {
        return p.region().intersects(boundary$1, -2.0);
    }

    public static final /* synthetic */ boolean $anonfun$scoreProposal$3(Box boundary$1, Box g) {
        return g.area() > (double)MODULE$.LargeGraphicThreshold() && boundary$1.contains(g, boundary$1.contains$default$2());
    }

    public static final /* synthetic */ void $anonfun$boxExpandLR$1(Box box$1, DoubleRef x1$1, DoubleRef x2$1, Box box2) {
        Tuple2<Object, Object> tuple2 = MODULE$.boxAlignment(box$1, box2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int h = tuple2._1$mcI$sp();
        int v = tuple2._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(h, v);
        int h2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
        int v2 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
        if (v2 == 0) {
            if (h2 == 1) {
                x1$1.elem = Math.max(x1$1.elem, box2.x2());
                return;
            }
            if (h2 == -1) {
                x2$1.elem = Math.min(x2$1.elem, box2.x1());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$boxExpandUD$1(Box box$2, DoubleRef y1$1, DoubleRef y2$1, Box box2) {
        Tuple2<Object, Object> tuple2 = MODULE$.boxAlignment(box$2, box2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int h = tuple2._1$mcI$sp();
        int v = tuple2._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(h, v);
        int h2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
        int v2 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
        if (h2 == 0) {
            if (v2 == 1) {
                y1$1.elem = Math.max(y1$1.elem, box2.y2());
                return;
            }
            if (v2 == -1) {
                y2$1.elem = Math.min(y2$1.elem, box2.y1());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildProposals$4(double x1$2, double x2$2, Box box) {
        return box.x1() < x1$2 && box.x2() > x2$2;
    }

    public static final /* synthetic */ void $anonfun$buildProposals$6(Box captBox$1, DoubleRef y1$2, DoubleRef y2$2, DoubleRef x1$3, DoubleRef x2$3, Box box) {
        Tuple2<Object, Object> tuple2 = MODULE$.boxAlignment(captBox$1, box);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int h = tuple2._1$mcI$sp();
        int v = tuple2._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(h, v);
        int h2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
        int v2 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
        if (h2 == 0) {
            if (v2 == 1) {
                y1$2.elem = Math.max(y1$2.elem, box.y2());
                return;
            }
            if (v2 == -1) {
                y2$2.elem = Math.min(box.y1(), y2$2.elem);
                return;
            }
            return;
        }
        if (v2 == 0) {
            if (h2 == 1) {
                x1$3.elem = Math.max(x1$3.elem, box.x2());
                return;
            }
            if (h2 == -1) {
                x2$3.elem = Math.min(x2$3.elem, box.x1());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildProposals$10(Box cropped$1, Box b) {
        return b.intersects(cropped$1, -2.0) && !cropped$1.contains(b, 1.0);
    }

    public static final /* synthetic */ boolean $anonfun$buildProposals$11(Seq possibleFigureContent$1, FigureDetector.Proposal proposal) {
        return !MODULE$.boxCutsFigure(proposal.region(), possibleFigureContent$1);
    }

    public static final /* synthetic */ boolean $anonfun$buildProposals$12(FigureDetector.Proposal proposal) {
        return !MODULE$.boxOnBoundary(proposal.region());
    }

    public static final /* synthetic */ double $anonfun$boxCutsFigure$1(Box box$3, Box fig) {
        return fig.intersectArea(box$3) / fig.area();
    }

    public static final /* synthetic */ boolean $anonfun$locatedFigures$1(Tuple2 x$38) {
        return ((SeqLike)x$38._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$locatedFigures$13(Tuple2 x$50) {
        return ((Option)x$50._2()).isDefined();
    }

    private FigureDetector$() {
        MODULE$ = this;
        this.MinProposalHeight = 15;
        this.MinProposalWidth = 20;
        this.ClipRegionMinGraphicSize = 5000;
        this.ClipRegionLargeTextSize = 3000;
        this.ClipRegionMaxTextDistance = 4;
        this.ClipRegionMaxLargeTextDistance = 10;
        this.ClipRegionMaxGraphicDistance = 20;
        this.LeftRightFigurePenalty = 0.75;
        this.SplitDifferentTypesPenalty = 0.75;
        this.SplitSameTypesPenalty = 0.5;
        this.SplitWhitespaceBonus = 2;
        this.LargeGraphicThreshold = 2000;
        this.ContainsGraphicBonus = 0.1;
        this.ContainsLargeGraphicBonus = 0.15;
        this.SplitVerticalRegionMinHeightFraction = 4;
        this.cutFilterIntervalMin = 0.1;
        this.cutFilterIntervalMax = 0.9;
        this.boundaryFilterMinDistance = 30;
    }
}

