/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.allenai.pdffigures2.Figure;
import org.allenai.pdffigures2.FigureExtractor;
import org.allenai.pdffigures2.FigureExtractor$;
import org.allenai.pdffigures2.FigureExtractorBatchCli;
import org.allenai.pdffigures2.FigureExtractorBatchCli$;
import org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch$;
import org.allenai.pdffigures2.FigureRenderer$;
import org.allenai.pdffigures2.FiguresInDocument;
import org.allenai.pdffigures2.JsonProtocol$;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.RasterizedFigure;
import org.allenai.pdffigures2.RasterizedFiguresInDocument;
import org.allenai.pdffigures2.SavedFigure;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.ParSeq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scopt.OptionParser;
import scopt.Read$;
import spray.json.RootJsonFormat;

public final class FigureExtractorBatchCli$
implements Logging {
    public static FigureExtractorBatchCli$ MODULE$;
    private final RootJsonFormat<FigureExtractorBatchCli.ProcessingStatistics> processingStatisticsFormat;
    private final RootJsonFormat<FigureExtractorBatchCli.ProcessingError> processingErrorFormat;
    private final OptionParser<FigureExtractorBatchCli.CliConfigBatch> Parser;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new FigureExtractorBatchCli$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public RootJsonFormat<FigureExtractorBatchCli.ProcessingStatistics> processingStatisticsFormat() {
        return this.processingStatisticsFormat;
    }

    public RootJsonFormat<FigureExtractorBatchCli.ProcessingError> processingErrorFormat() {
        return this.processingErrorFormat;
    }

    public OptionParser<FigureExtractorBatchCli.CliConfigBatch> Parser() {
        return this.Parser;
    }

    public Seq<String> getFilenames(String prefix, String docName, String format, Seq<Figure> figures) {
        Map namesUsed = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        return figures.map((Function1<Figure, String> & Serializable & scala.Serializable)fig -> {
            String figureName = new StringBuilder(0).append(fig.figType()).append(fig.name()).toString();
            namesUsed.update(figureName, namesUsed.getOrElse(figureName, (JFunction0$mcI$sp & scala.Serializable)() -> 1));
            int id = BoxesRunTime.unboxToInt(namesUsed.apply(figureName));
            String filename = new StringBuilder(3).append(prefix).append(docName).append("-").append(figureName).append("-").append(id).append(".").append(format).toString();
            return filename;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<SavedFigure> saveRasterizedFigures(String prefix, String docName, String format, int dpi, Seq<RasterizedFigure> figures, PDDocument doc) {
        Seq<String> filenames = this.getFilenames(prefix, docName, format, figures.map((Function1<RasterizedFigure, Figure> & Serializable & scala.Serializable)x$4 -> x$4.figure(), Seq$.MODULE$.canBuildFrom()));
        return FigureRenderer$.MODULE$.saveRasterizedFigures(filenames.zip(figures, Seq$.MODULE$.canBuildFrom()), format, dpi);
    }

    public Either<FigureExtractorBatchCli.ProcessingError, FigureExtractorBatchCli.ProcessingStatistics> processFile(File inputFile, FigureExtractorBatchCli.CliConfigBatch config) {
        Either either;
        block25: {
            long fileStartTime = System.nanoTime();
            FigureExtractor figureExtractor = FigureExtractor$.MODULE$.apply();
            try (PDDocument doc = null;){
                try {
                    int n;
                    doc = PDDocument.load(inputFile);
                    boolean useCairo = FigureRenderer$.MODULE$.CairoFormat().contains(config.figureFormat());
                    String inputName = inputFile.getName();
                    String truncatedName = inputName.substring(0, inputName.lastIndexOf(46));
                    if (config.fullTextPrefix().isDefined()) {
                        int numFigures;
                        int n2;
                        String outputFilename = new StringBuilder(5).append((Object)config.fullTextPrefix().get()).append(truncatedName).append(".json").toString();
                        if (config.figureImagePrefix().isDefined() && !useCairo) {
                            FigureExtractor.DocumentWithRasterizedFigures document = figureExtractor.getRasterizedFiguresWithText(doc, config.dpi(), figureExtractor.getRasterizedFiguresWithText$default$3(), figureExtractor.getRasterizedFiguresWithText$default$4());
                            Seq<SavedFigure> savedFigures = this.saveRasterizedFigures(config.figureImagePrefix().get(), truncatedName, config.figureFormat(), config.dpi(), document.figures(), doc);
                            FigureExtractor.DocumentWithSavedFigures documentWithFigures = new FigureExtractor.DocumentWithSavedFigures(savedFigures, document.abstractText(), document.sections());
                            FigureRenderer$.MODULE$.saveAsJSON(outputFilename, documentWithFigures, JsonProtocol$.MODULE$.documentWithFiguresFormat());
                            n2 = document.figures().size();
                        } else {
                            FigureExtractor.Document document = figureExtractor.getFiguresWithText(doc, figureExtractor.getFiguresWithText$default$2(), figureExtractor.getFiguresWithText$default$3());
                            if (useCairo) {
                                Seq<String> filenames = this.getFilenames(config.figureImagePrefix().get(), truncatedName, config.figureFormat(), document.figures());
                                Seq<SavedFigure> savedFigures = FigureRenderer$.MODULE$.saveFiguresAsImagesCairo(doc, filenames.zip(document.figures(), Seq$.MODULE$.canBuildFrom()), config.figureFormat(), config.dpi()).toSeq();
                                FigureExtractor.DocumentWithSavedFigures savedDocument = new FigureExtractor.DocumentWithSavedFigures(savedFigures, document.abstractText(), document.sections());
                                FigureRenderer$.MODULE$.saveAsJSON(outputFilename, savedDocument, JsonProtocol$.MODULE$.documentWithFiguresFormat());
                            } else {
                                FigureRenderer$.MODULE$.saveAsJSON(outputFilename, document, JsonProtocol$.MODULE$.documentFormat());
                            }
                            n2 = document.figures().size();
                        }
                        n = numFigures = n2;
                    } else {
                        Either either2;
                        Tuple2 tuple2;
                        Tuple2 tuple22;
                        if (config.figureImagePrefix().isDefined() && !useCairo) {
                            RasterizedFiguresInDocument figuresWithErrors = figureExtractor.getRasterizedFiguresWithErrors(doc, config.dpi(), figureExtractor.getRasterizedFiguresWithErrors$default$3(), figureExtractor.getRasterizedFiguresWithErrors$default$4());
                            Seq<SavedFigure> savedFigures = this.saveRasterizedFigures(config.figureImagePrefix().get(), truncatedName, config.figureFormat(), config.dpi(), figuresWithErrors.figures(), doc);
                            tuple22 = new Tuple2(package$.MODULE$.Left().apply(savedFigures), figuresWithErrors.failedCaptions());
                        } else {
                            FiguresInDocument figuresWithErrors = figureExtractor.getFiguresWithErrors(doc, figureExtractor.getFiguresWithErrors$default$2(), figureExtractor.getFiguresWithErrors$default$3());
                            if (useCairo) {
                                Seq<String> filenames = this.getFilenames(config.figureImagePrefix().get(), truncatedName, config.figureFormat(), figuresWithErrors.figures());
                                Seq savedFigures = FigureRenderer$.MODULE$.saveFiguresAsImagesCairo(doc, filenames.zip(figuresWithErrors.figures(), Seq$.MODULE$.canBuildFrom()), config.figureFormat(), config.dpi()).toSeq();
                                tuple22 = new Tuple2(package$.MODULE$.Left().apply(savedFigures), figuresWithErrors.failedCaptions());
                            } else {
                                tuple22 = tuple2 = new Tuple2(package$.MODULE$.Right().apply(figuresWithErrors.figures()), figuresWithErrors.failedCaptions());
                            }
                        }
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Either figures = tuple2._1();
                        Seq failedCaptions = (Seq)tuple2._2();
                        Tuple2<Either, Seq> tuple23 = new Tuple2<Either, Seq>(figures, failedCaptions);
                        Either figures2 = tuple23._1();
                        Seq failedCaptions2 = tuple23._2();
                        if (config.figureDataPrefix().isDefined()) {
                            String outputFilename = new StringBuilder(5).append((Object)config.figureDataPrefix().get()).append(truncatedName).append(".json").toString();
                            if (config.saveRegionlessCaptions()) {
                                scala.collection.immutable.Map toSave = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("figures"), package$.MODULE$.Left().apply(figures2)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("regionless-captions"), package$.MODULE$.Right().apply(failedCaptions2))}));
                                FigureRenderer$.MODULE$.saveAsJSON(outputFilename, toSave, JsonProtocol$.MODULE$.mapFormat(JsonProtocol$.MODULE$.StringJsonFormat(), JsonProtocol$.MODULE$.eitherFormat(JsonProtocol$.MODULE$.eitherFormat(JsonProtocol$.MODULE$.seqFormat(JsonProtocol$.MODULE$.savedFigureFormat()), JsonProtocol$.MODULE$.seqFormat(JsonProtocol$.MODULE$.figureFormat())), JsonProtocol$.MODULE$.seqFormat(JsonProtocol$.MODULE$.captionFormat()))));
                            } else {
                                Either toSave = figures2;
                                FigureRenderer$.MODULE$.saveAsJSON(outputFilename, toSave, JsonProtocol$.MODULE$.eitherFormat(JsonProtocol$.MODULE$.seqFormat(JsonProtocol$.MODULE$.savedFigureFormat()), JsonProtocol$.MODULE$.seqFormat(JsonProtocol$.MODULE$.figureFormat())));
                            }
                        }
                        if ((either2 = figures2) instanceof Left) {
                            Left left = (Left)either2;
                            Seq savedFigures = (Seq)left.value();
                            n = savedFigures.size();
                        } else if (either2 instanceof Right) {
                            Right right = (Right)either2;
                            Seq figs = (Seq)right.value();
                            n = figs.size();
                        } else {
                            throw new MatchError(either2);
                        }
                    }
                    int numFigures = n;
                    long timeTaken = System.nanoTime() - fileStartTime;
                    this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Finished ").append(inputFile.getName()).append(" in ").append((double)(timeTaken / 1000000L) / 1000.0).append(" seconds").toString());
                    either = package$.MODULE$.Right().apply(new FigureExtractorBatchCli.ProcessingStatistics(inputFile.getAbsolutePath(), doc.getNumberOfPages(), numFigures, timeTaken / 1000000L));
                }
                catch (Exception e) {
                    if (config.ignoreErrors()) {
                        this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error: ").append(e).append(" on document ").append(inputFile.getName()).toString());
                        either = package$.MODULE$.Left().apply(new FigureExtractorBatchCli.ProcessingError(inputFile.getAbsolutePath(), Option$.MODULE$.apply(e.getMessage()), e.getClass().getName()));
                        break block25;
                    }
                    throw e;
                }
            }
        }
        return either;
    }

    public void run(FigureExtractorBatchCli.CliConfigBatch config) {
        Seq errors;
        Seq seq;
        long startTime = System.nanoTime();
        if (!config.debugLogging()) {
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("root");
            root.setLevel(Level.INFO);
        }
        if (config.threads() == 1) {
            seq = ((TraversableLike)config.inputFiles().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Either> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    File inputFile = (File)tuple2._1();
                    int fileNum = tuple2._2$mcI$sp();
                    MODULE$.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Processing file ").append(inputFile.getName()).append(" ").append("(").append(fileNum + 1).append(" of ").append(config.inputFiles().size()).append(")").toString());
                    return MODULE$.processFile(inputFile, config);
                }
                throw new MatchError(tuple2);
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            ParSeq parFiles = (ParSeq)config.inputFiles().par();
            if (config.threads() != 0) {
                parFiles.tasksupport_$eq(new ForkJoinTaskSupport(new ForkJoinPool(config.threads())));
            }
            AtomicInteger onPdf = new AtomicInteger(0);
            seq = ((ParIterableLike)parFiles.map((Function1<File, Either> & Serializable & scala.Serializable)inputFile -> {
                int curPdf = onPdf.incrementAndGet();
                MODULE$.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Processing file ").append(inputFile.getName()).append(" ").append("(").append(curPdf).append(" of ").append(config.inputFiles().size()).append(")").toString());
                return MODULE$.processFile((File)inputFile, config);
            }, ParSeq$.MODULE$.canBuildFrom())).toList();
        }
        Seq results = seq;
        long totalTime = System.nanoTime() - startTime;
        this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Finished processing ").append(config.inputFiles().size()).append(" files").toString());
        this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Took ").append((double)(totalTime / 1000000L) / 1000.0).append(" seconds").toString());
        if (config.saveStats().isDefined()) {
            FigureRenderer$.MODULE$.saveAsJSON(config.saveStats().get(), results, JsonProtocol$.MODULE$.seqFormat(JsonProtocol$.MODULE$.eitherFormat(this.processingErrorFormat(), this.processingStatisticsFormat())));
            this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Stats saved to ").append((Object)config.saveStats().get()).toString());
        }
        if ((errors = results.flatMap((Function1<Either, Iterable> & Serializable & scala.Serializable)x0$2 -> {
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                FigureExtractorBatchCli.ProcessingError pe = (FigureExtractorBatchCli.ProcessingError)left.value();
                return Option$.MODULE$.option2Iterable(new Some<FigureExtractorBatchCli.ProcessingError>(pe));
            }
            return Option$.MODULE$.option2Iterable(None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom())).isEmpty()) {
            this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> "No errors");
            return;
        }
        String errorString = ((TraversableOnce)errors.map((Function1<FigureExtractorBatchCli.ProcessingError, String> & Serializable & scala.Serializable)x0$3 -> {
            FigureExtractorBatchCli.ProcessingError processingError = x0$3;
            if (processingError != null) {
                String name = processingError.filename();
                Option<String> msg = processingError.msg();
                String errorName = processingError.className();
                return new StringBuilder(4).append(name).append(": ").append(errorName).append(": ").append(msg).toString();
            }
            throw new MatchError(processingError);
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        if (config.saveStats().isDefined()) {
            this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Errors ").append(errors.size()).append(" files").toString());
            return;
        }
        this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Errors on the following files:\n").append(errorString).toString());
    }

    public void main(String[] args) {
        Option<FigureExtractorBatchCli.CliConfigBatch> option = this.Parser().parse(Predef$.MODULE$.wrapRefArray((Object[])args), new FigureExtractorBatchCli.CliConfigBatch(FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$1(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$2(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$3(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$4(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$5(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$6(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$7(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$8(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$9(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$10(), FigureExtractorBatchCli$CliConfigBatch$.MODULE$.apply$default$11()));
        if (option instanceof Some) {
            Some some = (Some)option;
            FigureExtractorBatchCli.CliConfigBatch config = (FigureExtractorBatchCli.CliConfigBatch)some.value();
            this.run(config);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            System.exit(1);
            return;
        }
        throw new MatchError(option);
    }

    private final void logger$lzycompute$1() {
        FigureExtractorBatchCli$ figureExtractorBatchCli$ = this;
        synchronized (figureExtractorBatchCli$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        FigureExtractorBatchCli$ figureExtractorBatchCli$ = this;
        synchronized (figureExtractorBatchCli$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ FigureExtractorBatchCli.ProcessingStatistics $anonfun$processingStatisticsFormat$1(String filename, int numPages, int numFigures, long timeInMillis) {
        return new FigureExtractorBatchCli.ProcessingStatistics(filename, numPages, numFigures, timeInMillis);
    }

    private FigureExtractorBatchCli$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.processingStatisticsFormat = JsonProtocol$.MODULE$.jsonFormat4((Function4<String, Object, Object, Object, FigureExtractorBatchCli.ProcessingStatistics> & Serializable & scala.Serializable)(filename, numPages, numFigures, timeInMillis) -> FigureExtractorBatchCli$.$anonfun$processingStatisticsFormat$1(filename, BoxesRunTime.unboxToInt(numPages), BoxesRunTime.unboxToInt(numFigures), BoxesRunTime.unboxToLong(timeInMillis)), JsonProtocol$.MODULE$.StringJsonFormat(), JsonProtocol$.MODULE$.IntJsonFormat(), JsonProtocol$.MODULE$.IntJsonFormat(), JsonProtocol$.MODULE$.LongJsonFormat(), ClassTag$.MODULE$.apply(FigureExtractorBatchCli.ProcessingStatistics.class));
        this.processingErrorFormat = JsonProtocol$.MODULE$.jsonFormat3((Function3<String, Option, String, FigureExtractorBatchCli.ProcessingError> & Serializable & scala.Serializable)(filename, msg, className) -> new FigureExtractorBatchCli.ProcessingError((String)filename, (Option<String>)msg, (String)className), JsonProtocol$.MODULE$.StringJsonFormat(), JsonProtocol$.MODULE$.optionFormat(JsonProtocol$.MODULE$.StringJsonFormat()), JsonProtocol$.MODULE$.StringJsonFormat(), ClassTag$.MODULE$.apply(FigureExtractorBatchCli.ProcessingError.class));
        this.Parser = new OptionParser<FigureExtractorBatchCli.CliConfigBatch>(){

            public static final /* synthetic */ FigureExtractorBatchCli.CliConfigBatch $anonfun$new$3(int dpi, FigureExtractorBatchCli.CliConfigBatch c) {
                int x$1 = dpi;
                Seq<File> x$2 = c.copy$default$1();
                Option<String> x$3 = c.copy$default$2();
                boolean x$4 = c.copy$default$4();
                Option<String> x$5 = c.copy$default$5();
                boolean x$6 = c.copy$default$6();
                int x$7 = c.copy$default$7();
                boolean x$8 = c.copy$default$8();
                Option<String> x$9 = c.copy$default$9();
                Option<String> x$10 = c.copy$default$10();
                String x$11 = c.copy$default$11();
                return c.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
            }

            public static final /* synthetic */ Either $anonfun$new$4(anon.1 $this, int dpi) {
                if (dpi > 0) {
                    return $this.success();
                }
                return $this.failure("DPI must > 0");
            }

            public static final /* synthetic */ FigureExtractorBatchCli.CliConfigBatch $anonfun$new$7(int t, FigureExtractorBatchCli.CliConfigBatch c) {
                int x$23 = t;
                Seq<File> x$24 = c.copy$default$1();
                Option<String> x$25 = c.copy$default$2();
                int x$26 = c.copy$default$3();
                boolean x$27 = c.copy$default$4();
                Option<String> x$28 = c.copy$default$5();
                boolean x$29 = c.copy$default$6();
                boolean x$30 = c.copy$default$8();
                Option<String> x$31 = c.copy$default$9();
                Option<String> x$32 = c.copy$default$10();
                String x$33 = c.copy$default$11();
                return c.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$23, x$30, x$31, x$32, x$33);
            }

            public static final /* synthetic */ Either $anonfun$new$8(anon.1 $this, int t) {
                if (t >= 0) {
                    return $this.success();
                }
                return $this.failure("Threads must be >= 0");
            }

            public static final /* synthetic */ boolean $anonfun$new$18(File f) {
                return !f.exists() || f.isDirectory() || !f.getName().endsWith(".pdf");
            }
            {
                this.head(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"figure-extractor-batch"}));
                this.arg("<input>", Read$.MODULE$.seqRead(Read$.MODULE$.stringRead())).required().action((Function2<Seq, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(i, c) -> {
                    File file;
                    $colon$colon<Nothing$> inputFiles = i.size() == 1 ? ((file = new File((String)i.head())).isDirectory() ? new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).toList() : new $colon$colon<Nothing$>((Nothing$)((Object)file), Nil$.MODULE$)) : ((TraversableOnce)i.map((Function1<String, File> & Serializable & scala.Serializable)f -> new File((String)f), Seq$.MODULE$.canBuildFrom())).toList();
                    return c.copy(inputFiles, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11());
                }).text("input PDF(s) or directory containing PDFs");
                this.opt('i', "dpi", Read$.MODULE$.intRead()).action((Function2<Object, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(dpi, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt(dpi), c)).text("DPI to save the figures in (default 150)").validate((Function1<Object, Either<String, BoxedUnit>>)(Function1<Object, Either> & Serializable & scala.Serializable)dpi -> anon.1.$anonfun$new$4(this, BoxesRunTime.unboxToInt(dpi)));
                this.opt('s', "save-stats", Read$.MODULE$.stringRead()).action((Function2<String, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(s, c) -> {
                    Some<String> x$12 = new Some<String>((String)s);
                    Seq<File> x$13 = c.copy$default$1();
                    Option<String> x$14 = c.copy$default$2();
                    int x$15 = c.copy$default$3();
                    boolean x$16 = c.copy$default$4();
                    boolean x$17 = c.copy$default$6();
                    int x$18 = c.copy$default$7();
                    boolean x$19 = c.copy$default$8();
                    Option<String> x$20 = c.copy$default$9();
                    Option<String> x$21 = c.copy$default$10();
                    String x$22 = c.copy$default$11();
                    return c.copy(x$13, x$14, x$15, x$16, x$12, x$17, x$18, x$19, x$20, x$21, x$22);
                }).validate((Function1<String, Either<String, BoxedUnit>>)(Function1<String, Either> & Serializable & scala.Serializable)s -> {
                    File f = new File((String)s);
                    if (!f.exists() || f.canWrite() && !f.isDirectory()) {
                        return this.success();
                    }
                    return this.failure(new StringBuilder(20).append("Can't write to file ").append((String)s).toString());
                }).text("Save the errors and timing information to the given file in JSON fromat");
                this.opt('t', "threads", Read$.MODULE$.intRead()).action((Function2<Object, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(t, c) -> anon.1.$anonfun$new$7(BoxesRunTime.unboxToInt(t), c)).validate((Function1<Object, Either<String, BoxedUnit>>)(Function1<Object, Either> & Serializable & scala.Serializable)t -> anon.1.$anonfun$new$8(this, BoxesRunTime.unboxToInt(t))).text("Number of threads to use, 0 means using Scala's default");
                this.opt('e', "ignore-error", Read$.MODULE$.unitRead()).action((Function2<BoxedUnit, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(x$1, c) -> {
                    boolean x$34 = true;
                    Seq<File> x$35 = c.copy$default$1();
                    Option<String> x$36 = c.copy$default$2();
                    int x$37 = c.copy$default$3();
                    Option<String> x$38 = c.copy$default$5();
                    boolean x$39 = c.copy$default$6();
                    int x$40 = c.copy$default$7();
                    boolean x$41 = c.copy$default$8();
                    Option<String> x$42 = c.copy$default$9();
                    Option<String> x$43 = c.copy$default$10();
                    String x$44 = c.copy$default$11();
                    return c.copy(x$35, x$36, x$37, x$34, x$38, x$39, x$40, x$41, x$42, x$43, x$44);
                }).text("Don't stop on errors, errors will be logged and also saved in `save-stats` if set");
                this.opt('q', "quiet", Read$.MODULE$.unitRead()).action((Function2<BoxedUnit, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(x$2, c) -> {
                    boolean x$45 = false;
                    Seq<File> x$46 = c.copy$default$1();
                    Option<String> x$47 = c.copy$default$2();
                    int x$48 = c.copy$default$3();
                    boolean x$49 = c.copy$default$4();
                    Option<String> x$50 = c.copy$default$5();
                    boolean x$51 = c.copy$default$6();
                    int x$52 = c.copy$default$7();
                    Option<String> x$53 = c.copy$default$9();
                    Option<String> x$54 = c.copy$default$10();
                    String x$55 = c.copy$default$11();
                    return c.copy(x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$45, x$53, x$54, x$55);
                }).text("Switches logging to INFO level");
                this.opt('d', "figure-data-prefix", Read$.MODULE$.stringRead()).action((Function2<String, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(o, c) -> {
                    Some<String> x$56 = new Some<String>((String)o);
                    Seq<File> x$57 = c.copy$default$1();
                    int x$58 = c.copy$default$3();
                    boolean x$59 = c.copy$default$4();
                    Option<String> x$60 = c.copy$default$5();
                    boolean x$61 = c.copy$default$6();
                    int x$62 = c.copy$default$7();
                    boolean x$63 = c.copy$default$8();
                    Option<String> x$64 = c.copy$default$9();
                    Option<String> x$65 = c.copy$default$10();
                    String x$66 = c.copy$default$11();
                    return c.copy(x$57, x$56, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66);
                }).text("Save JSON figure data to '<data-prefix><input_filename>.json'");
                this.opt('c', "save-regionless-captions", Read$.MODULE$.unitRead()).action((Function2<BoxedUnit, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(x$3, c) -> {
                    boolean x$67 = true;
                    Seq<File> x$68 = c.copy$default$1();
                    Option<String> x$69 = c.copy$default$2();
                    int x$70 = c.copy$default$3();
                    boolean x$71 = c.copy$default$4();
                    Option<String> x$72 = c.copy$default$5();
                    int x$73 = c.copy$default$7();
                    boolean x$74 = c.copy$default$8();
                    Option<String> x$75 = c.copy$default$9();
                    Option<String> x$76 = c.copy$default$10();
                    String x$77 = c.copy$default$11();
                    return c.copy(x$68, x$69, x$70, x$71, x$72, x$67, x$73, x$74, x$75, x$76, x$77);
                }).text("Include captions for which no figure regions were found in the JSON data");
                this.opt('g', "full-text-prefix", Read$.MODULE$.stringRead()).action((Function2<String, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(f, c) -> {
                    Some<String> x$78 = new Some<String>((String)f);
                    Seq<File> x$79 = c.copy$default$1();
                    Option<String> x$80 = c.copy$default$2();
                    int x$81 = c.copy$default$3();
                    boolean x$82 = c.copy$default$4();
                    Option<String> x$83 = c.copy$default$5();
                    boolean x$84 = c.copy$default$6();
                    int x$85 = c.copy$default$7();
                    boolean x$86 = c.copy$default$8();
                    Option<String> x$87 = c.copy$default$10();
                    String x$88 = c.copy$default$11();
                    return c.copy(x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$78, x$87, x$88);
                }).text("Save the document and figures into '<full-text-prefix><input_filename>.json");
                this.opt('m', "figure-prefix", Read$.MODULE$.stringRead()).action((Function2<String, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(f, c) -> {
                    Some<String> x$89 = new Some<String>((String)f);
                    Seq<File> x$90 = c.copy$default$1();
                    Option<String> x$91 = c.copy$default$2();
                    int x$92 = c.copy$default$3();
                    boolean x$93 = c.copy$default$4();
                    Option<String> x$94 = c.copy$default$5();
                    boolean x$95 = c.copy$default$6();
                    int x$96 = c.copy$default$7();
                    boolean x$97 = c.copy$default$8();
                    Option<String> x$98 = c.copy$default$9();
                    String x$99 = c.copy$default$11();
                    return c.copy(x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$89, x$99);
                }).text("Save figures as <figure-prefix><input_filename>-<Table|Figure><Name>-<id>.png. `id` will be 1 unless multiple figures are found with the same `Name` in `input_filename`");
                this.opt('f', "figure-format", Read$.MODULE$.stringRead()).action((Function2<String, FigureExtractorBatchCli.CliConfigBatch, FigureExtractorBatchCli.CliConfigBatch> & Serializable & scala.Serializable)(f, c) -> {
                    String x$100 = f;
                    Seq<File> x$101 = c.copy$default$1();
                    Option<String> x$102 = c.copy$default$2();
                    int x$103 = c.copy$default$3();
                    boolean x$104 = c.copy$default$4();
                    Option<String> x$105 = c.copy$default$5();
                    boolean x$106 = c.copy$default$6();
                    int x$107 = c.copy$default$7();
                    boolean x$108 = c.copy$default$8();
                    Option<String> x$109 = c.copy$default$9();
                    Option<String> x$110 = c.copy$default$10();
                    return c.copy(x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$100);
                }).text("Format to save figures (default png)").validate((Function1<String, Either<String, BoxedUnit>>)(Function1<String, Either> & Serializable & scala.Serializable)x -> {
                    if (FigureRenderer$.MODULE$.AllowedFormats().contains((String)x)) {
                        return this.success();
                    }
                    return this.failure(new StringBuilder(33).append((String)x).append(" not supported (allowed ").append("formats: ").append(FigureRenderer$.MODULE$.AllowedFormats().mkString(",")).toString());
                });
                this.checkConfig((Function1<FigureExtractorBatchCli.CliConfigBatch, Either> & Serializable & scala.Serializable)c -> {
                    Option<A> badFiles = c.inputFiles().find((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(anon.1.$anonfun$new$18(f)));
                    if (badFiles.isDefined()) {
                        return this.failure(new StringBuilder(29).append("Input file ").append(((File)badFiles.get()).getName()).append(" is not a PDF file").toString());
                    }
                    if (c.saveRegionlessCaptions() && c.fullTextPrefix().isDefined()) {
                        return this.failure("Can't set both save-regionless-captions and full-text");
                    }
                    if (c.fullTextPrefix().isDefined() && c.figureDataPrefix().isDefined()) {
                        return this.failure("Can't set both full-text and figure-data-prefix");
                    }
                    return this.success();
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$2(java.lang.String ), $anonfun$new$18$adapted(java.io.File ), $anonfun$new$1(scala.collection.Seq org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$3$adapted(java.lang.Object org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$4$adapted(org.allenai.pdffigures2.FigureExtractorBatchCli$$anon$1 java.lang.Object ), $anonfun$new$5(java.lang.String org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$6(org.allenai.pdffigures2.FigureExtractorBatchCli$$anon$1 java.lang.String ), $anonfun$new$7$adapted(java.lang.Object org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$8$adapted(org.allenai.pdffigures2.FigureExtractorBatchCli$$anon$1 java.lang.Object ), $anonfun$new$9(scala.runtime.BoxedUnit org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$10(scala.runtime.BoxedUnit org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$11(java.lang.String org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$12(scala.runtime.BoxedUnit org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$13(java.lang.String org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$14(java.lang.String org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$15(java.lang.String org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch ), $anonfun$new$16(org.allenai.pdffigures2.FigureExtractorBatchCli$$anon$1 java.lang.String ), $anonfun$new$17(org.allenai.pdffigures2.FigureExtractorBatchCli$$anon$1 org.allenai.pdffigures2.FigureExtractorBatchCli$CliConfigBatch )}, serializedLambda);
            }
        };
    }
}

