/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.Caption;
import org.allenai.pdffigures2.Figure;
import org.allenai.pdffigures2.InterruptiblePDFRenderer;
import org.allenai.pdffigures2.PageWithFigures;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.RasterizedFigure;
import org.allenai.pdffigures2.SavedFigure;
import org.allenai.pdffigures2.SavedFigure$;
import org.allenai.pdffigures2.VisualLogger;
import org.apache.pdfbox.pdmodel.PDDocument;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1$mcZI$sp;
import spray.json.JsonFormat;

public final class FigureRenderer$ {
    public static FigureRenderer$ MODULE$;
    private final Set<String> CairoFormat;
    private final Set<String> AllowedFormats;
    private final int MaxExpand;
    private final int PadNonFigureContent;
    private final int PadUnexpandedImage;

    static {
        new FigureRenderer$();
    }

    public Set<String> CairoFormat() {
        return this.CairoFormat;
    }

    public Set<String> AllowedFormats() {
        return this.AllowedFormats;
    }

    private int MaxExpand() {
        return this.MaxExpand;
    }

    private int PadNonFigureContent() {
        return this.PadNonFigureContent;
    }

    private int PadUnexpandedImage() {
        return this.PadUnexpandedImage;
    }

    public Tuple4<Object, Object, Object, Object> expandFigureBounds(int x1, int y1, int x2, int y2, Seq<Box> otherContentScaled, int contentPad, BufferedImage img) {
        int h = img.getHeight();
        int w = img.getWidth();
        IntRef newY1 = IntRef.create(y1);
        IntRef newX1 = IntRef.create(x1);
        IntRef newY2 = IntRef.create(y2);
        IntRef newX2 = IntRef.create(x2);
        while (newY1.elem > 0 && y1 - newY1.elem < this.MaxExpand() && !FigureRenderer$.intersectsAny$1(newX1.elem, newY1.elem - 1, newX2.elem, newY1.elem, otherContentScaled, contentPad) && package$.MODULE$.Range().apply(newX1.elem, newX2.elem + 1).exists((JFunction1$mcZI$sp & scala.Serializable)x -> FigureRenderer$.isColored$1(x, newY1$1.elem - 1, img) && FigureRenderer$.isColored$1(x, newY1$1.elem, img))) {
            --newY1.elem;
        }
        while (newY2.elem < h - 1 && newY2.elem - y2 < this.MaxExpand() && !FigureRenderer$.intersectsAny$1(newX1.elem, newY2.elem, newX2.elem, newY2.elem + 1, otherContentScaled, contentPad) && package$.MODULE$.Range().apply(newX1.elem, newX2.elem + 1).exists((JFunction1$mcZI$sp & scala.Serializable)x -> FigureRenderer$.isColored$1(x, newY2$1.elem + 1, img) && FigureRenderer$.isColored$1(x, newY2$1.elem, img))) {
            ++newY2.elem;
        }
        while (newX1.elem > 0 && x1 - newX1.elem < this.MaxExpand() && !FigureRenderer$.intersectsAny$1(newX1.elem - 1, newY1.elem, newX1.elem, newY2.elem, otherContentScaled, contentPad) && package$.MODULE$.Range().apply(newY1.elem, newY2.elem + 1).exists((JFunction1$mcZI$sp & scala.Serializable)y -> FigureRenderer$.isColored$1(newX1$1.elem, y, img) && FigureRenderer$.isColored$1(newX1$1.elem - 1, y, img))) {
            --newX1.elem;
        }
        while (newX2.elem < w - 1 && newX2.elem - x2 < this.MaxExpand() && !FigureRenderer$.intersectsAny$1(newX2.elem, newY1.elem, newX2.elem + 1, newY2.elem, otherContentScaled, contentPad) && package$.MODULE$.Range().apply(newY1.elem, newY2.elem + 1).exists((JFunction1$mcZI$sp & scala.Serializable)y -> FigureRenderer$.isColored$1(newX2$1.elem, y, img) && FigureRenderer$.isColored$1(newX2$1.elem + 1, y, img))) {
            ++newX2.elem;
        }
        return new Tuple4<Object, Object, Object, Object>(BoxesRunTime.boxToInteger(newX1.elem), BoxesRunTime.boxToInteger(newY1.elem), BoxesRunTime.boxToInteger(newX2.elem), BoxesRunTime.boxToInteger(newY2.elem));
    }

    public Seq<RasterizedFigure> rasterizeFigures(PDDocument doc, PageWithFigures page, int dpi, boolean clean, Option<VisualLogger> logger) {
        Seq<RasterizedFigure> rasterized;
        block0: {
            double scale = (double)dpi / 72.0;
            Seq nonFigureContent = ((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)page.classifiedText().allText().$plus$plus(page.paragraphs(), Seq$.MODULE$.canBuildFrom())).map((Function1<Paragraph, Box> & Serializable & scala.Serializable)x$1 -> x$1.boundary(), Seq$.MODULE$.canBuildFrom())).$plus$plus(page.failedCaptions().map((Function1<Caption, Box> & Serializable & scala.Serializable)x$2 -> x$2.boundary(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus(page.figures().map((Function1<Figure, Box> & Serializable & scala.Serializable)x$3 -> x$3.captionBoundary(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1<Box, Box> & Serializable & scala.Serializable)x$4 -> x$4.scale(scale), Seq$.MODULE$.canBuildFrom());
            ObjectRef figureRegions = ObjectRef.create(((TraversableLike)page.figures().map((Function1<Figure, Box> & Serializable & scala.Serializable)x$5 -> x$5.regionBoundary(), Seq$.MODULE$.canBuildFrom())).map((Function1<Box, Box> & Serializable & scala.Serializable)x$6 -> x$6.scale(scale), Seq$.MODULE$.canBuildFrom()));
            InterruptiblePDFRenderer renderer = new InterruptiblePDFRenderer(doc);
            BufferedImage pageImg = renderer.renderImageWithDPI(page.pageNumber(), dpi);
            rasterized = ((TraversableLike)page.figures().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, RasterizedFigure> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple4<Object, Object, Object, Object> tuple4;
                    Figure fig = (Figure)tuple2._1();
                    int figureNumber = tuple2._2$mcI$sp();
                    Seq otherFigureRegions = ((TraversableLike)((Seq)figureRegions$1.elem).take(figureNumber)).$plus$plus((GenTraversableOnce)((Seq)figureRegions$1.elem).drop(figureNumber + 1), Seq$.MODULE$.canBuildFrom());
                    Box r = fig.regionBoundary();
                    int x1 = Math.max((int)Math.floor(scale * r.x1()), 0);
                    int y1 = Math.max((int)Math.floor(scale * r.y1()), 0);
                    int x2 = Math.min((int)Math.ceil(scale * r.x2()), pageImg.getWidth() - 1);
                    int y2 = Math.min((int)Math.ceil(scale * r.y2()), pageImg.getHeight() - 1);
                    Tuple4<Object, Object, Object, Object> tuple42 = tuple4 = clean ? MODULE$.expandFigureBounds(x1, y1, x2, y2, nonFigureContent.$plus$plus(otherFigureRegions, Seq$.MODULE$.canBuildFrom()), MODULE$.PadNonFigureContent(), pageImg) : new Tuple4<Object, Object, Object, Object>(BoxesRunTime.boxToInteger(Math.max(x1 - MODULE$.PadUnexpandedImage(), 0)), BoxesRunTime.boxToInteger(Math.max(y1 - MODULE$.PadUnexpandedImage(), 0)), BoxesRunTime.boxToInteger(Math.min(x2 + MODULE$.PadUnexpandedImage() * 2, pageImg.getWidth() - 1)), BoxesRunTime.boxToInteger(Math.min(y2 + MODULE$.PadUnexpandedImage() * 2, pageImg.getHeight() - 1)));
                    if (tuple4 == null) {
                        throw new MatchError(tuple4);
                    }
                    int cx1 = BoxesRunTime.unboxToInt(tuple4._1());
                    int cy1 = BoxesRunTime.unboxToInt(tuple4._2());
                    int cx2 = BoxesRunTime.unboxToInt(tuple4._3());
                    int cy2 = BoxesRunTime.unboxToInt(tuple4._4());
                    Tuple4<Integer, Integer, Integer, Integer> tuple43 = new Tuple4<Integer, Integer, Integer, Integer>(BoxesRunTime.boxToInteger(cx1), BoxesRunTime.boxToInteger(cy1), BoxesRunTime.boxToInteger(cx2), BoxesRunTime.boxToInteger(cy2));
                    int cx12 = BoxesRunTime.unboxToInt(tuple43._1());
                    int cy12 = BoxesRunTime.unboxToInt(tuple43._2());
                    int cx22 = BoxesRunTime.unboxToInt(tuple43._3());
                    int cy22 = BoxesRunTime.unboxToInt(tuple43._4());
                    BufferedImage figureImage = pageImg.getSubimage(cx12, cy12, cx22 - cx12 + 1, cy22 - cy12 + 1);
                    RasterizedFigure rasterizedFigure = new RasterizedFigure(fig, new Box(cx12, cy12, cx22, cy22), figureImage, dpi);
                    figureRegions$1.elem = ((Seq)figureRegions$1.elem).updated(figureNumber, fig.regionBoundary(), Seq$.MODULE$.canBuildFrom());
                    return rasterizedFigure;
                }
                throw new MatchError(tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            if (!logger.isDefined()) break block0;
            logger.get().logRasterizedFigures(page.pageNumber(), rasterized);
        }
        return rasterized;
    }

    public Seq<SavedFigure> saveRasterizedFigures(Seq<Tuple2<String, RasterizedFigure>> figuresAndFilenames, String format, int dpi) {
        Predef$.MODULE$.require(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ImageIO.getWriterFormatNames())).contains(format), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Can't save to format ").append(format).toString());
        return figuresAndFilenames.map((Function1<Tuple2, SavedFigure> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String filename = (String)tuple2._1();
                RasterizedFigure rasterizedFigure = (RasterizedFigure)tuple2._2();
                ImageIO.write((RenderedImage)rasterizedFigure.bufferedImage(), format, new File(filename));
                return SavedFigure$.MODULE$.apply(rasterizedFigure, filename);
            }
            throw new MatchError(tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Iterable<SavedFigure> saveFiguresAsImagesCairo(PDDocument doc, Seq<Tuple2<String, Figure>> figuresAndFilenames, String format, int dpi) {
        Predef$.MODULE$.require(this.CairoFormat().contains(format), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cairo can't render to format ").append(format).toString());
        Map groupedByPage = figuresAndFilenames.groupBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger(FigureRenderer$.$anonfun$saveFiguresAsImagesCairo$2(x$8)));
        return groupedByPage.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int pageNum = tuple2._1$mcI$sp();
                Seq pageFigures = (Seq)tuple2._2();
                PDDocument pageDoc = new PDDocument();
                pageDoc.addPage(doc.getPage(pageNum));
                Seq savedFigures = pageFigures.map((Function1<Tuple2, SavedFigure> & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String filename = (String)tuple2._1();
                        Figure fig = (Figure)tuple2._2();
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        Box box = fig.regionBoundary();
                        long x = Math.round(box.x1()) - (long)MODULE$.PadUnexpandedImage();
                        long y = Math.round(box.y1()) - (long)MODULE$.PadUnexpandedImage();
                        long w = Math.round(box.width()) + (long)(MODULE$.PadUnexpandedImage() * 2);
                        long h = Math.round(box.height()) + (long)(MODULE$.PadUnexpandedImage() * 2);
                        String cmdStr = new StringBuilder(53).append("pdftocairo -").append(format).append(" -r ").append(dpi).append(" ").append("-x ").append(x).append(" -y ").append(y).append(" -H ").append(h).append(" -W ").append(w).append(" -paperw ").append(w).append(" -paperh ").append(h).append(" - ").append(filename).toString();
                        Process cmd = Runtime.getRuntime().exec(cmdStr);
                        OutputStream outStream = cmd.getOutputStream();
                        pageDoc.save(outStream);
                        if (cmd.waitFor() != 0) {
                            throw new IOException("Error using cairo to save a figure");
                        }
                        return SavedFigure$.MODULE$.apply(fig, filename, dpi);
                    }
                    throw new MatchError(tuple2);
                }, Seq$.MODULE$.canBuildFrom());
                pageDoc.close();
                return savedFigures;
            }
            throw new MatchError(tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public <T> void saveAsJSON(String outputFilename, T toSave, JsonFormat<T> evidence$1) {
        File file = new File(outputFilename);
        PrintWriter writer = new PrintWriter(file);
        writer.write(spray.json.package$.MODULE$.enrichAny(toSave).toJson(evidence$1).prettyPrint());
        writer.close();
    }

    private static final boolean isColored$1(int x, int y, BufferedImage img$1) {
        return img$1.getRGB(x, y) != -1;
    }

    private static final boolean intersectsAny$1(int x1, int y1, int x2, int y2, Seq otherContentScaled$1, int contentPad$1) {
        return new Box(x1, y1, x2, y2).intersectsAny(otherContentScaled$1, contentPad$1);
    }

    public static final /* synthetic */ int $anonfun$saveFiguresAsImagesCairo$2(Tuple2 x$8) {
        return ((Figure)x$8._2()).page();
    }

    private FigureRenderer$() {
        MODULE$ = this;
        this.CairoFormat = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ps", "eps", "pdf", "svg"}));
        this.AllowedFormats = (Set)this.CairoFormat().$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ImageIO.getWriterFormatNames())));
        this.MaxExpand = 20;
        this.PadNonFigureContent = 2;
        this.PadUnexpandedImage = 1;
    }
}

