/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.awt.image.BufferedImage;
import org.allenai.pdffigures2.Box;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class FindGraphicsRaster$ {
    public static FindGraphicsRaster$ MODULE$;
    private final int Threshold;
    private final int DPI;

    static {
        new FindGraphicsRaster$();
    }

    private int Threshold() {
        return this.Threshold;
    }

    private int DPI() {
        return this.DPI;
    }

    public List<Box> findCCBoundingBoxes(PDDocument doc, int page, Iterable<Box> remove) {
        PDFRenderer renderer = new PDFRenderer(doc);
        BufferedImage img = renderer.renderImageWithDPI(page, this.DPI(), ImageType.GRAY);
        return this.findCCBoundingBoxes(img, remove, this.Threshold(), this.DPI() / 72);
    }

    private List<Box> findCCBoundingBoxes(BufferedImage image, Iterable<Box> remove, int grayScaleTresh, int rescale) {
        int h = image.getHeight();
        int w = image.getWidth();
        int[] pixels = new int[w * h];
        image.getRaster().getPixels(0, 0, w, h, pixels);
        remove.foreach((Function1<Box, Object> & java.io.Serializable & Serializable)box -> {
            FindGraphicsRaster$.$anonfun$findCCBoundingBoxes$1(rescale, h, w, pixels, grayScaleTresh, box);
            return BoxedUnit.UNIT;
        });
        return this.findCCBoundingBoxes(pixels, w, h, grayScaleTresh, rescale);
    }

    private List<Box> findCCBoundingBoxes(int[] pixels, int w, int h, int pixThreshold, int rescale) {
        Set pixelsToExplore = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        ObjectRef<Nil$> boundingBoxes = ObjectRef.create(Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), h).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), w).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)x -> {
            int pixelIndex = x + y * w;
            if (pixels[pixelIndex] < pixThreshold) {
                int minX = x;
                int maxX = x;
                int minY = y;
                int maxY = y;
                pixelsToExplore.add(BoxesRunTime.boxToInteger(pixelIndex));
                while (pixelsToExplore.nonEmpty()) {
                    int rightPixel;
                    int leftPixel;
                    int upperPixel;
                    int lowerPixel;
                    int currentPixel = BoxesRunTime.unboxToInt(pixelsToExplore.head());
                    pixelsToExplore.remove(BoxesRunTime.boxToInteger(currentPixel));
                    if (currentPixel > w && pixels[lowerPixel = currentPixel - w] < pixThreshold) {
                        pixelsToExplore.add(BoxesRunTime.boxToInteger(currentPixel - w));
                        minY = Math.min(minY, lowerPixel / w);
                    }
                    if (currentPixel < pixels.length - w && pixels[upperPixel = currentPixel + w] < pixThreshold) {
                        pixelsToExplore.add(BoxesRunTime.boxToInteger(upperPixel));
                        maxY = Math.max(maxY, upperPixel / w);
                    }
                    if (currentPixel % w != 0 && pixels[leftPixel = currentPixel - 1] < pixThreshold) {
                        pixelsToExplore.add(BoxesRunTime.boxToInteger(leftPixel));
                        minX = Math.min(minX, leftPixel % w);
                    }
                    if ((currentPixel + 1) % w != 0 && pixels[rightPixel = currentPixel + 1] < pixThreshold) {
                        pixelsToExplore.add(BoxesRunTime.boxToInteger(rightPixel + 1));
                        maxX = Math.max(maxX, rightPixel % w);
                    }
                    pixels$2[currentPixel] = pixThreshold;
                }
                Box box = new Box(minX * rescale, minY * rescale, maxX * rescale, maxY * rescale);
                boundingBoxes$1.elem = ((List)boundingBoxes$1.elem).$colon$colon(box);
                return;
            }
        }));
        return (List)boundingBoxes.elem;
    }

    public static final /* synthetic */ void $anonfun$findCCBoundingBoxes$1(int rescale$1, int h$1, int w$1, int[] pixels$1, int grayScaleTresh$1, Box box) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)Math.floor(box.y1() / (double)rescale$1)), Math.min((int)Math.ceil(box.y2() / (double)rescale$1), h$1)).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)y -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)Math.floor(box.x1() / (double)rescale$1)), Math.min((int)Math.ceil(box.x2() / (double)rescale$1), w$1)).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)x -> {
            pixels$1[w$1 * y$1 + x] = grayScaleTresh$1;
        }));
    }

    private FindGraphicsRaster$() {
        MODULE$ = this;
        this.Threshold = 240;
        this.DPI = 72;
        Predef$.MODULE$.require(72 % this.DPI() == 0, (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "Currently need an integer scaling factor relative to 72 DPI");
    }
}

