/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.ClassifiedText;
import org.allenai.pdffigures2.ClassifiedText$;
import org.allenai.pdffigures2.FormattingTextExtractor;
import org.allenai.pdffigures2.FormattingTextExtractor$Interval$2$;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.Page;
import org.allenai.pdffigures2.PageWithClassifiedText;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.Paragraph$;
import org.allenai.pdffigures2.TextSpan;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.Tuple3Zipped$;
import scala.runtime.Tuple3Zipped$Ops$;
import scala.util.matching.Regex;

public final class FormattingTextExtractor$
implements Logging {
    public static FormattingTextExtractor$ MODULE$;
    private final Regex AbstractRegex;
    private final Regex PageNumberRegex;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new FormattingTextExtractor$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    private Regex AbstractRegex() {
        return this.AbstractRegex;
    }

    public Seq<Paragraph> selectAbstract(Page page) {
        Seq<Paragraph> paragraphs = page.paragraphs();
        Seq abstractStart = (Seq)paragraphs.filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$selectAbstract$1(p)));
        if (abstractStart.size() == 1) {
            boolean justTitle;
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Found abstract, marking as body text");
            Paragraph abstractParagraph = (Paragraph)abstractStart.head();
            boolean bl = justTitle = abstractParagraph.lines().size() == 1 && abstractParagraph.lines().head().words().size() == 1;
            if (justTitle) {
                double titleCenter = abstractParagraph.boundary().xCenter();
                Seq abstractBody = (Seq)page.paragraphs().filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$selectAbstract$3(abstractParagraph, titleCenter, p)));
                if (abstractBody.size() == 1) {
                    this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Found text body beneath the abstract, marking as body text");
                    return ((TraversableLike)new $colon$colon<Nothing$>((Nothing$)((Object)abstractParagraph), Nil$.MODULE$)).$plus$plus(abstractBody, Seq$.MODULE$.canBuildFrom());
                }
                return new $colon$colon<Nothing$>((Nothing$)((Object)abstractParagraph), Nil$.MODULE$);
            }
            return new $colon$colon<Nothing$>((Nothing$)((Object)abstractParagraph), Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    private Seq<Option<Paragraph>> selectHeaderCandidates(Seq<Page> textPages, Seq<Option<Paragraph>> candidates, int minConsistentHeaders) {
        Seq nonEmptyCandidates = (Seq)candidates.flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        if (nonEmptyCandidates.size() >= minConsistentHeaders) {
            public class Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1
            implements Product,
            scala.Serializable {
                private final double x1;
                private final double x2;

                public double x1() {
                    return this.x1;
                }

                public double x2() {
                    return this.x2;
                }

                public boolean intersects(Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1 other, double tol) {
                    return Math.abs(other.x1() - this.x1()) < tol && Math.abs(other.x2() - this.x2()) < tol;
                }

                public Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1 copy(double x1, double x2) {
                    return new Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1(x1, x2);
                }

                public double copy$default$1() {
                    return this.x1();
                }

                public double copy$default$2() {
                    return this.x2();
                }

                public String productPrefix() {
                    return "Interval";
                }

                public int productArity() {
                    return 2;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return BoxesRunTime.boxToDouble(this.x1());
                        }
                        case 1: {
                            return BoxesRunTime.boxToDouble(this.x2());
                        }
                    }
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator(this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1;
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix(n, Statics.doubleHash(this.x1()));
                    n = Statics.mix(n, Statics.doubleHash(this.x2()));
                    return Statics.finalizeHash(n, 2);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString(this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1 var4_3 = (Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1)x$1;
                    if (this.x1() != var4_3.x1()) return false;
                    if (this.x2() != var4_3.x2()) return false;
                    if (!var4_3.canEqual(this)) return false;
                    return true;
                }

                public Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1(double x1, double x2) {
                    this.x1 = x1;
                    this.x2 = x2;
                    Product.$init$(this);
                }
            }
            Map groupedByText = ((TraversableLike)nonEmptyCandidates.map((Function1<Paragraph, String> & Serializable & scala.Serializable)x -> x.text(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1<String, String> & Serializable & scala.Serializable)x -> x);
            Tuple2 tuple2 = (Tuple2)groupedByText.mapValues((Function1<Seq, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.size())).maxBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2._2$mcI$sp()), Ordering$Int$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String mostCommonText = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2<String, Integer> tuple22 = new Tuple2<String, Integer>(mostCommonText, BoxesRunTime.boxToInteger(count));
            String mostCommonText2 = tuple22._1();
            int count2 = tuple22._2$mcI$sp();
            if (count2 >= minConsistentHeaders) {
                return candidates.map((Function1<Option, Option> & Serializable & scala.Serializable)x0$1 -> {
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String string = ((Paragraph)some.get()).text();
                        String string2 = mostCommonText2;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return some;
                        }
                    }
                    return None$.MODULE$;
                }, Seq$.MODULE$.canBuildFrom());
            }
            LazyRef Interval$module = new LazyRef();
            Seq heights = nonEmptyCandidates.map((Function1<Paragraph, Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1> & Serializable & scala.Serializable)p -> this.Interval$3(Interval$module).apply(p.boundary().y1(), p.boundary().y2()), Seq$.MODULE$.canBuildFrom());
            Option commonHeight = heights.find((Function1<Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1, Object> & Serializable & scala.Serializable)interval -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$selectHeaderCandidates$8(heights, minConsistentHeaders, interval)));
            if (commonHeight.isDefined()) {
                return candidates.map((Function1<Option, Option> & Serializable & scala.Serializable)x0$2 -> {
                    Option option = x0$2;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Box boundary = ((Paragraph)some.get()).boundary();
                        Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1 interval = this.Interval$3(Interval$module).apply(boundary.y1(), boundary.y2());
                        if (interval.intersects((Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1)commonHeight.get(), 1.0)) {
                            return some;
                        }
                        return None$.MODULE$;
                    }
                    return None$.MODULE$;
                }, Seq$.MODULE$.canBuildFrom());
            }
            return (Seq)Seq$.MODULE$.fill(textPages.size(), (Function0<None$> & Serializable & scala.Serializable)() -> None$.MODULE$);
        }
        return (Seq)Seq$.MODULE$.fill(textPages.size(), (Function0<None$> & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    public Seq<Seq<Paragraph>> findHeaders(Seq<Page> textPages, int minConsistentHeaders) {
        Tuple2 tuple2 = ((GenericTraversableTemplate)textPages.map((Function1<Page, Tuple2> & Serializable & scala.Serializable)textPage -> {
            Seq topParagraphs = (Seq)textPage.paragraphs().filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$findHeaders$2(paragraph)));
            Seq top2Paragraphs = (Seq)((IterableLike)topParagraphs.sortBy((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble(FormattingTextExtractor$.$anonfun$findHeaders$3(x$4)), Ordering$Double$.MODULE$)).take(2);
            if (top2Paragraphs.nonEmpty()) {
                Option option;
                Option firstCandidate;
                Paragraph candidate = (Paragraph)top2Paragraphs.head();
                boolean aboveOtherText = topParagraphs.forall((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$findHeaders$4(candidate, paragraph)));
                boolean validCandidate = candidate.lines().size() <= 3 && aboveOtherText;
                Option option2 = firstCandidate = validCandidate ? new Some<Paragraph>(candidate) : None$.MODULE$;
                if (top2Paragraphs.size() > 1 && firstCandidate.isDefined()) {
                    boolean validCandidate2;
                    Paragraph candidate2 = (Paragraph)top2Paragraphs.apply(true);
                    boolean aboveOtherText2 = topParagraphs.forall((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$findHeaders$5(candidate2, firstCandidate, paragraph)));
                    boolean bl = validCandidate2 = candidate2.lines().size() <= 3 && aboveOtherText2;
                    option = validCandidate2 ? new Some<Paragraph>(candidate2) : None$.MODULE$;
                } else {
                    option = None$.MODULE$;
                }
                None$ secondCandidate = option;
                return new Tuple2<Option, None$>(firstCandidate, secondCandidate);
            }
            return new Tuple2<None$, None$>(None$.MODULE$, None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom())).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq firstCandidates = (Seq)tuple2._1();
        Seq secondCandidates = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(firstCandidates, secondCandidates);
        Seq firstCandidates2 = tuple22._1();
        Seq secondCandidates2 = tuple22._2();
        Seq<Option<Paragraph>> firstHeaders = this.selectHeaderCandidates(textPages, firstCandidates2, minConsistentHeaders);
        Seq<Option<Paragraph>> prunedSecondCandidates = ((TraversableLike)secondCandidates2.zip(firstHeaders, Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option sc = (Option)tuple2._1();
                Option option = (Option)tuple2._2();
                if (sc instanceof Some) {
                    Some some = (Some)sc;
                    if (option instanceof Some) {
                        return some;
                    }
                }
            }
            return None$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Option<Paragraph>> secondHeaders = this.selectHeaderCandidates(textPages, prunedSecondCandidates, minConsistentHeaders);
        return ((TraversableLike)firstHeaders.zip(secondHeaders, Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Seq> & Serializable & scala.Serializable)x -> ((TraversableOnce)Option$.MODULE$.option2Iterable((Option)x._1()).$plus$plus(Option$.MODULE$.option2Iterable((Option)x._2()), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    private Regex PageNumberRegex() {
        return this.PageNumberRegex;
    }

    public Seq<Option<Line>> findPageNumber(Seq<Page> textPages, int minConsistentPageNumbers) {
        boolean hasPageNumbers;
        Seq<Option<Line>> pageNumberCandidates = textPages.map((Function1<Page, Option> & Serializable & scala.Serializable)textPage -> {
            if (textPage.paragraphs().nonEmpty()) {
                Paragraph lastParagraph = (Paragraph)textPage.paragraphs().maxBy((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble(FormattingTextExtractor$.$anonfun$findPageNumber$2(x$6)), Ordering$Double$.MODULE$);
                Line lastLine = lastParagraph.lines().last();
                if (MODULE$.PageNumberRegex().pattern().matcher(lastLine.text()).matches()) {
                    return new Some<Line>(lastLine);
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
        boolean bl = hasPageNumbers = minConsistentPageNumbers <= pageNumberCandidates.count((Function1<Option, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.isDefined()));
        if (hasPageNumbers) {
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Page numbers detected");
            return pageNumberCandidates;
        }
        return (Seq)Seq$.MODULE$.fill(textPages.size(), (Function0<None$> & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    public List<PageWithClassifiedText> extractFormattingText(List<Page> textPages) {
        int minConsistentPages = textPages.size() - (textPages.size() < 3 ? 0 : (textPages.size() < 5 ? 1 : 2));
        Seq<Seq<Paragraph>> headers = this.findHeaders(textPages, minConsistentPages);
        Seq<Option<Line>> pageNumbers = this.findPageNumber(textPages, minConsistentPages);
        Option documentAbstract = ((IterableLike)((List)textPages.take(2)).view().map((Function1<Page, Tuple2> & Serializable & scala.Serializable)page -> new Tuple2<Integer, Seq<Paragraph>>(BoxesRunTime.boxToInteger(page.pageNumber()), MODULE$.selectAbstract((Page)page)), SeqView$.MODULE$.canBuildFrom())).find((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$extractFormattingText$2(x$8)));
        Option abstractPageNum = documentAbstract.isDefined() ? new Some<Integer>(BoxesRunTime.boxToInteger(((Tuple2)documentAbstract.get())._1$mcI$sp())) : None$.MODULE$;
        List<PageWithClassifiedText> textWithoutHeaders = Tuple3Zipped$.MODULE$.map$extension(Tuple3Zipped$Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3<List<Page>, Seq<Seq<Paragraph>>, Seq<Option<Line>>>(textPages, headers, pageNumbers)), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms()), (Function3<Page, Seq, Option, PageWithClassifiedText> & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3<Page, Seq, Option> tuple3 = new Tuple3<Page, Seq, Option>((Page)x0$1, (Seq)x1$1, (Option)x2$1);
            if (tuple3 != null) {
                Seq seq;
                Seq abstractText;
                Page textPage = tuple3._1();
                Seq header = tuple3._2();
                Option pageNumber = tuple3._3();
                if (abstractPageNum.isDefined() && BoxesRunTime.unboxToInt(abstractPageNum.get()) > textPage.pageNumber()) {
                    MODULE$.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Marking page ").append(textPage.pageNumber()).append(" as a cover page").toString());
                    Seq<Paragraph> x$1 = textPage.paragraphs();
                    Seq<Paragraph> x$2 = ClassifiedText$.MODULE$.apply$default$1();
                    Seq<Paragraph> x$3 = ClassifiedText$.MODULE$.apply$default$3();
                    Seq<Paragraph> x$4 = ClassifiedText$.MODULE$.apply$default$4();
                    return new PageWithClassifiedText(textPage.pageNumber(), Nil$.MODULE$, new ClassifiedText(x$2, x$1, x$3, x$4));
                }
                Option pageNumberParagraph = pageNumber.isDefined() ? new Some<Paragraph>(Paragraph$.MODULE$.apply(new $colon$colon<Nothing$>((Nothing$)((Object)((Line)pageNumber.get())), Nil$.MODULE$))) : None$.MODULE$;
                Option pageNumberLocations = pageNumber.map((Function1<Line, TextSpan> & Serializable & scala.Serializable)l -> new TextSpan(l.lineNumber(), l.lineNumber()));
                Seq headerLocations = header.map((Function1<Paragraph, TextSpan> & Serializable & scala.Serializable)x$9 -> x$9.span(), Seq$.MODULE$.canBuildFrom());
                Seq seq2 = abstractText = abstractPageNum.nonEmpty() && BoxesRunTime.unboxToInt(abstractPageNum.get()) == textPage.pageNumber() ? (Seq)((Tuple2)documentAbstract.get())._2() : (Seq)Nil$.MODULE$;
                if (abstractText.nonEmpty()) {
                    double abstractY1 = BoxesRunTime.unboxToDouble(((TraversableOnce)abstractText.map((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble(FormattingTextExtractor$.$anonfun$extractFormattingText$7(x$10)), Seq$.MODULE$.canBuildFrom())).min(Ordering$Double$.MODULE$));
                    Seq alreadyRemoved = ((TraversableLike)header.map((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger(x$11.startLineNumber()), Seq$.MODULE$.canBuildFrom())).$plus$plus(abstractText.map((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger(x$12.startLineNumber()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    seq = (Seq)textPage.paragraphs().filter((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$extractFormattingText$10(abstractY1, alreadyRemoved, paragraph)));
                } else {
                    seq = Nil$.MODULE$;
                }
                Seq aboveAbstractParagraph = seq;
                Seq aboveAbstractLocations = aboveAbstractParagraph.map((Function1<Paragraph, TextSpan> & Serializable & scala.Serializable)x$13 -> x$13.span(), Seq$.MODULE$.canBuildFrom());
                Seq abstractLocations = abstractText.map((Function1<Paragraph, TextSpan> & Serializable & scala.Serializable)x$14 -> x$14.span(), Seq$.MODULE$.canBuildFrom());
                Seq<TextSpan> toRemove = ((TraversableLike)((TraversableLike)headerLocations.$plus$plus(Option$.MODULE$.option2Iterable(pageNumberLocations), Seq$.MODULE$.canBuildFrom())).$plus$plus(abstractLocations, Seq$.MODULE$.canBuildFrom())).$plus$plus(aboveAbstractLocations, Seq$.MODULE$.canBuildFrom());
                Seq<Paragraph> strippedText = Paragraph$.MODULE$.removeSpans(toRemove, textPage.paragraphs());
                return new PageWithClassifiedText(textPage.pageNumber(), strippedText, new ClassifiedText(header, Option$.MODULE$.option2Iterable(pageNumberParagraph).toSeq().$plus$plus(aboveAbstractParagraph, Seq$.MODULE$.canBuildFrom()), abstractText, ClassifiedText$.MODULE$.apply$default$4()));
            }
            throw new MatchError(tuple3);
        }, List$.MODULE$.canBuildFrom());
        return textWithoutHeaders;
    }

    private final void logger$lzycompute$1() {
        FormattingTextExtractor$ formattingTextExtractor$ = this;
        synchronized (formattingTextExtractor$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        FormattingTextExtractor$ formattingTextExtractor$ = this;
        synchronized (formattingTextExtractor$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$selectAbstract$1(Paragraph p) {
        return MODULE$.AbstractRegex().pattern().matcher(p.lines().head().words().head().text()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$selectAbstract$3(Paragraph abstractParagraph$1, double titleCenter$1, Paragraph p) {
        double yDistFromAbstract = p.boundary().y1() - abstractParagraph$1.boundary().y2();
        boolean centered = Math.abs(p.boundary().xCenter() - titleCenter$1) < 1.0;
        boolean below = yDistFromAbstract < (double)20 && yDistFromAbstract > (double)3;
        return p.startLineNumber() != abstractParagraph$1.startLineNumber() && centered && below;
    }

    private static final /* synthetic */ FormattingTextExtractor$Interval$2$ Interval$lzycompute$1(LazyRef Interval$module$1) {
        FormattingTextExtractor$Interval$2$ formattingTextExtractor$Interval$2$;
        LazyRef lazyRef = Interval$module$1;
        synchronized (lazyRef) {
            formattingTextExtractor$Interval$2$ = Interval$module$1.initialized() ? (FormattingTextExtractor$Interval$2$)Interval$module$1.value() : Interval$module$1.initialize(new FormattingTextExtractor$Interval$2$());
        }
        return formattingTextExtractor$Interval$2$;
    }

    private final FormattingTextExtractor$Interval$2$ Interval$3(LazyRef Interval$module$1) {
        if (Interval$module$1.initialized()) {
            return (FormattingTextExtractor$Interval$2$)Interval$module$1.value();
        }
        return FormattingTextExtractor$.Interval$lzycompute$1(Interval$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$selectHeaderCandidates$9(FormattingTextExtractor.Interval.1 interval$1, FormattingTextExtractor.Interval.1 h) {
        return h.intersects(interval$1, 1.0);
    }

    public static final /* synthetic */ boolean $anonfun$selectHeaderCandidates$8(Seq heights$1, int minConsistentHeaders$1, FormattingTextExtractor.Interval.1 interval) {
        return heights$1.count((Function1<Org_allenai_pdffigures2_FormattingTextExtractor$Interval$1, Object> & Serializable & scala.Serializable)h -> {
            return BoxesRunTime.boxToBoolean(FormattingTextExtractor$.$anonfun$selectHeaderCandidates$9(interval, h));
        }) >= minConsistentHeaders$1;
    }

    public static final /* synthetic */ boolean $anonfun$findHeaders$2(Paragraph paragraph) {
        return paragraph.boundary().y1() < (double)216;
    }

    public static final /* synthetic */ double $anonfun$findHeaders$3(Paragraph x$4) {
        return x$4.boundary().y1();
    }

    public static final /* synthetic */ boolean $anonfun$findHeaders$4(Paragraph candidate$1, Paragraph paragraph) {
        return paragraph.startLineNumber() == candidate$1.startLineNumber() || Math.abs(candidate$1.boundary().y2() - paragraph.boundary().y2()) > (double)3;
    }

    public static final /* synthetic */ boolean $anonfun$findHeaders$5(Paragraph candidate$2, Option firstCandidate$1, Paragraph paragraph) {
        return paragraph.startLineNumber() == candidate$2.startLineNumber() || paragraph.startLineNumber() == ((Paragraph)firstCandidate$1.get()).startLineNumber() || Math.abs(candidate$2.boundary().y2() - paragraph.boundary().y2()) > (double)3;
    }

    public static final /* synthetic */ double $anonfun$findPageNumber$2(Paragraph x$6) {
        return x$6.boundary().y2();
    }

    public static final /* synthetic */ boolean $anonfun$extractFormattingText$2(Tuple2 x$8) {
        return ((TraversableOnce)x$8._2()).nonEmpty();
    }

    public static final /* synthetic */ double $anonfun$extractFormattingText$7(Paragraph x$10) {
        return x$10.boundary().y1();
    }

    public static final /* synthetic */ boolean $anonfun$extractFormattingText$10(double abstractY1$1, Seq alreadyRemoved$1, Paragraph paragraph) {
        return paragraph.boundary().y2() < abstractY1$1 && !alreadyRemoved$1.contains(BoxesRunTime.boxToInteger(paragraph.startLineNumber()));
    }

    private FormattingTextExtractor$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.AbstractRegex = new StringOps(Predef$.MODULE$.augmentString("^(Abstract|ABSTRACT)(((\u2014|-)[a-zA-Z]*)|.)?$")).r();
        this.PageNumberRegex = new StringOps(Predef$.MODULE$.augmentString("[1-9][0-9]*")).r();
    }
}

