/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.Box$;
import org.allenai.pdffigures2.FigureExtractor;
import org.allenai.pdffigures2.FigureExtractor$OcredPdfException$;
import org.allenai.pdffigures2.FindGraphicsRaster$;
import org.allenai.pdffigures2.GraphicBBDetector$;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.PageWithClassifiedText;
import org.allenai.pdffigures2.PageWithGraphics;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.VisualLogger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.Ordering$Double$;
import scala.runtime.BoxesRunTime;

public final class GraphicsExtractor$
implements Logging {
    public static GraphicsExtractor$ MODULE$;
    private final int GraphicClusteringTolerance;
    private final int OcrGraphicMinSize;
    private final int OcrPageBoundsTolerance;
    private final double HeaderLineMinWidthPercent;
    private final int HeaderLineMinHeight;
    private final int HeaderLineMinY1;
    private final int HeaderLineMinDistToHeader;
    private final int SecondHeaderMinDistToFirst;
    private final double SecondHeaderMaxWidthDifference;
    private final int MixedInGraphicMaxSize;
    private final int MixedInGraphicContainsTolerance;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new GraphicsExtractor$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    private int GraphicClusteringTolerance() {
        return this.GraphicClusteringTolerance;
    }

    private int OcrGraphicMinSize() {
        return this.OcrGraphicMinSize;
    }

    private int OcrPageBoundsTolerance() {
        return this.OcrPageBoundsTolerance;
    }

    private double HeaderLineMinWidthPercent() {
        return this.HeaderLineMinWidthPercent;
    }

    private int HeaderLineMinHeight() {
        return this.HeaderLineMinHeight;
    }

    private int HeaderLineMinY1() {
        return this.HeaderLineMinY1;
    }

    private int HeaderLineMinDistToHeader() {
        return this.HeaderLineMinDistToHeader;
    }

    private int SecondHeaderMinDistToFirst() {
        return this.SecondHeaderMinDistToFirst;
    }

    private double SecondHeaderMaxWidthDifference() {
        return this.SecondHeaderMaxWidthDifference;
    }

    private int MixedInGraphicMaxSize() {
        return this.MixedInGraphicMaxSize;
    }

    private int MixedInGraphicContainsTolerance() {
        return this.MixedInGraphicContainsTolerance;
    }

    public PageWithGraphics extractGraphics(PDDocument doc, PageWithClassifiedText page, boolean allowOcr, boolean ignoreWhiteGraphics, Option<VisualLogger> vLogger) {
        Box pageBounds;
        List<Box> rawGraphics = this.extractRawGraphics(doc, page, allowOcr, ignoreWhiteGraphics);
        Tuple2<Seq<Box>, Seq<Box>> tuple2 = this.preprocessGraphics(rawGraphics, page, pageBounds = Box$.MODULE$.fromPDRect(doc.getPage(page.pageNumber()).getCropBox()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<Box> graphics = tuple2._1();
        Seq<Box> nonFigureGraphics = tuple2._2();
        Tuple2<Seq<Box>, Seq<Box>> tuple22 = new Tuple2<Seq<Box>, Seq<Box>>(graphics, nonFigureGraphics);
        Seq<Box> graphics2 = tuple22._1();
        Seq<Box> nonFigureGraphics2 = tuple22._2();
        this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Found ").append(graphics2.size()).append(" graphic areas, ").append(graphics2.size()).append(" after cleaning").toString());
        if (vLogger.isDefined()) {
            vLogger.get().logGraphicCluster(page.pageNumber(), rawGraphics, graphics2);
        }
        return new PageWithGraphics(page.pageNumber(), page.paragraphs(), graphics2, nonFigureGraphics2, page.classifiedText());
    }

    private List<Box> extractRawGraphics(PDDocument doc, PageWithClassifiedText textPage, boolean allowOcr, boolean ignoreWhiteGraphics) {
        int page = textPage.pageNumber();
        Box bounds = Box$.MODULE$.fromPDRect(doc.getPage(page).getCropBox());
        List<Box> graphics = GraphicBBDetector$.MODULE$.findGraphicBB(doc.getPage(page), ignoreWhiteGraphics);
        if (graphics.exists((Function1<Box, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.contains(bounds, 1.0))) || graphics.size() == 1 && graphics.head().contains(bounds, this.OcrPageBoundsTolerance())) {
            if (allowOcr) {
                this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Page ").append(page).append(" is an image, falling back to CC graphic detection").toString());
                List<Box> rasterCCs = FindGraphicsRaster$.MODULE$.findCCBoundingBoxes(doc, page, ((TraversableLike)textPage.classifiedText().allText().$plus$plus(textPage.paragraphs(), Seq$.MODULE$.canBuildFrom())).map((Function1<Paragraph, Box> & Serializable & scala.Serializable)x$3 -> x$3.boundary(), Seq$.MODULE$.canBuildFrom()));
                return (List)rasterCCs.filter((Function1<Box, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(GraphicsExtractor$.$anonfun$extractRawGraphics$4(x$4)));
            }
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Page ").append(page).append(" is an image and allow OCR is false, giving up").toString());
            throw new FigureExtractor.OcredPdfException(new StringBuilder(45).append("Page ").append(page).append(" is an image and allow OCR is turned off").toString(), FigureExtractor$OcredPdfException$.MODULE$.$lessinit$greater$default$2());
        }
        return graphics;
    }

    private Tuple2<Seq<Box>, Seq<Box>> preprocessGraphics(List<Box> graphics, PageWithClassifiedText text, Box bounds) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        boolean headerLine;
        boolean bl;
        Seq<Paragraph> pageHeader = text.classifiedText().pageHeaders();
        Tuple2<Traversable<Box>, Traversable<Box>> tuple23 = graphics.partition((Function1<Box, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(GraphicsExtractor$.$anonfun$preprocessGraphics$1(bounds, g)));
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        List wideLines = (List)tuple23._1();
        List nonLines = (List)tuple23._2();
        Tuple2<List, List> tuple24 = new Tuple2<List, List>(wideLines, nonLines);
        List wideLines2 = tuple24._1();
        List nonLines2 = tuple24._2();
        List sortedWideLines = (List)wideLines2.sortBy((Function1<Box, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble(x$6.y1()), (Ordering)Ordering$Double$.MODULE$);
        if (sortedWideLines.isEmpty()) {
            bl = false;
        } else if (pageHeader.nonEmpty()) {
            double headerEnd = ((Paragraph)pageHeader.minBy((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble(GraphicsExtractor$.$anonfun$preprocessGraphics$3(x$7)), Ordering$Double$.MODULE$)).boundary().yCenter();
            bl = Math.abs(((Box)sortedWideLines.head()).y2() - headerEnd) < (double)this.HeaderLineMinDistToHeader();
        } else {
            double minTextElement = BoxesRunTime.unboxToDouble(((TraversableOnce)text.paragraphs().map((Function1<Paragraph, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble(GraphicsExtractor$.$anonfun$preprocessGraphics$4(x$8)), Seq$.MODULE$.canBuildFrom())).min(Ordering$Double$.MODULE$));
            bl = headerLine = sortedWideLines.size() == 1 && ((Box)sortedWideLines.head()).y1() < minTextElement;
        }
        if (headerLine) {
            boolean secondHeaderLine;
            Box secondLine;
            boolean bl2 = sortedWideLines.size() > 1 ? (secondLine = (Box)sortedWideLines.apply(1)).y1() - ((Box)sortedWideLines.head()).y1() < (double)this.SecondHeaderMinDistToFirst() && Math.abs(((Box)sortedWideLines.head()).x1() - secondLine.x1()) < this.SecondHeaderMaxWidthDifference() && Math.abs(((Box)sortedWideLines.head()).x2() - secondLine.x2()) < this.SecondHeaderMaxWidthDifference() : (secondHeaderLine = false);
            if (secondHeaderLine) {
                this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Two header lines detected");
            } else {
                this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Header line detected");
            }
            int numLines = secondHeaderLine ? 2 : 1;
            tuple22 = new Tuple2(sortedWideLines.take(numLines), ((List)sortedWideLines.drop(numLines)).$plus$plus(nonLines2, List$.MODULE$.canBuildFrom()));
        } else {
            tuple22 = tuple2 = new Tuple2(Nil$.MODULE$, graphics);
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq headerLines = tuple2._1();
        List<Box> nonHeaderGraphic = tuple2._2();
        Tuple2<Seq, List<Box>> tuple25 = new Tuple2<Seq, List<Box>>(headerLines, nonHeaderGraphic);
        Seq headerLines2 = tuple25._1();
        List<Box> nonHeaderGraphic2 = tuple25._2();
        Tuple2<Traversable<Box>, Traversable<Box>> tuple26 = nonHeaderGraphic2.partition((Function1<Box, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(GraphicsExtractor$.$anonfun$preprocessGraphics$7(bounds, b)));
        if (tuple26 == null) {
            throw new MatchError(tuple26);
        }
        List sidePanel = (List)tuple26._1();
        List graphicsToMerge = (List)tuple26._2();
        Tuple2<List, List> tuple27 = new Tuple2<List, List>(sidePanel, graphicsToMerge);
        List sidePanel2 = tuple27._1();
        List graphicsToMerge2 = tuple27._2();
        List<Box> merged = Box$.MODULE$.mergeBoxes(graphicsToMerge2, this.GraphicClusteringTolerance());
        List processedGraphics = (List)merged.filterNot((Function1<Box, Object> & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean(GraphicsExtractor$.$anonfun$preprocessGraphics$8(text, box)));
        return new Tuple2<Seq<Box>, Seq<Box>>(processedGraphics, headerLines2.$plus$plus(sidePanel2, Seq$.MODULE$.canBuildFrom()));
    }

    private final void logger$lzycompute$1() {
        GraphicsExtractor$ graphicsExtractor$ = this;
        synchronized (graphicsExtractor$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        GraphicsExtractor$ graphicsExtractor$ = this;
        synchronized (graphicsExtractor$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$extractRawGraphics$4(Box x$4) {
        return x$4.area() > (double)MODULE$.OcrGraphicMinSize();
    }

    public static final /* synthetic */ boolean $anonfun$preprocessGraphics$1(Box bounds$2, Box g) {
        return g.height() < (double)MODULE$.HeaderLineMinHeight() && g.y1() < (double)MODULE$.HeaderLineMinY1() && g.width() / bounds$2.width() > MODULE$.HeaderLineMinWidthPercent();
    }

    public static final /* synthetic */ double $anonfun$preprocessGraphics$3(Paragraph x$7) {
        return x$7.boundary().y1();
    }

    public static final /* synthetic */ double $anonfun$preprocessGraphics$4(Paragraph x$8) {
        return x$8.boundary().y1();
    }

    public static final /* synthetic */ boolean $anonfun$preprocessGraphics$7(Box bounds$2, Box b) {
        return Math.abs(b.height() - bounds$2.height()) < 1.0 && (b.x1() < 1.0 || Math.abs(b.x2() - bounds$2.x2()) < 1.0);
    }

    public static final /* synthetic */ boolean $anonfun$preprocessGraphics$9(Box box$1, Paragraph paragraph) {
        return paragraph.boundary().contains(box$1, MODULE$.MixedInGraphicContainsTolerance());
    }

    public static final /* synthetic */ boolean $anonfun$preprocessGraphics$8(PageWithClassifiedText text$1, Box box) {
        return box.area() < (double)MODULE$.MixedInGraphicMaxSize() && text$1.paragraphs().exists((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> BoxesRunTime.boxToBoolean(GraphicsExtractor$.$anonfun$preprocessGraphics$9(box, paragraph)));
    }

    private GraphicsExtractor$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.GraphicClusteringTolerance = 2;
        this.OcrGraphicMinSize = 2;
        this.OcrPageBoundsTolerance = 70;
        this.HeaderLineMinWidthPercent = 0.7;
        this.HeaderLineMinHeight = 5;
        this.HeaderLineMinY1 = 72;
        this.HeaderLineMinDistToHeader = 18;
        this.SecondHeaderMinDistToFirst = 36;
        this.SecondHeaderMaxWidthDifference = 0.1;
        this.MixedInGraphicMaxSize = 70;
        this.MixedInGraphicContainsTolerance = 2;
    }
}

