/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import java.text.Normalizer;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.Box$;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.TextSpan;
import org.allenai.pdffigures2.Word;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Paragraph$
implements scala.Serializable {
    public static Paragraph$ MODULE$;
    private final Regex unprintableRegex;

    static {
        new Paragraph$();
    }

    public Regex unprintableRegex() {
        return this.unprintableRegex;
    }

    public Paragraph apply(List<Line> lines) {
        return new Paragraph(lines, Box$.MODULE$.container(lines.map((Function1<Line, Box> & Serializable & scala.Serializable)x$1 -> x$1.boundary(), List$.MODULE$.canBuildFrom())));
    }

    public String normalizeWord(String word) {
        scala.collection.mutable.StringBuilder builder = null;
        int p = 0;
        int q = 0;
        int strLength = word.length();
        while (q < strLength) {
            char c = word.charAt(q);
            if ('\ufb00' <= c && c <= '\ufdff' || '\ufe70' <= c && c <= '\ufeff') {
                if (builder == null) {
                    builder = new scala.collection.mutable.StringBuilder(strLength * 2);
                }
                builder.append(word.substring(p, q));
                scala.collection.mutable.StringBuilder stringBuilder = c == '\ufdf2' && q > 0 && (word.charAt(q - 1) == '\u0627' || word.charAt(q - 1) == '\ufe8d') ? builder.append("\u0644\u0644\u0647") : builder.append(Normalizer.normalize(word.substring(q, q + 1), Normalizer.Form.NFKC).trim());
                p = q + 1;
            }
            int cfr_ignored_0 = ++q - 1;
        }
        if (builder == null) {
            return this.unprintableRegex().replaceAllIn((CharSequence)word, "");
        }
        builder.append(word.substring(p, q));
        return builder.toString();
    }

    public String convertToNormalizedString(Paragraph paragraph) {
        List normalizedLines = paragraph.lines().map((Function1<Line, List> & Serializable & scala.Serializable)x$2 -> x$2.words().map((Function1<Word, String> & Serializable & scala.Serializable)w -> MODULE$.normalizeWord(w.text()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        List linesWithoutHyphens = ((List)normalizedLines.dropRight(1)).map((Function1<List, String> & Serializable & scala.Serializable)line -> {
            String lastWord = (String)line.last();
            if (new StringOps(Predef$.MODULE$.augmentString(lastWord)).nonEmpty() && BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(lastWord)).last()) == '-' && lastWord.length() > 1 && new StringOps(Predef$.MODULE$.augmentString(lastWord)).exists((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(Paragraph$.$anonfun$convertToNormalizedString$4(BoxesRunTime.unboxToChar(x$1))))) {
                return (String)new StringOps(Predef$.MODULE$.augmentString(line.mkString(" "))).dropRight(1);
            }
            return new StringBuilder(1).append(line.mkString(" ")).append(" ").toString();
        }, List$.MODULE$.canBuildFrom());
        return new StringBuilder(0).append(linesWithoutHyphens.mkString("")).append(((TraversableOnce)normalizedLines.last()).mkString(" ")).toString();
    }

    public String convertToFlatNormalizedString(Iterable<Paragraph> paragraphs) {
        if (paragraphs.nonEmpty()) {
            return this.convertToNormalizedString(this.apply(((TraversableOnce)paragraphs.flatMap((Function1<Paragraph, List> & Serializable & scala.Serializable)x$3 -> x$3.lines(), Iterable$.MODULE$.canBuildFrom())).toList()));
        }
        return "";
    }

    public Seq<Paragraph> removeSpans(Seq<TextSpan> segments, Seq<Paragraph> paragraphs) {
        Iterator paragraphIterator;
        ObjectRef<Nil$> strippedParagraphs;
        block3: {
            if (segments.isEmpty()) {
                return paragraphs;
            }
            strippedParagraphs = ObjectRef.create(Nil$.MODULE$);
            paragraphIterator = paragraphs.iterator();
            ObjectRef<Paragraph> curParagraph = ObjectRef.create((Paragraph)paragraphIterator.next());
            ObjectRef<List<Line>> curLines = ObjectRef.create(((Paragraph)curParagraph.elem).lines());
            ((IterableLike)segments.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).foreach((Function1<TextSpan, Object> & Serializable & scala.Serializable)x0$1 -> {
                Paragraph$.$anonfun$removeSpans$1(curLines, curParagraph, strippedParagraphs, paragraphIterator, x0$1);
                return BoxedUnit.UNIT;
            });
            if (!((List)curLines.elem).nonEmpty()) break block3;
            if (((Line)((List)curLines.elem).head()).lineNumber() == ((Paragraph)curParagraph.elem).startLineNumber()) {
                Paragraph paragraph = (Paragraph)curParagraph.elem;
                strippedParagraphs.elem = ((List)strippedParagraphs.elem).$colon$colon(paragraph);
            } else {
                Paragraph trailingParagraph;
                Paragraph paragraph = trailingParagraph = this.apply((List)curLines.elem);
                strippedParagraphs.elem = ((List)strippedParagraphs.elem).$colon$colon(paragraph);
            }
        }
        return ((List)((List)strippedParagraphs.elem).reverse()).$plus$plus(paragraphIterator, List$.MODULE$.canBuildFrom());
    }

    public Paragraph apply(List<Line> lines, Box boundary) {
        return new Paragraph(lines, boundary);
    }

    public Option<Tuple2<List<Line>, Box>> unapply(Paragraph x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple2<List<Line>, Box>>(new Tuple2<List<Line>, Box>(x$0.lines(), x$0.boundary()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$convertToNormalizedString$4(char x$1) {
        return Character.isLetter(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSpans$2(int start$1, Line x$6) {
        return x$6.lineNumber() < start$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeSpans$3(int end$1, Line x$9) {
        return x$9.lineNumber() <= end$1;
    }

    public static final /* synthetic */ void $anonfun$removeSpans$1(ObjectRef curLines$1, ObjectRef curParagraph$1, ObjectRef strippedParagraphs$1, Iterator paragraphIterator$1, TextSpan x0$1) {
        TextSpan textSpan = x0$1;
        if (textSpan != null) {
            int start = textSpan.start();
            int end = textSpan.end();
            while (((List)curLines$1.elem).isEmpty() || ((Paragraph)curParagraph$1.elem).lines().last().lineNumber() < start) {
                if (((List)curLines$1.elem).nonEmpty()) {
                    if (((Line)((List)curLines$1.elem).head()).lineNumber() == ((Paragraph)curParagraph$1.elem).startLineNumber()) {
                        Paragraph paragraph = (Paragraph)curParagraph$1.elem;
                        strippedParagraphs$1.elem = ((List)strippedParagraphs$1.elem).$colon$colon(paragraph);
                    } else {
                        Paragraph trailingParagraph;
                        Paragraph paragraph = trailingParagraph = MODULE$.apply((List)curLines$1.elem);
                        strippedParagraphs$1.elem = ((List)strippedParagraphs$1.elem).$colon$colon(paragraph);
                    }
                }
                curParagraph$1.elem = (Paragraph)paragraphIterator$1.next();
                curLines$1.elem = ((Paragraph)curParagraph$1.elem).lines();
            }
            Tuple2 tuple2 = ((List)curLines$1.elem).span((Function1<Line, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(Paragraph$.$anonfun$removeSpans$2(start, x$6)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List linesBefore = tuple2._1();
            List linesAfter = tuple2._2();
            Tuple2 tuple22 = new Tuple2(linesBefore, linesAfter);
            List<Line> linesBefore2 = tuple22._1();
            List linesAfter2 = tuple22._2();
            if (linesBefore2.nonEmpty()) {
                Paragraph paragraph = MODULE$.apply(linesBefore2);
                strippedParagraphs$1.elem = ((List)strippedParagraphs$1.elem).$colon$colon(paragraph);
            }
            curLines$1.elem = linesAfter2;
            while (((Paragraph)curParagraph$1.elem).lines().last().lineNumber() < end) {
                curParagraph$1.elem = (Paragraph)paragraphIterator$1.next();
                curLines$1.elem = ((Paragraph)curParagraph$1.elem).lines();
            }
            curLines$1.elem = ((List)curLines$1.elem).dropWhile((Function1<Line, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(Paragraph$.$anonfun$removeSpans$3(end, x$9)));
            return;
        }
        throw new MatchError(textSpan);
    }

    private Paragraph$() {
        MODULE$ = this;
        this.unprintableRegex = new StringOps(Predef$.MODULE$.augmentString("[\\p{Cc}\\p{Cf}\\p{Co}\\p{Cn}]")).r();
    }
}

