/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.ClassifiedText;
import org.allenai.pdffigures2.DocumentLayout;
import org.allenai.pdffigures2.PageWithClassifiedText;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.Paragraph$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ParagraphRebuilder$ {
    public static ParagraphRebuilder$ MODULE$;
    private final int MaxIndentSize;
    private final int MinIndentSize;
    private final int MinLineContinuationXDist;
    private final double MinLineContinuationVerticalOverlap;
    private final double TextAlignmentTolerance;
    private final double LineSpacingPadding;

    static {
        new ParagraphRebuilder$();
    }

    private int MaxIndentSize() {
        return this.MaxIndentSize;
    }

    private int MinIndentSize() {
        return this.MinIndentSize;
    }

    private int MinLineContinuationXDist() {
        return this.MinLineContinuationXDist;
    }

    private double MinLineContinuationVerticalOverlap() {
        return this.MinLineContinuationVerticalOverlap;
    }

    private double TextAlignmentTolerance() {
        return this.TextAlignmentTolerance;
    }

    private double LineSpacingPadding() {
        return this.LineSpacingPadding;
    }

    public PageWithClassifiedText rebuildParagraphs(PageWithClassifiedText page, DocumentLayout documentLayout) {
        List<Paragraph> newParagraphs;
        List<Paragraph> x$1 = newParagraphs = this.mergeSortedParagraphs(page.paragraphs(), documentLayout.medianLineSpacing());
        int x$2 = page.copy$default$1();
        ClassifiedText x$3 = page.copy$default$3();
        return page.copy(x$2, x$1, x$3);
    }

    public List<Paragraph> mergeParagraphs(Seq<Paragraph> paragraphs, double medianLineSpacing) {
        return this.mergeSortedParagraphs((Seq)paragraphs.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), medianLineSpacing);
    }

    private List<Paragraph> mergeSortedParagraphs(Seq<Paragraph> paragraphs, double medianLineSpacing) {
        if (paragraphs.isEmpty()) {
            return Nil$.MODULE$;
        }
        ObjectRef<Nil$> newParagraphs = ObjectRef.create(Nil$.MODULE$);
        ObjectRef<Paragraph> onParagraph = ObjectRef.create((Paragraph)paragraphs.head());
        ((IterableLike)paragraphs.tail()).foreach((Function1<Paragraph, Object> & java.io.Serializable & Serializable)paragraph -> {
            ParagraphRebuilder$.$anonfun$mergeSortedParagraphs$1(onParagraph, medianLineSpacing, newParagraphs, paragraph);
            return BoxedUnit.UNIT;
        });
        return ((List)newParagraphs.elem).$colon$plus((Paragraph)onParagraph.elem, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$mergeSortedParagraphs$1(ObjectRef onParagraph$1, double medianLineSpacing$1, ObjectRef newParagraphs$1, Paragraph paragraph) {
        boolean mergeParagraph;
        boolean continuesReadingOrder = ((Paragraph)onParagraph$1.elem).span().end() == paragraph.span().start() - 1;
        Box curBB = ((Paragraph)onParagraph$1.elem).boundary();
        double yDist = paragraph.boundary().y1() - curBB.y2();
        boolean belowLine = yDist > (double)-4 && yDist < medianLineSpacing$1 + MODULE$.LineSpacingPadding() && curBB.horizontallyAligned(paragraph.boundary(), 0.0);
        boolean leftAligned = Math.abs(curBB.x1() - paragraph.boundary().x1()) < MODULE$.TextAlignmentTolerance();
        boolean rightAligned = Math.abs(curBB.x2() - paragraph.boundary().x2()) < MODULE$.TextAlignmentTolerance();
        double indent = paragraph.lines().head().boundary().x1() - curBB.x1();
        boolean indented = indent > (double)MODULE$.MinIndentSize() && indent < (double)MODULE$.MaxIndentSize();
        boolean prevLineIndented = -indent > (double)MODULE$.MinIndentSize() && -indent < (double)MODULE$.MaxIndentSize();
        double xDist = paragraph.boundary().x1() - curBB.x2();
        double verticalOverlap = Math.min(curBB.y2(), paragraph.boundary().y2()) - Math.max(curBB.y1(), paragraph.boundary().y1());
        boolean verticallyAligned = xDist < (double)MODULE$.MinLineContinuationXDist() && verticalOverlap / Math.min(paragraph.boundary().height(), curBB.height()) > MODULE$.MinLineContinuationVerticalOverlap();
        boolean bl = mergeParagraph = continuesReadingOrder && (verticallyAligned || belowLine && (!indented && leftAligned || prevLineIndented && rightAligned));
        if (mergeParagraph) {
            onParagraph$1.elem = Paragraph$.MODULE$.apply(((Paragraph)onParagraph$1.elem).lines().$plus$plus(paragraph.lines(), List$.MODULE$.canBuildFrom()));
            return;
        }
        newParagraphs$1.elem = ((List)newParagraphs$1.elem).$colon$plus((Paragraph)onParagraph$1.elem, List$.MODULE$.canBuildFrom());
        onParagraph$1.elem = paragraph;
    }

    private ParagraphRebuilder$() {
        MODULE$ = this;
        this.MaxIndentSize = 20;
        this.MinIndentSize = 3;
        this.MinLineContinuationXDist = 15;
        this.MinLineContinuationVerticalOverlap = 0.8;
        this.TextAlignmentTolerance = 2.0;
        this.LineSpacingPadding = 0.5;
    }
}

