/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.CaptionParagraph;
import org.allenai.pdffigures2.DocumentLayout;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.PageWithBodyText;
import org.allenai.pdffigures2.PageWithCaptions;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.RegionClassifier;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class RegionClassifier$
implements Logging {
    public static RegionClassifier$ MODULE$;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new RegionClassifier$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    private List<Paragraph> splitAroundCaptions(Paragraph paragraph, Seq<CaptionParagraph> captions, int page) {
        Seq intersects = (Seq)captions.filter((Function1<CaptionParagraph, Object> & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean(RegionClassifier$.$anonfun$splitAroundCaptions$1(paragraph, c)));
        if (intersects.nonEmpty()) {
            Seq<Box> captionBoundaries = intersects.map((Function1<CaptionParagraph, Box> & Serializable & scala.Serializable)x$3 -> x$3.boundary(), Seq$.MODULE$.canBuildFrom());
            if (!paragraph.lines().forall((Function1<Line, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(RegionClassifier$.$anonfun$splitAroundCaptions$3(captionBoundaries, x$4)))) {
                this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Page: ").append(page).append(", Splitting paragraphs that overlap caption").toString());
                List splitParagraphs = Nil$.MODULE$;
                List newLines = new $colon$colon<Nothing$>((Nothing$)((Object)paragraph.lines().head()), Nil$.MODULE$);
                List oldLines = (List)paragraph.lines().tail();
                Box newBox = paragraph.lines().head().boundary();
                int nSplits = 0;
                while (oldLines.nonEmpty()) {
                    Line next = (Line)oldLines.head();
                    Box combinedBox = next.boundary().container(newBox);
                    if (combinedBox.intersectsAny(captionBoundaries, combinedBox.intersectsAny$default$2())) {
                        Paragraph paragraph2 = new Paragraph((List<Line>)newLines.reverse(), newBox);
                        splitParagraphs = splitParagraphs.$colon$colon(paragraph2);
                        ++nSplits;
                        newLines = new $colon$colon<Nothing$>((Nothing$)((Object)next), Nil$.MODULE$);
                        newBox = next.boundary();
                    } else {
                        newBox = combinedBox;
                        Line line = next;
                        newLines = newLines.$colon$colon((Nothing$)((Object)line));
                    }
                    oldLines = (List)oldLines.tail();
                }
                Paragraph paragraph3 = new Paragraph((List<Line>)newLines.reverse(), newBox);
                return splitParagraphs.$colon$colon(paragraph3);
            }
            this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Page: ").append(page).append(", Paragraph overlaps caption, but was unable to split it").toString());
            return new $colon$colon<Nothing$>((Nothing$)((Object)paragraph), Nil$.MODULE$);
        }
        return new $colon$colon<Nothing$>((Nothing$)((Object)paragraph), Nil$.MODULE$);
    }

    public PageWithBodyText classifyRegions(PageWithCaptions page, DocumentLayout layout) {
        Seq<Box> graphics = page.graphics();
        ObjectRef<Nil$> bodyText = ObjectRef.create(Nil$.MODULE$);
        ObjectRef<Nil$> otherText = ObjectRef.create(Nil$.MODULE$);
        Seq<Paragraph> paragraphs = page.paragraphs();
        Seq separatedParagraphs = paragraphs.flatMap((Function1<Paragraph, List> & Serializable & scala.Serializable)p -> MODULE$.splitAroundCaptions((Paragraph)p, page.captions(), page.pageNumber()), Seq$.MODULE$.canBuildFrom());
        Seq classifierSieve = new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.GraphicOverlaps(page.graphics())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.VerticalText()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.Spacing(layout.standardFontSize(), layout.averageWordSpacing())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.LineWidth(layout.standardWidthBucketed())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.SmallFont(layout.standardFontSize())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.IsTitle(layout)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new RegionClassifier.Margins(layout.trustLeftMargin(), layout.leftMargins())), Nil$.MODULE$)))))));
        separatedParagraphs.foreach((Function1<Paragraph, Object> & Serializable & scala.Serializable)paragraph -> {
            RegionClassifier$.$anonfun$classifyRegions$2(classifierSieve, bodyText, otherText, paragraph);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = graphics.partition((Function1<Box, Object> & Serializable & scala.Serializable)graphicRegion -> BoxesRunTime.boxToBoolean(RegionClassifier$.$anonfun$classifyRegions$4(page, paragraphs, graphicRegion)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq figuresBoundingBoxGraphics = (Seq)tuple2._1();
        Seq rest = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(figuresBoundingBoxGraphics, rest);
        Seq figuresBoundingBoxGraphics2 = tuple22._1();
        Seq rest2 = tuple22._2();
        Seq figureBoundingBoxes = figuresBoundingBoxGraphics2.flatMap((Function1<Box, Seq> & Serializable & scala.Serializable)box -> {
            double x$1 = box.x1();
            double x$2 = box.copy$default$1();
            double x$3 = box.copy$default$2();
            double x$4 = box.copy$default$4();
            double x$5 = box.y1();
            double x$6 = box.copy$default$1();
            double x$7 = box.copy$default$2();
            double x$8 = box.copy$default$3();
            double x$9 = box.y2();
            double x$10 = box.copy$default$1();
            double x$11 = box.copy$default$3();
            double x$12 = box.copy$default$4();
            return new $colon$colon<Nothing$>((Nothing$)((Object)box.copy(x$2, x$3, x$1, x$4)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)box.copy(box.x2(), box.copy$default$2(), box.copy$default$3(), box.copy$default$4())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)box.copy(x$6, x$7, x$8, x$5)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)box.copy(x$10, x$9, x$11, x$12)), Nil$.MODULE$))));
        }, Seq$.MODULE$.canBuildFrom());
        Seq croppedFigureGraphics = figuresBoundingBoxGraphics2.map((Function1<Box, Box> & Serializable & scala.Serializable)box -> {
            double x$13 = box.x1() + (double)3;
            double x$14 = box.x2() - (double)3;
            double x$15 = box.y1() + (double)3;
            double x$16 = box.y2() - (double)3;
            return box.copy(x$13, x$15, x$14, x$16);
        }, Seq$.MODULE$.canBuildFrom());
        return new PageWithBodyText(page.pageNumber(), page.classifiedText(), page.captions(), rest2.$plus$plus(croppedFigureGraphics, Seq$.MODULE$.canBuildFrom()), page.nonFigureGraphics().$plus$plus(figureBoundingBoxes, Seq$.MODULE$.canBuildFrom()), (List)bodyText.elem, (List)otherText.elem);
    }

    private final void logger$lzycompute$1() {
        RegionClassifier$ regionClassifier$ = this;
        synchronized (regionClassifier$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        RegionClassifier$ regionClassifier$ = this;
        synchronized (regionClassifier$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$splitAroundCaptions$1(Paragraph paragraph$1, CaptionParagraph c) {
        return paragraph$1.boundary().intersects(c.boundary(), -2.0);
    }

    public static final /* synthetic */ boolean $anonfun$splitAroundCaptions$3(Seq captionBoundaries$1, Line x$4) {
        return x$4.boundary().intersectsAny(captionBoundaries$1, x$4.boundary().intersectsAny$default$2());
    }

    public static final /* synthetic */ void $anonfun$classifyRegions$2(Seq classifierSieve$1, ObjectRef bodyText$1, ObjectRef otherText$1, Paragraph paragraph) {
        boolean isBodyText;
        Option classification = ((TraversableLike)classifierSieve$1.view().flatMap((Function1<RegionClassifier.TextClassifier, Iterable> & Serializable & scala.Serializable)x$8 -> Option$.MODULE$.option2Iterable(x$8.isBodyText(paragraph)), SeqView$.MODULE$.canBuildFrom())).headOption();
        boolean bl = isBodyText = classification.isEmpty() || BoxesRunTime.unboxToBoolean(classification.get());
        if (isBodyText) {
            Paragraph paragraph2 = paragraph;
            bodyText$1.elem = ((List)bodyText$1.elem).$colon$colon(paragraph2);
            return;
        }
        Paragraph paragraph3 = paragraph;
        otherText$1.elem = ((List)otherText$1.elem).$colon$colon(paragraph3);
    }

    public static final /* synthetic */ boolean $anonfun$classifyRegions$5(Box graphicRegion$1, CaptionParagraph c) {
        return graphicRegion$1.contains(c.boundary(), graphicRegion$1.contains$default$2()) && graphicRegion$1.intersectArea(c.boundary()) / graphicRegion$1.area() < 0.5;
    }

    public static final /* synthetic */ boolean $anonfun$classifyRegions$6(Box graphicRegion$1, Paragraph p) {
        return !graphicRegion$1.contains(p.boundary(), graphicRegion$1.contains$default$2()) && p.boundary().intersects(graphicRegion$1, p.boundary().intersects$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$classifyRegions$4(PageWithCaptions page$2, Seq paragraphs$1, Box graphicRegion) {
        return page$2.captions().exists((Function1<CaptionParagraph, Object> & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean(RegionClassifier$.$anonfun$classifyRegions$5(graphicRegion, c))) && !paragraphs$1.exists((Function1<Paragraph, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(RegionClassifier$.$anonfun$classifyRegions$6(graphicRegion, p)));
    }

    private RegionClassifier$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

