/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.pdffigures2;

import java.io.Serializable;
import org.allenai.pdffigures2.Box;
import org.allenai.pdffigures2.ClassifiedPage;
import org.allenai.pdffigures2.ClassifiedText;
import org.allenai.pdffigures2.DocumentLayout;
import org.allenai.pdffigures2.Line;
import org.allenai.pdffigures2.Logging;
import org.allenai.pdffigures2.Logging$logger$;
import org.allenai.pdffigures2.Logging$loggerConfig$;
import org.allenai.pdffigures2.PageWithClassifiedText;
import org.allenai.pdffigures2.Paragraph;
import org.allenai.pdffigures2.Paragraph$;
import org.allenai.pdffigures2.RegexWithTimeout;
import org.allenai.pdffigures2.SectionTitleExtractor;
import org.allenai.pdffigures2.SectionTitleExtractor$SectionTitle$;
import org.allenai.pdffigures2.TextSpan;
import org.allenai.pdffigures2.Word;
import org.apache.pdfbox.text.TextPosition;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.Tuple3Zipped$;
import scala.runtime.Tuple3Zipped$Ops$;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.util.matching.Regex;

public final class SectionTitleExtractor$
implements Logging {
    public static SectionTitleExtractor$ MODULE$;
    private final double org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance;
    private final int MaxNonCapitalizedLargeWords;
    private final double PruneNonPrefixedSections;
    private final double MinSharedMargin;
    private final Regex NumberRegex;
    private final Regex LetterNumberRegex;
    private final Regex RomanNumeralsRegex;
    private final Regex AppendixRegex;
    private final Regex ListRegex;
    private final Seq<Regex> BlackList;
    private final Regex allowNonPrefiex;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new SectionTitleExtractor$();
    }

    @Override
    public Logger internalLogger() {
        return this.internalLogger;
    }

    @Override
    public Logging$logger$ logger() {
        if (this.logger$module == null) {
            this.logger$lzycompute$1();
        }
        return this.logger$module;
    }

    @Override
    public Logging$loggerConfig$ loggerConfig() {
        if (this.loggerConfig$module == null) {
            this.loggerConfig$lzycompute$1();
        }
        return this.loggerConfig$module;
    }

    @Override
    public void org$allenai$pdffigures2$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public double org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance() {
        return this.org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance;
    }

    private int MaxNonCapitalizedLargeWords() {
        return this.MaxNonCapitalizedLargeWords;
    }

    private double PruneNonPrefixedSections() {
        return this.PruneNonPrefixedSections;
    }

    private double MinSharedMargin() {
        return this.MinSharedMargin;
    }

    private Regex NumberRegex() {
        return this.NumberRegex;
    }

    private Regex LetterNumberRegex() {
        return this.LetterNumberRegex;
    }

    private Regex RomanNumeralsRegex() {
        return this.RomanNumeralsRegex;
    }

    private Regex AppendixRegex() {
        return this.AppendixRegex;
    }

    public boolean isPrefixed(Line line) {
        if (line.words().size() == 1) {
            return false;
        }
        String firstWordText = line.words().head().text();
        return RegexWithTimeout.matcher(this.NumberRegex().pattern(), firstWordText).matches() || RegexWithTimeout.matcher(this.RomanNumeralsRegex().pattern(), firstWordText).matches() || RegexWithTimeout.matcher(this.LetterNumberRegex().pattern(), firstWordText).matches() || RegexWithTimeout.matcher(this.AppendixRegex().pattern(), firstWordText).matches();
    }

    public boolean isTitleStartText(Line line) {
        String text = line.text();
        return text.length() > 1 && (Character.isUpperCase(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0)) || this.isPrefixed(line));
    }

    public boolean isAlignedOrCentered(Box region, DocumentLayout layout) {
        boolean bl;
        boolean isCenter;
        boolean bl2;
        if (layout.standardWidthBucketed().isDefined()) {
            double x1 = region.xCenter() - BoxesRunTime.unboxToDouble(layout.standardWidthBucketed().get()) / this.org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance();
            bl2 = BoxesRunTime.unboxToDouble(layout.leftMargins().getOrElse(BoxesRunTime.boxToInteger((int)Math.ceil(x1)), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble(layout.leftMargins().getOrElse(BoxesRunTime.boxToInteger((int)Math.floor(x1)), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0)) > this.MinSharedMargin();
        } else {
            bl2 = isCenter = false;
        }
        if (layout.trustLeftMargin()) {
            double x1 = region.x1();
            bl = BoxesRunTime.unboxToDouble(layout.leftMargins().getOrElse(BoxesRunTime.boxToInteger((int)Math.ceil(x1)), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble(layout.leftMargins().getOrElse(BoxesRunTime.boxToInteger((int)Math.floor(x1)), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0)) > this.MinSharedMargin();
        } else {
            bl = false;
        }
        boolean leftAligned = bl;
        return leftAligned || isCenter;
    }

    public boolean isTitleStyle(Line line, DocumentLayout layout) {
        int numChars = BoxesRunTime.unboxToInt(((TraversableOnce)line.words().map((Function1<Word, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(SectionTitleExtractor$.$anonfun$isTitleStyle$1(x$1)), List$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
        int nonStandardFont = ((TraversableOnce)line.words().flatMap((Function1<Word, List> & Serializable & scala.Serializable)x$2 -> x$2.positions(), List$.MODULE$.canBuildFrom())).count((Function1<TextPosition, Object> & Serializable & scala.Serializable)pos -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isTitleStyle$3(layout, pos)));
        boolean trustFontSize = layout.standardFontSize().nonEmpty() && BoxesRunTime.unboxToDouble(layout.standardFontSize().get()) < (double)20;
        boolean smallFont = trustFontSize && ((TraversableOnce)line.words().flatMap((Function1<Word, List> & Serializable & scala.Serializable)x$3 -> x$3.positions(), List$.MODULE$.canBuildFrom())).count((Function1<TextPosition, Object> & Serializable & scala.Serializable)pos -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isTitleStyle$6(layout, pos))) > numChars / 2;
        List asciiChars = ((List)((TraversableLike)line.words().filter((Function1<Word, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isTitleStyle$7(x$4)))).filter((Function1<Word, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isTitleStyle$8(x$5)))).flatMap((Function1<Word, List> & Serializable & scala.Serializable)x$6 -> x$6.positions(), List$.MODULE$.canBuildFrom());
        boolean sameFont = asciiChars.nonEmpty() && ((LinearSeqOptimized)asciiChars.tail()).forall((Function1<TextPosition, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isTitleStyle$11(asciiChars, x$7)));
        boolean isAllCaps = !new StringOps(Predef$.MODULE$.augmentString(line.text())).exists((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isTitleStyle$12(BoxesRunTime.unboxToChar(x$1))));
        return sameFont && (!smallFont && nonStandardFont > numChars / 2 || isAllCaps);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNormalText(TextPosition pos) {
        if (pos.getUnicode().length() != 1) return false;
        if (BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(pos.getUnicode())).head()) < '\u0080') return true;
        String string = pos.getUnicode();
        String string2 = "\ufb01";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private boolean isEquation(Line line) {
        int nonStandardChar = ((TraversableOnce)line.words().flatMap((Function1<Word, List> & Serializable & scala.Serializable)x$8 -> x$8.positions(), List$.MODULE$.canBuildFrom())).count((Function1<TextPosition, Object> & Serializable & scala.Serializable)position -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isEquation$2(position)));
        int numChars = BoxesRunTime.unboxToInt(((TraversableOnce)line.words().map((Function1<Word, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger(SectionTitleExtractor$.$anonfun$isEquation$3(x$9)), List$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
        return !this.isPrefixed(line) && nonStandardChar > 3 && (double)nonStandardChar > (double)numChars * 0.4;
    }

    private Regex ListRegex() {
        return this.ListRegex;
    }

    public boolean isList(Line line) {
        return line.words().size() > 1 && Character.isUpperCase(BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(line.words().head().text())).head())) && this.ListRegex().findFirstIn(((Word)((IterableLike)line.words().tail()).head()).text()).nonEmpty();
    }

    private Seq<Regex> BlackList() {
        return this.BlackList;
    }

    private boolean isCompleteTitle(SectionTitleExtractor.SectionTitle sectionTitle) {
        String text = sectionTitle.toParagraph().text();
        if (this.BlackList().exists((Function1<Regex, Object> & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isCompleteTitle$1(text, r)))) {
            this.logger().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Blacklist removed ").append(text).append(" as a header").toString());
            return false;
        }
        if (sectionTitle.lines().size() > 3) {
            return false;
        }
        if (sectionTitle.isPrefixed()) {
            return true;
        }
        List words = sectionTitle.lines().flatMap((Function1<Line, List> & Serializable & scala.Serializable)x$10 -> x$10.words(), List$.MODULE$.canBuildFrom());
        List largeNormalWords = (List)((TraversableLike)words.filter((Function1<Word, Object> & Serializable & scala.Serializable)w -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isCompleteTitle$4(w)))).filter((Function1<Word, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isCompleteTitle$5(x$11)));
        if (!sectionTitle.isPrefixed() && largeNormalWords.size() > 3) {
            int numNonCapitalized = largeNormalWords.count((Function1<Word, Object> & Serializable & scala.Serializable)w -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$isCompleteTitle$7(w)));
            return numNonCapitalized < this.MaxNonCapitalizedLargeWords();
        }
        return true;
    }

    private boolean isBeneath(Box upper, Box lower) {
        return upper.horizontallyAligned(lower, 50.0) && upper.y2() - (double)5 < lower.y2();
    }

    private boolean isFarFromPreviousLine(Line line, Option<Line> prevLine, DocumentLayout layout) {
        if (prevLine.isDefined()) {
            boolean largeVerticalSpace = prevLine.get().boundary().height() > (double)40 || line.boundary().y1() - prevLine.get().boundary().y2() > layout.medianLineSpacing() + 0.1;
            return largeVerticalSpace;
        }
        return true;
    }

    private boolean isLineBeginningSection(Line line, SectionTitleExtractor.SectionTitle current, DocumentLayout layout) {
        double yDist = line.boundary().y1() - current.boundary().y2();
        boolean close = yDist < layout.medianLineSpacing();
        boolean rightAndLeftAligned = Math.abs(current.boundary().x1() - line.boundary().x1()) < this.org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance() && Math.abs(current.boundary().x2() - line.boundary().x2()) < this.org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance();
        boolean largeFont = current.fontSize() > BoxesRunTime.unboxToDouble(layout.standardFontSize().getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> layout.averageFontSize() + 2.0));
        return !(line.words().size() <= 3 && !Character.isUpperCase(BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(line.words().head().text())).head())) || BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(current.lines().last().text())).last()) == '-' || !largeFont && close && rightAndLeftAligned);
    }

    public Seq<PageWithClassifiedText> stripSectionTitlesFromTextPage(Seq<ClassifiedPage> pages, DocumentLayout layout) {
        Tuple2 tuple2 = this.stripSectionTitlesFromSortedParagraphs(pages.map((Function1<ClassifiedPage, Seq> & Serializable & scala.Serializable)x$17 -> x$17.paragraphs(), Seq$.MODULE$.canBuildFrom()), layout).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq strippedTextPages = (Seq)tuple2._1();
        Seq sectionHeaders = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(strippedTextPages, sectionHeaders);
        Seq strippedTextPages2 = tuple22._1();
        Seq sectionHeaders2 = tuple22._2();
        return Tuple3Zipped$.MODULE$.map$extension(Tuple3Zipped$Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3<Seq<ClassifiedPage>, Seq, Seq>(pages, strippedTextPages2, sectionHeaders2)), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms()), (Function3<ClassifiedPage, Seq, Seq, PageWithClassifiedText> & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3<ClassifiedPage, Seq, Seq> tuple3 = new Tuple3<ClassifiedPage, Seq, Seq>((ClassifiedPage)x0$1, (Seq)x1$1, (Seq)x2$1);
            if (tuple3 != null) {
                ClassifiedPage page = tuple3._1();
                Seq strippedText = tuple3._2();
                Seq pageSectionHeaders = tuple3._3();
                ClassifiedText qual$1 = page.classifiedText();
                Seq x$1 = pageSectionHeaders;
                Seq<Paragraph> x$2 = qual$1.copy$default$1();
                Seq<Paragraph> x$3 = qual$1.copy$default$2();
                Seq<Paragraph> x$4 = qual$1.copy$default$3();
                return new PageWithClassifiedText(page.pageNumber(), strippedText.toList(), qual$1.copy(x$2, x$3, x$4, x$1));
            }
            throw new MatchError(tuple3);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Seq<Paragraph>, Seq<Paragraph>>> stripSectionTitles(Seq<Seq<Paragraph>> pages, DocumentLayout layout) {
        return this.stripSectionTitlesFromSortedParagraphs(pages.map((Function1<Seq, Seq> & Serializable & scala.Serializable)x$19 -> (Seq)x$19.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), Seq$.MODULE$.canBuildFrom()), layout);
    }

    private Regex allowNonPrefiex() {
        return this.allowNonPrefiex;
    }

    private Seq<Seq<SectionTitleExtractor.SectionTitle>> cleanPrefixedSections(Seq<Seq<SectionTitleExtractor.SectionTitle>> titles) {
        int numSections = BoxesRunTime.unboxToInt(((TraversableOnce)titles.map((Function1<Seq, Object> & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger(x$20.size()), Seq$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
        if (numSections > 3) {
            int numPrefixedSections = ((TraversableOnce)titles.flatten(Predef$.MODULE$.$conforms())).count((Function1<SectionTitleExtractor.SectionTitle, Object> & Serializable & scala.Serializable)title -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$cleanPrefixedSections$2(title)));
            double percentPrefixed = (double)numPrefixedSections / (double)numSections;
            if (percentPrefixed > this.PruneNonPrefixedSections()) {
                this.logger().debug((Function0<String> & Serializable & scala.Serializable)() -> "Number section titles detected, pruning sections titles that were not numbered");
                return titles.map((Function1<Seq, Seq> & Serializable & scala.Serializable)pageTitles -> (Seq)pageTitles.filter((Function1<SectionTitleExtractor.SectionTitle, Object> & Serializable & scala.Serializable)title -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$cleanPrefixedSections$5(title))), Seq$.MODULE$.canBuildFrom());
            }
            return titles;
        }
        return titles;
    }

    private Seq<Tuple2<Seq<Paragraph>, Seq<Paragraph>>> stripSectionTitlesFromSortedParagraphs(Seq<Seq<Paragraph>> pages, DocumentLayout layout) {
        Seq<Seq<SectionTitleExtractor.SectionTitle>> sectionTitles = pages.map((Function1<Seq, List> & Serializable & scala.Serializable)sortedParagraphs -> {
            ObjectRef<Nil$> sectionTitles;
            block0: {
                Iterator lines2 = sortedParagraphs.iterator().flatMap((Function1<Paragraph, List> & Serializable & scala.Serializable)x$21 -> x$21.lines());
                sectionTitles = ObjectRef.create(Nil$.MODULE$);
                ObjectRef<None$> prevLine = ObjectRef.create(None$.MODULE$);
                ObjectRef<None$> onTitle = ObjectRef.create(None$.MODULE$);
                lines2.sliding(2, lines2.sliding$default$2()).filter((Function1<Seq, Object> & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.$anonfun$stripSectionTitlesFromSortedParagraphs$3(x$22))).foreach((Function1<Seq, Object> & Serializable & scala.Serializable)lines -> {
                    SectionTitleExtractor$.$anonfun$stripSectionTitlesFromSortedParagraphs$4(layout, onTitle, sectionTitles, prevLine, lines);
                    return BoxedUnit.UNIT;
                });
                if (!((Option)onTitle.elem).isDefined() || !MODULE$.isCompleteTitle((SectionTitleExtractor.SectionTitle)((Option)onTitle.elem).get())) break block0;
                sectionTitles.elem = ((TraversableOnce)Option$.MODULE$.option2Iterable((Option)onTitle.elem).$plus$plus((List)sectionTitles.elem, Iterable$.MODULE$.canBuildFrom())).toList();
            }
            return (List)sectionTitles.elem;
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Seq<SectionTitleExtractor.SectionTitle>> filteredSectionTitles = this.cleanPrefixedSections(sectionTitles);
        return ((TraversableLike)pages.zip(filteredSectionTitles, Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq paragraphs = (Seq)tuple2._1();
                Seq pageSectionTitles = (Seq)tuple2._2();
                Seq sectionTitleParagraphs = pageSectionTitles.map((Function1<SectionTitleExtractor.SectionTitle, Paragraph> & Serializable & scala.Serializable)x$23 -> x$23.toParagraph(), Seq$.MODULE$.canBuildFrom());
                Seq<Paragraph> strippedText = Paragraph$.MODULE$.removeSpans((Seq)((SeqLike)sectionTitleParagraphs.map((Function1<Paragraph, TextSpan> & Serializable & scala.Serializable)x$24 -> x$24.span(), Seq$.MODULE$.canBuildFrom())).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), (Seq)paragraphs.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
                return new Tuple2(strippedText, sectionTitleParagraphs);
            }
            throw new MatchError(tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final void logger$lzycompute$1() {
        SectionTitleExtractor$ sectionTitleExtractor$ = this;
        synchronized (sectionTitleExtractor$) {
            if (this.logger$module == null) {
                this.logger$module = new Logging$logger$(this);
            }
        }
    }

    private final void loggerConfig$lzycompute$1() {
        SectionTitleExtractor$ sectionTitleExtractor$ = this;
        synchronized (sectionTitleExtractor$) {
            if (this.loggerConfig$module == null) {
                this.loggerConfig$module = new Logging$loggerConfig$(this);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$isTitleStyle$1(Word x$1) {
        return x$1.positions().size();
    }

    public static final /* synthetic */ boolean $anonfun$isTitleStyle$3(DocumentLayout layout$1, TextPosition pos) {
        return BoxesRunTime.unboxToDouble(layout$1.fontCounts().getOrElse(pos.getFont(), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0)) < 0.1;
    }

    public static final /* synthetic */ boolean $anonfun$isTitleStyle$6(DocumentLayout layout$1, TextPosition pos) {
        return (double)pos.getFontSizeInPt() < BoxesRunTime.unboxToDouble(layout$1.standardFontSize().get()) - 1.0;
    }

    public static final /* synthetic */ boolean $anonfun$isTitleStyle$7(Word x$4) {
        return x$4.positions().size() > 2;
    }

    public static final /* synthetic */ boolean $anonfun$isTitleStyle$8(Word x$5) {
        return x$5.positions().forall((Function1<TextPosition, Object> & Serializable & scala.Serializable)pos -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.MODULE$.isNormalText(pos)));
    }

    public static final /* synthetic */ boolean $anonfun$isTitleStyle$11(List asciiChars$1, TextPosition x$7) {
        return x$7.getFont().equals(((TextPosition)asciiChars$1.head()).getFont());
    }

    public static final /* synthetic */ boolean $anonfun$isTitleStyle$12(char x$1) {
        return Character.isLowerCase(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$isEquation$2(TextPosition position) {
        return position.getUnicode().length() > 1 || !Character.isLetter(BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(position.getUnicode())).head())) || BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(position.getUnicode())).head()) > '\u0080';
    }

    public static final /* synthetic */ int $anonfun$isEquation$3(Word x$9) {
        return x$9.positions().size();
    }

    public static final /* synthetic */ boolean $anonfun$isCompleteTitle$1(String text$1, Regex r) {
        return r.findFirstIn(text$1).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isCompleteTitle$4(Word w) {
        return w.positions().size() > 3 && Character.isLetter(BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(w.text())).head()));
    }

    public static final /* synthetic */ boolean $anonfun$isCompleteTitle$5(Word x$11) {
        return x$11.positions().forall((Function1<TextPosition, Object> & Serializable & scala.Serializable)pos -> BoxesRunTime.boxToBoolean(SectionTitleExtractor$.MODULE$.isNormalText(pos)));
    }

    public static final /* synthetic */ boolean $anonfun$isCompleteTitle$7(Word w) {
        return !Character.isUpperCase(BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(w.positions().head().getUnicode())).head()));
    }

    public static final /* synthetic */ boolean $anonfun$cleanPrefixedSections$2(SectionTitleExtractor.SectionTitle title) {
        return MODULE$.isPrefixed(title.lines().head()) || MODULE$.allowNonPrefiex().pattern().matcher(title.toParagraph().text()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$cleanPrefixedSections$5(SectionTitleExtractor.SectionTitle title) {
        return MODULE$.isPrefixed(title.lines().head()) || MODULE$.allowNonPrefiex().findFirstMatchIn(title.toParagraph().text()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$stripSectionTitlesFromSortedParagraphs$3(Seq x$22) {
        return x$22.size() == 2;
    }

    public static final /* synthetic */ void $anonfun$stripSectionTitlesFromSortedParagraphs$4(DocumentLayout layout$3, ObjectRef onTitle$1, ObjectRef sectionTitles$1, ObjectRef prevLine$1, Seq lines) {
        Line curLine = (Line)lines.head();
        Box curLineBB = curLine.boundary();
        Line followingLine = (Line)lines.last();
        if (MODULE$.isTitleStyle(curLine, layout$3) && MODULE$.isBeneath(curLineBB, followingLine.boundary()) && !MODULE$.isList(curLine) && !MODULE$.isEquation(curLine)) {
            boolean addToTitle;
            SectionTitleExtractor.SectionTitle sectionTitle = SectionTitleExtractor$SectionTitle$.MODULE$.build(curLine);
            boolean bl = addToTitle = ((Option)onTitle$1.elem).isDefined() && ((SectionTitleExtractor.SectionTitle)((Option)onTitle$1.elem).get()).isMatch(sectionTitle);
            if (addToTitle) {
                onTitle$1.elem = new Some<SectionTitleExtractor.SectionTitle>(((SectionTitleExtractor.SectionTitle)((Option)onTitle$1.elem).get()).addLine(curLine));
            } else {
                boolean prevLineWasTitle = ((Option)onTitle$1.elem).isDefined();
                if (((Option)onTitle$1.elem).isDefined()) {
                    if (MODULE$.isCompleteTitle((SectionTitleExtractor.SectionTitle)((Option)onTitle$1.elem).get())) {
                        sectionTitles$1.elem = ((TraversableOnce)Option$.MODULE$.option2Iterable((Option)onTitle$1.elem).$plus$plus((List)sectionTitles$1.elem, Iterable$.MODULE$.canBuildFrom())).toList();
                    }
                    onTitle$1.elem = None$.MODULE$;
                }
                if (MODULE$.isTitleStartText(curLine) && (prevLineWasTitle || MODULE$.isFarFromPreviousLine(curLine, (Option)prevLine$1.elem, layout$3)) && MODULE$.isAlignedOrCentered(curLineBB, layout$3)) {
                    onTitle$1.elem = new Some<SectionTitleExtractor.SectionTitle>(sectionTitle);
                }
            }
        } else if (((Option)onTitle$1.elem).isDefined()) {
            if (MODULE$.isLineBeginningSection(curLine, (SectionTitleExtractor.SectionTitle)((Option)onTitle$1.elem).get(), layout$3) && MODULE$.isCompleteTitle((SectionTitleExtractor.SectionTitle)((Option)onTitle$1.elem).get())) {
                sectionTitles$1.elem = ((TraversableOnce)Option$.MODULE$.option2Iterable((Option)onTitle$1.elem).$plus$plus((List)sectionTitles$1.elem, Iterable$.MODULE$.canBuildFrom())).toList();
            }
            onTitle$1.elem = None$.MODULE$;
        }
        if (MODULE$.isBeneath(curLineBB, followingLine.boundary())) {
            prevLine$1.elem = new Some<Line>(curLine);
            return;
        }
        prevLine$1.elem = None$.MODULE$;
    }

    private SectionTitleExtractor$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.org$allenai$pdffigures2$SectionTitleExtractor$$TextAlignmentTolerance = 2.0;
        this.MaxNonCapitalizedLargeWords = 2;
        this.PruneNonPrefixedSections = 0.7;
        this.MinSharedMargin = 0.1;
        this.NumberRegex = new StringOps(Predef$.MODULE$.augmentString("^[1-9][0-9]*(.[1-9][0-9]*)*.?$")).r();
        this.LetterNumberRegex = new StringOps(Predef$.MODULE$.augmentString("^[A-Z](.|[1-9]*.?)$")).r();
        this.RomanNumeralsRegex = new StringOps(Predef$.MODULE$.augmentString("^[IVX]+.?$")).r();
        this.AppendixRegex = new StringOps(Predef$.MODULE$.augmentString("^(?i)appendix.?$")).r();
        this.ListRegex = new StringOps(Predef$.MODULE$.augmentString("^([1-9][0-9]*|[IVX]+)(.|:)?")).r();
        this.BlackList = new $colon$colon<Nothing$>((Nothing$)((Object)new StringOps(Predef$.MODULE$.augmentString("\\b[wW]e\\b")).r()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringOps(Predef$.MODULE$.augmentString("^Proceedings of")).r()), Nil$.MODULE$));
        this.allowNonPrefiex = new StringOps(Predef$.MODULE$.augmentString("(?i)^(references|acknowledge?ments?|bibliography)$")).r();
    }
}

