/*
 * Decompiled with CFR 0.152.
 */
package spray.json;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsFalse$;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsString$;
import spray.json.JsTrue$;
import spray.json.JsValue;
import spray.json.JsonParser$;
import spray.json.JsonParserSettings;
import spray.json.JsonParserSettings$;
import spray.json.ParserInput;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mx!\u0002\u001c8\u0011\u0003ad!\u0002 8\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005\"\u0002%\u0002\t\u0003I\u0005\"\u0002%\u0002\t\u0003\u0011f\u0001B-\u0002\u0001iC\u0001bZ\u0003\u0003\u0006\u0004%\t\u0001\u001b\u0005\tc\u0016\u0011\t\u0011)A\u0005S\"A!/\u0002BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005t\u000b\t\u0005\t\u0015!\u0003j\u0011\u00151U\u0001\"\u0001u\u000f\u001dI\u0018!!A\t\u0002i4q!W\u0001\u0002\u0002#\u00051\u0010C\u0003G\u0019\u0011\u0005q\u0010C\u0005\u0002\u00021\t\n\u0011\"\u0001\u0002\u0004!I\u0011\u0011\u0004\u0007\u0002\u0002\u0013%\u00111\u0004\u0005\n\u0003\u0003\t\u0011\u0013!C\u0001\u0003[1QAP\u001c\u0001\u0003cA\u0001BT\t\u0003\u0002\u0003\u0006Ia\u0014\u0005\t+F\u0011\t\u0011)A\u0005-\"1a)\u0005C\u0001\u0003gAaAR\t\u0005\u0002\u0005m\u0002\u0002CA #\u0001\u0006I!!\u0011\t\u0011\u0005\u001d\u0013\u0003)Q\u0005\u0003\u0013B!\"a\u0014\u0012\u0001\u0004\u0005\t\u0015)\u0003K\u0011\u001d\t\t&\u0005C\u0001\u0003'Bq!!\u0015\u0012\t\u0003\t)\u0006C\u0005\u0002bE\u0011\r\u0011\"\u0004\u0002d!A\u0011\u0011N\t!\u0002\u001b\t)\u0007C\u0004\u0002lE!I!!\u001c\t\u000f\u0005}\u0014\u0003\"\u0003\u0002\u0002\"9\u00111Q\t\u0005\n\u0005\u0005\u0005bBAC#\u0011%\u0011\u0011\u0011\u0005\b\u0003\u000f\u000bB\u0011BAE\u0011\u001d\ti)\u0005C\u0005\u0003\u001fCq!a%\u0012\t\u0013\t)\nC\u0004\u0002\u0018F!I!!&\t\u000f\u0005e\u0015\u0003\"\u0003\u0002\u0016\"9\u00111T\t\u0005\n\u0005U\u0005bBAO#\u0011%\u0011Q\u0013\u0005\b\u0003?\u000bB\u0011BAK\u0011\u001d\tY+\u0005C\u0005\u0003\u0003Cq!!,\u0012\t\u0013\t)\nC\u0004\u00020F!I!!!\t\u000f\u0005E\u0016\u0003\"\u0003\u0002\u0002\"9\u00111W\t\u0005\n\u0005U\u0005bBA\\#\u0011%\u0011\u0011\u0018\u0005\b\u0003g\u000bB\u0011BA`\u0011\u001d\t\u0019-\u0005C\u0005\u0003\u0003Cq!!2\u0012\t\u0013\t9\rC\u0004\u0002LF!I!!4\t\u000f\u0005E\u0017\u0003\"\u0003\u0002T\"I\u0011q]\t\u0012\u0002\u0013%\u0011\u0011\u001e\u0005\n\u0003[\f\u0012\u0013!C\u0005\u0003_\f!BS:p]B\u000b'o]3s\u0015\tA\u0014(\u0001\u0003kg>t'\"\u0001\u001e\u0002\u000bM\u0004(/Y=\u0004\u0001A\u0011Q(A\u0007\u0002o\tQ!j]8o!\u0006\u00148/\u001a:\u0014\u0005\u0005\u0001\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002y\u0005)\u0011\r\u001d9msR\u0011!*\u0014\t\u0003{-K!\u0001T\u001c\u0003\u000f)\u001bh+\u00197vK\")aj\u0001a\u0001\u001f\u0006)\u0011N\u001c9viB\u0011Q\bU\u0005\u0003#^\u00121\u0002U1sg\u0016\u0014\u0018J\u001c9viR\u0019!j\u0015+\t\u000b9#\u0001\u0019A(\t\u000bU#\u0001\u0019\u0001,\u0002\u0011M,G\u000f^5oON\u0004\"!P,\n\u0005a;$A\u0005&t_:\u0004\u0016M]:feN+G\u000f^5oON\u0014\u0001\u0003U1sg&tw-\u0012=dKB$\u0018n\u001c8\u0014\u0005\u0015Y\u0006C\u0001/e\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002aw\u00051AH]8pizJ\u0011aQ\u0005\u0003G\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002fM\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0003G\n\u000bqa];n[\u0006\u0014\u00180F\u0001j!\tQgN\u0004\u0002lYB\u0011aLQ\u0005\u0003[\n\u000ba\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011QNQ\u0001\tgVlW.\u0019:zA\u00051A-\u001a;bS2\fq\u0001Z3uC&d\u0007\u0005F\u0002vob\u0004\"A^\u0003\u000e\u0003\u0005AQa\u001a\u0006A\u0002%DqA\u001d\u0006\u0011\u0002\u0003\u0007\u0011.\u0001\tQCJ\u001c\u0018N\\4Fq\u000e,\u0007\u000f^5p]B\u0011a\u000fD\n\u0004\u0019\u0001c\bCA!~\u0013\tq(I\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001{\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0001\u0016\u0004S\u0006\u001d1FAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M!)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0006\u0002\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003mC:<'BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\u0007\u001f\nTWm\u0019;\u0016\u0005\u0005=\"f\u0001,\u0002\bM\u0011\u0011\u0003\u0011\u000b\u0007\u0003k\t9$!\u000f\u0011\u0005u\n\u0002\"\u0002(\u0015\u0001\u0004y\u0005bB+\u0015!\u0003\u0005\rA\u0016\u000b\u0005\u0003k\ti\u0004C\u0003O+\u0001\u0007q*\u0001\u0002tEB!\u0011qDA\"\u0013\u0011\t)%!\t\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0003)\u0019WO]:pe\u000eC\u0017M\u001d\t\u0004\u0003\u0006-\u0013bAA'\u0005\n!1\t[1s\u0003\u001dQ7OV1mk\u0016\fA\u0002]1sg\u0016T5OV1mk\u0016$\u0012A\u0013\u000b\u0004\u0015\u0006]\u0003bBA-5\u0001\u0007\u00111L\u0001\u0013C2dwn\u001e+sC&d\u0017N\\4J]B,H\u000fE\u0002B\u0003;J1!a\u0018C\u0005\u001d\u0011un\u001c7fC:\f1!R(J+\t\t)g\u0004\u0002\u0002hq\u0019\u0001a\u0000\u0000\u0002\t\u0015{\u0015\nI\u0001\u0006m\u0006dW/\u001a\u000b\u0005\u0003_\n)\bE\u0002B\u0003cJ1!a\u001dC\u0005\u0011)f.\u001b;\t\u000f\u0005]T\u00041\u0001\u0002z\u0005\u0001\"/Z7bS:Lgn\u001a(fgRLgn\u001a\t\u0004\u0003\u0006m\u0014bAA?\u0005\n\u0019\u0011J\u001c;\u0002\u000b\u0019\fGn]3\u0015\u0005\u0005m\u0013\u0001\u00028vY2\fA\u0001\u001e:vK\u00061qN\u00196fGR$B!a\u001c\u0002\f\"9\u0011qO\u0011A\u0002\u0005e\u0014!B1se\u0006LH\u0003BA8\u0003#Cq!a\u001e#\u0001\u0004\tI(\u0001\u0004ok6\u0014WM\u001d\u000b\u0003\u0003_\n1!\u001b8u\u0003\u00111'/Y2\u0002\u0007\u0015D\b/A\bp]\u0016|%/T8sK\u0012Kw-\u001b;t\u0003AQXM]8Pe6{'/\u001a#jO&$8\u000fK\u0002)\u0003G\u0003B!!*\u0002(6\u0011\u0011\u0011C\u0005\u0005\u0003S\u000b\tBA\u0004uC&d'/Z2\u0002\u000b\u0011Ku)\u0013+\u0002\rM$(/\u001b8h\u0003\u0011\u0019\u0007.\u0019:\u0002\u000f\u0015\u001c8-\u00199fI\u0006\u0011qo\u001d\u0015\u0004[\u0005\r\u0016AA2i)\u0011\tY&a/\t\u000f\u0005uf\u00061\u0001\u0002J\u0005\t1\r\u0006\u0003\u0002\\\u0005\u0005\u0007bBA__\u0001\u0007\u0011\u0011J\u0001\bC\u00124\u0018M\\2f\u0003!\t\u0007\u000f]3oIN\u0013E\u0003BA.\u0003\u0013Dq!!02\u0001\u0004\tI%A\u0004sKF,\u0018N]3\u0015\t\u0005=\u0014q\u001a\u0005\b\u0003{\u0013\u0004\u0019AA%\u0003\u00111\u0017-\u001b7\u0015\u0011\u0005U\u00171\\Ap\u0003G\u00042!QAl\u0013\r\tIN\u0011\u0002\b\u001d>$\b.\u001b8h\u0011\u0019\tin\ra\u0001S\u00061A/\u0019:hKRD\u0011\"!94!\u0003\u0005\r!!\u001f\u0002\r\r,(o]8s\u0011%\t)o\rI\u0001\u0002\u0004\tI%A\u0005feJ|'o\u00115be\u0006qa-Y5mI\u0011,g-Y;mi\u0012\u0012TCAAvU\u0011\tI(a\u0002\u0002\u001d\u0019\f\u0017\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001f\u0016\u0005\u0003\u0013\n9\u0001")
public class JsonParser {
    private final ParserInput input;
    private final JsonParserSettings settings;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;

    public static JsonParserSettings $lessinit$greater$default$2() {
        return JsonParser$.MODULE$.$lessinit$greater$default$2();
    }

    public static JsValue apply(ParserInput parserInput, JsonParserSettings jsonParserSettings) {
        return JsonParser$.MODULE$.apply(parserInput, jsonParserSettings);
    }

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public JsValue parseJsValue() {
        return this.parseJsValue(false);
    }

    public JsValue parseJsValue(boolean allowTrailingInput) {
        block0: {
            this.ws();
            this.value(this.settings.maxDepth());
            if (allowTrailingInput) break block0;
            this.require('\uffff');
        }
        return this.jsValue;
    }

    private final char EOI() {
        return '\uffff';
    }

    private void value(int remainingNesting) {
        if (remainingNesting == 0) {
            throw new ParsingException("JSON input nested too deeply", new StringBuilder(76).append("JSON input was nested more deeply than the configured limit of maxNesting = ").append(this.settings.maxDepth()).toString());
        }
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            case 'f': {
                this.simpleValue$1(this.false(), JsFalse$.MODULE$, mark);
                break;
            }
            case 'n': {
                this.simpleValue$1(this.null(), JsNull$.MODULE$, mark);
                break;
            }
            case 't': {
                this.simpleValue$1(this.true(), JsTrue$.MODULE$, mark);
                break;
            }
            case '{': {
                this.advance();
                this.object(remainingNesting);
                break;
            }
            case '[': {
                this.advance();
                this.array(remainingNesting);
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                break;
            }
            case '\"': {
                this.string();
                this.jsValue = this.sb.length() == 0 ? JsString$.MODULE$.empty() : new JsString(this.sb.toString());
                break;
            }
            default: {
                throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private void object(int remainingNesting) {
        JsObject jsObject;
        this.ws();
        if (this.cursorChar != '}') {
            Map map = this.members$1((Map)((Object)TreeMap$.MODULE$.empty((Ordering)Ordering$String$.MODULE$)), remainingNesting);
            this.require('}');
            jsObject = new JsObject(map);
        } else {
            this.advance();
            jsObject = JsObject$.MODULE$.empty();
        }
        this.jsValue = jsObject;
        this.ws();
    }

    private void array(int remainingNesting) {
        JsArray jsArray;
        this.ws();
        if (this.cursorChar != ']') {
            Builder list = scala.package$.MODULE$.Vector().newBuilder();
            this.values$1(remainingNesting, list);
            this.require(']');
            jsArray = new JsArray(list.result());
        } else {
            this.advance();
            jsArray = JsArray$.MODULE$.empty();
        }
        this.jsValue = jsArray;
        this.ws();
    }

    private void number() {
        JsNumber jsNumber;
        int start = this.input.cursor();
        char startChar = this.cursorChar;
        this.ch('-');
        this.int();
        this.frac();
        this.exp();
        int numberLength = this.input.cursor() - start;
        if (startChar == '0' && this.input.cursor() - start == 1) {
            jsNumber = JsNumber$.MODULE$.zero();
        } else if (numberLength <= this.settings.maxNumberCharacters()) {
            jsNumber = JsNumber$.MODULE$.apply(this.input.sliceCharArray(start, this.input.cursor()));
        } else {
            String numberSnippet = new String(this.input.sliceCharArray(start, package$.MODULE$.min(this.input.cursor(), start + 20)));
            throw new ParsingException("Number too long", new StringBuilder(158).append("The number starting with '").append(numberSnippet).append("' had ").append(numberLength).append(" characters which is more than the allowed limit maxNumberCharacters = ").append(this.settings.maxNumberCharacters()).append(". If this is legit input ").append("consider increasing the limit.").toString());
        }
        this.jsValue = jsNumber;
        this.ws();
    }

    private void int() {
        block0: {
            if (this.ch('0')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private void frac() {
        block0: {
            if (!this.ch('.')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private void exp() {
        block0: {
            if (!this.ch('e') && !this.ch('E')) break block0;
            boolean bl = this.ch('-') || this.ch('+');
            this.oneOrMoreDigits();
        }
    }

    private void oneOrMoreDigits() {
        if (!this.DIGIT()) {
            throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
        }
        this.zeroOrMoreDigits();
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        if (this.cursorChar != '\"') {
            throw this.fail("'\"'", this.fail$default$2(), this.fail$default$3());
        }
        this.cursorChar = this.input.nextUtf8Char();
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        boolean bl;
        if ((1L << this.cursorChar & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = this.appendSB(this.cursorChar);
        } else {
            char c = this.cursorChar;
            switch (c) {
                case '\"': 
                case '\uffff': {
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.escaped();
                    break;
                }
                default: {
                    if (c >= ' ' && this.appendSB(c)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean escaped() {
        boolean bl;
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                bl = this.appendSB(this.cursorChar);
                break;
            }
            case 'b': {
                bl = this.appendSB('\b');
                break;
            }
            case 'f': {
                bl = this.appendSB('\f');
                break;
            }
            case 'n': {
                bl = this.appendSB('\n');
                break;
            }
            case 'r': {
                bl = this.appendSB('\r');
                break;
            }
            case 't': {
                bl = this.appendSB('\t');
                break;
            }
            case 'u': {
                this.advance();
                bl = this.unicode$1();
                break;
            }
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail(new StringBuilder(2).append("'").append(c).append("'").toString(), this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        String string;
        ParserInput.Line line = this.input.getLine(cursor);
        if (line == null) {
            throw new MatchError(line);
        }
        int lineNr = line.lineNr();
        int col = line.column();
        String text = line.text();
        Tuple3<Integer, Integer, String> tuple3 = new Tuple3<Integer, Integer, String>(BoxesRunTime.boxToInteger(lineNr), BoxesRunTime.boxToInteger(col), text);
        Tuple3<Integer, Integer, String> tuple32 = tuple3;
        int lineNr2 = BoxesRunTime.unboxToInt(tuple32._1());
        int col2 = BoxesRunTime.unboxToInt(tuple32._2());
        String text2 = tuple32._3();
        if (errorChar != '\uffff') {
            String c2 = Character.isISOControl(errorChar) ? new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(errorChar)})) : ((Object)BoxesRunTime.boxToCharacter(errorChar)).toString();
            string = new StringBuilder(12).append("character '").append(c2).append("'").toString();
        } else {
            string = "end-of-input";
        }
        String unexpected = string;
        String string2 = target;
        String string3 = "'\uffff'";
        String expected = (string2 == null ? string3 != null : !string2.equals(string3)) ? target : "end-of-input";
        String summary = new StringBuilder(57).append("Unexpected ").append(unexpected).append(" at input index ").append(cursor).append(" (line ").append(lineNr2).append(", position ").append(col2).append("), expected ").append(expected).toString();
        String sanitizedText = new StringOps(Predef$.MODULE$.augmentString(text2)).map((Function1<Object, Object> & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter(JsonParser.$anonfun$fail$1(BoxesRunTime.unboxToChar(c))), Predef$.MODULE$.StringCanBuildFrom());
        String detail = new StringBuilder(4).append("\n").append(sanitizedText).append("\n").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(col2 - 1)).append("^\n").toString();
        throw new ParsingException(summary, detail);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(boolean matched, JsValue value, int mark$1) {
        if (!matched) {
            throw this.fail("JSON Value", mark$1, this.fail$default$3());
        }
        this.jsValue = value;
    }

    private final Map members$1(Map map, int remainingNesting$1) {
        Map<String, JsValue> nextMap;
        while (true) {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value(remainingNesting$1 - 1);
            nextMap = map.updated(key, this.jsValue);
            if (!this.ws(',')) break;
            map = nextMap;
        }
        return nextMap;
    }

    private final void values$1(int remainingNesting$2, Builder list$1) {
        do {
            this.value(remainingNesting$2 - 1);
            list$1.$plus$eq(this.jsValue);
        } while (this.ws(','));
    }

    private final int hexValue$1(char c) {
        int n;
        if ('0' <= c && c <= '9') {
            n = c - 48;
        } else if ('a' <= c && c <= 'f') {
            n = c - 87;
        } else if ('A' <= c && c <= 'F') {
            n = c - 55;
        } else {
            throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
        }
        return n;
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    public static final /* synthetic */ char $anonfun$fail$1(char c) {
        return Character.isISOControl(c) ? (char)'?' : (char)c;
    }

    public JsonParser(ParserInput input, JsonParserSettings settings) {
        this.input = input;
        this.settings = settings;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
    }

    public JsonParser(ParserInput input) {
        this(input, JsonParserSettings$.MODULE$.default());
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : new StringBuilder(1).append(summary).append(":").append(detail).toString()));
        }
    }
}

